
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQEasingCurve.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQEasingCurve_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QEasingCurve

//  Constructor QEasingCurve::QEasingCurve(QEasingCurve::Type type)


static void _init_ctor_QEasingCurve_2167 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type", true, "QEasingCurve::Linear");
  decl->add_arg<const qt_gsi::Converter<QEasingCurve::Type>::target_type & > (argspec_0);
  decl->set_return_new<QEasingCurve *> ();
}

static void _call_ctor_QEasingCurve_2167 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  tl::Heap heap;
  const qt_gsi::Converter<QEasingCurve::Type>::target_type & arg1 = args ? args.read<const qt_gsi::Converter<QEasingCurve::Type>::target_type & > () : (const qt_gsi::Converter<QEasingCurve::Type>::target_type &)(qt_gsi::CppToQtReadAdaptor<QEasingCurve::Type>(heap, QEasingCurve::Linear));
  ret.write<QEasingCurve *> (new QEasingCurve (qt_gsi::QtToCppAdaptor<QEasingCurve::Type>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QEasingCurve_2167 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QEasingCurve::QEasingCurve(QEasingCurve::Type type)\nThis method creates an object of class QEasingCurve.", &_init_ctor_QEasingCurve_2167, &_call_ctor_QEasingCurve_2167);
}

//  Constructor QEasingCurve::QEasingCurve(const QEasingCurve &other)


static void _init_ctor_QEasingCurve_2510 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return_new<QEasingCurve *> ();
}

static void _call_ctor_QEasingCurve_2510 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEasingCurve &arg1 = args.read<const QEasingCurve & > ();
  ret.write<QEasingCurve *> (new QEasingCurve (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QEasingCurve_2510 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QEasingCurve::QEasingCurve(const QEasingCurve &other)\nThis method creates an object of class QEasingCurve.", &_init_ctor_QEasingCurve_2510, &_call_ctor_QEasingCurve_2510);
}

// double QEasingCurve::amplitude()


static void _init_f_amplitude_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_amplitude_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QEasingCurve *)cls)->amplitude ());
}

static qt_gsi::GenericMethod *_create_f_amplitude_c0 ()
{
  return new qt_gsi::GenericMethod (":amplitude", "@brief Method double QEasingCurve::amplitude()\n", true, &_init_f_amplitude_c0, &_call_f_amplitude_c0);
}

// bool QEasingCurve::operator!=(const QEasingCurve &other)


static void _init_f_operator_excl__eq__c2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEasingCurve &arg1 = args.read<const QEasingCurve & > ();
  ret.write<bool > ((bool)((QEasingCurve *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2510 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QEasingCurve::operator!=(const QEasingCurve &other)\n", true, &_init_f_operator_excl__eq__c2510, &_call_f_operator_excl__eq__c2510);
}

// QEasingCurve &QEasingCurve::operator=(const QEasingCurve &other)


static void _init_f_operator_eq__2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<QEasingCurve & > ();
}

static void _call_f_operator_eq__2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEasingCurve &arg1 = args.read<const QEasingCurve & > ();
  ret.write<QEasingCurve & > ((QEasingCurve &)((QEasingCurve *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2510 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QEasingCurve &QEasingCurve::operator=(const QEasingCurve &other)\n", false, &_init_f_operator_eq__2510, &_call_f_operator_eq__2510);
}

// bool QEasingCurve::operator==(const QEasingCurve &other)


static void _init_f_operator_eq__eq__c2510 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("other");
  decl->add_arg<const QEasingCurve & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2510 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QEasingCurve &arg1 = args.read<const QEasingCurve & > ();
  ret.write<bool > ((bool)((QEasingCurve *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2510 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QEasingCurve::operator==(const QEasingCurve &other)\n", true, &_init_f_operator_eq__eq__c2510, &_call_f_operator_eq__eq__c2510);
}

// double QEasingCurve::overshoot()


static void _init_f_overshoot_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_overshoot_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QEasingCurve *)cls)->overshoot ());
}

static qt_gsi::GenericMethod *_create_f_overshoot_c0 ()
{
  return new qt_gsi::GenericMethod (":overshoot", "@brief Method double QEasingCurve::overshoot()\n", true, &_init_f_overshoot_c0, &_call_f_overshoot_c0);
}

// double QEasingCurve::period()


static void _init_f_period_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<double > ();
}

static void _call_f_period_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<double > ((double)((QEasingCurve *)cls)->period ());
}

static qt_gsi::GenericMethod *_create_f_period_c0 ()
{
  return new qt_gsi::GenericMethod (":period", "@brief Method double QEasingCurve::period()\n", true, &_init_f_period_c0, &_call_f_period_c0);
}

// void QEasingCurve::setAmplitude(double amplitude)


static void _init_f_setAmplitude_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("amplitude");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAmplitude_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QEasingCurve *)cls)->setAmplitude (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAmplitude_1071 ()
{
  return new qt_gsi::GenericMethod ("setAmplitude|amplitude=", "@brief Method void QEasingCurve::setAmplitude(double amplitude)\n", false, &_init_f_setAmplitude_1071, &_call_f_setAmplitude_1071);
}

// void QEasingCurve::setOvershoot(double overshoot)


static void _init_f_setOvershoot_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("overshoot");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOvershoot_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QEasingCurve *)cls)->setOvershoot (arg1);
}

static qt_gsi::GenericMethod *_create_f_setOvershoot_1071 ()
{
  return new qt_gsi::GenericMethod ("setOvershoot|overshoot=", "@brief Method void QEasingCurve::setOvershoot(double overshoot)\n", false, &_init_f_setOvershoot_1071, &_call_f_setOvershoot_1071);
}

// void QEasingCurve::setPeriod(double period)


static void _init_f_setPeriod_1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("period");
  decl->add_arg<double > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPeriod_1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ((QEasingCurve *)cls)->setPeriod (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPeriod_1071 ()
{
  return new qt_gsi::GenericMethod ("setPeriod|period=", "@brief Method void QEasingCurve::setPeriod(double period)\n", false, &_init_f_setPeriod_1071, &_call_f_setPeriod_1071);
}

// void QEasingCurve::setType(QEasingCurve::Type type)


static void _init_f_setType_2167 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("type");
  decl->add_arg<const qt_gsi::Converter<QEasingCurve::Type>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setType_2167 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QEasingCurve::Type>::target_type & arg1 = args.read<const qt_gsi::Converter<QEasingCurve::Type>::target_type & > ();
  ((QEasingCurve *)cls)->setType (qt_gsi::QtToCppAdaptor<QEasingCurve::Type>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setType_2167 ()
{
  return new qt_gsi::GenericMethod ("setType|type=", "@brief Method void QEasingCurve::setType(QEasingCurve::Type type)\n", false, &_init_f_setType_2167, &_call_f_setType_2167);
}

// QEasingCurve::Type QEasingCurve::type()


static void _init_f_type_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QEasingCurve::Type>::target_type > ();
}

static void _call_f_type_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QEasingCurve::Type>::target_type > ((qt_gsi::Converter<QEasingCurve::Type>::target_type)qt_gsi::CppToQtAdaptor<QEasingCurve::Type>(((QEasingCurve *)cls)->type ()));
}

static qt_gsi::GenericMethod *_create_f_type_c0 ()
{
  return new qt_gsi::GenericMethod (":type", "@brief Method QEasingCurve::Type QEasingCurve::type()\n", true, &_init_f_type_c0, &_call_f_type_c0);
}

// double QEasingCurve::valueForProgress(double progress)


static void _init_f_valueForProgress_c1071 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("progress");
  decl->add_arg<double > (argspec_0);
  decl->set_return<double > ();
}

static void _call_f_valueForProgress_c1071 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  double arg1 = args.read<double > ();
  ret.write<double > ((double)((QEasingCurve *)cls)->valueForProgress (arg1));
}

static qt_gsi::GenericMethod *_create_f_valueForProgress_c1071 ()
{
  return new qt_gsi::GenericMethod ("valueForProgress", "@brief Method double QEasingCurve::valueForProgress(double progress)\n", true, &_init_f_valueForProgress_c1071, &_call_f_valueForProgress_c1071);
}


namespace gsi
{
gsi::Class<QEasingCurve> decl_QEasingCurve ("QEasingCurve",
  gsi::Methods(_create_ctor_QEasingCurve_2167 ()) +
  gsi::Methods(_create_ctor_QEasingCurve_2510 ()) +
  gsi::Methods(_create_f_amplitude_c0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2510 ()) +
  gsi::Methods(_create_f_operator_eq__2510 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2510 ()) +
  gsi::Methods(_create_f_overshoot_c0 ()) +
  gsi::Methods(_create_f_period_c0 ()) +
  gsi::Methods(_create_f_setAmplitude_1071 ()) +
  gsi::Methods(_create_f_setOvershoot_1071 ()) +
  gsi::Methods(_create_f_setPeriod_1071 ()) +
  gsi::Methods(_create_f_setType_2167 ()) +
  gsi::Methods(_create_f_type_c0 ()) +
  gsi::Methods(_create_f_valueForProgress_c1071 ()),
  "@qt\n@brief Binding of QEasingCurve");

}


//  Implementation of the enum wrapper class for QEasingCurve::Type
namespace qt_gsi
{

static QEasingCurve_Type_Enum *c_1_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::Linear); }
static QEasingCurve_Type_Enum *c_2_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InQuad); }
static QEasingCurve_Type_Enum *c_3_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutQuad); }
static QEasingCurve_Type_Enum *c_4_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutQuad); }
static QEasingCurve_Type_Enum *c_5_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInQuad); }
static QEasingCurve_Type_Enum *c_6_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InCubic); }
static QEasingCurve_Type_Enum *c_7_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutCubic); }
static QEasingCurve_Type_Enum *c_8_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutCubic); }
static QEasingCurve_Type_Enum *c_9_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInCubic); }
static QEasingCurve_Type_Enum *c_10_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InQuart); }
static QEasingCurve_Type_Enum *c_11_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutQuart); }
static QEasingCurve_Type_Enum *c_12_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutQuart); }
static QEasingCurve_Type_Enum *c_13_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInQuart); }
static QEasingCurve_Type_Enum *c_14_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InQuint); }
static QEasingCurve_Type_Enum *c_15_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutQuint); }
static QEasingCurve_Type_Enum *c_16_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutQuint); }
static QEasingCurve_Type_Enum *c_17_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInQuint); }
static QEasingCurve_Type_Enum *c_18_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InSine); }
static QEasingCurve_Type_Enum *c_19_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutSine); }
static QEasingCurve_Type_Enum *c_20_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutSine); }
static QEasingCurve_Type_Enum *c_21_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInSine); }
static QEasingCurve_Type_Enum *c_22_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InExpo); }
static QEasingCurve_Type_Enum *c_23_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutExpo); }
static QEasingCurve_Type_Enum *c_24_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutExpo); }
static QEasingCurve_Type_Enum *c_25_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInExpo); }
static QEasingCurve_Type_Enum *c_26_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InCirc); }
static QEasingCurve_Type_Enum *c_27_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutCirc); }
static QEasingCurve_Type_Enum *c_28_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutCirc); }
static QEasingCurve_Type_Enum *c_29_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInCirc); }
static QEasingCurve_Type_Enum *c_30_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InElastic); }
static QEasingCurve_Type_Enum *c_31_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutElastic); }
static QEasingCurve_Type_Enum *c_32_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutElastic); }
static QEasingCurve_Type_Enum *c_33_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInElastic); }
static QEasingCurve_Type_Enum *c_34_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InBack); }
static QEasingCurve_Type_Enum *c_35_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutBack); }
static QEasingCurve_Type_Enum *c_36_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutBack); }
static QEasingCurve_Type_Enum *c_37_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInBack); }
static QEasingCurve_Type_Enum *c_38_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InBounce); }
static QEasingCurve_Type_Enum *c_39_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutBounce); }
static QEasingCurve_Type_Enum *c_40_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InOutBounce); }
static QEasingCurve_Type_Enum *c_41_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutInBounce); }
static QEasingCurve_Type_Enum *c_42_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::InCurve); }
static QEasingCurve_Type_Enum *c_43_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::OutCurve); }
static QEasingCurve_Type_Enum *c_44_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::SineCurve); }
static QEasingCurve_Type_Enum *c_45_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::CosineCurve); }
static QEasingCurve_Type_Enum *c_46_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::Custom); }
static QEasingCurve_Type_Enum *c_47_QEasingCurve_Type_Enum () { return new QEasingCurve_Type_Enum (QEasingCurve::NCurveTypes); }

static gsi::Methods mkdefs_QEasingCurve_Type () {
  return
    gsi::constant ("Linear", &qt_gsi::c_1_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::Linear") +
    gsi::constant ("InQuad", &qt_gsi::c_2_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InQuad") +
    gsi::constant ("OutQuad", &qt_gsi::c_3_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutQuad") +
    gsi::constant ("InOutQuad", &qt_gsi::c_4_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutQuad") +
    gsi::constant ("OutInQuad", &qt_gsi::c_5_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInQuad") +
    gsi::constant ("InCubic", &qt_gsi::c_6_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InCubic") +
    gsi::constant ("OutCubic", &qt_gsi::c_7_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutCubic") +
    gsi::constant ("InOutCubic", &qt_gsi::c_8_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutCubic") +
    gsi::constant ("OutInCubic", &qt_gsi::c_9_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInCubic") +
    gsi::constant ("InQuart", &qt_gsi::c_10_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InQuart") +
    gsi::constant ("OutQuart", &qt_gsi::c_11_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutQuart") +
    gsi::constant ("InOutQuart", &qt_gsi::c_12_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutQuart") +
    gsi::constant ("OutInQuart", &qt_gsi::c_13_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInQuart") +
    gsi::constant ("InQuint", &qt_gsi::c_14_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InQuint") +
    gsi::constant ("OutQuint", &qt_gsi::c_15_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutQuint") +
    gsi::constant ("InOutQuint", &qt_gsi::c_16_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutQuint") +
    gsi::constant ("OutInQuint", &qt_gsi::c_17_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInQuint") +
    gsi::constant ("InSine", &qt_gsi::c_18_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InSine") +
    gsi::constant ("OutSine", &qt_gsi::c_19_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutSine") +
    gsi::constant ("InOutSine", &qt_gsi::c_20_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutSine") +
    gsi::constant ("OutInSine", &qt_gsi::c_21_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInSine") +
    gsi::constant ("InExpo", &qt_gsi::c_22_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InExpo") +
    gsi::constant ("OutExpo", &qt_gsi::c_23_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutExpo") +
    gsi::constant ("InOutExpo", &qt_gsi::c_24_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutExpo") +
    gsi::constant ("OutInExpo", &qt_gsi::c_25_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInExpo") +
    gsi::constant ("InCirc", &qt_gsi::c_26_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InCirc") +
    gsi::constant ("OutCirc", &qt_gsi::c_27_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutCirc") +
    gsi::constant ("InOutCirc", &qt_gsi::c_28_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutCirc") +
    gsi::constant ("OutInCirc", &qt_gsi::c_29_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInCirc") +
    gsi::constant ("InElastic", &qt_gsi::c_30_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InElastic") +
    gsi::constant ("OutElastic", &qt_gsi::c_31_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutElastic") +
    gsi::constant ("InOutElastic", &qt_gsi::c_32_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutElastic") +
    gsi::constant ("OutInElastic", &qt_gsi::c_33_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInElastic") +
    gsi::constant ("InBack", &qt_gsi::c_34_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InBack") +
    gsi::constant ("OutBack", &qt_gsi::c_35_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutBack") +
    gsi::constant ("InOutBack", &qt_gsi::c_36_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutBack") +
    gsi::constant ("OutInBack", &qt_gsi::c_37_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInBack") +
    gsi::constant ("InBounce", &qt_gsi::c_38_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InBounce") +
    gsi::constant ("OutBounce", &qt_gsi::c_39_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutBounce") +
    gsi::constant ("InOutBounce", &qt_gsi::c_40_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InOutBounce") +
    gsi::constant ("OutInBounce", &qt_gsi::c_41_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutInBounce") +
    gsi::constant ("InCurve", &qt_gsi::c_42_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::InCurve") +
    gsi::constant ("OutCurve", &qt_gsi::c_43_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::OutCurve") +
    gsi::constant ("SineCurve", &qt_gsi::c_44_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::SineCurve") +
    gsi::constant ("CosineCurve", &qt_gsi::c_45_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::CosineCurve") +
    gsi::constant ("Custom", &qt_gsi::c_46_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::Custom") +
    gsi::constant ("NCurveTypes", &qt_gsi::c_47_QEasingCurve_Type_Enum, "@brief Enum constant QEasingCurve::NCurveTypes");
}

static std::string to_s_QEasingCurve_Type_Enum (const QEasingCurve_Type_Enum *e)
{
  if (e->value () == QEasingCurve::Linear) { return tl::sprintf ("Linear (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InQuad) { return tl::sprintf ("InQuad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutQuad) { return tl::sprintf ("OutQuad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutQuad) { return tl::sprintf ("InOutQuad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInQuad) { return tl::sprintf ("OutInQuad (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InCubic) { return tl::sprintf ("InCubic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutCubic) { return tl::sprintf ("OutCubic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutCubic) { return tl::sprintf ("InOutCubic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInCubic) { return tl::sprintf ("OutInCubic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InQuart) { return tl::sprintf ("InQuart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutQuart) { return tl::sprintf ("OutQuart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutQuart) { return tl::sprintf ("InOutQuart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInQuart) { return tl::sprintf ("OutInQuart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InQuint) { return tl::sprintf ("InQuint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutQuint) { return tl::sprintf ("OutQuint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutQuint) { return tl::sprintf ("InOutQuint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInQuint) { return tl::sprintf ("OutInQuint (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InSine) { return tl::sprintf ("InSine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutSine) { return tl::sprintf ("OutSine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutSine) { return tl::sprintf ("InOutSine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInSine) { return tl::sprintf ("OutInSine (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InExpo) { return tl::sprintf ("InExpo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutExpo) { return tl::sprintf ("OutExpo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutExpo) { return tl::sprintf ("InOutExpo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInExpo) { return tl::sprintf ("OutInExpo (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InCirc) { return tl::sprintf ("InCirc (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutCirc) { return tl::sprintf ("OutCirc (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutCirc) { return tl::sprintf ("InOutCirc (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInCirc) { return tl::sprintf ("OutInCirc (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InElastic) { return tl::sprintf ("InElastic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutElastic) { return tl::sprintf ("OutElastic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutElastic) { return tl::sprintf ("InOutElastic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInElastic) { return tl::sprintf ("OutInElastic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InBack) { return tl::sprintf ("InBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutBack) { return tl::sprintf ("OutBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutBack) { return tl::sprintf ("InOutBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInBack) { return tl::sprintf ("OutInBack (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InBounce) { return tl::sprintf ("InBounce (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutBounce) { return tl::sprintf ("OutBounce (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InOutBounce) { return tl::sprintf ("InOutBounce (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutInBounce) { return tl::sprintf ("OutInBounce (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::InCurve) { return tl::sprintf ("InCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::OutCurve) { return tl::sprintf ("OutCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::SineCurve) { return tl::sprintf ("SineCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::CosineCurve) { return tl::sprintf ("CosineCurve (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::Custom) { return tl::sprintf ("Custom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QEasingCurve::NCurveTypes) { return tl::sprintf ("NCurveTypes (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QEasingCurve_Type_Enum (const QEasingCurve_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QEasingCurve_Type_Enum *from_i_QEasingCurve_Type_Enum (unsigned int i)
{
  return new QEasingCurve_Type_Enum ((QEasingCurve::Type) i);
}

static bool equalQEasingCurve_Type_Enum (const QEasingCurve_Type_Enum *e, QEasingCurve_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QEasingCurve_Type_Enum (const QEasingCurve_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QEasingCurve_Type_Enums oropQEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e, const QEasingCurve_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QEasingCurve_Type_Enums andopQEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e, const QEasingCurve_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QEasingCurve_Type_Enums xoropQEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e, const QEasingCurve_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QEasingCurve::Linear)) { if (!l.empty ()) l += "|"; l += "Linear"; }
  if (e->testFlag (QEasingCurve::InQuad)) { if (!l.empty ()) l += "|"; l += "InQuad"; }
  if (e->testFlag (QEasingCurve::OutQuad)) { if (!l.empty ()) l += "|"; l += "OutQuad"; }
  if (e->testFlag (QEasingCurve::InOutQuad)) { if (!l.empty ()) l += "|"; l += "InOutQuad"; }
  if (e->testFlag (QEasingCurve::OutInQuad)) { if (!l.empty ()) l += "|"; l += "OutInQuad"; }
  if (e->testFlag (QEasingCurve::InCubic)) { if (!l.empty ()) l += "|"; l += "InCubic"; }
  if (e->testFlag (QEasingCurve::OutCubic)) { if (!l.empty ()) l += "|"; l += "OutCubic"; }
  if (e->testFlag (QEasingCurve::InOutCubic)) { if (!l.empty ()) l += "|"; l += "InOutCubic"; }
  if (e->testFlag (QEasingCurve::OutInCubic)) { if (!l.empty ()) l += "|"; l += "OutInCubic"; }
  if (e->testFlag (QEasingCurve::InQuart)) { if (!l.empty ()) l += "|"; l += "InQuart"; }
  if (e->testFlag (QEasingCurve::OutQuart)) { if (!l.empty ()) l += "|"; l += "OutQuart"; }
  if (e->testFlag (QEasingCurve::InOutQuart)) { if (!l.empty ()) l += "|"; l += "InOutQuart"; }
  if (e->testFlag (QEasingCurve::OutInQuart)) { if (!l.empty ()) l += "|"; l += "OutInQuart"; }
  if (e->testFlag (QEasingCurve::InQuint)) { if (!l.empty ()) l += "|"; l += "InQuint"; }
  if (e->testFlag (QEasingCurve::OutQuint)) { if (!l.empty ()) l += "|"; l += "OutQuint"; }
  if (e->testFlag (QEasingCurve::InOutQuint)) { if (!l.empty ()) l += "|"; l += "InOutQuint"; }
  if (e->testFlag (QEasingCurve::OutInQuint)) { if (!l.empty ()) l += "|"; l += "OutInQuint"; }
  if (e->testFlag (QEasingCurve::InSine)) { if (!l.empty ()) l += "|"; l += "InSine"; }
  if (e->testFlag (QEasingCurve::OutSine)) { if (!l.empty ()) l += "|"; l += "OutSine"; }
  if (e->testFlag (QEasingCurve::InOutSine)) { if (!l.empty ()) l += "|"; l += "InOutSine"; }
  if (e->testFlag (QEasingCurve::OutInSine)) { if (!l.empty ()) l += "|"; l += "OutInSine"; }
  if (e->testFlag (QEasingCurve::InExpo)) { if (!l.empty ()) l += "|"; l += "InExpo"; }
  if (e->testFlag (QEasingCurve::OutExpo)) { if (!l.empty ()) l += "|"; l += "OutExpo"; }
  if (e->testFlag (QEasingCurve::InOutExpo)) { if (!l.empty ()) l += "|"; l += "InOutExpo"; }
  if (e->testFlag (QEasingCurve::OutInExpo)) { if (!l.empty ()) l += "|"; l += "OutInExpo"; }
  if (e->testFlag (QEasingCurve::InCirc)) { if (!l.empty ()) l += "|"; l += "InCirc"; }
  if (e->testFlag (QEasingCurve::OutCirc)) { if (!l.empty ()) l += "|"; l += "OutCirc"; }
  if (e->testFlag (QEasingCurve::InOutCirc)) { if (!l.empty ()) l += "|"; l += "InOutCirc"; }
  if (e->testFlag (QEasingCurve::OutInCirc)) { if (!l.empty ()) l += "|"; l += "OutInCirc"; }
  if (e->testFlag (QEasingCurve::InElastic)) { if (!l.empty ()) l += "|"; l += "InElastic"; }
  if (e->testFlag (QEasingCurve::OutElastic)) { if (!l.empty ()) l += "|"; l += "OutElastic"; }
  if (e->testFlag (QEasingCurve::InOutElastic)) { if (!l.empty ()) l += "|"; l += "InOutElastic"; }
  if (e->testFlag (QEasingCurve::OutInElastic)) { if (!l.empty ()) l += "|"; l += "OutInElastic"; }
  if (e->testFlag (QEasingCurve::InBack)) { if (!l.empty ()) l += "|"; l += "InBack"; }
  if (e->testFlag (QEasingCurve::OutBack)) { if (!l.empty ()) l += "|"; l += "OutBack"; }
  if (e->testFlag (QEasingCurve::InOutBack)) { if (!l.empty ()) l += "|"; l += "InOutBack"; }
  if (e->testFlag (QEasingCurve::OutInBack)) { if (!l.empty ()) l += "|"; l += "OutInBack"; }
  if (e->testFlag (QEasingCurve::InBounce)) { if (!l.empty ()) l += "|"; l += "InBounce"; }
  if (e->testFlag (QEasingCurve::OutBounce)) { if (!l.empty ()) l += "|"; l += "OutBounce"; }
  if (e->testFlag (QEasingCurve::InOutBounce)) { if (!l.empty ()) l += "|"; l += "InOutBounce"; }
  if (e->testFlag (QEasingCurve::OutInBounce)) { if (!l.empty ()) l += "|"; l += "OutInBounce"; }
  if (e->testFlag (QEasingCurve::InCurve)) { if (!l.empty ()) l += "|"; l += "InCurve"; }
  if (e->testFlag (QEasingCurve::OutCurve)) { if (!l.empty ()) l += "|"; l += "OutCurve"; }
  if (e->testFlag (QEasingCurve::SineCurve)) { if (!l.empty ()) l += "|"; l += "SineCurve"; }
  if (e->testFlag (QEasingCurve::CosineCurve)) { if (!l.empty ()) l += "|"; l += "CosineCurve"; }
  if (e->testFlag (QEasingCurve::Custom)) { if (!l.empty ()) l += "|"; l += "Custom"; }
  if (e->testFlag (QEasingCurve::NCurveTypes)) { if (!l.empty ()) l += "|"; l += "NCurveTypes"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QEasingCurve_Type_Enums (const QEasingCurve_Type_Enums *e, const QEasingCurve_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QEasingCurve_Type_Enums> decl_QEasingCurve_Type_Enums ("QEasingCurve_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQEasingCurve_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQEasingCurve_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQEasingCurve_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QEasingCurve_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QEasingCurve_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QEasingCurve_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QEasingCurve::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QEasingCurve_Type_Enum> decl_QEasingCurve_Type_Enum (decl_QEasingCurve_Type_Enums, "QEasingCurve_Type",
  qt_gsi::mkdefs_QEasingCurve_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QEasingCurve_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QEasingCurve_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQEasingCurve_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QEasingCurve_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QEasingCurve_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QEasingCurve::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QEasingCurve> inject_QEasingCurve_Type_Enum_in_parent (qt_gsi::mkdefs_QEasingCurve_Type ());
static gsi::ClassExt<QEasingCurve> decl_QEasingCurve_Type_Enum_as_child (decl_QEasingCurve_Type_Enum, "Type");

}

