
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDomNode.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtXml.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDomNode_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDomNode

//  Constructor QDomNode::QDomNode()


static void _init_ctor_QDomNode_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDomNode *> ();
}

static void _call_ctor_QDomNode_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode *> (new QDomNode ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDomNode_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDomNode::QDomNode()\nThis method creates an object of class QDomNode.", &_init_ctor_QDomNode_0, &_call_ctor_QDomNode_0);
}

//  Constructor QDomNode::QDomNode(const QDomNode &)


static void _init_ctor_QDomNode_2072 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return_new<QDomNode *> ();
}

static void _call_ctor_QDomNode_2072 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<QDomNode *> (new QDomNode (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDomNode_2072 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDomNode::QDomNode(const QDomNode &)\nThis method creates an object of class QDomNode.", &_init_ctor_QDomNode_2072, &_call_ctor_QDomNode_2072);
}

// QDomNode QDomNode::appendChild(const QDomNode &newChild)


static void _init_f_appendChild_2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_appendChild_2072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->appendChild (arg1));
}

static qt_gsi::GenericMethod *_create_f_appendChild_2072 ()
{
  return new qt_gsi::GenericMethod ("appendChild", "@brief Method QDomNode QDomNode::appendChild(const QDomNode &newChild)\n", false, &_init_f_appendChild_2072, &_call_f_appendChild_2072);
}

// QDomNamedNodeMap QDomNode::attributes()


static void _init_f_attributes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNamedNodeMap > ();
}

static void _call_f_attributes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNamedNodeMap > ((QDomNamedNodeMap)((QDomNode *)cls)->attributes ());
}

static qt_gsi::GenericMethod *_create_f_attributes_c0 ()
{
  return new qt_gsi::GenericMethod ("attributes", "@brief Method QDomNamedNodeMap QDomNode::attributes()\n", true, &_init_f_attributes_c0, &_call_f_attributes_c0);
}

// QDomNodeList QDomNode::childNodes()


static void _init_f_childNodes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNodeList > ();
}

static void _call_f_childNodes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNodeList > ((QDomNodeList)((QDomNode *)cls)->childNodes ());
}

static qt_gsi::GenericMethod *_create_f_childNodes_c0 ()
{
  return new qt_gsi::GenericMethod ("childNodes", "@brief Method QDomNodeList QDomNode::childNodes()\n", true, &_init_f_childNodes_c0, &_call_f_childNodes_c0);
}

// void QDomNode::clear()


static void _init_f_clear_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_clear_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDomNode *)cls)->clear ();
}

static qt_gsi::GenericMethod *_create_f_clear_0 ()
{
  return new qt_gsi::GenericMethod ("clear", "@brief Method void QDomNode::clear()\n", false, &_init_f_clear_0, &_call_f_clear_0);
}

// QDomNode QDomNode::cloneNode(bool deep)


static void _init_f_cloneNode_c864 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("deep", true, "true");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_cloneNode_c864 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args ? args.read<bool > () : (bool)(true);
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->cloneNode (arg1));
}

static qt_gsi::GenericMethod *_create_f_cloneNode_c864 ()
{
  return new qt_gsi::GenericMethod ("cloneNode", "@brief Method QDomNode QDomNode::cloneNode(bool deep)\n", true, &_init_f_cloneNode_c864, &_call_f_cloneNode_c864);
}

// int QDomNode::columnNumber()


static void _init_f_columnNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_columnNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDomNode *)cls)->columnNumber ());
}

static qt_gsi::GenericMethod *_create_f_columnNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("columnNumber", "@brief Method int QDomNode::columnNumber()\n", true, &_init_f_columnNumber_c0, &_call_f_columnNumber_c0);
}

// QDomNode QDomNode::firstChild()


static void _init_f_firstChild_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_firstChild_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->firstChild ());
}

static qt_gsi::GenericMethod *_create_f_firstChild_c0 ()
{
  return new qt_gsi::GenericMethod ("firstChild", "@brief Method QDomNode QDomNode::firstChild()\n", true, &_init_f_firstChild_c0, &_call_f_firstChild_c0);
}

// QDomElement QDomNode::firstChildElement(const QString &tagName)


static void _init_f_firstChildElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_firstChildElement_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->firstChildElement (arg1));
}

static qt_gsi::GenericMethod *_create_f_firstChildElement_c2025 ()
{
  return new qt_gsi::GenericMethod ("firstChildElement", "@brief Method QDomElement QDomNode::firstChildElement(const QString &tagName)\n", true, &_init_f_firstChildElement_c2025, &_call_f_firstChildElement_c2025);
}

// bool QDomNode::hasAttributes()


static void _init_f_hasAttributes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasAttributes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->hasAttributes ());
}

static qt_gsi::GenericMethod *_create_f_hasAttributes_c0 ()
{
  return new qt_gsi::GenericMethod ("hasAttributes", "@brief Method bool QDomNode::hasAttributes()\n", true, &_init_f_hasAttributes_c0, &_call_f_hasAttributes_c0);
}

// bool QDomNode::hasChildNodes()


static void _init_f_hasChildNodes_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasChildNodes_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->hasChildNodes ());
}

static qt_gsi::GenericMethod *_create_f_hasChildNodes_c0 ()
{
  return new qt_gsi::GenericMethod ("hasChildNodes", "@brief Method bool QDomNode::hasChildNodes()\n", true, &_init_f_hasChildNodes_c0, &_call_f_hasChildNodes_c0);
}

// QDomNode QDomNode::insertAfter(const QDomNode &newChild, const QDomNode &refChild)


static void _init_f_insertAfter_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("refChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_insertAfter_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  const QDomNode &arg2 = args.read<const QDomNode & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->insertAfter (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertAfter_4036 ()
{
  return new qt_gsi::GenericMethod ("insertAfter", "@brief Method QDomNode QDomNode::insertAfter(const QDomNode &newChild, const QDomNode &refChild)\n", false, &_init_f_insertAfter_4036, &_call_f_insertAfter_4036);
}

// QDomNode QDomNode::insertBefore(const QDomNode &newChild, const QDomNode &refChild)


static void _init_f_insertBefore_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("refChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_insertBefore_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  const QDomNode &arg2 = args.read<const QDomNode & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->insertBefore (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_insertBefore_4036 ()
{
  return new qt_gsi::GenericMethod ("insertBefore", "@brief Method QDomNode QDomNode::insertBefore(const QDomNode &newChild, const QDomNode &refChild)\n", false, &_init_f_insertBefore_4036, &_call_f_insertBefore_4036);
}

// bool QDomNode::isAttr()


static void _init_f_isAttr_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isAttr_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isAttr ());
}

static qt_gsi::GenericMethod *_create_f_isAttr_c0 ()
{
  return new qt_gsi::GenericMethod ("isAttr?", "@brief Method bool QDomNode::isAttr()\n", true, &_init_f_isAttr_c0, &_call_f_isAttr_c0);
}

// bool QDomNode::isCDATASection()


static void _init_f_isCDATASection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCDATASection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isCDATASection ());
}

static qt_gsi::GenericMethod *_create_f_isCDATASection_c0 ()
{
  return new qt_gsi::GenericMethod ("isCDATASection?", "@brief Method bool QDomNode::isCDATASection()\n", true, &_init_f_isCDATASection_c0, &_call_f_isCDATASection_c0);
}

// bool QDomNode::isCharacterData()


static void _init_f_isCharacterData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isCharacterData_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isCharacterData ());
}

static qt_gsi::GenericMethod *_create_f_isCharacterData_c0 ()
{
  return new qt_gsi::GenericMethod ("isCharacterData?", "@brief Method bool QDomNode::isCharacterData()\n", true, &_init_f_isCharacterData_c0, &_call_f_isCharacterData_c0);
}

// bool QDomNode::isComment()


static void _init_f_isComment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isComment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isComment ());
}

static qt_gsi::GenericMethod *_create_f_isComment_c0 ()
{
  return new qt_gsi::GenericMethod ("isComment?", "@brief Method bool QDomNode::isComment()\n", true, &_init_f_isComment_c0, &_call_f_isComment_c0);
}

// bool QDomNode::isDocument()


static void _init_f_isDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocument_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocument ());
}

static qt_gsi::GenericMethod *_create_f_isDocument_c0 ()
{
  return new qt_gsi::GenericMethod ("isDocument?", "@brief Method bool QDomNode::isDocument()\n", true, &_init_f_isDocument_c0, &_call_f_isDocument_c0);
}

// bool QDomNode::isDocumentFragment()


static void _init_f_isDocumentFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocumentFragment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocumentFragment ());
}

static qt_gsi::GenericMethod *_create_f_isDocumentFragment_c0 ()
{
  return new qt_gsi::GenericMethod ("isDocumentFragment?", "@brief Method bool QDomNode::isDocumentFragment()\n", true, &_init_f_isDocumentFragment_c0, &_call_f_isDocumentFragment_c0);
}

// bool QDomNode::isDocumentType()


static void _init_f_isDocumentType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isDocumentType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isDocumentType ());
}

static qt_gsi::GenericMethod *_create_f_isDocumentType_c0 ()
{
  return new qt_gsi::GenericMethod ("isDocumentType?", "@brief Method bool QDomNode::isDocumentType()\n", true, &_init_f_isDocumentType_c0, &_call_f_isDocumentType_c0);
}

// bool QDomNode::isElement()


static void _init_f_isElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isElement_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isElement ());
}

static qt_gsi::GenericMethod *_create_f_isElement_c0 ()
{
  return new qt_gsi::GenericMethod ("isElement?", "@brief Method bool QDomNode::isElement()\n", true, &_init_f_isElement_c0, &_call_f_isElement_c0);
}

// bool QDomNode::isEntity()


static void _init_f_isEntity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEntity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isEntity ());
}

static qt_gsi::GenericMethod *_create_f_isEntity_c0 ()
{
  return new qt_gsi::GenericMethod ("isEntity?", "@brief Method bool QDomNode::isEntity()\n", true, &_init_f_isEntity_c0, &_call_f_isEntity_c0);
}

// bool QDomNode::isEntityReference()


static void _init_f_isEntityReference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isEntityReference_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isEntityReference ());
}

static qt_gsi::GenericMethod *_create_f_isEntityReference_c0 ()
{
  return new qt_gsi::GenericMethod ("isEntityReference?", "@brief Method bool QDomNode::isEntityReference()\n", true, &_init_f_isEntityReference_c0, &_call_f_isEntityReference_c0);
}

// bool QDomNode::isNotation()


static void _init_f_isNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNotation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isNotation ());
}

static qt_gsi::GenericMethod *_create_f_isNotation_c0 ()
{
  return new qt_gsi::GenericMethod ("isNotation?", "@brief Method bool QDomNode::isNotation()\n", true, &_init_f_isNotation_c0, &_call_f_isNotation_c0);
}

// bool QDomNode::isNull()


static void _init_f_isNull_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isNull_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isNull ());
}

static qt_gsi::GenericMethod *_create_f_isNull_c0 ()
{
  return new qt_gsi::GenericMethod ("isNull?", "@brief Method bool QDomNode::isNull()\n", true, &_init_f_isNull_c0, &_call_f_isNull_c0);
}

// bool QDomNode::isProcessingInstruction()


static void _init_f_isProcessingInstruction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isProcessingInstruction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isProcessingInstruction ());
}

static qt_gsi::GenericMethod *_create_f_isProcessingInstruction_c0 ()
{
  return new qt_gsi::GenericMethod ("isProcessingInstruction?", "@brief Method bool QDomNode::isProcessingInstruction()\n", true, &_init_f_isProcessingInstruction_c0, &_call_f_isProcessingInstruction_c0);
}

// bool QDomNode::isSupported(const QString &feature, const QString &version)


static void _init_f_isSupported_c3942 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("feature");
  decl->add_arg<const QString & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("version");
  decl->add_arg<const QString & > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_isSupported_c3942 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  const QString &arg2 = args.read<const QString & > ();
  ret.write<bool > ((bool)((QDomNode *)cls)->isSupported (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_isSupported_c3942 ()
{
  return new qt_gsi::GenericMethod ("isSupported?", "@brief Method bool QDomNode::isSupported(const QString &feature, const QString &version)\n", true, &_init_f_isSupported_c3942, &_call_f_isSupported_c3942);
}

// bool QDomNode::isText()


static void _init_f_isText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDomNode *)cls)->isText ());
}

static qt_gsi::GenericMethod *_create_f_isText_c0 ()
{
  return new qt_gsi::GenericMethod ("isText?", "@brief Method bool QDomNode::isText()\n", true, &_init_f_isText_c0, &_call_f_isText_c0);
}

// QDomNode QDomNode::lastChild()


static void _init_f_lastChild_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_lastChild_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->lastChild ());
}

static qt_gsi::GenericMethod *_create_f_lastChild_c0 ()
{
  return new qt_gsi::GenericMethod ("lastChild", "@brief Method QDomNode QDomNode::lastChild()\n", true, &_init_f_lastChild_c0, &_call_f_lastChild_c0);
}

// QDomElement QDomNode::lastChildElement(const QString &tagName)


static void _init_f_lastChildElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_lastChildElement_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->lastChildElement (arg1));
}

static qt_gsi::GenericMethod *_create_f_lastChildElement_c2025 ()
{
  return new qt_gsi::GenericMethod ("lastChildElement", "@brief Method QDomElement QDomNode::lastChildElement(const QString &tagName)\n", true, &_init_f_lastChildElement_c2025, &_call_f_lastChildElement_c2025);
}

// int QDomNode::lineNumber()


static void _init_f_lineNumber_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_lineNumber_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDomNode *)cls)->lineNumber ());
}

static qt_gsi::GenericMethod *_create_f_lineNumber_c0 ()
{
  return new qt_gsi::GenericMethod ("lineNumber", "@brief Method int QDomNode::lineNumber()\n", true, &_init_f_lineNumber_c0, &_call_f_lineNumber_c0);
}

// QString QDomNode::localName()


static void _init_f_localName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_localName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDomNode *)cls)->localName ());
}

static qt_gsi::GenericMethod *_create_f_localName_c0 ()
{
  return new qt_gsi::GenericMethod ("localName", "@brief Method QString QDomNode::localName()\n", true, &_init_f_localName_c0, &_call_f_localName_c0);
}

// QDomNode QDomNode::namedItem(const QString &name)


static void _init_f_namedItem_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("name");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_namedItem_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->namedItem (arg1));
}

static qt_gsi::GenericMethod *_create_f_namedItem_c2025 ()
{
  return new qt_gsi::GenericMethod ("namedItem", "@brief Method QDomNode QDomNode::namedItem(const QString &name)\n", true, &_init_f_namedItem_c2025, &_call_f_namedItem_c2025);
}

// QString QDomNode::namespaceURI()


static void _init_f_namespaceURI_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_namespaceURI_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDomNode *)cls)->namespaceURI ());
}

static qt_gsi::GenericMethod *_create_f_namespaceURI_c0 ()
{
  return new qt_gsi::GenericMethod ("namespaceURI", "@brief Method QString QDomNode::namespaceURI()\n", true, &_init_f_namespaceURI_c0, &_call_f_namespaceURI_c0);
}

// QDomNode QDomNode::nextSibling()


static void _init_f_nextSibling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_nextSibling_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->nextSibling ());
}

static qt_gsi::GenericMethod *_create_f_nextSibling_c0 ()
{
  return new qt_gsi::GenericMethod ("nextSibling", "@brief Method QDomNode QDomNode::nextSibling()\n", true, &_init_f_nextSibling_c0, &_call_f_nextSibling_c0);
}

// QDomElement QDomNode::nextSiblingElement(const QString &taName)


static void _init_f_nextSiblingElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("taName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_nextSiblingElement_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->nextSiblingElement (arg1));
}

static qt_gsi::GenericMethod *_create_f_nextSiblingElement_c2025 ()
{
  return new qt_gsi::GenericMethod ("nextSiblingElement", "@brief Method QDomElement QDomNode::nextSiblingElement(const QString &taName)\n", true, &_init_f_nextSiblingElement_c2025, &_call_f_nextSiblingElement_c2025);
}

// QString QDomNode::nodeName()


static void _init_f_nodeName_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nodeName_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDomNode *)cls)->nodeName ());
}

static qt_gsi::GenericMethod *_create_f_nodeName_c0 ()
{
  return new qt_gsi::GenericMethod ("nodeName", "@brief Method QString QDomNode::nodeName()\n", true, &_init_f_nodeName_c0, &_call_f_nodeName_c0);
}

// QDomNode::NodeType QDomNode::nodeType()


static void _init_f_nodeType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDomNode::NodeType>::target_type > ();
}

static void _call_f_nodeType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QDomNode::NodeType>::target_type > ((qt_gsi::Converter<QDomNode::NodeType>::target_type)qt_gsi::CppToQtAdaptor<QDomNode::NodeType>(((QDomNode *)cls)->nodeType ()));
}

static qt_gsi::GenericMethod *_create_f_nodeType_c0 ()
{
  return new qt_gsi::GenericMethod ("nodeType", "@brief Method QDomNode::NodeType QDomNode::nodeType()\n", true, &_init_f_nodeType_c0, &_call_f_nodeType_c0);
}

// QString QDomNode::nodeValue()


static void _init_f_nodeValue_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_nodeValue_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDomNode *)cls)->nodeValue ());
}

static qt_gsi::GenericMethod *_create_f_nodeValue_c0 ()
{
  return new qt_gsi::GenericMethod (":nodeValue", "@brief Method QString QDomNode::nodeValue()\n", true, &_init_f_nodeValue_c0, &_call_f_nodeValue_c0);
}

// void QDomNode::normalize()


static void _init_f_normalize_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_normalize_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDomNode *)cls)->normalize ();
}

static qt_gsi::GenericMethod *_create_f_normalize_0 ()
{
  return new qt_gsi::GenericMethod ("normalize", "@brief Method void QDomNode::normalize()\n", false, &_init_f_normalize_0, &_call_f_normalize_0);
}

// bool QDomNode::operator!=(const QDomNode &)


static void _init_f_operator_excl__eq__c2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_excl__eq__c2072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<bool > ((bool)((QDomNode *)cls)->operator!= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_excl__eq__c2072 ()
{
  return new qt_gsi::GenericMethod ("!=", "@brief Method bool QDomNode::operator!=(const QDomNode &)\n", true, &_init_f_operator_excl__eq__c2072, &_call_f_operator_excl__eq__c2072);
}

// QDomNode &QDomNode::operator=(const QDomNode &)


static void _init_f_operator_eq__2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode & > ();
}

static void _call_f_operator_eq__2072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<QDomNode & > ((QDomNode &)((QDomNode *)cls)->operator= (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__2072 ()
{
  return new qt_gsi::GenericMethod ("assign", "@brief Method QDomNode &QDomNode::operator=(const QDomNode &)\n", false, &_init_f_operator_eq__2072, &_call_f_operator_eq__2072);
}

// bool QDomNode::operator==(const QDomNode &)


static void _init_f_operator_eq__eq__c2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_operator_eq__eq__c2072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<bool > ((bool)((QDomNode *)cls)->operator== (arg1));
}

static qt_gsi::GenericMethod *_create_f_operator_eq__eq__c2072 ()
{
  return new qt_gsi::GenericMethod ("==", "@brief Method bool QDomNode::operator==(const QDomNode &)\n", true, &_init_f_operator_eq__eq__c2072, &_call_f_operator_eq__eq__c2072);
}

// QDomDocument QDomNode::ownerDocument()


static void _init_f_ownerDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocument > ();
}

static void _call_f_ownerDocument_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomDocument > ((QDomDocument)((QDomNode *)cls)->ownerDocument ());
}

static qt_gsi::GenericMethod *_create_f_ownerDocument_c0 ()
{
  return new qt_gsi::GenericMethod ("ownerDocument", "@brief Method QDomDocument QDomNode::ownerDocument()\n", true, &_init_f_ownerDocument_c0, &_call_f_ownerDocument_c0);
}

// QDomNode QDomNode::parentNode()


static void _init_f_parentNode_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_parentNode_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->parentNode ());
}

static qt_gsi::GenericMethod *_create_f_parentNode_c0 ()
{
  return new qt_gsi::GenericMethod ("parentNode", "@brief Method QDomNode QDomNode::parentNode()\n", true, &_init_f_parentNode_c0, &_call_f_parentNode_c0);
}

// QString QDomNode::prefix()


static void _init_f_prefix_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_prefix_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QDomNode *)cls)->prefix ());
}

static qt_gsi::GenericMethod *_create_f_prefix_c0 ()
{
  return new qt_gsi::GenericMethod (":prefix", "@brief Method QString QDomNode::prefix()\n", true, &_init_f_prefix_c0, &_call_f_prefix_c0);
}

// QDomNode QDomNode::previousSibling()


static void _init_f_previousSibling_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNode > ();
}

static void _call_f_previousSibling_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->previousSibling ());
}

static qt_gsi::GenericMethod *_create_f_previousSibling_c0 ()
{
  return new qt_gsi::GenericMethod ("previousSibling", "@brief Method QDomNode QDomNode::previousSibling()\n", true, &_init_f_previousSibling_c0, &_call_f_previousSibling_c0);
}

// QDomElement QDomNode::previousSiblingElement(const QString &tagName)


static void _init_f_previousSiblingElement_c2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("tagName", true, "QString()");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QDomElement > ();
}

static void _call_f_previousSiblingElement_c2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args ? args.read<const QString & > () : (const QString &)(QString());
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->previousSiblingElement (arg1));
}

static qt_gsi::GenericMethod *_create_f_previousSiblingElement_c2025 ()
{
  return new qt_gsi::GenericMethod ("previousSiblingElement", "@brief Method QDomElement QDomNode::previousSiblingElement(const QString &tagName)\n", true, &_init_f_previousSiblingElement_c2025, &_call_f_previousSiblingElement_c2025);
}

// QDomNode QDomNode::removeChild(const QDomNode &oldChild)


static void _init_f_removeChild_2072 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("oldChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  decl->set_return<QDomNode > ();
}

static void _call_f_removeChild_2072 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->removeChild (arg1));
}

static qt_gsi::GenericMethod *_create_f_removeChild_2072 ()
{
  return new qt_gsi::GenericMethod ("removeChild", "@brief Method QDomNode QDomNode::removeChild(const QDomNode &oldChild)\n", false, &_init_f_removeChild_2072, &_call_f_removeChild_2072);
}

// QDomNode QDomNode::replaceChild(const QDomNode &newChild, const QDomNode &oldChild)


static void _init_f_replaceChild_4036 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("newChild");
  decl->add_arg<const QDomNode & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("oldChild");
  decl->add_arg<const QDomNode & > (argspec_1);
  decl->set_return<QDomNode > ();
}

static void _call_f_replaceChild_4036 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QDomNode &arg1 = args.read<const QDomNode & > ();
  const QDomNode &arg2 = args.read<const QDomNode & > ();
  ret.write<QDomNode > ((QDomNode)((QDomNode *)cls)->replaceChild (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_replaceChild_4036 ()
{
  return new qt_gsi::GenericMethod ("replaceChild", "@brief Method QDomNode QDomNode::replaceChild(const QDomNode &newChild, const QDomNode &oldChild)\n", false, &_init_f_replaceChild_4036, &_call_f_replaceChild_4036);
}

// void QDomNode::save(QTextStream &, int)


static void _init_f_save_c2399 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_save_c2399 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextStream &arg1 = args.read<QTextStream & > ();
  int arg2 = args.read<int > ();
  ((QDomNode *)cls)->save (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_save_c2399 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method void QDomNode::save(QTextStream &, int)\n", true, &_init_f_save_c2399, &_call_f_save_c2399);
}

// void QDomNode::save(QTextStream &, int, QDomNode::EncodingPolicy)


static void _init_f_save_c5033 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTextStream & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("arg3");
  decl->add_arg<const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_save_c5033 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTextStream &arg1 = args.read<QTextStream & > ();
  int arg2 = args.read<int > ();
  const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & arg3 = args.read<const qt_gsi::Converter<QDomNode::EncodingPolicy>::target_type & > ();
  ((QDomNode *)cls)->save (arg1, arg2, qt_gsi::QtToCppAdaptor<QDomNode::EncodingPolicy>(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_save_c5033 ()
{
  return new qt_gsi::GenericMethod ("save", "@brief Method void QDomNode::save(QTextStream &, int, QDomNode::EncodingPolicy)\n", true, &_init_f_save_c5033, &_call_f_save_c5033);
}

// void QDomNode::setNodeValue(const QString &)


static void _init_f_setNodeValue_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setNodeValue_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QDomNode *)cls)->setNodeValue (arg1);
}

static qt_gsi::GenericMethod *_create_f_setNodeValue_2025 ()
{
  return new qt_gsi::GenericMethod ("setNodeValue|nodeValue=", "@brief Method void QDomNode::setNodeValue(const QString &)\n", false, &_init_f_setNodeValue_2025, &_call_f_setNodeValue_2025);
}

// void QDomNode::setPrefix(const QString &pre)


static void _init_f_setPrefix_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("pre");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPrefix_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QDomNode *)cls)->setPrefix (arg1);
}

static qt_gsi::GenericMethod *_create_f_setPrefix_2025 ()
{
  return new qt_gsi::GenericMethod ("setPrefix|prefix=", "@brief Method void QDomNode::setPrefix(const QString &pre)\n", false, &_init_f_setPrefix_2025, &_call_f_setPrefix_2025);
}

// QDomAttr QDomNode::toAttr()


static void _init_f_toAttr_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomAttr > ();
}

static void _call_f_toAttr_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomAttr > ((QDomAttr)((QDomNode *)cls)->toAttr ());
}

static qt_gsi::GenericMethod *_create_f_toAttr_c0 ()
{
  return new qt_gsi::GenericMethod ("toAttr", "@brief Method QDomAttr QDomNode::toAttr()\n", true, &_init_f_toAttr_c0, &_call_f_toAttr_c0);
}

// QDomCDATASection QDomNode::toCDATASection()


static void _init_f_toCDATASection_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomCDATASection > ();
}

static void _call_f_toCDATASection_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomCDATASection > ((QDomCDATASection)((QDomNode *)cls)->toCDATASection ());
}

static qt_gsi::GenericMethod *_create_f_toCDATASection_c0 ()
{
  return new qt_gsi::GenericMethod ("toCDATASection", "@brief Method QDomCDATASection QDomNode::toCDATASection()\n", true, &_init_f_toCDATASection_c0, &_call_f_toCDATASection_c0);
}

// QDomCharacterData QDomNode::toCharacterData()


static void _init_f_toCharacterData_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomCharacterData > ();
}

static void _call_f_toCharacterData_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomCharacterData > ((QDomCharacterData)((QDomNode *)cls)->toCharacterData ());
}

static qt_gsi::GenericMethod *_create_f_toCharacterData_c0 ()
{
  return new qt_gsi::GenericMethod ("toCharacterData", "@brief Method QDomCharacterData QDomNode::toCharacterData()\n", true, &_init_f_toCharacterData_c0, &_call_f_toCharacterData_c0);
}

// QDomComment QDomNode::toComment()


static void _init_f_toComment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomComment > ();
}

static void _call_f_toComment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomComment > ((QDomComment)((QDomNode *)cls)->toComment ());
}

static qt_gsi::GenericMethod *_create_f_toComment_c0 ()
{
  return new qt_gsi::GenericMethod ("toComment", "@brief Method QDomComment QDomNode::toComment()\n", true, &_init_f_toComment_c0, &_call_f_toComment_c0);
}

// QDomDocument QDomNode::toDocument()


static void _init_f_toDocument_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocument > ();
}

static void _call_f_toDocument_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomDocument > ((QDomDocument)((QDomNode *)cls)->toDocument ());
}

static qt_gsi::GenericMethod *_create_f_toDocument_c0 ()
{
  return new qt_gsi::GenericMethod ("toDocument", "@brief Method QDomDocument QDomNode::toDocument()\n", true, &_init_f_toDocument_c0, &_call_f_toDocument_c0);
}

// QDomDocumentFragment QDomNode::toDocumentFragment()


static void _init_f_toDocumentFragment_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocumentFragment > ();
}

static void _call_f_toDocumentFragment_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomDocumentFragment > ((QDomDocumentFragment)((QDomNode *)cls)->toDocumentFragment ());
}

static qt_gsi::GenericMethod *_create_f_toDocumentFragment_c0 ()
{
  return new qt_gsi::GenericMethod ("toDocumentFragment", "@brief Method QDomDocumentFragment QDomNode::toDocumentFragment()\n", true, &_init_f_toDocumentFragment_c0, &_call_f_toDocumentFragment_c0);
}

// QDomDocumentType QDomNode::toDocumentType()


static void _init_f_toDocumentType_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomDocumentType > ();
}

static void _call_f_toDocumentType_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomDocumentType > ((QDomDocumentType)((QDomNode *)cls)->toDocumentType ());
}

static qt_gsi::GenericMethod *_create_f_toDocumentType_c0 ()
{
  return new qt_gsi::GenericMethod ("toDocumentType", "@brief Method QDomDocumentType QDomNode::toDocumentType()\n", true, &_init_f_toDocumentType_c0, &_call_f_toDocumentType_c0);
}

// QDomElement QDomNode::toElement()


static void _init_f_toElement_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomElement > ();
}

static void _call_f_toElement_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomElement > ((QDomElement)((QDomNode *)cls)->toElement ());
}

static qt_gsi::GenericMethod *_create_f_toElement_c0 ()
{
  return new qt_gsi::GenericMethod ("toElement", "@brief Method QDomElement QDomNode::toElement()\n", true, &_init_f_toElement_c0, &_call_f_toElement_c0);
}

// QDomEntity QDomNode::toEntity()


static void _init_f_toEntity_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomEntity > ();
}

static void _call_f_toEntity_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomEntity > ((QDomEntity)((QDomNode *)cls)->toEntity ());
}

static qt_gsi::GenericMethod *_create_f_toEntity_c0 ()
{
  return new qt_gsi::GenericMethod ("toEntity", "@brief Method QDomEntity QDomNode::toEntity()\n", true, &_init_f_toEntity_c0, &_call_f_toEntity_c0);
}

// QDomEntityReference QDomNode::toEntityReference()


static void _init_f_toEntityReference_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomEntityReference > ();
}

static void _call_f_toEntityReference_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomEntityReference > ((QDomEntityReference)((QDomNode *)cls)->toEntityReference ());
}

static qt_gsi::GenericMethod *_create_f_toEntityReference_c0 ()
{
  return new qt_gsi::GenericMethod ("toEntityReference", "@brief Method QDomEntityReference QDomNode::toEntityReference()\n", true, &_init_f_toEntityReference_c0, &_call_f_toEntityReference_c0);
}

// QDomNotation QDomNode::toNotation()


static void _init_f_toNotation_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomNotation > ();
}

static void _call_f_toNotation_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomNotation > ((QDomNotation)((QDomNode *)cls)->toNotation ());
}

static qt_gsi::GenericMethod *_create_f_toNotation_c0 ()
{
  return new qt_gsi::GenericMethod ("toNotation", "@brief Method QDomNotation QDomNode::toNotation()\n", true, &_init_f_toNotation_c0, &_call_f_toNotation_c0);
}

// QDomProcessingInstruction QDomNode::toProcessingInstruction()


static void _init_f_toProcessingInstruction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomProcessingInstruction > ();
}

static void _call_f_toProcessingInstruction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomProcessingInstruction > ((QDomProcessingInstruction)((QDomNode *)cls)->toProcessingInstruction ());
}

static qt_gsi::GenericMethod *_create_f_toProcessingInstruction_c0 ()
{
  return new qt_gsi::GenericMethod ("toProcessingInstruction", "@brief Method QDomProcessingInstruction QDomNode::toProcessingInstruction()\n", true, &_init_f_toProcessingInstruction_c0, &_call_f_toProcessingInstruction_c0);
}

// QDomText QDomNode::toText()


static void _init_f_toText_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QDomText > ();
}

static void _call_f_toText_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDomText > ((QDomText)((QDomNode *)cls)->toText ());
}

static qt_gsi::GenericMethod *_create_f_toText_c0 ()
{
  return new qt_gsi::GenericMethod ("toText", "@brief Method QDomText QDomNode::toText()\n", true, &_init_f_toText_c0, &_call_f_toText_c0);
}


namespace gsi
{
gsi::Class<QDomNode> decl_QDomNode ("QDomNode",
  gsi::Methods(_create_ctor_QDomNode_0 ()) +
  gsi::Methods(_create_ctor_QDomNode_2072 ()) +
  gsi::Methods(_create_f_appendChild_2072 ()) +
  gsi::Methods(_create_f_attributes_c0 ()) +
  gsi::Methods(_create_f_childNodes_c0 ()) +
  gsi::Methods(_create_f_clear_0 ()) +
  gsi::Methods(_create_f_cloneNode_c864 ()) +
  gsi::Methods(_create_f_columnNumber_c0 ()) +
  gsi::Methods(_create_f_firstChild_c0 ()) +
  gsi::Methods(_create_f_firstChildElement_c2025 ()) +
  gsi::Methods(_create_f_hasAttributes_c0 ()) +
  gsi::Methods(_create_f_hasChildNodes_c0 ()) +
  gsi::Methods(_create_f_insertAfter_4036 ()) +
  gsi::Methods(_create_f_insertBefore_4036 ()) +
  gsi::Methods(_create_f_isAttr_c0 ()) +
  gsi::Methods(_create_f_isCDATASection_c0 ()) +
  gsi::Methods(_create_f_isCharacterData_c0 ()) +
  gsi::Methods(_create_f_isComment_c0 ()) +
  gsi::Methods(_create_f_isDocument_c0 ()) +
  gsi::Methods(_create_f_isDocumentFragment_c0 ()) +
  gsi::Methods(_create_f_isDocumentType_c0 ()) +
  gsi::Methods(_create_f_isElement_c0 ()) +
  gsi::Methods(_create_f_isEntity_c0 ()) +
  gsi::Methods(_create_f_isEntityReference_c0 ()) +
  gsi::Methods(_create_f_isNotation_c0 ()) +
  gsi::Methods(_create_f_isNull_c0 ()) +
  gsi::Methods(_create_f_isProcessingInstruction_c0 ()) +
  gsi::Methods(_create_f_isSupported_c3942 ()) +
  gsi::Methods(_create_f_isText_c0 ()) +
  gsi::Methods(_create_f_lastChild_c0 ()) +
  gsi::Methods(_create_f_lastChildElement_c2025 ()) +
  gsi::Methods(_create_f_lineNumber_c0 ()) +
  gsi::Methods(_create_f_localName_c0 ()) +
  gsi::Methods(_create_f_namedItem_c2025 ()) +
  gsi::Methods(_create_f_namespaceURI_c0 ()) +
  gsi::Methods(_create_f_nextSibling_c0 ()) +
  gsi::Methods(_create_f_nextSiblingElement_c2025 ()) +
  gsi::Methods(_create_f_nodeName_c0 ()) +
  gsi::Methods(_create_f_nodeType_c0 ()) +
  gsi::Methods(_create_f_nodeValue_c0 ()) +
  gsi::Methods(_create_f_normalize_0 ()) +
  gsi::Methods(_create_f_operator_excl__eq__c2072 ()) +
  gsi::Methods(_create_f_operator_eq__2072 ()) +
  gsi::Methods(_create_f_operator_eq__eq__c2072 ()) +
  gsi::Methods(_create_f_ownerDocument_c0 ()) +
  gsi::Methods(_create_f_parentNode_c0 ()) +
  gsi::Methods(_create_f_prefix_c0 ()) +
  gsi::Methods(_create_f_previousSibling_c0 ()) +
  gsi::Methods(_create_f_previousSiblingElement_c2025 ()) +
  gsi::Methods(_create_f_removeChild_2072 ()) +
  gsi::Methods(_create_f_replaceChild_4036 ()) +
  gsi::Methods(_create_f_save_c2399 ()) +
  gsi::Methods(_create_f_save_c5033 ()) +
  gsi::Methods(_create_f_setNodeValue_2025 ()) +
  gsi::Methods(_create_f_setPrefix_2025 ()) +
  gsi::Methods(_create_f_toAttr_c0 ()) +
  gsi::Methods(_create_f_toCDATASection_c0 ()) +
  gsi::Methods(_create_f_toCharacterData_c0 ()) +
  gsi::Methods(_create_f_toComment_c0 ()) +
  gsi::Methods(_create_f_toDocument_c0 ()) +
  gsi::Methods(_create_f_toDocumentFragment_c0 ()) +
  gsi::Methods(_create_f_toDocumentType_c0 ()) +
  gsi::Methods(_create_f_toElement_c0 ()) +
  gsi::Methods(_create_f_toEntity_c0 ()) +
  gsi::Methods(_create_f_toEntityReference_c0 ()) +
  gsi::Methods(_create_f_toNotation_c0 ()) +
  gsi::Methods(_create_f_toProcessingInstruction_c0 ()) +
  gsi::Methods(_create_f_toText_c0 ()),
  "@qt\n@brief Binding of QDomNode");

}


//  Implementation of the enum wrapper class for QDomNode::EncodingPolicy
namespace qt_gsi
{

static QDomNode_EncodingPolicy_Enum *c_1_QDomNode_EncodingPolicy_Enum () { return new QDomNode_EncodingPolicy_Enum (QDomNode::EncodingFromDocument); }
static QDomNode_EncodingPolicy_Enum *c_2_QDomNode_EncodingPolicy_Enum () { return new QDomNode_EncodingPolicy_Enum (QDomNode::EncodingFromTextStream); }

static gsi::Methods mkdefs_QDomNode_EncodingPolicy () {
  return
    gsi::constant ("EncodingFromDocument", &qt_gsi::c_1_QDomNode_EncodingPolicy_Enum, "@brief Enum constant QDomNode::EncodingFromDocument") +
    gsi::constant ("EncodingFromTextStream", &qt_gsi::c_2_QDomNode_EncodingPolicy_Enum, "@brief Enum constant QDomNode::EncodingFromTextStream");
}

static std::string to_s_QDomNode_EncodingPolicy_Enum (const QDomNode_EncodingPolicy_Enum *e)
{
  if (e->value () == QDomNode::EncodingFromDocument) { return tl::sprintf ("EncodingFromDocument (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::EncodingFromTextStream) { return tl::sprintf ("EncodingFromTextStream (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDomNode_EncodingPolicy_Enum (const QDomNode_EncodingPolicy_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDomNode_EncodingPolicy_Enum *from_i_QDomNode_EncodingPolicy_Enum (unsigned int i)
{
  return new QDomNode_EncodingPolicy_Enum ((QDomNode::EncodingPolicy) i);
}

static bool equalQDomNode_EncodingPolicy_Enum (const QDomNode_EncodingPolicy_Enum *e, QDomNode_EncodingPolicy_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDomNode_EncodingPolicy_Enum (const QDomNode_EncodingPolicy_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDomNode_EncodingPolicy_Enums oropQDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e, const QDomNode_EncodingPolicy_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDomNode_EncodingPolicy_Enums andopQDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e, const QDomNode_EncodingPolicy_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDomNode_EncodingPolicy_Enums xoropQDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e, const QDomNode_EncodingPolicy_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e)
{
  std::string l;
  if (e->testFlag (QDomNode::EncodingFromDocument)) { if (!l.empty ()) l += "|"; l += "EncodingFromDocument"; }
  if (e->testFlag (QDomNode::EncodingFromTextStream)) { if (!l.empty ()) l += "|"; l += "EncodingFromTextStream"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDomNode_EncodingPolicy_Enums (const QDomNode_EncodingPolicy_Enums *e, const QDomNode_EncodingPolicy_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDomNode_EncodingPolicy_Enums> decl_QDomNode_EncodingPolicy_Enums ("QDomNode_QFlags_EncodingPolicy",
  gsi::method_ext ("|", &qt_gsi::oropQDomNode_EncodingPolicy_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDomNode_EncodingPolicy_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDomNode_EncodingPolicy_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDomNode_EncodingPolicy_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDomNode_EncodingPolicy_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDomNode_EncodingPolicy_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDomNode::EncodingPolicy> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDomNode_EncodingPolicy_Enum> decl_QDomNode_EncodingPolicy_Enum (decl_QDomNode_EncodingPolicy_Enums, "QDomNode_EncodingPolicy",
  qt_gsi::mkdefs_QDomNode_EncodingPolicy () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDomNode_EncodingPolicy_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDomNode_EncodingPolicy_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDomNode_EncodingPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDomNode_EncodingPolicy_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDomNode_EncodingPolicy_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDomNode::EncodingPolicy enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDomNode> inject_QDomNode_EncodingPolicy_Enum_in_parent (qt_gsi::mkdefs_QDomNode_EncodingPolicy ());
static gsi::ClassExt<QDomNode> decl_QDomNode_EncodingPolicy_Enum_as_child (decl_QDomNode_EncodingPolicy_Enum, "EncodingPolicy");

}


//  Implementation of the enum wrapper class for QDomNode::NodeType
namespace qt_gsi
{

static QDomNode_NodeType_Enum *c_1_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::ElementNode); }
static QDomNode_NodeType_Enum *c_2_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::AttributeNode); }
static QDomNode_NodeType_Enum *c_3_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::TextNode); }
static QDomNode_NodeType_Enum *c_4_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::CDATASectionNode); }
static QDomNode_NodeType_Enum *c_5_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::EntityReferenceNode); }
static QDomNode_NodeType_Enum *c_6_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::EntityNode); }
static QDomNode_NodeType_Enum *c_7_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::ProcessingInstructionNode); }
static QDomNode_NodeType_Enum *c_8_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::CommentNode); }
static QDomNode_NodeType_Enum *c_9_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::DocumentNode); }
static QDomNode_NodeType_Enum *c_10_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::DocumentTypeNode); }
static QDomNode_NodeType_Enum *c_11_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::DocumentFragmentNode); }
static QDomNode_NodeType_Enum *c_12_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::NotationNode); }
static QDomNode_NodeType_Enum *c_13_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::BaseNode); }
static QDomNode_NodeType_Enum *c_14_QDomNode_NodeType_Enum () { return new QDomNode_NodeType_Enum (QDomNode::CharacterDataNode); }

static gsi::Methods mkdefs_QDomNode_NodeType () {
  return
    gsi::constant ("ElementNode", &qt_gsi::c_1_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::ElementNode") +
    gsi::constant ("AttributeNode", &qt_gsi::c_2_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::AttributeNode") +
    gsi::constant ("TextNode", &qt_gsi::c_3_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::TextNode") +
    gsi::constant ("CDATASectionNode", &qt_gsi::c_4_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::CDATASectionNode") +
    gsi::constant ("EntityReferenceNode", &qt_gsi::c_5_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::EntityReferenceNode") +
    gsi::constant ("EntityNode", &qt_gsi::c_6_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::EntityNode") +
    gsi::constant ("ProcessingInstructionNode", &qt_gsi::c_7_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::ProcessingInstructionNode") +
    gsi::constant ("CommentNode", &qt_gsi::c_8_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::CommentNode") +
    gsi::constant ("DocumentNode", &qt_gsi::c_9_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::DocumentNode") +
    gsi::constant ("DocumentTypeNode", &qt_gsi::c_10_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::DocumentTypeNode") +
    gsi::constant ("DocumentFragmentNode", &qt_gsi::c_11_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::DocumentFragmentNode") +
    gsi::constant ("NotationNode", &qt_gsi::c_12_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::NotationNode") +
    gsi::constant ("BaseNode", &qt_gsi::c_13_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::BaseNode") +
    gsi::constant ("CharacterDataNode", &qt_gsi::c_14_QDomNode_NodeType_Enum, "@brief Enum constant QDomNode::CharacterDataNode");
}

static std::string to_s_QDomNode_NodeType_Enum (const QDomNode_NodeType_Enum *e)
{
  if (e->value () == QDomNode::ElementNode) { return tl::sprintf ("ElementNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::AttributeNode) { return tl::sprintf ("AttributeNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::TextNode) { return tl::sprintf ("TextNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::CDATASectionNode) { return tl::sprintf ("CDATASectionNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::EntityReferenceNode) { return tl::sprintf ("EntityReferenceNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::EntityNode) { return tl::sprintf ("EntityNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::ProcessingInstructionNode) { return tl::sprintf ("ProcessingInstructionNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::CommentNode) { return tl::sprintf ("CommentNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::DocumentNode) { return tl::sprintf ("DocumentNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::DocumentTypeNode) { return tl::sprintf ("DocumentTypeNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::DocumentFragmentNode) { return tl::sprintf ("DocumentFragmentNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::NotationNode) { return tl::sprintf ("NotationNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::BaseNode) { return tl::sprintf ("BaseNode (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDomNode::CharacterDataNode) { return tl::sprintf ("CharacterDataNode (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDomNode_NodeType_Enum (const QDomNode_NodeType_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDomNode_NodeType_Enum *from_i_QDomNode_NodeType_Enum (unsigned int i)
{
  return new QDomNode_NodeType_Enum ((QDomNode::NodeType) i);
}

static bool equalQDomNode_NodeType_Enum (const QDomNode_NodeType_Enum *e, QDomNode_NodeType_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDomNode_NodeType_Enum (const QDomNode_NodeType_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDomNode_NodeType_Enums oropQDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e, const QDomNode_NodeType_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDomNode_NodeType_Enums andopQDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e, const QDomNode_NodeType_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDomNode_NodeType_Enums xoropQDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e, const QDomNode_NodeType_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e)
{
  std::string l;
  if (e->testFlag (QDomNode::ElementNode)) { if (!l.empty ()) l += "|"; l += "ElementNode"; }
  if (e->testFlag (QDomNode::AttributeNode)) { if (!l.empty ()) l += "|"; l += "AttributeNode"; }
  if (e->testFlag (QDomNode::TextNode)) { if (!l.empty ()) l += "|"; l += "TextNode"; }
  if (e->testFlag (QDomNode::CDATASectionNode)) { if (!l.empty ()) l += "|"; l += "CDATASectionNode"; }
  if (e->testFlag (QDomNode::EntityReferenceNode)) { if (!l.empty ()) l += "|"; l += "EntityReferenceNode"; }
  if (e->testFlag (QDomNode::EntityNode)) { if (!l.empty ()) l += "|"; l += "EntityNode"; }
  if (e->testFlag (QDomNode::ProcessingInstructionNode)) { if (!l.empty ()) l += "|"; l += "ProcessingInstructionNode"; }
  if (e->testFlag (QDomNode::CommentNode)) { if (!l.empty ()) l += "|"; l += "CommentNode"; }
  if (e->testFlag (QDomNode::DocumentNode)) { if (!l.empty ()) l += "|"; l += "DocumentNode"; }
  if (e->testFlag (QDomNode::DocumentTypeNode)) { if (!l.empty ()) l += "|"; l += "DocumentTypeNode"; }
  if (e->testFlag (QDomNode::DocumentFragmentNode)) { if (!l.empty ()) l += "|"; l += "DocumentFragmentNode"; }
  if (e->testFlag (QDomNode::NotationNode)) { if (!l.empty ()) l += "|"; l += "NotationNode"; }
  if (e->testFlag (QDomNode::BaseNode)) { if (!l.empty ()) l += "|"; l += "BaseNode"; }
  if (e->testFlag (QDomNode::CharacterDataNode)) { if (!l.empty ()) l += "|"; l += "CharacterDataNode"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDomNode_NodeType_Enums (const QDomNode_NodeType_Enums *e, const QDomNode_NodeType_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDomNode_NodeType_Enums> decl_QDomNode_NodeType_Enums ("QDomNode_QFlags_NodeType",
  gsi::method_ext ("|", &qt_gsi::oropQDomNode_NodeType_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDomNode_NodeType_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDomNode_NodeType_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDomNode_NodeType_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDomNode_NodeType_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDomNode_NodeType_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDomNode::NodeType> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDomNode_NodeType_Enum> decl_QDomNode_NodeType_Enum (decl_QDomNode_NodeType_Enums, "QDomNode_NodeType",
  qt_gsi::mkdefs_QDomNode_NodeType () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDomNode_NodeType_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDomNode_NodeType_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDomNode_NodeType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDomNode_NodeType_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDomNode_NodeType_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDomNode::NodeType enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDomNode> inject_QDomNode_NodeType_Enum_in_parent (qt_gsi::mkdefs_QDomNode_NodeType ());
static gsi::ClassExt<QDomNode> decl_QDomNode_NodeType_Enum_as_child (decl_QDomNode_NodeType_Enum, "NodeType");

}

