
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQDataStream.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtCore.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQDataStream_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QDataStream
  static qint8 f_QDataStream_read_qint8(QDataStream *s)
  {
    qint8 v = 0;
    *s >> v;
    return v;
  }

  static quint8 f_QDataStream_read_quint8(QDataStream *s)
  {
    quint8 v = 0;
    *s >> v;
    return v;
  }

  static qint16 f_QDataStream_read_qint16(QDataStream *s)
  {
    qint16 v = 0;
    *s >> v;
    return v;
  }

  static quint16 f_QDataStream_read_quint16(QDataStream *s)
  {
    quint16 v = 0;
    *s >> v;
    return v;
  }

  static qint32 f_QDataStream_read_qint32(QDataStream *s)
  {
    qint32 v = 0;
    *s >> v;
    return v;
  }

  static quint32 f_QDataStream_read_quint32(QDataStream *s)
  {
    quint32 v = 0;
    *s >> v;
    return v;
  }

  static quint64 f_QDataStream_read_quint64(QDataStream *s)
  {
    quint64 v = 0;
    *s >> v;
    return v;
  }

  static qint64 f_QDataStream_read_qint64(QDataStream *s)
  {
    qint64 v = 0;
    *s >> v;
    return v;
  }

  static double f_QDataStream_read_double(QDataStream *s)
  {
    double v = 0;
    *s >> v;
    return v;
  }

  static float f_QDataStream_read_float(QDataStream *s)
  {
    float v = 0;
    *s >> v;
    return v;
  }

  static bool f_QDataStream_read_bool(QDataStream *s)
  {
    bool v = 0;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<class QChar>::target_type f_QDataStream_read_qchar(QDataStream *s)
  {
    QChar v = 0;
    *s >> v;
    return qt_gsi::Converter<class QChar>::toc (v);
  }

  static qt_gsi::Converter<class QList<int> >::target_type f_QDataStream_read_int_list(QDataStream *s)
  {
    QList<int> v;
    *s >> v;
    return qt_gsi::Converter<class QList<int> >::toc (v);
  }

  static qt_gsi::Converter<class QVector<int> >::target_type f_QDataStream_read_int_vector(QDataStream *s)
  {
    QVector<int> v;
    *s >> v;
    return qt_gsi::Converter<class QVector<int> >::toc (v);
  }

  static QString f_QDataStream_read_string(QDataStream *s)
  {
    QString v;
    *s >> v;
    return v;
  }

  static qt_gsi::Converter<QByteArray>::target_type f_QDataStream_read_bytearray(QDataStream *s)
  {
    QByteArray v;
    *s >> v;
    return qt_gsi::Converter<QByteArray>::toc (v);
  }

  static QDataStream *f_QDataStream_put_qint8(QDataStream *s, qint8 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_quint8(QDataStream *s, quint8 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_qint16(QDataStream *s, qint16 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_quint16(QDataStream *s, quint16 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_qint32(QDataStream *s, qint32 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_quint32(QDataStream *s, quint32 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_qint64(QDataStream *s, qint64 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_quint64(QDataStream *s, quint64 v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_float(QDataStream *s, float v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_double(QDataStream *s, double v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_bool(QDataStream *s, bool v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_qchar(QDataStream *s, const qt_gsi::Converter<class QChar>::target_type &v)
  {
    *s << qt_gsi::Converter<class QChar>::toq (v);
    return s;
  }

  static QDataStream *f_QDataStream_put_int_list(QDataStream *s, const qt_gsi::Converter<class QList<int> >::target_type &v)
  {
    *s << qt_gsi::Converter<class QList<int> >::toq (v);
    return s;
  }

  static QDataStream *f_QDataStream_put_int_vector(QDataStream *s, const qt_gsi::Converter<class QVector<int> >::target_type &v)
  {
    *s << qt_gsi::Converter<class QVector<int> >::toq (v);
    return s;
  }

  static QDataStream *f_QDataStream_put_string(QDataStream *s, const QString &v)
  {
    *s << v;
    return s;
  }

  static QDataStream *f_QDataStream_put_bytearray(QDataStream *s, const qt_gsi::Converter<class QByteArray>::target_type &v)
  {
    *s << qt_gsi::Converter<class QByteArray>::toq (v);
    return s;
  }


// bool QDataStream::atEnd()


static void _init_f_atEnd_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_atEnd_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QDataStream *)cls)->atEnd ());
}

static qt_gsi::GenericMethod *_create_f_atEnd_c0 ()
{
  return new qt_gsi::GenericMethod ("atEnd", "@brief Method bool QDataStream::atEnd()\n", true, &_init_f_atEnd_c0, &_call_f_atEnd_c0);
}

// QDataStream::ByteOrder QDataStream::byteOrder()


static void _init_f_byteOrder_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDataStream::ByteOrder>::target_type > ();
}

static void _call_f_byteOrder_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QDataStream::ByteOrder>::target_type > ((qt_gsi::Converter<QDataStream::ByteOrder>::target_type)qt_gsi::CppToQtAdaptor<QDataStream::ByteOrder>(((QDataStream *)cls)->byteOrder ()));
}

static qt_gsi::GenericMethod *_create_f_byteOrder_c0 ()
{
  return new qt_gsi::GenericMethod (":byteOrder", "@brief Method QDataStream::ByteOrder QDataStream::byteOrder()\n", true, &_init_f_byteOrder_c0, &_call_f_byteOrder_c0);
}

// QIODevice *QDataStream::device()


static void _init_f_device_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QIODevice * > ();
}

static void _call_f_device_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIODevice * > ((QIODevice *)((QDataStream *)cls)->device ());
}

static qt_gsi::GenericMethod *_create_f_device_c0 ()
{
  return new qt_gsi::GenericMethod (":device", "@brief Method QIODevice *QDataStream::device()\n", true, &_init_f_device_c0, &_call_f_device_c0);
}

// QDataStream::FloatingPointPrecision QDataStream::floatingPointPrecision()


static void _init_f_floatingPointPrecision_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type > ();
}

static void _call_f_floatingPointPrecision_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type > ((qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type)qt_gsi::CppToQtAdaptor<QDataStream::FloatingPointPrecision>(((QDataStream *)cls)->floatingPointPrecision ()));
}

static qt_gsi::GenericMethod *_create_f_floatingPointPrecision_c0 ()
{
  return new qt_gsi::GenericMethod (":floatingPointPrecision", "@brief Method QDataStream::FloatingPointPrecision QDataStream::floatingPointPrecision()\n", true, &_init_f_floatingPointPrecision_c0, &_call_f_floatingPointPrecision_c0);
}

// void QDataStream::resetStatus()


static void _init_f_resetStatus_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_resetStatus_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataStream *)cls)->resetStatus ();
}

static qt_gsi::GenericMethod *_create_f_resetStatus_0 ()
{
  return new qt_gsi::GenericMethod ("resetStatus", "@brief Method void QDataStream::resetStatus()\n", false, &_init_f_resetStatus_0, &_call_f_resetStatus_0);
}

// void QDataStream::setByteOrder(QDataStream::ByteOrder)


static void _init_f_setByteOrder_2543 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QDataStream::ByteOrder>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setByteOrder_2543 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDataStream::ByteOrder>::target_type & arg1 = args.read<const qt_gsi::Converter<QDataStream::ByteOrder>::target_type & > ();
  ((QDataStream *)cls)->setByteOrder (qt_gsi::QtToCppAdaptor<QDataStream::ByteOrder>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setByteOrder_2543 ()
{
  return new qt_gsi::GenericMethod ("setByteOrder|byteOrder=", "@brief Method void QDataStream::setByteOrder(QDataStream::ByteOrder)\n", false, &_init_f_setByteOrder_2543, &_call_f_setByteOrder_2543);
}

// void QDataStream::setDevice(QIODevice *)


static void _init_f_setDevice_1447 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDevice_1447 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ((QDataStream *)cls)->setDevice (arg1);
}

static qt_gsi::GenericMethod *_create_f_setDevice_1447 ()
{
  return new qt_gsi::GenericMethod ("setDevice|device=", "@brief Method void QDataStream::setDevice(QIODevice *)\n", false, &_init_f_setDevice_1447, &_call_f_setDevice_1447);
}

// void QDataStream::setFloatingPointPrecision(QDataStream::FloatingPointPrecision precision)


static void _init_f_setFloatingPointPrecision_3913 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("precision");
  decl->add_arg<const qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setFloatingPointPrecision_3913 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type & arg1 = args.read<const qt_gsi::Converter<QDataStream::FloatingPointPrecision>::target_type & > ();
  ((QDataStream *)cls)->setFloatingPointPrecision (qt_gsi::QtToCppAdaptor<QDataStream::FloatingPointPrecision>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setFloatingPointPrecision_3913 ()
{
  return new qt_gsi::GenericMethod ("setFloatingPointPrecision|floatingPointPrecision=", "@brief Method void QDataStream::setFloatingPointPrecision(QDataStream::FloatingPointPrecision precision)\n", false, &_init_f_setFloatingPointPrecision_3913, &_call_f_setFloatingPointPrecision_3913);
}

// void QDataStream::setStatus(QDataStream::Status status)


static void _init_f_setStatus_2275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("status");
  decl->add_arg<const qt_gsi::Converter<QDataStream::Status>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStatus_2275 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QDataStream::Status>::target_type & arg1 = args.read<const qt_gsi::Converter<QDataStream::Status>::target_type & > ();
  ((QDataStream *)cls)->setStatus (qt_gsi::QtToCppAdaptor<QDataStream::Status>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setStatus_2275 ()
{
  return new qt_gsi::GenericMethod ("setStatus|status=", "@brief Method void QDataStream::setStatus(QDataStream::Status status)\n", false, &_init_f_setStatus_2275, &_call_f_setStatus_2275);
}

// void QDataStream::setVersion(int)


static void _init_f_setVersion_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setVersion_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QDataStream *)cls)->setVersion (arg1);
}

static qt_gsi::GenericMethod *_create_f_setVersion_767 ()
{
  return new qt_gsi::GenericMethod ("setVersion|version=", "@brief Method void QDataStream::setVersion(int)\n", false, &_init_f_setVersion_767, &_call_f_setVersion_767);
}

// int QDataStream::skipRawData(int len)


static void _init_f_skipRawData_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("len");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_skipRawData_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QDataStream *)cls)->skipRawData (arg1));
}

static qt_gsi::GenericMethod *_create_f_skipRawData_767 ()
{
  return new qt_gsi::GenericMethod ("skipRawData", "@brief Method int QDataStream::skipRawData(int len)\n", false, &_init_f_skipRawData_767, &_call_f_skipRawData_767);
}

// QDataStream::Status QDataStream::status()


static void _init_f_status_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QDataStream::Status>::target_type > ();
}

static void _call_f_status_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QDataStream::Status>::target_type > ((qt_gsi::Converter<QDataStream::Status>::target_type)qt_gsi::CppToQtAdaptor<QDataStream::Status>(((QDataStream *)cls)->status ()));
}

static qt_gsi::GenericMethod *_create_f_status_c0 ()
{
  return new qt_gsi::GenericMethod (":status", "@brief Method QDataStream::Status QDataStream::status()\n", true, &_init_f_status_c0, &_call_f_status_c0);
}

// void QDataStream::unsetDevice()


static void _init_f_unsetDevice_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_unsetDevice_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QDataStream *)cls)->unsetDevice ();
}

static qt_gsi::GenericMethod *_create_f_unsetDevice_0 ()
{
  return new qt_gsi::GenericMethod ("unsetDevice", "@brief Method void QDataStream::unsetDevice()\n", false, &_init_f_unsetDevice_0, &_call_f_unsetDevice_0);
}

// int QDataStream::version()


static void _init_f_version_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_version_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QDataStream *)cls)->version ());
}

static qt_gsi::GenericMethod *_create_f_version_c0 ()
{
  return new qt_gsi::GenericMethod (":version", "@brief Method int QDataStream::version()\n", true, &_init_f_version_c0, &_call_f_version_c0);
}

// QDataStream &QDataStream::writeBytes(const char *, unsigned int len)


static void _init_f_writeBytes_3395 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<unsigned int > (argspec_1);
  decl->set_return<QDataStream & > ();
}

static void _call_f_writeBytes_3395 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  unsigned int arg2 = args.read<unsigned int > ();
  ret.write<QDataStream & > ((QDataStream &)((QDataStream *)cls)->writeBytes (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_writeBytes_3395 ()
{
  return new qt_gsi::GenericMethod ("writeBytes", "@brief Method QDataStream &QDataStream::writeBytes(const char *, unsigned int len)\n", false, &_init_f_writeBytes_3395, &_call_f_writeBytes_3395);
}

// int QDataStream::writeRawData(const char *, int len)


static void _init_f_writeRawData_2390 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("len");
  decl->add_arg<int > (argspec_1);
  decl->set_return<int > ();
}

static void _call_f_writeRawData_2390 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  int arg2 = args.read<int > ();
  ret.write<int > ((int)((QDataStream *)cls)->writeRawData (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_writeRawData_2390 ()
{
  return new qt_gsi::GenericMethod ("writeRawData", "@brief Method int QDataStream::writeRawData(const char *, int len)\n", false, &_init_f_writeRawData_2390, &_call_f_writeRawData_2390);
}

namespace gsi
{
gsi::Class<QDataStream> decl_QDataStream ("QDataStream_Native",
  gsi::method_ext("read_i8", &f_QDataStream_read_qint8, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui8", &f_QDataStream_read_quint8, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_i16", &f_QDataStream_read_qint16, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui16", &f_QDataStream_read_quint16, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_i32", &f_QDataStream_read_qint32, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui32", &f_QDataStream_read_quint32, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_i64", &f_QDataStream_read_qint64, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ui64", &f_QDataStream_read_quint64, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_d", &f_QDataStream_read_double, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_f", &f_QDataStream_read_float, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_b", &f_QDataStream_read_bool, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_qc", &f_QDataStream_read_qchar, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_il", &f_QDataStream_read_int_list, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_iv", &f_QDataStream_read_int_vector, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_s", &f_QDataStream_read_string, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("read_ba", &f_QDataStream_read_bytearray, "@brief Unambiguous adaptation of the corresponding operator>>") +
  gsi::method_ext("put_i8", &f_QDataStream_put_qint8, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui8", &f_QDataStream_put_quint8, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_i16", &f_QDataStream_put_qint16, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui16", &f_QDataStream_put_quint16, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_i32", &f_QDataStream_put_qint32, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui32", &f_QDataStream_put_quint32, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_i64", &f_QDataStream_put_qint64, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ui64", &f_QDataStream_put_quint64, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_d", &f_QDataStream_put_double, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_f", &f_QDataStream_put_float, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_b", &f_QDataStream_put_bool, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_qc", &f_QDataStream_put_qchar, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_il", &f_QDataStream_put_int_list, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_iv", &f_QDataStream_put_int_vector, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_s", &f_QDataStream_put_string, "@brief Unambiguous adaptation of the corresponding operator<<") +
  gsi::method_ext("put_ba", &f_QDataStream_put_bytearray, "@brief Unambiguous adaptation of the corresponding operator<<") 
+
  gsi::Methods(_create_f_atEnd_c0 ()) +
  gsi::Methods(_create_f_byteOrder_c0 ()) +
  gsi::Methods(_create_f_device_c0 ()) +
  gsi::Methods(_create_f_floatingPointPrecision_c0 ()) +
  gsi::Methods(_create_f_resetStatus_0 ()) +
  gsi::Methods(_create_f_setByteOrder_2543 ()) +
  gsi::Methods(_create_f_setDevice_1447 ()) +
  gsi::Methods(_create_f_setFloatingPointPrecision_3913 ()) +
  gsi::Methods(_create_f_setStatus_2275 ()) +
  gsi::Methods(_create_f_setVersion_767 ()) +
  gsi::Methods(_create_f_skipRawData_767 ()) +
  gsi::Methods(_create_f_status_c0 ()) +
  gsi::Methods(_create_f_unsetDevice_0 ()) +
  gsi::Methods(_create_f_version_c0 ()) +
  gsi::Methods(_create_f_writeBytes_3395 ()) +
  gsi::Methods(_create_f_writeRawData_2390 ()),
  "@hide\n@alias QDataStream");
}


class QDataStream_Adaptor : public QDataStream, public qt_gsi::QtObjectBase
{
public:

  virtual ~QDataStream_Adaptor();

  //  [adaptor ctor] QDataStream::QDataStream()
  QDataStream_Adaptor() : QDataStream()
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDataStream::QDataStream(QIODevice *)
  QDataStream_Adaptor(QIODevice *arg1) : QDataStream(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDataStream::QDataStream(QByteArray *, QFlags<QIODevice::OpenModeFlag> flags)
  QDataStream_Adaptor(QByteArray *arg1, QFlags<QIODevice::OpenModeFlag> flags) : QDataStream(arg1, flags)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QDataStream::QDataStream(const QByteArray &)
  QDataStream_Adaptor(const QByteArray &arg1) : QDataStream(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  
};

QDataStream_Adaptor::~QDataStream_Adaptor() { }

//  Constructor QDataStream::QDataStream() (adaptor class)

static void _init_ctor_QDataStream_Adaptor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QDataStream_Adaptor *> ();
}

static void _call_ctor_QDataStream_Adaptor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDataStream_Adaptor *> (new QDataStream_Adaptor ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDataStream_Adaptor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataStream::QDataStream()\nThis method creates an object of class QDataStream.", &_init_ctor_QDataStream_Adaptor_0, &_call_ctor_QDataStream_Adaptor_0);
}

//  Constructor QDataStream::QDataStream(QIODevice *) (adaptor class)

static void _init_ctor_QDataStream_Adaptor_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QDataStream_Adaptor *> ();
}

static void _call_ctor_QDataStream_Adaptor_1447 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QIODevice *arg1 = args.read<QIODevice * > ();
  ret.write<QDataStream_Adaptor *> (new QDataStream_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDataStream_Adaptor_1447 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataStream::QDataStream(QIODevice *)\nThis method creates an object of class QDataStream.", &_init_ctor_QDataStream_Adaptor_1447, &_call_ctor_QDataStream_Adaptor_1447);
}

//  Constructor QDataStream::QDataStream(QByteArray *, QFlags<QIODevice::OpenModeFlag> flags) (adaptor class)

static void _init_ctor_QDataStream_Adaptor_4752 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QByteArray * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("flags");
  decl->add_arg<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > (argspec_1);
  decl->set_return_new<QDataStream_Adaptor *> ();
}

static void _call_ctor_QDataStream_Adaptor_4752 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QByteArray *arg1 = args.read<QByteArray * > ();
  const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & arg2 = args.read<const qt_gsi::Converter<QFlags<QIODevice::OpenModeFlag> >::target_type & > ();
  ret.write<QDataStream_Adaptor *> (new QDataStream_Adaptor (arg1, qt_gsi::QtToCppAdaptor<QFlags<QIODevice::OpenModeFlag> >(arg2).cref()));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDataStream_Adaptor_4752 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataStream::QDataStream(QByteArray *, QFlags<QIODevice::OpenModeFlag> flags)\nThis method creates an object of class QDataStream.", &_init_ctor_QDataStream_Adaptor_4752, &_call_ctor_QDataStream_Adaptor_4752);
}

//  Constructor QDataStream::QDataStream(const QByteArray &) (adaptor class)

static void _init_ctor_QDataStream_Adaptor_2309 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QByteArray & > (argspec_0);
  decl->set_return_new<QDataStream_Adaptor *> ();
}

static void _call_ctor_QDataStream_Adaptor_2309 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QByteArray &arg1 = args.read<const QByteArray & > ();
  ret.write<QDataStream_Adaptor *> (new QDataStream_Adaptor (arg1));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QDataStream_Adaptor_2309 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QDataStream::QDataStream(const QByteArray &)\nThis method creates an object of class QDataStream.", &_init_ctor_QDataStream_Adaptor_2309, &_call_ctor_QDataStream_Adaptor_2309);
}

namespace gsi
{

extern gsi::Class<QDataStream> decl_QDataStream;

gsi::Class<QDataStream_Adaptor> decl_QDataStream_Adaptor (decl_QDataStream, "QDataStream",
  gsi::Methods(_create_ctor_QDataStream_Adaptor_0 ()) +
  gsi::Methods(_create_ctor_QDataStream_Adaptor_1447 ()) +
  gsi::Methods(_create_ctor_QDataStream_Adaptor_4752 ()) +
  gsi::Methods(_create_ctor_QDataStream_Adaptor_2309 ()),
  "@qt\n@brief Binding of QDataStream");

}


//  Implementation of the enum wrapper class for QDataStream::ByteOrder
namespace qt_gsi
{

static QDataStream_ByteOrder_Enum *c_1_QDataStream_ByteOrder_Enum () { return new QDataStream_ByteOrder_Enum (QDataStream::BigEndian); }
static QDataStream_ByteOrder_Enum *c_2_QDataStream_ByteOrder_Enum () { return new QDataStream_ByteOrder_Enum (QDataStream::LittleEndian); }

static gsi::Methods mkdefs_QDataStream_ByteOrder () {
  return
    gsi::constant ("BigEndian", &qt_gsi::c_1_QDataStream_ByteOrder_Enum, "@brief Enum constant QDataStream::BigEndian") +
    gsi::constant ("LittleEndian", &qt_gsi::c_2_QDataStream_ByteOrder_Enum, "@brief Enum constant QDataStream::LittleEndian");
}

static std::string to_s_QDataStream_ByteOrder_Enum (const QDataStream_ByteOrder_Enum *e)
{
  if (e->value () == QDataStream::BigEndian) { return tl::sprintf ("BigEndian (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDataStream::LittleEndian) { return tl::sprintf ("LittleEndian (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDataStream_ByteOrder_Enum (const QDataStream_ByteOrder_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDataStream_ByteOrder_Enum *from_i_QDataStream_ByteOrder_Enum (unsigned int i)
{
  return new QDataStream_ByteOrder_Enum ((QDataStream::ByteOrder) i);
}

static bool equalQDataStream_ByteOrder_Enum (const QDataStream_ByteOrder_Enum *e, QDataStream_ByteOrder_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDataStream_ByteOrder_Enum (const QDataStream_ByteOrder_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDataStream_ByteOrder_Enums oropQDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e, const QDataStream_ByteOrder_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDataStream_ByteOrder_Enums andopQDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e, const QDataStream_ByteOrder_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDataStream_ByteOrder_Enums xoropQDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e, const QDataStream_ByteOrder_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e)
{
  std::string l;
  if (e->testFlag (QDataStream::BigEndian)) { if (!l.empty ()) l += "|"; l += "BigEndian"; }
  if (e->testFlag (QDataStream::LittleEndian)) { if (!l.empty ()) l += "|"; l += "LittleEndian"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDataStream_ByteOrder_Enums (const QDataStream_ByteOrder_Enums *e, const QDataStream_ByteOrder_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDataStream_ByteOrder_Enums> decl_QDataStream_ByteOrder_Enums ("QDataStream_QFlags_ByteOrder",
  gsi::method_ext ("|", &qt_gsi::oropQDataStream_ByteOrder_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDataStream_ByteOrder_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDataStream_ByteOrder_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_ByteOrder_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_ByteOrder_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDataStream_ByteOrder_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDataStream::ByteOrder> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDataStream_ByteOrder_Enum> decl_QDataStream_ByteOrder_Enum (decl_QDataStream_ByteOrder_Enums, "QDataStream_ByteOrder",
  qt_gsi::mkdefs_QDataStream_ByteOrder () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_ByteOrder_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_ByteOrder_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDataStream_ByteOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDataStream_ByteOrder_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDataStream_ByteOrder_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDataStream::ByteOrder enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDataStream> inject_QDataStream_ByteOrder_Enum_in_parent (qt_gsi::mkdefs_QDataStream_ByteOrder ());
static gsi::ClassExt<QDataStream> decl_QDataStream_ByteOrder_Enum_as_child (decl_QDataStream_ByteOrder_Enum, "ByteOrder");

}


//  Implementation of the enum wrapper class for QDataStream::FloatingPointPrecision
namespace qt_gsi
{

static QDataStream_FloatingPointPrecision_Enum *c_1_QDataStream_FloatingPointPrecision_Enum () { return new QDataStream_FloatingPointPrecision_Enum (QDataStream::SinglePrecision); }
static QDataStream_FloatingPointPrecision_Enum *c_2_QDataStream_FloatingPointPrecision_Enum () { return new QDataStream_FloatingPointPrecision_Enum (QDataStream::DoublePrecision); }

static gsi::Methods mkdefs_QDataStream_FloatingPointPrecision () {
  return
    gsi::constant ("SinglePrecision", &qt_gsi::c_1_QDataStream_FloatingPointPrecision_Enum, "@brief Enum constant QDataStream::SinglePrecision") +
    gsi::constant ("DoublePrecision", &qt_gsi::c_2_QDataStream_FloatingPointPrecision_Enum, "@brief Enum constant QDataStream::DoublePrecision");
}

static std::string to_s_QDataStream_FloatingPointPrecision_Enum (const QDataStream_FloatingPointPrecision_Enum *e)
{
  if (e->value () == QDataStream::SinglePrecision) { return tl::sprintf ("SinglePrecision (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDataStream::DoublePrecision) { return tl::sprintf ("DoublePrecision (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDataStream_FloatingPointPrecision_Enum (const QDataStream_FloatingPointPrecision_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDataStream_FloatingPointPrecision_Enum *from_i_QDataStream_FloatingPointPrecision_Enum (unsigned int i)
{
  return new QDataStream_FloatingPointPrecision_Enum ((QDataStream::FloatingPointPrecision) i);
}

static bool equalQDataStream_FloatingPointPrecision_Enum (const QDataStream_FloatingPointPrecision_Enum *e, QDataStream_FloatingPointPrecision_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDataStream_FloatingPointPrecision_Enum (const QDataStream_FloatingPointPrecision_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDataStream_FloatingPointPrecision_Enums oropQDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e, const QDataStream_FloatingPointPrecision_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDataStream_FloatingPointPrecision_Enums andopQDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e, const QDataStream_FloatingPointPrecision_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDataStream_FloatingPointPrecision_Enums xoropQDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e, const QDataStream_FloatingPointPrecision_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e)
{
  std::string l;
  if (e->testFlag (QDataStream::SinglePrecision)) { if (!l.empty ()) l += "|"; l += "SinglePrecision"; }
  if (e->testFlag (QDataStream::DoublePrecision)) { if (!l.empty ()) l += "|"; l += "DoublePrecision"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDataStream_FloatingPointPrecision_Enums (const QDataStream_FloatingPointPrecision_Enums *e, const QDataStream_FloatingPointPrecision_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDataStream_FloatingPointPrecision_Enums> decl_QDataStream_FloatingPointPrecision_Enums ("QDataStream_QFlags_FloatingPointPrecision",
  gsi::method_ext ("|", &qt_gsi::oropQDataStream_FloatingPointPrecision_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDataStream_FloatingPointPrecision_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDataStream_FloatingPointPrecision_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_FloatingPointPrecision_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_FloatingPointPrecision_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDataStream_FloatingPointPrecision_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDataStream::FloatingPointPrecision> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDataStream_FloatingPointPrecision_Enum> decl_QDataStream_FloatingPointPrecision_Enum (decl_QDataStream_FloatingPointPrecision_Enums, "QDataStream_FloatingPointPrecision",
  qt_gsi::mkdefs_QDataStream_FloatingPointPrecision () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_FloatingPointPrecision_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_FloatingPointPrecision_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDataStream_FloatingPointPrecision_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDataStream_FloatingPointPrecision_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDataStream_FloatingPointPrecision_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDataStream::FloatingPointPrecision enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDataStream> inject_QDataStream_FloatingPointPrecision_Enum_in_parent (qt_gsi::mkdefs_QDataStream_FloatingPointPrecision ());
static gsi::ClassExt<QDataStream> decl_QDataStream_FloatingPointPrecision_Enum_as_child (decl_QDataStream_FloatingPointPrecision_Enum, "FloatingPointPrecision");

}


//  Implementation of the enum wrapper class for QDataStream::Status
namespace qt_gsi
{

static QDataStream_Status_Enum *c_1_QDataStream_Status_Enum () { return new QDataStream_Status_Enum (QDataStream::Ok); }
static QDataStream_Status_Enum *c_2_QDataStream_Status_Enum () { return new QDataStream_Status_Enum (QDataStream::ReadPastEnd); }
static QDataStream_Status_Enum *c_3_QDataStream_Status_Enum () { return new QDataStream_Status_Enum (QDataStream::ReadCorruptData); }

static gsi::Methods mkdefs_QDataStream_Status () {
  return
    gsi::constant ("Ok", &qt_gsi::c_1_QDataStream_Status_Enum, "@brief Enum constant QDataStream::Ok") +
    gsi::constant ("ReadPastEnd", &qt_gsi::c_2_QDataStream_Status_Enum, "@brief Enum constant QDataStream::ReadPastEnd") +
    gsi::constant ("ReadCorruptData", &qt_gsi::c_3_QDataStream_Status_Enum, "@brief Enum constant QDataStream::ReadCorruptData");
}

static std::string to_s_QDataStream_Status_Enum (const QDataStream_Status_Enum *e)
{
  if (e->value () == QDataStream::Ok) { return tl::sprintf ("Ok (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDataStream::ReadPastEnd) { return tl::sprintf ("ReadPastEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QDataStream::ReadCorruptData) { return tl::sprintf ("ReadCorruptData (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QDataStream_Status_Enum (const QDataStream_Status_Enum *e)
{
  return (unsigned int) e->value ();
}

static QDataStream_Status_Enum *from_i_QDataStream_Status_Enum (unsigned int i)
{
  return new QDataStream_Status_Enum ((QDataStream::Status) i);
}

static bool equalQDataStream_Status_Enum (const QDataStream_Status_Enum *e, QDataStream_Status_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QDataStream_Status_Enum (const QDataStream_Status_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QDataStream_Status_Enums oropQDataStream_Status_Enums (const QDataStream_Status_Enums *e, const QDataStream_Status_Enums &d)
{
  return e->flags () | d.flags ();
}

static QDataStream_Status_Enums andopQDataStream_Status_Enums (const QDataStream_Status_Enums *e, const QDataStream_Status_Enums &d)
{
  return e->flags () & d.flags ();
}

static QDataStream_Status_Enums xoropQDataStream_Status_Enums (const QDataStream_Status_Enums *e, const QDataStream_Status_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QDataStream_Status_Enums (const QDataStream_Status_Enums *e)
{
  std::string l;
  if (e->testFlag (QDataStream::Ok)) { if (!l.empty ()) l += "|"; l += "Ok"; }
  if (e->testFlag (QDataStream::ReadPastEnd)) { if (!l.empty ()) l += "|"; l += "ReadPastEnd"; }
  if (e->testFlag (QDataStream::ReadCorruptData)) { if (!l.empty ()) l += "|"; l += "ReadCorruptData"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QDataStream_Status_Enums (const QDataStream_Status_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QDataStream_Status_Enums (const QDataStream_Status_Enums *e, const QDataStream_Status_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QDataStream_Status_Enums> decl_QDataStream_Status_Enums ("QDataStream_QFlags_Status",
  gsi::method_ext ("|", &qt_gsi::oropQDataStream_Status_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQDataStream_Status_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQDataStream_Status_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_Status_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_Status_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QDataStream_Status_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QDataStream::Status> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QDataStream_Status_Enum> decl_QDataStream_Status_Enum (decl_QDataStream_Status_Enums, "QDataStream_Status",
  qt_gsi::mkdefs_QDataStream_Status () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QDataStream_Status_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QDataStream_Status_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQDataStream_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QDataStream_Status_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QDataStream_Status_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QDataStream::Status enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QDataStream> inject_QDataStream_Status_Enum_in_parent (qt_gsi::mkdefs_QDataStream_Status ());
static gsi::ClassExt<QDataStream> decl_QDataStream_Status_Enum_as_child (decl_QDataStream_Status_Enum, "Status");

}

