
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQBoxLayout.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQBoxLayout_EventAdaptor.h"
#include "gsiDeclQBoxLayout_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QBoxLayout

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QBoxLayout::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}

// void QBoxLayout::addItem(QLayoutItem *)


static void _init_f_addItem_1740 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addItem_1740 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QBoxLayout *)cls)->addItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addItem_1740 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Method void QBoxLayout::addItem(QLayoutItem *)\nThis is a reimplementation of QLayout::addItem", false, &_init_f_addItem_1740, &_call_f_addItem_1740);
}

// void QBoxLayout::addLayout(QLayout *layout, int stretch)


static void _init_f_addLayout_2000 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("layout");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_addLayout_2000 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  int arg2 = args ? args.read<int > () : (int)(0);
  ((QBoxLayout *)cls)->addLayout (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_addLayout_2000 ()
{
  return new qt_gsi::GenericMethod ("addLayout", "@brief Method void QBoxLayout::addLayout(QLayout *layout, int stretch)\n", false, &_init_f_addLayout_2000, &_call_f_addLayout_2000);
}

// void QBoxLayout::addSpacerItem(QSpacerItem *spacerItem)


static void _init_f_addSpacerItem_1708 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacerItem");
  decl->add_arg<QSpacerItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addSpacerItem_1708 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QSpacerItem *arg1 = args.read<QSpacerItem * > ();
  ((QBoxLayout *)cls)->addSpacerItem (arg1);
}

static qt_gsi::GenericMethod *_create_f_addSpacerItem_1708 ()
{
  return new qt_gsi::GenericMethod ("addSpacerItem", "@brief Method void QBoxLayout::addSpacerItem(QSpacerItem *spacerItem)\n", false, &_init_f_addSpacerItem_1708, &_call_f_addSpacerItem_1708);
}

// void QBoxLayout::addSpacing(int size)


static void _init_f_addSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QBoxLayout *)cls)->addSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_addSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("addSpacing", "@brief Method void QBoxLayout::addSpacing(int size)\n", false, &_init_f_addSpacing_767, &_call_f_addSpacing_767);
}

// void QBoxLayout::addStretch(int stretch)


static void _init_f_addStretch_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("stretch", true, "0");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addStretch_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args ? args.read<int > () : (int)(0);
  ((QBoxLayout *)cls)->addStretch (arg1);
}

static qt_gsi::GenericMethod *_create_f_addStretch_767 ()
{
  return new qt_gsi::GenericMethod ("addStretch", "@brief Method void QBoxLayout::addStretch(int stretch)\n", false, &_init_f_addStretch_767, &_call_f_addStretch_767);
}

// void QBoxLayout::addStrut(int)


static void _init_f_addStrut_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_addStrut_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QBoxLayout *)cls)->addStrut (arg1);
}

static qt_gsi::GenericMethod *_create_f_addStrut_767 ()
{
  return new qt_gsi::GenericMethod ("addStrut", "@brief Method void QBoxLayout::addStrut(int)\n", false, &_init_f_addStrut_767, &_call_f_addStrut_767);
}

// void QBoxLayout::addWidget(QWidget *, int stretch, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_addWidget_4616 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch", true, "0");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("alignment", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_addWidget_4616 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg3 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::AlignmentFlag> >(heap, 0));
  ((QBoxLayout *)cls)->addWidget (arg1, arg2, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg3).cref());
}

static qt_gsi::GenericMethod *_create_f_addWidget_4616 ()
{
  return new qt_gsi::GenericMethod ("addWidget", "@brief Method void QBoxLayout::addWidget(QWidget *, int stretch, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_addWidget_4616, &_call_f_addWidget_4616);
}

// int QBoxLayout::count()


static void _init_f_count_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_count_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QBoxLayout *)cls)->count ());
}

static qt_gsi::GenericMethod *_create_f_count_c0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Method int QBoxLayout::count()\nThis is a reimplementation of QLayout::count", true, &_init_f_count_c0, &_call_f_count_c0);
}

// QBoxLayout::Direction QBoxLayout::direction()


static void _init_f_direction_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QBoxLayout::Direction>::target_type > ();
}

static void _call_f_direction_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QBoxLayout::Direction>::target_type > ((qt_gsi::Converter<QBoxLayout::Direction>::target_type)qt_gsi::CppToQtAdaptor<QBoxLayout::Direction>(((QBoxLayout *)cls)->direction ()));
}

static qt_gsi::GenericMethod *_create_f_direction_c0 ()
{
  return new qt_gsi::GenericMethod (":direction", "@brief Method QBoxLayout::Direction QBoxLayout::direction()\n", true, &_init_f_direction_c0, &_call_f_direction_c0);
}

// QFlags<Qt::Orientation> QBoxLayout::expandingDirections()


static void _init_f_expandingDirections_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_f_expandingDirections_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(((QBoxLayout *)cls)->expandingDirections ()));
}

static qt_gsi::GenericMethod *_create_f_expandingDirections_c0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Method QFlags<Qt::Orientation> QBoxLayout::expandingDirections()\nThis is a reimplementation of QLayout::expandingDirections", true, &_init_f_expandingDirections_c0, &_call_f_expandingDirections_c0);
}

// bool QBoxLayout::hasHeightForWidth()


static void _init_f_hasHeightForWidth_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_hasHeightForWidth_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QBoxLayout *)cls)->hasHeightForWidth ());
}

static qt_gsi::GenericMethod *_create_f_hasHeightForWidth_c0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Method bool QBoxLayout::hasHeightForWidth()\nThis is a reimplementation of QLayoutItem::hasHeightForWidth", true, &_init_f_hasHeightForWidth_c0, &_call_f_hasHeightForWidth_c0);
}

// int QBoxLayout::heightForWidth(int)


static void _init_f_heightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_heightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QBoxLayout *)cls)->heightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_heightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Method int QBoxLayout::heightForWidth(int)\nThis is a reimplementation of QLayoutItem::heightForWidth", true, &_init_f_heightForWidth_c767, &_call_f_heightForWidth_c767);
}

// void QBoxLayout::insertLayout(int index, QLayout *layout, int stretch)


static void _init_f_insertLayout_2659 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("layout");
  decl->add_arg<QLayout * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("stretch", true, "0");
  decl->add_arg<int > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_insertLayout_2659 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QLayout *arg2 = args.read<QLayout * > ();
  int arg3 = args ? args.read<int > () : (int)(0);
  ((QBoxLayout *)cls)->insertLayout (arg1, arg2, arg3);
}

static qt_gsi::GenericMethod *_create_f_insertLayout_2659 ()
{
  return new qt_gsi::GenericMethod ("insertLayout", "@brief Method void QBoxLayout::insertLayout(int index, QLayout *layout, int stretch)\n", false, &_init_f_insertLayout_2659, &_call_f_insertLayout_2659);
}

// void QBoxLayout::insertSpacerItem(int index, QSpacerItem *spacerItem)


static void _init_f_insertSpacerItem_2367 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("spacerItem");
  decl->add_arg<QSpacerItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSpacerItem_2367 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QSpacerItem *arg2 = args.read<QSpacerItem * > ();
  ((QBoxLayout *)cls)->insertSpacerItem (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertSpacerItem_2367 ()
{
  return new qt_gsi::GenericMethod ("insertSpacerItem", "@brief Method void QBoxLayout::insertSpacerItem(int index, QSpacerItem *spacerItem)\n", false, &_init_f_insertSpacerItem_2367, &_call_f_insertSpacerItem_2367);
}

// void QBoxLayout::insertSpacing(int index, int size)


static void _init_f_insertSpacing_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("size");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertSpacing_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QBoxLayout *)cls)->insertSpacing (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertSpacing_1426 ()
{
  return new qt_gsi::GenericMethod ("insertSpacing", "@brief Method void QBoxLayout::insertSpacing(int index, int size)\n", false, &_init_f_insertSpacing_1426, &_call_f_insertSpacing_1426);
}

// void QBoxLayout::insertStretch(int index, int stretch)


static void _init_f_insertStretch_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_insertStretch_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  ((QBoxLayout *)cls)->insertStretch (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_insertStretch_1426 ()
{
  return new qt_gsi::GenericMethod ("insertStretch", "@brief Method void QBoxLayout::insertStretch(int index, int stretch)\n", false, &_init_f_insertStretch_1426, &_call_f_insertStretch_1426);
}

// void QBoxLayout::insertWidget(int index, QWidget *widget, int stretch, QFlags<Qt::AlignmentFlag> alignment)


static void _init_f_insertWidget_5275 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("widget");
  decl->add_arg<QWidget * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("stretch", true, "0");
  decl->add_arg<int > (argspec_2);
  static gsi::ArgSpecBase argspec_3 ("alignment", true, "0");
  decl->add_arg<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > (argspec_3);
  decl->set_return<void > ();
}

static void _call_f_insertWidget_5275 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QWidget *arg2 = args.read<QWidget * > ();
  int arg3 = args ? args.read<int > () : (int)(0);
  tl::Heap heap;
  const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & arg4 = args ? args.read<const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type & > () : (const qt_gsi::Converter<QFlags<Qt::AlignmentFlag> >::target_type &)(qt_gsi::CppToQtReadAdaptor<QFlags<Qt::AlignmentFlag> >(heap, 0));
  ((QBoxLayout *)cls)->insertWidget (arg1, arg2, arg3, qt_gsi::QtToCppAdaptor<QFlags<Qt::AlignmentFlag> >(arg4).cref());
}

static qt_gsi::GenericMethod *_create_f_insertWidget_5275 ()
{
  return new qt_gsi::GenericMethod ("insertWidget", "@brief Method void QBoxLayout::insertWidget(int index, QWidget *widget, int stretch, QFlags<Qt::AlignmentFlag> alignment)\n", false, &_init_f_insertWidget_5275, &_call_f_insertWidget_5275);
}

// void QBoxLayout::invalidate()


static void _init_f_invalidate_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_invalidate_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QBoxLayout *)cls)->invalidate ();
}

static qt_gsi::GenericMethod *_create_f_invalidate_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Method void QBoxLayout::invalidate()\nThis is a reimplementation of QLayout::invalidate", false, &_init_f_invalidate_0, &_call_f_invalidate_0);
}

// QLayoutItem *QBoxLayout::itemAt(int)


static void _init_f_itemAt_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_f_itemAt_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QBoxLayout *)cls)->itemAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_itemAt_c767 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Method QLayoutItem *QBoxLayout::itemAt(int)\nThis is a reimplementation of QLayout::itemAt", true, &_init_f_itemAt_c767, &_call_f_itemAt_c767);
}

// QSize QBoxLayout::maximumSize()


static void _init_f_maximumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_maximumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout *)cls)->maximumSize ());
}

static qt_gsi::GenericMethod *_create_f_maximumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Method QSize QBoxLayout::maximumSize()\nThis is a reimplementation of QLayout::maximumSize", true, &_init_f_maximumSize_c0, &_call_f_maximumSize_c0);
}

// int QBoxLayout::minimumHeightForWidth(int)


static void _init_f_minimumHeightForWidth_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_minimumHeightForWidth_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QBoxLayout *)cls)->minimumHeightForWidth (arg1));
}

static qt_gsi::GenericMethod *_create_f_minimumHeightForWidth_c767 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Method int QBoxLayout::minimumHeightForWidth(int)\nThis is a reimplementation of QLayoutItem::minimumHeightForWidth", true, &_init_f_minimumHeightForWidth_c767, &_call_f_minimumHeightForWidth_c767);
}

// QSize QBoxLayout::minimumSize()


static void _init_f_minimumSize_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_minimumSize_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout *)cls)->minimumSize ());
}

static qt_gsi::GenericMethod *_create_f_minimumSize_c0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Method QSize QBoxLayout::minimumSize()\nThis is a reimplementation of QLayout::minimumSize", true, &_init_f_minimumSize_c0, &_call_f_minimumSize_c0);
}

// void QBoxLayout::setDirection(QBoxLayout::Direction)


static void _init_f_setDirection_2497 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QBoxLayout::Direction>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDirection_2497 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QBoxLayout::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QBoxLayout::Direction>::target_type & > ();
  ((QBoxLayout *)cls)->setDirection (qt_gsi::QtToCppAdaptor<QBoxLayout::Direction>(arg1).cref());
}

static qt_gsi::GenericMethod *_create_f_setDirection_2497 ()
{
  return new qt_gsi::GenericMethod ("setDirection|direction=", "@brief Method void QBoxLayout::setDirection(QBoxLayout::Direction)\n", false, &_init_f_setDirection_2497, &_call_f_setDirection_2497);
}

// void QBoxLayout::setGeometry(const QRect &)


static void _init_f_setGeometry_1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGeometry_1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QBoxLayout *)cls)->setGeometry (arg1);
}

static qt_gsi::GenericMethod *_create_f_setGeometry_1792 ()
{
  return new qt_gsi::GenericMethod ("setGeometry|geometry=", "@brief Method void QBoxLayout::setGeometry(const QRect &)\nThis is a reimplementation of QLayout::setGeometry", false, &_init_f_setGeometry_1792, &_call_f_setGeometry_1792);
}

// void QBoxLayout::setSpacing(int spacing)


static void _init_f_setSpacing_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("spacing");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setSpacing_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ((QBoxLayout *)cls)->setSpacing (arg1);
}

static qt_gsi::GenericMethod *_create_f_setSpacing_767 ()
{
  return new qt_gsi::GenericMethod ("setSpacing|spacing=", "@brief Method void QBoxLayout::setSpacing(int spacing)\n", false, &_init_f_setSpacing_767, &_call_f_setSpacing_767);
}

// void QBoxLayout::setStretch(int index, int stretch)


static void _init_f_setStretch_1426 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setStretch_1426 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ((QBoxLayout *)cls)->setStretch (arg1, arg2);
}

static qt_gsi::GenericMethod *_create_f_setStretch_1426 ()
{
  return new qt_gsi::GenericMethod ("setStretch", "@brief Method void QBoxLayout::setStretch(int index, int stretch)\n", false, &_init_f_setStretch_1426, &_call_f_setStretch_1426);
}

// bool QBoxLayout::setStretchFactor(QWidget *w, int stretch)


static void _init_f_setStretchFactor_1974 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setStretchFactor_1974 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args.read<int > ();
  ret.write<bool > ((bool)((QBoxLayout *)cls)->setStretchFactor (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_setStretchFactor_1974 ()
{
  return new qt_gsi::GenericMethod ("setStretchFactor", "@brief Method bool QBoxLayout::setStretchFactor(QWidget *w, int stretch)\n", false, &_init_f_setStretchFactor_1974, &_call_f_setStretchFactor_1974);
}

// bool QBoxLayout::setStretchFactor(QLayout *l, int stretch)


static void _init_f_setStretchFactor_2000 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("stretch");
  decl->add_arg<int > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_setStretchFactor_2000 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  int arg2 = args.read<int > ();
  ret.write<bool > ((bool)((QBoxLayout *)cls)->setStretchFactor (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_setStretchFactor_2000 ()
{
  return new qt_gsi::GenericMethod ("setStretchFactor", "@brief Method bool QBoxLayout::setStretchFactor(QLayout *l, int stretch)\n", false, &_init_f_setStretchFactor_2000, &_call_f_setStretchFactor_2000);
}

// QSize QBoxLayout::sizeHint()


static void _init_f_sizeHint_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_sizeHint_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout *)cls)->sizeHint ());
}

static qt_gsi::GenericMethod *_create_f_sizeHint_c0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Method QSize QBoxLayout::sizeHint()\nThis is a reimplementation of QLayoutItem::sizeHint", true, &_init_f_sizeHint_c0, &_call_f_sizeHint_c0);
}

// int QBoxLayout::spacing()


static void _init_f_spacing_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_spacing_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QBoxLayout *)cls)->spacing ());
}

static qt_gsi::GenericMethod *_create_f_spacing_c0 ()
{
  return new qt_gsi::GenericMethod (":spacing", "@brief Method int QBoxLayout::spacing()\n", true, &_init_f_spacing_c0, &_call_f_spacing_c0);
}

// int QBoxLayout::stretch(int index)


static void _init_f_stretch_c767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_f_stretch_c767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QBoxLayout *)cls)->stretch (arg1));
}

static qt_gsi::GenericMethod *_create_f_stretch_c767 ()
{
  return new qt_gsi::GenericMethod ("stretch", "@brief Method int QBoxLayout::stretch(int index)\n", true, &_init_f_stretch_c767, &_call_f_stretch_c767);
}

// QLayoutItem *QBoxLayout::takeAt(int)


static void _init_f_takeAt_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return_new<QLayoutItem * > ();
}

static void _call_f_takeAt_767 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QBoxLayout *)cls)->takeAt (arg1));
}

static qt_gsi::GenericMethod *_create_f_takeAt_767 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Method QLayoutItem *QBoxLayout::takeAt(int)\nThis is a reimplementation of QLayout::takeAt", false, &_init_f_takeAt_767, &_call_f_takeAt_767);
}

// static QString QBoxLayout::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QBoxLayout::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QBoxLayout::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QBoxLayout::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QBoxLayout::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QBoxLayout::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QBoxLayout::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QBoxLayout::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QBoxLayout::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QBoxLayout::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QBoxLayout::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QBoxLayout::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

static qt_gsi::QObjectConnector<QBoxLayout, QBoxLayout_EventAdaptor> ea_QBoxLayout;

namespace gsi
{
extern gsi::Class<QLayout> decl_QLayout;

gsi::Class<QBoxLayout> decl_QBoxLayout (ea_QBoxLayout, decl_QLayout, "QBoxLayout_Native",
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_addItem_1740 ()) +
  gsi::Methods(_create_f_addLayout_2000 ()) +
  gsi::Methods(_create_f_addSpacerItem_1708 ()) +
  gsi::Methods(_create_f_addSpacing_767 ()) +
  gsi::Methods(_create_f_addStretch_767 ()) +
  gsi::Methods(_create_f_addStrut_767 ()) +
  gsi::Methods(_create_f_addWidget_4616 ()) +
  gsi::Methods(_create_f_count_c0 ()) +
  gsi::Methods(_create_f_direction_c0 ()) +
  gsi::Methods(_create_f_expandingDirections_c0 ()) +
  gsi::Methods(_create_f_hasHeightForWidth_c0 ()) +
  gsi::Methods(_create_f_heightForWidth_c767 ()) +
  gsi::Methods(_create_f_insertLayout_2659 ()) +
  gsi::Methods(_create_f_insertSpacerItem_2367 ()) +
  gsi::Methods(_create_f_insertSpacing_1426 ()) +
  gsi::Methods(_create_f_insertStretch_1426 ()) +
  gsi::Methods(_create_f_insertWidget_5275 ()) +
  gsi::Methods(_create_f_invalidate_0 ()) +
  gsi::Methods(_create_f_itemAt_c767 ()) +
  gsi::Methods(_create_f_maximumSize_c0 ()) +
  gsi::Methods(_create_f_minimumHeightForWidth_c767 ()) +
  gsi::Methods(_create_f_minimumSize_c0 ()) +
  gsi::Methods(_create_f_setDirection_2497 ()) +
  gsi::Methods(_create_f_setGeometry_1792 ()) +
  gsi::Methods(_create_f_setSpacing_767 ()) +
  gsi::Methods(_create_f_setStretch_1426 ()) +
  gsi::Methods(_create_f_setStretchFactor_1974 ()) +
  gsi::Methods(_create_f_setStretchFactor_2000 ()) +
  gsi::Methods(_create_f_sizeHint_c0 ()) +
  gsi::Methods(_create_f_spacing_c0 ()) +
  gsi::Methods(_create_f_stretch_c767 ()) +
  gsi::Methods(_create_f_takeAt_767 ()) +
  qt_gsi::qt_signal<QBoxLayout, QBoxLayout_EventAdaptor, QObject *> ("destroyed", &QBoxLayout_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QBoxLayout::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()),
  "@hide\n@alias QBoxLayout");
}


class QBoxLayout_Adaptor : public QBoxLayout, public qt_gsi::QtObjectBase
{
public:

  virtual ~QBoxLayout_Adaptor();

  //  [adaptor ctor] QBoxLayout::QBoxLayout(QBoxLayout::Direction, QWidget *parent)
  QBoxLayout_Adaptor(QBoxLayout::Direction arg1) : QBoxLayout(arg1)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QBoxLayout::QBoxLayout(QBoxLayout::Direction, QWidget *parent)
  QBoxLayout_Adaptor(QBoxLayout::Direction arg1, QWidget *parent) : QBoxLayout(arg1, parent)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  void QBoxLayout::addChildLayout(QLayout *l)
  void fp_QBoxLayout_addChildLayout_1341 (QLayout *l) {
    QBoxLayout::addChildLayout(l);
  }

  //  void QBoxLayout::addChildWidget(QWidget *w)
  void fp_QBoxLayout_addChildWidget_1315 (QWidget *w) {
    QBoxLayout::addChildWidget(w);
  }

  //  QRect QBoxLayout::alignmentRect(const QRect &)
  QRect fp_QBoxLayout_alignmentRect_c1792 (const QRect &arg1) const {
    return QBoxLayout::alignmentRect(arg1);
  }

  //  void QBoxLayout::insertItem(int index, QLayoutItem *)
  void fp_QBoxLayout_insertItem_2399 (int index, QLayoutItem *arg2) {
    QBoxLayout::insertItem(index, arg2);
  }

  //  int QBoxLayout::receivers(const char *signal)
  int fp_QBoxLayout_receivers_c1731 (const char *signal) const {
    return QBoxLayout::receivers(signal);
  }

  //  QObject *QBoxLayout::sender()
  QObject * fp_QBoxLayout_sender_c0 () const {
    return QBoxLayout::sender();
  }

  //  void QBoxLayout::widgetEvent(QEvent *)
  void fp_QBoxLayout_widgetEvent_1217 (QEvent *arg1) {
    QBoxLayout::widgetEvent(arg1);
  }

  //  [adaptor impl] void QBoxLayout::addItem(QLayoutItem *)
  void cbs_addItem_1740_0(QLayoutItem *arg1)
  {
    QBoxLayout::addItem(arg1);
  }

  virtual void addItem(QLayoutItem *arg1)
  {
    if (cb_addItem_1740_0.can_issue()) {
      cb_addItem_1740_0.issue<QBoxLayout_Adaptor, QLayoutItem *>(&QBoxLayout_Adaptor::cbs_addItem_1740_0, arg1);
    } else {
      QBoxLayout::addItem(arg1);
    }
  }

  //  [adaptor impl] int QBoxLayout::count()
  int cbs_count_c0_0() const
  {
    return QBoxLayout::count();
  }

  virtual int count() const
  {
    if (cb_count_c0_0.can_issue()) {
      return cb_count_c0_0.issue<QBoxLayout_Adaptor, int>(&QBoxLayout_Adaptor::cbs_count_c0_0);
    } else {
      return QBoxLayout::count();
    }
  }

  //  [adaptor impl] bool QBoxLayout::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QBoxLayout::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QBoxLayout_Adaptor, bool, QEvent *>(&QBoxLayout_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QBoxLayout::event(arg1);
    }
  }

  //  [adaptor impl] bool QBoxLayout::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QBoxLayout::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QBoxLayout_Adaptor, bool, QObject *, QEvent *>(&QBoxLayout_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QBoxLayout::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] QFlags<Qt::Orientation> QBoxLayout::expandingDirections()
  qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type cbs_expandingDirections_c0_0() const
  {
    return qt_gsi::CppToQtAdaptor<QFlags<Qt::Orientation> >(QBoxLayout::expandingDirections());
  }

  virtual QFlags<Qt::Orientation> expandingDirections() const
  {
    if (cb_expandingDirections_c0_0.can_issue()) {
      return qt_gsi::QtToCppAdaptor<QFlags<Qt::Orientation> >(cb_expandingDirections_c0_0.issue<QBoxLayout_Adaptor, qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type>(&QBoxLayout_Adaptor::cbs_expandingDirections_c0_0)).cref();
    } else {
      return QBoxLayout::expandingDirections();
    }
  }

  //  [adaptor impl] QRect QBoxLayout::geometry()
  QRect cbs_geometry_c0_0() const
  {
    return QBoxLayout::geometry();
  }

  virtual QRect geometry() const
  {
    if (cb_geometry_c0_0.can_issue()) {
      return cb_geometry_c0_0.issue<QBoxLayout_Adaptor, QRect>(&QBoxLayout_Adaptor::cbs_geometry_c0_0);
    } else {
      return QBoxLayout::geometry();
    }
  }

  //  [adaptor impl] bool QBoxLayout::hasHeightForWidth()
  bool cbs_hasHeightForWidth_c0_0() const
  {
    return QBoxLayout::hasHeightForWidth();
  }

  virtual bool hasHeightForWidth() const
  {
    if (cb_hasHeightForWidth_c0_0.can_issue()) {
      return cb_hasHeightForWidth_c0_0.issue<QBoxLayout_Adaptor, bool>(&QBoxLayout_Adaptor::cbs_hasHeightForWidth_c0_0);
    } else {
      return QBoxLayout::hasHeightForWidth();
    }
  }

  //  [adaptor impl] int QBoxLayout::heightForWidth(int)
  int cbs_heightForWidth_c767_0(int arg1) const
  {
    return QBoxLayout::heightForWidth(arg1);
  }

  virtual int heightForWidth(int arg1) const
  {
    if (cb_heightForWidth_c767_0.can_issue()) {
      return cb_heightForWidth_c767_0.issue<QBoxLayout_Adaptor, int, int>(&QBoxLayout_Adaptor::cbs_heightForWidth_c767_0, arg1);
    } else {
      return QBoxLayout::heightForWidth(arg1);
    }
  }

  //  [adaptor impl] int QBoxLayout::indexOf(QWidget *)
  int cbs_indexOf_c1315_0(QWidget *arg1) const
  {
    return QBoxLayout::indexOf(arg1);
  }

  virtual int indexOf(QWidget *arg1) const
  {
    if (cb_indexOf_c1315_0.can_issue()) {
      return cb_indexOf_c1315_0.issue<QBoxLayout_Adaptor, int, QWidget *>(&QBoxLayout_Adaptor::cbs_indexOf_c1315_0, arg1);
    } else {
      return QBoxLayout::indexOf(arg1);
    }
  }

  //  [adaptor impl] void QBoxLayout::invalidate()
  void cbs_invalidate_0_0()
  {
    QBoxLayout::invalidate();
  }

  virtual void invalidate()
  {
    if (cb_invalidate_0_0.can_issue()) {
      cb_invalidate_0_0.issue<QBoxLayout_Adaptor>(&QBoxLayout_Adaptor::cbs_invalidate_0_0);
    } else {
      QBoxLayout::invalidate();
    }
  }

  //  [adaptor impl] bool QBoxLayout::isEmpty()
  bool cbs_isEmpty_c0_0() const
  {
    return QBoxLayout::isEmpty();
  }

  virtual bool isEmpty() const
  {
    if (cb_isEmpty_c0_0.can_issue()) {
      return cb_isEmpty_c0_0.issue<QBoxLayout_Adaptor, bool>(&QBoxLayout_Adaptor::cbs_isEmpty_c0_0);
    } else {
      return QBoxLayout::isEmpty();
    }
  }

  //  [adaptor impl] QLayoutItem *QBoxLayout::itemAt(int)
  QLayoutItem * cbs_itemAt_c767_0(int arg1) const
  {
    return QBoxLayout::itemAt(arg1);
  }

  virtual QLayoutItem * itemAt(int arg1) const
  {
    if (cb_itemAt_c767_0.can_issue()) {
      return cb_itemAt_c767_0.issue<QBoxLayout_Adaptor, QLayoutItem *, int>(&QBoxLayout_Adaptor::cbs_itemAt_c767_0, arg1);
    } else {
      return QBoxLayout::itemAt(arg1);
    }
  }

  //  [adaptor impl] QLayout *QBoxLayout::layout()
  QLayout * cbs_layout_0_0()
  {
    return QBoxLayout::layout();
  }

  virtual QLayout * layout()
  {
    if (cb_layout_0_0.can_issue()) {
      return cb_layout_0_0.issue<QBoxLayout_Adaptor, QLayout *>(&QBoxLayout_Adaptor::cbs_layout_0_0);
    } else {
      return QBoxLayout::layout();
    }
  }

  //  [adaptor impl] QSize QBoxLayout::maximumSize()
  QSize cbs_maximumSize_c0_0() const
  {
    return QBoxLayout::maximumSize();
  }

  virtual QSize maximumSize() const
  {
    if (cb_maximumSize_c0_0.can_issue()) {
      return cb_maximumSize_c0_0.issue<QBoxLayout_Adaptor, QSize>(&QBoxLayout_Adaptor::cbs_maximumSize_c0_0);
    } else {
      return QBoxLayout::maximumSize();
    }
  }

  //  [adaptor impl] int QBoxLayout::minimumHeightForWidth(int)
  int cbs_minimumHeightForWidth_c767_0(int arg1) const
  {
    return QBoxLayout::minimumHeightForWidth(arg1);
  }

  virtual int minimumHeightForWidth(int arg1) const
  {
    if (cb_minimumHeightForWidth_c767_0.can_issue()) {
      return cb_minimumHeightForWidth_c767_0.issue<QBoxLayout_Adaptor, int, int>(&QBoxLayout_Adaptor::cbs_minimumHeightForWidth_c767_0, arg1);
    } else {
      return QBoxLayout::minimumHeightForWidth(arg1);
    }
  }

  //  [adaptor impl] QSize QBoxLayout::minimumSize()
  QSize cbs_minimumSize_c0_0() const
  {
    return QBoxLayout::minimumSize();
  }

  virtual QSize minimumSize() const
  {
    if (cb_minimumSize_c0_0.can_issue()) {
      return cb_minimumSize_c0_0.issue<QBoxLayout_Adaptor, QSize>(&QBoxLayout_Adaptor::cbs_minimumSize_c0_0);
    } else {
      return QBoxLayout::minimumSize();
    }
  }

  //  [adaptor impl] void QBoxLayout::setGeometry(const QRect &)
  void cbs_setGeometry_1792_0(const QRect &arg1)
  {
    QBoxLayout::setGeometry(arg1);
  }

  virtual void setGeometry(const QRect &arg1)
  {
    if (cb_setGeometry_1792_0.can_issue()) {
      cb_setGeometry_1792_0.issue<QBoxLayout_Adaptor, const QRect &>(&QBoxLayout_Adaptor::cbs_setGeometry_1792_0, arg1);
    } else {
      QBoxLayout::setGeometry(arg1);
    }
  }

  //  [adaptor impl] QSize QBoxLayout::sizeHint()
  QSize cbs_sizeHint_c0_0() const
  {
    return QBoxLayout::sizeHint();
  }

  virtual QSize sizeHint() const
  {
    if (cb_sizeHint_c0_0.can_issue()) {
      return cb_sizeHint_c0_0.issue<QBoxLayout_Adaptor, QSize>(&QBoxLayout_Adaptor::cbs_sizeHint_c0_0);
    } else {
      return QBoxLayout::sizeHint();
    }
  }

  //  [adaptor impl] QSpacerItem *QBoxLayout::spacerItem()
  QSpacerItem * cbs_spacerItem_0_0()
  {
    return QBoxLayout::spacerItem();
  }

  virtual QSpacerItem * spacerItem()
  {
    if (cb_spacerItem_0_0.can_issue()) {
      return cb_spacerItem_0_0.issue<QBoxLayout_Adaptor, QSpacerItem *>(&QBoxLayout_Adaptor::cbs_spacerItem_0_0);
    } else {
      return QBoxLayout::spacerItem();
    }
  }

  //  [adaptor impl] QLayoutItem *QBoxLayout::takeAt(int)
  QLayoutItem * cbs_takeAt_767_0(int arg1)
  {
    return QBoxLayout::takeAt(arg1);
  }

  virtual QLayoutItem * takeAt(int arg1)
  {
    if (cb_takeAt_767_0.can_issue()) {
      return cb_takeAt_767_0.issue<QBoxLayout_Adaptor, QLayoutItem *, int>(&QBoxLayout_Adaptor::cbs_takeAt_767_0, arg1);
    } else {
      return QBoxLayout::takeAt(arg1);
    }
  }

  //  [adaptor impl] QWidget *QBoxLayout::widget()
  QWidget * cbs_widget_0_0()
  {
    return QBoxLayout::widget();
  }

  virtual QWidget * widget()
  {
    if (cb_widget_0_0.can_issue()) {
      return cb_widget_0_0.issue<QBoxLayout_Adaptor, QWidget *>(&QBoxLayout_Adaptor::cbs_widget_0_0);
    } else {
      return QBoxLayout::widget();
    }
  }

  //  [adaptor impl] void QBoxLayout::childEvent(QChildEvent *e)
  void cbs_childEvent_1701_0(QChildEvent *e)
  {
    QBoxLayout::childEvent(e);
  }

  virtual void childEvent(QChildEvent *e)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QBoxLayout_Adaptor, QChildEvent *>(&QBoxLayout_Adaptor::cbs_childEvent_1701_0, e);
    } else {
      QBoxLayout::childEvent(e);
    }
  }

  //  [adaptor impl] void QBoxLayout::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QBoxLayout::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QBoxLayout_Adaptor, QEvent *>(&QBoxLayout_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QBoxLayout::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QBoxLayout::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QBoxLayout::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QBoxLayout_Adaptor, const char *>(&QBoxLayout_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QBoxLayout::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QBoxLayout::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QBoxLayout::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QBoxLayout_Adaptor, QTimerEvent *>(&QBoxLayout_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QBoxLayout::timerEvent(arg1);
    }
  }

  gsi::Callback cb_addItem_1740_0;
  gsi::Callback cb_count_c0_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_expandingDirections_c0_0;
  gsi::Callback cb_geometry_c0_0;
  gsi::Callback cb_hasHeightForWidth_c0_0;
  gsi::Callback cb_heightForWidth_c767_0;
  gsi::Callback cb_indexOf_c1315_0;
  gsi::Callback cb_invalidate_0_0;
  gsi::Callback cb_isEmpty_c0_0;
  gsi::Callback cb_itemAt_c767_0;
  gsi::Callback cb_layout_0_0;
  gsi::Callback cb_maximumSize_c0_0;
  gsi::Callback cb_minimumHeightForWidth_c767_0;
  gsi::Callback cb_minimumSize_c0_0;
  gsi::Callback cb_setGeometry_1792_0;
  gsi::Callback cb_sizeHint_c0_0;
  gsi::Callback cb_spacerItem_0_0;
  gsi::Callback cb_takeAt_767_0;
  gsi::Callback cb_widget_0_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QBoxLayout_Adaptor::~QBoxLayout_Adaptor() { }

//  Constructor QBoxLayout::QBoxLayout(QBoxLayout::Direction, QWidget *parent) (adaptor class)

static void _init_ctor_QBoxLayout_Adaptor_3704 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<QBoxLayout::Direction>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("parent", true, "0");
  decl->add_arg<QWidget * > (argspec_1);
  decl->set_return_new<QBoxLayout_Adaptor *> ();
}

static void _call_ctor_QBoxLayout_Adaptor_3704 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<QBoxLayout::Direction>::target_type & arg1 = args.read<const qt_gsi::Converter<QBoxLayout::Direction>::target_type & > ();
  QWidget *arg2 = args ? args.read<QWidget * > () : (QWidget *)(0);
  ret.write<QBoxLayout_Adaptor *> (new QBoxLayout_Adaptor (qt_gsi::QtToCppAdaptor<QBoxLayout::Direction>(arg1).cref(), arg2));
}

static qt_gsi::GenericStaticMethod *_create_ctor_QBoxLayout_Adaptor_3704 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QBoxLayout::QBoxLayout(QBoxLayout::Direction, QWidget *parent)\nThis method creates an object of class QBoxLayout.", &_init_ctor_QBoxLayout_Adaptor_3704, &_call_ctor_QBoxLayout_Adaptor_3704);
}

// void QBoxLayout::addChildLayout(QLayout *l)

static void _init_fp_addChildLayout_1341 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<QLayout * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildLayout_1341 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayout *arg1 = args.read<QLayout * > ();
  qt_gsi::qt_keep (arg1);
  ((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_addChildLayout_1341 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildLayout_1341 ()
{
  return new qt_gsi::GenericMethod("*addChildLayout", "@brief Method void QBoxLayout::addChildLayout(QLayout *l)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildLayout_1341, &_call_fp_addChildLayout_1341);
}


// void QBoxLayout::addChildWidget(QWidget *w)

static void _init_fp_addChildWidget_1315 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("w");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_addChildWidget_1315 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_addChildWidget_1315 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_addChildWidget_1315 ()
{
  return new qt_gsi::GenericMethod("*addChildWidget", "@brief Method void QBoxLayout::addChildWidget(QWidget *w)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_addChildWidget_1315, &_call_fp_addChildWidget_1315);
}


// QRect QBoxLayout::alignmentRect(const QRect &)

static void _init_fp_alignmentRect_c1792 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<QRect > ();
}

static void _call_fp_alignmentRect_c1792 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ret.write<QRect > ((QRect)((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_alignmentRect_c1792 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_alignmentRect_c1792 ()
{
  return new qt_gsi::GenericMethod("*alignmentRect", "@brief Method QRect QBoxLayout::alignmentRect(const QRect &)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_alignmentRect_c1792, &_call_fp_alignmentRect_c1792);
}


// void QBoxLayout::insertItem(int index, QLayoutItem *)

static void _init_fp_insertItem_2399 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("index");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QLayoutItem * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_fp_insertItem_2399 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QLayoutItem *arg2 = args.read<QLayoutItem * > ();
  ((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_insertItem_2399 (arg1, arg2);
}

static qt_gsi::GenericMethod*_create_fp_insertItem_2399 ()
{
  return new qt_gsi::GenericMethod("*insertItem", "@brief Method void QBoxLayout::insertItem(int index, QLayoutItem *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_insertItem_2399, &_call_fp_insertItem_2399);
}


// int QBoxLayout::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QBoxLayout::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QBoxLayout::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QBoxLayout::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// void QBoxLayout::widgetEvent(QEvent *)

static void _init_fp_widgetEvent_1217 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_fp_widgetEvent_1217 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QBoxLayout_Adaptor *)cls)->fp_QBoxLayout_widgetEvent_1217 (arg1);
}

static qt_gsi::GenericMethod*_create_fp_widgetEvent_1217 ()
{
  return new qt_gsi::GenericMethod("*widgetEvent", "@brief Method void QBoxLayout::widgetEvent(QEvent *)\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_widgetEvent_1217, &_call_fp_widgetEvent_1217);
}


// void QBoxLayout::addItem(QLayoutItem *)

static void _init_cbs_addItem_1740_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QLayoutItem * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_addItem_1740_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QLayoutItem *arg1 = args.read<QLayoutItem * > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_addItem_1740_0 (arg1);
}

static void _set_callback_cbs_addItem_1740_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_addItem_1740_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@hide", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_addItem_1740_0 ()
{
  return new qt_gsi::GenericMethod ("addItem", "@brief Virtual method void QBoxLayout::addItem(QLayoutItem *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_addItem_1740_0, &_call_cbs_addItem_1740_0, &_set_callback_cbs_addItem_1740_0);
}


// int QBoxLayout::count()

static void _init_cbs_count_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_cbs_count_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)((QBoxLayout_Adaptor *)cls)->cbs_count_c0_0 ());
}

static void _set_callback_cbs_count_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_count_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@hide", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_count_c0_0 ()
{
  return new qt_gsi::GenericMethod ("count", "@brief Virtual method int QBoxLayout::count()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_count_c0_0, &_call_cbs_count_c0_0, &_set_callback_cbs_count_c0_0);
}


// bool QBoxLayout::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QBoxLayout_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QBoxLayout::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// bool QBoxLayout::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QBoxLayout_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QBoxLayout::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// QFlags<Qt::Orientation> QBoxLayout::expandingDirections()

static void _init_cbs_expandingDirections_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ();
}

static void _call_cbs_expandingDirections_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type > ((qt_gsi::Converter<QFlags<Qt::Orientation> >::target_type)((QBoxLayout_Adaptor *)cls)->cbs_expandingDirections_c0_0 ());
}

static void _set_callback_cbs_expandingDirections_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_expandingDirections_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@hide", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_expandingDirections_c0_0 ()
{
  return new qt_gsi::GenericMethod ("expandingDirections", "@brief Virtual method QFlags<Qt::Orientation> QBoxLayout::expandingDirections()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_expandingDirections_c0_0, &_call_cbs_expandingDirections_c0_0, &_set_callback_cbs_expandingDirections_c0_0);
}


// QRect QBoxLayout::geometry()

static void _init_cbs_geometry_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QRect > ();
}

static void _call_cbs_geometry_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QRect > ((QRect)((QBoxLayout_Adaptor *)cls)->cbs_geometry_c0_0 ());
}

static void _set_callback_cbs_geometry_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_geometry_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@hide", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_geometry_c0_0 ()
{
  return new qt_gsi::GenericMethod ("geometry", "@brief Virtual method QRect QBoxLayout::geometry()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_geometry_c0_0, &_call_cbs_geometry_c0_0, &_set_callback_cbs_geometry_c0_0);
}


// bool QBoxLayout::hasHeightForWidth()

static void _init_cbs_hasHeightForWidth_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_hasHeightForWidth_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QBoxLayout_Adaptor *)cls)->cbs_hasHeightForWidth_c0_0 ());
}

static void _set_callback_cbs_hasHeightForWidth_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_hasHeightForWidth_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@hide", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_hasHeightForWidth_c0_0 ()
{
  return new qt_gsi::GenericMethod ("hasHeightForWidth", "@brief Virtual method bool QBoxLayout::hasHeightForWidth()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_hasHeightForWidth_c0_0, &_call_cbs_hasHeightForWidth_c0_0, &_set_callback_cbs_hasHeightForWidth_c0_0);
}


// int QBoxLayout::heightForWidth(int)

static void _init_cbs_heightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_heightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QBoxLayout_Adaptor *)cls)->cbs_heightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_heightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_heightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@hide", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_heightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("heightForWidth", "@brief Virtual method int QBoxLayout::heightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_heightForWidth_c767_0, &_call_cbs_heightForWidth_c767_0, &_set_callback_cbs_heightForWidth_c767_0);
}


// int QBoxLayout::indexOf(QWidget *)

static void _init_cbs_indexOf_c1315_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_indexOf_c1315_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  ret.write<int > ((int)((QBoxLayout_Adaptor *)cls)->cbs_indexOf_c1315_0 (arg1));
}

static void _set_callback_cbs_indexOf_c1315_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_indexOf_c1315_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@hide", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_indexOf_c1315_0 ()
{
  return new qt_gsi::GenericMethod ("indexOf", "@brief Virtual method int QBoxLayout::indexOf(QWidget *)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_indexOf_c1315_0, &_call_cbs_indexOf_c1315_0, &_set_callback_cbs_indexOf_c1315_0);
}


// void QBoxLayout::invalidate()

static void _init_cbs_invalidate_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_cbs_invalidate_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ((QBoxLayout_Adaptor *)cls)->cbs_invalidate_0_0 ();
}

static void _set_callback_cbs_invalidate_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_invalidate_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@hide", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_invalidate_0_0 ()
{
  return new qt_gsi::GenericMethod ("invalidate", "@brief Virtual method void QBoxLayout::invalidate()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_invalidate_0_0, &_call_cbs_invalidate_0_0, &_set_callback_cbs_invalidate_0_0);
}


// bool QBoxLayout::isEmpty()

static void _init_cbs_isEmpty_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_isEmpty_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QBoxLayout_Adaptor *)cls)->cbs_isEmpty_c0_0 ());
}

static void _set_callback_cbs_isEmpty_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_isEmpty_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@hide", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_isEmpty_c0_0 ()
{
  return new qt_gsi::GenericMethod ("isEmpty", "@brief Virtual method bool QBoxLayout::isEmpty()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_isEmpty_c0_0, &_call_cbs_isEmpty_c0_0, &_set_callback_cbs_isEmpty_c0_0);
}


// QLayoutItem *QBoxLayout::itemAt(int)

static void _init_cbs_itemAt_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_itemAt_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QBoxLayout_Adaptor *)cls)->cbs_itemAt_c767_0 (arg1));
}

static void _set_callback_cbs_itemAt_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_itemAt_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@hide", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_itemAt_c767_0 ()
{
  return new qt_gsi::GenericMethod ("itemAt", "@brief Virtual method QLayoutItem *QBoxLayout::itemAt(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_itemAt_c767_0, &_call_cbs_itemAt_c767_0, &_set_callback_cbs_itemAt_c767_0);
}


// QLayout *QBoxLayout::layout()

static void _init_cbs_layout_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QLayout * > ();
}

static void _call_cbs_layout_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLayout * > ((QLayout *)((QBoxLayout_Adaptor *)cls)->cbs_layout_0_0 ());
}

static void _set_callback_cbs_layout_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_layout_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@hide", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_layout_0_0 ()
{
  return new qt_gsi::GenericMethod ("layout", "@brief Virtual method QLayout *QBoxLayout::layout()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_layout_0_0, &_call_cbs_layout_0_0, &_set_callback_cbs_layout_0_0);
}


// QSize QBoxLayout::maximumSize()

static void _init_cbs_maximumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_maximumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout_Adaptor *)cls)->cbs_maximumSize_c0_0 ());
}

static void _set_callback_cbs_maximumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_maximumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@hide", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_maximumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("maximumSize", "@brief Virtual method QSize QBoxLayout::maximumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_maximumSize_c0_0, &_call_cbs_maximumSize_c0_0, &_set_callback_cbs_maximumSize_c0_0);
}


// int QBoxLayout::minimumHeightForWidth(int)

static void _init_cbs_minimumHeightForWidth_c767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_minimumHeightForWidth_c767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<int > ((int)((QBoxLayout_Adaptor *)cls)->cbs_minimumHeightForWidth_c767_0 (arg1));
}

static void _set_callback_cbs_minimumHeightForWidth_c767_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_minimumHeightForWidth_c767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@hide", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumHeightForWidth_c767_0 ()
{
  return new qt_gsi::GenericMethod ("minimumHeightForWidth", "@brief Virtual method int QBoxLayout::minimumHeightForWidth(int)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumHeightForWidth_c767_0, &_call_cbs_minimumHeightForWidth_c767_0, &_set_callback_cbs_minimumHeightForWidth_c767_0);
}


// QSize QBoxLayout::minimumSize()

static void _init_cbs_minimumSize_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_minimumSize_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout_Adaptor *)cls)->cbs_minimumSize_c0_0 ());
}

static void _set_callback_cbs_minimumSize_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_minimumSize_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@hide", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_minimumSize_c0_0 ()
{
  return new qt_gsi::GenericMethod ("minimumSize", "@brief Virtual method QSize QBoxLayout::minimumSize()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_minimumSize_c0_0, &_call_cbs_minimumSize_c0_0, &_set_callback_cbs_minimumSize_c0_0);
}


// void QBoxLayout::setGeometry(const QRect &)

static void _init_cbs_setGeometry_1792_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QRect & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setGeometry_1792_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QRect &arg1 = args.read<const QRect & > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_setGeometry_1792_0 (arg1);
}

static void _set_callback_cbs_setGeometry_1792_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_setGeometry_1792_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@hide", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_setGeometry_1792_0 ()
{
  return new qt_gsi::GenericMethod ("setGeometry", "@brief Virtual method void QBoxLayout::setGeometry(const QRect &)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setGeometry_1792_0, &_call_cbs_setGeometry_1792_0, &_set_callback_cbs_setGeometry_1792_0);
}


// QSize QBoxLayout::sizeHint()

static void _init_cbs_sizeHint_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_cbs_sizeHint_c0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)((QBoxLayout_Adaptor *)cls)->cbs_sizeHint_c0_0 ());
}

static void _set_callback_cbs_sizeHint_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_sizeHint_c0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@hide", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_sizeHint_c0_0 ()
{
  return new qt_gsi::GenericMethod ("sizeHint", "@brief Virtual method QSize QBoxLayout::sizeHint()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sizeHint_c0_0, &_call_cbs_sizeHint_c0_0, &_set_callback_cbs_sizeHint_c0_0);
}


// QSpacerItem *QBoxLayout::spacerItem()

static void _init_cbs_spacerItem_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QSpacerItem * > ();
}

static void _call_cbs_spacerItem_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSpacerItem * > ((QSpacerItem *)((QBoxLayout_Adaptor *)cls)->cbs_spacerItem_0_0 ());
}

static void _set_callback_cbs_spacerItem_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_spacerItem_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@hide", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_spacerItem_0_0 ()
{
  return new qt_gsi::GenericMethod ("spacerItem", "@brief Virtual method QSpacerItem *QBoxLayout::spacerItem()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_spacerItem_0_0, &_call_cbs_spacerItem_0_0, &_set_callback_cbs_spacerItem_0_0);
}


// QLayoutItem *QBoxLayout::takeAt(int)

static void _init_cbs_takeAt_767_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<QLayoutItem * > ();
}

static void _call_cbs_takeAt_767_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  ret.write<QLayoutItem * > ((QLayoutItem *)((QBoxLayout_Adaptor *)cls)->cbs_takeAt_767_0 (arg1));
}

static void _set_callback_cbs_takeAt_767_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_takeAt_767_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@hide", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_takeAt_767_0 ()
{
  return new qt_gsi::GenericMethod ("takeAt", "@brief Virtual method QLayoutItem *QBoxLayout::takeAt(int)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_takeAt_767_0, &_call_cbs_takeAt_767_0, &_set_callback_cbs_takeAt_767_0);
}


// QWidget *QBoxLayout::widget()

static void _init_cbs_widget_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_cbs_widget_0_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)((QBoxLayout_Adaptor *)cls)->cbs_widget_0_0 ());
}

static void _set_callback_cbs_widget_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_widget_0_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@hide", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_widget_0_0 ()
{
  return new qt_gsi::GenericMethod ("widget", "@brief Virtual method QWidget *QBoxLayout::widget()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_widget_0_0, &_call_cbs_widget_0_0, &_set_callback_cbs_widget_0_0);
}


// void QBoxLayout::childEvent(QChildEvent *e)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("e");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QBoxLayout::childEvent(QChildEvent *e)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QBoxLayout::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QBoxLayout::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QBoxLayout::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QBoxLayout::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// void QBoxLayout::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QBoxLayout_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QBoxLayout_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QBoxLayout::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QBoxLayout> decl_QBoxLayout;

gsi::Class<QBoxLayout_Adaptor> decl_QBoxLayout_Adaptor (decl_QBoxLayout, "QBoxLayout",
  gsi::Methods(_create_fp_addChildLayout_1341 ()) +
  gsi::Methods(_create_fp_addChildWidget_1315 ()) +
  gsi::Methods(_create_fp_alignmentRect_c1792 ()) +
  gsi::Methods(_create_fp_insertItem_2399 ()) +
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_fp_widgetEvent_1217 ()) +
  gsi::Methods(_create_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_callback_cbs_addItem_1740_0 ()) +
  gsi::Methods(_create_cbs_count_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_count_c0_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_expandingDirections_c0_0 ()) +
  gsi::Methods(_create_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_geometry_c0_0 ()) +
  gsi::Methods(_create_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_hasHeightForWidth_c0_0 ()) +
  gsi::Methods(_create_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_heightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_callback_cbs_indexOf_c1315_0 ()) +
  gsi::Methods(_create_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_callback_cbs_invalidate_0_0 ()) +
  gsi::Methods(_create_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_isEmpty_c0_0 ()) +
  gsi::Methods(_create_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_itemAt_c767_0 ()) +
  gsi::Methods(_create_cbs_layout_0_0 ()) +
  gsi::Methods(_create_callback_cbs_layout_0_0 ()) +
  gsi::Methods(_create_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_maximumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumHeightForWidth_c767_0 ()) +
  gsi::Methods(_create_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_minimumSize_c0_0 ()) +
  gsi::Methods(_create_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_callback_cbs_setGeometry_1792_0 ()) +
  gsi::Methods(_create_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_callback_cbs_sizeHint_c0_0 ()) +
  gsi::Methods(_create_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_callback_cbs_spacerItem_0_0 ()) +
  gsi::Methods(_create_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_callback_cbs_takeAt_767_0 ()) +
  gsi::Methods(_create_cbs_widget_0_0 ()) +
  gsi::Methods(_create_callback_cbs_widget_0_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_ctor_QBoxLayout_Adaptor_3704 ()),
  "@qt\n@brief Binding of QBoxLayout");

}


//  Implementation of the enum wrapper class for QBoxLayout::Direction
namespace qt_gsi
{

static QBoxLayout_Direction_Enum *c_1_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::LeftToRight); }
static QBoxLayout_Direction_Enum *c_2_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::RightToLeft); }
static QBoxLayout_Direction_Enum *c_3_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::TopToBottom); }
static QBoxLayout_Direction_Enum *c_4_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::BottomToTop); }
static QBoxLayout_Direction_Enum *c_5_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::Down); }
static QBoxLayout_Direction_Enum *c_6_QBoxLayout_Direction_Enum () { return new QBoxLayout_Direction_Enum (QBoxLayout::Up); }

static gsi::Methods mkdefs_QBoxLayout_Direction () {
  return
    gsi::constant ("LeftToRight", &qt_gsi::c_1_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::LeftToRight") +
    gsi::constant ("RightToLeft", &qt_gsi::c_2_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::RightToLeft") +
    gsi::constant ("TopToBottom", &qt_gsi::c_3_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::TopToBottom") +
    gsi::constant ("BottomToTop", &qt_gsi::c_4_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::BottomToTop") +
    gsi::constant ("Down", &qt_gsi::c_5_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::Down") +
    gsi::constant ("Up", &qt_gsi::c_6_QBoxLayout_Direction_Enum, "@brief Enum constant QBoxLayout::Up");
}

static std::string to_s_QBoxLayout_Direction_Enum (const QBoxLayout_Direction_Enum *e)
{
  if (e->value () == QBoxLayout::LeftToRight) { return tl::sprintf ("LeftToRight (%u)", (unsigned int) e->value ()); }
  if (e->value () == QBoxLayout::RightToLeft) { return tl::sprintf ("RightToLeft (%u)", (unsigned int) e->value ()); }
  if (e->value () == QBoxLayout::TopToBottom) { return tl::sprintf ("TopToBottom (%u)", (unsigned int) e->value ()); }
  if (e->value () == QBoxLayout::BottomToTop) { return tl::sprintf ("BottomToTop (%u)", (unsigned int) e->value ()); }
  if (e->value () == QBoxLayout::Down) { return tl::sprintf ("Down (%u)", (unsigned int) e->value ()); }
  if (e->value () == QBoxLayout::Up) { return tl::sprintf ("Up (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QBoxLayout_Direction_Enum (const QBoxLayout_Direction_Enum *e)
{
  return (unsigned int) e->value ();
}

static QBoxLayout_Direction_Enum *from_i_QBoxLayout_Direction_Enum (unsigned int i)
{
  return new QBoxLayout_Direction_Enum ((QBoxLayout::Direction) i);
}

static bool equalQBoxLayout_Direction_Enum (const QBoxLayout_Direction_Enum *e, QBoxLayout_Direction_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QBoxLayout_Direction_Enum (const QBoxLayout_Direction_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QBoxLayout_Direction_Enums oropQBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e, const QBoxLayout_Direction_Enums &d)
{
  return e->flags () | d.flags ();
}

static QBoxLayout_Direction_Enums andopQBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e, const QBoxLayout_Direction_Enums &d)
{
  return e->flags () & d.flags ();
}

static QBoxLayout_Direction_Enums xoropQBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e, const QBoxLayout_Direction_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e)
{
  std::string l;
  if (e->testFlag (QBoxLayout::LeftToRight)) { if (!l.empty ()) l += "|"; l += "LeftToRight"; }
  if (e->testFlag (QBoxLayout::RightToLeft)) { if (!l.empty ()) l += "|"; l += "RightToLeft"; }
  if (e->testFlag (QBoxLayout::TopToBottom)) { if (!l.empty ()) l += "|"; l += "TopToBottom"; }
  if (e->testFlag (QBoxLayout::BottomToTop)) { if (!l.empty ()) l += "|"; l += "BottomToTop"; }
  if (e->testFlag (QBoxLayout::Down)) { if (!l.empty ()) l += "|"; l += "Down"; }
  if (e->testFlag (QBoxLayout::Up)) { if (!l.empty ()) l += "|"; l += "Up"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QBoxLayout_Direction_Enums (const QBoxLayout_Direction_Enums *e, const QBoxLayout_Direction_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QBoxLayout_Direction_Enums> decl_QBoxLayout_Direction_Enums ("QBoxLayout_QFlags_Direction",
  gsi::method_ext ("|", &qt_gsi::oropQBoxLayout_Direction_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQBoxLayout_Direction_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQBoxLayout_Direction_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QBoxLayout_Direction_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QBoxLayout_Direction_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QBoxLayout_Direction_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QBoxLayout::Direction> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QBoxLayout_Direction_Enum> decl_QBoxLayout_Direction_Enum (decl_QBoxLayout_Direction_Enums, "QBoxLayout_Direction",
  qt_gsi::mkdefs_QBoxLayout_Direction () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QBoxLayout_Direction_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QBoxLayout_Direction_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQBoxLayout_Direction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QBoxLayout_Direction_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QBoxLayout_Direction_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QBoxLayout::Direction enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QBoxLayout> inject_QBoxLayout_Direction_Enum_in_parent (qt_gsi::mkdefs_QBoxLayout_Direction ());
static gsi::ClassExt<QBoxLayout> decl_QBoxLayout_Direction_Enum_as_child (decl_QBoxLayout_Direction_Enum, "Direction");

}

