
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQApplication.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQApplication_EventAdaptor.h"
#include "gsiDeclQApplication_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QApplication

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QApplication::staticMetaObject);
}

static qt_gsi::GenericStaticMethod *_create_smo ()
{
  return new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
}
  static QApplication *ctor_QApplication()
  {
    static char *(dummy_argv[]) = { (char *)"undefined_application" };
    int argc = 1;
    return new QApplication (argc, dummy_argv);
  }

// bool QApplication::autoSipEnabled()


static void _init_f_autoSipEnabled_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_autoSipEnabled_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)((QApplication *)cls)->autoSipEnabled ());
}

static qt_gsi::GenericMethod *_create_f_autoSipEnabled_c0 ()
{
  return new qt_gsi::GenericMethod (":autoSipEnabled", "@brief Method bool QApplication::autoSipEnabled()\n", true, &_init_f_autoSipEnabled_c0, &_call_f_autoSipEnabled_c0);
}

// QInputContext *QApplication::inputContext()


static void _init_f_inputContext_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QInputContext * > ();
}

static void _call_f_inputContext_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QInputContext * > ((QInputContext *)((QApplication *)cls)->inputContext ());
}

static qt_gsi::GenericMethod *_create_f_inputContext_c0 ()
{
  return new qt_gsi::GenericMethod (":inputContext", "@brief Method QInputContext *QApplication::inputContext()\n", true, &_init_f_inputContext_c0, &_call_f_inputContext_c0);
}

// bool QApplication::notify(QObject *, QEvent *)


static void _init_f_notify_2411 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_f_notify_2411 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QApplication *)cls)->notify (arg1, arg2));
}

static qt_gsi::GenericMethod *_create_f_notify_2411 ()
{
  return new qt_gsi::GenericMethod ("notify", "@brief Method bool QApplication::notify(QObject *, QEvent *)\nThis is a reimplementation of QCoreApplication::notify", false, &_init_f_notify_2411, &_call_f_notify_2411);
}

// void QApplication::setAutoSipEnabled(const bool enabled)


static void _init_f_setAutoSipEnabled_1559 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("enabled");
  decl->add_arg<const bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setAutoSipEnabled_1559 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const bool arg1 = args.read<const bool > ();
  ((QApplication *)cls)->setAutoSipEnabled (arg1);
}

static qt_gsi::GenericMethod *_create_f_setAutoSipEnabled_1559 ()
{
  return new qt_gsi::GenericMethod ("setAutoSipEnabled|autoSipEnabled=", "@brief Method void QApplication::setAutoSipEnabled(const bool enabled)\n", false, &_init_f_setAutoSipEnabled_1559, &_call_f_setAutoSipEnabled_1559);
}

// void QApplication::setInputContext(QInputContext *)


static void _init_f_setInputContext_1972 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QInputContext * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setInputContext_1972 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QInputContext *arg1 = args.read<QInputContext * > ();
  ((QApplication *)cls)->setInputContext (arg1);
}

static qt_gsi::GenericMethod *_create_f_setInputContext_1972 ()
{
  return new qt_gsi::GenericMethod ("setInputContext|inputContext=", "@brief Method void QApplication::setInputContext(QInputContext *)\n", false, &_init_f_setInputContext_1972, &_call_f_setInputContext_1972);
}

// void QApplication::setStyleSheet(const QString &sheet)


static void _init_f_setStyleSheet_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("sheet");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyleSheet_2025 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ((QApplication *)cls)->setStyleSheet (arg1);
}

static qt_gsi::GenericMethod *_create_f_setStyleSheet_2025 ()
{
  return new qt_gsi::GenericMethod ("setStyleSheet|styleSheet=", "@brief Method void QApplication::setStyleSheet(const QString &sheet)\n", false, &_init_f_setStyleSheet_2025, &_call_f_setStyleSheet_2025);
}

// QString QApplication::styleSheet()


static void _init_f_styleSheet_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_styleSheet_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QString > ((QString)((QApplication *)cls)->styleSheet ());
}

static qt_gsi::GenericMethod *_create_f_styleSheet_c0 ()
{
  return new qt_gsi::GenericMethod (":styleSheet", "@brief Method QString QApplication::styleSheet()\n", true, &_init_f_styleSheet_c0, &_call_f_styleSheet_c0);
}

// static void QApplication::aboutQt()


static void _init_f_aboutQt_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_aboutQt_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication::aboutQt ();
}

static qt_gsi::GenericStaticMethod *_create_f_aboutQt_0 ()
{
  return new qt_gsi::GenericStaticMethod ("aboutQt", "@brief Static method void QApplication::aboutQt()\nThis method is static and can be called without an instance.", &_init_f_aboutQt_0, &_call_f_aboutQt_0);
}

// static QWidget *QApplication::activeModalWidget()


static void _init_f_activeModalWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeModalWidget_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QApplication::activeModalWidget ());
}

static qt_gsi::GenericStaticMethod *_create_f_activeModalWidget_0 ()
{
  return new qt_gsi::GenericStaticMethod ("activeModalWidget", "@brief Static method QWidget *QApplication::activeModalWidget()\nThis method is static and can be called without an instance.", &_init_f_activeModalWidget_0, &_call_f_activeModalWidget_0);
}

// static QWidget *QApplication::activePopupWidget()


static void _init_f_activePopupWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activePopupWidget_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QApplication::activePopupWidget ());
}

static qt_gsi::GenericStaticMethod *_create_f_activePopupWidget_0 ()
{
  return new qt_gsi::GenericStaticMethod ("activePopupWidget", "@brief Static method QWidget *QApplication::activePopupWidget()\nThis method is static and can be called without an instance.", &_init_f_activePopupWidget_0, &_call_f_activePopupWidget_0);
}

// static QWidget *QApplication::activeWindow()


static void _init_f_activeWindow_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_activeWindow_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QApplication::activeWindow ());
}

static qt_gsi::GenericStaticMethod *_create_f_activeWindow_0 ()
{
  return new qt_gsi::GenericStaticMethod (":activeWindow", "@brief Static method QWidget *QApplication::activeWindow()\nThis method is static and can be called without an instance.", &_init_f_activeWindow_0, &_call_f_activeWindow_0);
}

// static void QApplication::alert(QWidget *widget, int duration)


static void _init_f_alert_1974 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("widget");
  decl->add_arg<QWidget * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("duration", true, "0");
  decl->add_arg<int > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_alert_1974 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  int arg2 = args ? args.read<int > () : (int)(0);
  QApplication::alert (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_alert_1974 ()
{
  return new qt_gsi::GenericStaticMethod ("alert", "@brief Static method void QApplication::alert(QWidget *widget, int duration)\nThis method is static and can be called without an instance.", &_init_f_alert_1974, &_call_f_alert_1974);
}

// static QList<QWidget *> QApplication::allWidgets()


static void _init_f_allWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QWidget *> >::target_type > ();
}

static void _call_f_allWidgets_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QWidget *> >::target_type > ((qt_gsi::Converter<QList<QWidget *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QWidget *> >(QApplication::allWidgets ()));
}

static qt_gsi::GenericStaticMethod *_create_f_allWidgets_0 ()
{
  return new qt_gsi::GenericStaticMethod ("allWidgets", "@brief Static method QList<QWidget *> QApplication::allWidgets()\nThis method is static and can be called without an instance.", &_init_f_allWidgets_0, &_call_f_allWidgets_0);
}

// static void QApplication::beep()


static void _init_f_beep_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_beep_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication::beep ();
}

static qt_gsi::GenericStaticMethod *_create_f_beep_0 ()
{
  return new qt_gsi::GenericStaticMethod ("beep", "@brief Static method void QApplication::beep()\nThis method is static and can be called without an instance.", &_init_f_beep_0, &_call_f_beep_0);
}

// static void QApplication::changeOverrideCursor(const QCursor &)


static void _init_f_changeOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_changeOverrideCursor_2032 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QCursor &arg1 = args.read<const QCursor & > ();
  QApplication::changeOverrideCursor (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_changeOverrideCursor_2032 ()
{
  return new qt_gsi::GenericStaticMethod ("changeOverrideCursor", "@brief Static method void QApplication::changeOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_changeOverrideCursor_2032, &_call_f_changeOverrideCursor_2032);
}

// static QClipboard *QApplication::clipboard()


static void _init_f_clipboard_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QClipboard * > ();
}

static void _call_f_clipboard_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QClipboard * > ((QClipboard *)QApplication::clipboard ());
}

static qt_gsi::GenericStaticMethod *_create_f_clipboard_0 ()
{
  return new qt_gsi::GenericStaticMethod ("clipboard", "@brief Static method QClipboard *QApplication::clipboard()\nThis method is static and can be called without an instance.", &_init_f_clipboard_0, &_call_f_clipboard_0);
}

// static void QApplication::closeAllWindows()


static void _init_f_closeAllWindows_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_closeAllWindows_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication::closeAllWindows ();
}

static qt_gsi::GenericStaticMethod *_create_f_closeAllWindows_0 ()
{
  return new qt_gsi::GenericStaticMethod ("closeAllWindows", "@brief Static method void QApplication::closeAllWindows()\nThis method is static and can be called without an instance.", &_init_f_closeAllWindows_0, &_call_f_closeAllWindows_0);
}

// static int QApplication::colorSpec()


static void _init_f_colorSpec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_colorSpec_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::colorSpec ());
}

static qt_gsi::GenericStaticMethod *_create_f_colorSpec_0 ()
{
  return new qt_gsi::GenericStaticMethod (":colorSpec", "@brief Static method int QApplication::colorSpec()\nThis method is static and can be called without an instance.", &_init_f_colorSpec_0, &_call_f_colorSpec_0);
}

// static int QApplication::cursorFlashTime()


static void _init_f_cursorFlashTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_cursorFlashTime_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::cursorFlashTime ());
}

static qt_gsi::GenericStaticMethod *_create_f_cursorFlashTime_0 ()
{
  return new qt_gsi::GenericStaticMethod (":cursorFlashTime", "@brief Static method int QApplication::cursorFlashTime()\nThis method is static and can be called without an instance.", &_init_f_cursorFlashTime_0, &_call_f_cursorFlashTime_0);
}

// static QDesktopWidget *QApplication::desktop()


static void _init_f_desktop_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QDesktopWidget * > ();
}

static void _call_f_desktop_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QDesktopWidget * > ((QDesktopWidget *)QApplication::desktop ());
}

static qt_gsi::GenericStaticMethod *_create_f_desktop_0 ()
{
  return new qt_gsi::GenericStaticMethod ("desktop", "@brief Static method QDesktopWidget *QApplication::desktop()\nThis method is static and can be called without an instance.", &_init_f_desktop_0, &_call_f_desktop_0);
}

// static bool QApplication::desktopSettingsAware()


static void _init_f_desktopSettingsAware_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_desktopSettingsAware_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QApplication::desktopSettingsAware ());
}

static qt_gsi::GenericStaticMethod *_create_f_desktopSettingsAware_0 ()
{
  return new qt_gsi::GenericStaticMethod (":desktopSettingsAware", "@brief Static method bool QApplication::desktopSettingsAware()\nThis method is static and can be called without an instance.", &_init_f_desktopSettingsAware_0, &_call_f_desktopSettingsAware_0);
}

// static int QApplication::doubleClickInterval()


static void _init_f_doubleClickInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_doubleClickInterval_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::doubleClickInterval ());
}

static qt_gsi::GenericStaticMethod *_create_f_doubleClickInterval_0 ()
{
  return new qt_gsi::GenericStaticMethod (":doubleClickInterval", "@brief Static method int QApplication::doubleClickInterval()\nThis method is static and can be called without an instance.", &_init_f_doubleClickInterval_0, &_call_f_doubleClickInterval_0);
}

// static int QApplication::exec()


static void _init_f_exec_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_exec_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::exec ());
}

static qt_gsi::GenericStaticMethod *_create_f_exec_0 ()
{
  return new qt_gsi::GenericStaticMethod ("exec", "@brief Static method int QApplication::exec()\nThis method is static and can be called without an instance.", &_init_f_exec_0, &_call_f_exec_0);
}

// static QWidget *QApplication::focusWidget()


static void _init_f_focusWidget_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QWidget * > ();
}

static void _call_f_focusWidget_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QWidget * > ((QWidget *)QApplication::focusWidget ());
}

static qt_gsi::GenericStaticMethod *_create_f_focusWidget_0 ()
{
  return new qt_gsi::GenericStaticMethod ("focusWidget", "@brief Static method QWidget *QApplication::focusWidget()\nThis method is static and can be called without an instance.", &_init_f_focusWidget_0, &_call_f_focusWidget_0);
}

// static QFont QApplication::font()


static void _init_f_font_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFont > ();
}

static void _call_f_font_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFont > ((QFont)QApplication::font ());
}

static qt_gsi::GenericStaticMethod *_create_f_font_0 ()
{
  return new qt_gsi::GenericStaticMethod (":font", "@brief Static method QFont QApplication::font()\nThis method is static and can be called without an instance.", &_init_f_font_0, &_call_f_font_0);
}

// static QFont QApplication::font(const QWidget *)


static void _init_f_font_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_2010 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_font_2010 ()
{
  return new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_font_2010, &_call_f_font_2010);
}

// static QFont QApplication::font(const char *className)


static void _init_f_font_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QFont > ();
}

static void _call_f_font_1731 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QFont > ((QFont)QApplication::font (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_font_1731 ()
{
  return new qt_gsi::GenericStaticMethod ("font", "@brief Static method QFont QApplication::font(const char *className)\nThis method is static and can be called without an instance.", &_init_f_font_1731, &_call_f_font_1731);
}

// static QFontMetrics QApplication::fontMetrics()


static void _init_f_fontMetrics_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QFontMetrics > ();
}

static void _call_f_fontMetrics_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QFontMetrics > ((QFontMetrics)QApplication::fontMetrics ());
}

static qt_gsi::GenericStaticMethod *_create_f_fontMetrics_0 ()
{
  return new qt_gsi::GenericStaticMethod ("fontMetrics", "@brief Static method QFontMetrics QApplication::fontMetrics()\nThis method is static and can be called without an instance.", &_init_f_fontMetrics_0, &_call_f_fontMetrics_0);
}

// static QSize QApplication::globalStrut()


static void _init_f_globalStrut_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QSize > ();
}

static void _call_f_globalStrut_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QSize > ((QSize)QApplication::globalStrut ());
}

static qt_gsi::GenericStaticMethod *_create_f_globalStrut_0 ()
{
  return new qt_gsi::GenericStaticMethod (":globalStrut", "@brief Static method QSize QApplication::globalStrut()\nThis method is static and can be called without an instance.", &_init_f_globalStrut_0, &_call_f_globalStrut_0);
}

// static bool QApplication::isEffectEnabled(Qt::UIEffect)


static void _init_f_isEffectEnabled_1496 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_f_isEffectEnabled_1496 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::UIEffect>::target_type & > ();
  ret.write<bool > ((bool)QApplication::isEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref()));
}

static qt_gsi::GenericStaticMethod *_create_f_isEffectEnabled_1496 ()
{
  return new qt_gsi::GenericStaticMethod ("isEffectEnabled?", "@brief Static method bool QApplication::isEffectEnabled(Qt::UIEffect)\nThis method is static and can be called without an instance.", &_init_f_isEffectEnabled_1496, &_call_f_isEffectEnabled_1496);
}

// static bool QApplication::isLeftToRight()


static void _init_f_isLeftToRight_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isLeftToRight_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QApplication::isLeftToRight ());
}

static qt_gsi::GenericStaticMethod *_create_f_isLeftToRight_0 ()
{
  return new qt_gsi::GenericStaticMethod ("isLeftToRight?", "@brief Static method bool QApplication::isLeftToRight()\nThis method is static and can be called without an instance.", &_init_f_isLeftToRight_0, &_call_f_isLeftToRight_0);
}

// static bool QApplication::isRightToLeft()


static void _init_f_isRightToLeft_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isRightToLeft_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QApplication::isRightToLeft ());
}

static qt_gsi::GenericStaticMethod *_create_f_isRightToLeft_0 ()
{
  return new qt_gsi::GenericStaticMethod ("isRightToLeft?", "@brief Static method bool QApplication::isRightToLeft()\nThis method is static and can be called without an instance.", &_init_f_isRightToLeft_0, &_call_f_isRightToLeft_0);
}

// static Qt::LayoutDirection QApplication::keyboardInputDirection()


static void _init_f_keyboardInputDirection_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_keyboardInputDirection_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(QApplication::keyboardInputDirection ()));
}

static qt_gsi::GenericStaticMethod *_create_f_keyboardInputDirection_0 ()
{
  return new qt_gsi::GenericStaticMethod ("keyboardInputDirection", "@brief Static method Qt::LayoutDirection QApplication::keyboardInputDirection()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputDirection_0, &_call_f_keyboardInputDirection_0);
}

// static int QApplication::keyboardInputInterval()


static void _init_f_keyboardInputInterval_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_keyboardInputInterval_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::keyboardInputInterval ());
}

static qt_gsi::GenericStaticMethod *_create_f_keyboardInputInterval_0 ()
{
  return new qt_gsi::GenericStaticMethod (":keyboardInputInterval", "@brief Static method int QApplication::keyboardInputInterval()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputInterval_0, &_call_f_keyboardInputInterval_0);
}

// static QLocale QApplication::keyboardInputLocale()


static void _init_f_keyboardInputLocale_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QLocale > ();
}

static void _call_f_keyboardInputLocale_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QLocale > ((QLocale)QApplication::keyboardInputLocale ());
}

static qt_gsi::GenericStaticMethod *_create_f_keyboardInputLocale_0 ()
{
  return new qt_gsi::GenericStaticMethod ("keyboardInputLocale", "@brief Static method QLocale QApplication::keyboardInputLocale()\nThis method is static and can be called without an instance.", &_init_f_keyboardInputLocale_0, &_call_f_keyboardInputLocale_0);
}

// static QFlags<Qt::KeyboardModifier> QApplication::keyboardModifiers()


static void _init_f_keyboardModifiers_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type > ();
}

static void _call_f_keyboardModifiers_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type > ((qt_gsi::Converter<QFlags<Qt::KeyboardModifier> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::KeyboardModifier> >(QApplication::keyboardModifiers ()));
}

static qt_gsi::GenericStaticMethod *_create_f_keyboardModifiers_0 ()
{
  return new qt_gsi::GenericStaticMethod ("keyboardModifiers", "@brief Static method QFlags<Qt::KeyboardModifier> QApplication::keyboardModifiers()\nThis method is static and can be called without an instance.", &_init_f_keyboardModifiers_0, &_call_f_keyboardModifiers_0);
}

// static Qt::LayoutDirection QApplication::layoutDirection()


static void _init_f_layoutDirection_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ();
}

static void _call_f_layoutDirection_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<Qt::LayoutDirection>::target_type > ((qt_gsi::Converter<Qt::LayoutDirection>::target_type)qt_gsi::CppToQtAdaptor<Qt::LayoutDirection>(QApplication::layoutDirection ()));
}

static qt_gsi::GenericStaticMethod *_create_f_layoutDirection_0 ()
{
  return new qt_gsi::GenericStaticMethod (":layoutDirection", "@brief Static method Qt::LayoutDirection QApplication::layoutDirection()\nThis method is static and can be called without an instance.", &_init_f_layoutDirection_0, &_call_f_layoutDirection_0);
}

// static QFlags<Qt::MouseButton> QApplication::mouseButtons()


static void _init_f_mouseButtons_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type > ();
}

static void _call_f_mouseButtons_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type > ((qt_gsi::Converter<QFlags<Qt::MouseButton> >::target_type)qt_gsi::CppToQtAdaptor<QFlags<Qt::MouseButton> >(QApplication::mouseButtons ()));
}

static qt_gsi::GenericStaticMethod *_create_f_mouseButtons_0 ()
{
  return new qt_gsi::GenericStaticMethod ("mouseButtons", "@brief Static method QFlags<Qt::MouseButton> QApplication::mouseButtons()\nThis method is static and can be called without an instance.", &_init_f_mouseButtons_0, &_call_f_mouseButtons_0);
}

// static QCursor *QApplication::overrideCursor()


static void _init_f_overrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QCursor * > ();
}

static void _call_f_overrideCursor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QCursor * > ((QCursor *)QApplication::overrideCursor ());
}

static qt_gsi::GenericStaticMethod *_create_f_overrideCursor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("overrideCursor", "@brief Static method QCursor *QApplication::overrideCursor()\nThis method is static and can be called without an instance.", &_init_f_overrideCursor_0, &_call_f_overrideCursor_0);
}

// static QPalette QApplication::palette()


static void _init_f_palette_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QPalette > ();
}

static void _call_f_palette_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QPalette > ((QPalette)QApplication::palette ());
}

static qt_gsi::GenericStaticMethod *_create_f_palette_0 ()
{
  return new qt_gsi::GenericStaticMethod (":palette", "@brief Static method QPalette QApplication::palette()\nThis method is static and can be called without an instance.", &_init_f_palette_0, &_call_f_palette_0);
}

// static QPalette QApplication::palette(const QWidget *)


static void _init_f_palette_2010 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QWidget * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_2010 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QWidget *arg1 = args.read<const QWidget * > ();
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_palette_2010 ()
{
  return new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const QWidget *)\nThis method is static and can be called without an instance.", &_init_f_palette_2010, &_call_f_palette_2010);
}

// static QPalette QApplication::palette(const char *className)


static void _init_f_palette_1731 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("className");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<QPalette > ();
}

static void _call_f_palette_1731 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<QPalette > ((QPalette)QApplication::palette (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_palette_1731 ()
{
  return new qt_gsi::GenericStaticMethod ("palette", "@brief Static method QPalette QApplication::palette(const char *className)\nThis method is static and can be called without an instance.", &_init_f_palette_1731, &_call_f_palette_1731);
}

// static bool QApplication::quitOnLastWindowClosed()


static void _init_f_quitOnLastWindowClosed_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_quitOnLastWindowClosed_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QApplication::quitOnLastWindowClosed ());
}

static qt_gsi::GenericStaticMethod *_create_f_quitOnLastWindowClosed_0 ()
{
  return new qt_gsi::GenericStaticMethod (":quitOnLastWindowClosed", "@brief Static method bool QApplication::quitOnLastWindowClosed()\nThis method is static and can be called without an instance.", &_init_f_quitOnLastWindowClosed_0, &_call_f_quitOnLastWindowClosed_0);
}

// static void QApplication::restoreOverrideCursor()


static void _init_f_restoreOverrideCursor_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_restoreOverrideCursor_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication::restoreOverrideCursor ();
}

static qt_gsi::GenericStaticMethod *_create_f_restoreOverrideCursor_0 ()
{
  return new qt_gsi::GenericStaticMethod ("restoreOverrideCursor", "@brief Static method void QApplication::restoreOverrideCursor()\nThis method is static and can be called without an instance.", &_init_f_restoreOverrideCursor_0, &_call_f_restoreOverrideCursor_0);
}

// static void QApplication::setActiveWindow(QWidget *act)


static void _init_f_setActiveWindow_1315 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("act");
  decl->add_arg<QWidget * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setActiveWindow_1315 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QWidget *arg1 = args.read<QWidget * > ();
  QApplication::setActiveWindow (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setActiveWindow_1315 ()
{
  return new qt_gsi::GenericStaticMethod ("setActiveWindow|activeWindow=", "@brief Static method void QApplication::setActiveWindow(QWidget *act)\nThis method is static and can be called without an instance.", &_init_f_setActiveWindow_1315, &_call_f_setActiveWindow_1315);
}

// static void QApplication::setColorSpec(int)


static void _init_f_setColorSpec_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setColorSpec_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setColorSpec (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setColorSpec_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setColorSpec|colorSpec=", "@brief Static method void QApplication::setColorSpec(int)\nThis method is static and can be called without an instance.", &_init_f_setColorSpec_767, &_call_f_setColorSpec_767);
}

// static void QApplication::setCursorFlashTime(int)


static void _init_f_setCursorFlashTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCursorFlashTime_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setCursorFlashTime (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setCursorFlashTime_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setCursorFlashTime|cursorFlashTime=", "@brief Static method void QApplication::setCursorFlashTime(int)\nThis method is static and can be called without an instance.", &_init_f_setCursorFlashTime_767, &_call_f_setCursorFlashTime_767);
}

// static void QApplication::setDesktopSettingsAware(bool)


static void _init_f_setDesktopSettingsAware_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDesktopSettingsAware_864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  QApplication::setDesktopSettingsAware (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setDesktopSettingsAware_864 ()
{
  return new qt_gsi::GenericStaticMethod ("setDesktopSettingsAware|desktopSettingsAware=", "@brief Static method void QApplication::setDesktopSettingsAware(bool)\nThis method is static and can be called without an instance.", &_init_f_setDesktopSettingsAware_864, &_call_f_setDesktopSettingsAware_864);
}

// static void QApplication::setDoubleClickInterval(int)


static void _init_f_setDoubleClickInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setDoubleClickInterval_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setDoubleClickInterval (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setDoubleClickInterval_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setDoubleClickInterval|doubleClickInterval=", "@brief Static method void QApplication::setDoubleClickInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setDoubleClickInterval_767, &_call_f_setDoubleClickInterval_767);
}

// static void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)


static void _init_f_setEffectEnabled_2252 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const qt_gsi::Converter<Qt::UIEffect>::target_type & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("enable", true, "true");
  decl->add_arg<bool > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setEffectEnabled_2252 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::UIEffect>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::UIEffect>::target_type & > ();
  bool arg2 = args ? args.read<bool > () : (bool)(true);
  QApplication::setEffectEnabled (qt_gsi::QtToCppAdaptor<Qt::UIEffect>(arg1).cref(), arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setEffectEnabled_2252 ()
{
  return new qt_gsi::GenericStaticMethod ("setEffectEnabled", "@brief Static method void QApplication::setEffectEnabled(Qt::UIEffect, bool enable)\nThis method is static and can be called without an instance.", &_init_f_setEffectEnabled_2252, &_call_f_setEffectEnabled_2252);
}

// static void QApplication::setFont(const QFont &, const char *className)


static void _init_f_setFont_3424 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QFont & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setFont_3424 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QFont &arg1 = args.read<const QFont & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  QApplication::setFont (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setFont_3424 ()
{
  return new qt_gsi::GenericStaticMethod ("setFont", "@brief Static method void QApplication::setFont(const QFont &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setFont_3424, &_call_f_setFont_3424);
}

// static void QApplication::setGlobalStrut(const QSize &)


static void _init_f_setGlobalStrut_1805 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QSize & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGlobalStrut_1805 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QSize &arg1 = args.read<const QSize & > ();
  QApplication::setGlobalStrut (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setGlobalStrut_1805 ()
{
  return new qt_gsi::GenericStaticMethod ("setGlobalStrut|globalStrut=", "@brief Static method void QApplication::setGlobalStrut(const QSize &)\nThis method is static and can be called without an instance.", &_init_f_setGlobalStrut_1805, &_call_f_setGlobalStrut_1805);
}

// static void QApplication::setGraphicsSystem(const QString &)


static void _init_f_setGraphicsSystem_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setGraphicsSystem_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  QApplication::setGraphicsSystem (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setGraphicsSystem_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setGraphicsSystem", "@brief Static method void QApplication::setGraphicsSystem(const QString &)\nThis method is static and can be called without an instance.", &_init_f_setGraphicsSystem_2025, &_call_f_setGraphicsSystem_2025);
}

// static void QApplication::setKeyboardInputInterval(int)


static void _init_f_setKeyboardInputInterval_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setKeyboardInputInterval_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setKeyboardInputInterval (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setKeyboardInputInterval_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setKeyboardInputInterval|keyboardInputInterval=", "@brief Static method void QApplication::setKeyboardInputInterval(int)\nThis method is static and can be called without an instance.", &_init_f_setKeyboardInputInterval_767, &_call_f_setKeyboardInputInterval_767);
}

// static void QApplication::setLayoutDirection(Qt::LayoutDirection direction)


static void _init_f_setLayoutDirection_2316 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("direction");
  decl->add_arg<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setLayoutDirection_2316 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const qt_gsi::Converter<Qt::LayoutDirection>::target_type & arg1 = args.read<const qt_gsi::Converter<Qt::LayoutDirection>::target_type & > ();
  QApplication::setLayoutDirection (qt_gsi::QtToCppAdaptor<Qt::LayoutDirection>(arg1).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_setLayoutDirection_2316 ()
{
  return new qt_gsi::GenericStaticMethod ("setLayoutDirection|layoutDirection=", "@brief Static method void QApplication::setLayoutDirection(Qt::LayoutDirection direction)\nThis method is static and can be called without an instance.", &_init_f_setLayoutDirection_2316, &_call_f_setLayoutDirection_2316);
}

// static void QApplication::setOverrideCursor(const QCursor &)


static void _init_f_setOverrideCursor_2032 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QCursor & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setOverrideCursor_2032 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QCursor &arg1 = args.read<const QCursor & > ();
  QApplication::setOverrideCursor (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setOverrideCursor_2032 ()
{
  return new qt_gsi::GenericStaticMethod ("setOverrideCursor", "@brief Static method void QApplication::setOverrideCursor(const QCursor &)\nThis method is static and can be called without an instance.", &_init_f_setOverrideCursor_2032, &_call_f_setOverrideCursor_2032);
}

// static void QApplication::setPalette(const QPalette &, const char *className)


static void _init_f_setPalette_3736 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QPalette & > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("className", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<void > ();
}

static void _call_f_setPalette_3736 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPalette &arg1 = args.read<const QPalette & > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  QApplication::setPalette (arg1, arg2);
}

static qt_gsi::GenericStaticMethod *_create_f_setPalette_3736 ()
{
  return new qt_gsi::GenericStaticMethod ("setPalette", "@brief Static method void QApplication::setPalette(const QPalette &, const char *className)\nThis method is static and can be called without an instance.", &_init_f_setPalette_3736, &_call_f_setPalette_3736);
}

// static void QApplication::setQuitOnLastWindowClosed(bool quit)


static void _init_f_setQuitOnLastWindowClosed_864 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("quit");
  decl->add_arg<bool > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setQuitOnLastWindowClosed_864 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  bool arg1 = args.read<bool > ();
  QApplication::setQuitOnLastWindowClosed (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setQuitOnLastWindowClosed_864 ()
{
  return new qt_gsi::GenericStaticMethod ("setQuitOnLastWindowClosed|quitOnLastWindowClosed=", "@brief Static method void QApplication::setQuitOnLastWindowClosed(bool quit)\nThis method is static and can be called without an instance.", &_init_f_setQuitOnLastWindowClosed_864, &_call_f_setQuitOnLastWindowClosed_864);
}

// static void QApplication::setStartDragDistance(int l)


static void _init_f_setStartDragDistance_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("l");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragDistance_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setStartDragDistance (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setStartDragDistance_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setStartDragDistance|startDragDistance=", "@brief Static method void QApplication::setStartDragDistance(int l)\nThis method is static and can be called without an instance.", &_init_f_setStartDragDistance_767, &_call_f_setStartDragDistance_767);
}

// static void QApplication::setStartDragTime(int ms)


static void _init_f_setStartDragTime_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("ms");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStartDragTime_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setStartDragTime (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setStartDragTime_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setStartDragTime|startDragTime=", "@brief Static method void QApplication::setStartDragTime(int ms)\nThis method is static and can be called without an instance.", &_init_f_setStartDragTime_767, &_call_f_setStartDragTime_767);
}

// static void QApplication::setStyle(QStyle *)


static void _init_f_setStyle_1232 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QStyle * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setStyle_1232 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QStyle *arg1 = args.read<QStyle * > ();
  QApplication::setStyle (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setStyle_1232 ()
{
  return new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method void QApplication::setStyle(QStyle *)\nThis method is static and can be called without an instance.", &_init_f_setStyle_1232, &_call_f_setStyle_1232);
}

// static QStyle *QApplication::setStyle(const QString &)


static void _init_f_setStyle_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<QStyle * > ();
}

static void _call_f_setStyle_2025 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QString &arg1 = args.read<const QString & > ();
  ret.write<QStyle * > ((QStyle *)QApplication::setStyle (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_setStyle_2025 ()
{
  return new qt_gsi::GenericStaticMethod ("setStyle|style=", "@brief Static method QStyle *QApplication::setStyle(const QString &)\nThis method is static and can be called without an instance.", &_init_f_setStyle_2025, &_call_f_setStyle_2025);
}

// static void QApplication::setWheelScrollLines(int)


static void _init_f_setWheelScrollLines_767 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWheelScrollLines_767 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  QApplication::setWheelScrollLines (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setWheelScrollLines_767 ()
{
  return new qt_gsi::GenericStaticMethod ("setWheelScrollLines|wheelScrollLines=", "@brief Static method void QApplication::setWheelScrollLines(int)\nThis method is static and can be called without an instance.", &_init_f_setWheelScrollLines_767, &_call_f_setWheelScrollLines_767);
}

// static void QApplication::setWindowIcon(const QIcon &icon)


static void _init_f_setWindowIcon_1787 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("icon");
  decl->add_arg<const QIcon & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setWindowIcon_1787 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QIcon &arg1 = args.read<const QIcon & > ();
  QApplication::setWindowIcon (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setWindowIcon_1787 ()
{
  return new qt_gsi::GenericStaticMethod ("setWindowIcon|windowIcon=", "@brief Static method void QApplication::setWindowIcon(const QIcon &icon)\nThis method is static and can be called without an instance.", &_init_f_setWindowIcon_1787, &_call_f_setWindowIcon_1787);
}

// static int QApplication::startDragDistance()


static void _init_f_startDragDistance_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragDistance_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::startDragDistance ());
}

static qt_gsi::GenericStaticMethod *_create_f_startDragDistance_0 ()
{
  return new qt_gsi::GenericStaticMethod (":startDragDistance", "@brief Static method int QApplication::startDragDistance()\nThis method is static and can be called without an instance.", &_init_f_startDragDistance_0, &_call_f_startDragDistance_0);
}

// static int QApplication::startDragTime()


static void _init_f_startDragTime_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_startDragTime_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::startDragTime ());
}

static qt_gsi::GenericStaticMethod *_create_f_startDragTime_0 ()
{
  return new qt_gsi::GenericStaticMethod (":startDragTime", "@brief Static method int QApplication::startDragTime()\nThis method is static and can be called without an instance.", &_init_f_startDragTime_0, &_call_f_startDragTime_0);
}

// static QStyle *QApplication::style()


static void _init_f_style_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QStyle * > ();
}

static void _call_f_style_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QStyle * > ((QStyle *)QApplication::style ());
}

static qt_gsi::GenericStaticMethod *_create_f_style_0 ()
{
  return new qt_gsi::GenericStaticMethod (":style", "@brief Static method QStyle *QApplication::style()\nThis method is static and can be called without an instance.", &_init_f_style_0, &_call_f_style_0);
}

// static void QApplication::syncX()


static void _init_f_syncX_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_syncX_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QApplication::syncX ();
}

static qt_gsi::GenericStaticMethod *_create_f_syncX_0 ()
{
  return new qt_gsi::GenericStaticMethod ("syncX", "@brief Static method void QApplication::syncX()\nThis method is static and can be called without an instance.", &_init_f_syncX_0, &_call_f_syncX_0);
}

// static QWidget *QApplication::topLevelAt(const QPoint &p)


static void _init_f_topLevelAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1916 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_topLevelAt_1916 ()
{
  return new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1916, &_call_f_topLevelAt_1916);
}

// static QWidget *QApplication::topLevelAt(int x, int y)


static void _init_f_topLevelAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_topLevelAt_1426 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)QApplication::topLevelAt (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_topLevelAt_1426 ()
{
  return new qt_gsi::GenericStaticMethod ("topLevelAt", "@brief Static method QWidget *QApplication::topLevelAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_topLevelAt_1426, &_call_f_topLevelAt_1426);
}

// static QList<QWidget *> QApplication::topLevelWidgets()


static void _init_f_topLevelWidgets_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QList<QWidget *> >::target_type > ();
}

static void _call_f_topLevelWidgets_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QList<QWidget *> >::target_type > ((qt_gsi::Converter<QList<QWidget *> >::target_type)qt_gsi::CppToQtAdaptor<QList<QWidget *> >(QApplication::topLevelWidgets ()));
}

static qt_gsi::GenericStaticMethod *_create_f_topLevelWidgets_0 ()
{
  return new qt_gsi::GenericStaticMethod ("topLevelWidgets", "@brief Static method QList<QWidget *> QApplication::topLevelWidgets()\nThis method is static and can be called without an instance.", &_init_f_topLevelWidgets_0, &_call_f_topLevelWidgets_0);
}

// static QString QApplication::tr(const char *s, const char *c)


static void _init_f_tr_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_tr_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QApplication::tr (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QApplication::tr(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_tr_3354, &_call_f_tr_3354);
}

// static QString QApplication::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QApplication::tr (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_tr_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QApplication::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
}

// static QString QApplication::trUtf8(const char *s, const char *c)


static void _init_f_trUtf8_3354 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "0");
  decl->add_arg<const char * > (argspec_1);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_3354 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args ? args.read<const char * > () : (const char *)(0);
  ret.write<QString > ((QString)QApplication::trUtf8 (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_3354 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QApplication::trUtf8(const char *s, const char *c)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_3354, &_call_f_trUtf8_3354);
}

// static QString QApplication::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  const char *arg2 = args.read<const char * > ();
  int arg3 = args.read<int > ();
  ret.write<QString > ((QString)QApplication::trUtf8 (arg1, arg2, arg3));
}

static qt_gsi::GenericStaticMethod *_create_f_trUtf8_4013 ()
{
  return new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QApplication::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
}

// static QApplication::Type QApplication::type()


static void _init_f_type_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<qt_gsi::Converter<QApplication::Type>::target_type > ();
}

static void _call_f_type_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<qt_gsi::Converter<QApplication::Type>::target_type > ((qt_gsi::Converter<QApplication::Type>::target_type)qt_gsi::CppToQtAdaptor<QApplication::Type>(QApplication::type ()));
}

static qt_gsi::GenericStaticMethod *_create_f_type_0 ()
{
  return new qt_gsi::GenericStaticMethod ("type", "@brief Static method QApplication::Type QApplication::type()\nThis method is static and can be called without an instance.", &_init_f_type_0, &_call_f_type_0);
}

// static int QApplication::wheelScrollLines()


static void _init_f_wheelScrollLines_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_wheelScrollLines_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<int > ((int)QApplication::wheelScrollLines ());
}

static qt_gsi::GenericStaticMethod *_create_f_wheelScrollLines_0 ()
{
  return new qt_gsi::GenericStaticMethod (":wheelScrollLines", "@brief Static method int QApplication::wheelScrollLines()\nThis method is static and can be called without an instance.", &_init_f_wheelScrollLines_0, &_call_f_wheelScrollLines_0);
}

// static QWidget *QApplication::widgetAt(const QPoint &p)


static void _init_f_widgetAt_1916 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("p");
  decl->add_arg<const QPoint & > (argspec_0);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1916 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const QPoint &arg1 = args.read<const QPoint & > ();
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_widgetAt_1916 ()
{
  return new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(const QPoint &p)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1916, &_call_f_widgetAt_1916);
}

// static QWidget *QApplication::widgetAt(int x, int y)


static void _init_f_widgetAt_1426 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("x");
  decl->add_arg<int > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("y");
  decl->add_arg<int > (argspec_1);
  decl->set_return<QWidget * > ();
}

static void _call_f_widgetAt_1426 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  int arg1 = args.read<int > ();
  int arg2 = args.read<int > ();
  ret.write<QWidget * > ((QWidget *)QApplication::widgetAt (arg1, arg2));
}

static qt_gsi::GenericStaticMethod *_create_f_widgetAt_1426 ()
{
  return new qt_gsi::GenericStaticMethod ("widgetAt", "@brief Static method QWidget *QApplication::widgetAt(int x, int y)\nThis method is static and can be called without an instance.", &_init_f_widgetAt_1426, &_call_f_widgetAt_1426);
}

// static QIcon QApplication::windowIcon()


static void _init_f_windowIcon_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<QIcon > ();
}

static void _call_f_windowIcon_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QIcon > ((QIcon)QApplication::windowIcon ());
}

static qt_gsi::GenericStaticMethod *_create_f_windowIcon_0 ()
{
  return new qt_gsi::GenericStaticMethod (":windowIcon", "@brief Static method QIcon QApplication::windowIcon()\nThis method is static and can be called without an instance.", &_init_f_windowIcon_0, &_call_f_windowIcon_0);
}

static qt_gsi::QObjectConnector<QApplication, QApplication_EventAdaptor> ea_QApplication;

namespace gsi
{
extern gsi::Class<QCoreApplication> decl_QCoreApplication;

gsi::Class<QApplication> decl_QApplication (ea_QApplication, decl_QCoreApplication, "QApplication_Native",
  gsi::constructor("new_app", &ctor_QApplication, "@brief Creates a new QApplication object\n\nThis implementation is provided for test purposes only. It is not required usually to create a QApplication object. Use the object provided by QApplication::instance instead.")
+
  gsi::Methods(_create_smo ()) +
  gsi::Methods(_create_f_autoSipEnabled_c0 ()) +
  gsi::Methods(_create_f_inputContext_c0 ()) +
  gsi::Methods(_create_f_notify_2411 ()) +
  gsi::Methods(_create_f_setAutoSipEnabled_1559 ()) +
  gsi::Methods(_create_f_setInputContext_1972 ()) +
  gsi::Methods(_create_f_setStyleSheet_2025 ()) +
  gsi::Methods(_create_f_styleSheet_c0 ()) +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor> ("aboutToQuit", &QApplication_EventAdaptor::aboutToQuit_e_0, "@brief Signal declaration for QApplication::aboutToQuit()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor, QObject *> ("destroyed", &QApplication_EventAdaptor::destroyed_e_1302, gsi::arg("arg1"), "@brief Signal declaration for QApplication::destroyed(QObject *)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor, QWidget *, QWidget *> ("focusChanged", &QApplication_EventAdaptor::focusChanged_e_2522, gsi::arg("old"), gsi::arg("now"), "@brief Signal declaration for QApplication::focusChanged(QWidget *old, QWidget *now)\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor> ("fontDatabaseChanged", &QApplication_EventAdaptor::fontDatabaseChanged_e_0, "@brief Signal declaration for QApplication::fontDatabaseChanged()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor> ("lastWindowClosed", &QApplication_EventAdaptor::lastWindowClosed_e_0, "@brief Signal declaration for QApplication::lastWindowClosed()\nYou can bind a procedure to this signal.") +
  qt_gsi::qt_signal<QApplication, QApplication_EventAdaptor, int> ("unixSignal", &QApplication_EventAdaptor::unixSignal_e_767, gsi::arg("arg1"), "@brief Signal declaration for QApplication::unixSignal(int)\nYou can bind a procedure to this signal.") +
  gsi::Methods(_create_f_aboutQt_0 ()) +
  gsi::Methods(_create_f_activeModalWidget_0 ()) +
  gsi::Methods(_create_f_activePopupWidget_0 ()) +
  gsi::Methods(_create_f_activeWindow_0 ()) +
  gsi::Methods(_create_f_alert_1974 ()) +
  gsi::Methods(_create_f_allWidgets_0 ()) +
  gsi::Methods(_create_f_beep_0 ()) +
  gsi::Methods(_create_f_changeOverrideCursor_2032 ()) +
  gsi::Methods(_create_f_clipboard_0 ()) +
  gsi::Methods(_create_f_closeAllWindows_0 ()) +
  gsi::Methods(_create_f_colorSpec_0 ()) +
  gsi::Methods(_create_f_cursorFlashTime_0 ()) +
  gsi::Methods(_create_f_desktop_0 ()) +
  gsi::Methods(_create_f_desktopSettingsAware_0 ()) +
  gsi::Methods(_create_f_doubleClickInterval_0 ()) +
  gsi::Methods(_create_f_exec_0 ()) +
  gsi::Methods(_create_f_focusWidget_0 ()) +
  gsi::Methods(_create_f_font_0 ()) +
  gsi::Methods(_create_f_font_2010 ()) +
  gsi::Methods(_create_f_font_1731 ()) +
  gsi::Methods(_create_f_fontMetrics_0 ()) +
  gsi::Methods(_create_f_globalStrut_0 ()) +
  gsi::Methods(_create_f_isEffectEnabled_1496 ()) +
  gsi::Methods(_create_f_isLeftToRight_0 ()) +
  gsi::Methods(_create_f_isRightToLeft_0 ()) +
  gsi::Methods(_create_f_keyboardInputDirection_0 ()) +
  gsi::Methods(_create_f_keyboardInputInterval_0 ()) +
  gsi::Methods(_create_f_keyboardInputLocale_0 ()) +
  gsi::Methods(_create_f_keyboardModifiers_0 ()) +
  gsi::Methods(_create_f_layoutDirection_0 ()) +
  gsi::Methods(_create_f_mouseButtons_0 ()) +
  gsi::Methods(_create_f_overrideCursor_0 ()) +
  gsi::Methods(_create_f_palette_0 ()) +
  gsi::Methods(_create_f_palette_2010 ()) +
  gsi::Methods(_create_f_palette_1731 ()) +
  gsi::Methods(_create_f_quitOnLastWindowClosed_0 ()) +
  gsi::Methods(_create_f_restoreOverrideCursor_0 ()) +
  gsi::Methods(_create_f_setActiveWindow_1315 ()) +
  gsi::Methods(_create_f_setColorSpec_767 ()) +
  gsi::Methods(_create_f_setCursorFlashTime_767 ()) +
  gsi::Methods(_create_f_setDesktopSettingsAware_864 ()) +
  gsi::Methods(_create_f_setDoubleClickInterval_767 ()) +
  gsi::Methods(_create_f_setEffectEnabled_2252 ()) +
  gsi::Methods(_create_f_setFont_3424 ()) +
  gsi::Methods(_create_f_setGlobalStrut_1805 ()) +
  gsi::Methods(_create_f_setGraphicsSystem_2025 ()) +
  gsi::Methods(_create_f_setKeyboardInputInterval_767 ()) +
  gsi::Methods(_create_f_setLayoutDirection_2316 ()) +
  gsi::Methods(_create_f_setOverrideCursor_2032 ()) +
  gsi::Methods(_create_f_setPalette_3736 ()) +
  gsi::Methods(_create_f_setQuitOnLastWindowClosed_864 ()) +
  gsi::Methods(_create_f_setStartDragDistance_767 ()) +
  gsi::Methods(_create_f_setStartDragTime_767 ()) +
  gsi::Methods(_create_f_setStyle_1232 ()) +
  gsi::Methods(_create_f_setStyle_2025 ()) +
  gsi::Methods(_create_f_setWheelScrollLines_767 ()) +
  gsi::Methods(_create_f_setWindowIcon_1787 ()) +
  gsi::Methods(_create_f_startDragDistance_0 ()) +
  gsi::Methods(_create_f_startDragTime_0 ()) +
  gsi::Methods(_create_f_style_0 ()) +
  gsi::Methods(_create_f_syncX_0 ()) +
  gsi::Methods(_create_f_topLevelAt_1916 ()) +
  gsi::Methods(_create_f_topLevelAt_1426 ()) +
  gsi::Methods(_create_f_topLevelWidgets_0 ()) +
  gsi::Methods(_create_f_tr_3354 ()) +
  gsi::Methods(_create_f_tr_4013 ()) +
  gsi::Methods(_create_f_trUtf8_3354 ()) +
  gsi::Methods(_create_f_trUtf8_4013 ()) +
  gsi::Methods(_create_f_type_0 ()) +
  gsi::Methods(_create_f_wheelScrollLines_0 ()) +
  gsi::Methods(_create_f_widgetAt_1916 ()) +
  gsi::Methods(_create_f_widgetAt_1426 ()) +
  gsi::Methods(_create_f_windowIcon_0 ()),
  "@hide\n@alias QApplication");
}


class QApplication_Adaptor : public QApplication, public qt_gsi::QtObjectBase
{
public:

  virtual ~QApplication_Adaptor();

  //  int QApplication::receivers(const char *signal)
  int fp_QApplication_receivers_c1731 (const char *signal) const {
    return QApplication::receivers(signal);
  }

  //  QObject *QApplication::sender()
  QObject * fp_QApplication_sender_c0 () const {
    return QApplication::sender();
  }

  //  [adaptor impl] bool QApplication::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QApplication::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QApplication_Adaptor, bool, QObject *, QEvent *>(&QApplication_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QApplication::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QApplication::notify(QObject *, QEvent *)
  bool cbs_notify_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QApplication::notify(arg1, arg2);
  }

  virtual bool notify(QObject *arg1, QEvent *arg2)
  {
    if (cb_notify_2411_0.can_issue()) {
      return cb_notify_2411_0.issue<QApplication_Adaptor, bool, QObject *, QEvent *>(&QApplication_Adaptor::cbs_notify_2411_0, arg1, arg2);
    } else {
      return QApplication::notify(arg1, arg2);
    }
  }

  //  [adaptor impl] void QApplication::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QApplication::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QApplication_Adaptor, QChildEvent *>(&QApplication_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QApplication::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QApplication::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QApplication::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QApplication_Adaptor, QEvent *>(&QApplication_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QApplication::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QApplication::disconnectNotify(const char *signal)
  void cbs_disconnectNotify_1731_0(const char *signal)
  {
    QApplication::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const char *signal)
  {
    if (cb_disconnectNotify_1731_0.can_issue()) {
      cb_disconnectNotify_1731_0.issue<QApplication_Adaptor, const char *>(&QApplication_Adaptor::cbs_disconnectNotify_1731_0, signal);
    } else {
      QApplication::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] bool QApplication::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QApplication::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QApplication_Adaptor, bool, QEvent *>(&QApplication_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QApplication::event(arg1);
    }
  }

  //  [adaptor impl] void QApplication::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QApplication::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QApplication_Adaptor, QTimerEvent *>(&QApplication_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QApplication::timerEvent(arg1);
    }
  }

  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_notify_2411_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_1731_0;
  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QApplication_Adaptor::~QApplication_Adaptor() { }

// int QApplication::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ret.write<int > ((int)((QApplication_Adaptor *)cls)->fp_QApplication_receivers_c1731 (arg1));
}

static qt_gsi::GenericMethod*_create_fp_receivers_c1731 ()
{
  return new qt_gsi::GenericMethod("*receivers", "@brief Method int QApplication::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
}


// QObject *QApplication::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QObject * > ((QObject *)((QApplication_Adaptor *)cls)->fp_QApplication_sender_c0 ());
}

static qt_gsi::GenericMethod*_create_fp_sender_c0 ()
{
  return new qt_gsi::GenericMethod("*sender", "@brief Method QObject *QApplication::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
}


// bool QApplication::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_eventFilter_2411_0 ()
{
  return new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QApplication::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
}


// bool QApplication::notify(QObject *, QEvent *)

static void _init_cbs_notify_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_notify_2411_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QEvent *arg2 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_notify_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_notify_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_notify_2411_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_notify_2411_0 ()
{
  return new qt_gsi::GenericMethod ("notify", "@hide", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_notify_2411_0 ()
{
  return new qt_gsi::GenericMethod ("notify", "@brief Virtual method bool QApplication::notify(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_notify_2411_0, &_call_cbs_notify_2411_0, &_set_callback_cbs_notify_2411_0);
}


// void QApplication::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QChildEvent *arg1 = args.read<QChildEvent * > ();
  ((QApplication_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_childEvent_1701_0 ()
{
  return new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QApplication::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
}


// void QApplication::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ((QApplication_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_customEvent_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QApplication::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
}


// void QApplication::disconnectNotify(const char *signal)

static void _init_cbs_disconnectNotify_1731_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_1731_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  const char *arg1 = args.read<const char * > ();
  ((QApplication_Adaptor *)cls)->cbs_disconnectNotify_1731_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_1731_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_disconnectNotify_1731_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_disconnectNotify_1731_0 ()
{
  return new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QApplication::disconnectNotify(const char *signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_1731_0, &_call_cbs_disconnectNotify_1731_0, &_set_callback_cbs_disconnectNotify_1731_0);
}


// bool QApplication::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QEvent *arg1 = args.read<QEvent * > ();
  ret.write<bool > ((bool)((QApplication_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_event_1217_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_event_1217_0 ()
{
  return new qt_gsi::GenericMethod ("*event", "@brief Virtual method bool QApplication::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
}


// void QApplication::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod *decl, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QTimerEvent *arg1 = args.read<QTimerEvent * > ();
  ((QApplication_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QApplication_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}

static qt_gsi::GenericMethod *_create_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
}

static qt_gsi::GenericMethod *_create_callback_cbs_timerEvent_1730_0 ()
{
  return new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QApplication::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
}


namespace gsi
{

extern gsi::Class<QApplication> decl_QApplication;

gsi::Class<QApplication_Adaptor> decl_QApplication_Adaptor (decl_QApplication, "QApplication",
  gsi::Methods(_create_fp_receivers_c1731 ()) +
  gsi::Methods(_create_fp_sender_c0 ()) +
  gsi::Methods(_create_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_eventFilter_2411_0 ()) +
  gsi::Methods(_create_cbs_notify_2411_0 ()) +
  gsi::Methods(_create_callback_cbs_notify_2411_0 ()) +
  gsi::Methods(_create_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_callback_cbs_childEvent_1701_0 ()) +
  gsi::Methods(_create_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_customEvent_1217_0 ()) +
  gsi::Methods(_create_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_callback_cbs_disconnectNotify_1731_0 ()) +
  gsi::Methods(_create_cbs_event_1217_0 ()) +
  gsi::Methods(_create_callback_cbs_event_1217_0 ()) +
  gsi::Methods(_create_cbs_timerEvent_1730_0 ()) +
  gsi::Methods(_create_callback_cbs_timerEvent_1730_0 ()),
  "@qt\n@brief Binding of QApplication");

}


//  Implementation of the enum wrapper class for QApplication::Type
namespace qt_gsi
{

static QApplication_Type_Enum *c_1_QApplication_Type_Enum () { return new QApplication_Type_Enum (QApplication::Tty); }
static QApplication_Type_Enum *c_2_QApplication_Type_Enum () { return new QApplication_Type_Enum (QApplication::GuiClient); }
static QApplication_Type_Enum *c_3_QApplication_Type_Enum () { return new QApplication_Type_Enum (QApplication::GuiServer); }

static gsi::Methods mkdefs_QApplication_Type () {
  return
    gsi::constant ("Tty", &qt_gsi::c_1_QApplication_Type_Enum, "@brief Enum constant QApplication::Tty") +
    gsi::constant ("GuiClient", &qt_gsi::c_2_QApplication_Type_Enum, "@brief Enum constant QApplication::GuiClient") +
    gsi::constant ("GuiServer", &qt_gsi::c_3_QApplication_Type_Enum, "@brief Enum constant QApplication::GuiServer");
}

static std::string to_s_QApplication_Type_Enum (const QApplication_Type_Enum *e)
{
  if (e->value () == QApplication::Tty) { return tl::sprintf ("Tty (%u)", (unsigned int) e->value ()); }
  if (e->value () == QApplication::GuiClient) { return tl::sprintf ("GuiClient (%u)", (unsigned int) e->value ()); }
  if (e->value () == QApplication::GuiServer) { return tl::sprintf ("GuiServer (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QApplication_Type_Enum (const QApplication_Type_Enum *e)
{
  return (unsigned int) e->value ();
}

static QApplication_Type_Enum *from_i_QApplication_Type_Enum (unsigned int i)
{
  return new QApplication_Type_Enum ((QApplication::Type) i);
}

static bool equalQApplication_Type_Enum (const QApplication_Type_Enum *e, QApplication_Type_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QApplication_Type_Enum (const QApplication_Type_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QApplication_Type_Enums oropQApplication_Type_Enums (const QApplication_Type_Enums *e, const QApplication_Type_Enums &d)
{
  return e->flags () | d.flags ();
}

static QApplication_Type_Enums andopQApplication_Type_Enums (const QApplication_Type_Enums *e, const QApplication_Type_Enums &d)
{
  return e->flags () & d.flags ();
}

static QApplication_Type_Enums xoropQApplication_Type_Enums (const QApplication_Type_Enums *e, const QApplication_Type_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QApplication_Type_Enums (const QApplication_Type_Enums *e)
{
  std::string l;
  if (e->testFlag (QApplication::Tty)) { if (!l.empty ()) l += "|"; l += "Tty"; }
  if (e->testFlag (QApplication::GuiClient)) { if (!l.empty ()) l += "|"; l += "GuiClient"; }
  if (e->testFlag (QApplication::GuiServer)) { if (!l.empty ()) l += "|"; l += "GuiServer"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QApplication_Type_Enums (const QApplication_Type_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QApplication_Type_Enums (const QApplication_Type_Enums *e, const QApplication_Type_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QApplication_Type_Enums> decl_QApplication_Type_Enums ("QApplication_QFlags_Type",
  gsi::method_ext ("|", &qt_gsi::oropQApplication_Type_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQApplication_Type_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQApplication_Type_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QApplication_Type_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QApplication_Type_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QApplication_Type_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QApplication::Type> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QApplication_Type_Enum> decl_QApplication_Type_Enum (decl_QApplication_Type_Enums, "QApplication_Type",
  qt_gsi::mkdefs_QApplication_Type () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QApplication_Type_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QApplication_Type_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQApplication_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QApplication_Type_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QApplication_Type_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QApplication::Type enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QApplication> inject_QApplication_Type_Enum_in_parent (qt_gsi::mkdefs_QApplication_Type ());
static gsi::ClassExt<QApplication> decl_QApplication_Type_Enum_as_child (decl_QApplication_Type_Enum, "Type");

}

