
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2016 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQAccessible.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include "gsiQtGui.h"
#include "gsiDeclQtTypeTraits.h"
#include "gsiDeclQAccessible_Enums.h"
#include <memory>

// -----------------------------------------------------------------------
// class QAccessible

//  Constructor QAccessible::QAccessible()


static void _init_ctor_QAccessible_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return_new<QAccessible *> ();
}

static void _call_ctor_QAccessible_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<QAccessible *> (new QAccessible ());
}

static qt_gsi::GenericStaticMethod *_create_ctor_QAccessible_0 ()
{
  return new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QAccessible::QAccessible()\nThis method creates an object of class QAccessible.", &_init_ctor_QAccessible_0, &_call_ctor_QAccessible_0);
}

// static void QAccessible::cleanup()


static void _init_f_cleanup_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<void > ();
}

static void _call_f_cleanup_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QAccessible::cleanup ();
}

static qt_gsi::GenericStaticMethod *_create_f_cleanup_0 ()
{
  return new qt_gsi::GenericStaticMethod ("cleanup", "@brief Static method void QAccessible::cleanup()\nThis method is static and can be called without an instance.", &_init_f_cleanup_0, &_call_f_cleanup_0);
}

// static bool QAccessible::isActive()


static void _init_f_isActive_0 (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_isActive_0 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  ret.write<bool > ((bool)QAccessible::isActive ());
}

static qt_gsi::GenericStaticMethod *_create_f_isActive_0 ()
{
  return new qt_gsi::GenericStaticMethod ("isActive?", "@brief Static method bool QAccessible::isActive()\nThis method is static and can be called without an instance.", &_init_f_isActive_0, &_call_f_isActive_0);
}

// static QAccessibleInterface *QAccessible::queryAccessibleInterface(QObject *)


static void _init_f_queryAccessibleInterface_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<QAccessibleInterface * > ();
}

static void _call_f_queryAccessibleInterface_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  ret.write<QAccessibleInterface * > ((QAccessibleInterface *)QAccessible::queryAccessibleInterface (arg1));
}

static qt_gsi::GenericStaticMethod *_create_f_queryAccessibleInterface_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("queryAccessibleInterface", "@brief Static method QAccessibleInterface *QAccessible::queryAccessibleInterface(QObject *)\nThis method is static and can be called without an instance.", &_init_f_queryAccessibleInterface_1302, &_call_f_queryAccessibleInterface_1302);
}

// static void QAccessible::setRootObject(QObject *)


static void _init_f_setRootObject_1302 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setRootObject_1302 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  QAccessible::setRootObject (arg1);
}

static qt_gsi::GenericStaticMethod *_create_f_setRootObject_1302 ()
{
  return new qt_gsi::GenericStaticMethod ("setRootObject", "@brief Static method void QAccessible::setRootObject(QObject *)\nThis method is static and can be called without an instance.", &_init_f_setRootObject_1302, &_call_f_setRootObject_1302);
}

// static void QAccessible::updateAccessibility(QObject *, int who, QAccessible::Event reason)


static void _init_f_updateAccessibility_4006 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("who");
  decl->add_arg<int > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("reason");
  decl->add_arg<const qt_gsi::Converter<QAccessible::Event>::target_type & > (argspec_2);
  decl->set_return<void > ();
}

static void _call_f_updateAccessibility_4006 (const qt_gsi::GenericStaticMethod *decl, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  QObject *arg1 = args.read<QObject * > ();
  int arg2 = args.read<int > ();
  const qt_gsi::Converter<QAccessible::Event>::target_type & arg3 = args.read<const qt_gsi::Converter<QAccessible::Event>::target_type & > ();
  QAccessible::updateAccessibility (arg1, arg2, qt_gsi::QtToCppAdaptor<QAccessible::Event>(arg3).cref());
}

static qt_gsi::GenericStaticMethod *_create_f_updateAccessibility_4006 ()
{
  return new qt_gsi::GenericStaticMethod ("updateAccessibility", "@brief Static method void QAccessible::updateAccessibility(QObject *, int who, QAccessible::Event reason)\nThis method is static and can be called without an instance.", &_init_f_updateAccessibility_4006, &_call_f_updateAccessibility_4006);
}


namespace gsi
{
gsi::Class<QAccessible> decl_QAccessible ("QAccessible",
  gsi::Methods(_create_ctor_QAccessible_0 ()) +
  gsi::Methods(_create_f_cleanup_0 ()) +
  gsi::Methods(_create_f_isActive_0 ()) +
  gsi::Methods(_create_f_queryAccessibleInterface_1302 ()) +
  gsi::Methods(_create_f_setRootObject_1302 ()) +
  gsi::Methods(_create_f_updateAccessibility_4006 ()),
  "@qt\n@brief Binding of QAccessible");

}


//  Implementation of the enum wrapper class for QAccessible::Event
namespace qt_gsi
{

static QAccessible_Event_Enum *c_1_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::SoundPlayed); }
static QAccessible_Event_Enum *c_2_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::Alert); }
static QAccessible_Event_Enum *c_3_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ForegroundChanged); }
static QAccessible_Event_Enum *c_4_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::MenuStart); }
static QAccessible_Event_Enum *c_5_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::MenuEnd); }
static QAccessible_Event_Enum *c_6_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::PopupMenuStart); }
static QAccessible_Event_Enum *c_7_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::PopupMenuEnd); }
static QAccessible_Event_Enum *c_8_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ContextHelpStart); }
static QAccessible_Event_Enum *c_9_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ContextHelpEnd); }
static QAccessible_Event_Enum *c_10_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DragDropStart); }
static QAccessible_Event_Enum *c_11_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DragDropEnd); }
static QAccessible_Event_Enum *c_12_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DialogStart); }
static QAccessible_Event_Enum *c_13_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DialogEnd); }
static QAccessible_Event_Enum *c_14_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ScrollingStart); }
static QAccessible_Event_Enum *c_15_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ScrollingEnd); }
static QAccessible_Event_Enum *c_16_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::MenuCommand); }
static QAccessible_Event_Enum *c_17_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ObjectCreated); }
static QAccessible_Event_Enum *c_18_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ObjectDestroyed); }
static QAccessible_Event_Enum *c_19_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ObjectShow); }
static QAccessible_Event_Enum *c_20_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ObjectHide); }
static QAccessible_Event_Enum *c_21_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ObjectReorder); }
static QAccessible_Event_Enum *c_22_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::Focus); }
static QAccessible_Event_Enum *c_23_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::Selection); }
static QAccessible_Event_Enum *c_24_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::SelectionAdd); }
static QAccessible_Event_Enum *c_25_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::SelectionRemove); }
static QAccessible_Event_Enum *c_26_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::SelectionWithin); }
static QAccessible_Event_Enum *c_27_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::StateChanged); }
static QAccessible_Event_Enum *c_28_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::LocationChanged); }
static QAccessible_Event_Enum *c_29_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::NameChanged); }
static QAccessible_Event_Enum *c_30_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DescriptionChanged); }
static QAccessible_Event_Enum *c_31_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ValueChanged); }
static QAccessible_Event_Enum *c_32_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::ParentChanged); }
static QAccessible_Event_Enum *c_33_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::HelpChanged); }
static QAccessible_Event_Enum *c_34_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::DefaultActionChanged); }
static QAccessible_Event_Enum *c_35_QAccessible_Event_Enum () { return new QAccessible_Event_Enum (QAccessible::AcceleratorChanged); }

static gsi::Methods mkdefs_QAccessible_Event () {
  return
    gsi::constant ("SoundPlayed", &qt_gsi::c_1_QAccessible_Event_Enum, "@brief Enum constant QAccessible::SoundPlayed") +
    gsi::constant ("Alert", &qt_gsi::c_2_QAccessible_Event_Enum, "@brief Enum constant QAccessible::Alert") +
    gsi::constant ("ForegroundChanged", &qt_gsi::c_3_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ForegroundChanged") +
    gsi::constant ("MenuStart", &qt_gsi::c_4_QAccessible_Event_Enum, "@brief Enum constant QAccessible::MenuStart") +
    gsi::constant ("MenuEnd", &qt_gsi::c_5_QAccessible_Event_Enum, "@brief Enum constant QAccessible::MenuEnd") +
    gsi::constant ("PopupMenuStart", &qt_gsi::c_6_QAccessible_Event_Enum, "@brief Enum constant QAccessible::PopupMenuStart") +
    gsi::constant ("PopupMenuEnd", &qt_gsi::c_7_QAccessible_Event_Enum, "@brief Enum constant QAccessible::PopupMenuEnd") +
    gsi::constant ("ContextHelpStart", &qt_gsi::c_8_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ContextHelpStart") +
    gsi::constant ("ContextHelpEnd", &qt_gsi::c_9_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ContextHelpEnd") +
    gsi::constant ("DragDropStart", &qt_gsi::c_10_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DragDropStart") +
    gsi::constant ("DragDropEnd", &qt_gsi::c_11_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DragDropEnd") +
    gsi::constant ("DialogStart", &qt_gsi::c_12_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DialogStart") +
    gsi::constant ("DialogEnd", &qt_gsi::c_13_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DialogEnd") +
    gsi::constant ("ScrollingStart", &qt_gsi::c_14_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ScrollingStart") +
    gsi::constant ("ScrollingEnd", &qt_gsi::c_15_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ScrollingEnd") +
    gsi::constant ("MenuCommand", &qt_gsi::c_16_QAccessible_Event_Enum, "@brief Enum constant QAccessible::MenuCommand") +
    gsi::constant ("ObjectCreated", &qt_gsi::c_17_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ObjectCreated") +
    gsi::constant ("ObjectDestroyed", &qt_gsi::c_18_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ObjectDestroyed") +
    gsi::constant ("ObjectShow", &qt_gsi::c_19_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ObjectShow") +
    gsi::constant ("ObjectHide", &qt_gsi::c_20_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ObjectHide") +
    gsi::constant ("ObjectReorder", &qt_gsi::c_21_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ObjectReorder") +
    gsi::constant ("Focus", &qt_gsi::c_22_QAccessible_Event_Enum, "@brief Enum constant QAccessible::Focus") +
    gsi::constant ("Selection", &qt_gsi::c_23_QAccessible_Event_Enum, "@brief Enum constant QAccessible::Selection") +
    gsi::constant ("SelectionAdd", &qt_gsi::c_24_QAccessible_Event_Enum, "@brief Enum constant QAccessible::SelectionAdd") +
    gsi::constant ("SelectionRemove", &qt_gsi::c_25_QAccessible_Event_Enum, "@brief Enum constant QAccessible::SelectionRemove") +
    gsi::constant ("SelectionWithin", &qt_gsi::c_26_QAccessible_Event_Enum, "@brief Enum constant QAccessible::SelectionWithin") +
    gsi::constant ("StateChanged", &qt_gsi::c_27_QAccessible_Event_Enum, "@brief Enum constant QAccessible::StateChanged") +
    gsi::constant ("LocationChanged", &qt_gsi::c_28_QAccessible_Event_Enum, "@brief Enum constant QAccessible::LocationChanged") +
    gsi::constant ("NameChanged", &qt_gsi::c_29_QAccessible_Event_Enum, "@brief Enum constant QAccessible::NameChanged") +
    gsi::constant ("DescriptionChanged", &qt_gsi::c_30_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DescriptionChanged") +
    gsi::constant ("ValueChanged", &qt_gsi::c_31_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ValueChanged") +
    gsi::constant ("ParentChanged", &qt_gsi::c_32_QAccessible_Event_Enum, "@brief Enum constant QAccessible::ParentChanged") +
    gsi::constant ("HelpChanged", &qt_gsi::c_33_QAccessible_Event_Enum, "@brief Enum constant QAccessible::HelpChanged") +
    gsi::constant ("DefaultActionChanged", &qt_gsi::c_34_QAccessible_Event_Enum, "@brief Enum constant QAccessible::DefaultActionChanged") +
    gsi::constant ("AcceleratorChanged", &qt_gsi::c_35_QAccessible_Event_Enum, "@brief Enum constant QAccessible::AcceleratorChanged");
}

static std::string to_s_QAccessible_Event_Enum (const QAccessible_Event_Enum *e)
{
  if (e->value () == QAccessible::SoundPlayed) { return tl::sprintf ("SoundPlayed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Alert) { return tl::sprintf ("Alert (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ForegroundChanged) { return tl::sprintf ("ForegroundChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MenuStart) { return tl::sprintf ("MenuStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MenuEnd) { return tl::sprintf ("MenuEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PopupMenuStart) { return tl::sprintf ("PopupMenuStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PopupMenuEnd) { return tl::sprintf ("PopupMenuEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ContextHelpStart) { return tl::sprintf ("ContextHelpStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ContextHelpEnd) { return tl::sprintf ("ContextHelpEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DragDropStart) { return tl::sprintf ("DragDropStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DragDropEnd) { return tl::sprintf ("DragDropEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DialogStart) { return tl::sprintf ("DialogStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DialogEnd) { return tl::sprintf ("DialogEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ScrollingStart) { return tl::sprintf ("ScrollingStart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ScrollingEnd) { return tl::sprintf ("ScrollingEnd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MenuCommand) { return tl::sprintf ("MenuCommand (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ObjectCreated) { return tl::sprintf ("ObjectCreated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ObjectDestroyed) { return tl::sprintf ("ObjectDestroyed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ObjectShow) { return tl::sprintf ("ObjectShow (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ObjectHide) { return tl::sprintf ("ObjectHide (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ObjectReorder) { return tl::sprintf ("ObjectReorder (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Focus) { return tl::sprintf ("Focus (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Selection) { return tl::sprintf ("Selection (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SelectionAdd) { return tl::sprintf ("SelectionAdd (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SelectionRemove) { return tl::sprintf ("SelectionRemove (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SelectionWithin) { return tl::sprintf ("SelectionWithin (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::StateChanged) { return tl::sprintf ("StateChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::LocationChanged) { return tl::sprintf ("LocationChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::NameChanged) { return tl::sprintf ("NameChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DescriptionChanged) { return tl::sprintf ("DescriptionChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ValueChanged) { return tl::sprintf ("ValueChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ParentChanged) { return tl::sprintf ("ParentChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HelpChanged) { return tl::sprintf ("HelpChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DefaultActionChanged) { return tl::sprintf ("DefaultActionChanged (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::AcceleratorChanged) { return tl::sprintf ("AcceleratorChanged (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_Event_Enum (const QAccessible_Event_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_Event_Enum *from_i_QAccessible_Event_Enum (unsigned int i)
{
  return new QAccessible_Event_Enum ((QAccessible::Event) i);
}

static bool equalQAccessible_Event_Enum (const QAccessible_Event_Enum *e, QAccessible_Event_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_Event_Enum (const QAccessible_Event_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_Event_Enums oropQAccessible_Event_Enums (const QAccessible_Event_Enums *e, const QAccessible_Event_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_Event_Enums andopQAccessible_Event_Enums (const QAccessible_Event_Enums *e, const QAccessible_Event_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_Event_Enums xoropQAccessible_Event_Enums (const QAccessible_Event_Enums *e, const QAccessible_Event_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_Event_Enums (const QAccessible_Event_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::SoundPlayed)) { if (!l.empty ()) l += "|"; l += "SoundPlayed"; }
  if (e->testFlag (QAccessible::Alert)) { if (!l.empty ()) l += "|"; l += "Alert"; }
  if (e->testFlag (QAccessible::ForegroundChanged)) { if (!l.empty ()) l += "|"; l += "ForegroundChanged"; }
  if (e->testFlag (QAccessible::MenuStart)) { if (!l.empty ()) l += "|"; l += "MenuStart"; }
  if (e->testFlag (QAccessible::MenuEnd)) { if (!l.empty ()) l += "|"; l += "MenuEnd"; }
  if (e->testFlag (QAccessible::PopupMenuStart)) { if (!l.empty ()) l += "|"; l += "PopupMenuStart"; }
  if (e->testFlag (QAccessible::PopupMenuEnd)) { if (!l.empty ()) l += "|"; l += "PopupMenuEnd"; }
  if (e->testFlag (QAccessible::ContextHelpStart)) { if (!l.empty ()) l += "|"; l += "ContextHelpStart"; }
  if (e->testFlag (QAccessible::ContextHelpEnd)) { if (!l.empty ()) l += "|"; l += "ContextHelpEnd"; }
  if (e->testFlag (QAccessible::DragDropStart)) { if (!l.empty ()) l += "|"; l += "DragDropStart"; }
  if (e->testFlag (QAccessible::DragDropEnd)) { if (!l.empty ()) l += "|"; l += "DragDropEnd"; }
  if (e->testFlag (QAccessible::DialogStart)) { if (!l.empty ()) l += "|"; l += "DialogStart"; }
  if (e->testFlag (QAccessible::DialogEnd)) { if (!l.empty ()) l += "|"; l += "DialogEnd"; }
  if (e->testFlag (QAccessible::ScrollingStart)) { if (!l.empty ()) l += "|"; l += "ScrollingStart"; }
  if (e->testFlag (QAccessible::ScrollingEnd)) { if (!l.empty ()) l += "|"; l += "ScrollingEnd"; }
  if (e->testFlag (QAccessible::MenuCommand)) { if (!l.empty ()) l += "|"; l += "MenuCommand"; }
  if (e->testFlag (QAccessible::ObjectCreated)) { if (!l.empty ()) l += "|"; l += "ObjectCreated"; }
  if (e->testFlag (QAccessible::ObjectDestroyed)) { if (!l.empty ()) l += "|"; l += "ObjectDestroyed"; }
  if (e->testFlag (QAccessible::ObjectShow)) { if (!l.empty ()) l += "|"; l += "ObjectShow"; }
  if (e->testFlag (QAccessible::ObjectHide)) { if (!l.empty ()) l += "|"; l += "ObjectHide"; }
  if (e->testFlag (QAccessible::ObjectReorder)) { if (!l.empty ()) l += "|"; l += "ObjectReorder"; }
  if (e->testFlag (QAccessible::Focus)) { if (!l.empty ()) l += "|"; l += "Focus"; }
  if (e->testFlag (QAccessible::Selection)) { if (!l.empty ()) l += "|"; l += "Selection"; }
  if (e->testFlag (QAccessible::SelectionAdd)) { if (!l.empty ()) l += "|"; l += "SelectionAdd"; }
  if (e->testFlag (QAccessible::SelectionRemove)) { if (!l.empty ()) l += "|"; l += "SelectionRemove"; }
  if (e->testFlag (QAccessible::SelectionWithin)) { if (!l.empty ()) l += "|"; l += "SelectionWithin"; }
  if (e->testFlag (QAccessible::StateChanged)) { if (!l.empty ()) l += "|"; l += "StateChanged"; }
  if (e->testFlag (QAccessible::LocationChanged)) { if (!l.empty ()) l += "|"; l += "LocationChanged"; }
  if (e->testFlag (QAccessible::NameChanged)) { if (!l.empty ()) l += "|"; l += "NameChanged"; }
  if (e->testFlag (QAccessible::DescriptionChanged)) { if (!l.empty ()) l += "|"; l += "DescriptionChanged"; }
  if (e->testFlag (QAccessible::ValueChanged)) { if (!l.empty ()) l += "|"; l += "ValueChanged"; }
  if (e->testFlag (QAccessible::ParentChanged)) { if (!l.empty ()) l += "|"; l += "ParentChanged"; }
  if (e->testFlag (QAccessible::HelpChanged)) { if (!l.empty ()) l += "|"; l += "HelpChanged"; }
  if (e->testFlag (QAccessible::DefaultActionChanged)) { if (!l.empty ()) l += "|"; l += "DefaultActionChanged"; }
  if (e->testFlag (QAccessible::AcceleratorChanged)) { if (!l.empty ()) l += "|"; l += "AcceleratorChanged"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_Event_Enums (const QAccessible_Event_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_Event_Enums (const QAccessible_Event_Enums *e, const QAccessible_Event_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_Event_Enums> decl_QAccessible_Event_Enums ("QAccessible_QFlags_Event",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_Event_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_Event_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_Event_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Event_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Event_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_Event_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::Event> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_Event_Enum> decl_QAccessible_Event_Enum (decl_QAccessible_Event_Enums, "QAccessible_Event",
  qt_gsi::mkdefs_QAccessible_Event () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Event_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Event_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_Event_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_Event_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_Event_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::Event enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Event_Enum_in_parent (qt_gsi::mkdefs_QAccessible_Event ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Event_Enum_as_child (decl_QAccessible_Event_Enum, "Event");

}


//  Implementation of the enum wrapper class for QAccessible::Method
namespace qt_gsi
{

static QAccessible_Method_Enum *c_1_QAccessible_Method_Enum () { return new QAccessible_Method_Enum (QAccessible::ListSupportedMethods); }
static QAccessible_Method_Enum *c_2_QAccessible_Method_Enum () { return new QAccessible_Method_Enum (QAccessible::SetCursorPosition); }
static QAccessible_Method_Enum *c_3_QAccessible_Method_Enum () { return new QAccessible_Method_Enum (QAccessible::GetCursorPosition); }
static QAccessible_Method_Enum *c_4_QAccessible_Method_Enum () { return new QAccessible_Method_Enum (QAccessible::ForegroundColor); }
static QAccessible_Method_Enum *c_5_QAccessible_Method_Enum () { return new QAccessible_Method_Enum (QAccessible::BackgroundColor); }

static gsi::Methods mkdefs_QAccessible_Method () {
  return
    gsi::constant ("ListSupportedMethods", &qt_gsi::c_1_QAccessible_Method_Enum, "@brief Enum constant QAccessible::ListSupportedMethods") +
    gsi::constant ("SetCursorPosition", &qt_gsi::c_2_QAccessible_Method_Enum, "@brief Enum constant QAccessible::SetCursorPosition") +
    gsi::constant ("GetCursorPosition", &qt_gsi::c_3_QAccessible_Method_Enum, "@brief Enum constant QAccessible::GetCursorPosition") +
    gsi::constant ("ForegroundColor", &qt_gsi::c_4_QAccessible_Method_Enum, "@brief Enum constant QAccessible::ForegroundColor") +
    gsi::constant ("BackgroundColor", &qt_gsi::c_5_QAccessible_Method_Enum, "@brief Enum constant QAccessible::BackgroundColor");
}

static std::string to_s_QAccessible_Method_Enum (const QAccessible_Method_Enum *e)
{
  if (e->value () == QAccessible::ListSupportedMethods) { return tl::sprintf ("ListSupportedMethods (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SetCursorPosition) { return tl::sprintf ("SetCursorPosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::GetCursorPosition) { return tl::sprintf ("GetCursorPosition (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ForegroundColor) { return tl::sprintf ("ForegroundColor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::BackgroundColor) { return tl::sprintf ("BackgroundColor (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_Method_Enum (const QAccessible_Method_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_Method_Enum *from_i_QAccessible_Method_Enum (unsigned int i)
{
  return new QAccessible_Method_Enum ((QAccessible::Method) i);
}

static bool equalQAccessible_Method_Enum (const QAccessible_Method_Enum *e, QAccessible_Method_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_Method_Enum (const QAccessible_Method_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_Method_Enums oropQAccessible_Method_Enums (const QAccessible_Method_Enums *e, const QAccessible_Method_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_Method_Enums andopQAccessible_Method_Enums (const QAccessible_Method_Enums *e, const QAccessible_Method_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_Method_Enums xoropQAccessible_Method_Enums (const QAccessible_Method_Enums *e, const QAccessible_Method_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_Method_Enums (const QAccessible_Method_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::ListSupportedMethods)) { if (!l.empty ()) l += "|"; l += "ListSupportedMethods"; }
  if (e->testFlag (QAccessible::SetCursorPosition)) { if (!l.empty ()) l += "|"; l += "SetCursorPosition"; }
  if (e->testFlag (QAccessible::GetCursorPosition)) { if (!l.empty ()) l += "|"; l += "GetCursorPosition"; }
  if (e->testFlag (QAccessible::ForegroundColor)) { if (!l.empty ()) l += "|"; l += "ForegroundColor"; }
  if (e->testFlag (QAccessible::BackgroundColor)) { if (!l.empty ()) l += "|"; l += "BackgroundColor"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_Method_Enums (const QAccessible_Method_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_Method_Enums (const QAccessible_Method_Enums *e, const QAccessible_Method_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_Method_Enums> decl_QAccessible_Method_Enums ("QAccessible_QFlags_Method",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_Method_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_Method_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_Method_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Method_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Method_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_Method_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::Method> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_Method_Enum> decl_QAccessible_Method_Enum (decl_QAccessible_Method_Enums, "QAccessible_Method",
  qt_gsi::mkdefs_QAccessible_Method () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Method_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Method_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_Method_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_Method_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_Method_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::Method enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Method_Enum_in_parent (qt_gsi::mkdefs_QAccessible_Method ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Method_Enum_as_child (decl_QAccessible_Method_Enum, "Method");

}


//  Implementation of the enum wrapper class for QAccessible::RelationFlag
namespace qt_gsi
{

static QAccessible_RelationFlag_Enum *c_1_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Unrelated); }
static QAccessible_RelationFlag_Enum *c_2_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Self); }
static QAccessible_RelationFlag_Enum *c_3_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Ancestor); }
static QAccessible_RelationFlag_Enum *c_4_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Child); }
static QAccessible_RelationFlag_Enum *c_5_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Descendent); }
static QAccessible_RelationFlag_Enum *c_6_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Sibling); }
static QAccessible_RelationFlag_Enum *c_7_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::HierarchyMask); }
static QAccessible_RelationFlag_Enum *c_8_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Up); }
static QAccessible_RelationFlag_Enum *c_9_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Down); }
static QAccessible_RelationFlag_Enum *c_10_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Left); }
static QAccessible_RelationFlag_Enum *c_11_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Right); }
static QAccessible_RelationFlag_Enum *c_12_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Covers); }
static QAccessible_RelationFlag_Enum *c_13_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Covered); }
static QAccessible_RelationFlag_Enum *c_14_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::GeometryMask); }
static QAccessible_RelationFlag_Enum *c_15_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::FocusChild); }
static QAccessible_RelationFlag_Enum *c_16_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Label); }
static QAccessible_RelationFlag_Enum *c_17_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Labelled); }
static QAccessible_RelationFlag_Enum *c_18_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Controller); }
static QAccessible_RelationFlag_Enum *c_19_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::Controlled); }
static QAccessible_RelationFlag_Enum *c_20_QAccessible_RelationFlag_Enum () { return new QAccessible_RelationFlag_Enum (QAccessible::LogicalMask); }

static gsi::Methods mkdefs_QAccessible_RelationFlag () {
  return
    gsi::constant ("Unrelated", &qt_gsi::c_1_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Unrelated") +
    gsi::constant ("Self", &qt_gsi::c_2_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Self") +
    gsi::constant ("Ancestor", &qt_gsi::c_3_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Ancestor") +
    gsi::constant ("Child", &qt_gsi::c_4_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Child") +
    gsi::constant ("Descendent", &qt_gsi::c_5_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Descendent") +
    gsi::constant ("Sibling", &qt_gsi::c_6_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Sibling") +
    gsi::constant ("HierarchyMask", &qt_gsi::c_7_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::HierarchyMask") +
    gsi::constant ("Up", &qt_gsi::c_8_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Up") +
    gsi::constant ("Down", &qt_gsi::c_9_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Down") +
    gsi::constant ("Left", &qt_gsi::c_10_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Left") +
    gsi::constant ("Right", &qt_gsi::c_11_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Right") +
    gsi::constant ("Covers", &qt_gsi::c_12_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Covers") +
    gsi::constant ("Covered", &qt_gsi::c_13_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Covered") +
    gsi::constant ("GeometryMask", &qt_gsi::c_14_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::GeometryMask") +
    gsi::constant ("FocusChild", &qt_gsi::c_15_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::FocusChild") +
    gsi::constant ("Label", &qt_gsi::c_16_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Label") +
    gsi::constant ("Labelled", &qt_gsi::c_17_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Labelled") +
    gsi::constant ("Controller", &qt_gsi::c_18_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Controller") +
    gsi::constant ("Controlled", &qt_gsi::c_19_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::Controlled") +
    gsi::constant ("LogicalMask", &qt_gsi::c_20_QAccessible_RelationFlag_Enum, "@brief Enum constant QAccessible::LogicalMask");
}

static std::string to_s_QAccessible_RelationFlag_Enum (const QAccessible_RelationFlag_Enum *e)
{
  if (e->value () == QAccessible::Unrelated) { return tl::sprintf ("Unrelated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Self) { return tl::sprintf ("Self (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Ancestor) { return tl::sprintf ("Ancestor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Child) { return tl::sprintf ("Child (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Descendent) { return tl::sprintf ("Descendent (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Sibling) { return tl::sprintf ("Sibling (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HierarchyMask) { return tl::sprintf ("HierarchyMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Up) { return tl::sprintf ("Up (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Down) { return tl::sprintf ("Down (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Left) { return tl::sprintf ("Left (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Right) { return tl::sprintf ("Right (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Covers) { return tl::sprintf ("Covers (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Covered) { return tl::sprintf ("Covered (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::GeometryMask) { return tl::sprintf ("GeometryMask (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::FocusChild) { return tl::sprintf ("FocusChild (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Label) { return tl::sprintf ("Label (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Labelled) { return tl::sprintf ("Labelled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Controller) { return tl::sprintf ("Controller (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Controlled) { return tl::sprintf ("Controlled (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::LogicalMask) { return tl::sprintf ("LogicalMask (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_RelationFlag_Enum (const QAccessible_RelationFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_RelationFlag_Enum *from_i_QAccessible_RelationFlag_Enum (unsigned int i)
{
  return new QAccessible_RelationFlag_Enum ((QAccessible::RelationFlag) i);
}

static bool equalQAccessible_RelationFlag_Enum (const QAccessible_RelationFlag_Enum *e, QAccessible_RelationFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_RelationFlag_Enum (const QAccessible_RelationFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_RelationFlag_Enums oropQAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e, const QAccessible_RelationFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_RelationFlag_Enums andopQAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e, const QAccessible_RelationFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_RelationFlag_Enums xoropQAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e, const QAccessible_RelationFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::Unrelated)) { if (!l.empty ()) l += "|"; l += "Unrelated"; }
  if (e->testFlag (QAccessible::Self)) { if (!l.empty ()) l += "|"; l += "Self"; }
  if (e->testFlag (QAccessible::Ancestor)) { if (!l.empty ()) l += "|"; l += "Ancestor"; }
  if (e->testFlag (QAccessible::Child)) { if (!l.empty ()) l += "|"; l += "Child"; }
  if (e->testFlag (QAccessible::Descendent)) { if (!l.empty ()) l += "|"; l += "Descendent"; }
  if (e->testFlag (QAccessible::Sibling)) { if (!l.empty ()) l += "|"; l += "Sibling"; }
  if (e->testFlag (QAccessible::HierarchyMask)) { if (!l.empty ()) l += "|"; l += "HierarchyMask"; }
  if (e->testFlag (QAccessible::Up)) { if (!l.empty ()) l += "|"; l += "Up"; }
  if (e->testFlag (QAccessible::Down)) { if (!l.empty ()) l += "|"; l += "Down"; }
  if (e->testFlag (QAccessible::Left)) { if (!l.empty ()) l += "|"; l += "Left"; }
  if (e->testFlag (QAccessible::Right)) { if (!l.empty ()) l += "|"; l += "Right"; }
  if (e->testFlag (QAccessible::Covers)) { if (!l.empty ()) l += "|"; l += "Covers"; }
  if (e->testFlag (QAccessible::Covered)) { if (!l.empty ()) l += "|"; l += "Covered"; }
  if (e->testFlag (QAccessible::GeometryMask)) { if (!l.empty ()) l += "|"; l += "GeometryMask"; }
  if (e->testFlag (QAccessible::FocusChild)) { if (!l.empty ()) l += "|"; l += "FocusChild"; }
  if (e->testFlag (QAccessible::Label)) { if (!l.empty ()) l += "|"; l += "Label"; }
  if (e->testFlag (QAccessible::Labelled)) { if (!l.empty ()) l += "|"; l += "Labelled"; }
  if (e->testFlag (QAccessible::Controller)) { if (!l.empty ()) l += "|"; l += "Controller"; }
  if (e->testFlag (QAccessible::Controlled)) { if (!l.empty ()) l += "|"; l += "Controlled"; }
  if (e->testFlag (QAccessible::LogicalMask)) { if (!l.empty ()) l += "|"; l += "LogicalMask"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_RelationFlag_Enums (const QAccessible_RelationFlag_Enums *e, const QAccessible_RelationFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_RelationFlag_Enums> decl_QAccessible_RelationFlag_Enums ("QAccessible_QFlags_RelationFlag",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_RelationFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_RelationFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_RelationFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_RelationFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_RelationFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_RelationFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::RelationFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_RelationFlag_Enum> decl_QAccessible_RelationFlag_Enum (decl_QAccessible_RelationFlag_Enums, "QAccessible_RelationFlag",
  qt_gsi::mkdefs_QAccessible_RelationFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_RelationFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_RelationFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_RelationFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_RelationFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_RelationFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::RelationFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_RelationFlag_Enum_in_parent (qt_gsi::mkdefs_QAccessible_RelationFlag ());
static gsi::ClassExt<QAccessible> decl_QAccessible_RelationFlag_Enum_as_child (decl_QAccessible_RelationFlag_Enum, "RelationFlag");

}


//  Implementation of the enum wrapper class for QAccessible::Role
namespace qt_gsi
{

static QAccessible_Role_Enum *c_1_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::NoRole); }
static QAccessible_Role_Enum *c_2_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::TitleBar); }
static QAccessible_Role_Enum *c_3_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::MenuBar); }
static QAccessible_Role_Enum *c_4_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ScrollBar); }
static QAccessible_Role_Enum *c_5_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Grip); }
static QAccessible_Role_Enum *c_6_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Sound); }
static QAccessible_Role_Enum *c_7_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Cursor); }
static QAccessible_Role_Enum *c_8_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Caret); }
static QAccessible_Role_Enum *c_9_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::AlertMessage); }
static QAccessible_Role_Enum *c_10_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Window); }
static QAccessible_Role_Enum *c_11_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Client); }
static QAccessible_Role_Enum *c_12_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::PopupMenu); }
static QAccessible_Role_Enum *c_13_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::MenuItem); }
static QAccessible_Role_Enum *c_14_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ToolTip); }
static QAccessible_Role_Enum *c_15_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Application); }
static QAccessible_Role_Enum *c_16_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Document); }
static QAccessible_Role_Enum *c_17_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Pane); }
static QAccessible_Role_Enum *c_18_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Chart); }
static QAccessible_Role_Enum *c_19_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Dialog); }
static QAccessible_Role_Enum *c_20_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Border); }
static QAccessible_Role_Enum *c_21_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Grouping); }
static QAccessible_Role_Enum *c_22_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Separator); }
static QAccessible_Role_Enum *c_23_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ToolBar); }
static QAccessible_Role_Enum *c_24_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::StatusBar); }
static QAccessible_Role_Enum *c_25_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Table); }
static QAccessible_Role_Enum *c_26_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ColumnHeader); }
static QAccessible_Role_Enum *c_27_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::RowHeader); }
static QAccessible_Role_Enum *c_28_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Column); }
static QAccessible_Role_Enum *c_29_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Row); }
static QAccessible_Role_Enum *c_30_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Cell); }
static QAccessible_Role_Enum *c_31_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Link); }
static QAccessible_Role_Enum *c_32_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::HelpBalloon); }
static QAccessible_Role_Enum *c_33_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Assistant); }
static QAccessible_Role_Enum *c_34_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::List); }
static QAccessible_Role_Enum *c_35_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ListItem); }
static QAccessible_Role_Enum *c_36_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Tree); }
static QAccessible_Role_Enum *c_37_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::TreeItem); }
static QAccessible_Role_Enum *c_38_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::PageTab); }
static QAccessible_Role_Enum *c_39_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::PropertyPage); }
static QAccessible_Role_Enum *c_40_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Indicator); }
static QAccessible_Role_Enum *c_41_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Graphic); }
static QAccessible_Role_Enum *c_42_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::StaticText); }
static QAccessible_Role_Enum *c_43_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::EditableText); }
static QAccessible_Role_Enum *c_44_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::PushButton); }
static QAccessible_Role_Enum *c_45_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::CheckBox); }
static QAccessible_Role_Enum *c_46_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::RadioButton); }
static QAccessible_Role_Enum *c_47_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ComboBox); }
static QAccessible_Role_Enum *c_48_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ProgressBar); }
static QAccessible_Role_Enum *c_49_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Dial); }
static QAccessible_Role_Enum *c_50_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::HotkeyField); }
static QAccessible_Role_Enum *c_51_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Slider); }
static QAccessible_Role_Enum *c_52_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::SpinBox); }
static QAccessible_Role_Enum *c_53_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Canvas); }
static QAccessible_Role_Enum *c_54_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Animation); }
static QAccessible_Role_Enum *c_55_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Equation); }
static QAccessible_Role_Enum *c_56_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ButtonDropDown); }
static QAccessible_Role_Enum *c_57_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ButtonMenu); }
static QAccessible_Role_Enum *c_58_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::ButtonDropGrid); }
static QAccessible_Role_Enum *c_59_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Whitespace); }
static QAccessible_Role_Enum *c_60_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::PageTabList); }
static QAccessible_Role_Enum *c_61_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Clock); }
static QAccessible_Role_Enum *c_62_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::Splitter); }
static QAccessible_Role_Enum *c_63_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::LayeredPane); }
static QAccessible_Role_Enum *c_64_QAccessible_Role_Enum () { return new QAccessible_Role_Enum (QAccessible::UserRole); }

static gsi::Methods mkdefs_QAccessible_Role () {
  return
    gsi::constant ("NoRole", &qt_gsi::c_1_QAccessible_Role_Enum, "@brief Enum constant QAccessible::NoRole") +
    gsi::constant ("TitleBar", &qt_gsi::c_2_QAccessible_Role_Enum, "@brief Enum constant QAccessible::TitleBar") +
    gsi::constant ("MenuBar", &qt_gsi::c_3_QAccessible_Role_Enum, "@brief Enum constant QAccessible::MenuBar") +
    gsi::constant ("ScrollBar", &qt_gsi::c_4_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ScrollBar") +
    gsi::constant ("Grip", &qt_gsi::c_5_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Grip") +
    gsi::constant ("Sound", &qt_gsi::c_6_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Sound") +
    gsi::constant ("Cursor", &qt_gsi::c_7_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Cursor") +
    gsi::constant ("Caret", &qt_gsi::c_8_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Caret") +
    gsi::constant ("AlertMessage", &qt_gsi::c_9_QAccessible_Role_Enum, "@brief Enum constant QAccessible::AlertMessage") +
    gsi::constant ("Window", &qt_gsi::c_10_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Window") +
    gsi::constant ("Client", &qt_gsi::c_11_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Client") +
    gsi::constant ("PopupMenu", &qt_gsi::c_12_QAccessible_Role_Enum, "@brief Enum constant QAccessible::PopupMenu") +
    gsi::constant ("MenuItem", &qt_gsi::c_13_QAccessible_Role_Enum, "@brief Enum constant QAccessible::MenuItem") +
    gsi::constant ("ToolTip", &qt_gsi::c_14_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ToolTip") +
    gsi::constant ("Application", &qt_gsi::c_15_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Application") +
    gsi::constant ("Document", &qt_gsi::c_16_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Document") +
    gsi::constant ("Pane", &qt_gsi::c_17_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Pane") +
    gsi::constant ("Chart", &qt_gsi::c_18_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Chart") +
    gsi::constant ("Dialog", &qt_gsi::c_19_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Dialog") +
    gsi::constant ("Border", &qt_gsi::c_20_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Border") +
    gsi::constant ("Grouping", &qt_gsi::c_21_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Grouping") +
    gsi::constant ("Separator", &qt_gsi::c_22_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Separator") +
    gsi::constant ("ToolBar", &qt_gsi::c_23_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ToolBar") +
    gsi::constant ("StatusBar", &qt_gsi::c_24_QAccessible_Role_Enum, "@brief Enum constant QAccessible::StatusBar") +
    gsi::constant ("Table", &qt_gsi::c_25_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Table") +
    gsi::constant ("ColumnHeader", &qt_gsi::c_26_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ColumnHeader") +
    gsi::constant ("RowHeader", &qt_gsi::c_27_QAccessible_Role_Enum, "@brief Enum constant QAccessible::RowHeader") +
    gsi::constant ("Column", &qt_gsi::c_28_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Column") +
    gsi::constant ("Row", &qt_gsi::c_29_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Row") +
    gsi::constant ("Cell", &qt_gsi::c_30_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Cell") +
    gsi::constant ("Link", &qt_gsi::c_31_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Link") +
    gsi::constant ("HelpBalloon", &qt_gsi::c_32_QAccessible_Role_Enum, "@brief Enum constant QAccessible::HelpBalloon") +
    gsi::constant ("Assistant", &qt_gsi::c_33_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Assistant") +
    gsi::constant ("List", &qt_gsi::c_34_QAccessible_Role_Enum, "@brief Enum constant QAccessible::List") +
    gsi::constant ("ListItem", &qt_gsi::c_35_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ListItem") +
    gsi::constant ("Tree", &qt_gsi::c_36_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Tree") +
    gsi::constant ("TreeItem", &qt_gsi::c_37_QAccessible_Role_Enum, "@brief Enum constant QAccessible::TreeItem") +
    gsi::constant ("PageTab", &qt_gsi::c_38_QAccessible_Role_Enum, "@brief Enum constant QAccessible::PageTab") +
    gsi::constant ("PropertyPage", &qt_gsi::c_39_QAccessible_Role_Enum, "@brief Enum constant QAccessible::PropertyPage") +
    gsi::constant ("Indicator", &qt_gsi::c_40_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Indicator") +
    gsi::constant ("Graphic", &qt_gsi::c_41_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Graphic") +
    gsi::constant ("StaticText", &qt_gsi::c_42_QAccessible_Role_Enum, "@brief Enum constant QAccessible::StaticText") +
    gsi::constant ("EditableText", &qt_gsi::c_43_QAccessible_Role_Enum, "@brief Enum constant QAccessible::EditableText") +
    gsi::constant ("PushButton", &qt_gsi::c_44_QAccessible_Role_Enum, "@brief Enum constant QAccessible::PushButton") +
    gsi::constant ("CheckBox", &qt_gsi::c_45_QAccessible_Role_Enum, "@brief Enum constant QAccessible::CheckBox") +
    gsi::constant ("RadioButton", &qt_gsi::c_46_QAccessible_Role_Enum, "@brief Enum constant QAccessible::RadioButton") +
    gsi::constant ("ComboBox", &qt_gsi::c_47_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ComboBox") +
    gsi::constant ("ProgressBar", &qt_gsi::c_48_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ProgressBar") +
    gsi::constant ("Dial", &qt_gsi::c_49_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Dial") +
    gsi::constant ("HotkeyField", &qt_gsi::c_50_QAccessible_Role_Enum, "@brief Enum constant QAccessible::HotkeyField") +
    gsi::constant ("Slider", &qt_gsi::c_51_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Slider") +
    gsi::constant ("SpinBox", &qt_gsi::c_52_QAccessible_Role_Enum, "@brief Enum constant QAccessible::SpinBox") +
    gsi::constant ("Canvas", &qt_gsi::c_53_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Canvas") +
    gsi::constant ("Animation", &qt_gsi::c_54_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Animation") +
    gsi::constant ("Equation", &qt_gsi::c_55_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Equation") +
    gsi::constant ("ButtonDropDown", &qt_gsi::c_56_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ButtonDropDown") +
    gsi::constant ("ButtonMenu", &qt_gsi::c_57_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ButtonMenu") +
    gsi::constant ("ButtonDropGrid", &qt_gsi::c_58_QAccessible_Role_Enum, "@brief Enum constant QAccessible::ButtonDropGrid") +
    gsi::constant ("Whitespace", &qt_gsi::c_59_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Whitespace") +
    gsi::constant ("PageTabList", &qt_gsi::c_60_QAccessible_Role_Enum, "@brief Enum constant QAccessible::PageTabList") +
    gsi::constant ("Clock", &qt_gsi::c_61_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Clock") +
    gsi::constant ("Splitter", &qt_gsi::c_62_QAccessible_Role_Enum, "@brief Enum constant QAccessible::Splitter") +
    gsi::constant ("LayeredPane", &qt_gsi::c_63_QAccessible_Role_Enum, "@brief Enum constant QAccessible::LayeredPane") +
    gsi::constant ("UserRole", &qt_gsi::c_64_QAccessible_Role_Enum, "@brief Enum constant QAccessible::UserRole");
}

static std::string to_s_QAccessible_Role_Enum (const QAccessible_Role_Enum *e)
{
  if (e->value () == QAccessible::NoRole) { return tl::sprintf ("NoRole (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::TitleBar) { return tl::sprintf ("TitleBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MenuBar) { return tl::sprintf ("MenuBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ScrollBar) { return tl::sprintf ("ScrollBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Grip) { return tl::sprintf ("Grip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Sound) { return tl::sprintf ("Sound (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Cursor) { return tl::sprintf ("Cursor (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Caret) { return tl::sprintf ("Caret (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::AlertMessage) { return tl::sprintf ("AlertMessage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Window) { return tl::sprintf ("Window (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Client) { return tl::sprintf ("Client (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PopupMenu) { return tl::sprintf ("PopupMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MenuItem) { return tl::sprintf ("MenuItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ToolTip) { return tl::sprintf ("ToolTip (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Application) { return tl::sprintf ("Application (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Document) { return tl::sprintf ("Document (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Pane) { return tl::sprintf ("Pane (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Chart) { return tl::sprintf ("Chart (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Dialog) { return tl::sprintf ("Dialog (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Border) { return tl::sprintf ("Border (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Grouping) { return tl::sprintf ("Grouping (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Separator) { return tl::sprintf ("Separator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ToolBar) { return tl::sprintf ("ToolBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::StatusBar) { return tl::sprintf ("StatusBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Table) { return tl::sprintf ("Table (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ColumnHeader) { return tl::sprintf ("ColumnHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::RowHeader) { return tl::sprintf ("RowHeader (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Column) { return tl::sprintf ("Column (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Row) { return tl::sprintf ("Row (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Cell) { return tl::sprintf ("Cell (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Link) { return tl::sprintf ("Link (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HelpBalloon) { return tl::sprintf ("HelpBalloon (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Assistant) { return tl::sprintf ("Assistant (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::List) { return tl::sprintf ("List (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ListItem) { return tl::sprintf ("ListItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Tree) { return tl::sprintf ("Tree (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::TreeItem) { return tl::sprintf ("TreeItem (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PageTab) { return tl::sprintf ("PageTab (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PropertyPage) { return tl::sprintf ("PropertyPage (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Indicator) { return tl::sprintf ("Indicator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Graphic) { return tl::sprintf ("Graphic (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::StaticText) { return tl::sprintf ("StaticText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::EditableText) { return tl::sprintf ("EditableText (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PushButton) { return tl::sprintf ("PushButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::CheckBox) { return tl::sprintf ("CheckBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::RadioButton) { return tl::sprintf ("RadioButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ComboBox) { return tl::sprintf ("ComboBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ProgressBar) { return tl::sprintf ("ProgressBar (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Dial) { return tl::sprintf ("Dial (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HotkeyField) { return tl::sprintf ("HotkeyField (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Slider) { return tl::sprintf ("Slider (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SpinBox) { return tl::sprintf ("SpinBox (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Canvas) { return tl::sprintf ("Canvas (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Animation) { return tl::sprintf ("Animation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Equation) { return tl::sprintf ("Equation (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ButtonDropDown) { return tl::sprintf ("ButtonDropDown (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ButtonMenu) { return tl::sprintf ("ButtonMenu (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ButtonDropGrid) { return tl::sprintf ("ButtonDropGrid (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Whitespace) { return tl::sprintf ("Whitespace (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::PageTabList) { return tl::sprintf ("PageTabList (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Clock) { return tl::sprintf ("Clock (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Splitter) { return tl::sprintf ("Splitter (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::LayeredPane) { return tl::sprintf ("LayeredPane (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::UserRole) { return tl::sprintf ("UserRole (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_Role_Enum (const QAccessible_Role_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_Role_Enum *from_i_QAccessible_Role_Enum (unsigned int i)
{
  return new QAccessible_Role_Enum ((QAccessible::Role) i);
}

static bool equalQAccessible_Role_Enum (const QAccessible_Role_Enum *e, QAccessible_Role_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_Role_Enum (const QAccessible_Role_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_Role_Enums oropQAccessible_Role_Enums (const QAccessible_Role_Enums *e, const QAccessible_Role_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_Role_Enums andopQAccessible_Role_Enums (const QAccessible_Role_Enums *e, const QAccessible_Role_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_Role_Enums xoropQAccessible_Role_Enums (const QAccessible_Role_Enums *e, const QAccessible_Role_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_Role_Enums (const QAccessible_Role_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::NoRole)) { if (!l.empty ()) l += "|"; l += "NoRole"; }
  if (e->testFlag (QAccessible::TitleBar)) { if (!l.empty ()) l += "|"; l += "TitleBar"; }
  if (e->testFlag (QAccessible::MenuBar)) { if (!l.empty ()) l += "|"; l += "MenuBar"; }
  if (e->testFlag (QAccessible::ScrollBar)) { if (!l.empty ()) l += "|"; l += "ScrollBar"; }
  if (e->testFlag (QAccessible::Grip)) { if (!l.empty ()) l += "|"; l += "Grip"; }
  if (e->testFlag (QAccessible::Sound)) { if (!l.empty ()) l += "|"; l += "Sound"; }
  if (e->testFlag (QAccessible::Cursor)) { if (!l.empty ()) l += "|"; l += "Cursor"; }
  if (e->testFlag (QAccessible::Caret)) { if (!l.empty ()) l += "|"; l += "Caret"; }
  if (e->testFlag (QAccessible::AlertMessage)) { if (!l.empty ()) l += "|"; l += "AlertMessage"; }
  if (e->testFlag (QAccessible::Window)) { if (!l.empty ()) l += "|"; l += "Window"; }
  if (e->testFlag (QAccessible::Client)) { if (!l.empty ()) l += "|"; l += "Client"; }
  if (e->testFlag (QAccessible::PopupMenu)) { if (!l.empty ()) l += "|"; l += "PopupMenu"; }
  if (e->testFlag (QAccessible::MenuItem)) { if (!l.empty ()) l += "|"; l += "MenuItem"; }
  if (e->testFlag (QAccessible::ToolTip)) { if (!l.empty ()) l += "|"; l += "ToolTip"; }
  if (e->testFlag (QAccessible::Application)) { if (!l.empty ()) l += "|"; l += "Application"; }
  if (e->testFlag (QAccessible::Document)) { if (!l.empty ()) l += "|"; l += "Document"; }
  if (e->testFlag (QAccessible::Pane)) { if (!l.empty ()) l += "|"; l += "Pane"; }
  if (e->testFlag (QAccessible::Chart)) { if (!l.empty ()) l += "|"; l += "Chart"; }
  if (e->testFlag (QAccessible::Dialog)) { if (!l.empty ()) l += "|"; l += "Dialog"; }
  if (e->testFlag (QAccessible::Border)) { if (!l.empty ()) l += "|"; l += "Border"; }
  if (e->testFlag (QAccessible::Grouping)) { if (!l.empty ()) l += "|"; l += "Grouping"; }
  if (e->testFlag (QAccessible::Separator)) { if (!l.empty ()) l += "|"; l += "Separator"; }
  if (e->testFlag (QAccessible::ToolBar)) { if (!l.empty ()) l += "|"; l += "ToolBar"; }
  if (e->testFlag (QAccessible::StatusBar)) { if (!l.empty ()) l += "|"; l += "StatusBar"; }
  if (e->testFlag (QAccessible::Table)) { if (!l.empty ()) l += "|"; l += "Table"; }
  if (e->testFlag (QAccessible::ColumnHeader)) { if (!l.empty ()) l += "|"; l += "ColumnHeader"; }
  if (e->testFlag (QAccessible::RowHeader)) { if (!l.empty ()) l += "|"; l += "RowHeader"; }
  if (e->testFlag (QAccessible::Column)) { if (!l.empty ()) l += "|"; l += "Column"; }
  if (e->testFlag (QAccessible::Row)) { if (!l.empty ()) l += "|"; l += "Row"; }
  if (e->testFlag (QAccessible::Cell)) { if (!l.empty ()) l += "|"; l += "Cell"; }
  if (e->testFlag (QAccessible::Link)) { if (!l.empty ()) l += "|"; l += "Link"; }
  if (e->testFlag (QAccessible::HelpBalloon)) { if (!l.empty ()) l += "|"; l += "HelpBalloon"; }
  if (e->testFlag (QAccessible::Assistant)) { if (!l.empty ()) l += "|"; l += "Assistant"; }
  if (e->testFlag (QAccessible::List)) { if (!l.empty ()) l += "|"; l += "List"; }
  if (e->testFlag (QAccessible::ListItem)) { if (!l.empty ()) l += "|"; l += "ListItem"; }
  if (e->testFlag (QAccessible::Tree)) { if (!l.empty ()) l += "|"; l += "Tree"; }
  if (e->testFlag (QAccessible::TreeItem)) { if (!l.empty ()) l += "|"; l += "TreeItem"; }
  if (e->testFlag (QAccessible::PageTab)) { if (!l.empty ()) l += "|"; l += "PageTab"; }
  if (e->testFlag (QAccessible::PropertyPage)) { if (!l.empty ()) l += "|"; l += "PropertyPage"; }
  if (e->testFlag (QAccessible::Indicator)) { if (!l.empty ()) l += "|"; l += "Indicator"; }
  if (e->testFlag (QAccessible::Graphic)) { if (!l.empty ()) l += "|"; l += "Graphic"; }
  if (e->testFlag (QAccessible::StaticText)) { if (!l.empty ()) l += "|"; l += "StaticText"; }
  if (e->testFlag (QAccessible::EditableText)) { if (!l.empty ()) l += "|"; l += "EditableText"; }
  if (e->testFlag (QAccessible::PushButton)) { if (!l.empty ()) l += "|"; l += "PushButton"; }
  if (e->testFlag (QAccessible::CheckBox)) { if (!l.empty ()) l += "|"; l += "CheckBox"; }
  if (e->testFlag (QAccessible::RadioButton)) { if (!l.empty ()) l += "|"; l += "RadioButton"; }
  if (e->testFlag (QAccessible::ComboBox)) { if (!l.empty ()) l += "|"; l += "ComboBox"; }
  if (e->testFlag (QAccessible::ProgressBar)) { if (!l.empty ()) l += "|"; l += "ProgressBar"; }
  if (e->testFlag (QAccessible::Dial)) { if (!l.empty ()) l += "|"; l += "Dial"; }
  if (e->testFlag (QAccessible::HotkeyField)) { if (!l.empty ()) l += "|"; l += "HotkeyField"; }
  if (e->testFlag (QAccessible::Slider)) { if (!l.empty ()) l += "|"; l += "Slider"; }
  if (e->testFlag (QAccessible::SpinBox)) { if (!l.empty ()) l += "|"; l += "SpinBox"; }
  if (e->testFlag (QAccessible::Canvas)) { if (!l.empty ()) l += "|"; l += "Canvas"; }
  if (e->testFlag (QAccessible::Animation)) { if (!l.empty ()) l += "|"; l += "Animation"; }
  if (e->testFlag (QAccessible::Equation)) { if (!l.empty ()) l += "|"; l += "Equation"; }
  if (e->testFlag (QAccessible::ButtonDropDown)) { if (!l.empty ()) l += "|"; l += "ButtonDropDown"; }
  if (e->testFlag (QAccessible::ButtonMenu)) { if (!l.empty ()) l += "|"; l += "ButtonMenu"; }
  if (e->testFlag (QAccessible::ButtonDropGrid)) { if (!l.empty ()) l += "|"; l += "ButtonDropGrid"; }
  if (e->testFlag (QAccessible::Whitespace)) { if (!l.empty ()) l += "|"; l += "Whitespace"; }
  if (e->testFlag (QAccessible::PageTabList)) { if (!l.empty ()) l += "|"; l += "PageTabList"; }
  if (e->testFlag (QAccessible::Clock)) { if (!l.empty ()) l += "|"; l += "Clock"; }
  if (e->testFlag (QAccessible::Splitter)) { if (!l.empty ()) l += "|"; l += "Splitter"; }
  if (e->testFlag (QAccessible::LayeredPane)) { if (!l.empty ()) l += "|"; l += "LayeredPane"; }
  if (e->testFlag (QAccessible::UserRole)) { if (!l.empty ()) l += "|"; l += "UserRole"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_Role_Enums (const QAccessible_Role_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_Role_Enums (const QAccessible_Role_Enums *e, const QAccessible_Role_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_Role_Enums> decl_QAccessible_Role_Enums ("QAccessible_QFlags_Role",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_Role_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_Role_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_Role_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Role_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Role_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_Role_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::Role> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_Role_Enum> decl_QAccessible_Role_Enum (decl_QAccessible_Role_Enums, "QAccessible_Role",
  qt_gsi::mkdefs_QAccessible_Role () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Role_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Role_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_Role_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_Role_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_Role_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::Role enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Role_Enum_in_parent (qt_gsi::mkdefs_QAccessible_Role ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Role_Enum_as_child (decl_QAccessible_Role_Enum, "Role");

}


//  Implementation of the enum wrapper class for QAccessible::StateFlag
namespace qt_gsi
{

static QAccessible_StateFlag_Enum *c_1_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Normal); }
static QAccessible_StateFlag_Enum *c_2_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Unavailable); }
static QAccessible_StateFlag_Enum *c_3_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Selected); }
static QAccessible_StateFlag_Enum *c_4_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Focused); }
static QAccessible_StateFlag_Enum *c_5_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Pressed); }
static QAccessible_StateFlag_Enum *c_6_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Checked); }
static QAccessible_StateFlag_Enum *c_7_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Mixed); }
static QAccessible_StateFlag_Enum *c_8_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::ReadOnly); }
static QAccessible_StateFlag_Enum *c_9_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::HotTracked); }
static QAccessible_StateFlag_Enum *c_10_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::DefaultButton); }
static QAccessible_StateFlag_Enum *c_11_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Expanded); }
static QAccessible_StateFlag_Enum *c_12_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Collapsed); }
static QAccessible_StateFlag_Enum *c_13_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Busy); }
static QAccessible_StateFlag_Enum *c_14_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Marqueed); }
static QAccessible_StateFlag_Enum *c_15_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Animated); }
static QAccessible_StateFlag_Enum *c_16_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Invisible); }
static QAccessible_StateFlag_Enum *c_17_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Offscreen); }
static QAccessible_StateFlag_Enum *c_18_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Sizeable); }
static QAccessible_StateFlag_Enum *c_19_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Movable); }
static QAccessible_StateFlag_Enum *c_20_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::SelfVoicing); }
static QAccessible_StateFlag_Enum *c_21_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Focusable); }
static QAccessible_StateFlag_Enum *c_22_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Selectable); }
static QAccessible_StateFlag_Enum *c_23_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Linked); }
static QAccessible_StateFlag_Enum *c_24_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Traversed); }
static QAccessible_StateFlag_Enum *c_25_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::MultiSelectable); }
static QAccessible_StateFlag_Enum *c_26_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::ExtSelectable); }
static QAccessible_StateFlag_Enum *c_27_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Protected); }
static QAccessible_StateFlag_Enum *c_28_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::HasPopup); }
static QAccessible_StateFlag_Enum *c_29_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::Modal); }
static QAccessible_StateFlag_Enum *c_30_QAccessible_StateFlag_Enum () { return new QAccessible_StateFlag_Enum (QAccessible::HasInvokeExtension); }

static gsi::Methods mkdefs_QAccessible_StateFlag () {
  return
    gsi::constant ("Normal", &qt_gsi::c_1_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Normal") +
    gsi::constant ("Unavailable", &qt_gsi::c_2_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Unavailable") +
    gsi::constant ("Selected", &qt_gsi::c_3_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Selected") +
    gsi::constant ("Focused", &qt_gsi::c_4_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Focused") +
    gsi::constant ("Pressed", &qt_gsi::c_5_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Pressed") +
    gsi::constant ("Checked", &qt_gsi::c_6_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Checked") +
    gsi::constant ("Mixed", &qt_gsi::c_7_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Mixed") +
    gsi::constant ("ReadOnly", &qt_gsi::c_8_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::ReadOnly") +
    gsi::constant ("HotTracked", &qt_gsi::c_9_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::HotTracked") +
    gsi::constant ("DefaultButton", &qt_gsi::c_10_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::DefaultButton") +
    gsi::constant ("Expanded", &qt_gsi::c_11_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Expanded") +
    gsi::constant ("Collapsed", &qt_gsi::c_12_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Collapsed") +
    gsi::constant ("Busy", &qt_gsi::c_13_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Busy") +
    gsi::constant ("Marqueed", &qt_gsi::c_14_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Marqueed") +
    gsi::constant ("Animated", &qt_gsi::c_15_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Animated") +
    gsi::constant ("Invisible", &qt_gsi::c_16_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Invisible") +
    gsi::constant ("Offscreen", &qt_gsi::c_17_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Offscreen") +
    gsi::constant ("Sizeable", &qt_gsi::c_18_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Sizeable") +
    gsi::constant ("Movable", &qt_gsi::c_19_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Movable") +
    gsi::constant ("SelfVoicing", &qt_gsi::c_20_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::SelfVoicing") +
    gsi::constant ("Focusable", &qt_gsi::c_21_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Focusable") +
    gsi::constant ("Selectable", &qt_gsi::c_22_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Selectable") +
    gsi::constant ("Linked", &qt_gsi::c_23_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Linked") +
    gsi::constant ("Traversed", &qt_gsi::c_24_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Traversed") +
    gsi::constant ("MultiSelectable", &qt_gsi::c_25_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::MultiSelectable") +
    gsi::constant ("ExtSelectable", &qt_gsi::c_26_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::ExtSelectable") +
    gsi::constant ("Protected", &qt_gsi::c_27_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Protected") +
    gsi::constant ("HasPopup", &qt_gsi::c_28_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::HasPopup") +
    gsi::constant ("Modal", &qt_gsi::c_29_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::Modal") +
    gsi::constant ("HasInvokeExtension", &qt_gsi::c_30_QAccessible_StateFlag_Enum, "@brief Enum constant QAccessible::HasInvokeExtension");
}

static std::string to_s_QAccessible_StateFlag_Enum (const QAccessible_StateFlag_Enum *e)
{
  if (e->value () == QAccessible::Normal) { return tl::sprintf ("Normal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Unavailable) { return tl::sprintf ("Unavailable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Selected) { return tl::sprintf ("Selected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Focused) { return tl::sprintf ("Focused (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Pressed) { return tl::sprintf ("Pressed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Checked) { return tl::sprintf ("Checked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Mixed) { return tl::sprintf ("Mixed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ReadOnly) { return tl::sprintf ("ReadOnly (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HotTracked) { return tl::sprintf ("HotTracked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::DefaultButton) { return tl::sprintf ("DefaultButton (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Expanded) { return tl::sprintf ("Expanded (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Collapsed) { return tl::sprintf ("Collapsed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Busy) { return tl::sprintf ("Busy (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Marqueed) { return tl::sprintf ("Marqueed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Animated) { return tl::sprintf ("Animated (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Invisible) { return tl::sprintf ("Invisible (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Offscreen) { return tl::sprintf ("Offscreen (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Sizeable) { return tl::sprintf ("Sizeable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Movable) { return tl::sprintf ("Movable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::SelfVoicing) { return tl::sprintf ("SelfVoicing (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Focusable) { return tl::sprintf ("Focusable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Selectable) { return tl::sprintf ("Selectable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Linked) { return tl::sprintf ("Linked (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Traversed) { return tl::sprintf ("Traversed (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::MultiSelectable) { return tl::sprintf ("MultiSelectable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::ExtSelectable) { return tl::sprintf ("ExtSelectable (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Protected) { return tl::sprintf ("Protected (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HasPopup) { return tl::sprintf ("HasPopup (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Modal) { return tl::sprintf ("Modal (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::HasInvokeExtension) { return tl::sprintf ("HasInvokeExtension (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_StateFlag_Enum (const QAccessible_StateFlag_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_StateFlag_Enum *from_i_QAccessible_StateFlag_Enum (unsigned int i)
{
  return new QAccessible_StateFlag_Enum ((QAccessible::StateFlag) i);
}

static bool equalQAccessible_StateFlag_Enum (const QAccessible_StateFlag_Enum *e, QAccessible_StateFlag_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_StateFlag_Enum (const QAccessible_StateFlag_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_StateFlag_Enums oropQAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e, const QAccessible_StateFlag_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_StateFlag_Enums andopQAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e, const QAccessible_StateFlag_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_StateFlag_Enums xoropQAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e, const QAccessible_StateFlag_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::Normal)) { if (!l.empty ()) l += "|"; l += "Normal"; }
  if (e->testFlag (QAccessible::Unavailable)) { if (!l.empty ()) l += "|"; l += "Unavailable"; }
  if (e->testFlag (QAccessible::Selected)) { if (!l.empty ()) l += "|"; l += "Selected"; }
  if (e->testFlag (QAccessible::Focused)) { if (!l.empty ()) l += "|"; l += "Focused"; }
  if (e->testFlag (QAccessible::Pressed)) { if (!l.empty ()) l += "|"; l += "Pressed"; }
  if (e->testFlag (QAccessible::Checked)) { if (!l.empty ()) l += "|"; l += "Checked"; }
  if (e->testFlag (QAccessible::Mixed)) { if (!l.empty ()) l += "|"; l += "Mixed"; }
  if (e->testFlag (QAccessible::ReadOnly)) { if (!l.empty ()) l += "|"; l += "ReadOnly"; }
  if (e->testFlag (QAccessible::HotTracked)) { if (!l.empty ()) l += "|"; l += "HotTracked"; }
  if (e->testFlag (QAccessible::DefaultButton)) { if (!l.empty ()) l += "|"; l += "DefaultButton"; }
  if (e->testFlag (QAccessible::Expanded)) { if (!l.empty ()) l += "|"; l += "Expanded"; }
  if (e->testFlag (QAccessible::Collapsed)) { if (!l.empty ()) l += "|"; l += "Collapsed"; }
  if (e->testFlag (QAccessible::Busy)) { if (!l.empty ()) l += "|"; l += "Busy"; }
  if (e->testFlag (QAccessible::Marqueed)) { if (!l.empty ()) l += "|"; l += "Marqueed"; }
  if (e->testFlag (QAccessible::Animated)) { if (!l.empty ()) l += "|"; l += "Animated"; }
  if (e->testFlag (QAccessible::Invisible)) { if (!l.empty ()) l += "|"; l += "Invisible"; }
  if (e->testFlag (QAccessible::Offscreen)) { if (!l.empty ()) l += "|"; l += "Offscreen"; }
  if (e->testFlag (QAccessible::Sizeable)) { if (!l.empty ()) l += "|"; l += "Sizeable"; }
  if (e->testFlag (QAccessible::Movable)) { if (!l.empty ()) l += "|"; l += "Movable"; }
  if (e->testFlag (QAccessible::SelfVoicing)) { if (!l.empty ()) l += "|"; l += "SelfVoicing"; }
  if (e->testFlag (QAccessible::Focusable)) { if (!l.empty ()) l += "|"; l += "Focusable"; }
  if (e->testFlag (QAccessible::Selectable)) { if (!l.empty ()) l += "|"; l += "Selectable"; }
  if (e->testFlag (QAccessible::Linked)) { if (!l.empty ()) l += "|"; l += "Linked"; }
  if (e->testFlag (QAccessible::Traversed)) { if (!l.empty ()) l += "|"; l += "Traversed"; }
  if (e->testFlag (QAccessible::MultiSelectable)) { if (!l.empty ()) l += "|"; l += "MultiSelectable"; }
  if (e->testFlag (QAccessible::ExtSelectable)) { if (!l.empty ()) l += "|"; l += "ExtSelectable"; }
  if (e->testFlag (QAccessible::Protected)) { if (!l.empty ()) l += "|"; l += "Protected"; }
  if (e->testFlag (QAccessible::HasPopup)) { if (!l.empty ()) l += "|"; l += "HasPopup"; }
  if (e->testFlag (QAccessible::Modal)) { if (!l.empty ()) l += "|"; l += "Modal"; }
  if (e->testFlag (QAccessible::HasInvokeExtension)) { if (!l.empty ()) l += "|"; l += "HasInvokeExtension"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_StateFlag_Enums (const QAccessible_StateFlag_Enums *e, const QAccessible_StateFlag_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_StateFlag_Enums> decl_QAccessible_StateFlag_Enums ("QAccessible_QFlags_StateFlag",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_StateFlag_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_StateFlag_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_StateFlag_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_StateFlag_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_StateFlag_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_StateFlag_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::StateFlag> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_StateFlag_Enum> decl_QAccessible_StateFlag_Enum (decl_QAccessible_StateFlag_Enums, "QAccessible_StateFlag",
  qt_gsi::mkdefs_QAccessible_StateFlag () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_StateFlag_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_StateFlag_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_StateFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_StateFlag_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_StateFlag_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::StateFlag enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_StateFlag_Enum_in_parent (qt_gsi::mkdefs_QAccessible_StateFlag ());
static gsi::ClassExt<QAccessible> decl_QAccessible_StateFlag_Enum_as_child (decl_QAccessible_StateFlag_Enum, "StateFlag");

}


//  Implementation of the enum wrapper class for QAccessible::Text
namespace qt_gsi
{

static QAccessible_Text_Enum *c_1_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::Name); }
static QAccessible_Text_Enum *c_2_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::Description); }
static QAccessible_Text_Enum *c_3_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::Value); }
static QAccessible_Text_Enum *c_4_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::Help); }
static QAccessible_Text_Enum *c_5_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::Accelerator); }
static QAccessible_Text_Enum *c_6_QAccessible_Text_Enum () { return new QAccessible_Text_Enum (QAccessible::UserText); }

static gsi::Methods mkdefs_QAccessible_Text () {
  return
    gsi::constant ("Name", &qt_gsi::c_1_QAccessible_Text_Enum, "@brief Enum constant QAccessible::Name") +
    gsi::constant ("Description", &qt_gsi::c_2_QAccessible_Text_Enum, "@brief Enum constant QAccessible::Description") +
    gsi::constant ("Value", &qt_gsi::c_3_QAccessible_Text_Enum, "@brief Enum constant QAccessible::Value") +
    gsi::constant ("Help", &qt_gsi::c_4_QAccessible_Text_Enum, "@brief Enum constant QAccessible::Help") +
    gsi::constant ("Accelerator", &qt_gsi::c_5_QAccessible_Text_Enum, "@brief Enum constant QAccessible::Accelerator") +
    gsi::constant ("UserText", &qt_gsi::c_6_QAccessible_Text_Enum, "@brief Enum constant QAccessible::UserText");
}

static std::string to_s_QAccessible_Text_Enum (const QAccessible_Text_Enum *e)
{
  if (e->value () == QAccessible::Name) { return tl::sprintf ("Name (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Description) { return tl::sprintf ("Description (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Value) { return tl::sprintf ("Value (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Help) { return tl::sprintf ("Help (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::Accelerator) { return tl::sprintf ("Accelerator (%u)", (unsigned int) e->value ()); }
  if (e->value () == QAccessible::UserText) { return tl::sprintf ("UserText (%u)", (unsigned int) e->value ()); }
  return std::string ("(not a valid enum evalue)");
}

static unsigned int to_i_QAccessible_Text_Enum (const QAccessible_Text_Enum *e)
{
  return (unsigned int) e->value ();
}

static QAccessible_Text_Enum *from_i_QAccessible_Text_Enum (unsigned int i)
{
  return new QAccessible_Text_Enum ((QAccessible::Text) i);
}

static bool equalQAccessible_Text_Enum (const QAccessible_Text_Enum *e, QAccessible_Text_Enum d)
{
  return e->value () == d.value ();
}

static bool equal2QAccessible_Text_Enum (const QAccessible_Text_Enum *e, unsigned int i)
{
  return (unsigned int) e->value () == i;
}

static QAccessible_Text_Enums oropQAccessible_Text_Enums (const QAccessible_Text_Enums *e, const QAccessible_Text_Enums &d)
{
  return e->flags () | d.flags ();
}

static QAccessible_Text_Enums andopQAccessible_Text_Enums (const QAccessible_Text_Enums *e, const QAccessible_Text_Enums &d)
{
  return e->flags () & d.flags ();
}

static QAccessible_Text_Enums xoropQAccessible_Text_Enums (const QAccessible_Text_Enums *e, const QAccessible_Text_Enums &d)
{
  return e->flags () ^ d.flags ();
}

static std::string to_s_QAccessible_Text_Enums (const QAccessible_Text_Enums *e)
{
  std::string l;
  if (e->testFlag (QAccessible::Name)) { if (!l.empty ()) l += "|"; l += "Name"; }
  if (e->testFlag (QAccessible::Description)) { if (!l.empty ()) l += "|"; l += "Description"; }
  if (e->testFlag (QAccessible::Value)) { if (!l.empty ()) l += "|"; l += "Value"; }
  if (e->testFlag (QAccessible::Help)) { if (!l.empty ()) l += "|"; l += "Help"; }
  if (e->testFlag (QAccessible::Accelerator)) { if (!l.empty ()) l += "|"; l += "Accelerator"; }
  if (e->testFlag (QAccessible::UserText)) { if (!l.empty ()) l += "|"; l += "UserText"; }
  return tl::sprintf ("%u (%s)", (unsigned int) (e->flags ()), l);
}

static int to_i_QAccessible_Text_Enums (const QAccessible_Text_Enums *e)
{
  return int (e->flags ());
}

static bool testFlag_QAccessible_Text_Enums (const QAccessible_Text_Enums *e, const QAccessible_Text_Enum &d)
{
  return e->flags ().testFlag (d.value ());
}

}

namespace gsi
{

//  Declarations for QFlags<enum> wrapper class
gsi::Class<qt_gsi::QAccessible_Text_Enums> decl_QAccessible_Text_Enums ("QAccessible_QFlags_Text",
  gsi::method_ext ("|", &qt_gsi::oropQAccessible_Text_Enums, gsi::arg ("other"), "@brief 'or' operator between two flag sets") +
  gsi::method_ext ("&", &qt_gsi::andopQAccessible_Text_Enums, gsi::arg ("other"), "@brief 'and' operator between two flag sets") +
  gsi::method_ext ("^", &qt_gsi::xoropQAccessible_Text_Enums, gsi::arg ("other"), "@brief 'xor' operator between two flag sets") +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Text_Enums, "@brief Converts the flag set to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Text_Enums, "@brief Returns the integer value encoding the flag set") +
  gsi::method_ext ("testFlag", &qt_gsi::testFlag_QAccessible_Text_Enums, gsi::arg ("flag"), "@brief Tests whether the flag is contained in the flag set"),
  "@qt\n@brief This class represents the QFlags<QAccessible::Text> flag set");

//  Declarations for enum wrapper class
gsi::Class<qt_gsi::QAccessible_Text_Enum> decl_QAccessible_Text_Enum (decl_QAccessible_Text_Enums, "QAccessible_Text",
  qt_gsi::mkdefs_QAccessible_Text () +
  gsi::method_ext ("to_s|inspect", &qt_gsi::to_s_QAccessible_Text_Enum, "@brief Converts the enum class to a string") +
  gsi::method_ext ("to_i", &qt_gsi::to_i_QAccessible_Text_Enum, "@brief Converts the enum class to an integer") +
  gsi::method_ext ("==", &qt_gsi::equalQAccessible_Text_Enum, gsi::arg ("other"), "@brief Compares the enum class against an enum of it's own type") +
  gsi::method_ext ("==", &qt_gsi::equal2QAccessible_Text_Enum, gsi::arg ("other"), "@brief Compares the enum class against an integer") +
  gsi::constructor ("new", &qt_gsi::from_i_QAccessible_Text_Enum, gsi::arg ("value"), "@brief Creates the enum object from an integer"),
  "@qt\n@brief This class represents the QAccessible::Text enum");

//  Inject the declarations into the parent
static gsi::ClassExt<QAccessible> inject_QAccessible_Text_Enum_in_parent (qt_gsi::mkdefs_QAccessible_Text ());
static gsi::ClassExt<QAccessible> decl_QAccessible_Text_Enum_as_child (decl_QAccessible_Text_Enum, "Text");

}

