/********************************************************************************

Copyright 2018  Thomas Fischer <fischer@unix-ag.uni-kl.de> and others

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

1. Redistributions of source code must retain the above copyright
   notice, this list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright
   notice, this list of conditions and the following disclaimer in the
   documentation and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

********************************************************************************/

static const char *bug19489LastAuthors("Ralph");
static const char *bug19489FilesUrlsDois("bart.04.1242.pdf");
static const char *nameswithbracesLastAuthors("{{{{{LastName3A LastName3B}}}}}");
static const char *nameswithbracesFilesUrlsDois("");
static const char *duplicatesLastAuthors("FlajoletSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickSedgewickWayne");
static const char *duplicatesFilesUrlsDois("http://dblp.uni-trier.de/db/conf/esa/esa96.html#Sedgewick96"
        "http://dblp.uni-trier.de/db/conf/esa/esa96.html#Sedgewick96http://dblp.uni-trier.de/db/conf/esa/esa96.html#Sedgewick96http://dblp.uni-trier.de/db/journals/jal/jal15.html#SchafferS93http://portal.acm.org/citation.cfm?id=159277.159281&coll=Portal&dl=GUIDE&CFID=89127717&CFTOKEN=92605832"
        "10.1006/jagm.1993.1031http://portal.acm.org/citation.cfm?id=159277.159281&coll=Portal&dl=GUIDE&CFID=89127717&CFTOKEN=9260583210.1006/jagm.1993.1031");
static const char *minixLastAuthors("ACMACMACMAasAltingAnglinAnonymousAnonymousAnonymousAnonymousAnonymousAnonymousAnonymousAnonymousAnonymousArbaughAshtonBosChangChenChigiraChittoorChizmadiaChristieCushingDasDasDurrEganFerenceFresquezGallardGallardGallardGer\u0151fiGrehanGuerriniGuhaGuoHartleyHartley"
                                    "HaysHerHerderHernesHernesHowattHsiehIEEEIEEEIEEEJenKachelKanapoulosKellyKimKnudsonKobylanskiKochLakshmiLarribeauLevittLevittLiLouboutinMaginnisMaginnisMartellaMeierMeursMullerNakamaNaniwadekarNaniwadekarNavauxNettoNollOlabeOmuraRameshRennhackkampRennhackkamp"
                                    "RoskosSandSilveiraSmithSmithStevensonSuarezTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTanenbaumTiwanaTsaiVaidyanathanVikenWainerWangWeiWilliamsWinkler"
                                    "WoodhullWoodhullXuYagerYangde V. Smitvan Moolenbroek");
static const char *minixFilesUrlsDois("10.1145/322609.32313510.1145/322609.32315310.1145/322609.32315210.1109/ACSAC.1988.11333810.1145/74091.7409310.1145/122153.12216510.1145/101085.10109610.1145/122572.12257510.1109/IWRSP.1991.21862310.1145/163640.163647"
                                      "10.1145/160551.16055810.1145/155848.15585610.1109/EURMIC.1994.39033910.1145/206826.20684610.1145/820127.820179http://www.minix3.org/doc/herder_thesis.pdfhttp://www.minix3.org/doc/alting_thesis.pdf10.1145/1134744.1134747http://www.minix3.org/doc/gerofi_thesis.pdf"
                                      "http://www.minix3.org/doc/EDCC-2006.pdfhttp://www.eu-egee.org/egee_events/events/edcc-6-sixth-european-dependable-computing-conference-18-20-october-2006-coimbra-portugal/http://www.minix3.org/doc/reliable-os.pdfhttp://www.minix3.org/doc/OSR-2006.pdf10.1145/1151374.1151391"
                                      "http://www.usenix.org/publications/login/2006-04/openpdfs/herder.pdfhttp://www.minix3.org/http://www.minix3.org/doc/ACSAC-2006.pdfhttp://minixonxen.skynet.ie/cgi-bin/trac.cgi/attachment/wiki/Report/Report.pdf?format=rawhttp://www.minix3.org/doc/meurs_thesis.pdf"
                                      "10.1109/MC.2006.156http://www.minix3.org/doc/moolenbroek_thesis.pdf10.1145/1348713.1348716");
static const char *bug19484refsLastAuthors("AUAIAbell\u00e1nAeyelsAeyelsAeyelsAitchisonAsaiAugustinAugustinAugustinAugustinAugustinAugustinAugustinAugustinAugustinAugustinAvisBN@WorkBachmanBalakrishnanBarndorff-NielsenBayerBeerelBen-HaimBergerBernardBernardBernardBernardBickisBillingsleyBooleBoraty\u0144skaBorodovsky"
        "BoseBoseBouchon-MeunierBouckaertBouteBouteBrokkenBrownBrownBuckleyBuehlerBurrillBurtonBushellCamererCarnapCasalisChatfieldChojnackiChoquetChrismanChurchCoolenCoolenCoolenCoolenCoolenCooperCooperCoup\u00e9CousoCousoCozmanCozmanCozmanCozmanCozmanCozmanCozmanCram\u00e9r"
        "DaboniDaboniDaniellDantzigDarwicheDavisDavisonDawidDayhoffDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe CoomanDe Cooman"
        "De CoomanDe MunckDe PalmaDeGrootDegrauweDelbaenDempsterDempsterDennebergDennebergDerriennicDesterckeDhaenensDietzenbacherDoseDoumontDoumontDoumontDoumontDoumontDoumontDoumontDoumontDoumontDoumontDyerECCAIEckelEckelEdwardsEfronEisenEl GhaouiEl GhaouiEl-Atoum"
        "ElbersEricsonFagiuoliFauserFeronFersonFineFinessoFinkFiorettiFishburnFishburnFishburnFisherFortetFreedmanFreedmanFriedmanFriedmanFriedmanFriedmanFriendFr\u00e9chetFudenbergFukudaFukudaFukudaGaifmanGeisserGhahramaniGhahramaniGilGilGoldbergGoldsteinGoldsteinGoodGood"
        "GrabischGrafGrapsGroenendaalGr\u00fcnbaumGunawardenaGutinGuti\u00e9rrez-Pe\u00f1aHaddawyHaldaneHaldaneHallHalpernHalpernHammerHampelHanksHarsanyiHarsanyiHartHartfielHartfielHatcherHausslerHermansHermansHermansHerrmannHillHillHippHirschHlad\u00edkHofbauerHogarthHogeveenHolmes"
        "HumeHutterHuygensHuzurbazarInuiguchiInuiguchiIserlesJacobJaegerJaffrayJaffrayJaffrayJaynesJeffreysJiJohnsonJohnsonJohnsonJohnsonJordanKadaneKadaneKadaneKadaneKadaneKadaneKadaneKallenbergKarassaKarlinKarypisKatzoffKerreKerreKerreKeynesKleeKleeKlee, Jr. Koller"
        "KolmogorovKoopmanKoopmanKoopmanKoopmansKotzKrieglerKroghKroghKrymskyKubi\u015bKunischKunreutherKutateladzeKuznetsovKyburgLaValleLambrakisLangeLangleyLaplaceLaplaceLarkeyLarkeyLarra\u00f1agaLaskeyLauritzenLauritzenLawryLawryLetacLeviLeviLeviLevineLevineLiuLiuLoLodwick"
        "LoeffenLoeffenLoeligerMaa\u00dfMaa\u00dfMacKayMaceManskiMantelMarcotMartinMarzettaMas-ColellMazzuchiMcKinneyMevelMillerMilmanMilneMinkaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMirandaMitchisonMoralMoralMoralMoralMoralMoreaux"
        "MorishimaMorrisMosimannMosimannMoslehianMr\u00e1zMunroMurphyM\u00fcllerNadarajahNashNasriNauNauNemirovskiNeumaierNeumaierNeumaierNorthropNuutilaO'HaraOliphantOltvaiOrcuttOshimeOshimePalusznyPapadimitriouPardalosParsonsPatilPazzaniPearlPearlPereiraPereiraPetersPeterson"
        "PetriniPinkusPradePradePrautzschPriestleyProdonP\u00f3lyaQuQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeurQuaeghebeur"
        "RafteryRam\u00edkRegazziniRenooijRenooijRenooijRevuzRiabackeRiosRobertsRobinsonRockafellarRohnRommelfangerRommelfangerRosenthalRotaRoubensRoyRubinRudolphRuedaSIKSSIPTASabbadinSakawaSarabiaSarukkaiSavageSchechterSchemppSchervishSchlaiferSchneierSchwartzSch\u00f6lkopf"
        "SegaleSeidelSeidenfeldSeidenfeldSeidenfeldSeidenfeldSeidenfeldSeidenfeldSeidenfeldSenetaSentzSentzSeoShaferShaferShaferShannonShapleyShapleyShepardShimonySigmundSigmundSineSivaganesanSkyrmsSmithSmithSmithSmithSnellSnellSousaSoysterSpiegelhalterStegunSteuerSteuer"
        "StoyeStrassenStrensStroblSudderthSuppesSuppesSuvritSzaniawskiTaalTaalTaalTallonTanakaTaylorTessemThapaThatcherThompsonTroffaesTroffaesTroffaesTroffaesTroffaesTroffaesTsaiTsitsiklisTukeyUtkinVan LoanVandenbergheVanstoneVaraiyaVerdegayVeroneseVeroneseVicigVicig"
        "VicigVicigVicigVicigWagnerWagnerWagnerWagnerWagnerWagnerWagnerWagnerWagnerWagnerWagnerWagnerWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWalleyWallnerWallnerWalterWankaWassermanWatsonWatsonWeichselbergerWellmanWhittleWhittleWilliams"
        "WilliamsWilliamsWilliamsWilliamsWilliamsWilsonWongYeYlvisakerYuZabellZabellZabellZabellZabellZadehZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZaffalonZagoraiouZelenyZieglerZieglerZimmermann"
        "ZimmermannZimmermannZimmermannZimmermannde Boorde Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Finettide Jongvan der Gaagvan der Gaagvan der Gaag"
        "van der Gaagvan der Gaagvan der Gaagvan der Gaagvan der Gaagvan der Gaagvan der Gaagvon Neumannvon Winterfeldt\u0160kulj\u0160kulj");
static const char *bug19484refsFilesUrlsDois("10.1016/j.ijar.2011.04.004article/Couso-Moral-2011.pdfinbook/Morishima-1964-Perron-Frobenius.pdf10.1016/j.ijar.2010.12.002inbook/Dayhoff-Schwartz-Orcutt-1978.pdf"
        "http://users.ugent.be/~equaeghe/#EQ-2010-SSS10.1016/0165-0114(94)00353-9article/Buckley-1995.pdfhttp://www.jstor.org/stable/2318065article/Peterson-1972-Radon.pdf10.1016/S0004-3702(98)00089-7article/Fagiuoli-Zaffalon-1998-2U.pdfhttp://www.jstor.org/stable/1402732"
        "article/Edwards-1983-Pascal.pdfhttp://www.jstor.org/stable/295834410.1214/aosarticle/Hipp-1974.pdfhttp://www.jstor.org/stable/2984504article/Dempster-1968.pdfhttp://www.ams.org/bull/1940-46-10/S0002-9904-1940-07294-5/S0002-9904-1940-0729\n4-5.pdfhttp://projecteuclid.org/euclid.bams/1183503229"
        "article/Koopman-1940-ams.pdf10.1016/j.ijar.2004.10.003article/Cozman-2005-graphical.pdf10.1023/A:1018936829318article/Ha-etal-1998.pdfarticle/Daboni-1975.pdf10.1016/S0378-3758(01)00201-4article/Zaffalon-2002-ncc.pdf10.1016/j.envsoft.2004.10.006http://www.sciencedirect.com/science/article/B6V05-4RM881N-1/1/385e96ea2df064e7\nab875367eafbf9f9"
        "10.1016/j.fss.2007.12.021article/Combarro-Miranda-2008-polytope.pdfhttp://www.jstor.org/stable/2984417article/Tatcher-1964.pdf10.1080/15598608.2009.10411926article/Aughenbaugh-Herrmann-2009.pdf10.1023/A:1014745904458article/Kozine-Utkin-2002.pdfarticle/DeFinetti-1933c.pdf"
        "10.1007/s00500-002-0217-3article/Gilbert-DeCooman-Kerre-2003.pdfarticle/DeFinetti-1933a.pdf10.1186/1471-2105-7-263article/Munch-Krogh-2006.pdfhttp://www.jstor.org/stable/25050444article/Basu-Pereira-1983b.pdf10.1215/S0012-7094-51-01835-210.1142/S0218488502001867"
        "article/Miranda-Grabisch-Gil-2002.pdfinbook/VanDorp-Mazzuchi-2003.pdfarticle/Fodor-Marichal-Roubens-1995.pdfhttp://www.jstor.org/stable/1403571article/Pericchi-Walley-1991.pdfhttp://www.jstor.org/stable/3689397article/Fishburn-1980.pdfhttp://www.jstor.org/stable/2346164"
        "article/Walley-1996-IDM.pdf10.1016/0024-3795(86)90319-8article/Bushell-1986-Hilbert-metric.pdfhttp://diglib.cib.unibo.it/diglib.php?inv=35&term_ptnum=1&format=jpg10.4134/JKMS.2010.47.1.017article/Bot-Lorenz-Wanka-2010.pdfhttp://www.jstor.org/stable/2984207article/Ericson-1969.pdf"
        "http://www.jstor.org/stable/213265910.1137/1037083article/Rosenthal-1995-Markov-rate.pdfhttp://www.jstor.org/stable/2238958article/Bloch-Watson-1967.pdf10.1214/aosarticle/Zabell-1982.pdf10.1214/ssarticle/Cifarelli-Regazzini-1996.pdf10.1007/s10700-004-4200-6"
        "article/Rommelfanger-2004.pdfhttp://www.jstor.org/stable/2983842article/Smith-1961.pdfhttp://books.google.com/books?id=0bTK5uWzbYwChttp://www.jstor.org/stable/687102article/Williams-1978.pdfhttp://www.jstor.org/stable/263276510.1287/mnsc.40.2.263article/Luce-VonWinterfeld-1994.pdf"
        "http://www.jstor.org/stable/2983957article/Whittle-1955.pdfhttp://www.jstor.org/stable/2291525article/GutierrezPena-Smith-1995.pdfarticle/Krein-Milman-1940.pdfhttp://www.jstor.org/stable/2683137article/Tukey-1986-sunset.pdf10.1215/S0012-7094-55-02209-2article/Hammer-1955.pdf"
        "10.1016/S0047-259X(03)00095-2article/Consonni-Veronese-GutierrezPena-2004.pdf10.1016/j.ijar.2008.03.01210.1080/03081070500190839article/Augustin-2005.pdf10.1016/0888-613X(88)90117-Xarticle/Pearl-1988-intervals.pdfarticle/DeFinetti-1933b.pdf10.1111/1467-9469.00075"
        "article/Walley-1997-bounded.pdfhttp://www.jstor.org/stable/2984811article/Suppes-1974.pdfhttp://www.numdam.org/item?id=AIF_1956__6__187_0article/Revuz-1956.pdfhttp://www.nsc.ru/interval/Library/InteBooks/InexactLP.pdfhttp://cgm.cs.mcgill.ca/~avis/C/lrs.html"
        "10.1080/03081077508960870http://www.mscand.dk/article.php?id=1449article/Klee-1956.pdf10.1007/s10472-005-9006-xarticle/DeCooman-2005-order.pdftechreport/Williams-1975.pdfhttp://www.jstor.org/stable/2268039article/Shimony-1955.pdf10.1016/j.ijar.2006.06.001article/Troffaes-2007-decision.pdf"
        "http://www.cs.hut.fi/~enu/thesis.htmlhttp://www.jstor.org/stable/2283728article/Conner-Mosimann-1969.pdf10.1007/s10959-007-0055-4article/Miranda-DeCooman-Quaeghebeur-2007-Hausdorff.pdf10.1007/s12543-009-0002-4article/Ovaere-deschrijver-Kerre-2009.pdfhttp://www.jstor.org/stable/2631295"
        "article/Harsanyi-1982-comment.pdf10.1007/s11225-007-9064-7article/Wagner-2007-Smith-Walley.pdf10.1080/0196972730854591210.1214/aosarticle/Diaconis-Ylvisaker-1979.pdf10.1016/j.ejor.2005.03.005article/Miranda-Combarro-Gil-2006-extreme.pdf10.1016/j.jspi.2004.03.005"
        "article/Miranda-DeCooman-Couso-2005-multivalued.pdf10.1016/j.ijar.2006.11.003article/Bruening-Dennenberg-2007-belELP.pdf10.3982/TE596article/Epstein-Seo-2010.pdf10.1093/nararticle/Rho-Tang-Ye-2010.pdfarticle/Utkin-Augustin-2007.pdf10.1186/1471-2105-7-239article/Munch-etal-2006.pdf"
        "10.1023/A:1016705331195article/DeCooman-2001.pdfhttp://www.jstor.org/stable/224275210.1214/aosarticle/Casalis-1996.pdf10.1016/j.ijar.2010.08.011article/DeCooman-etal-2010.pdfhttp://www.jstor.org/stable/2631294article/Kadane-Larkey-1982.pdf10.1287/mnsc.17.4.B141"
        "article/Bellman-Zadeh-1970.pdfhttp://www.sciencedirect.com/science/article/pii/S037837580100206310.1016/S0378-3758(01)00206-3article/Zaffalon-2002-missing.pdf10.1016/j.artint.2004.05.006article/DeCooman-Zaffalon-2004-incomplete.pdf10.1093/bioinformaticsarticle/Liu-Mueller-2003.pdf"
        "10.1006/game.1999.0717http://bcn.boulder.co.us/government/approvalvote/altvote.htmlhttp://www.worldscibooks.com/compsci/6747.html10.1016/S0377-2217(99)00473-7article/Dubois-Prade-Sabbadin-2001.pdf10.1016/j.ijar.2006.07.014article/Gillett-et-al-2007.pdf10.1093/nar"
        "http://www.people.cornell.edu/pages/df36/CONJINTRnewTEX.pdf10.1007/BF00485351article/Zabell-1992.pdf10.1016/S0165-0114(98)00449-7article/Inuiguchi-Ramik-2000.pdf10.1006/jeth.2000.2746article/Hart-MasColell-2001.pdf10.1017/S1357530900000156article/Couso-Moral-Walley-2000-independence.pdf"
        "10.1016/S0378-3758(01)00209-9article/DeCooman-2002.pdfhttp://www.jstor.org/stable/295857810.1214/aosarticle/Buehler-1976.pdfhttp://www.amsta.leeds.ac.uk/~charles/statloghttp://repository.cmu.edu/statistics/3810.1287/mnsc.28.2.124article/Kadane-Larkey-1982-reply.pdf"
        "10.1023/A:102582232174310.1007/s101070100286article/BenTal-Nemirovski-2002.pdf10.1214/aosarticle/Morris-1982.pdf10.1006/jmbi.1994.1104article/Krogh-etal-1994.pdfhttp://www.jstor.org/stable/224306310.1214/aoparticle/Diaconis-Freedman-1980-partial-xch.pdfhttp://people.cs.ubc.ca/~murphyk/Papers/intro_gm.pdf"
        "http://www.jstor.org/stable/2291741article/Kadane-Schervish-Seidenfeld-1996-foregone.pdf10.1007/s10472-005-9011-0article/Moral-2005-desir.pdfhttp://www.stat.cmu.edu/tr/tr660/tr660.html10.1016/0165-0114(91)90019-Marticle/Buckley-Qu-1991.pdfhttp://www.jstor.org/stable/3689308"
        "article/Dyer-1983.pdfhttp://www.jstor.org/stable/168933article/Soyster-1973.pdf10.1007/BF02564426article/GutierrezPena-Smith-1997-review.pdf10.1007/BF01448847article/vonNeumann-1928.pdf10.1007/978-3-540-85027-4_2910.1016/j.ijar.2008.02.005article/Antonucci-Zaffalon-2008.pdf"
        "10.1109/18.910572article/Kschischang-Frey-Loeliger-2001.pdfhttp://www.jstor.org/stable/187511article/Seidenfeld-1985.pdfhttp://www.digizeitschriften.de/dms/img/?PPN=GDZPPN00036554810.1007/BF02293050article/Avis-Fukuda-1992.pdf10.1016/0885-064X(88)90006-4article/Georgakopoulos-Kavvadias-Papadimitriou-1988.pdf"
        "10.1007/3-540-31182-3_66incollection/Jimenez-etal-2005.pdf10.1016/j.ijar.2007.09.003article/Ide-Cozman-2008.pdf10.1007/BF0104925910.1016/0304-4068(94)90033-7article/Dietzenbacher-1994-Perron-Frobenius.pdfhttp://decsai.ugr.es/~lci/journal-papers-pdf/ijuf94.pdf"
        "10.1142/S0218488594000146article/DeCampos-Huete-Moral-1994-intervals.pdf10.1016/j.artint.2008.03.001article/DeCooman-Hermans-2008-bridging.pdf10.3150/09-BEJ182http://www.jstor.org/stable/2237603article/Billingsley-1961.pdf10.1016/j.jspi.2003.07.003article/Augustin-Coolen-2004.pdf"
        "http://www.jstor.org/stable/1969529article/Nash-1951.pdfhttp://www.stat.uni-muenchen.de/~thomas/team/diplomathesis_GeroWalter.pdfmastersthesis/Walter-2006.pdf10.1016/0167-8396(95)00031-3article/Trump-Prautzsch-1996.pdf10.1007/s10472-011-9231-4article/Miranda-Zaffalon-2011.pdf"
        "http://www.sipta.org/isipta09/proceedings/063.htmlhttp://www.jstor.org/stable/2682880article/Mantel-1976-tails.pdfhttp://cm.bell-labs.com/cm/ms/what/shannonday/shannon1948.pdfarticle/Shannon-1948.pdfhttp://decsai.ugr.es/~smc/isipta99/proc/072.html10.1023/A:1020287225409"
        "article/Kunreuther-et-al-2002.pdfhttp://www.ams.org/journals/tran/1962-103-01/S0002-9947-1962-0147879-X/S0002-99\n47-1962-0147879-X.pdf10.1090/S0002-9947-1962-0147879-Xarticle/McKinney-1962.pdfhttp://www.jstor.org/stable/3214695article/Hartfiel-1991.pdf10.1016/j.ijar.2008.03.011"
        "article/Coolen-Augustin-2008-IDM-alternative.pdfhttp://www.jstor.org/stable/1969003article/Koopman-1940-axioms.pdfhttp://hdl.handle.net/10338.dmlcz/135726article/Inuiguchi-2006.pdfhttp://www.jstor.org/stable/184348article/Northrop-1936-prob-in-QM.pdf10.1016/S0925-7721(96)00023-5"
        "article/Avis-Bremner-Seidel-1997.pdf10.1046/j.1464-410x.1999.0830s1079.xarticle/OHara-OHara-1999.pdfhttp://www.jstor.org/stable/2684602article/Genest-MacKay-1986.pdf10.1016/0024-3795(94)00222-3article/Rudolph-1996-duality.pdfarticle/Benavoli-et-al-2010.pdfhttp://www.jstor.org/stable/2284229"
        "article/Savage-1971.pdf10.1007/BF01441156article/Lange-1995.pdfhttp://www.jstor.org/stable/2981696article/Goodhardt-Ehrenberg-Chatfield-1984.pdfhttp://iospress.metapress.com/content/22bh7djyjk86a55harticle/DeCooman-Troffaes-Miranda-2005-Kerre.pdf10.1007/978-3-642-14055-6_7"
        "10.1007/s10472-005-9009-7http://www.schneier.com/book-applied.html10.1287/mnsc.28.2.124aarticle/Harsanyi-1982-rejoinder.pdfhttp://www.m-hikari.com/imf-password2007/13-16-2007/mazaheriIMF13-16-2007-3.pdf\narticle/Mazaheri-Nasri-2007.pdf10.1016/j.ijar.2009.01.005"
        "article/Antonucci-etal-2009-milident.pdfhttp://www.gutenberg.org/ebooks/1511410.1214/aomsarticle/Bildikar-Patil-1968.pdfhttp://books.google.com/books?id=Ovo3AAAAMAAJhttp://www.ams.org/journals/tran/1936-039-03/S0002-9947-1936-1501854-3/S0002-99\n47-1936-1501854-3.pdf"
        "article/Koopman-1936.pdf10.1098/rspa.1934.0050article/Fisher-1934.pdf10.1016/S0165-0114(02)00248-8article/Neumaier-2003-surprise.pdf10.1142/S0218488503002156article/Pelessoni-Vicig-2003-risk.pdf10.1088/0957-0233article/Dose-2007-gravity.pdf10.1109/TPC.2002.805164"
        "article/Doumont-2002.pdf10.1016/j.geb.2009.03.013article/Halpern-2010.pdf10.1023/A:1018911830478article/Fishburn-LaValle-1998.pdfhttp://www.jstor.org/stable/2332299article/Haldane-1945.pdf10.1613/jair.1292article/Halpern-Koller-2004.pdfhttp://www.handleidinghtml.nl"
        "http://projecteuclid.org/euclid.kjm/1250521436article/Oshime-1983-Perron.pdf10.1007/978-3-540-68996-6_5inbook/VanderGaag-Renooij-Coupe-2007.pdfhttp://www.jstor.org/stable/2282931article/Johnson-1967.pdf10.1007/978-3-540-44792-4_2010.1016/S0020-0255(01)00090-1"
        "article/Walley-DeCooman-2001.pdfhttp://hdl.handle.net/1854/LU-1863955http://www.jstor.org/stable/224166810.1214/aosarticle/Schervish-1989-forecaster.pdfhttp://www.jstor.org/stable/2284038article/Hill-1968-An.pdf10.1016/S0888-613X(99)00007-9article/Walley-DeCooman-1999.pdf"
        "10.1016/S0933-3657(03)00046-010.1214/ssarticle/Fishburn-1986.pdfhttp://users.ugent.be/~equaeghe/content/EQ-2002-UCL-memoire-hyperlinked.pdfmastersthesis/Quaeghebeur-2002.pdf10.1142/S0218001401000836article/Ghahramani-2001-HMM+BN-intro.pdfhttp://frameindex.htm"
        "http://www.jstor.org/stable/25050417article/Basu-Pereira-1983a.pdf10.1006/game.1993.1021article/Fudenberg-Kreps-1993.pdf10.1016/0165-4896(89)90056-5article/Chateauneuf-Jaffray-1989.pdf10.1016/j.ijar.2006.07.017article/Wallner-2007-extremepoints.pdf10.1016/j.fss.2007.11.020"
        "article/Quaeghebeur-DeCooman-2008-ELP-FSS.pdfhttp://www.jstor.org/stable/2683760article/Heath-Sudderth-1976-exchangeability.pdfhttp://books.google.com/books?id=4UY-ucucWucC10.1016/0020-0255(85)90025-810.1023/A:1009778005914article/Friedman-1997.pdfhttp://uivtx.cs.cas.cz/~rohn/handbook"
        "10.1016/S0096-3003(97)10140-0article/Wong-1998.pdf10.1016/j.ress.2005.11.042article/Hall-2006-sensitivity-indices.pdf10.1007/BF00531932article/Rota-1964-moebius.pdf10.1016/j.jspi.2003.09.005article/Walley-Pelessoni-Vicig-2004.pdfhttp://www.jstor.org/stable/3689148"
        "article/Matheiss-Rubin-1980.pdf10.1126/science.1094068article/Friedman-2004.pdfhttp://www.cs.unb.ca/profs/bremner/pd10.1007/PL00009389http://www.jstor.org/stable/2288190article/Goldstein-1983.pdf10.1016/S1389-1286(00)00044-Xarticle/Sarukkai-2000-link-prediction.pdf"
        "10.1016/S0378-3758(01)00204-Xarticle/Walley-2002-reconciling.pdf10.1016/S0004-3702(00)00029-1article/Cozman-2000-cn.pdfhttp://www.tramy.us/numpybook.pdfarticle/Daboni-1953.pdf10.1016/j.ijar.2004.10.009article/Ferreira-Cozman-2005-AR+.pdfhttp://www.numdam.org/item?id=AIHP_1930__1_2_117_0"
        "article/Polya-1930.pdfhttp://www.jstor.org/stable/3009940article/Inuiguchi-Sakawa-1997.pdf10.1016/j.ijar.2006.07.019article/Williams-2007-notes.pdf10.1016/0022-247X(74)90133-4article/Delbaen-1974.pdf10.1016/0167-6377(89)90010-2article/Jaffray-1989.pdfhttp://www.jstor.org/stable/687182"
        "article/Williams-1980.pdf10.1214/aosarticle/Huber-Strassen-1973.pdf10.1111/j.1365-2362.2010.02272.xarticle/Ioannidis-et-al-2010-afraid.pdf10.1198/016214506000001437article/Gneiting-Raftery-2007.pdf10.1016/j.jsc.2003.08.007article/Fukuda-2004-Minkowski-addition.pdf"
        "10.1007/978-1-4020-8202-310.1016/j.ijar.2006.07.018article/Vicig-Zaffalon-Cozman-2007-notes.pdfhttp://www.jstor.org/stable/224236610.1214/aosarticle/Nau-1992.pdfhttp://links.jstor.org/sici?sici=0035-9246(1969)31:2%3C195:SBMISF%3E2.0.CO10.1016/0305-0548(83)90004-7"
        "10.1016/j.ijar.2004.10.002article/Bernard-2005.pdf10.1023/A:1007413511361article/Domingos-Pazzani-1997.pdf10.1016/0888-613X(92)90006-Lhttp://hdl.handle.net/1854/LU-18236510.1080/03081079708945160article/DeCooman-1997-postheo1.pdf10.1016/0377-2217(95)00008-9"
        "article/Rommelfanger-1996.pdfbook/Walley-1991-book.pdfbook/Walley-1991.pdf10.1016/j.ijar.2006.12.009article/Miranda-DeCooman-2007-margext.pdf10.1016/0004-3702(95)00009-7article/Walley-1996-expert.pdf10.1007/978-1-4020-8202-3http://portal.acm.org/citation.cfm?doid=1086642.1086647"
        "10.1145/1086642.1086647article/Boute-2005.pdf10.1007/s10472-005-9004-zarticle/Cozman-Walley-2005-graphoid.pdf10.1007/BF02213460article/Zabell-1995.pdfhttp://www.jstor.org/stable/1268384article/Miller-1980-gamma.pdf10.1016/0304-4068(94)90028-0article/Fujimoto-Oshime-1994-Perron-Frobenius.pdf"
        "10.1109/3468.833093article/DeCooman-Aeyels-2000.pdf10.1016/j.ijar.2010.01.007article/Antonucci-etal-2010-GL2U.pdfhttp://journal.sjdm.org/jdm7303b.pdfarticle/Krantz-Kunreuther-2007.pdf10.1093/biometarticle/Mardia-ElAtoum-1976.pdfhttp://www.jstor.org/stable/1969530"
        "article/Robinson-1951.pdfhttp://books.google.com/books?id=SsBPTDFwnpoChttp://www.cs.utexas.edu/~suvrit/work/research.html10.1023/B:SYNT.0000029944.99888.a7article/Gaifman-2004.pdfhttp://hdl.handle.net/1854/6279mastersthesis/Quaeghebeur-2001.pdfhttp://www.ams.org/journals/tran/2004-356-12/S0002-9947-04-03470-1"
        "article/Gaubert-Gunawardena-2004-Perron.pdf10.1016/j.ijar.2009.06.007article/Skulj-2009-impmarkov.pdfhttp://links.jstor.org/stable/2984416article/Aitchison-1964-tolerance.pdf10.1016/j.ijar.2005.03.001article/Baroni-Vicig-2005-interchange.pdf10.1007/978-1-4020-8202-3"
        "http://www.jstor.org/stable/2290285article/Wasserman-Kadane-1992.pdf10.1016/S0888-613X(00)00031-1article/Walley-2000-towards.pdfhttp://www.jstor.org/stable/2287313article/Diaconis-Zabell-1982.pdfhttp://www.jstor.org/stable/2250183article/Johnson-1932.pdfhttp://www.sipta.org/isipta07/proceedings/proceedings-optimised.pdf"
        "proceedings/ISIPTA-2007.pdf10.1016/j.ijar.2006.07.020article/Cano-etal-2007-cn.pdf10.1214/aosarticle/Lo-1986-finite-sampling.pdf10.1016/j.ress.2004.03.005article/Hall-Lawry-2004-approx.pdf10.1109/43.736573article/Xie-Beerel-1998-stateclassif.pdfhttp://www.jstor.org/stable/2332350"
        "article/Haldane-1948.pdfhttp://www.math.technion.ac.il/sat/papers/1article/Pinkus-2005-approx.pdfhttp://www.jstor.org/stable/2239146article/Dempster-1967.pdf10.1038/415530aarticle/VantVeer-etal-2002.pdf10.1016/S0165-0114(99)00082-2article/Jamison-Lodwick-2001.pdf"
        "http://www.jstor.org/stable/3689177article/Steuer-1981.pdfhttp://books.google.com/books?id=MuEFJR7Ek4EC10.1016/j.ejor.2005.08.016article/Haddad-Moreaux-2007.pdf10.1016/S0167-7152(97)00060-6article/Boratynska-1997.pdfhttp://repository.cmu.edu/statistics/29article/Schervish-Seidenfeld-Kadane-2002-incoherence.pdf"
        "http://www.jstor.org/stable/232272510.2307/2322725article/Roy-1987.pdf10.1214/aosarticle/Seidenfeld-Wasserman-1993.pdf10.1007/BF02888345article/Giron-Rios-1980.pdfhttp://www.ams.org/proc/1990-109-02/S0002-9939-1990-0948156-X/S0002-9939-1990-0\n948156-X.pdfarticle/Sine-1990-Perron-Frobenius.pdf"
        "http://www.jstor.org/stable/188357article/Skyrms-1993.pdf10.1016/0165-1889(94)00819-4article/Fudenberg-Levine-1995.pdfhttp://www.numdam.org/item?id=AIHP_1937__7_1_1_0article/DeFinetti-1937.pdf10.1080/02331889308802432article/Arnold-Castillo-Sarabia-1993.pdf"
        "http://www.jstor.org/stable/2025732article/Levi-1977.pdfhttp://www.jstor.org/stable/2333468article/Mosimann-1962.pdfhttp://www.jstor.org/stable/2242823article/Diaconis-Freedman-1982-exchangeability.pdf10.1016/0167-7152(93)90066-Rarticle/Coolen-1993.pdfhttp://www.sciencedirect.com/science/article/pii/S0888613X0600096X"
        "10.1016/j.ijar.2006.07.013article/Campos-Cozman-2007-epistemic.pdf10.1016/j.ijar.2005.12.001article/Kreinovich-Xiang-Ferson-2006.pdf10.1016/j.fss.2007.04.004article/Inuiguchi-2007.pdfhttp://hdl.handle.net/2115/30499article/Tanaka-1993.pdf10.1016/j.ijar.2008.03.010"
        "article/DeCooman-Miranda-Quaeghebeur-2009-RIP.pdfhttp://www.stanford.edu/~boyd/cvxbook10.1007/BF01753431article/Shapley-1971.pdfhttp://www.numdam.org/item?id=AIHP_1948__10_4_215_0article/Frechet-1948.pdf10.1016/j.ijar.2007.12.001article/Miranda-2008-survey.pdf"
        "10.1007/978-1-4020-8202-310.1017/S0269964809990039http://www.gutenberg.org/ebooks/32625article/Moslehian-2006.pdfhttp://www.jstor.org/stable/2988546article/Walley-Gurrin-Burton-1996.pdf10.1016/S0888-613X(02)00087-7article/Miranda-DeCooman-2003.pdf10.1093/bjps"
        "article/Dawid-1985-symmetry.pdfhttp://www.jstor.org/stable/2290650article/Consonni-Veronese-1992.pdf10.1016/S0378-3758(01)00281-6article/GutierrezPena-Rueda-2003.pdfarticle/Bernard-1997-specificity.pdf10.1007/PL00012529article/Kubis-2002.pdf10.1016/j.ijar.2004.10.007"
        "article/Pelessoni-Vicig-2005-convex.pdf10.1007/BF0256267610.1126/science.1115327article/Hsu-et-al-2005.pdfhttp://www.jstor.org/stable/2984087article/Good-1952.pdf10.1016/S0020-0255(99)00007-9article/DeCooman-Aeyels-1999.pdf10.1038/nrg1272article/Barabasi-Oltvai-2004.pdf"
        "10.1214/088342304000000026article/Jordan-2004-graphical.pdf10.1016/j.jmaa.2008.05.071article/DeCooman-Troffaes-Miranda-2008-exact.pdfhttp://www.ifor.math.ethz.ch/~fukuda/polyfaq/polyfaq.htmlhttp://www.jstor.org/stable/1967495article/Daniell-1918.pdfhttp://books.google.com/books?id=79wZAQAAIAAJ"
        "10.1214/aosarticle/Seidenfeld-Schervish-Kadane-1995-preference.pdf10.1371/journal.pgen.1001290article/Kaplan-etal-2011.pdf10.1214/aosarticle/Efron-1978-expfam.pdf10.1111/1467-9469.00243article/Consonni-Veronese-2001.pdf10.1007/s10700-005-3663-4article/Lodwick-Bachman-2005.pdf"
        "http://portal.acm.org/citation.cfm?doid=103162.10316310.1145/103162.103163article/Goldberg-1991-float.pdfhttp://www.jstor.org/stable/2372648article/Davis-1954.pdfarticle/Grabisch-1995.pdfhttp://www.jstor.org/stable/1427899article/Hartfiel-Seneta-1994.pdf10.1016/j.ijar.2008.07.003"
        "article/Destercke-etal-2008-unifying1.pdfhttp://fma2.math.uni-magdeburg.de/~henk/preprints/henkrichter-gebert ziegler&basic properties of convex polytopes.pdfhttp://www.jstor.org/stable/2025161article/Levi-1974.pdf10.1016/j.laa.2005.08.024article/Huang-Huang-Tsai-2006-Hilbert-metric.pdf"
        "http://hdl.handle.net/1854/LU-470245mastersthesis/Dhaenens-2007.pdf10.1214/009053606000000740article/Nau-2006-shape.pdf10.1016/j.ijar.2007.07.007article/Miranda-DeCooman-Quaeghebeur-2007-finitely.pdfhttp://www.ifor.math.ethz.ch/~fukuda/cdd_home10.1007/3-540-61576-8_77"
        "10.1023/A:1018985914065article/Mraz-1998.pdf10.1093/bioinformaticsarticle/Aach-Church-2001.pdfhttp://repub.eur.nl/res/pub/8510.1016/j.ress.2004.03.007article/DeCooman-Troffaes-2004.pdfhttp://www.numdam.org/item?id=AIF_1954__5__131_010.5802/aif.53article/Choquet-1954.pdf"
        "10.1214/aoparticle/Hartman-Watson-1974.pdf10.1112/blmsarticle/Grunbaum-Shepard-1969.pdfhttp://equaeghe.github.com/murasyphttp://www.cs.uu.nl/dazzle10.1145/1088348.108835110.1023/A:1016398407857inbook/deFinetti-1937-foresight.pdf10.1080/15598608.2009.10411920"
        "article/DeCampos-etal-2009.pdfarticle/DeFinetti-Jacob-1935.pdf10.1080/15598608.2009.10411908article/Hampel-2009.pdf10.1080/15598608.2009.10411909article/Kozine-Krymsky-2009.pdf10.1080/15598608.2009.10411923article/Stoye-2009.pdf10.1080/15598608.2009.10411907"
        "article/CoolenSchrijner-etal-2009.pdf10.1080/15598608.2009.10411913article/Pelessoni-Vicig-2009.pdf10.1080/15598608.2009.10411910article/Bose-2009-imposition.pdf10.1080/15598608.2009.10411921article/Wilson-Huzurbazar-Sentz-2009.pdfhttp://www.jstor.org/stable/687386"
        "10.1093/bjpsarticle/deFinetti-1981-BJPS.pdf10.1080/15598608.2009.10411922article/Fuchs-Neumaier-2009.pdf10.1080/15598608.2009.10411924article/Walter-Augustin-2009.pdf10.1080/15598608.2009.10411917article/Danielson-Ekenberg-Riabacke-2009.pdf10.1080/15598608.2009.10411915"
        "article/Strobl-Augustin-2009.pdf10.1080/15598608.2009.10411912article/Montgomery-Coolen-Hart-2009.pdf10.1080/15598608.2009.10411916article/Farrow-Goldstein-2009.pdf10.1080/15598608.2009.10411919article/Bickis-2009.pdf10.1007/BFb0086576inbook/Schempp-1977-Bernstein.pdf"
        "10.1080/15598608.2009.10411914article/Crossman-CoolenSchrijner-Coolen-2009.pdf10.1080/15598608.2009.10411918article/Smithson-Segale-2009.pdf10.1080/15598608.2009.10411925article/CoolenSchrijner-Maturi-Coolen-2009.pdf10.1080/15598608.2009.10411911article/Bose-2009-smoothness.pdf"
        "10.1016/j.artint.2008.04.00110.1016/j.ijar.2004.05.00910.1016/S0004-3702(02)00247-310.1016/0004-3702(90)90026-V10.3168/jds.2009-302010.1613/jair.337410.1016/S0933-3657(02)00012-X10.1109/21.384252http://www.bnatwork.orghttp://www.siks.nlhttp://www.auai.orghttp://www.eccai.org"
        "http://www.sipta.org10.1016/j.ijar.2005.10.00310.1007/978-3-642-03070-3_5910.1007/3-540-60112-0_14inbook/Chateauneuf-Jaffray-1995.pdfhttp://www.jstor.org/stable/262747610.1287/mnsc.6.1.73article/Charnes-Cooper-1959.pdfhttp://www.jstor.org/stable/262715910.1287/mnsc.1.3-4.197"
        "article/Dantzig-1955.pdf10.1016/0022-247X(75)90189-410.1007/BF0158011110.1007/b97283book/Dantzig-Thapa-2003.pdfhttp://bugseng.com/products/ppl/documentation/BagnaraRZH02.pdf10.1007/3-540-45789-5_17inproceedings/Bagnara-etal-2002.pdf");
static const char *bug19362file15701databaseLastAuthors("AbeAbeAlazzawiArakiArakiArakiArakiArakiArakiArakiArnoldArvesonArzanoAudretschBagarelloBahnsBahnsBalachandranBaumannBaumg\u00e4rtnerBerkowitzBernardBertrandBieliavskyBieliavskyBischoffBoasBollerBollerBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchers"
        "BorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBorchersBostelmannBostelmannBrandenbergerBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholzBuchholz"
        "BuchholzBuchholzBuchholzBuchholzBuchholzBuchholzB\u00f6ckenhauerCamassaCamassaCarpiCarpiCasiniCastro-AlvaredoChandrasekharChiconeClaessensClarkConnesConnesConnesConwayConwayCornwellCornwellCuntzD'AntoniDamekDappiaggiDavidsonDerezinskiDimockDimockDixmierDonoghue"
        "DoplicherDoplicherDoplicherDoreyDriesslerDriesslerDurenDybalskiDybalskiDybalskiDybalskiEbrahimi-FardEckmannEckmannEllisEllisEmchEmchEngli\u00c5{{{{{{{{{{{{{{{{{{{{\u00a1}}}}}}}}}}}}}}}}}}}}EpsteinEpsteinFaddeevFerrariFewsterFewsterFewsterFewsterFewsterFewsterFewster"
        "FewsterFewsterFidaleoFigueroaFilkFioreFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFleischhackFlorigFlorigFoitFolacciFollandFollandFrancoFredenhagenFredenhagenFredenhagenFredenhagen"
        "FredenhagenFredenhagenFredenhagenFringFr\u00f6hlichFr\u00f6hlichFr\u00f6hlichFr\u00f6hlichFr\u00f6hlichFr\u00f6hlichFr\u00f6hlichGallavottiGarberGarberGarnettGawedzkiGayralGeGerochGerochGerstenhaberGlaserGlaserGlaserGlaserGlimmGracia-BondiaGrosseGrundlingGrundlingGuichardetHaagHaagHaag"
        "HaagHaagHaagHalvorsonHauerHauerHegerfeldtHegerfeldtHelgasonHellerHeppHeppHerbstHertelHeuserHeuserHighamHillierHofmannHofmannHogeHollandsHollandsHollandsHollandsHollandsHollandsHuHurdH\u00f6lzlerH\u00f6rmanderH\u00f6rmanderH\u00f6rmanderH\u00f6rmanderH\u00f6rmanderH\u00f6rmanderIagolnitzer"
        "IagolnitzerIagolnitzerIagolnitzerInamiIshamIshamJacksonJacobiJaffeJaffeJaffeJaffeJaffeJarchowJohnsonJosephJosephJostJostJunglasJunglasJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4kelJ\u00e4nichJ\u00e4nichJ\u00e4nichJ\u00f6r\u00dfJ\u00f6r\u00dfJ\u00f6r\u00dfKadisonKaiblingerKarowski"
        "KarowskiKarowskiKarowskiKaschekKasprzakKasprzakKastlerKastlerKatoKauffmanKawahigashiKawahigashiKayKayKayKayKeeganKellerKeylKeylKirillovKishimotoKleinKniemeyerKnightKopperKosterKrantzKrantzKreimerKuckertKuckertKulishKunhardtK\u00f6hlerK\u00f6theK\u00f6theLachi\u00e8ze-ReyLance"
        "LandauLandauLandiLandsmanLangLangmannLarkinLashkevichLauridsen-RibeiroLechnerLechnerLechnerLechnerLechnerLechnerLechnerLechnerLechnerLechnerLehmannLesniewskiLesterLewandowskiLewkeeratiyutkulLichtLichtLledoLledoLled\u00f3Lled\u00f3LongoLongoLongoLongoLongoLongoLongo"
        "LongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLongoLorenzenLorenzenL\u00fcckeMackMackMaedaMaisonManchakMandelstamMandulaMartinMartinettiMasielloMassarMehenMeinrenkenMeistersMerkliMichelMichorMillingtoMintchevMintchevMorettiMorfa-Morales"
        "Morfa-MoralesMorfa-MoralesMorsellaMorsellaMorsellaMorsellaMoschellaMoschellaMoschellaMoschellaMotovilovMundMundMundMundMundMundMundMundMussardoM\u00fcgerM\u00fcgerM\u00fcgerM\u00fcgerNachbinNekrasovNelsonNestNestNewmanNiedermaierNowakNowakO'NeillOecklOecklOjimaOkolowOlafsson"
        "OlbermannOliveOsterwalderOsterwalderPaschkePaschkePascualPascualPedersenPfenningPf\u00e4fflePiacitelliPiacitelliPiacitelliPiacitelliPiacitelliPiacitelliPiacitelliPiacitelliPinamontiPinamontiPinamontiPinamontiPinamontiPizzoPohlmeyerPolitoPolkinghornePorrmannPorrmann"
        "PorrmannQuellaQureshiRadulescuRadzikowskiRadzikowskiRainerRamacherRaschhoferRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRehrenRennieRennieRieffelRieffelRieffelRieffelRieffelRieffelRieffel"
        "RieffelRieffelRingroseRingroseRingroseRitzRivasseauRivasseauRivasseauRivasseauRivasseauRivasseauRobertsRobertsRobertsRobertsRobertsRobertsRobertsRobertsRobertsRobertsRobertsRobinsonRobinsonRobinsonRobinsonRobinsonRobinsonRoepstorffRoosRossiRossiRotheRudinRudin"
        "RudinRuelleRuelleRuelleSaffarySahlmannSahlmannSahlmannSakaiSakaiSaleurSalvittiSandersSandersSandersSandersSandhasScharfSchenkelSchiffSchlemmerSchlemmerSchliederSchlingemannSchlingemannSchlingemannSchm\u00fcdgenSchomerusSchomerusSchomerusSchraderSchraderSchrader"
        "SchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchroerSchumannSchwartzSchweigertSchweitzer"
        "SchwingerSeilerSeilerSeilerSeilerSenSenSiboldSiboldSiboldSimonSimonSimonSimonSimonSimonettiSj\u00f6strandSmirnovSmirnovSmolinSolovievSolovievSpindelSpindelSteinackerSteinackerSteinmannSteinmannSternheimerSternheimerStichelStolerStraussStreaterStreaterStrichStrocchi"
        "StrohmaierStrohmaierSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSummersSunderSvegstrupSwiecaSwiecaSwiecaSymanzikSzaboSzaboSzaboSzaboSzaboS\u00e1nchezS\u00e1nchez"
        "S\u00e9n\u00e9chalTakesakiTakesakiTakesakiTanasaTanimotoTanimotoTanimotoTanimotoTanimotoTateoTaylorTeoTeotonio-SobrinhoTeotonio-SobrinhoTeschlTeschnerTestardTestardTestardThallerThiemannThiemannThiemannThiemannThiemannThiemannThirringThirringThirringThrelfallTitchmarsh"
        "TitchmarshTodorovTodorovTodorovTodorovTodorov.TomassiniTongTrevesTruongTruongTruongTruongTruongTureanuTureanuTureanuTureanuTureanuTuynmanUhlmannUhlmannUllrichUllrichVaidyaVaidyaVaidyaVaidyaVaidyaVaidyaVaradarajanVarillyVarillyVarillyVarillyVasselliVassilevich"
        "Vazquez-MozoVerbeureVerbeureVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVerchVernovVernovVernovVernovVernovVignes-TourneretVignes-TourneretVilenkinVitaleVoelkelVoganWaldWaldWaldWaldWaldmannWaldmannWaldmannWaldmannWaldmannWaldmannWaldmann"
        "WaldmannWaldmannWaldmannWaldmannWaldmannWallWallWallWalletWangWanzenbergWassermannWeaverWeinerWeinerWeinerWeissWeiszWeiszWeiszWeiszWeiszWernerWernerWernerWessWessWessWessWhiteWichmannWichmannWichmannWichmannWichmannWichmannWichmannWiesbrockWiesbrockWiesbrock"
        "WiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWiesbrockWightmanWignerWilanskyWildeWilliamsWinninkWittenWittenWittenWohlgenanntWohlgenanntWollenbergWollenbergWollenbergWollenbergWollenberg"
        "WollenbergWoodardWoodsWoronowiczWoronowiczWoronowiczWoronowiczWoronowiczWuWuWulkenhaarWulkenhaarWulkenhaarWulkenhaarWyssWyssXiaYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvasonYngvason"
        "YngvasonYngvasonZahabiZahnZahnZahnZakharovZamolodchikovZamolodchikovZamolodchikovZhangZhouZimmermannZinovievZsidoZsidode Goursact'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft t'Hooft"
        "van Suijlekomvan der Kallenvon Neumann\u00c5ks");
static const char *bug19362file15701databaseFilesUrlsDois("http://projecteuclid.org/euclid.cmp/1103757611http://projecteuclid.org/euclid.cmp/11038418191969 - Borchers - On the Implementability of Automorphism Groups.pdfhttp://projecteuclid.org/euclid.cmp/11038416271969 - Epstein, Glaser, Martin - Polynomial behaviour of scattering amplitudes at fixed momentum transfer in theories with local observables.pdf"
        "http://projecteuclid.org/euclid.cmp/11038574091971 - Glimm, Jaffe - The energy momentum spectrum and vacuum expectation values in quantum field theory II.pdfhttp://projecteuclid.org/euclid.cmp/11038584081972 - Borchers, Hegerfeldt - The Structure of Space-Time Transformations.pdf"
        "1972 - Woronowicz - On the Purification of Factor States.pdf1974 - Buchholz - Collision theory for massless Fermions.pdf1974 - Buchholz - Haag-Ruelle approximation of collision states.pdf1974 - Buchholz - Product states for local algebras.pdf1974 - Fannes, Verbeure - On the time evolution automorphisms of the CCR-algebra for quantum mechanics.pdf"
        "1975 - Borchers, Sen - Relativity groups in the presence of matter.pdf1975 - Borchers, Yngvason - Integral representations for Schwinger functionals and the moment problem over nuclear spaces.pdf1975 - Borchers, Yngvason - On the algebra of field operators. The weak commutant and integral decompositions of states.pdf"
        "1975 - Driessler - Comments on lightlike translations and applications in relativistic quantum field theory.pdf1976 - Borchers, Yngvason - Necessary and sufficient conditions for integral representations of Wightman functionals at Schwinger points.pdf1976 - Buchholz, Roberts - Bounded perturbations of dynamics.pdf"
        "1977 - Buchholz - Collision theory for massless bosons.pdf1977 - Buchholz, Fredenhagen - A note on the inverse scattering problem in quantum field theory.pdf1978 - Iagolnitzer - Factorization of the multiparticle S-matrix in two-dimensional space-time models.pdf"
        "1978 - Pusz, Woronowicz - Passive States and KMS States for General Quantum Systems.pdf1978 - Shankar, Witten - S-matrix of the supersymmetric nonlinear sigma model.pdf1979 - Longo - Notes on algebraic invariants for noncommutative dynamical systems.pdf1981 - Epstein, Glaser, Iagolnitzer - SOME ANALYTICITY PROPERTIES ARISING FROM ASYMPTOTIC COMPLETENESS IN QUANTUM FIELD THEORY.pdf"
        "1981 - Emch - Prequantization and KMS structures.pdf1982 - Buchholz - THE PHYSICAL STATE SPACE OF QUANTUM ELECTRODYNAMICS.pdf1982 - Hislop, Longo - Modular structure of the local algebras associated with the free massless scalar field theory.pdf1982 - Steinmann - A JOST-SCHROER THEOREM FOR STRING FIELDS.pdf"
        "1983 - Doplicher, Longo - LOCAL ASPECTS OF SUPERSELECTION RULES. II.pdf1983 - Wichmann - ON SYSTEMS OF LOCAL OPERATORS AND THE DUALITY CONDITION.pdf1984 - Baumg\\\"artel, Wollenberg - A class of nontrivial weakly local massive Wightman fields with interpolating properties.pdf"
        "1984 - Borchers - Translation Group and Spectrum Condition.pdf1985 - Borchers, Buchholz - The Energy-Momentum Spectrum in Local Field Theories with Broken Lorentz-Symmetry.pdf1985 - Buchholz, Epstein - Spin and Statistics of Quantum Topological Charges.pdf1986 - Buchholz, Junglas - LOCAL PROPERTIES OF EQUILIBRIUM STATES AND THE PARTICLE SPECTRUM IN QUANTUM FIELD THEORY.pdf"
        "10.1007/BF012123411986 - Driessler, Summers, Wichmann - On the connection between quantum fields and von Neumann algebras of local operators.pdf1986 - Pohlmeyer, Rehren - ALGEBRAIC PROPERTIES OF THE INVARIANT CHARGES OF THE NAMBU- GOTO THEORY.pdf1987 - Buchholz, D'Antoni, Fredenhagen - The universal structure of local algebras.pdf"
        "1987 - Buchholz, Jacobi - On the Nuclearity Condition for Massless Fields.pdf1988 - Pohlmeyer, Rehren - THE ALGEBRA FORMED BY THE INVARIANT CHARGES OF THE NAMBU- GOTO THEORY: IDENTIFICATION OF A MAXIMAL ABELIAN SUBALGEBRA.pdf1988 - Pohlmeyer, Rehren - THE INVARIANT CHARGES OF THE NAMBU-GOTO THEORY: THEIR GEOMETRIC ORIGIN AND THEIR COMPLETENESS.pdf"
        "1989 - Buchholz, Junglas - On the existence of equilibrium states in local quantum field theory.pdf1990 - Borchers - Translation group and modular automorphisms for local regions.pdfhttp://projecteuclid.org/euclid.cmp/110418022310.1007/BF021045051990 - Borchers, Yngvason - Positivity of Wightman functionals and the existence of local nets.pdf"
        "1990 - Rehren - SPACE-TIME FIELDS AND EXCHANGE FIELDS.pdf1991 - Borchers, Wollenberg - On the relation between types of local algebras in different global representations.pdf1991 - Kay, Wald - Theorems on the Uniqueness and Thermal Properties of Stationary, Nonsingular, Quasifree States on Space-Times with a Bifurcate Killing Horizon.pdf"
        "http://arxiv.org/abs/hep-th/92020531992 - Ashtekar, Isham - Representations of the holonomy algebras of gravity and non-Abelian gauge theories.pdf1992 - Buchholz, Wanzenberg - The realm of the vacuum.pdf1993 - Kay - Sufficient conditions for quasifree states and an improved uniqueness theorem for quantum fields on space-times with horizons.pdf"
        "1992 - Rehren - Field operators for anyons and plektons.pdf1992 - Thirring - Ergodic Properties in Quantum Systems.pdfhttp://arxiv.org/abs/funct-an/93020081993 - Brunetti, Guido, Longo - Modular Structure and Duality in Conformal Quantum Field Theory.pdf1993 - Buchholz, Doplicher, Longo, Roberts - Extensions of automorphisms and gauge symmetries.pdf"
        "http://arxiv.org/abs/hep-th/93031081993 - Fring, Mussardo, Simonetti - Form Factors of the Elementary Field in the Bullough-Dodd Model.pdfhttp://arxiv.org/abs/hep-th/94030271994 - Buchholz, Yngvason - There are no causality problems for Fermis Two Atom System.pdf"
        "http://arxiv.org/abs/hep-th/03030371994 - Doplicher, Fredenhagen, Roberts - The Quantum Structure of Spacetime at the Planck Scale and Quantum Fields.pdfhttp://arxiv.org/abs/hep-th/94061181994 - Lashkevich - Sectors of mutually local fields in integrable models of quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/93120391994 - Smirnov - A New set of exact form-factors.pdf1994 - Verch - Local definiteness, primarity and quasiequivalence of quasifree Hadamard quantum states in curved spacetime.pdf1995 - Borchers - On the use of modular groups in quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/94030391995 - Liguori, Mintchev - Fock representations of quantum fields with generalized statistics.pdf1995 - Liguori, Mintchev, Rossi - Unitary Group Representations in Fock Spaces with Generalized Exchange Properties.pdf1996 - Florig, Summers - On the statistical independence of algebras of observables.pdf"
        "http://arxiv.org/abs/hep-th/96090201996 - Jorss - From conformal Haag-Kastler nets to Wightman functions.pdf1996 - Rehren - Comments on a recent solution to Wightman's axioms.pdfhttp://arxiv.org/abs/hep-th/94091651995 - Rehren, Stanev, TodorovIvan T - Characterizing invariants for local extensions of current algebras.pdf"
        "http://arxiv.org/abs/hep-th/96080831997 - Schroer - Motivations and physical aims of algebraic QFT.pdf1996 - Schumann - Operator Ideals and the Statistical Independence in Quantum Field Theory.pdf1996 - Yngvason - Tomita Conjugations and Transitivity of Locality.pdf"
        "1997 - Liguori, Mintchev, Rossi - Fock representations of exchange algebras with involution.pdfhttp://arxiv.org/abs/hep-th/97061721997 - Niedermaier - A Derivation of the Cyclic Form Factor Equation.pdfhttp://arxiv.org/abs/hep-th/97110851998 - Rehren - Spin statistics and CPT for solitons.pdf"
        "10.1063/1.5319541997 - Thomas, Wichmann - On the Causal Structure of Minkowski Spacetime.pdfhttp://arxiv.org/abs/math-ph/98050261998 - Buchholz, Dreyer, Florig, Summers - Geometric modular action and spacetime symmetry groups.pdfhttp://arxiv.org/abs/math-ph/0006011"
        "2000 - Florig, Summers - Further representations of the canonical commutation relations.pdfhttp://arxiv.org/abs/hep-th/98122511998 - Schroer, Wiesbrock - Modular constructions of quantum field theories with interactions.pdf1998 - Thomas, Wichmann - Standard Forms of local nets in quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/99091531999 - Babujian, Karowski - The Exact Quantum Sine-Gordon Field Equation and Other Non-Perturbative Results.pdfhttp://arxiv.org/abs/gr-qc/99100602000 - Fewster - A general worldline quantum inequality.pdfhttp://arxiv.org/abs/gr-qc/9812032"
        "1999 - Fewster, Teo - Bounds on negative energy densities in static space-times.pdf1999 - Gaier, Yngvason - Geometric Modular Action, Wedge Duality and Lorentz Covariance are Equivalent for Generalized Free Fields.pdfhttp://arxiv.org/abs/math-ph/990601910.1142/S0129055X01000557"
        "1999 - Guido, Longo, Roberts, Verch - Charged sectors, spin and statistics in quantum field theory on curved spacetimes.pdfhttp://arxiv.org/abs/gr-qc/99120111999 - Rainer - Is loop quantum gravity a QFT?.pdf2000 - Borchers - On Revolutionizing Quantum Field Theory.pdf"
        "http://arxiv.org/abs/hep-th/00110152000 - Buchholz, Doplicher, Morchio, Roberts, Strocchi - Quantum Delocalization of the Electric Charge.pdfhttp://arxiv.org/abs/hep-th/00112372000 - Buchholz, Mund, Summers - Transplantation of Local Nets and Geometric Modular Action on Robertson-Walker Space-Times.pdf"
        "http://arxiv.org/abs/math-ph/00010062000 - Fleischhack - Gauge Orbit Types for Generalized Connections.pdfhttp://arxiv.org/abs/math-ph/00010072000 - Fleischhack - Hyphs and the Ashtekar-Lewandowski measure.pdfhttp://arxiv.org/abs/math-ph/00010082000 - Fleischhack - Stratification of the Generalized Gauge Orbit Space.pdf"
        "http://arxiv.org/abs/hep-th/00030182000 - Oeckl - Untwisting noncommutative R**d and the equivalence of quantum field theories.pdf2000 - Ramacher - Modular localization of elementary systems in the theory of Wigner.pdfhttp://arxiv.org/abs/hep-th/00011292001 - D\\\"utsch, Fedenhagen - Perturbative Algebraic Field Theory, and Deformation Quantization.pdf"
        "http://arxiv.org/abs/hep-th/01060642001 - Fassarella, Schroer - The fuzzy analog of chiral diffeomorphisms in higher dimensional quantum field theories.pdfhttp://arxiv.org/abs/math-ph/010502710.1007/s0022001005842001 - Fewster, Verch - A Quantum weak energy inequality for Dirac fields in curved space-time.pdf"
        "http://arxiv.org/abs/math-ph/01110012001 - Fleischhack, Lewandowski - Breakdown of the action method in gauge theories.pdfhttp://arxiv.org/abs/math-ph/00070012003 - Fleischhack - On the Gribov problem for generalized connections.pdfhttp://arxiv.org/abs/math-ph/0107022"
        "2001 - Fleischhack - On the structure of physical measures in gauge theories.pdfhttp://arxiv.org/abs/math-ph/01090302001 - Fleischhack - On the support of physical measures in gauge theories.pdfhttp://arxiv.org/abs/math-ph/01090012001 - Kunhardt - On Infravacua and the Superselection Structure of Theories with Massless Particles.pdf"
        "http://arxiv.org/abs/hep-th/01012272001 - Mund - The Bisognano Wichmann theorem for massive theories.pdfhttp://arxiv.org/abs/hep-th/01082032001 - Schroer - Lightfront Formalism versus Holography + Chiral Scanning.pdfhttp://arxiv.org/abs/hep-th/01060662001 - Schroer - Uniqueness of Inverse Scattering Problem in Local Quantum Physics.pdf"
        "http://arxiv.org/abs/math-ph/00080432000 - Strohmaier - On the local structure of the Klein-Gordon field on curved spacetimes.pdfhttp://arxiv.org/abs/gr-qc/01100342001 - Thiemann - Introduction to modern canonical quantum general relativity.pdfhttp://arxiv.org/abs/gr-qc/0211012"
        "2002 - Ashtekar, Lewandowski, Sahlmann - Polymer and Fock representations for a Scalar field.pdfhttp://arxiv.org/abs/hep-th/020122210.1016/S0370-2693(02)01563-02002 - Bahns, Doplicher, Fredenhagen, Piacitelli - On the unitarity problem in space-time noncommutative theories.pdf"
        "http://arxiv.org/abs/hep-th/02070572002 - Buchholz, Mund, Summers - Covariant and quasi-covariant quantum dynamics in Robertson-Walker space-times.pdfhttp://arxiv.org/abs/hep-th/02050762003 - Castro-Alvaredo, Fring - From integrability to conductance, impurity systems.pdf"
        "http://arxiv.org/abs/hep-th/01121682002 - Fassarella, Schroer - Wigner Particle Theory and Local Quantum Physics.pdf2003 - Fleischhack - Regular connections among generalized connections.pdfhttp://arxiv.org/abs/gr-qc/02071112002 - Sahlmann - Some comments on the representation theory of the algebra underlying loop quantum gravity.pdf"
        "http://arxiv.org/abs/gr-qc/02100942003 - Thiemann - Lectures on loop quantum gravity.pdfhttp://arxiv.org/abs/hep-th/03050932003 - Alvarez-Gaume, Vazquez-Mozo - General Properties of Noncommutative Field Theories.pdfhttp://arxiv.org/abs/hep-th/03010882003 - Babujian, Karowski - Towards the Construction of Wightman Functions of Integrable Quantum Field Theories.pdf"
        "http://arxiv.org/abs/hep-th/02090082003 - Chaichian, Nishijima, Tureanu - Spin-Statistics and CPT Theorems in Noncommutative Field Theory.pdfhttp://arxiv.org/abs/math-ph/03040012003 - Fleischhack - Parallel Transports in Webs.pdfhttp://arxiv.org/abs/math-ph/0304002"
        "2004 - Fleischhack - Proof of a Conjecture by Lewandowski and Thiemann.pdfhttp://arxiv.org/abs/hep-th/98032452004 - J\\\"akel -%20 The Relation between KMS states for different temperatures.pdfhttp://arxiv.org/abs/quant-ph/03021152003 - Redei, Summers - Remarks On Causality in Relativistic Quantum Field Theory.pdf"
        "http://arxiv.org/abs/hep-th/04080802003 - Wess - Deformed coordinate spaces: Derivatives.pdfhttp://arxiv.org/abs/math-ph/04090702004 - Bostelmann - Phase space properties and the short distance structure in quantum field theory.pdfhttp://arxiv.org/abs/math-ph/0402072"
        "10.1007/s00023-004-0190-82004 - Buchholz, Lechner - Modular nuclearity and localization.pdfhttp://arxiv.org/abs/hep-th/04022122004 - Chaichian, Mnatsakanova, Nishijima, Tureanu, Vernov - Towards an Axiomatic Formulation of Noncommutative Quantum Field Theory.pdf"
        "http://arxiv.org/abs/gr-qc/04090432004 - Fewster - Comments on 'Counter example to the quantum inequality'.pdfhttp://arxiv.org/abs/gr-qc/04111142004 - Fewster - Quantum energy inequalities in two dimensions.pdfhttp://arxiv.org/abs/math-ph/04050372004 - Kawahigashi, Longo - Noncommutative Spectral Invariants and Black Hole Entropy.pdf"
        "http://arxiv.org/abs/math-ph/040506210.1088/0305-44702005 - Lechner - On the existence of local observables in theories with a factorizing S-Matrix.pdfhttp://arxiv.org/abs/math-ph/040506710.1142/S0129055X040021632004 - Longo, Rehren - Local fields in boundary conformal QFT.pdf"
        "http://arxiv.org/abs/hep-th/04051052005 - Schroer - An anthology of non-local QFT and QFT on noncommutative spacetime.pdf2004 - Ullrich - On the restriction of quantum fields to a lightlike surface.pdfhttp://arxiv.org/abs/math-ph/04110582004 - Yngvason - The role of type III factors in quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/04082042005 - Bahns, Doplicher, Fredenhagen, Piacitelli - Field Theory on Noncommutative Spacetimes - Quasiplanar Wick Products.pdfhttp://arxiv.org/abs/hep-th/05080022005 - Balachandran, Mangano, Pinzul, Vaidya - Spin and Statistics on the Groenewold-Moyal Plane - Pauli-Forbidden Levels and Transitions.pdf"
        "http://arxiv.org/abs/math-ph/05090472005 - Buchholz, Summers - Scattering in Relativistic Quantum Field Theory - Fundamental Concepts and Tools.pdfhttp://arxiv.org/abs/math-ph/04120282005 - Fewster, Hollands - Quantum energy inequalities in two-dimensional conformal field theory.pdf"
        "http://arxiv.org/abs/hep-th/04011282005 - Grosse, Wulkenhaar - Renormalisation of phi**4 theory on noncommutative R**4 in the matrix base.pdfhttp://arxiv.org/abs/hep-th/05021842005 - Lechner - Towards the construction of quantum field theories from a factorizing S-matrix.pdf"
        "http://arxiv.org/abs/hep-th/04030332005 - Mnatsakanova, Vernov - Jost-Lehmann-Dyson representation, analyticity in angle variable and upper bounds in noncommutative quantum field theory.pdfhttp://arxiv.org/abs/math-ph/051104210.1007/s00220-006-0067-42005 - Mund, Schroer, Yngvason - String-localized quantum fields and modular localization.pdf"
        "http://arxiv.org/abs/math-ph/05120462005 - Saffary - Modular action on the massive algebra.pdfhttp://arxiv.org/abs/hep-th/05071072007 - Salvitti - Generalized particle statistics in two-dimensions: Examples from the theory of free massive Dirac field.pdfhttp://arxiv.org/abs/hep-th/0406016"
        "2005 - Schroer - Constructive proposals for QFT based on the crossing property and on lightfront holography.pdfhttp://arxiv.org/abs/math/06077452006 - Bahns, Waldmann - Locally Noncommutative Space-Times.pdfhttp://arxiv.org/abs/hep-th/06081792006 - Balachandran, Govindarajan, Mangano, Pinzul, Qureshi, Vaidya - Statistics and UV-IR Mixing with Twisted Poincare Invariance.pdf"
        "http://arxiv.org/abs/hep-th/06081382006 - Balachandran, Pinzul, Qureshi, Vaidya - Poincare Invariant Gauge and Gravity Theories on the Groenewold-Moyal Plane.pdfhttp://arxiv.org/abs/gr-qc/06081332006 - Buchholz, Schlemmer - Local Temperature in Curved Spacetime.pdf"
        "http://arxiv.org/abs/hep-th/06020932006 - Bytsko, Teschner - Quantization of models with non-compact quantum group symmetry: Modular XXZ magnet and lattice sinh-Gordon model.pdfhttp://arxiv.org/abs/math-ph/06020422006 - Fewster, Pfenning - Quantum energy inequalities and local covariance. I: Globally hyperbolic spacetimes.pdf"
        "http://arxiv.org/abs/math-ph/06010052005 - Fleischhack - Construction of generalized connections.pdfhttp://arxiv.org/abs/math-ph/04070062004 - Fleischhack - Representations of the Weyl algebra in quantum geometry.pdfhttp://arxiv.org/abs/math-ph/06090592006 - J\\\"akel, Wreszinski - Stability and related properties of vacua and ground states.pdf"
        "http://arxiv.org/abs/hep-th/06060562006 - Kulish - Twists of quantum groups and noncommutative field theory.pdfhttp://arxiv.org/abs/gr-qc/05041472005 - Lewandowski, Okolow, Sahlmann - Uniqueness of diffeomorphism invariant states on holonomy- flux algebras.pdf"
        "http://arxiv.org/abs/hep-th/06032312006 - Zahn - Remarks on twisted noncommutative quantum field theory.pdfhttp://arxiv.org/abs/0704.02322007 - Bergbauer, Kreimer - New Algebraic Aspects of Perturbative and Non-Perturbative Quantum Field Theory.pdfhttp://arxiv.org/abs/math-ph/0203021"
        "10.1142/S0129055X020013872002 - Brunetti, Guido, Longo - Modular localization and Wigner particles.pdfhttp://arxiv.org/abs/0705.19882007 - Buchholz, Grundling - The resolvent algebra: A new approach to canonical quantum systems.pdfhttp://arxiv.org/abs/hep-th/9905102"
        "2000 - Buchholz, Longo - Graded KMS Functionals and the Breakdown of Supersymmetry.pdfhttp://arxiv.org/abs/math-ph/06110582006 - Fewster - Quantum energy inequalities and local covariance. II: Categorical formulation.pdfhttp://arxiv.org/abs/0705.1120http://arxiv.org/abs/hep-th/0701078"
        "2007 - Fiore, Wess - On full twisted Poincare' symmetry and QFT on Moyal-Weyl spaces.pdfhttp://arxiv.org/abs/hep-th/97031291998 - Guido, Longo, Wiesbrock - Extensions of Conformal Nets and Superselection Structures.pdfhttp://arxiv.org/abs/0704.3392http://arxiv.org/abs/math-ph/0611050"
        "2006 - Lechner - On the Construction of Quantum Field Theories with Factorizing S-Matrices-PhD-Thesis.pdf2007 - Lorenzen - From Spin Groups and Modular P_1CT Symmetry to Covariant Representations and the Spin-Statistics Theorem.pdfhttp://arxiv.org/abs/0704.2986"
        "http://arxiv.org/abs/hep-th/07020962007 - Schlemmer - Local Thermal Equilibrium States and Unruh Detectors in Quantum Field Theory.pdfhttp://arxiv.org/abs/math/0703336http://arxiv.org/abs/math/04071902005 - Carpi, Weiner - On the uniqueness of diffeomorphism symmetry in conformal field theory.pdf"
        "http://arxiv.org/abs/0705.36092007 - Carpi, Kawahigashi, Longo - Structure and Classification of Superconformal Nets.pdfhttp://arxiv.org/abs/math-ph/06100702007 - Pinamonti - On localization and position operators in Moebius covariant theories.pdfhttp://arxiv.org/abs/0708.1379"
        "http://arxiv.org/abs/0708.1283http://arxiv.org/abs/math-ph/03110522003 - Bros, Moschella - Fourier analysis and holomorphic decomposition on the one- sheeted hyperboloid.pdfhttp://arxiv.org/abs/math-ph/06090802006 - Bertola, Corbetta, Moschella - Massless scalar field in two-dimensional de Sitter universe.pdf"
        "http://arxiv.org/abs/gr-qc/95110191996 - Bros, Moschella - Two-point Functions and Quantum Fields in de Sitter Universe.pdfhttp://arxiv.org/abs/0706.399210.1088/1126-67082007 - Grosse, Lechner - Wedge-Local Quantum Fields and Noncommutative Minkowski Space.pdf"
        "http://scitation.aip.org/getabs/servlet/GetabsServlet?prog=normal&id=JMAPAQ000002000004000459000001&idtype=cvips&gifs=yes10.1063/1.17037311961 - Knight - Strict Localization in Quantum Field Theory.pdfhttp://arxiv.org/abs/hep-ph/92092241993 - Chamseddine, Felder, Frohlich - Grand unification in noncommutative geometry.pdf"
        "http://arxiv.org/abs/math/04115072004 - Fr\\\"ohlich, Fuchs, Runkel - Picard groups in rational conformal field theory.pdfhttp://arxiv.org/abs/hep-th/02081952003 - Mund - Modular localization of massive particles with any spin in.pdfhttp://arxiv.org/abs/hep-th/9712119"
        "1997 - Mund - No-Go Theorem for Free Relativistic Anyons in d=2+1.pdfhttp://arxiv.org/abs/hep-th/05020142005 - Mund - String-localized covariant quantum fields.pdf10.2307/19685511939 - Wigner - On unitary representations of the inhomogeneous Lorentz group.pdf"
        "http://arxiv.org/abs/0708.17792007 - Balachandran, Pinzul, Qureshi - Twisted Poincar'e Invariant Quantum Field Theories.pdfhttp://arxiv.org/abs/0708.2426http://arxiv.org/abs/0705.3340http://arxiv.org/abs/gr-qc/06050722007 - Hollands - The operator product expansion for perturbative quantum field theory in curved spacetime.pdf"
        "http://arxiv.org/abs/gr-qc/02120282004 - Hollands - A general PCT theorem for the operator product expansion in curved spacetime.pdfhttp://arxiv.org/abs/math-ph/07030132006 - Gerard, J\\\"akel - On the relativistic KMS condition for the P(phi)(2) model.pdfhttp://arxiv.org/abs/math-ph/0609088"
        "2005 - Gerard, J\\\"akel - Thermal quantum fields without cut-offs in 1+1 space-time dimensions.pdfhttp://arxiv.org/abs/math-ph/03070532003 - Gerard, J\\\"akel - Thermal quantum fields with spatially cut-off interactions in 1+1 space-time dimensions.pdfhttp://arxiv.org/abs/math-ph/0507047"
        "2006 - Jaffe, J\\\"akel - An exchange identity for non-linear fields.pdfhttp://arxiv.org/abs/0709.101010.1016/0003-4916(79)90391-91979 - Zamolodchikov, Zamolodchikov - Factorized S-matrices in two dimensions as the exact solutions of certain relativistic quantum field theory models.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Glimm, Jaffe - Quantum Physics - A Functional Integral Point of View.djvu10.1007/BF020990111992 - Borchers - The CPT-theorem in two-dimensional theories of local observables.pdfhttp://arxiv.org/abs/math-ph/98090031998 - Schroer, Wiesbrock - Modular Theory and Geometry.pdf"
        "1997 - Wiesbrock - Symmetries and Modular Intersections of Von Neumann Algebras.pdf1998 - Wiesbrock - Modular Intersections of von Neumann Algebras in Quantum Field Theory.pdf1994 - Wiesbrock - A note on strongly additive conformal field theory and half-sided modular conormal standard inclusions.pdf"
        "1993 - Wiesbrock - Conformal quantum field theory and half-sided modular inclusions of von Neumann algebras.pdf1993 - Wiesbrock - Half-sided modular inclusions of von-Neumann-algebras.pdf1992 - Wiesbrock - A comment on a recent work of Borchers.pdfhttp://arxiv.org/abs/hep-th/0003243"
        "10.1007/s0022001004112000 - Borchers, Buchholz, Schroer - Polarization-free generators and the S-matrix.pdfhttp://projecteuclid.org/euclid.cmp/11038425351970 - Yngvason - Zero-mass infinite spin representations of the Poincare group and quantum field theory.pdf"
        "1990 - Buchholz, D'Antoni, Longo - Nuclear maps and modular structures. II. Applications to quantum field theory.pdf1990 - Buchholz, D'Antoni, Longo - Nuclear maps and modular structures 1 - general properties.pdfhttp://www.arxiv.org/abs/math-ph/040701110.1063/1.1804230"
        "2004 - Buchholz, Summers - Stable quantum systems in anti-de Sitter space: Causality, independence and spectral properties.pdfhttp://arxiv.org/abs/0705.07052007 - Rivasseau - Non-commutative renormalization.pdf10.1063/1.17043051965 - Aks - Proof that Scattering Implies Production in Quantum Field Theory.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Araki - Mathematical Theory of Quantum Fields.djvuhttp://arxiv.org/abs/hep-th/04080692004 - Chaichian, Kulish, Nishijima - On a Lorentz-invariant interpretation of noncommutative space-time and its implications on noncommutative QFT.pdf"
        "http://arxiv.org/abs/hep-th/01060482001 - Douglas, Nekrasov - Noncommutative field theory.pdfhttp://arxiv.org/abs/math-ph/051206010.1088/1751-81132007 - Buchholz, Summers - String- and Brane-Localized Causal Fields in a Strongly Nonlocal Model.pdf1979 - Grosse - On the construction of m\\\"oller operators for the nonlinear schr\\\"odinger equation.pdf"
        "10.1007/BF016464941965 - Hepp - On the connection between the LSZ and Wightman quantum field theory.pdfhttp://arxiv.org/abs/math-ph/05120682007 - Kuckert, Lorenzen - Spin, statistics, and reflections. II: Lorentz invariance.pdfhttp://arxiv.org/abs/hep-th/0303062"
        "10.1023/A:10257723048042003 - Lechner - Polarization-Free Quantum Fields and Interaction.pdfhttp://arxiv.org/abs/math-ph/060102210.1007/s00220-007-0381-52007 - Lechner - Construction of Quantum Field Theories with Factorizing S-matrices.pdfhttp://arxiv.org/abs/hep-th/9702145v1"
        "1997 - Schroer - Modular Localization and the Bootstrap-Formfactor Program.pdfhttp://arxiv.org/abs/hep-th/99081421999 - Seiberg, Witten - String theory and noncommutative geometry.pdfhttp://arxiv.org/abs/hep-th/01091622003 - Szabo - Quantum field theory on noncommutative spaces.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Streater R.F., Wightman A.S. PCT, spin and statistics and all that (Benjamin, 1964)(T)(189s)_PQft_.djvuhttp://arxiv.org/abs/0704.00972007 - Kawahigashi - Conformal Field Theory and Operator Algebras.pdfhttp://arxiv.org/abs/math-ph/0602036"
        "2006 - Halvorson, M\\\"uger - Algebraic Quantum Field Theory.pdfhttp://arxiv.org/abs/math/02111412002 - Kawahigashi - Classification of operator algebraic conformal field theories.pdfhttp://arxiv.org/abs/hep-th/94120941996 - Davidson - Endomorphism semigroups and lightlike translations.pdf"
        "http://arxiv.org/abs/math-ph/06100272007 - Svegstrup - Endomorphisms on Half-Sided Modular Inclusions.pdf1993 - Wiesbrock - Symmetries and half-sided modular inclusions of von Neumann algebras.pdfhttp://arxiv.org/abs/hep-th/01051782001 - Babujian, Karowski - Exact form factors in integrable quantum field theories: the sine-Gordon model (II).pdf"
        "http://arxiv.org/abs/hep-th/06091302006 - Babujian, Foerster, Karowski - The Form Factor Program: a Review and New Results - the Nested SU(N) Off-Shell Bethe Ansatz.pdfhttp://arxiv.org/abs/hep-th/03011002003 - Bahns, Doplicher, Fredenhagen, Piacitelli - Ultraviolet Finite Quantum Field Theory on Quantum Spacetime.pdf"
        "http://arxiv.org/abs/hep-th/06080812007 - Balachandran, Queiroz, Marques, Teotonio-Sobrinho - Deformed Kac-Moody and Virasoro Algebras.pdfhttp://arxiv.org/abs/0706.00212007 - Balachandran, Queiroz, Marques, Teotonio-Sobrinho - Quantum Fields with Noncommutative Target Spaces.pdf"
        "1976 - Bisognano, Wichmann - On the Duality Condition for Quantum Fields.pdf1974 - Bisognano, Wichmann - On the Duality Condition for a Hermitian Quantum Field.pdfhttp://arxiv.org/abs/0710.10831999 - Borchers - On the embedding of von Neumann subalgebras.pdf"
        "http://www.springerlink.com/content/un027304k4m253q7/?p=1a14bec3579d46e3a219897d6845164b&pi=51997 - Borchers - On the Lattice of Subalgebras Associated with the Principle of Half-sided Modular Inclusion.pdfhttp://www.springerlink.com/content/pn7wp853n1666537/?p=98c19fdbd87648f79f623d3d44e9bf70&pi=8"
        "1996 - Borchers - Half-sided modular inclusion and the construction of the Poincare group.pdf2005 - Araki, Zsido - Extension of the structure theorem of Borchers and its application to half-sided modular inclusions.pdfhttp://arxiv.org/abs/0709.24931993 - Fr\\\"ohlich, Gabbiani - Operator algebras and conformal field theory.pdf"
        "1999 - J\\\"akel - Two algebraic properties of thermal quantum field theories.pdf1963 - Araki - A Lattice of Von Neumann Algebras Associated with the Quantum Theory of a Free Bose Field.pdf1963 - Licht - Strict Localization.pdf1964 - Araki - Von Neumann Algebras of Local Observables for Free Scalar Field.pdf"
        "1965 - Borchers - Local rings and the connection of spin with statistics.pdf1965 - Borchers - On the structure of the algebra of field operators. II.pdf1965 - Borchers - On the vacuum state in quantum field theory II.pdf1965 - Bros, Epstein, Glaser - A proof of the crossing property for two-particle amplitudes in general quantum field theory.pdf"
        "2002 - Birke, Fr\\\"ohlich - KMS, etc.pdf1965 - Haag, Swieca - When does a quantum field theory describe particles.pdf1965 - Jaffe - Divergence of perturbation theory for bosons.pdf1965 - Kastler - The Cstar-algebras of a free Boson field. I. Discussion of the basic facts.pdf"
        "1965 - Langerholc, Schroer - On the structure of the von Neumann algebras generated by local functions of the free Bose field.pdf1965 - Robinson - A theorem concerning the positive metric.pdf1965 - Robinson - The ground state of the Bose gas.pdf1965 - Schlieder - Some remarks about the localization of states in a quantum field theory.pdf"
        "1966 - Borchers - Energy and momentum as observables in quantum field theory.pdf1966 - Dell'Antonio, Doplicher, Ruelle - A theorem on canonical commutation and anticommutation relations.pdf1966 - Doplicher, Kastler, Robinson - Covariance algebras in field theory and statistical mechanics.pdf"
        "1966 - Kadison, Ringrose - Derivations and automorphisms of operator algebras.pdf1966 - Kastler, Robinson, Swieca - Conserved currents and associated symmetries Goldstone's theorem.pdf1966 - Kupsch, Sandhas - Moeller operators for scattering on singular potentials.pdf"
        "1966 - Lehmann - Analytic properties of scattering amplitudes in two variables in general quantum field theory.pdf1966 - Licht - Local States.pdf1966 - Schroer, Stichel - Current commutation relations in the framework of general quantum field theory.pdf1966 - Streater - Canonical quantization.pdf"
        "1967 - Araki, Haag - Collision cross sections in terms of local observables.pdf1967 - Borchers - A remark on a theorem of B. Misra.pdf1967 - Bros, Epstein, Glaser - On the connection between analyticity and Lorentz covariance of Wightman functions.pdf1967 - Ezawa, Swieca - Spontaneous breakdown of symmetries and zero-mass states.pdf"
        "1967 - Glimm - Yukawa coupling of quantum fields in two dimensions. I.pdf1967 - Haag, Hugenholtz, Winnink - On the equilibrium states in quantum statistical mechanics.pdf1967 - Kadison - The energy momentum spectrum of quantum fields.pdf1968 - Borchers - On the converse of the Reeh-Schlieder theorem.pdf"
        "1968 - Borchers, Pohlmeyer - Eine scheinbare Abschw\\\"achung der Lokalit\\\"atsbedingung II.pdf1968 - Manuceau, Verbeure - Quasi-free states of the CCR-algebra and Bogoliubov transformations.pdf1970 - Steinmann - Scattering formalism for non-localizable fields.pdf"
        "1971 - Glimm, Jaffe - Positivity and self adjointness of the P(phi)_2 Hamiltonian.pdf1973 - Osterwalder, Schrader - Axioms for Euclidean Green's functions.pdf1973 - Woronowicz - On the Purification Map.pdf1974 - Buchholz - Threshold singularities of the S-matrix and convergence of Haag-Ruelle approximations.pdf"
        "1974 - Connes - Caract\\'erisation des espaces vectoriels ordonn\\'es sous-jacents aux alg\\`ebres de von Neumann.pdf1975 - Buchholz - Collision theory for waves in two dimensions and a characterization of models with trivial S-matrix.pdf1975 - Fr\\\"ohlich - Quantized Sine-Gordon Equation with a Nonvanishing Mass Term in Two Space-Time Dimensions.pdf"
        "1975 - Mandelstam - Soliton operators for the quantized sine-Gordon equation.pdf1976 - Bros, Buchholz, Glaser - Constants of motion in local field theory (Coleman's theorem revisited).pdf1976 - Dimock, Eckmann - On the bound state in weakly coupled lambda(phi6-ph4)_2.pdf"
        "1976 - Fr\\\"ohlich - New super-selection sectors (``soliton-states'') in two dimensional Bose quantum field models.pdf1977 - Perez, Wilde - Localization and causality in relativistic quantum mechanics.pdf1979 - Berg, Karowski, Weisz - Construction of Green's functions from an exact S matrix.pdf"
        "1979 - L\\\"ucke - PCT, Spin and Statistics, and All That for Nonlocal Wightman Fields.pdf1980 - Borchers, Garber - Local theory of solutions for the O(2k+1) sigma-model.pdf1980 - Borchers, Garber - Analyticity of solutions of the O(N) nonlinear sigma-model.pdf"
        "1980 - Dimock - Algebras of local observables on a manifold.pdf1982 - Buchholz, Fredenhagen - Locality and the structure of particle states.pdf1983 - Borchers - C-star-algebras and automorphism groups.pdf1983 - Driessler, Summers - Nonexistence of quantum fields associated with two-dimensional spacelike planes.pdf"
        "1984 - Doplicher, Longo - Standard and split inclusions of von Neumann algebras.pdf1984 - Longo - Solution of the Factorial Stone-Weierstrass conjecture.pdf1985 - Woronowicz - On the Existence of KMS states.pdf1986 - Buchholz, Wichmann - Causal independence and the energy-level density of states in local quantum field theory.pdf"
        "1987 - D'Antoni, Doplicher, Fredenhagen, Longo - Convergence of Local Charges and Continuity Properties of W-Inclusions.pdf1988 - Bros, Iagolnitzer - 2-particle asymptotic completeness and bound states in weakly coupled quantum field theories.pdf1988 - Rehren - Locality of conformal fields in two dimensions - exchange algebra on the light-cone.pdf"
        "1989 - Fredenhagen, Rehren, Schroer - Superselection Sectors with Braid Group Statistics and Exchange Algebras I General Theory.pdf1990 - Borchers, Sen - Theory of ordered spaces.pdf1990 - Buchholz - Harmonic analysis of local operators.pdf10.1063/1.5286801990 - Buchholz - On quantum fields that generate local algebras.pdf"
        "1992 - Babelon, Bernard - From Form Factors to Correlation Functions - The Ising Model.pdf1993 - Dimock, Hurd - Construction of the two-dimensional sine-Gordon model for beta less than 8 pi.pdf1994 - Balog, Hauer - Polynomial Form Factors in the O(3) nonlinear sigma-model.pdf"
        "1994 - Hegerfeldt - Causality Problems for Fermis Two Atom System.pdfhttp://projecteuclid.org/euclid.cmp/11038409821968 - Maison - Eine Bemerkung zu Clustereigenschaften.pdfhttp://arxiv.org/abs/hep-th/04122262004 - Dybalski - Haag-Ruelle scattering theory in presence of massless particles.pdf"
        "http://www.pubmedcentral.nih.gov/articlerender.fcgi?artid=5286741958 - Schwinger - On the Euclidian Structure of Relativistic Field Theory.pdfhttp://projecteuclid.org/euclid.cmp/11038991821975 - Baumann - When is a field theory a generalized free field.pdfhttp://arxiv.org/abs/hep-th/9501063"
        "1995 - Buchholz, Verch - Scaling Algebras and Renormalization Group in Algebraic Quantum Field Theory.pdfhttp://arxiv.org/abs/hep-th/97080951997 - Buchholz, Verch - Scaling Algebras and Renormalization Group in Algebraic Quantum Field Theory. II. Instructive Examples.pdf"
        "http://arxiv.org/abs/0705.42942007 - Strelchenko, Vassilevich - On space-time noncommutative theories at finite temperature.pdfhttp://arxiv.org/abs/0711.0371http://arxiv.org/abs/0711.1525http://www.lqp.uni-goettingen.de/papers/07/11/07111201.html2007 - Schroer - Localization and the interface between quantum mechanics, quantum field theory and quantum gravity.pdf"
        "http://www.lqp.uni-goettingen.de/papers/07/11/07111200.html2007 - Schroer - Constructive use of holographic projections.pdfhttp://arxiv.org/abs/hep-th/97050191997 - M\\\"uger - Superselection structure in massive quantum field theories in 1+1 dimensions.pdfhttp://arxiv.org/abs/0711.4237"
        "http://arxiv.org/abs/hep-th/06061832007 - Abe - Noncommutative quantization for noncommutative field theory.pdfhttp://arxiv.org/abs/0708.1561http://arxiv.org/abs/hep-th/05070302006 - Grosse, Wohlgenannt - On kappa-deformation and UV-IR-mixing.pdfhttp://arxiv.org/abs/hep-th/0612170"
        "2007 - Freidel, Kowalski-Glikman, Nowak - From noncommutative kappa-Minkowski to Minkowski space- time.pdfhttp://arxiv.org/abs/0706.3658http://www-library.desy.de/cgi-bin/showprep.pl?thesis04-0042003 - Bahns - Perturbative Methods on the Noncommutative Minkowski space.pdf"
        "http://arxiv.org/abs/hep-th/06121122006 - Chaichian, Mnatsakanova, Tureanu, Vernov - Classical Theorems in Noncommutative Quantum Field Theory.pdfhttp://arxiv.org/abs/hep-th/06110972006 - Chaichian, Mnatsakanova, Tureanu - Generalized Haag's theorem in SO(1,1) and SO(1,3) invariant quantum field theory.pdf"
        "http://arxiv.org/abs/0708.00692007 - Balachandran, Pinzul, Qureshi - Twisted Gauge and Gravity Theories on the Groenewold-Moyal Plane.pdfhttp://arxiv.org/abs/hep-ph/01050512002 - Buchholz, Ojima, Roos - Thermodynamic properties of non-equilibrium states in quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/03011152003 - Buchholz - On hot bangs and the arrow of time in relativistic quantum field theory.pdfhttp://arxiv.org/abs/math-ph/06070572006 - Camassa - Relative Haag duality for the free field in Fock representation.pdfhttp://arxiv.org/abs/0712.2140"
        "2007 - Longo, Rehren - How to remove the boundary.pdfhttp://arxiv.org/abs/hep-th/03120152003 - Seiler - The case against asymptotic freedom.pdfhttp://arxiv.org/abs/0712.44032007 - Schroer - Localization-Entropy from Holography on Null-Surfaces and the Split Property.pdf"
        "http://arxiv.org/abs/hep-th/93101871993 - Fr\\\"ohlich, Gawedzki - Conformal Field Theory and Geometry of Strings.pdfhttp://arxiv.org/abs/math-ph/01060282006 - D'Antoni, Hollands - Nuclearity, local quasiequivalence and split property for Dirac quantum fields in curved spacetime.pdf"
        "http://arxiv.org/abs/math/98100031998 - D'Antoni, Longo, Radulescu - Conformal Nets, Maximal Temperature and Models from Free Probability.pdfhttp://spaces.djvu/home/gandalf/Physik/Fachb\\\"ucher/Conway - Functions of One Complex Variable I.djvu/home/gandalf/Physik/Fachb\\\"ucher/Boas - Entire Functions.djvu"
        "1987 - Rehren, Schroer - Exchange algebra on the lightcone and order-disorder 2n-point functions in the Ising field theory.pdf1978 - Schroer, Truong - The Relativistic Quantum Fields of the d=2 Ising Model.pdf1977 - Schroer, Truong - Equivilance of the Sine-Gordon and Thirring models and cumulative mass effects.pdf"
        "1979 - Schroer, Truong - Z_2 Duality Algebra in d=2 Quantum Field Theory.pdf1979 - Schroer, Truong, Weisz - Supersymmetric Ising Field Theory.pdf1978 - Schroer, Truong - The Order-Disorder Quantum Field Operators associated with the tw-dimensional Ising Model in the Continuum Limit.pdf"
        "1976 - Schroer, Truong, Weisz - Towards an Explicit Construction of the Sine-Gordon Field Theory.pdf1976 - Schroer, Truong - Model Study of Nonleading Mass Singularities I.pdf1978 - Schroer, Truong - Direct Construction of the Quantum Field Operators of the d=2 Ising Model.pdf"
        "http://arxiv.org/abs/0801.352910.1063/1.28381552008 - Strich - Passive States for Essential Observers.pdfhttp://arxiv.org/abs/0801.3621http://arxiv.org/abs/math-ph/99060201999 - Ilieva, Thirring - Anyons and the Bose-Fermi duality in the finite-temperature Thirring model.pdf"
        "1977 - Cuntz - Simple Cstar-algebras generated by isometries.pdfhttp://arxiv.org/abs/gr-qc/9605073http://arxiv.org/abs/math-ph/05110342005 - Summers - Tomita-Takesaki Modular Theory.pdf1975 - Araki - Relative entropy of states of von Neumann algebras.pdf1977 - Araki - Relative entropy for states of von Neumann algebras II.pdf"
        "1974 - Eckmann, Fr\\\"ohlich - Unitary equivalence of local algebras in the quasifree representation.pdf1993 - Buchholz, Summers - An algebraic characterization of vacuum states in Minkowski space.pdf1994 - Langmann - Fermion current algebras and Schwinger terms in (3+1)-dimensions.pdf"
        "1994 - Longo, Rehren - Nets of Subfactors.pdf1994 - Mund, Schrader - Hilbert Spaces for Nonrelativistic and Relativistic Free Plektons (Particles with Braid Group Statistics).pdfhttp://arxiv.org/abs/hep-th/95060161995 - J\\\"or\\ss - The Construction of Pointlike Localized Charged Fields from Conformal Haag-Kastler Nets.pdf"
        "1995 - Liguori, Mintchev - Fock Spaces with Generalized Statistics.pdfhttp://arxiv.org/abs/hep-th/96041611996 - Balog, Niedermaier, Hauer - Perturbative versus Non-perturbative QFT Lessons from the O(3) NLS Model.pdf1996 - Filk - Divergenices of a field theory on quantum space.pdf"
        "http://arxiv.org/abs/hep-th/96092061996 - Grosse, Langmann, Raschhofer - The Luttinger--Schwinger Model.pdf1997 - Borchers - Half-sided Translations in Connection with Modular Groups as a Tool in Quantum Field Theory.pdf1997 - M\\\"uger - Superselection Structure of Quantum Field Theories in 1+1 Dimenions PhD.pdf"
        "http://arxiv.org/abs/hep-th/96080921997 - Schroer - Wigner Representation Theory of the Poincare Group, Localization, Statistics and the S-Matrix.pdf1997 - Wulkenhaar - Non-Associative Geometry - Unified Models Based on L-Cycles -- PhD Thesis.pdfhttp://arxiv.org/abs/hep-th/9810026"
        "1998 - Dorey - Exact S-matrices.pdf1998 - Eveson, Fewster - Bounds on negative energy densities in flat spacetime.pdf1998 - Schroer - Localization and Nonperturbative Local Quantum Physics.pdfhttp://arxiv.org/abs/hep-th/97121241998 - Schroer - Modular Wedge Localization and the d=1+1 Formfactor Program.pdf"
        "http://arxiv.org/abs/math/98060311998 - Wassermann - OPERATOR ALGEBRAS AND CONFORMAL FIELD THEORY III.pdf1999 - Florig - Geometric Modular Action -- PhD-Thesis.pdfhttp://arxiv.org/abs/hep-th/99062251999 - Oeckl - Braided Quantum Field Theory.pdfhttp://arxiv.org/abs/hep-th/9908021"
        "1999 - Schroer - New Concepts in Particle Physics from Solution of an Old Problem.pdf2000 - Bostelmann - Lokale Algebren und Operatorprodukte am Punkt.pdfhttp://arxiv.org/abs/0801.46052008 - Carey, Phillips, Rennie - Twisted cyclic theory and an index theory for the gauge invariant KMS state on Cuntz algebras.pdf"
        "http://arxiv.org/abs/0802.0317http://arxiv.org/abs/0802.18542008 - Summers - Yet More Ado About Nothing: The Remarkable Relativistic Vacuum State.pdfhttp://arxiv.org/abs/0802.20982008 - Schroer - Is inert matter from indecomposable positive energy infinite spin representations the much sought-after dark matter.pdf"
        "1993 - Verch - Antilocality and a Reeh-Schlieder Theorem on Manifolds.pdfhttp://arxiv.org/abs/0802.29352008 - Summers - ``On the Impossibility of a Poincare-Invariant Vacuum State with Unit Norm'' Refuted.pdfhttp://arxiv.org/abs/0802.02161989 - Longo - Index of subfactors and statistics of quantum fields I.pdf"
        "1990 - Mack, Schomerus - Conformal field algebras with quantum symmetry from the theory of superselection sectors.pdf2000 - Jaffe - Constructive Quantum Field Theory.pdf1999 - Schroer - New Concepts in Particle Physics from Solution of an Old Problem.pdfhttp://arxiv.org/abs/gr-qc/0001050"
        "2000 - Varadarajan - Fock representations from U(1) holonomy algebras.pdf1998 - Borchers - Half-sided Translations and the Type of von Neumann Algebras.pdf2001 - Fidaleo - On the split property for inclusions of W-algebras.pdf2002 - Ebrahimi-Fard - On the relation between modular theory and geometry.pdf"
        "1981 - Ojima - Gauge Fields at Finite Temperature - ``Thermo Field Dynamics'' and the KMS Condition and Their Extension to Gauge Theories.pdf2007 - Zahn - Dispersion relations in quantum electrodynamics on the noncommutative Minkowski space - PhD-Thesis.pdf"
        "2007 - Kopf, Paschke - Generally covariant quantum mechanics on noncommutative configuration spaces.pdf2007 - Dybalski - A sharpened nuclearity condition and the uniqueness of the vacuum in QFT.pdf2004 - Kuckert, Mund - Spin and Statistics in Nonrelativistic Quantum Mechanics II.pdf"
        "2007 - Tureanu - Twisted Poincare Symmetry and Some Implications on Noncommutative Quantum Field Theory.pdf2007 - t'Hooft - The Grand Views of Physics.pdfhttp://arxiv.org/abs/math-ph/011204110.1007/s00220-003-0815-72001 - Brunetti, Fredenhagen, Verch - The generally covariant locality principle - A new paradigm for local quantum physics.pdf"
        "2003 - Camassa - Quasi-Free States and KMS States of the Scalar Free Field.pdfhttp://www.staff.city.ac.uk/o.castro-alvaredo/heptese.pdf2001 - Castro-Alvaredo - Bootstrap Methods in 1+1-Dimensional Quantum Field Theories - the Homogeneous Sine-Gordon Models - PhD thesis.pdf"
        "2001 - Schroer - Lectures on Algebraic Quantum Field Theory and Operator Algebras.pdf2002 - Kniemeyer - Untersuchungen am erzeugenden Funktional der AdS-CFT-Korrespondenz.pdf2003 - Kawahigashi, Longo - Classification of Two-dimensional Local Conformal Nets with c smaller 1 and 2-cohomology Vanishing for Tensor Categories.pdf"
        "2004 - Buchholz, Summers - Quantum statistics and locality.pdf\u00a9 symmetry and its implications.pdf2004 - Fewster, Ojima, Porrmann - p-Nuclearity in a New Perspective.pdf2004 - Heslop, Sibold - Quantized equations of motion in non-commutative theories.pdfhttp://arxiv.org/abs/math-ph/0402043"
        "2004 - Mund, Schroer, Yngvason - String-Localized quantum fields from Wigner representations.pdf2004 - Ullrich - Uniqueness in the Characteristic Cauchy Problem of the Klein-Gordon Equation and Tame Restrictions of Generalized Functions.pdf2005 - Gallavotii - Constructive Quantum Field Theory.pdf"
        "2006 - D'Antoni, Morsella - Scaling algebras and superselection sectors: Study of a class of models.pdf2006 - Fleischhack - Kinematical Uniqueness of Loop Quantum Gravity.pdf2006 - Giesel, Thiemann - Algebraic Quantum Gravity (AQG) I. Conceptual Setup.pdf2006 - Kawahigashi, Longo, Pennig, Rehren - The classification of non-local chiral CFT with c less than 1.pdf"
        "2006 - Lewandowski, Kaminski, Okolow - Background independent quantizations: the scalar field II.pdf2006 - Redei, Summers - Quantum Probability Theory.pdf2006 - Sahlmann - Exploring the diffeomorphism invariant Hilbert space of a scalar field.pdf2006 - Thiemann - Ein Universum aus brodelnden Schleifen.pdf"
        "2006 - Thiemann - Loop Quantum Gravity - An Inside View.pdf2007 - Balog, Weisz - Construction and clustering properties of the 2-d non-linear sigma model form factors - O(3), O(4), large n examples.pdf2007 - Baumg\\\"artner - Thermodynamic Stability: A note on a footnote in Ruelle's book.pdf"
        "http://arxiv.org/abs/0803.1468http://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6VN0-3YMWKX2-J&_user=162904&_rdoc=1&_fmt=&_orig=search&_sort=d&view=c&_acct=C000013078&_version=1&_urlVersion=0&_userid=162904&md5=eda241c67a6639fb4bd486d8ad51ecdc10.1016/0034-4877(96)83512-9"
        "1995 - Baumg\\\"artel, Jurke, Lled\\'o - On Free Nets Over Minkowski Space.pdfhttp://www.sciencedirect.com/science?_ob=ArticleURL&_udi=B6WJJ-4CRHYBM-4Y&_user=162904&_coverDate=05%2F31%2F1973&_alid=703919693&_rdoc=2&_fmt=full&_orig=search&_cdi=6880&_sort=d&_docanchor=&view=c&_ct=2&_acct=C000013078&_version=1&_urlVersion=0&_userid=162904&md5=1f33ae207b04b63eb9040ca7df0b088e"
        "10.1016/0022-1236(73)90062-11972 - Eckmann, Osterwalder - An application of Tomita's theory of modular Hilbert algebras: Duality for free Bose fields.pdfhttp://arxiv.org/abs/hep-th/05081432005 - Kopper - Renormalization Theory based on Flow Equations.pdfhttp://projecteuclid.org/euclid.cmp/1103922129"
        "1983 - Klein, Landau - From the Euclidean group to the Poincar\\'e group via Osterwalder-Schrader positivity.pdfhttp://projecteuclid.org/euclid.cmp/11038989091975 - L\\\"uscher, Mack - Global Conformal Invariance in Quantum Field Theory.pdf2001 - Paschke - Von Nichtkommutativen Geometrien, ihren Symmetrien und etwas Hochenergiephysik.pdf"
        "http://arxiv.org/abs/0804.35632008 - Schroer - A note on Infraparticles and Unparticles.pdf10.1007/BF020965481992 - Guido, Longo - Relativistic invariance and charge conjugation in quantum field theory.pdfhttp://arxiv.org/abs/hep-th/030724110.1007/s00220-004-1057-z"
        "2003 - Gayral, Gracia-Bondia, Iochum, Schucker, Varilly - Moyal planes are spectral triples.pdfhttp://projecteuclid.org/euclid.cmp/110385859010.1007/BF016461341973 - Swieca, V\\\"olkel - Remarks on Conformal Invariance.pdfhttp://arxiv.org/abs/0802.35262008 - Schroer - Do confinement and darkness have the same conceptual roots - The crucial role of localization.pdf"
        "http://arxiv.org/abs/0805.3500http://www.numdam.org/numdam-bin/fitem?id=AIHPA_1986__45_2_117_01986 - Yngvason - Invariant states on Borchers\\rq tensor algebra.pdfhttp://projecteuclid.org/euclid.cmp/110392032510.1007/BF012090751981 - Yngvason - Translationally invariant states and the spectrum ideal in the algebra of test functions for quantum fields.pdf"
        "http://projecteuclid.org/euclid.cmp/110385947610.1007/BF016464761973 - Yngvason - On the Algebra of Test Functions for Field Operators - Decomposition of Linear Functionals into Positive Ones.pdf10.1007/BF027456451962 - Borchers - On Structure of the Algebra of Field Operators.pdf"
        "10.1088/0305-44702005 - Franco - On the Borchers Class of a Non-Commutative Field.pdf2001 - Borchers, Yngvason - On the PCT--Theorem in the Theory of Local Observables.pdfhttp://arxiv.org/abs/0806.03492008 - Buchholz, Summers - Warped Convolutions: A Novel Tool in the Construction of Quantum Field Theories.pdf"
        "http://arxiv.org/abs/0707.38532007 - Carey, Phillips, Rennie - Semifinite spectral triples associated with graph Cstar-algebras.pdfhttp://arxiv.org/abs/0803.10352008 - Grosse, Vignes-Tourneret - Minimalist translation-invariant non-commutative scalar field theory.pdf"
        "http://arxiv.org/abs/0802.0791http://arxiv.org/abs/0806.1940http://arxiv.org/abs/0802.099710.1103/PhysRevD.77.1250132008 - Soloviev - On the failure of microcausality in noncommutative field theories.pdfhttp://arxiv.org/abs/0706.171210.1016/0370-2693(94)90940-7"
        "1994 - Doplicher, Fredenhagen, Roberts - Space-time quantization induced by classical gravity.pdfhttp://theory.djvuhttp://arxiv.org/abs/0803.4351http://arxiv.org/abs/0706.12592007 - Akofor, Balachandran, Jo, Joseph - Quantum Fields on the Groenwald-Moyal Plane: C, P, T and CPT.pdf"
        "10.1016/S0550-3213(02)00937-92002 - Aschieri, Jurco, Schupp, Wess - Noncommutative GUTs, standard model and C,P,T..pdfhttp://arxiv.org/abs/hep-th/06052492006 - Soloviev - Axiomatic formulations of nonlocal and noncommutative field theories.pdf2006 - Chu, Furuta, Inami - Locality, Causality and Noncommutative Geometry.pdf"
        "2004 - Franco , Polito - A New Derivation of the CPT and Spin-Statistics Theorems in Non-Commutative Field Theories.pdf10.1140/epjc2004 - Grosse, Wulkenhaar - The beta-function in duality-covariant noncommutative phi^4-theory.pdf10.1140/epjc2007 - Disertori, Rivasseau - Two and Three Loops Beta Function of Non Commutative Phi^4_4 Theory.pdf"
        "10.1016/j.physletb.2007.04.0072007 - Disertori, Gurau, Magnen, Rivasseau - Vanishing of Beta Function of Non Commutative Phi^4_4 Theory to all orders.pdf10.2977/prims1984 - Yngvason - On the Locality Ideal in the Algebra of Test Functions for Quantum Fields.pdf"
        "1968 - Lassner, Uhlmann - On positive functionals on algebras of test functions for quantum fields.pdf2008 - Hollands, Wald - Axiomatic quantum field theory in curved spacetime.pdf1978 - Leyland, Roberts, Testard - Duality for Quantum Free Fields.pdf2008 - Buchholz - Ein alternativer Zugang zur Teilchenphysik.pdf"
        "http://arxiv.org/abs/0808.345910.1088/1126-67082008 - Grosse, Lechner - Noncommutative Deformations of Wightman Quantum Field Theories.pdfhttp://arxiv.org/abs/0803.10352008 - Grosse, Vignes-Tourneret - Quantum field theory on the degenerate Moyal space.pdfhttp://arxiv.org/abs/0810.1195"
        "10.1088/1126-67082008 - Fischer, Szabo - Duality covariant quantum field theory on noncommutative Minkowski space.pdfhttp://arxiv.org/abs/hep-th/99102431999 - Buchholz, Haag - The Quest for Understanding in Relativistic Quantum Physics.pdf1966 - Symanzik - Euclidean Quantum Field Theory. I. Equations for a Scalar Model.pdf"
        "1999 - Schlingemann - Short-distance analysis for algebraic euclidean field theory.pdfhttp://arxiv.org/abs/hep-th/98020351999 - Schlingemann - From Euclidean Field Theory to Quantum Field Theory.pdfhttp://arxiv.org/abs/0810.52942008 - Redei, Summers - When are quantum systems operationally independent.pdf"
        "http://arxiv.org/abs/math-ph/98050131999 - Borchers, Yngvason - Modular groups of quantum fields in thermal states.pdf10.1016/0370-2693(79)90561-6http://arxiv.org/abs/hep-th/93100581993 - Fendley, Saleur - Massless integrable quantum field theories and massless scattering in 1+1 dimensions.pdf"
        "10.1007/BF020992491996 - Fredenhagen, J\\\"or\\ss - Conformal Haag-Kastler nets, pointlike localized fields and the existence of operator product expansions.pdf10.1103/PhysRevD.67.08500110.1023/B:MATH.0000035040.57943.7e10.1088/1751-8113http://arxiv.org/abs/math/0606333"
        "2008 - Kasprzak - Rieffel Deformations via Crossed Products.pdf1990 - Rieffel - Deformation Quantization and Operator Algebras.pdfhttp://arxiv.org/abs/math/04082172004 - Waldmann - States and representations in deformation quantization.pdfhttp://arxiv.org/abs/math/0609850"
        "2006 - Heller, Neumaier, Waldmann - A C-Algebraic Model for Locally Noncommutative Spacetimes.pdfhttp://arxiv.org/abs/math/99030531999 - Waldmann - Locality in GNS Representations of Deformation Quantization.pdfhttp://arxiv.org/abs/0901.10042009 - Lledo - Modular Theory by Example.pdf"
        "http://arxiv.org/abs/0812.47622008 - Bostelmann, D'Antoni, Morsella - On dilation symmetries arising from scaling limits.pdfhttp://arxiv.org/abs/0812.47602008 - Bostelmann, Fewster - Quantum Inequalities from Operator Product Expansions.pdfhttp://arxiv.org/abs/0809.2206"
        "10.4171/JNCG2008 - Kaschek, Neumaier, Waldmann - Complete Positivity of Rieffel's Deformation Quantization by Actions of Rd.pdf10.1007/BF016456931972 - Wyss - The Field algebra and its positive linear functionals.pdf10.1023/A:10075465073921998 - Florig - On Borchers' theorem.pdf"
        "2009 - Piacitelli - Twisted Covariance vs Weyl Quantisation.pdfhttp://arxiv.org/abs/math-ph/06040232006 - De Bievre, Merkli - The Unruh effect revisited.pdfhttp://arxiv.org/abs/0812.15172008 - Summers - Subsystems and Independence in Relativistic Microscopic Physics.pdf"
        "http://arxiv.org/abs/0901.31272008 - Dybalski - Spectral Theory of Automorphism Groups and Particle Structures in Quantum Field Theory.pdfhttp://analysis.djvu/home/gandalf/Physik/Fachb\\\"ucher/Kadison, Ringrose - Fundamentals of the Theory of Operator Algebras I - Elementary Theory.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Kadison, Ringrose - Fundamentals of the Theory of Operator Algebras II - Advanced Theory.pdf/home/gandalf/Physik/Lecture Notes/1997 - Landi - An Introduction to Noncommutative Spaces and their Geometry.pdfhttp://theory.djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Bratteli, Robinson - Operator Algebras and Quantum Statistical Mechanics. Vol. 1.djvu/home/gandalf/Physik/Fachb\\\"ucher/Bratteli, Robinson - Operator Algebras and Quantum Statistical Mechanics. Vol. 2.djvuhttp://algebras.djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Jost - General theory of quantized fields (AMS, 1964)(L)(T)(86s).djvu2002 - Boller - Spectral Theory of Modular Operators for von Neumann Algebras and Related Inverse Problems.pdfhttp://www.emis.de/journals/ZAA/1901/2.html2000 - Leitz-Martini, Wollenberg - Notes on Modular Conjugations of von Neumann Factors.pdf"
        "http://arxiv.org/abs/0902.05752009 - Piacitelli - Twisted Covariance as a Non Invariant Restriction of the Fully Covariant DFR Model.pdf/home/gandalf/Physik/Fachb\\\"ucher/Takesaki M. Theory of operator algebras 1 (Enc.Math.Sci.124, Springer, 2001)(ISBN 354042248X)(600dpi)(T)(435s)_MCf_.djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Takesaki M. Theory of operator algebras 2 (Enc.Math.Sci.125, Springer, 2003)(ISBN 354042914X)(600dpi)(T)(540s)_MCf_.djvu/home/gandalf/Physik/Fachb\\\"ucher/Takesaki M. Theory of operator algebras 3 (Enc.Math.Sci.127, Springer, 2003)(ISBN 3540429131)(600dpi)(T)(570s)_MCf_.djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Connes - Noncommutative Geometry.pdf/home/gandalf/Physik/Fachb\\\"ucher/Reed, Simon - Methods of Modern Mathematical Physics I - Functional Analysis.pdf/home/gandalf/Physik/Fachb\\\"ucher/Reed, Simon - Methods of Modern Mathematical Physics II - Fourier Analysis, Self-Adjointness.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Reed, Simon - Methods of Modern Mathematical Physics III - Scattering Theory.pdf/home/gandalf/Physik/Fachb\\\"ucher/Reed, Simon - Methods of Modern Mathematical Physics IV - Analysis of Operators.pdfhttp://i.djvu/home/gandalf/Physik/Fachb\\\"ucher/Neumann - Mathematische Grundlagen der Quantenmechanik.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Landsman - Mathematical topics between classical and quantum mechanics.djvu1962 - Uhlmann - \\\"Uber die Definition der Quantenfelder nach Wightman und Haag.pdf1972 - Borchers - Algebraic Aspects of Wightman Field Theory.pdfhttp://arxiv.org/abs/0812.0786"
        "10.1007/s00220-009-0905-22008 - Borris, Verch - Dirac field on Moyal-Minkowski spacetime and non-commutative potential scattering.pdf/home/gandalf/Physik/Fachb\\\"ucher/Rieffel - Deformation Quantization for Actions of Rd.pdf10.1023/A:10073680125571997 - Rehren - Bounded Bose fields.pdf"
        "1997 - Rehren - Konforme Quantenfeldtheorie.pdf/home/gandalf/Physik/Lecture Notes/1997 - Rehren - Konforme Quantenfeldtheorie.pdf/home/gandalf/Physik/Fachb\\\"ucher/Di Francesco P., Mathieu P., Senechal D. Conformal field theory (Springer 1997)(no preface)(K)(T)(908s)_PQft_.djvu"
        "http://arxiv.org/abs/hep-th/940707910.1007/BF021018941996 - B\\\"ockenhauer - Localized endomorphisms of the chiral Ising model.pdf2008 - Fewster - Lectures on quantum field theory in curved spacetime.pdf1988 - Furlan, Sotkov, Todorov - Two-dimensional conformal quantum field theory.pdf"
        "2004 - Kawahigashi, Longo - Classification of Local Conformal Nets. Case c < 1.pdf10.1103/PhysRevLett.38.7931977 - McCoy, Tracy, Wu - Two-Dimensional Ising Model as an Exactly Solvable Relativistic Quantum Field Theory: Explicit Formulas for n-Point Functions.pdf"
        "10.1023/A:10075171311431999 - Carpi - Classification of Subsystems for the Haag--Kastler Nets Generated by c = 1 Chiral Current Algebras.pdf10.1023/A:10074664201141998 - Carpi - Absence of Subsystems for the Haag--Kastler Net Generated by the Energy-Momentum Tensor in Two-Dimensional Conformal Field Theory.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Heuser H. Gewoehnliche Differentialgleichungen (Teubner, 1995)(de)(600dpi)(T)(628s)_MCde_.djvu2000 - Boller - Characterization of Cyclic and Separating Vectors and Application to an Inverse Problem in Modular Theory I. Finite Factors.pdf"
        "http://algebras.djvu2008 - Longo - Lectures on Conformal Nets - part1.pdf2008 - Longo - Lectures on Conformal Nets - part2.pdf2001 - D\\\"utsch, Fedenhagen - Perturbative Algebraic Field Theory, and Deformation Quantization.pdf2003 - Ritz - Normalit\\\"atseigenschaften lokaler Gleichgewichtszust\\\"ande in der relativistischen Quantenfeldtheorie.pdf"
        "1996 - Brunetti, Fredenhagen, K\\\"ohler - The microlocal spectrum condition and Wick polynomials of free fields on curved spacetimes.pdfhttp://arxiv.org/abs/0802.21982008 - Hollands - Quantum field theory in terms of consistency conditions I: General framework, and perturbation theory via Hochschild cohomology.pdf"
        "http://www.jstor.org/stable/19704841964 - Gerstenhaber - On the deformation of rings and algebras.pdfhttp://arxiv.org/abs/0905.37762009 - Nahm, Keegan - Integrable deformations of CFTs and the discrete Hirota equations.pdfhttp://arxiv.org/abs/hep-th/9411203"
        "10.1016/0370-2693(95)00125-51995 - Gliozzi, Tateo - ADE functional dilogarithm identities and integrable models.pdfhttp://geometry.djvu1996 - Weaver - Deformations of von Neumann algebras.pdf1981 - Rieffel - Von Neumann algebras associated with pairs of lattices in Lie groups.pdf"
        "1990 - Rieffel - Non-commutative tori - a case study of non-commutative differentiable manifolds.pdfhttp://arxiv.org/abs/0905.44352009 - Schroer - BMS symmetry, holography on null-surfaces and area proportionality of light-slice entropy.pdfhttp://link.aip.org/link/?JMP/25/113/1"
        "10.1063/1.5260051982 - Lester - The causal automorphism of de Sitter and Einstein cylinder spacetimes.pdfhttp://arxiv.org/abs/math-ph/03100092003 - Suijlekom - The noncommutative Lorentzian cylinder as an isospectral deformation.pdf10.1007/BF020995821995 - Coburn, Xia - Toeplitz Algebras and Rieffel Deformations.pdf"
        "http://arxiv.org/abs/math/02092952002 - Bieliavsky, Maeda - Convergent Star Product Algebras on 'ax+b'.pdfhttp://arxiv.org/abs/math/00100042000 - Bieliavsky - Strict Quantization of Solvable Symmetric Spaces.pdf2006 - Heller - Lokal nichtkommutative Raumzeiten und Strikte Deformationsquantisierung - Diplom.pdf"
        "2008 - Kaschek - Nichtperturbative Deformationstheorie physikalischer Zust\\\"ande - Diplomarbeit.pdf/home/gandalf/Physik/Fachb\\\"ucher/Lance E.C. Hilbert C-Modules.. a toolkit for operator algebraists (CUP, 1995)(600dpi)(T)(ISBN 052147910X)(138s).djvu10.1007/BF01941663"
        "1981 - Fredenhagen, Hertel - Local algebras of observables and pointlike localized fields.pdf/home/gandalf/Physik/Fachb\\\"ucher/Schiff J.L. Laplace Transformation.. Theory and Applications (UTM, Springer,1999)(ISBN 0387986987)(245s)_MCat_.pdfhttp://arxiv.org/abs/0906.3524"
        "2009 - Rivasseau - Constructive Field Theory in Zero Dimension.pdf10.1007/BF015651141992 - Bros, Buchholz - Particles and propagators in relativistic thermo field theory.pdfhttp://arxiv.org/abs/hep-th/980709910.1016/0550-3213(94)00298-31994 - Bros, Buchholz - Towards a Relativistic KMS Condition.pdf"
        "http://arxiv.org/abs/hep-th/95110221995 - Bros, Buchholz - Relativistic KMS-condition and Kaellen-Lehmann type representatios of thermal propagators.pdfhttp://arxiv.org/abs/hep-th/96060461996 - Bros, Buchholz - Axiomatic analyticity properties and representations of particles in thermal quantum field theory.pdf"
        "http://arxiv.org/abs/hep-th/960813910.1103/PhysRevD.58.1250121998 - Bros, Buchholz - The unmasking of thermal Goldstone bosons.pdfhttp://arxiv.org/abs/hep-ph/010913610.1016/S0550-3213(02)00059-72002 - Bros, Buchholz - Asymptotic dynamics of thermal quantum fields.pdf"
        "http://arxiv.org/abs/hep-th/98040171999 - J\\\"akel - Cluster Estimates for Modular Structures.pdfhttp://www.math.berkeley.edu/~rieffel/papers/compact.pdf1993 - Rieffel - Compact quantum groups associated with toral subgroups.pdf1995 - Rieffel - Non-compact quantum groups associated with abelian subgroups.pdf"
        "1974 - Rieffel - Induced Representations of C-Algebras.pdfhttp://arxiv.org/abs/0907.09052009 - Akofor, Balachandran - Finite Temperature Field Theory on the Moyal Plane.pdfhttp://arxiv.org/abs/physics/970802710.1063/1.5324841998 - Bertrand, Bertrand - Symbolic calculus on the time-frequency half-plane.pdf"
        "10.1016/0370-2693(79)90523-91978 - Karowski, Kurak, Schroer - Confinement in two-dimensional models with factorization.pdf1999 - Quella - Formfaktoren und Lokalit\\\"at in integrablen Modellen der Quantenfeldtheorie in 1+1 Dimensionen.pdfhttp://arxiv.org/abs/0907.3640"
        "2009 - Galluccio, Lizzi, Vitale - Translation Invariance, Commutation Relations and Ultraviolet-Infrared Mixing.pdf/home/gandalf/Physik/Fachb\\\"ucher/Arnold V.I. Ordinary differential equations (MIT, 1978)(no TOC)(400dpi)(T)(273s).djvu/home/gandalf/Physik/Fachb\\\"ucher/Teschl G. Ordinary differential equations (lecture notes, web draft, 2004)(243s).pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Chicone C. Ordinary Differential Equations with Applications(TAM 34,Springer,1999)(ISBN 0387985352)(571s)_MCde_.pdf10.1016/0003-4916(89)90262-51989 - Varilly, Gracia-Bondia - The Moyal Representation for Spin.pdf/home/gandalf/Physik/Fachb\\\"ucher/Williams - Crossed products of C-algebras.djvu"
        "http://arxiv.org/abs/0908.45372009 - Bahns - Schwinger functions in noncommutative quantum field theory.pdfhttp://arxiv.org/abs/0906.20672009 - Schroer - Geometry and Localization, a metaphorically related pair.pdf/home/gandalf/Physik/Fachb\\\"ucher/Jaenich K. Funktionentheorie (5ed., Springer, 1999)(de)(L)(T)(ISBN 3540661522)(66s).djvu"
        "http://arxiv.org/abs/0909.18992009 - Brunetti, Fredenhagen, Hoge - Time in quantum physics: From an external parameter to an intrinsic observable.pdfhttp://space.djvuhttp://arxiv.org/abs/0909.32152009 - Dabrowski, Piacitelli - The k-Minkowski Spacetime: Trace, Classical Limit and uncertainty Relations.pdf"
        "http://arxiv.org/abs/hep-th/060315510.1007/978-3-540-71117-9_42006 - Fredenhagen, Rehren, Seiler - Quantum Field Theory: Where We Are.pdf/home/gandalf/Physik/Fachb\\\"ucher/Connes A., Cuntz J., et al., Noncommutative geometry, CIME lectures, 2000, LNM1831, Springer, 2004, 359s.pdf"
        "1998 - M\\\"uger - Quantum Double Actions on Operator Algebras and Orbifold Quantum Field Theories.pdf2005 - Albeverio, Motovilov - Operator integrals with respect to a spectral measure and solutions to some operator equations.pdf/home/gandalf/Physik/Fachb\\\"ucher/Pedersen G.K. C-algebras and their authomorphism groups (AP, 1979)(600dpi)(T)(ISBN 0125494505)(426s).djvu"
        "2005 - Moschella - The de Sitter and anti-de Sitter sightseeing tour.pdfhttp://arxiv.org/abs/1005.265610.1007/s00220-010-1137-12010 - Buchholz, Lechner, Summers - Warped Convolutions, Rieffel Deformations and the Construction of Quantum Field Theories.pdfhttp://arxiv.org/abs/1006.3548"
        "10.1007/s00220-011-1210-42010 - Dappiaggi, Lechner, Morfa-Morales - Deformations of quantum field theories on spacetimes with Killing fields.pdf2009 - Lechner - Deformations of Operator Algebras and the Construction of Quantum Field Theories.pdfhttp://arxiv.org/abs/0911.5136"
        "2009 - Doplicher - The Principle of Locality. Effectiveness, fate and challenges.pdf/home/gandalf/Physik/Fachb\\\"ucher/Waldmann - Poisson-Geometrie und Deformationsquantisierung.pdfhttp://arxiv.org/abs/0712.17702007 - Dappiaggi, Moretti, Pinamonti - Cosmological horizons and reconstruction of quantum field theories.pdf"
        "2008 - Dappiaggi, Moretti, Pinamonti - Distinguished quantum states in a class of cosmological spacetimes and their Hadamard property.pdf2009 - Manchak - Is spacetime hole free.pdf2000 - Kuckert - Localization Regions of Local Observables.pdf1994 - Masiello - Convex regions of Lorentzian manifolds.pdf"
        "http://arxiv.org/abs/0912.09062009 - Cagnache, D'Andrea, Martinetti, Wallet - The spectral distance on the Moyal plane.pdfhttp://arxiv.org/abs/0912.11062009 - Longo, Martinetti, Rehren - Geometric modular action for disjoint intervals and boundary conformal field theory.pdf"
        "http://arxiv.org/abs/math-ph/00020212000 - Sahlmann, Verch - Passivity and microlocal spectrum condition.pdfhttp://arxiv.org/abs/gr-qc/98030361999 - Borchers, Buchholz - Global properties of vacuum states in de Sitter space.pdf/home/gandalf/Physik/Fachb\\\"ucher/Wald R.M. General relativity (1984)(T)(ISBN 0226870332)(494s).djvu"
        "http://www.lqp.uni-goe.de/papers/09/12/09120802.html2009 - Borchers - On the Net of von Neumann algebras associated with a Wedge and Wedge-causal Manifolds.pdf2009 - Claessens - Locally anti de Sitter spaces and deformation quantization.pdfhttp://arxiv.org/abs/0912.2252"
        "2009 - Ohl, Schenkel - Algebraic approach to quantum field theory on a class of noncommutative curved spacetimes.pdf/home/gandalf/Physik/Fachb\\\"ucher/Sachs R.K., Wu H. General relativity for mathematicians (Springer, 1977)(T)(ISBN 038790218X)(301s).djvuhttp://arxiv.org/abs/1001.1882"
        "2010 - Streater - A Scattering Theory based on Free Fields.pdf/home/gandalf/Physik/Fachb\\\"ucher/Sakai S. C-star-algebras and W-star-algebras (Springer, 1971)(600dpi)(T)(270s).djvu/home/gandalf/Physik/Fachb\\\"ucher/Arveson W. An invitation to C-algebras (Springer, 1976)(600dpi)(T)(116s).djvu"
        "1966 - Araki, Woods - Complete Boolean algebras of type I factors.pdf/home/gandalf/Physik/Fachb\\\"ucher/Guichardet. Symmetric Hilbert Spaces and Related Topics (LNM0261, Springer, 1972)(ISBN 3540058036)(T)(202s).djvuhttp://arxiv.org/abs/1002.09562010 - L\\aangvik, Zahabi - On Finite Noncommutativity in Quantum Field Theory.pdf"
        "http://arxiv.org/abs/hep-th/00050572000 - Porrmann - The Concept of Particle Weights in Local Quantum Field Theory - PhD-Thesis.pdfhttp://arxiv.org/abs/0809.48282008 - Sanders - Aspects of locally covariant quantum field theory - PhD-Thesis.pdfhttp://arxiv.org/abs/0903.1021"
        "2009 - Sanders - Equivalence of the (generalised) Hadamard and microlocal spectrum condition for (generalised) free fields in curved spacetime.pdfhttp://arxiv.org/abs/0801.46762008 - Sanders - On the Reeh-Schlieder Property in Curved Spacetime.pdfhttp://arxiv.org/abs/1001.0858"
        "2010 - Dappiaggi, Pinamonti, Porrmann - Local causal structures, Hadamard states and the principle of local covariance in quantum field theory.pdfhttp://arxiv.org/abs/0806.080310.1007/s00220-009-0780-x2008 - Pinamonti - Conformal generally covariant quantum field theory: The scalar field and its Wick products.pdf"
        "2009 - Waldmann - Geometric Wave Equations.pdfhttp://arxiv.org/abs/0712.04012007 - Lauridsen-Ribeiro - Structural and Dynamical Aspects of the AdS-CFT Correspondence - a Rigorous Approach - PhD-Thesis.pdf/home/gandalf/Physik/Fachb\\\"ucher/Jaenich K. Vektoranalysis (2ed., Springer, 1993)(de)(L)(T)(ISBN 3540571426)(143s).djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Isham C.J. Modern Differential Geometry for Physicists (WS, 2001)(T)(306s).djvu/home/gandalf/Physik/Fachb\\\"ucher/J\\\"anich - Topologie.djvu/home/gandalf/Physik/Fachb\\\"ucher/Rudin - Functional Analysis.djvuhttp://arxiv.org/abs/math-ph/0001034"
        "2000 - Longo - The Bisognano-Wichmann Theorem for Charged States and the Conformal Boundary of a Black Hole.pdf/home/gandalf/Physik/Fachb\\\"ucher/Galindo A., Pascual P. Quantum mechanics I (Springer, 1990)(ISBN 0387514066)(T) (431s).djvu/home/gandalf/Physik/Fachb\\\"ucher/Galindo A., Pascual P. Quantum mechanics II (Springer, 1991)(ISBN 038752309X)(T)(388s).djvu"
        "http://geometry.djvuhttp://analysis.djvuhttp://qft.djvuhttp://arxiv.org/abs/gr-qc/040111210.1007/s00220-005-1346-12005 - Bernal, Sanchez - Smoothness of time functions and the metric splitting of globally hyperbolic spacetimes.pdfhttp://arxiv.org/abs/gr-qc/0512095"
        "10.1007/s11005-006-0091-52006 - Bernal, Sanchez - Further results on the smoothability of Cauchy hypersurfaces and Cauchy time functions.pdfhttp://topology.djvuhttp://holes.djvu10.1007/s10714-006-0283-42006 - Ellis - The Bianchi Models - Then and Now.pdf10.1103/PhysRevD.10.3905"
        "http://thermodynamics.djvu10.1007/BF0210118010.1007/BF0210009610.1103/PhysRevD.35.377110.1063/1.166450710.1063/1.1665067http://spacetime.djvuhttp://sciences.djvuhttp://arxiv.org/abs/hep-th/99051791999 - Rehren - Algebraic Holography.pdf10.1142/S0129055X96000093"
        "2000 - Buchholz - Algebraic quantum field theory: A Status report.pdfhttp://projecteuclid.org/euclid.cmp/110394333710.1007/BF012126871985 - Kay - The double-wedge algebra for quantum fields on Schwarzschild and Minkowski spacetimes.pdfhttp://arxiv.org/abs/0709.1110"
        "2007 - Bieliavsky - Deformation quantization for actions of the affine group.pdfhttp://arxiv.org/abs/hep-th/04032572004 - Bieliavsky, Detournay, Rooman, Spindel - Star products on extended massive non-rotating BTZ black holes.pdfhttp://arxiv.org/abs/math/0011144"
        "2001 - Bieliavsky, Massar - Strict Deformation Quantization for Actions of a Class of Symplectic Lie Groups.pdfhttp://integral.djvuhttp://arxiv.org/abs/1004.06162010 - Longo, Witten - An Algebraic Construction of Boundary Quantum Field Theory.pdfhttp://www.ems-ph.org/journals/show_abstract.php?issn=0034-5318&vol=6&iss=3&rank=1&srch=searchterm%7COn+quasifree+states+of+CAR+and+Bogoliubov+automorphisms"
        "10.2977/prims1970 - Araki - On Quasifree States of CAR and Bogoliubov Automorphisms.pdf1968 - Araki - On the Diagonalization of a Bilinear Hamiltonian by a Bogoliubov Transformation.pdfhttp://arxiv.org/abs/0904.061210.1142/S0129055X090038642009 - Dappiaggi, Hack, Pinamonti - The extended algebra of observables for Dirac fields and the trace anomaly of their stress-energy tensor.pdf"
        "10.2307/19985971982 - Dimock - Dirac Quantum Fields on a Manifold.pdf10.1007/s0022000002992000 - Strohmaier - The Reeh--Schlieder Property for Quantum Fields on Stationary Spacetimes.pdfhttp://projecteuclid.org/euclid.cmp/11038414811969 - Doplicher, Haag, Roberts - Fields, observables and gauge transformations I.pdf"
        "http://www.ems-ph.org/journals/show_abstract.php?issn=0034-5318&vol=19&iss=2&rank=11&srch=searchterm%7CAbstract+Twisted+Duality+for+Quantum+Free+Fermi+Fields1983 - Foit - Abstract Twisted Duality for Quantum Free Fermi Fields.pdf10.1007/BF012056641981 - Summers - Normal product states for fermions and twisted duality for CCR- and CAR-type algebras with application to the Yukawa2 quantum field model.pdf"
        "10.1007/s0022001005262001 - Verch - A Spin-Statistics Theorem for Quantum Fields on Curved Spacetime Manifolds in a Generally Covariant Framework.pdf2000 - Verch - On Generalizations of the Spectrum Condition.pdfhttp://dx.doi.org/10.1142/S0129167X9300031510.1142/S0129167X93000315"
        "1993 - Schweitzer - Dense m-convex Frechet Subalgebras of Operator Algebra Crossed Products by Lie Groups.pdf/home/gandalf/Physik/Fachb\\\"ucher/Taylor - Noncommutative Harmonic Analysis.pdfhttp://arxiv.org/abs/quant-ph/02021222008 - Keyl - Fundamentals of Quantum Information Theory.pdf"
        "http://arxiv.org/abs/gr-qc/04050572004 - Paschke, Verch - Local covariant quantum field theory over spectral geometries.pdfhttp://arxiv.org/abs/1005.05412010 - Zahn - Divergences in quantum field theory on the noncommutative two-dimensional Minkowski space with Grosse-Wulkenhaar potential.pdf"
        "http://arxiv.org/abs/0907.55102009 - Aastrup, Grimstrup, Paschke, Nest - On Semi-Classical States of Quantum Gravity and Noncommutative Geometry.pdfhttp://arxiv.org/abs/0802.178310.1088/0264-93812008 - Aastrup, Grimstrup, Nest - On Spectral Triples in Quantum Gravity.pdf"
        "http://arxiv.org/abs/0804.191410.1088/1751-81132008 - Blaschke, Gieres, Kronberger, Schweda, Wohlgenannt - Translation-invariant models for non-commutative gauge fields.pdfhttp://arxiv.org/abs/hep-th/050418310.1088/0264-93812005 - Aschieri, Blohmann, Dimitrijevic, Meyer, Schupp, Wess - A Gravity Theory on Noncommutative Spaces.pdf"
        "http://projecteuclid.org/euclid.cmp/110389905010.1007/BF016089781975 - Osterwalder, Schrader - Axioms for Euclidean Green's functions II.pdfhttp://arxiv.org/abs/hep-th/94080091995 - Zinoviev - Equivalence of Euclidean and Wightman field theories.pdfhttp://arxiv.org/abs/1005.2130"
        "2010 - Bahns, Doplicher, Fredenhagen, Piacitelli - Quantum Geometry on Quantum Spacetime: Distance, Area and Volume Operators.pdf10.1063/1.5277331987 - Summers, Werner - Bell's Inequalities and quantum field theory I. General setting.pdfhttp://arxiv.org/abs/funct-an/9701011"
        "1997 - Rieffel - On the operator algebra for the space-time uncertainty relations.pdf/home/gandalf/Physik/Fachb\\\"ucher/Lang - SL(2,R).djvuhttp://arxiv.org/abs/math-ph/06030832006 - Buchholz, D'Antoni, Longo - Nuclearity and Thermal States in Conformal Field Theory.pdf"
        "http://c-algebras.djvuhttp://arxiv.org/abs/hep-th/99040491999 - J\\\"akel - The Reeh-Schlieder property for thermal field theories.pdfhttp://arxiv.org/abs/0911.130410.1142/S0129055X100039902010 - Sanders - The locally covariant Dirac field.pdf10.1016/0370-1573(92)90044-Z"
        "10.1063/1.5285141989 - Estrada, Gracia-Bondia, Varilly - On asymptotic expansions of twisted products.pdf/home/gandalf/Physik/Fachb\\\"ucher/Jackson J.D. Classical electrodynamics (Wiley, 1962)(T)(656s).djvuhttp://arxiv.org/abs/1006.34162010 - Kasprzak - Rieffel deformation of group coactions.pdf"
        "http://theory.djvuhttp://arxiv.org/abs/hep-th/01062052001 - Chu, Madore, Steinacker - Scaling Limits of the Fuzzy Sphere at one Loop.pdfhttp://arxiv.org/abs/math/01080052001 - Rieffel - Matrix algebras converge to the sphere for quantum Gromov-Hausdorff distance.pdf"
        "http://arxiv.org/abs/1006.54302010 - Dybalski, Tanimoto - Asymptotic completeness in a class of massless relativistic quantum field theories.pdfhttp://www.jstor.org/stable/20069791983 - Fr\\\"ohlich, Osterwalder, Seiler - On Virtual representations of symmetric spaces and their analytic continuation.pdf"
        "http://spaces.djvuhttp://mechanics.djvuhttp://arxiv.org/abs/1005.46662010 - Acharyya, Vaidya - Uniformly Accelerated Observer in Moyal Spacetime.pdf/home/gandalf/Physik/Fachb\\\"ucher/Kirillov - Lectures on the Orbit Method.pdfhttp://arxiv.org/abs/0806.42552008 - Bieliavsky, Gurau, Rivasseau - Non Commutative Field Theory on Rank One Symmetric Spaces.pdf"
        "http://arxiv.org/abs/math/03054422006 - Cushman, van der Kallen - Adjoint and Coadjoint Orbits of the Poincare Group.pdfVogan - Corrections to Lectures on the Orbit Methods by Kirillov.pdfhttp://equation.djvu1982 - Dimock, Kay - Classical wave operators and asymptotic quantum field operators on curved spacetimes.pdf"
        "1982 - Kay - Quantum Fields in Curved Spacetimes and Scattering Theory.pdf10.1063/1.5233701976 - Buchholz, Fredenhagen - Dilations and Interaction.pdfhttp://arxiv.org/abs/1006.47262010 - Weiner - An algebraic Haag's theorem.pdf2000 - D'Antoni, Zsido - The Flat Tube Theorem for Vector Valued Functions.pdf"
        "Hyperfunctions_and_theoretical_physics-Springer(1975).djvuhttp://arxiv.org/abs/0806.47412009 - Bieliavsky, Detournay, Spindel - The Deformation Quantizations of the Hyperbolic Plane.pdf1992 - Klimek, Lesniewski - Quantum Riemann Surfaces I, The Unit Disc.pdf"
        "http://arxiv.org/abs/1007.40942010 - Bertozzini, Conti, Lewkeeratiyutkul - Modular Theory, Non-commutative Geometry and Quantum Gravity.pdf1981 - Klein, Landau - Construction of a Unique Self-Adjoint Generator for a Symmetric Local Semigroup.pdf1976 - Klein - The semigroup characterization of Osterwalder-Schrader path spaces and the construction of Euclidean fields.pdf"
        "http://arxiv.org/abs/1009.38322010 - Casini - Wedge Reflection Positivity.pdf10.1007/BF028216771963 - Borchers, Zimmermann - On the Self-Adjointness of Field Operators.pdfhttp://electrodynamics.djvuhttp://i.djvuhttp://ii.djvuhttp://iii.djvuhttp://iv.djvuhttp://analysis.djvu"
        "http://i.djvu1971 - H\\\"ormander - Fourier Integral Operators I.pdfhttp://applications.djvu/home/gandalf/Physik/Fachb\\\"ucher/Jarchow - Locally Convex Spaces.djvuhttp://kernels.djvuhttp://arxiv.org/abs/1011.23702010 - Bieliavsky, de Goursac, Tuynman - Deformation Quantization for Heisenberg Supergroup.pdf"
        "10.1007/BF012134091985 - Fredenhagen - A remark on the cluster theorem.pdfhttp://arxiv.org/abs/quant-ph/00070602001 - Halvorson - Reeh-Schlieder Defeats Newton-Wigner: On Alternative Localization Schemes in Relativistic Quantum Field Theory.pdf2004 - J\\\"akel - Mathematical Foundations of Thermal Field Theory .pdf"
        "10.1063/1.17036881960 - Epstein - Generalization of the Edge-of-the-Wedge Theorem.pdf10.1007/BF007501471994 - Yngvason - A note on essential duality.pdfhttp://arxiv.org/abs/1012.14542010 - Mund - An Algebraic Jost-Schroer Theorem for Massive Theories.pdfhttp://arxiv.org/abs/1012.1417"
        "2010 - Bagarello - Modular Structures and Landau Levels.pdf2001 - Dubois-Violette, Kriegel, Maeda, Michor - Smooth Star-Algebras.pdfhttp://distributions.djvuhttp://introduction.djvu10.1142/S0129055X940002011994 - Borchers, Yngvason - Transitivity of locality and duality in quantum field theory - Some modular aspects.pdf"
        "http://arxiv.org/abs/math/04103502004 - Bursztyn, Waldmann - Hermitian star products are completely positive deformations.pdf10.1063/1.5282001988 - Gracia-Bondia, Varilly - Algebras of distributions suitable for phase space quantum mechanics. I.pdf10.1063/1.527984"
        "1988 - Gracia-Bondia, Varilly - Algebras of distributions suitable for phase-space quantum mechanics II. Topologies on the Moyal algebra.pdfhttp://arxiv.org/abs/1101.09312011 - Amelino-Camelia, Freidel, Kowalski-Glikman, Smolin - The principle of relative locality.pdf"
        "http://introduction.djvu1963 - Hepp - Kovariante analytische Funktionen - PhD-Thesis.pdfhttp://functions.djvu1992 - Zamolodchikov, Zamolodchikov - Massless factorized scattering and sigma models with topological terms.pdfhttp://spaces.djvu1960 - H\\\"ormander - Estimates for translation invariant operators in Lp spaces.pdf"
        "1989 - Meisters - Linear operators commuting with translations on D(R) are continuous.pdf1993 - Dales, Millington - Translation-invariant operators.pdf2006 - Feichtinger, F\\\"uhr, Gr\\\"ochenig, Kaiblinger - Operators commuting with a discrete subgroup of translations.pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Donoghue - Distributions and Fourier transforms.pdfhttp://analysis.djvuhttp://arxiv.org/abs/1102.5270http://s-matrix.djvuhttp://arxiv.org/abs/1103.11412011 - Longo, Rehren - Boundary Quantum Field Theory on the Interior of the Lorentz Hyperboloid.pdf"
        "http://arxiv.org/abs/hep-th/06102962006 - Gazeau, Lachieze-Rey - Quantum Field Theory in de Sitter space : A survey of recent approaches.pdf10.1016/0034-4877(96)87678-61996 - Hofmann - On the GNS representation of generalized free fields with indefinite metric.pdf"
        "10.1007/s0022000502701998 - Hofmann - On GNS representations on indefinite inner product spaces. 1. The Structure of the representation space.pdfhttp://relations.ps/home/gandalf/Physik/Fachb\\\"ucher/Kato - Perturbation theory for linear operators (1995).djvu"
        "/home/gandalf/Physik/Fachb\\\"ucher/Garnett - Bounded Analytic Functions (2006).pdf/home/gandalf/Physik/Fachb\\\"ucher/Titchmarsh - Introduction to the theory of Fourier integrals(1948).djvu2001 - Boller, Wollenerg - An inverse problem in Tomita-Takesaki modular theory.pdf"
        "1992 - Wollenberg - Notes on Perturbations of Causal Nets of Operator Algebras.pdfhttp://variables.djvuhttp://variable.djvuhttp://arxiv.org/abs/1104.19482011 - Lechner - Deformations of quantum field theories and integrable models.pdfhttp://physics.djvuhttp://mechanics.djvu"
        "1977 - Driessler, Fr\\\"ohlich - The reconstruction of local observable algebras from the Euclidean Green's functions of relativistic quantum field theory.pdf1959 - Nelson - Analytic Vectors.pdf10.1016/0370-1573(92)90047-41992 - Mussardo - Off-critical statistical models: Factorized scattering theories and bootstrap program.pdf"
        "1999 - Jorgensen, Olafsson - Unitary representations and Osterwalder-Schrader duality.pdfhttp://arxiv.org/abs/1105.2781http://www.worldscinet.com/rmp/23/2310/S0129055X11004539.html10.1142/S0129055X110045392011 - Bostelmann, Lechner, Morsella - Scaling Limits of Integrable Quantum Field Theories.pdf"
        "http://arxiv.org/abs/1105.29632011 - Kukhtina, Rehren - Local Commutators and Deformations in Conformal Chiral Quantum Field Theories.pdf1970 - Roberts - The structure of sectors reached by a field algebra.pdf2011 - Schroer - Causality and dispersion relations and the role of the S-matrix in the ongoing research.pdf"
        "1977 - Driessler - On the Structure of Fields and Algebras on Null Planes.pdf10.1063/1.14833762002 - Baumg\\\"artel, Jurke, Lled\\'o - Twisted duality of the CAR algebra.pdf10.1016/0034-4877(96)83512-91995 - Baumg\\\"artel, Jurke, Lled\\'o - On Free Nets Over Minkowski Space.pdf"
        "10.1142/S0217751X030122172003 - Schroer - Lightfront holography and area density of entropy associated with localization on wedge-horizons.pdfhttp://arxiv.org/abs/1105.48562011 - Morfa-Morales - Deformations of quantum field theories on de Sitter spacetime.pdf"
        "http://arxiv.org/abs/0901.38652009 - Wall - Ten Proofs of the Generalized Second Law.pdfhttp://arxiv.org/abs/1007.14932010 - Wall - A proof of the generalized second law for rapidly-evolving Rindler horizons.pdfhttp://arxiv.org/abs/1105.34452011 - Wall - A proof of the generalized second law for rapidly changing fields and arbitrary horizon slices.pdf"
        "http://arxiv.org/abs/hep-th/99122191999 - Schlingemann - Application of Tomita-Takesaki theory in algebraic euclidean field theories.pdfhttp://arxiv.org/abs/0908.04802009 - Doplicher - The Measurement Process in Local Quantum Theory and the EPR Paradox.pdfhttp://arxiv.org/abs/1101.5700"
        "2011 - Dybalski, Tanimoto - Infraparticles with superselected direction of motion in two-dimensional conformal field theory.pdfhttp://arxiv.org/abs/1105.6202http://arxiv.org/abs/1106.47852011 - Fewster, Verch - Dynamical locality and covariance - What makes a physical theory the same in all spacetimes.pdf"
        "10.1007/BF025063881996 - Connes - Gravity coupled with matter and the foundation of non-commutative geometry.pdf10.1007/BF016459411974 - Glaser - On the equivalence of the Euclidean and Wightman formulation of field theory.pdf10.1007/s00023-003-0141-92003 - D\\\"utsch, Rehren - Generalized Free Fields and the AdS-CFT Correspondence.pdf"
        "http://arxiv.org/abs/1107.26292011 - Tanimoto - Construction of wedge-local nets of observables through Longo-Witten endomorphisms.pdfhttp://arxiv.org/abs/1107.26622011 - Tanimoto - Noninteraction of waves in two-dimensional conformal field theory.pdfhttp://arxiv.org/abs/1009.4990"
        "2010 - Brunetti, Moretti - Modular dynamics in diamonds.pdfhttp://arxiv.org/abs/1108.20042011 - Beiser, Waldmann - Fr\\'echet algebraic deformation quantization of the Poincar\\'e disk.pdfhttp://spaces.djvuhttp://i.djvuhttp://ii.djvuhttp://arxiv.org/abs/1108.3947"
        "2011 - Goursac - Non-formal deformation quantization of abelian supergroups.pdfhttp://arxiv.org/abs/1108.48892011 - Bischoff - Models in Boundary Quantum Field Theory Associated with Lattices and Loop Group Models.pdf2011 - Bieliavsky, Gayral - Deformation Quantization for Actions of Kahlerian Lie Groups Part I - Frechet Algebras.pdf"
        "http://arxiv.org/abs/1109.4824http://arxiv.org/abs/1109.12122011 - Schroer - The foundational origin of integrability in quantum field theory.pdfhttp://arxiv.org/abs/1109.59502011 - Lechner, Waldmann - Strict deformation quantization of locally convex algebras and modules - arXiv version 1.pdf"
        "/home/gandalf/Physik/Lecture Notes/Meinrenken - Symplectic geometry.pdfhttp://arxiv.org/abs/hep-th/030417910.1007/s00220-003-0865-x2003 - Summers, White - On Deriving Space-Time From Quantum Observables and States.pdfhttp://arxiv.org/abs/gr-qc/02120252003 - Guido, Longo - A Converse Hawking-Unruh Effect and dS^2-CFT Correspondance.pdf"
        "2011 - Summers - A Perspective on Constructive Quantum Field Theory.pdf1972 - Flato, Simon, Snellman, Sternheimer - Simple facts about analytic vectors and integrability.pdfhttp://arxiv.org/abs/1111.1671v1http://arxiv.org/pdf/1111.1671v12011 - Bischoff, Tanimoto - Construction of wedge-local nets of observables through Longo-Witten endomorphisms II.pdf"
        "http://algebras.djvu1993 - Rehren - A new view of the Virasoro algebra.pdfhttp://renormalization.djvuhttp://arxiv.org/abs/1106.1138v1http://arxiv.org/pdf/1106.1138v12011 - Verch - Quantum Dirac Field on Moyal-Minkowski Spacetime - Illustrating Quantum Field Theory over Lorentzian Spectral Geometry.pdf"
        "http://arxiv.org/abs/hep-th/0202039v2http://arxiv.org/pdf/hep-th/0202039v210.1016/S0370-2693(02)01650-72002 - Langmann, Szabo - Duality in Scalar Field Theory on Noncommutative Phase Spaces.pdf/home/gandalf/Physik/Fachb\\\"ucher/Olver, Lozier, Boisvert, Clark - NIST handbook of mathematical functions.pdf"
        "http://arxiv.org/abs/1004.5261v3http://arxiv.org/pdf/1004.5261v310.3842/SIGMA.2010.073http://arxiv.org/abs/1106.6166v2http://arxiv.org/pdf/1106.6166v2http://arxiv.org/abs/hep-th/0005129v2http://arxiv.org/pdf/hep-th/0005129v210.1016/S0550-3213(00)00525-3http://arxiv.org/abs/hep-th/0206011v2"
        "http://arxiv.org/pdf/hep-th/0206011v210.1007/s10052-002-1018-7http://arxiv.org/abs/hep-th/0205269v2http://arxiv.org/pdf/hep-th/0205269v210.1007/s10052-002-1017-8http://arxiv.org/abs/0909.1389v1http://arxiv.org/pdf/0909.1389v1http://arxiv.org/abs/1104.3750v2"
        "http://arxiv.org/pdf/1104.3750v21971 - Herbst - One\u2010Particle Operators and Local Internal Symmetries.pdfhttp://arxiv.org/abs/1112.5785v1http://arxiv.org/pdf/1112.5785v12011 - Bros, Mund - Braid group statistics implies scattering in three-dimensional local quantum physics.pdf"
        "http://www.bibsonomy.org/bibtex/23f4ad4b7cec0eed95efd7a954c28dc0a/brouder1958 - Haag - Quantum field theories with composite particles and asymptotic conditions.pdf1961 - Ruelle - On the asymptotic condition in quantum field theory.pdf10.1016/0370-1573(84)90021-8"
        "1984 - Novikov, Shifman, Vainstein, Zakharov - Two-Dimensional Sigma Models: Modeling Nonperturbative Effects of Quantum Chromodynamics.pdfhttp://arxiv.org/abs/quant-ph/9601017v1http://arxiv.org/pdf/quant-ph/9601017v110.1007/BF02099630/home/gandalf/Physik/Fachb\\\"ucher/Roepstorff G. Path integral approach to quantum physics (Springer, 1994)(ISBN 0387552138)(K)(T)(399s)_PQft_.djvu"
        "1969 - Doplicher, Haag, Roberts - Fields, observables and gauge transformations II.pdf1971 - Doplicher, Haag, Roberst - Local observables and particle statistics I.pdf1974 - Doplicher, Haag, Roberts - Local observables and particle statistics II.pdfhttp://arxiv.org/abs/math-ph/0307048v1"
        "http://arxiv.org/pdf/math-ph/0307048v110.1007/s00023-004-0183-72004 - D'Antoni, Morsella, Verch - Scaling Algebras for Charged Fields and Short-Distance Analysis for Localizable and Topological Charges.pdf1968 - Doplicher, Kastler - Ergodic states in a non commutative ergodic theory.pdf"
        "1967 - Doplicher, Kadison, Kastler, Robinson - Asymptotically abelian systems.pdfhttp://groups.djvuhttp://theory.djvuhttp://dx.doi.org/10.1007/BF020976801990 - Doplicher, Roberts - Why there is a field algebra with a compact gauge group describing the superselection structure in particle physics.pdf"
        "http://link.aps.org/doi/10.1103/PhysRev.159.125110.1103/PhysRev.159.12511967 - Coleman, Mandula - All Possible Symmetries of the S-Matrix.pdfhttp://dx.doi.org/10.1007/BF0210180610.1007/BF021018061995 - Guido, Longo - An algebraic spin and statistics theorem.pdf"
        "2012 - Todorov - Quantization is a Mystery.pdfhttp://physics.djvu/home/gandalf/Physik/Fachb\\\"ucher/Cornwell - Group Theory in Physics Vol 3.pdfhttp://theory.djvu/home/gandalf/Physik/Fachb\\\"ucher/Thirring - A Course in Mathematical Physics 4: Quantum Mechanics of Large Systems.pdf"
        "http://arxiv.org/abs/1203.2058v1http://arxiv.org/pdf/1203.2058v12012 - Alazzawi - Deformations of Fermionic Quantum Field Theories and Integrable Models.pdf/home/gandalf/Physik/Artikelsammlung/2012 - Morfa-Morales - Deformations of Quantum Field Theories on Curved Spacetimes - PhD-Thesis.pdf"
        "http://arxiv.org/abs/1203.2705v1http://arxiv.org/pdf/1203.2705v12012 - Johnson - Algebras without Involution and Quantum Field Theories.pdf/home/gandalf/Physik/Lecture Notes/2009 - Waldmann - Vector-Valued Functions.pdfhttp://arxiv.org/abs/1203.3184v1http://arxiv.org/pdf/1203.3184v1"
        "http://arxiv.org/abs/1110.6164v3http://arxiv.org/pdf/1110.6164v3http://dx.doi.org/10.1007/BF0040097810.1007/BF004009781984 - Basart, Flato, Lichnerowicz, Sternheimer - Deformation theory applied to quantization and statistical mechanics.pdfhttp://dx.doi.org/10.1007/s002200050402"
        "10.1007/s0022000504021998 - Bordemann, Waldmann - Formal GNS Construction and States in Deformation Quantization.pdfhttp://arxiv.org/abs/math-ph/0405065v1http://arxiv.org/pdf/math-ph/0405065v110.1142/S0129055X050023762004 - Ali, Englis - Quantization Methods: A Guide for Physicists and Analysts.pdf"
        "http://www.sciencedirect.com/science/article/pii/037596017290240X10.1016/0375-9601(72)90240-X1971 - Stoler, Newman - Minimum Uncertainty and Density Matrices.pdfhttp://link.aps.org/doi/10.1103/PhysRevD.1.321710.1103/PhysRevD.1.32171970 - Stoler - Equivalence Classes of Minimum Uncertainty Packets.pdf"
        "1973 - Osterwalder - Euclidean Green's functions and Wightman distributions.pdfhttp://arxiv.org/abs/0905.4006v5http://arxiv.org/pdf/0905.4006v510.1007/s10701-010-9492-5http://arxiv.org/abs/math-ph/0504012v1http://arxiv.org/pdf/math-ph/0504012v12005 - Damek - Continuity of KMS states for quantum fields on manifolds.pdf"
        "http://arxiv.org/abs/quant-ph/0101061v1http://arxiv.org/pdf/quant-ph/0101061v12000 - Werner - Quantum Information Theory - an Invitation.pdf/home/gandalf/Physik/Fachb\\\"ucher/Audretsch - Verschr\\\"ankte Systeme.pdf1972 - Kastler, Mebkhout, Loupias, Michel - Central decomposition of invariant states applications to the groups of time translations and of Euclidean transformations in algebraic field theory.pdf"
        "1974 - Powers, Sakai - Existence of ground states and KMS states for approximately inner dynamics.pdf1977 - Araki, Kishimoto - Symmetry and equilibrium states.pdf/home/gandalf/Physik/Fachb\\\"ucher/Ruelle - Statistical mechanics.djvu1977 - Araki, Haag, Kastler, Takesaki - Extension of KMS States and Chemical Potential.pdf"
        "http://arxiv.org/abs/1204.5078v1http://arxiv.org/pdf/1204.5078v12012 - Hillier - On Super-KMS Functionals for Graded-Local Conformal Nets.pdfhttp://arxiv.org/abs/math-ph/0604044v2http://arxiv.org/pdf/math-ph/0604044v210.1007/s00220-006-0177-z2006 - Buchholz, Grundling - Algebraic Supersymmetry: A case study.pdf"
        "http://dx.doi.org/10.1007/BF0164541610.1007/BF016454161969 - Rocca, Sirugue, Testard - On a class of equilibrium states under the Kubo-Martin-Schwinger condition. I. Fermions .pdf1969 - Rocca, Sirugue, Testard - On a class of equilibrium states under the Kubo-Martin-Schwinger condition. II. Bosons .pdf"
        "/home/gandalf/Physik/Fachb\\\"ucher/Sunder - An Invitation to von Neumann Algebras.pdf");
static const char *digiplayLastAuthors("(ed)A.AarsethAarsethAarsethAarsethAarsethAarsethAarsethAarsethAarsethAarsethAbanesAbenhaimAbramsonAdamoAdamovichAdamsAdamsAdamsAdamsAdamsAdamsAedoAgababyanAgababyanAgahAhaAhaAhlersAhmadAhnAitkinAkaiAkessonAlbertAlbertAlbrechtslundAlbrechtslundAlexaAlexander"
                                       "AlinierAliyaAllansonAllansonAllenAllenAlmeidaAltAltmanAltmanAltunbasAlvaresAlvisiAmoryAnacletoAnandAndersAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndersonAndrewsAndrewsAngAngelidesAnnaAnnettaAnsteyAntleAoyamaApperleyApperleyApperleyApperley"
                                       "ArbingerArbiserArchambaultArchambaultArendashArlenArmandAronssonAronssonArpanArsenaultArthurAsakuraAscioneAsgariAsgariAshtonAshtonAtkinsAtkinsAtkinsAtkinsAtkinsAtkinsAtkinsAtkinsAuAuberAugeraudAverchAveryAvetisovaAxelssonAylettBabaBabicBacklundBadiruBaerBaerg"
                                       "BagnallBaileyBainbridgeBainbridgeBaldwinBallanceBallanceBallanceBallardBalsamBaltraBalzeraniBanksBanseBanthorpeBar-onBaranowskiBarberBarellaBarendregtBarnesBarnesBarrowcliffBarryBarthesBartholowBartleBartonBatemanBauckhageBauckhageBaumgardnerBaurBavelierBavelier"
                                       "BavelierBayindir-UpmannBeanBeavisBebkoBechtoldtBeckerBeckerBeckerBeckerBeckerBeckerBehrenshausenBekebredeBekebredeBekkerBekkerBelavinaBellBenfordBenjaminBentonBenturBeresinBergerBergerBergmanBergmanBerkemeierBerlinerBernhardtBernsteinBerryBertrandBestBetzBevc"
                                       "BialystokBidarraBiddleBiddleBiddleBischofBissellBissettBiswasBittantiBittantiBizzocchiBizzocchiBizzocchiBizzocchiBizzocchiBizzochiBjornstadBj\u00f6rkBj\u00f6rkBlackBlackBlackBlahutaBlanchfieldBlascovichBlashkiBleeckerBlighBlockBlowBlumbergBlumbergBlumbergBluntBlunt"
                                       "BoalBodeBoehrerBoellstorffBoellstorffBogostBogostBogostBogostBogostBogostBojinBojinBojinBojinBoleskinaBonenfantBoningerBoningerBoonBoothBoothBoppBorderBorodziczBoronBossomaierBosworthBoudreauBousteadBouvardBovillBowersBowlesBowmanBoydBoydenBozionelosBozionelos"
                                       "BozionelosBozionelosBradleyBradleyBranchBrancoBrandBrathwaiteBrazBreglerBreidenbachBrennerBreretonBrissBristowBrockBrodyBromBrownBrownBrownBrownBrownBruderBruillardBrunerBryantBryceBryceBryceBryceBryceBryceBryceBryceBrysonBuchananBuchmanBuchmanBuckalewBuckingham"
                                       "BuckleyBuddBufanoBungayBurgessBurkBurkeBurkeBurkeBurnBurnsBuroBuroBurrillBurtBuschBuschBuseBushinskyBushmanBushmanBushmanBushmanBushnellButerButlandButlerButlerButlerBuusBuysByersByrneByronB\u00f6ttgerCaceresCagiltayCagiltayCagiltayCagiltayCaiCaldwellCallejaCalleja"
                                       "CalvertCalvertCameronCameronCameronCammaranoCampbellCampbellCampionCannon-BowersCannon-BowersCaplanCaplovitzCappelCarbonaroCardadorCareyCariniCarleyCarlsonCarrCarrCarrCarrCarrCarrCarrollCarrollCarsonCarverCaseCaseyCassellCastronovaCastronovaCastronovaCastronova"
                                       "CathcartCavanaughCavazzaCazenaveCerankoskyCeranogluChabayChadwickChaikaChaill\u00e9ChalabiChamberlainChambersChambersChampionChanChanChanChanChanChanChanChanChangChangChangChappellChappellChappellCharlesCharlesCharltonCharmanteCharskyChathamChaykaCheeCheeChenChen"
                                       "ChenChenChenChenChenChenChenChenChenChenChenChenChengChengChengCheokCheokChiChiangChienChiharaChildren NowChiouChiouChisholmChiuChiuChoChoiChoiChoiChoverChristenChristiansenChuChuangChuangClancyClarkClarkClarkClarkeClaypoolClaypoolClaypoolClaysonCleareClements"
                                       "ClippingerCloutierCoelhoCohenCohenCohenColditzColditzColditzColemanColleyCollinsColwellCombettoCompton-LillyConnollyConsalvoConsalvoConsalvoConsalvoConsalvoConsalvoConsalvoContractorContractorContractorContractorContractorContractorContractorContractorConway"
                                       "CookCookCookeCoopermanCooperstockCopierCoppolaCorlissCorlissCorlissCorreiaCorrubleCorrubleCorsiniCostaCostelloCostikyanCostikyanCourtyCoviCowanCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCrawfordCressyCrickCrissmanCroganCrogan"
                                       "CroganCrookallCruzCunninghamCunninghamCuretCurlewCutlerCzakDachseltDachseltDaleDancasterDanforthDantasDantasDantonDantonDarleyDavidsonDaviesDaviesDavisDavisDavisDavisDavisDavisDavisonDe FraineDe SchutterDeCostaDeFillippiDealDeckDekovenDelphinDelwicheDemartines"
                                       "DemersDemetriouDemirchoglyanDenegri-KnottDeneveDengDengeri-KnottDerevenskyDeshpandeDeussenDeussenDevlinDiamondDiasDiazDibbellDickeyDickeyDickeyDickeyDieckmannDietzDietzDietzDillDillDillDillenbourgDittlerDixDixitDoddDodgsonDodsworthDollmanDominickDonchinDonelan"
                                       "DonelanDonovanDoolittleDopfnerDormanDormansDourishDoveyDownesDownesDoyleDoyleDrachenDrakeDrettakisDriskellDrummondDryfhoutDuatoDuatoDucheneautDucrestDuffyDufnerDugganDuhDuretDurkinDurkinDuttonDu{\\textquoteright}MontDwyerDyer-WithefordDziabenkoELSPAELSPAEarnshaw"
                                       "EatonEbiEcclesEchtEddyEdelmannEdmondsEdmondsEdsonEdwardsEdwardsEffelsbergEffelsbergEgenfeldt-NielsenEgenfeldt-NielsenEggermontEhrenbergEikaasEisenackEkebladEklundEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEl-NasrEladhariEladhari"
                                       "ElangoEliasEllisEllisEllisonEllisonEmbreyEmesEngeliEnglandEnglandEnochssonEpsteinErikssonErlebenErmiErnkvistEspinozaEspositoEspositoEssEsselmanEstevesEtterEverettEvertsenEvstigneevaFASFASFaberFaganFakotakisFarmerFaure-PragierFazekasFederoffFedorovFeenbergFeingold"
                                       "FeixFeldmanFeldonFeldonFengFerdigFern\u00e1ndez-Manj\u00f3nFern\u00e1ndez-Manj\u00f3nFern\u00e1ndez-Manj\u00f3nFerrellFerrerFerriFerrisFeustelFicocelliFieldsFigaFinchFinkelsteinFinnFinnFinneyFirinciogullariFischerFischerFischettiFishFlaggFlahertyFlanaganFletcherFletcherFlyenFlynnFlynn"
                                       "FlynnFoleyFoleyFolmannFolmannForbisFordForemanForlinesFormentinForooshForrestForstenForteFosterFoutsFoutsFoxFoxFrancisFrascaFrascaFrascaFrascaFrascaFreemanFreemanFreyFreyFridayFriedmanFriedmanFriedmanFriesFrommeFrommeFronFukuiFullertonFullgrabeFungeFunkFunk"
                                       "FunkFunkFunkFunkFurgerFurlongFurnessFurnkranzFyfeFyfeGDCGabbardGabrielGackenbachGagnonGaileyGajicGalGalGalantucciGalarneauGalarneauGalarneauGallegoGalliniGallowayGallowayGaoGarciaMolinaGardenforsGardnerGarreltsGarreltsGeakeGeeGeeGeeGeeGeeGeeGeeGellersenGemino"
                                       "GenoveseGentileGentileGentileGenvoGermannGermannGestwickiGettmanGhellalGhersiniGibbsGiddingsGieselmannGilbertGilbertGilbertGilbertGillesGillisGingoldGiovanettoGirouxGlassGlassnerGlaubkeGleanGlissovGlithoGodwinGoebelsGoebelsGogginGoldbergerGoldsmithGoldstein"
                                       "GoldsteinGoldsteinGoldsteinGomesGonzalezGonzalezGoochGoodhewGoodithGoodmanGoodmanGoodmanGoodmanGorlatchGortmakerGorvitsGoslingGoslingGosneyGotestamGothGotsmanGottschalkGouadecGraceGraceGraceGraceGraceGrahamGrandclementGrandjeanGraner-RayGrangerGranthamGrasca"
                                       "GrazianoGrebnevaGreenGreenfieldGreenfieldGreenfieldGreenfieldGreenfieldGreenhalghGreenhalghGreenleafGreenspanGreggGregoryGriffeyGriffinGriffithGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffiths"
                                       "GriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriffithsGriggGrillGrimesGrimesGrimesGrimesGrimesGrimesGrimesGrimesGrimesGrimshawGrimshawGrimshawGrimshawGrimshawGrimshawGrimshawGrimshawGrimshawGrinterGrodalGroenGroenGrollmanGrondinGros"
                                       "GrosGrossGrossGrossGrossGrossmanGrossmanGrundyGrutzmacherGr\u00fcnvogelGuGuGuardiniGuerriniGuerriniGuinsGunkelGunkelGunterGunterGuoGuoGurrGurtnerGutwinG\u00f3mez-Mart\u00ednHackettHaddonHaddonHaddonHaddonHadfieldHaenniHagiuHagstr\u00f6mHagstr\u00f6mHainesHaineyHainleyHakkinenHakonen"
                                       "HakonenHalbrechtHalcombHallHallHallHallamHallamHallamHalloranHamalainenHamiltonHamilton-GiachritsisHanaire-BroutinHancockHanebeckHaningerHaningerHannaHanzlikHar-ElHaradaHardingHargreavesHarperHarperHarpoldHarriganHarrisHartHarteveldHarveyHasegawaHateckeHaussmann"
                                       "HawnHawthornHaydelHayesHayesHaylesHaylesHaynesHaynesHealdHeckerHeddenHeidenreichHeleHeli\u00f6Heli\u00f6HellisonHelmuthHemnesHendersonHendersonHendlerHennessyHermanHermkesHerreraHertzogHerzHerzHessHexmoorHianesHickeyHigginsHillHillHillingerHiltHiltonHirakiHiroseHjorth"
                                       "HoHoffmanHoffosHogleHoglundHolanHollandHollingsheadHolmquistHolmquistHolmstromHolzingerHoneyHooperHopsonHornHorneHorngHorrelHorshamHorswillHorswillHoshinoHoshinoHoskingHouHoutmanHoweHowellsHoweryHsiHsiaoHsiaoHsuHsuHsuHsuHsuHuHuHuangHuangHuangHuangHubbardHuber"
                                       "HuberHudiburgHuesmannHuesmannHuffHuhtamoHuizingaHumbleHumphreysHumphreysHumphreysHuntHuntHuntemannHurleyHussHutchinsonHwangHymanIDCIDSAIbrahimIbrahimIbrahimIbrahimIbrahimIbrahimIchiharaIddingsIjzermanInceInoueInteractive Digital Software AssociationIoergerIones"
                                       "Iowa InterventionIpIpIpIrvineIsbisterIsbisterIshiguroIshikawaItoItoItoIurgelIversenIvoryIvoryIvoryIwamuraIzmirliIzushiJJacksonJacksonJacobsJacobsJacobsenJacobsonJacobsonJahn-SudmannJahreJainJakobssonJamesJanszJanszJardinesJarzabekJayakanthanJayemanneJayemanne"
                                       "JehlenJellinekJenJenkinsJenkinsJenkinsJenkinsJenkinsJenkinsJenkinsJenkinsJenkinsJenkinsJenningsJensenJensonJeongJeppesenJeppesenJesselJohannessonJohanssonJohnJohnsJohnsonJohnsonJohnsonJohnsonJohnsonJohnsonJohnsonJohnssonJohnstonJoinerJoinerJolivaltJoltonJones"
                                       "JonesJonesJonesJonesJonesJonesJonesJonesJonesJordanJordanJorgensenJuhlinJuhlinJungJungJungJungJungJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJuulJ\u00e4rvinenJ\u00e4rvinenJ\u00e4rvinenJ\u00e4rvinenJ\u00e4rvinenJ\u00e4rvinenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensen"
                                       "J\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenJ\u00f8rgensenKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKafaiKahnKaipainenKaipainenKaiserKaiserKallinenKalyanaramanKalyanaramanKantorKanungoKaplanKaplanKappesKaptelininKaptelininKapuku"
                                       "KapukuKarlsson-BkarlssonKasperekKassisKataokaKatchabawKatoKaufmanKaufmanKavakliKavakliKavakliKaviKayKayamaKayeKayeKayeKayeKayeKayeKearneyKearneyKearneyKearneyKearneyKeeganKeekerKeepersKeepersKeirKeithKellyKellyKeltikangas-J\u00e4rvinenKempfKennedyKennedyKennedy"
                                       "KennedyKennedyKentKentKerbsKerrKerrKerrKerrKerrKerrKerrKerrKerrKerrKestnbaumKeumKeunekeKiernanKillenKillenKimKimKimKimKimKimKimKimKimKimKimKimKimKimKimKimataKinderKinderKinderKinderKingKingKingseppKinkleyKinnearKirklandKirkmanKirkpatrickKirks\u00e6therKirriemuir"
                                       "KirriemuirKirriemuirKirshKirshKitamotoKivikangasKizilkayaKlabbersKlabbersKlabbersKlabbersKlabbersKlassKlassKlassKlastrupKlastrupKlevjerKlevjerKlimmtKlimmtKlingemannKlionsKnaussKnightKnipphalsKnollKoKoch-MohrKohKolkoKolkoKolkoKomisarKonigsmannKonijnKonoKonrad"
                                       "KonradKonzackKooKortKorvaKoskinenKoufterosKozbeltKozmaKramerKratchmerKrautKrcmarKrcmarKreimeierKretchmerKroomanKrosnickKrugmanKrzywinskaKrzywinskaKrzywinskaKrzywinskaKrzywinskaKrzywinskaKrzywinskaKrzywinskaKuanKuhaneckKujanp\u00e4\u00e4KukafkaKullerKunichKuntscheKuo"
                                       "KuritaKurkovskyKushnerKustraKuwadaKyumaK\u00fccklichK\u00fccklichK\u00fccklichK\u00fccklichK\u00fccklichLaffLahiriLainemaLairdLairdLairdLambertLambertLamersLammesLammesLanderholmLaneyLangLangeLangeLange deLangloisLankfordLankoskiLankoskiLankoskiLapollaLarkinLarsenLarsonLarsson"
                                       "LastowkaLastowkaLastowkaLauLauLaurelLauterenLautonLauwaertLavenderLavrenkoLawsonLawtonLazzaroLeafLeanLebeltelLebramLebramLeeLeeLeeLeeLeeLeeLeeLeeLeeLeeLeeLeeLeeLeggatLehdonvirtaLehdonvirtaLehmannLeiLeighLeiteLennerforsLennonLeonardLepperLesgoldLeungLevinLevin"
                                       "LevineLevineLevineLevineLevinsonLevyLevyLewisLiLiLiLiLiangLichtiLichtmanLiebermanLiebermanLiebermanLiebermanLinLinLinLinLinLinLindbergLindbladLinderothLinderothLindleyLindleyLindleyLindleyLindleyLindleyLindleyLindleyLindleyLindleyLindleyLindlofLindmarkLindof"
                                       "LinebergerLintonenLinzieLitchinskyLittletonLiuLiuLiuLiuLivingLlauradoLoLoftusLohrLoiphaLondonLongLonguetLossadaLouckyLoviscachLowoodLowoodLowoodLowoodLowoodLowoodLowoodLuLucasLudvigsenLuepkerLundeLuritLynchLynchLytleL\u00f6ckeltL\u00f6ckeltL\u00f8vlieMacCallum-StewartMacDorman"
                                       "MacGregorMacInnesMacKenzieMacedoniaMackeyMackeyMackieMacleodMacredieMaddenMaddenMadillMadillMaedaMageeMagerkoMagnussenMagosMaherMaherMahmoodMahoneyMakinouchiMalabyMalabyMaldonadoMaldonadoMallietMaloneMaloneMaloufManciniManninenManninenManninenManninenMannisto"
                                       "ManosManovichManskeMansourMaragoudakisMarckmannMarcusMarcusMargaroneMargaroneMaria Cutumisu Matthew McNaughtonMarkMarksMarksMarksonMarriottMarshMartensMarteyMartiMartinMartinMartinMartisMart\u00edn C\u00e1ceresMaryMasendorfMastinMasuchMasuchMasuchMatarazzoMateasMateas"
                                       "MatherMathiakMatsuishiMattanMatthewsMattilaMauveMauveMawdesleyMayMayerMayerMayerkressMayhornMayoMayraMayraMazalekMazorMcAlisterMcAllisterMcAllisterMcBroomMcCabeMcCormacMcCrackenMcDonaldMcDonnellMcDougallMcDowellMcEachenMcFarlaneMcFedriesMcGonigalMcIlvaneMcKee"
                                       "McKennaMcKnightMcMurrayMcNameeMcNeeseMcShaffreyMcWilliamsMcowanMedia Analysis LaboratoryMedinaMedinaMeierMeisterMelloneMelotMemisogluMenacheMenchacaMendelsonMendizMennieMennieMergetMerolaMerrellMerzenichMeshefedjianMesserlyMetaxasMeyerMichaudMichodMiesenberger"
                                       "MiettinenMiikkulainenMike Klaas Tristram SoutheyMiklaucicMilamMilesMilesMillardMillerMillerMillerMillerMillerMillerMillerMillingtonMilnerMirrezaieMistreeMitchellMiyaokuMohanMokMollaMollerMollickMoll\u00e1Moll\u00e1MoltenbreyMonicaMonteiroMontfortMontolaMooreMooreMoore"
                                       "MooreMooreMooreMoosbruggerMorMoradMoranMordkoffMorelMorenaMorenoMoriMoriMorieMorilloMorphettMorrisMorrisMorrisMorrisonMorrowMortensenMortensenMosleyMosleyMossMoulthropMountsMountsMtenziMuellerMuijsMuirMuirMuktiMullerMulliganMulveyMumtazMurakiMurariMurphieMurphy"
                                       "MurphyMurrayMurrayMyersMyersMyersMyersMyersMyersMyllyahoM\u00e4yr\u00e4M\u00e4yr\u00e4M\u00e4yr\u00e4M\u00e4yr\u00e4M\u00fcllerNabiNackeNackeNackeNackeNackeNackrosNagenborgNahum-MoscovociNairNairNakamuraNamatameNandhakumarNapierNaquetNational School Board AssociationNattamNcubeNecessaryNecessary"
                                       "NeitzelNelsonNelsonNeoNettNeuringerNewcombeNewellNewmanNewmanNgNguyenNickellNickellNickellNickellNieborgNieborgNieborgNieborgNiedenthalNiedenthalNieuwdorpNikolovaNilsenNishitaNitscheNitscheNitscheNivensNiwaNolanNorcioNordliNordlingerNorrisNorthNortonNovakNowak"
                                       "NussbaumNussbaumNusserNymanNymanOConnorOakesOalcleyObataOblingerOchoaOffirOhOhashiOkitaOkuzumiOlczakOlczakOldsOlearyOlsenOlsonOlsonOmernickOndrejkaOoiOpalachOrtizOsakaOsborneOsofskyOstriaOstromOuhyoungOvermarsOvermarsOwenOwensO{\\textquoteright}BrienO{\\textquoteright}Donnell"
                                       "O{\\textquoteright}DonnellO{\\textquoteright}FarrellO{\\textquoteright}SullivanP. A.PacePaderewskiPagulayanPaivaPaivaPaivaPajarolaPalazziPalmerPanPanayiotopoulosPanelasPapastergiouPapastergiouParaskevaPargmanParisParisiParkParkParkerParkerParkerParkerParkinParra-Cabrera"
                                       "PasnikPastaPatePaternoPaulPaulPaulkPaunovPauschPavelPavlidisPaynePaynePearcePearcePearcePearcePearcePearcePearcePecchinendaPeinadoPeitzPellegriniPelletierPelletierPelletierPendryPengPengPepinPepplerPerezPerlinPerlinPerlinPerronPerronPerryPescePeterPetersPeterson"
                                       "PetrzelaPhillipsPiasPicardPicardPickensPicqPinchbeckPinchbeckPiringerPittsPivecPlattenPleussPlusquellecPoberPolichPollardPollardPollmullerPollockPollockPonserrePoolePopkinPopkinPopkinPopkinPopkinPorembaPorterPorterPostigoPostigoPostmaPostmaPostmaPotamianosPotts"
                                       "PowellPowerPradaPrattPreecePrendergastPrenskyPrenskyPrenskyPricePriceProbstProffittProvenzoProvenzoPrzybylskiPuertaPurushotmaPuschQuagliaraQuandtQuinnQu\u00e9auQu\u00e9retteRaessensRaessensRailtonRaisamoRaisamoRaiterRaittRajagopalanRamalhoRandellRansdellRaoRaoRaoRaschke"
                                       "RatyRatzonRauRaudenbushRavajaRayRaybournRaynauldReeley JrReeseReggiaRehakRehakReidReimannReinsteinReissRemagninoRenaudRenaudRenneckerRepenningReveillereRexfordReynoldsRhaitiRheingoldRhodesRhodyRhyneRhyneRiceRiceRichardRickardfigueroaRickwoodRiddochRiegerRimpela"
                                       "RinerRinerRitterRitterfeldRizoRobertsRobertsRobertsonRobertsonRobertsonRobertsonRobinsonRobinsonRobleyRoccettiRocheleauRockwellRockwellRodastaRodastaRodrigoRodriguezRodriguez-HenriquezRodriguez-VivesRoemmichRogersRonan Boulic Branislav UlicnyRooneyRoperRoque"
                                       "RoqueRoqueRosasRosasRosenbergRosenthalRossRossiRothermundRothkrantzRotterRouchierRoughgardenRouseRouseRouseRoussakisRuanRubinRuddRuddockRudolphRuedaRujanRuncoRushRushkoffRushkoffRushkoffRushkoffRussellRutterRutterRutterRutterRutterRutterRutterRutterRutterRutter"
                                       "RutterRutterRutterRutterRyanRyanRyanRyanRybkaR\u00f6berSaariSabouretSachdevSacherSafaeiSagererSagererSaitoSakamotoSakataSaklofskeSalazarSalenSalenSalinasSalisburySalminenSalonius-PasternakSaltzmanSalvendySalvendySalverdaSamuelSanchezSandfordSandfordSangerSangsupawanich"
                                       "SantorumSargentSastronSatohSattarSavolainenSawyerSaxeSayirScaranoScatteiaScattergoodSchaeferSchaefferSchaefferSchaefferSchaefferSchaefferScharrerSchenkSchererSchimmingSchirraSchlackSchlechtweg-JahnSchleinerSchleinerSchleinerSchlossSchlosserSchmierbachSchmoll"
                                       "SchneiderSchneiderSchottSchottSchottSchottSchottSchreierSchreinerSchulzkeSchulzrinneSchulzrinneSchusterSchutSchutSchutSchwaigerSchwartzSchwingelerScottScottScullicaSefton-GreenSegalSegalSegersSegersSeidnerSeilerSeinoSeiterSellersSelnowSelnowSeneffSeneffSengers"
                                       "SennerstenSennerstenSeoSerpanosSestirSethiSgarbossaShadeShafferShafferShafferShapiroShapkinSharpSharpSharrittSharrittSharrittSharrittSharrittSharrittSharrittShawShawSheffSheldonSheldonSheldonSheltonShenShenShenShepherdSheppardShererShererShererSheridanSherman"
                                       "ShernoffSherrySherryShewokisShewokisShifrinShihShihShihShimShinShinShinShinkleShintaniShiuShmelyovShortShumShybaSicartSicartSicartSicartSicartSicartSicartSiediSiegelSifuentesSigfusdottirSignerSiitonenSikoraSilcoxSillsSilvaSilvaSilvernSilverstoneSimonSimonSimon"
                                       "SimonSimonSimonSimonSimonsSimonsSimpsonSinclairSingerSislerSislerSislerSislerSislerSislerSislerSiuSkirrowSkoricSkrzypczykSkurzynskiSlaterSlavikSlavikSlimaneSlusallekSlusallekSmartSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmithSmith"
                                       "SmithSmithSmythSnowSoetersSokolSoldatovaSolowaySolowaySorensenSorensenSotamaaSotamaaSotamaaSotamaaSotamaaSotirchosSouvignierSpenceSpenceSpencerSpierlingSpittleSquireSquireSrivastavaSrivastavaSsuStablerStablesStahlStaldStallabrassStamatoudiStapletonStarbuckStarn"
                                       "SteeleSteimleSteinSteinbergSteinbergSteinbergSteinhardtSteinkuehlerSteinkuehlerSteinkuehlerSteinkuehlerSteinmullerStellmachStengerStephaniStephanidisSternSternSternSternSternSternStevensonStockbridgeStockburgerStockmannStoffregenStoneStoreyStorg\u00e5rdsStrangStrasburger"
                                       "StrattonStrehovecStringerStrothotteStrouseStruckStudtStumpfSuSuddendorfSuddendorfSudnowSugiyamaSuhSuhSullivanSullivanSullivanSulskySummersSunSunSunSunSuretteSuterSuthersSuthersSuttonSutton-SmithSuzorSwalwellSwalwellSwankSwannSwansonSweeneySwellerSykesSykesSykes"
                                       "SykesSzafronSzerSzulborskiTafallaTainioTakahashiTakahashiTakasakaTallalTamboriniTanTanTanakaTanenbaumTanenbaumTanenbaumTanisTantleff-DunnTapleyTashakkoriTavellaTavinorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTaylorTejadaTellermanTenhula"
                                       "TeoTerashimaTerranovaTettehThagardThaiThalemannThalmannThalmannTheintzTheodoropoulosTheodoropoulosThies-BrandnerThilmanyThissenThobenTholanderThomasThomasThomasThomasThomasThomasThomasThomasThompsonThompsonThompsonThompsonThompsonThorntonThottanTinwellTirrito"
                                       "TobiasTobiasTobiasToetToftsTolesTolinoTomesTomlinsonToriyamaTorresTorres CanteroToscaTracyTranTreiberTremblayTreniteTreniteTreniteTreniteTrentTrinkausTrivediTsaiTsaiTsai-FellanderTsunodaTsvetanovaTuckerTulupmanTurkleTurkleTurkleTurnerTurnerTurpeinenTurpeinen"
                                       "TuysuzTychsenTylerTylerTzengT\u00f6yliT\u00fcz\u00fcnUdokaUnderwoodUpitisUpitisUricchioV. KlotenVaculikVaculikVaculikVaculikValdezValentineValkyrieValkyrieVan EckVan EenwykVan LooyVan LooyVan den BulckVan den BulckVan den BulckVanEenwykVandewaterVaradyVaseekaranVasilevskii"
                                       "VasudevanVaupelVeltumVenousiouVenturiVerbraeckVerbruggeVerhoeffVerhoevenVeugenVeugenVexoVezinaVicenteVidaverVigevanoVigevanoVikVillaniVincentVitakVockingVogelVogelVoigtVorrasiVosmeerVossWaddingtonWadeWadleyWaelbroeckWaernWagnerWagnerWakefieldWakkaryWalkerWalkerdine"
                                       "WalkerdineWallerWallichWallinWallsWalshWalshWalshWaltherWaltherWalzWalzWangWangWangWangWangWardWardWardWardWardleWardrip-FruinWardynskiWarfWarkWarkWarnerWarnesWarrenWartellaWatersWatersWatersWatsonWatsonWattersWayWebbWebbWebbWebbWeberWeberWeberWeickerWeilWeiler"
                                       "WeimerWeinbrenWeinsteinWeirichWeisWeiseWeiseWeismanWeismanWeissWeissWeisscherWelburyWeldonWelsbyWengWenliWenningerWernerWerningWestermannWestmancottWhalenWhalenWhangWheatleyWhinstonWhitcombWhiteWhiteWhiteWhitfordWhitingWhitingWiederholdWiegmanWijersWiklundWilde"
                                       "WilesWilhelmssonWilkinsWillemsWillemseWillettWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsWilliamsonWilliamsonWilliamson"
                                       "WilloughbyWilsonWilsonWilsonWilsonWilsonWilsonWilsonWilsonWilsonWilsonWindischWingroveWinklerWinmanWinnicottWinogradWinterWinterWirenWitfeltWitherfordWixenWolfWolfWolfWolfWolfisWolflingWolfordWollmanWongWongWongWooWooWoodWoodsWoytiukWrightWrightWrightWuWuWu"
                                       "WuWuWyethWyethXiXiongXuXuYamadaYamaokaYanYanYanYanagiYangYangYangYeYeYeYeatesYeeYeeYeeYeeYeeYeeYehYenYokotaYoungYoungYoungYoungYoungYujiYulishZackariassonZackariassonZagalZamarianZammittoZarembaZeiglerZelinskyZengZhaiZhangZhangZhangZhaoZhengZhengZhouZhouZhou"
                                       "ZhouZhukovZieglerZieglerZielinskiZimmermanZimmermanZimmermanZimmermanZimmermanZimmermanZindalZivkovicZoiaZollZootaZubekZumbachZupkoZydaZydade Antoniode Araujode Cardalhode Castellde Castellde Castellde Freitasde Grootde Laetde Meyerde Mulde Mulde PeuterdeHaan"
                                       "deHaandeHaanvan Hornvan Lentvan Lentvan Mechelenvan Oostendorpvan Schievan de Wallevan den Herikvon Bulow-Faerbervon Salisch");
static const char *digiplayFilesUrlsDois("http://papers.ssrn.com/sol3/papers.cfm?abstract_id=1939241http://gac.sagepub.com/cgi/content/abstract/1555412010364983v110.1177/1555412010364983"
        "10.1177/155541201036498110.1177/155541201036497710.1177/155541201036498010.1177/1555412010364979http://gac.sagepub.com/cgi/content/abstract/1555412010364982v110.1177/155541201036497810.1177/1461444810370949http://gac.sagepub.com/content/6/1/61.abstracthttp://gac.sagepub.com/content/6/1/3.abstract"
        "http://gac.sagepub.com/content/6/1/17.abstracthttp://gac.sagepub.com/content/6/1/83.abstracthttp://gac.sagepub.com/content/6/1/38.abstracthttp://gac.sagepub.com/content/6/5/414.abstracthttp://gac.sagepub.com/content/6/5/453.abstracthttp://gac.sagepub.com/content/6/5/395.abstract"
        "10.1177/1555412011402675http://gac.sagepub.com/content/6/5/429.abstracthttp://eprints.ecs.soton.ac.uk/21567/http://www.uic.edu/htbin/cgiwrap/bin/ojs/index.php/fm/article/view/3624/3006http://www.uic.edu/htbin/cgiwrap/bin/ojs/index.php/fm/article/view/3517/3020"
        "10.1177/135485651039709610.1177/1354856510397111http://www.digitalcultureandeducation.com/volume-3/teaching-and-learning-english-through-digital-game-projects/http://arcticpenguin.files.wordpress.com/2011/01/pid1058556.pdfhttp://eprints.ecs.soton.ac.uk/21566/"
        "http://gac.sagepub.com/content/6/4/327.abstract10.1177/155541201039108910.1177/1555412010391091http://con.sagepub.com/content/17/3/287.abstract10.1177/1354856511407802http://www.vwobservatory.com/wp/?p=207http://con.sagepub.com/content/17/3/323.abstract10.1177/1354856511406472"
        "http://digitalcommons.bolton.ac.uk/gcct_journalspr/14/10.1016/j.chb.2010.10.018http://ecs.sagepub.com/content/14/3/299.abstract10.1177/1367549410393232http://www.amazon.co.uk/Game-Sound-Technology-Player-Interaction/dp/161692828X/ref=sr_1_1?ie=UTF8\\&qid=1294291419\\&sr=8-1"
        "http://con.sagepub.com/content/17/3/271.abstract10.1177/1354856511405766http://www.uapress.ua.edu/product/Gaming-Matters,5078.aspx10.1177/1555412010391090http://gac.sagepub.com/content/6/5/479.abstracthttp://gac.sagepub.com/content/6/4/291.abstract10.1177/1555412010391088"
        "http://gac.sagepub.com/content/6/4/373.abstract10.1177/1555412010391092http://triadicgamedesign.comhttp://www.vwobservatory.com/wp/?p=62http://con.sagepub.com/content/17/3/307.abstract10.1177/1354856511405758http://sri.sagepub.com/content/18/2/160.abstract10.1177/1553350610392064"
        "http://digitalcommons.bolton.ac.uk/cgi/viewcontent.cgi?article=1013\\&context=gcct_conferencepr10.1145/1859799.1859809http://con.sagepub.com/content/16/4/395.abstracthttp://gac.sagepub.com/cgi/content/abstract/1555412010361953v1http://gac.sagepub.com/cgi/content/abstract/1555412009359764v1"
        "http://gac.sagepub.com/cgi/content/abstract/1555412009360414v1http://gac.sagepub.com/cgi/content/abstract/1555412009359765v1http://gac.sagepub.com/cgi/content/abstract/1555412009360413v2http://gac.sagepub.com/cgi/content/abstract/1555412010364976v1http://sag.sagepub.com/cgi/content/abstract/41/3/316"
        "http://sag.sagepub.com/cgi/content/abstract/41/3/390http://sag.sagepub.com/cgi/content/abstract/41/3/341http://sag.sagepub.com/cgi/content/abstract/41/3/400http://sag.sagepub.com/cgi/content/abstract/41/3/360http://nms.sagepub.com/cgi/content/abstract/1461444809343563v1"
        "http://gac.sagepub.com/cgi/content/abstract/5/1/43http://gac.sagepub.com/cgi/content/abstract/5/1/116http://gac.sagepub.com/cgi/content/abstract/5/1/88http://gac.sagepub.com/cgi/content/abstract/5/1/64http://gac.sagepub.com/cgi/content/abstract/5/1/3http://gac.sagepub.com/cgi/content/abstract/5/1/23"
        "<Go to ISI>://000272728400001http://sag.sagepub.com/cgi/content/abstract/41/1/72http://sag.sagepub.com/cgi/content/abstract/41/1/51http://sag.sagepub.com/cgi/content/abstract/41/1/51http://sag.sagepub.com/cgi/content/abstract/41/1/94http://sag.sagepub.com/cgi/content/abstract/41/1/6"
        "http://sag.sagepub.com/cgi/content/abstract/41/1/20http://sag.sagepub.com/cgi/content/abstract/41/1/116http://pss.sagepub.com/content/21/4/463.full.pdf+htmlhttp://sag.sagepub.com/cgi/content/abstract/1046878110366070v1http://cpj.sagepub.com/cgi/content/abstract/49/4/337"
        "http://sag.sagepub.com/cgi/content/abstract/41/2/145http://sag.sagepub.com/cgi/content/abstract/41/2/238http://sag.sagepub.com/cgi/content/abstract/41/2/170http://sag.sagepub.com/cgi/content/abstract/41/2/260http://eprints.ecs.soton.ac.uk/21564/http://www.ludoscience.com/files/ressources/seriousgames_gaming20.pdf"
        "http://www.digra.org:8080/Plone/Members/malteelson/Too\\%20fast\\%20or\\%20too\\%20furious.pdf/viewhttp://sag.sagepub.com/content/41/5/743.abstracthttp://sag.sagepub.com/content/41/5/705.abstracthttp://sag.sagepub.com/content/41/5/724.abstracthttp://gac.sagepub.com/cgi/content/abstract/5/1/116"
        "http://gac.sagepub.com/cgi/content/abstract/5/1/88http://gac.sagepub.com/cgi/content/abstract/5/1/64http://gac.sagepub.com/cgi/content/abstract/5/1/3http://gac.sagepub.com/cgi/content/abstract/5/1/23http://eprints.ecs.soton.ac.uk/21669/http://portal.acm.org/ft_gateway.cfm?id=1753910\\&type=pdf\\&coll=GUIDE\\&dl=GUIDE\\&CFID=15151515\\&CFTOKEN=6184618"
        "10.1145/1753846.1753910http://eprints.ecs.soton.ac.uk/21606/http://eprints.ecs.soton.ac.uk/21563/http://eprints.ecs.soton.ac.uk/21565/http://www.professorgrace.com/documents/ACHI_paper_Music_Box2_IEEE.pdf10.1109/ACHI.2010.18http://langcom.u-shizuoka-ken.ac.jp/dehaan"
        "http://www.situatedresearch.com/CogTech14-2-15-1.pdfhttp://llt.msu.edu/vol14num2/abstracts.html$\\#$dehaanreedkuwadahttp://www.glsconference.org/2010/program/event/199http://www.glsconference.org/2010/program/event/12910.1177/1087054709347205http://www.springerlink.com/openurl.asp?genre=article\\&id=doi:10.1007/s00530-009-0174-0"
        "10.1007/s00530-009-0174-0http://www.thechineseroom.co.uk/pinchbeckbuild.pdfhttp://hci.usask.ca/publications/view.php?id=188http://portal.acm.org/citation.cfm?doid=1743666.174369310.1145/1743666.1743693http://www.informaworld.com/smpp/content~db=all~content=a922546769~frm=abslink"
        "10.1080/14626261003654509https://www.taik.fi/kirjakauppa/product_info.php?cPath=23\\&products_id=163http://www.vwobservatory.com/wp/?p=110http://www.vwobservatory.com/wp/?p=143http://www.vwobservatory.com/wp/?p=14510.1177/1555412009354727http://www.eludamos.org/index.php/eludamos/article/view/vol4no2-13"
        "http://www.business-and-management.org/paper.php?id=48http://ssrn.com/paper=158007910.1177/1555412009354728http://telearn.noe-kaleidoscope.org/open-archive/browse?resource=223210.1177/1555412010377322http://crx.sagepub.com/cgi/content/abstract/37/2/25610.1177/0093650209356394"
        "http://www.ludoliteracy.com/http://www.vwobservatory.com/wp?p=124http://dx.doi.org/10.1016/j.intcom.2010.04.00510.1016/j.intcom.2010.04.005http://hci.usask.ca/publications/view.php?id=181http://www.vwobservatory.com/wp/?p=138http://nms.sagepub.com/cgi/content/abstract/12/2/235"
        "10.1177/146144480934226710.1177/0267323110373456http://www.vwobservatory.com//wp/?p=14010.1145/1785455.1785474http://digitalcommons.bolton.ac.uk/gcct_journalspr/510.3916/C34-2010-02-07http://www.vwobservatory.com/wp/?p=126http://hdl.handle.net/1956/4287http://www.lulu.com/content/8042752"
        "http://digitalcommons.bolton.ac.uk/gcct_journalspr/13/http://langcom.u-shizuoka-ken.ac.jp/dehaan-games-language-learninghttp://bit.ly/virtualjustice10.1177/1555412009354729http://hci.usask.ca/publications/view.php?id=18210.1177/1476718X09345406http://digitalcommons.bolton.ac.uk/gcct_conferencepr/10/"
        "http://digitalcommons.bolton.ac.uk/gcct_conferencepr/9<Go to ISI>://000269646100060<Go to ISI>://000270242200004<Go to ISI>://000269941100011<Go to ISI>://000268927700003<Go to ISI>://000270656000017<Go to ISI>://000270656000006<Go to ISI>://000270336800006"
        "<Go to ISI>://000269092500016<Go to ISI>://000270627500013<Go to ISI>://000269069200039<Go to ISI>://000269069200033<Go to ISI>://000271490000012<Go to ISI>://000269069200006<Go to ISI>://000269069200040<Go to ISI>://000271910900005<Go to ISI>://000270829000002"
        "<Go to ISI>://000272073800015<Go to ISI>://000270643200003<Go to ISI>://000271447500002<Go to ISI>://000266418500018<Go to ISI>://000265774700013<Go to ISI>://000271090500003<Go to ISI>://000264505700006<Go to ISI>://000264057100001<Go to ISI>://000263825500034"
        "<Go to ISI>://000263779000039<Go to ISI>://000266763100009http://nms.sagepub.com/cgi/content/abstract/11/4/509http://nms.sagepub.com/cgi/content/abstract/11/4/621<Go to ISI>://000266632400019<Go to ISI>://000268143600001<Go to ISI>://000270221200006<Go to ISI>://000266069600003"
        "<Go to ISI>://000267622000007http://digitalcommons.bolton.ac.uk/gcct_conferencepr/12/10.1007/978-3-642-02774-1_67<Go to ISI>://000269443300005<Go to ISI>://000267628500008<Go to ISI>://000268361100001<Go to ISI>://000267720400006<Go to ISI>://000262859000016"
        "<Go to ISI>://000262105300002<Go to ISI>://000264354600009<Go to ISI>://000263701900001<Go to ISI>://000264182300011<Go to ISI>://000263701900007<Go to ISI>://000261636800035<Go to ISI>://000261931400003<Go to ISI>://000263225300002<Go to ISI>://000263251900021"
        "<Go to ISI>://000264084900012<Go to ISI>://000271397300006http://escholarship.org/uc/item/6f49r74nhttp://sag.sagepub.com/cgi/content/abstract/40/6/752http://sag.sagepub.com/cgi/content/abstract/40/6/802http://vcu.sagepub.com/cgi/content/abstract/8/3/279<Go to ISI>://000271414100005"
        "http://nms.sagepub.com/cgi/content/abstract/11/5/685http://nms.sagepub.com/cgi/content/abstract/11/5/815<Go to ISI>://000268468800003<Go to ISI>://000268812600010<Go to ISI>://000266928500007<Go to ISI>://000268377000013<Go to ISI>://000266187700017http://digitalcommons.bolton.ac.uk/gcct_conferencepr/11/"
        "<Go to ISI>://000265384800008<Go to ISI>://000265087100020http://www.bth.se/fou/forskinfo.nsf/8ea71836fbadac09c125733300214ab9/4771af1c725ee1f4c12575c500452fa2!OpenDocumenthttp://www.jesperjuul.net/text/easydifficult/10.1145/1536513.1536539http://www2.fcsh.unl.pt/docentes/hbarbas/Textos/instory_euromedia_hb_nc_2009.pdf"
        "http://www.idunn.no/file/ci/38198929/nmt_2009_04_pdf.pdfhttp://www.bth.se/fou/forskinfo.nsf/8ea71836fbadac09c125733300214ab9/55cdcbe9e175f256c12575c50057d7a0!OpenDocumenthttp://eprints.ecs.soton.ac.uk/21569/http://www.gamecareerguide.com/features/791/educational_.php"
        "http://www.liebertonline.com/doi/abs/10.1089/cpb.2009.001310.1089/cpb.2009.0013http://dmitriwilliams.com/Profanity.pdf10.1089/cpb.2008.0337http://www.gamecareerguide.com/features/776/truly_independent_game_.phphttp://underthemask.wdfiles.com/local--files/key-note/Garry\\%20Crawford.doc"
        "http://www.liebertonline.com/doi/abs/10.1089/cpb.2008.027910.1089/cpb.2008.0279http://www.humankinetics.com/SSJ/viewarticle.cfm?jid=XbPvtE4KXgVfhGMTXgAubr2cXaKymypVXeJnfe2rXcEkqkyzX\\&aid=16853\\&site=XbPvtE4KXgVfhGMTXgAubr2cXaKymypVXeJnfe2rXcEkqkyzXhttp://eprints.ecs.soton.ac.uk/21562/"
        "http://filebox.vt.edu/users/jivory/IvoryKalyanaraman2009CommReportsContentAbstractionPerceivedEffects.pdf10.1080/08934210902798536http://www.digra.org/dl/db/09287.20429.pdfhttp://www.bth.se/fou/forskinfo.nsf/17e96a0dab8ab6a1c1257457004d59ab/e0a8cdd8cfc0c7e6c125762c005557c0!OpenDocument"
        "http://www.eludamos.org/index.php/eludamos/article/view/71http://mitpress.mit.edu/catalog/item/default.asp?ttype=2\\&tid=11549<Go to ISI>://000266435000016http://facsrv.cs.depaul.edu/~jzagal/Papers/Zagal_et_al_GameReviews.pdfhttp://www.vwobservatory.com/wp/?p=203"
        "http://www.mellenpress.com/mellenpress.cfm?bookid=7897\\&pc=9http://www.vwobservatory.com/wp/?p=272http://www.jesperjuul.net/text/fearoffailing/http://www.vwobservatory.com/wp/?p=149http://www.vwobservatory.com/wp/?p=156http://www.vwobservatory.com/wp/?p=194"
        "http://www.vwobservatory.com/wp?p=161http://gamingmoms.wordpress.com/publications/http://www.digitalislam.eu/article.do?articleId=2515http://www.igi-global.com/Bookstore/TitleDetails.aspx?TitleId=448\\&DetailsType=Description10.4018/978-1-60566-352-4http://mitpress.mit.edu/catalog/item/default.asp?ttype=2\\&tid=11696"
        "http://www.informaworld.com/smpp/content~content=a909230753~db=all~jumptype=rss10.1145/1581073.1581093http://www.vwobservatory.com/wp/?p=153<Go to ISI>://000268061500012http://www.cyberchimp.co.uk/research/testoftime.htmhttp://www3.interscience.wiley.com/journal/122598460/abstract?CRETRY=1\\&SRETRY=0"
        "http://religion.info/english/interviews/article_413.shtmlhttp://www.digitalislam.eu/article.do?articleId=2550http://www.vwobservatory.com/wp/?p=151http://www.vwobservatory.com/wp/?p=201<Go to ISI>://000269212200012<Go to ISI>://000272798500001<Go to ISI>://000266634600053"
        "<Go to ISI>://000272675500019<Go to ISI>://000264269800004<Go to ISI>://000265992600006<Go to ISI>://000267262400038<Go to ISI>://000270315200005<Go to ISI>://000265769200046<Go to ISI>://000265299800005<Go to ISI>://000264525500006<Go to ISI>://000269762300005"
        "<Go to ISI>://000270735700003<Go to ISI>://000271971800004<Go to ISI>://000269930300045<Go to ISI>://000269934000015<Go to ISI>://000269191600002<Go to ISI>://000267757200037<Go to ISI>://000264525500002<Go to ISI>://000264099000003<Go to ISI>://000269034700041"
        "<Go to ISI>://000265013400005<Go to ISI>://000270937300024<Go to ISI>://000264525500005<Go to ISI>://000269930300024<Go to ISI>://000263926900004<Go to ISI>://000269961200028<Go to ISI>://000269934000019<Go to ISI>://000267512400008<Go to ISI>://000272798300002"
        "<Go to ISI>://000265530200001<Go to ISI>://000265542001617<Go to ISI>://000267731500002<Go to ISI>://000269934000033<Go to ISI>://000270531200024<Go to ISI>://000267755700030<Go to ISI>://000269034700045<Go to ISI>://000269934000036<Go to ISI>://000271451400025"
        "<Go to ISI>://000272569400001<Go to ISI>://000265103800064<Go to ISI>://000270543400017<Go to ISI>://000271485600015<Go to ISI>://000265786800035<Go to ISI>://000271509500004<Go to ISI>://000269034700036<Go to ISI>://000269934000055<Go to ISI>://000267137900044"
        "<Go to ISI>://000269934000001<Go to ISI>://000269304600068<Go to ISI>://000272585900086<Go to ISI>://000270899000038<Go to ISI>://000267137900047<Go to ISI>://000271545700064<Go to ISI>://000264744600040<Go to ISI>://000271451400051<Go to ISI>://000269972300036"
        "<Go to ISI>://000269304600065<Go to ISI>://000272165400045<Go to ISI>://000271485600009<Go to ISI>://000271485600017<Go to ISI>://000270597500078<Go to ISI>://000269934000020<Go to ISI>://000272138200006<Go to ISI>://000269212200136<Go to ISI>://000269934000002"
        "<Go to ISI>://000263872300001<Go to ISI>://000265740800001<Go to ISI>://000270884800008<Go to ISI>://000270543400092<Go to ISI>://000265736800050<Go to ISI>://000264525500011<Go to ISI>://000270434800002<Go to ISI>://000268998000029<Go to ISI>://000265679301121"
        "<Go to ISI>://000269034700034<Go to ISI>://000264137700002<Go to ISI>://000267475900003<Go to ISI>://000270204900055<Go to ISI>://000269024500055<Go to ISI>://000269034000069<Go to ISI>://000271799300069<Go to ISI>://000268378000005<Go to ISI>://000269934000026"
        "<Go to ISI>://000270315200002<Go to ISI>://000264525500001<Go to ISI>://000271922200001<Go to ISI>://000264878000024<Go to ISI>://000269212200025<Go to ISI>://000269869600013<Go to ISI>://000269034000025<Go to ISI>://000269934000034<Go to ISI>://000266594800003"
        "<Go to ISI>://000269934000024<Go to ISI>://000263788400008http://digitalcommons.bolton.ac.uk/gcct_conferencepr/7http://digitalcommons.bolton.ac.uk/gcct_conferencepr/1<Go to ISI>://000264047400007<Go to ISI>://000270196700009<Go to ISI>://000259264307693<Go to ISI>://000268325500003"
        "<Go to ISI>://000262311900005<Go to ISI>://000268949900002http://gamingmoms.wordpress.com/publications/https://bora.uib.no/bitstream/1956/3895/1/jorgensen-researching\\%20players.pdfhttp://gamescience.bth.se/download/16/https://bora.uib.no/bitstream/1956/3896/3/KJorgensen-digicult.pdf"
        "http://www.hindawi.com/GetArticle.aspx?doi=10.1155/2008/72028010.1155/2008/720280http://www.springerlink.com/content/f3560134p7017541/10.1007/978-3-540-88322-7http://gamestudies.org/0802/articles/tylerhttp://journals.sfu.ca/loading/index.php/loading/article/view/51"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/40http://journals.sfu.ca/loading/index.php/loading/article/view/50http://journals.sfu.ca/loading/index.php/loading/article/view/41http://eprints.ecs.soton.ac.uk/21568/http://journals.sfu.ca/loading/index.php/loading/article/view/43"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/52http://journals.sfu.ca/loading/index.php/loading/article/view/39http://journals.sfu.ca/loading/index.php/loading/article/view/44http://journals.sfu.ca/loading/index.php/loading/article/view/46http://www.pewinternet.org/PPF/r/263/report_display.asp"
        "http://www.eludamos.org/index.php/eludamos/article/view/50http://uisk.jinonice.cuni.cz/sisler/publications/ACM_MindTrek_Europe_2045.pdfhttp://www.digitalislam.eu/article.do?articleId=170410.1177/1367549407088333http://www.informaworld.com/smpp/content~content=a789782126~db=all~order=page"
        "10.1080/17430430701823380http://portal.acm.org/citation.cfm?id=1496984.149699810.1145/1496984.1496998http://www.eludamos.org/index.php/eludamos/article/view/38/66http://knol.google.com/k/ravi-purushotma/10-key-principles-for-designing-video/27mkxqba7b13d/2http://gamestudies.org/0802/articles/jorgensen"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/42http://judyrobertson.typepad.com/judy_robertson/files/RobertsonHowellsComputersEducationInPress.dochttp://www.palgrave-usa.com/catalog/product.aspx?isbn=0230545440http://digiplay.info/files/CoC.pdf"
        "http://uisk.jinonice.cuni.cz/sisler/publications/SislerBromEdutainment2008.pdf10.1007/978-3-540-69744-2_1http://www.islp.uni-koeln.de/venus/Material/Gloor_Schoder.pdfhttp://io-noi-aldo.sonance.net/gaming-2-0/Gaming_2_0_Thesis_lowres.pdfhttp://spnl.stanford.edu/publications/pdfs/Hoeft_2008JPsychiatrRes.pdf"
        "http://www.minkhollow.ca/KB/PhD/Thesis07/doku.php?id=thesis:mainhttp://www.ijclp.net/files/ijclp_web-doc_8-12-2008.pdfhttp://www.eludamos.org/index.php/eludamos/article/view/21http://www.liebertonline.com/doi/abs/10.1089/cpb.2007.0014http://opus.kobv.de/ubp/volltexte/2008/2455/pdf/digarec01_03.pdf"
        "http://www.uq.edu.au/emsah/mia/issues/mia126.html$\\#$grimeshttp://ja.games.free.fr/ludoscience/PDF/EtudeIDATE08_UK.pdfhttp://www.psychology.iastate.edu/~dgentile/pdfs/G2_Exemplary_Teachers_2007.pdfhttp://www.vwobservatory.com/wp/?p=205<Go to ISI>://000262977300014"
        "<Go to ISI>://000264585800012<Go to ISI>://000264585800004<Go to ISI>://000264585800009<Go to ISI>://000264585800010<Go to ISI>://000264099100001<Go to ISI>://000270113900005<Go to ISI>://000261729700004<Go to ISI>://000264099100004<Go to ISI>://000264585800005"
        "<Go to ISI>://000272333000021<Go to ISI>://000264585800001http://gac.sagepub.com/content/vol2/issue4/http://gac.sagepub.com/content/vol2/issue4/http://gac.sagepub.com/content/vol2/issue4/http://gac.sagepub.com/content/vol2/issue4/http://gac.sagepub.com/content/vol2/issue4/"
        "http://www.aera.net/meetings/Default.aspx?menu_id=24\\&id=2116http://gamescience.bth.se/download/14/http://synlab.gatech.edu/workshops/tangibleplay2007/files/IUI-workshop_TangiblePlay.pdfhttp://www.iitsec.orghttp://www.editlib.org/index.cfm/files/paper_24920.pdf?fuseaction=Reader.DownloadFullText\\&paper_id=24920"
        "http://www.iitsec.org/http://www.danpinchbeck.co.uk/ludicreality.pdfhttp://www.jesperjuul.net/text/acertainlevel/http://www.digra.org/dl/db/07311.06195.pdfhttp://www.salt.org/dc/washingtonP.asphttp://pkearney.radical.ac.nz/page2/page2.htmlhttp://www.holymeatballs.org/pdfs/P4K_Year_2-Report.pdf"
        "http://www.hindawi.com/GetPDF.aspx?doi=10.1155/2008/21678410.1155/2008/216784http://www.atypon-link.com/INT/doi/pdf/10.1386/nl.5.1.105_1http://www.jesperjuul.net/text/swapadjacent/10.1080/17493460601173366http://portal.acm.org/citation.cfm?id=1272535http://www.nsba.org/site/docs/41400/41340.pdf"
        "http://portal.acm.org/citation.cfm?id=1272516.1272537http://portal.acm.org/citation.cfm?id=1272516.1272538http://www.e-ucm.es/publications/articles.html10.1016/j.scico.2006.07.003http://langcom.u-shizuoka-ken.ac.jp/dehaanhttp://journals.sfu.ca/loading/index.php/loading/article/view/6/11"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/23/9http://journals.sfu.ca/loading/index.php/loading/article/view/5/2http://journals.sfu.ca/loading/index.php/loading/article/view/8/10http://journals.sfu.ca/loading/index.php/loading/article/view/12/15"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/24/23http://journals.sfu.ca/loading/index.php/loading/article/view/2/14http://journals.sfu.ca/loading/index.php/loading/article/view/19/16http://journals.sfu.ca/loading/index.php/loading/article/view/4/7"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/1/1http://journals.sfu.ca/loading/index.php/loading/article/view/13/17http://journals.sfu.ca/loading/index.php/loading/article/view/15/4http://journals.sfu.ca/loading/index.php/loading/article/view/18/18"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/10/21http://journals.sfu.ca/loading/index.php/loading/article/view/7/13http://journals.sfu.ca/loading/index.php/loading/article/view/17/20http://journals.sfu.ca/loading/index.php/loading/article/view/21/6"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/20/3http://journals.sfu.ca/loading/index.php/loading/article/view/16/8http://journals.sfu.ca/loading/index.php/loading/article/view/3/19http://journals.sfu.ca/loading/index.php/loading/article/view/14/12"
        "http://journals.sfu.ca/loading/index.php/loading/article/view/11/5http://www.his.se/upload/19354/HS-\\%20IKI\\%20-TR-07-001.pdfhttp://sirfragalot.com/mainsite/phd.htmlhttp://www.bcs.rochester.edu/people/daphne/csg_ps_07.pdfhttp://gac.sagepub.com/cgi/content/abstract/2/2/95"
        "http://gac.sagepub.com/cgi/content/abstract/2/1/59http://www.sussex.ac.uk/Units/spru/events/ocs/viewpaper.php?id=237http://portal.acm.org/ft_gateway.cfm?id=1228234\\&type=pdfhttp://gac.sagepub.com/cgi/content/abstract/2/3/194http://web.cs.wpi.edu/~gogo/hive/papers/Rueda_VR2007.pdf"
        "http://mitpress.mit.edu/catalog/item/default.asp?ttype=2\\&tid=11153http://pkearney.radical.ac.nz/page2/page2.htmlhttp://hci.yonsei.ac.kr/paper/eng_journal/2007-CPB-Collaborate\\%20and\\%20Share.pdfhttp://www.lit-verlag.de/isbn/3-8258-0332-2http://www2.parc.com/spl/members/bobmoore/bio/CHI2007-706-Moore-etal-FINAL.pdf"
        "http://gac.sagepub.com/cgi/content/abstract/2/3/236http://www.digitalislam.eu/http://gac.sagepub.com/cgi/content/abstract/2/2/114http://www2.parc.com/spl/members/bobmoore/research/DoingVirtuallyNothing.pdfhttp://www.cs.wpi.edu/~claypool/papers/rez/paper.pdf"
        "http://julian.togelius.com/Agapitos2007Evolving.pdfhttp://www.lingualgamers.com/thesis/http://web.cs.wpi.edu/~claypool/papers/fr/fulltext.pdfhttp://gac.sagepub.com/cgi/content/abstract/2/1/3http://www.futureofthebook.org/mckenziewark/gamertheory2.0/http://tampub.uta.fi/index.php?tiedot=202"
        "http://gac.sagepub.com/cgi/content/abstract/2/3/175http://gac.sagepub.com/cgi/content/abstract/2/1/23http://www.getrichgaming.com/http://www.techlearning.com/story/showArticle.php?articleID=196604665http://research.microsoft.com/users/kunzhou/publications/mesh-animation.pdf"
        "http://www.popsci.com/popsci/technology/d997f0209dd15110vgnvcm1000004eecbccdrcrd.htmlhttp://portal.acm.org/ft_gateway.cfm?id=1255106\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618http://www.psychology.iastate.edu/FACULTY/dgentile/pdfs/Rosser\\%20et\\%20al\\%20(2007).pdf"
        "http://www.futurelab.org.uk/resources/documents/external_publications/Teaching_with_Games_IJATL.pdfhttp://telearn.noe-kaleidoscope.org/open-archive/browse?resource=530http://www.eludamos.org/index.php/eludamos/article/view/4http://www.futurelab.org.uk/resources/publications_reports_articles/web_articles/Web_Article794"
        "http://www.1up.com/do/feature?cId=3163635http://portal.acm.org/ft_gateway.cfm?id=1255097\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618http://portal.acm.org/ft_gateway.cfm?id=1255073\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618http://www.merl.com/papers/docs/TR2006-009.pdf"
        "http://cmsprod.bgu.ac.il/NR/rdonlyres/34396BDB-6C0E-4931-A077-697451885123/38246/MicrosoftWordtom.pdfhttp://www.cigital.com/papers/download/attack-trends-EOG.pdfhttp://www.cs.unibo.it/~cpalazzi/papers/Palazzi-OOS.pdfhttp://portal.acm.org/ft_gateway.cfm?id=1255059\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618"
        "http://mitpress.mit.edu/catalog/item/default.asp?ttype=2\\&tid=11152http://www.digra.org/dl/db/07312.21221.pdfhttp://gac.sagepub.com/cgi/content/abstract/2/2/149http://jonassmith.dk/weblog/players-realm/http://portal.acm.org/ft_gateway.cfm?id=1255140\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618"
        "http://portal.acm.org/ft_gateway.cfm?id=1255051\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618http://gac.sagepub.com/cgi/content/abstract/2/1/49http://lisa.socialstudiesgames.com/productive_play.pdfhttp://www.cs.cmu.edu/~kraut/RKraut.site.files/articles/seay07-GamePlay\\&PsychologicalWellbeing.pdf"
        "http://ro.uow.edu.au/cgi/viewcontent.cgi?article=1500\\&context=infopapershttp://www.cs.cornell.edu/johannes/papers/2007/2007-SIGMOD-Games.pdfhttp://portal.acm.org/ft_gateway.cfm?id=1272399\\&type=pdf\\&coll=GUIDE\\&dl=ACM\\&CFID=15151515\\&CFTOKEN=6184618http://portal.acm.org/ft_gateway.cfm?id=1255057\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618"
        "http://www.cs.bath.ac.uk/~cspmaw/ieeesmcb.pdfhttp://www.spacetimeplay.org/http://uisk.jinonice.cuni.cz/sisler/publications/Story_Manager_Europe2045_Petri_Nets.pdf10.1007/978-3-540-77039-8http://gac.sagepub.com/cgi/content/abstract/2/3/213http://www.ee.surrey.ac.uk/CVSSP/VMRG/Publications/starck07cga.pdf"
        "http://gac.sagepub.com/cgi/content/abstract/2/3/261http://synlab.gatech.edu/papers/mazalek_ace2007_tui3d.pdfhttp://learningfromsocialworlds.wordpress.com/interview-teaching-machinima-at-schome-parkhttp://www.escapistmagazine.com/articles/view/issues/issue_121/2575-Ten-Myths-About-Serious-Games"
        "http://www.mcfarlandpub.com/book-2.php?isbn=0-7864-2832-5http://gac.sagepub.com/cgi/content/abstract/2/2/134http://ace2007.org/download/p307-bardzell.pdfhttp://portal.acm.org/ft_gateway.cfm?id=1255052\\&type=pdf\\&coll=GUIDE\\&dl=\\&CFID=15151515\\&CFTOKEN=6184618"
        "http://www.cs.uta.fi/~tarja/irisWG/cr1042165089399.pdfhttp://www.sk.tsukuba.ac.jp/SSM/libraries/pdf1051/1097.pdfhttp://www.sellmorevideogames.com/VideogameMarketingAndPR.pdfhttp://www.gamestyleguide.com/http://www.gamestyleguide.com/http://www.press.uchicago.edu/cgi-bin/hfs.cgi/00/226001.ctl"
        "http://www.youtube.com/view_play_list?p=77B70E50BFC0A98Chttp://www.jesperjuul.net/text/withoutagoal/http://www.eludamos.org/index.php/eludamos/article/view/7<Go to ISI>://000272330700011http://www.eludamos.org/index.php/eludamos/article/view/2/1http://www.eludamos.org/index.php/eludamos/article/view/9"
        "http://www.eludamos.org/index.php/eludamos/article/view/3<Go to ISI>://000272219300037http://www.eludamos.org/index.php/eludamos/article/view/8<Go to ISI>://00026712330009610.1177/104687810628794410.1177/1046878106287943http://ejov.org/Projects/408/ICE\\%202006/Training,\\%20Eductaion\\%20and\\%20Legal\\%20Issues/p49-47.pdf"
        "http://www.fas.org/gamesummit/www.comp.dit.ie/bduggan/Research/Using\\%20the\\%20Source\\%20engine\\%20for\\%20Serious\\%20Games.pdfhttp://journal.fibreculture.org/issue8/issue8_chan.htmlhttp://journal.fibreculture.org/issue8/issue8_andrews.htmlhttp://journal.fibreculture.org/issue8/issue8_hjorth.html"
        "http://www.fas.org/gamesummit/Resources/RD\\%20Games.pdfhttp://gac.sagepub.com/cgi/content/abstract/1/4/362http://www.educause.edu/apps/eq/eqm06/eqm0633.asphttp://www.futurelab.org.uk/projects/teaching_with_games/research/final_reporthttp://www.unaustralia.com/electronicpdf/Unapperley.pdf"
        "http://www.units.muohio.edu/codeconference/papers/papers/VG\\%20and\\%20project\\%20management\\%20\\%5BMcDaniel\\%20et\\%20al\\%5D.pdfhttp://www-cdn.educause.edu/ir/library/pdf/ELI3004.pdfhttp://www.zgdv.de/TIDSE06/10.1207/s15327825mcs0901_6http://www.uvka.de/univerlag/volltexte/2006/144/"
        "http://gac.sagepub.com/cgi/content/abstract/1/1/89http://www.cs.unimaas.nl/p.spronck/Pubs/DynamicScripting.pdfhttp://www.ofcom.org.uk/research/tv/reports/videoregulation/http://vrlab.epfl.ch/Publications/pdf/Salamin_Thalmann_Vexo_VRST_06.pdfhttp://gac.sagepub.com/cgi/content/abstract/1/1/62"
        "http://gac.sagepub.com/cgi/content/abstract/1/4/383http://gac.sagepub.com/cgi/content/abstract/1/4/281http://digiplay.ino/UDG/http://journal.fibreculture.org/issue8/issue8_taylor.htmlhttp://doi.ieeecomputersociety.org/10.1109/ICPR.2006.370http://www-static.cc.gatech.edu/~jp/Papers/Zagal\\%20et\\%20al\\%20-\\%20Collaborative\\%20Games\\%20-\\%20Lessons\\%20learned\\%20from\\%20boardgames.pdf"
        "http://digiplay.info/UDGhttp://gac.sagepub.com/cgi/content/abstract/1/1/41http://www.informaworld.com/smpp/content~content=a755296191~db=all~order=page10.1080/13691180600858721http://digiplay.info/UDGhttp://ajp.psychiatryonline.org/cgi/content/full/163/3/381"
        "http://connect.educause.edu/library/abstract/DigitalGameBasedLear/40614http://digiplay.info/UDGhttp://digiplay.ino/UDG/http://digiplay.info/UDGhttp://digiplay.info/UDGhttp://www.digitalislam.eu/article.do?articleId=1419http://www.peostri.army.mil/CTO/FILES/DisruptivePotential.pdf"
        "http://gac.sagepub.com/cgi/content/abstract/1/4/318http://www.nda.ac.jp/~nama/Top/Papers/research-namatame/07-01.pdfhttp://digiplay.info/UDGhttp://pediatrics.aappublications.org/cgi/content/full/118/6/e1831http://digiplay.info/UDGhttp://gac.sagepub.com/cgi/content/abstract/1/1/111"
        "http://gac.sagepub.com/cgi/content/abstract/1/4/338http://mcgraw-hill.co.uk/html/033521357X.htmlhttp://www.ctonet.org/documents/SmithR_GameImpactTheory.pdfhttp://gac.sagepub.com/cgi/content/abstract/1/1/116http://ihobo.com/WP/http://www.sfu.ca/cprost/docs/06Chee.pdf"
        "http://www.gamingcultures.comhttp://gac.sagepub.com/cgi/content/abstract/1/1/5http://www.culture-communication.unimelb.edu.au/research-students/tom-apperley.pdfhttp://gac.sagepub.comhttp://dare.ubvu.vu.nl/bitstream/1871/11014/2/HereBeDragonsbw.pdfhttp://www.atypon-link.com/INT/doi/abs/10.1386/jmpr.7.1.25/1"
        "http://digiplay.info/UDGhttp://gac.sagepub.com/cgi/content/abstract/1/3/231http://web.cs.wpi.edu/~claypool/iqp/fr-rez/paper.pdfhttp://booksonline.iospress.com/Content/View.aspx?piid=2408http://faculty-gsb.stanford.edu/nair/PDF-s/VGames_Dynamic_2006.pdfhttp://www.digitalislam.eu/article.do?articleId=1418"
        "http://userinnovation.mit.edu/papers/SIMS_R\\&D_final.pdfhttp://telearn.noe-kaleidoscope.org/open-archive/browse?resource=257http://digiplay.ino/UDG/http://gac.sagepub.com/cgi/content/abstract/1/1/29https://www.sensepublishers.com/product_info.php?products_id=202\\&osCsid=1a7"
        "http://www.lulu.com/content/376076http://doi.acm.org/10.1145/1142405.1142433http://gac.sagepub.com/cgi/content/abstract/1/1/103http://www1.umn.edu/umnnews/Feature_Stories/22Neverwinter_Nights22_in_the_classroom.htmlhttp://nms.sagepub.com/content/8/6/969.full.pdf"
        "http://papers.ssrn.com/sol3/papers.cfm?abstract_id=946987http://www.sciencedirect.com/science/article/B6V8J-4KWK0VK-1/2/29dd929f136a00e9c5cfefba1858d21chttp://jonassmith.dk/weblog/phd-plans-and-purposes/http://digiplay.info/UDGhttp://cee.nd.edu/news/documents/PracticingGoodnessReportFINAL.pdf"
        "http://doi.ieeecomputersociety.org/10.1109/ITNG.2006.110http://www.stockburger.co.uk/research/abstract.htmlhttp://www.digitalislam.eu/article.do?articleId=1423http://gac.sagepub.com/cgi/content/abstract/1/2/163http://www.charlesriver.com/Books/BookDetail.aspx?productID=124865"
        "http://eprints.nuim.ie/archive/00000436/01/GTAKerr_final06.pdfhttp://www.leaonline.com/doi/abs/10.1207/s15327825mcs0901_6http://www.rickblunt.com/phd/blunt_richard_dissertation_final.pdfhttp://www.ict.usc.edu/~leuski/publications/papers/fp674-leuski-cikm.pdf"
        "http://digiplay.info/UDGhttp://digiplay.ino/UDG/http://mitpress.mit.edu/catalog/item/default.asp?ttype=2\\&tid=10917http://www.uib.no/people/smkrk/docs/RuneKlevjer_What\\%20is\\%20the\\%20Avatar_finalprint.pdfhttp://gamestudies.org/0701/articles/malliethttp://gamestudies.org/0601/articles/montfort"
        "http://gamestudies.org/0701/articles/elnasr_niedenthal_knez_almeida_zupkohttp://gamestudies.org/0601/articles/consalvo_duttonhttp://gac.sagepub.com/cgi/content/abstract/1/1/78http://gamestudies.org/0601/articles/heide_smithhttp://gac.sagepub.com/cgi/content/abstract/1/1/68"
        "http://gac.sagepub.com/cgi/content/abstract/1/1/25http://gac.sagepub.com/cgi/content/abstract/1/3/252http://gac.sagepub.com/cgi/content/abstract/1/3/199http://journal.fibreculture.org/issue8/issue8_nieborg.htmlhttp://gamestudies.org/0701/articles/wallinhttp://gamestudies.org/0701/articles/simons"
        "http://gac.sagepub.com/cgi/content/abstract/1/1/83http://gac.sagepub.com/cgi/content/abstract/1/2/141http://journal.fibreculture.org/issue8/issue8_walther.htmlhttp://doi.acm.org/10.1145/1125451.1125774http://gamestudies.org/0601/articles/rodrigeshttp://gac.sagepub.com/cgi/content/abstract/1/1/52"
        "http://gac.sagepub.com/cgi/content/abstract/1/1/36http://gac.sagepub.com/cgi/content/abstract/1/1/119http://gac.sagepub.com/cgi/content/abstract/1/1/17http://gac.sagepub.com/cgi/content/abstract/1/1/72http://gac.sagepub.com/cgi/content/abstract/1/3/214http://gamestudies.org/0601/articles/dormans"
        "http://gamestudies.org/0701/articles/harpoldhttp://gamestudies.org/0601/articles/paulkhttp://gac.sagepub.com/cgi/content/abstract/1/1/47http://gamestudies.org/0601/articles/nghttp://gamestudies.org/0701/articles/smithhttp://gac.sagepub.com/cgi/content/abstract/1/2/127"
        "http://gac.sagepub.com/cgi/content/abstract/1/1/97http://gac.sagepub.com/cgi/content/abstract/1/1/13http://gac.sagepub.com/cgi/content/abstract/1/1/58http://gac.sagepub.com/cgi/content/abstract/1/1/107http://gac.sagepub.com/cgi/content/abstract/1/4/397http://www.oecd.org/dataoecd/19/5/34884414.pdf"
        "http://www.comp.dit.ie/bduggan/Research/games_0539.PDFhttp://homepage.mac.com/markdouglaswagner/.Public/Ibbitson.dochttp://www.digra.org/dl/db/06276.14516.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/db/06276.32151.pdfhttp://www.uta.fi/hyper/gamelab/creativegamers/"
        "www.metromagazine.com.auhttp://www.journal.fibreculture.org/issue5/kucklich.htmlhttp://portal.acm.org/citation.cfm?id=1073954http://csdl2.computer.org/persagen/DLAbsToc.jsp?resourcePath=/dl/proceedings/\\&toc=comp/proceedings/iv/2005/2397/00/2397toc.xml\\&DOI=10.1109/IV.2005.64"
        "http://www.ascilite.org.au/conferences/brisbane05/blogs/proceedings/25_Fladen.pdfhttp://www.uvka.de/univerlag/volltexte/2006/144/pdf/Digital_Game_Based_Learning.pdfhttp://www.uvka.de/univerlag/volltexte/2006/144/pdf/Digital_Game_Based_Learning.pdfhttp://ihobo.com/WP/"
        "http://www.digra.org/dl/http://www.digra.org/dl/db/06276.49210.pdfhttp://www.sapientia.pucsp.br//tde_busca/arquivo.php?codArquivo=783http://www.intelligentagent.com/http://www.digra.org/dl/db/06278.47142.pdfhttp://www.digra.org/dl/db/06276.47486.pdfhttp://www.digra.org/dl/db/06276.04067.pdf"
        "http://www.digra.org/dl/db/06276.52412.pdfhttp://www.digra.org/dl/db/06276.39174.pdfhttp://www.digra.org/dl/db/06276.00539.pdfhttp://www.digra.org/dl/db/06278.41489.pdfhttp://www.digra.org/dl/db/06278.03293.pdfhttp://csdl2.computer.org/comp/proceedings/hicss/2005/2268/07/22680191a.pdf"
        "http://www.digra.org/dl/db/06276.28131.pdfhttp://www.digra.org/dl/db/06276.50521.pdfhttp://www.digra.org/dl/db/06276.10020.pdfhttp://oak.cats.ohiou.edu/~consalvo/Cheating_good_for_you.pdfhttp://www.digra.org/dl/db/06276.58345.pdfhttp://www.digra.org/dl/db/06276.20328.pdf"
        "http://www.digra.org/dl/db/06278.50594.pdfhttp://www.digra.org/dl/db/06276.28330.pdfhttp://www.childrenyouthandmediacentre.co.uk/Pics/SimAndGameCarr.pdfhttp://www.cjc-online.ca/index.php/journal/article/view/1525/1654http://www.digra.org/dl/db/06276.21047.pdf"
        "http://www.digra.org/dl/db/06276.39565.pdfhttp://www.digra.org/dl/db/06278.11008.pdfhttp://www.digra.org/dl/db/06276.30561.pdfhttp://www.digra.org/dl/db/06278.02012.pdfhttp://www.psychology.iastate.edu/faculty/caa/abstracts/2005-2009/05CA.pdfhttp://www.digra.org/dl/db/06276.38324.pdf"
        "http://www.digra.org/dl/db/06276.55524.pdfhttp://eric.ed.gov/ERICWebPortal/custom/portlets/recordDetails/detailmini.jsp?_nfpb=true\\&_\\&ERICExtSearch_SearchValue_0=EJ737691\\&ERICExtSearch_SearchType_0=eric_accno\\&accno=EJ737691http://www.digra.org/dl/http://www.digra.org/dl/db/06278.05074.pdf"
        "http://www.digra.org/dl/db/06276.25259.pdfhttp://eprints.qut.edu.au/archive/00005010/http://www.digra.org/dl/db/06276.00216.pdfhttp://www.lcc.gatech.edu/~nitsche/download/Nitsche_machinima_DRAFT4.pdfhttp://www.gamestudies.org/0501/gruenvogel/http://www.digra.org/dl/db/06276.36533.pdf"
        "http://www.digra.org/dl/db/06276.41516.pdfhttp://www.digra.org/dl/db/06275.15203.pdfhttp://www.digra.org/dl/db/06278.34239.pdfhttp://www.digra.org/dl/db/06276.06108.pdfhttp://www.digra.org/dl/db/05150.48223http://www.digra.org/dl/db/06278.39122.pdfhttp://www.digra.org/dl/db/06276.18065.pdf"
        "http://www.darkshire.net/jhkim/rpg/theory/styles.htmlhttp://www.digra.org/dl/db/06276.44285.pdfhttp://www.digra.org/dl/db/06276.11074.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/db/06278.12199.pdfhttp://www.gamestudies.org/0501/nakamura_wirman/http://www.digra.org/dl/db/06276.04321.pdf"
        "http://www.digra.org/dl/db/06276.58368.pdfhttp://tesi.fabio.web.cs.unibo.it/Tesi/UsabilitaEVideoGiochihttp://www.psychnology.org/336.phphttp://www.fair-play.se/source.php/42930/Lancet\\%202005.pdfhttp://www.digra.org/dl/http://www.ltss.bristol.ac.uk/interact/31/INTERACT_31.pdf"
        "http://www.digra.org/dl/db/06276.35222.pdfhttp://www.i-r-i-e.net/inhalt/004/Buchanan-Ess.pdfhttp://www.digra.org/dl/http://mitpress.mit.edu/books/chapters/0262182408intro1.pdfhttp://www.digra.org/dl/db/06278.37511.pdfhttp://portal.acm.org/citation.cfm?id=1111293.1111301"
        "http://www.digra.org/dl/db/06276.47199.pdfhttp://www.digra.org/dl/db/06276.15163.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.libraryjournal.com/article/CA516033.htmlhttp://www.digra.org/dl/http://www.digra.org/dl/db/06276.13262.pdfhttp://www.digra.org/dl/"
        "http://www.digra.org/dl/db/06276.26370.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/db/06275.08442.pdfhttp://www.intellectbooks.co.uk/journals/view-Article,id=5081/http://www.digra.org/dl/http://www.digra.org/dl/db/06276.21027.pdfhttp://www.digra.org/dl/"
        "http://www.digra.org/dl/db/06276.11525.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/db/06276.30483.pdfhttp://www.digra.org/dl/db/06276.36443.pdfhttp://www.digra.org/dl/db/06276.19386.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/db/06276.06512.pdf"
        "http://www.digra.org/dl/db/06278.49263.pdfhttp://www.digra.org/dl/db/06276.54243.pdfhttp://www.digra.org/dl/db/06276.15565.pdfhttp://www.digra.org/dl/db/06276.30120.pdfhttp://www.digra.org/dl/db/06278.24323.pdfhttp://www.i-r-i-e.net/inhalt/004/Chan.pdfhttp://www.digra.org/dl/db/06276.24389.pdf"
        "http://www.digra.org/dl/db/06276.33335.pdfhttp://www.digra.org/dl/db/06278.00101.pdfhttp://www.digra.org/dl/db/06276.16354.pdfhttp://eprints.qut.edu.au/archive/00005232/http://www.law.unimelb.edu.au/cmcl/malr/10-4-4\\%20Humphreys\\%20formatted\\%20for\\%20web.pdf"
        "http://www.digra.org/dl/http://www.digra.org/dl/db/06276.19076.pdfhttp://www.cse.unr.edu/~bdbryant/papers/stanley.ieeetec05.pdfhttp://www.digra.org/dl/db/06278.40383.pdfhttp://www.i-r-i-e.net/inhalt/004/Consalvo.pdfhttp://gamestudies.org/0501/lindley/http://www.digra.org/dl/db/06276.54317.pdf"
        "http://www.digra.org/dl/db/06276.29242.pdfhttp://mitpress.mit.edu/books/chapters/0262182408chap1.pdfhttp://www.digra.org/dl/db/06276.45288.pdfhttp://www.digra.org/dl/db/06276.35072.pdfhttp://www.digra.org/dl/db/06276.22478.pdfhttp://www.digra.org/dl/db/06278.36260.pdf"
        "http://www.digra.org/dl/db/06276.43287.pdfhttp://www.digra.org/dl/db/06276.22378.pdfhttp://www.immersivegaming.com/http://www.digra.org/dl/db/06276.05114.pdfhttp://www.digra.org/dl/db/06276.09313.pdfhttp://www.digra.org/dl/db/06278.06445.pdfhttp://www.digra.org/dl/db/06278.09267.pdf"
        "http://www.socresonline.org.uk/10/1/crawford.htmlhttp://www.digra.org/dl/db/06278.14520.pdfhttp://www.digra.org/dl/db/06278.58570.pdfhttp://education.waikato.ac.nz/journal/english_journal/uploads/files/2005v4n1art3.pdfhttp://www.digra.org/dl/db/06276.11341.pdf"
        "http://www.bmj.com/cgi/content/full/bmj\\%3B331/7509/122http://www.digra.org/dl/db/06276.02460.pdfhttp://www.digra.org/dl/db/06278.08106.pdfhttp://www.digra.org/dl/db/06276.08169.pdfhttp://www.digra.org/dl/http://ir.lib.sfu.ca/handle/1892/1600?mode=fullhttp://www.digra.org/dl/db/06276.23429.pdf"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.maxwell.lambda.ele.puc-rio.br/cgi-bin/db2www/PRG_0651.D2W/SHOW?CdLinPrg=pt\\&Cont=7861:pt"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/burkehttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/pearcehttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Chen-Park.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Burk.pdf"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Kimppa-Bissett.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Larrson-Dodig-Crnkovic.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Sicart.pdfhttp://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/manninen_kujanpaa/http://www.digra.org/dl/http://www.digra.org/dl/http://ssrn.com/abstract=870634http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.cs.ubc.ca/~sulingy/540.pdfhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/ermi_mayra"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.i-r-i-e.net/inhalt/004/Warner-Raiter.pdf"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/davis_steury_pagulayan/"
        "http://ssrn.com/abstract=618982http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamesconference.org/digra2005/viewabstract.php?id=144"
        "http://www.digra.org/dl/http://www.digra.org/dl/http://www.gamestudies.org/0501/gingoldhttp://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.digra.org/dl/http://www.cvm.uiuc.edu/courses/path671/video\\%20game\\%20intro.pdf"
        "http://doi.acm.org/10.1145/985921.98606810.1145/985921.986068http://www.sisostds.org/index.php?tg=articles\\&idx=More\\&article=219\\&topics=72http://ieeexplore.ieee.org/iel5/9429/29917/01366208.pdfhttp://www.gamespace.nl/content/ISAGA_Nieborg.PDFhttp://www.clim.nl/personal/docs/final_presentation.ppt"
        "http://www.ye-brothers.com/documents/HCIGAMEDESIGN.pdfhttp://www.jesperjuul.net/text/timetoplay/http://www.techcomm-online.org/http://www.cric.ac.uk/cric/staff/Jason_Rutter/papers/ME1.pdfhttp://www.gamespot.com/features/6106009/p-1.htmlhttp://www.hollywoodreporter.com/hr/search/article_display.jsp?vnu_content_id=1000484956"
        "http://www.cs.mdx.ac.uk/research/PhDArea/j_salisbury/john_salisburys_game_design_research_symposium_and_workshop_submission.rtfhttp://doi.acm.org/10.1145/1028014.1028069http://doi.acm.org/10.1145/1028014.1028083http://citeseer.ist.psu.edu/675898.htmlhttp://informatica.uv.es/~pmorillo/papers/pmorillo_cgi04.pdf"
        "http://www.gamestudies.org/0401/rau/http://www.system.tstc.edu/forecasting/reports/dgames.asphttp://visinfo.zib.de/EVlib/Show?EVL-2004-72http://springerlink.metapress.com/openurl.asp?genre=article\\&ampissn=0302-9743\\&ampvolume=3166\\&ampspage=598http://dialnet.unirioja.es/servlet/oaiart?codigo=1335389"
        "http://www.gamestudies.org/0401/kolo/http://www.gamestudies.org/0401/woods/http://portal.acm.org/citation.cfm?id=1028078\\&dl=acm\\&coll=\\&CFID=15151515\\&CFTOKEN=6184618http://www.gamestudies.org/0401/jarvinen/http://www.gamestudies.org/0401/whalen/http://www.gamestudies.org/0401/galloway/"
        "http://doi.acm.org/10.1145/1067343.1067372http://www.digra.org/dl/db/display_html?chid=http://www.digra.org/dl/db/05150.01496http://www.digra.org/dl/db/05150.21522.pdfhttp://www.jesperjuul.net/text/gameplayerworld/http://old.imv.au.dk/eng/academic/pdf_files/Sotamaa.pdf"
        "http://www.nytimes.com/2003/12/04/technology/circuits/04modd.html?ex=1385874000\\&en=1bff37ae5c48d16b\\&ei=5007\\&partner=USERLANDhttp://www.cric.ac.uk/cric/staff/Jason_Rutter/papers/LSA.pdfhttp://www.digra.org/dl/display_html?chid=http://www.digra.org/dl/db/05150.07598"
        "http://www.psychologicalscience.org/pdf/pspi/pspi43.pdfhttp://www.igda.org/columns/ivorytower/ivory_Apr03.phphttp://www.cs.berkeley.edu/~daf/games/webpage/AIpapers/Bauckhage2003-LHL.pdfhttp://www.desq.co.uk/doomed/pdf/Making_the_case.pdfhttp://www.digra.org/dl/display_html?chid=http://www.digra.org/dl/db/05163.32071"
        "http://www.gamespace.nl/content/NieborgVanderGraaf_TogetherWeBrand_2003.pdfhttp://mcgraw-hill.co.uk/html/0072228997.htmlhttp://www.gamestudies.org/0302/castronova/http://www.digra.org/dl/display_html?chid=http://www.digra.org/dl/db/05150.01496http://www.gamestudies.org/0301/fromme/"
        "http://www.gamestudies.org/0301/fromme/http://doi.acm.org/10.1145/958720.958735http://www.gamestudies.org/0301/pearce/http://www.gamestudies.org/0302/lee/http://firstmonday.org/issues/issue8_7/gros/index.htmlhttp://www.gamestudies.org/0301/manninen/http://doi.acm.org/10.1145/950566.950575"
        "http://www.gamestudies.org/0301/kucklich/http://www.gamestudies.org/0301/carr/http://www.gamestudies.org/0301/walther/http://www.gamestudies.org/0302/frasca/http://www.gamestudies.org/0302/vanlooy/http://doi.acm.org/10.1145/950566.950583http://www.scit.wlv.ac.uk/~cm1822/ijkurt.pdf"
        "http://doi.acm.org/10.1145/950566.950595http://www.gamestudies.org/0302/taylor/http://sag.sagepub.com/cgi/reprint/33/4/441http://www.oss.net/dynamaster/file_archive/041017/96a13ea1954b4fa57ad78d790077637a/JC Herz\\%20on\\%20Harnessing\\%20the\\%20Hive\\%20Via\\%20Online Games.pdf"
        "http://www.gamesconference.org/digra2003/2003/index.php?Games+conferencehttp://portal.acm.org/http://portal.acm.org/http://portal.acm.org/http://mcgraw-hill.co.uk/html/0072226609.htmlhttp://www.gamestudies.org/0202/wright/http://citeseer.ist.psu.edu/612839.html"
        "http://gn.www.media.mit.edu/groups/gn/pubs/gender.hci.just.pdfhttp://gamepipe.usc.edu/~zyda/pubs/ShillingGameon2002.pdfhttp://digiplay.info/files/cgdc.pdfhttp://www.gamestudies.org/0202/lugo/http://www.arts.ulster.ac.uk/media/kerr/source\\%20files/text/executive\\%20summary_final\\%20report2.pdf"
        "http://www.futureofchildren.org/usr_doc/tfoc_12-2f.pdfhttp://www.rcgd.isr.umich.edu/garp/articles/durkin02.pdfwww.teem.org.uk/publications/teem_gamesined_full.pdfhttp://www.mediajournal.org/modules/pub/view.php/mediajournal-5http://dir.salon.com/story/tech/feature/2002/04/16/modding/index.html"
        "http://www.gamestudies.org/0202/smith/http://www.gamestudies.org/0102/squire/http://www.gamestudies.org/0102/editorial.htmlhttp://www.gamestudies.org/0202/editorial/http://www.gamestudies.org/0102/jarvinen/http://www.gamestudies.org/0202/kennedy/http://www.gamestudies.org/0102/newman/"
        "http://www.gamestudies.org/0202/pearce/http://www.gamestudies.org/0102/mortensen/http://www.gamestudies.org/0102/pearce/http://ntsa.metapress.com/app/home/contribution.asp?referrer=parent\\&backto=issue,6,151journal,6,7linkingpublicationresults,1:113340,1http://www.math-info.univ-paris5.fr/~bouzy/publications/CG-AISurvey.pdf"
        "http://digiplay.info/flowhttp://www.druid.dk/uploads/tx_picturedb/wp01-10.pdfhttp://www.computervisualistik.de/~schirra/Work/Papers/P01/P01-1/http://www.childrennow.org/media/video-games/2001/fair-play-2001.pdfhttp://www.technologyreview.com/Infotech/12189/"
        "http://psych-server.iastate.edu/faculty/caa/abstracts/2000-2004/00senate.pdfhttp://stevenpoole.net/blog/trigger-happier/http://www.jesperjuul.net/text/wcgcacd.htmlhttp://www.gamasutra.com/features/20000301/carson_01.htmhttp://www.gdconference.com/archives/proceedings/2000/game_papers.html"
        "http://www.childrennow.org/media/video-games/video-games-girls.pdfhttp://www.utoledo.edu/psychology/funktestimony.htmlhttp://www.mediaandthefamily.org/press/senateviolence-full.shtmlhttp://www.senate.gov/~commerce/hearings/0504hue.pdfhttp://www.senate.gov/~commerce/hearings/0504jen.pdf"
        "http://commerce.senate.gov/hearings/0321pro.pdfhttp://www.senate.gov/~commerce/hearings/0321gol.pdfhttp://www.geoffreyrockwell.com/publications/Gore.Galore.pdfhttp://www.ludology.org/articles/ludology.htmhttp://www.blackwell-synergy.com/doi/pdf/10.1111/j.1528-1157.1999.tb00903.x"
        "http://www.media-awareness.ca/english/resources/research_documents/studies/video_games/video_game_culture.cfmhttp://www.hf.uib.no/hi/espen/papers/spacehttp://www.jesperjuul.net/thesis/http://lingo.uib.no/dac98/papers/frasca.htmlhttp://lingo.uib.no/dac98/papers/kirksaether.html"
        "www.ed.ac.uk/rcss/SLIM/SLIMhome.htmlhttp://www.wired.com/wired/archive/5.01/esschilling.htmlhttp://twinpinefarm.com/pdfs/games.pdfhttp://portal.acm.org/ft_gateway.cfm?id=232852\\&type=pdf\\&coll=GUIDE\\&dl=ACM\\&CFID=15151515\\&CFTOKEN=6184618http://www.geekcomix.com/vgh/genracinequal.shtml"
        "http://portal.acm.org/citation.cfm?id=232025\\&jmp=cit\\&coll=GUIDE\\&dl=GUIDE\\&CFID=48113042\\&CFTOKEN=94606531$\\#$http://links.jstor.org/sici?sici=0024-094X(1995)28\\%3A5\\%3C403\\%3AMCGIIA\\%3E2.0.CO\\%3B2-3www.wired.com/wired/archive/2.05/tetris_pr.htmlhttp://web.archive.org/web/20000815110856/http://www.media-awareness.ca/eng/issues/violence/resource/reports/gamedoc.htm"
        "http://www.ullrich-dittler.de/Inhaltbuch1.pdfhttp://www.blackwell-synergy.com/doi/pdf/10.1111/j.0022-3840.1983.1702_61.x?cookieSet=1http://www.pubmedcentral.nih.gov/picrender.fcgi?artid=1498660\\&blobtype=pdf");
static const char *backslashLastAuthors("Doe");
static const char *backslashFilesUrlsDois("http://www.example.com/file\\_aaa1.bibhttp://www.example.com/file_aaa2.bib/tmp/file\\_bbb1.bib/tmp/file_bbb2.bib");
static const char *bug379443attachment105313IOPEXPORTBIBLastAuthors("Yuldashev");
static const char *bug379443attachment105313IOPEXPORTBIBFilesUrlsDois("http://stacks.iop.org/1748-0221/3/i=08/a=S08004");
static const char *bug21870politoLastAuthors("AlbrechtAllhoffAntosArducArendtBandhauerBassnettBeller-ReuseBergsdorfBergsdorfBergsdorfBertelsmann-StiftungBiedenkopfBiereBlommaertBlommaertBlommaertBockBockBockBockBockBockBockBockBockBohlenBohlenderBoventerBramstedtBresserBrosiusBr\u00e4uerBubenhoferBurgerBurger"
        "BurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardt"
        "BurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBurkhardtBuschBusseBusseBusseBusseBusseBusseBusseBusseBusseBusseBusseBusseBusse"
        "BusseB\u00f6ckelmannB\u00f6keB\u00f6keB\u00f6keB\u00f6keCariusCoenenCzerwickDieckmannDieckmannDieckmannDieckmannDieckmannDiekmannshenkeDiekmannshenkeDiekmannshenkeDiekmannshenkeDiekmannshenkeDongesDumontDuttD\u00f6rnerD\u00f6rnerD\u00fcrscheidD\u00fcrscheidEggsEichingerElsner-PetriElterEnglebretson"
        "EpplerEpplerEpplerEpplerEromsEromsFaircloughFaircloughFelderFischerFixFixForsterForsterForsterForsterFritzscheFrohningFuhseGanselGaugerGaugerGei\u00dflerGirnthGirnthGirnthGirnthGirnthGoodGreiffenhagenGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenig"
        "GrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrewenigGrieswelleGronkeGro\u00dfGrunerGrunerHausendorfHeringerHeringerHeringerHermannsHermannsHermannsHermannsHobergHoffmannHoinleHollyHollyHollyHollyHollyHollyHollyHollyIcklerJaffeJanuschek"
        "JungJ\u00e4ckelJ\u00e4ckelJ\u00e4gerJ\u00e4gerJ\u00e4gerJ\u00e4gerKarglKellerKepplingerKerstingKilianKilianKilianKilianKilianKilianKilianKilianKilianKilianKilianKilianKilianKilianKindelmannKindtKindtKindtKindtKindtKindtKindtKindtKindtKirstKleinKleinKleinKleinKleinKleinKleinKleinKlein"
        "KleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKlein"
        "KleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinKleinheyerKlemmKlemmKlingemannKnapeKnapeKopperschmidtKopperschmidtKopperschmidtKopperschmidtKrebsKressKrzy\u017canowskiKuhlmannKuhnK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mper"
        "K\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00e4mperK\u00fchnLangenbucherLangerLatniakLeyendeckerLiebertLiedtkeLinkeLucasLuginb\u00fchlL\u00e4zerMei\u00dfnerMei\u00dfnerMetzeltinMetzeltinMeyerMeyerMeyerMeyerMusahlM\u00fcnklerNiehrNiehrNiehrNiehrNiehr"
        "NiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNiehrNosOsterkampPanaglPapePapePapePappertPappertPappertPappertPappertPappertPappertPappertPappertPappertPappertPappertPatzeltPaulPetter-ZimmerPlatzPlettPollmannPorschP\u00f6rksenP\u00f6rksen"
        "P\u00f6rksenP\u00fcschelP\u00fcschelP\u00fcschelP\u00fcschelRaschkeReiherReissen-KoschReissen-KoschRickenbacherRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothRothenh\u00f6ferRuchtRybarczykR\u00fcttenSagerSagerSarcinelliSarcinelliSarcinelliSarcinelli"
        "SarcinelliSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSauerSaxerSchalkScharlothScharlothScharlothScharlothSchieweSchildSchildenSchlosser"
        "SchlosserSchmitt-BeckSchneiderSchoenSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchr\u00f6terSchultzeSchulzSchumannSchwerSch\u00e4ferSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffner"
        "Sch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ffnerSch\u00e4ubleSch\u00fctzScott"
        "SondereggerSpiegelSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpie\u00dfSpillnerSpitzm\u00fcllerSpitzm\u00fcllerSpitzm\u00fcllerStammenSteyerSteyerStickelStickelStra\u00dfnerSt\u00f6tzelSt\u00fcrmerSuplieTeubertTeubertTiittula"
        "TillmannTodenhagenTownsonUedingUedingUedingUedingUedingUedingVerschuerenVogtVoigtVolmertWarnkeWarnkeWarnkeWaschkuhnWeber-Sch\u00e4ferWeidacherWeidacherWeidacherWeidacherWeidacherWeidacherWei\u00dfenfelsWelanWellerWendenWengelerWengelerWengelerWengelerWengelerWengeler"
        "WengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengelerWengeler"
        "WengelerWengelerWiegandWienenWienenWimmerWinterhoff-SpurkWittk\u00e4mperWittk\u00e4mperWodakWodakWollingWongZiemZiemZiemZorbachvon Alemannvon Polenz");
static const char *bug21870politoFilesUrlsDois("http://othes.univie.ac.at/15622/1/2011-07-27_0609377.pdfhttp://www.sprichst-du-politik.de/downloads/sprichst-du-politik_Studie.pdf"
        "http://www.jostrans.org/issue17/issue17_toc.phphttp://www.bpb.de/politik/grundfragen/sprache-und-politik/42720/schlagwoerterhttp://www.gfl-journal.de/Issue_1_2011.phphttp://www.owid.de/wb/disk45/einleitung.htmlhttp://www.nhh.no/Default.aspx?ID=2242http://www.gfl-journal.de/22008/schroeter.pdf"
        "http://www.gespraechsforschung-ozs.dehttp://www.soz.uni-frankfurt.de/K.G/B5_2005_Coenen.pdfhttp://www.diss-duisburg.de/internetbibliothek/buecher/volltexte.htm");
static const char *cloudduplicatesLastAuthors("AhmedAhmedAhmedHuylebroeckHuylebroeckHuylebroeckKozirisKozirisKozirisKozirisLancellottiLancellottiLilienLilienReddyReddyReddyZhangZhangZhangZhang");
static const char *cloudduplicatesFilesUrlsDois("http://dl.acm.org/citation.cfm?id=1967425http://securlab.ing.unimo.it/papers/cloudcp2011.pdfhttp://doi.acm.org/10.1145/1967422.1967425"
        "10.1145/1967422.1967425http://dblp.uni-trier.de/db/conf/middleware/comp2009.html#CerbelaudGH09http://dl.acm.org/citation.cfm?id=1657011http://dl.acm.org/citation.cfm?id=1656980.1657011http://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=562339010.1109/SRDS.2010.28"
        "http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=5623390http://www.cs.purdue.edu/homes/bb/SRDS.pdfhttp://ieeexplore.ieee.org/stamp/stamp.jsp?arnumber=612278210.1109/ISIAS.2011.6122782http://ieeexplore.ieee.org/xpls/abs_all.jsp?arnumber=6122782http://faculty.uoit.ca/sartipi/courses/SC/w13/5.Resources/3.Cloud/OpenID%20Authentication%20As%20A%20Service%20in%20OpenStack.pdf"
        "http://dblp.uni-trier.de/db/conf/IEEEias/IEEEias2011.html#KhanYA11http://dl.acm.org/citation.cfm?id=2063973http://www.cslab.ece.ntua.gr/~ikons/on_the_elasticity_of_nosql_databases_over_cloud_management_platforms.pdfhttp://doi.acm.org/10.1145/2063576.2063973"
        "10.1145/2063576.2063973http://www.cslab.ece.ntua.gr/~dtsouma/index_files/tira_cikm_ext.pdfhttp://dblp.uni-trier.de/db/conf/cikm/cikm2011.html#KonstantinouABTK11http://dblp.uni-trier.de/db/journals/corr/corr1208.html#abs-1208-4166http://dblp.uni-trier.de/db/journals/pvldb/pvldb5.html#FloratouTDPZ12"
        "http://dl.acm.org/citation.cfm?id=2367511http://arxiv.org/pdf/1208.4166http://dl.acm.org/citation.cfm?id=2367502.2367511http://dblp.uni-trier.de/db/journals/corr/corr1207.html#abs-1207-0780http://adsabs.harvard.edu/abs/2012arXiv1207.0780Thttp://arxiv.org/abs/1207.0780"
        "http://arxiv.org/pdf/1207.0780");
