
// boobtube table generated by DK/tube_table_gen.py -- do not modify manually

struct table1d { // 1-dimensional function table
    float low;
    float high;
    float istep;
    int size;
    float data[];
};

template <int tab_size>
struct table1d_imp {
    float low;
    float high;
    float istep;
    int size;
    float data[tab_size];
    operator table1d&() const { return *(table1d*)this; }
};

static table1d_imp<200> tube_table __rt_data = {
	0.000000000000,0.780941,102.98377,200, {
	0.000000000000,0.009478055085,0.018437455077,0.027819130903,0.036718531139,
	0.045997948108,0.054828849836,0.064000542747,0.072755012913,0.081813935779,
	0.090484608482,0.099426135236,0.108006208380,0.116826129958,0.125309357714,
	0.134003875985,0.142384557655,0.150950276666,0.159223242623,0.167657157592,
	0.175817752299,0.184117236828,0.192161300783,0.200324092569,0.208247941775,
	0.216272127256,0.224072532050,0.231956530249,0.239630693271,0.247373239108,
	0.254918772806,0.262518900114,0.269933804060,0.277390828501,0.284673466737,
	0.291986968775,0.299136047396,0.306305855468,0.313320400573,0.320346574567,
	0.327225910732,0.334108725856,0.340852455195,0.347592386388,0.354200368237,
	0.360798074786,0.367270406490,0.373726717572,0.380063715322,0.386379616115,
	0.392581797301,0.398758415328,0.404826481362,0.410865073714,0.416799893682,
	0.422701834832,0.428504430206,0.434271200106,0.439942729957,0.445575903327,
	0.451117650339,0.456618885937,0.462032243483,0.467403274228,0.472689733970,
	0.477932357548,0.483093497819,0.488209567826,0.493247042718,0.498238460314,
	0.503153989443,0.508022695503,0.512818054426,0.517566022169,0.522243033431,
	0.526872261515,0.531432786293,0.535945292355,0.540391222675,0.544789037299,
	0.549122288806,0.553407449907,0.557629955158,0.561804502762,0.565918205021,
	0.569984176430,0.573991023939,0.577950449259,0.581852389968,0.585707287992,
	0.589506264716,0.593258639146,0.596956585140,0.600608421129,0.604207256055,
	0.607760517059,0.611262143318,0.614718768253,0.618125067675,0.621486968340,
	0.624799799208,0.628068857994,0.631290052380,0.634468120227,0.637599481632,
	0.640688376227,0.643731677497,0.646733181712,0.649690163221,0.652606023765,
	0.655478391849,0.658310318125,0.661099743747,0.663849406909,0.666557524548,
	0.669226556737,0.671854963475,0.674444957233,0.676995212038,0.679507719876,
	0.681981343066,0.684417877190,0.686816350052,0.689178382224,0.691503146799,
	0.693792108331,0.696044567329,0.698261849196,0.700443366050,0.702590319116,
	0.704702218148,0.706780153492,0.708823720194,0.710833909530,0.712810390943,
	0.714754067124,0.716664672306,0.718543029907,0.720388930482,0.722203126451,
	0.723985457232,0.725736611605,0.727456471283,0.729145667948,0.730804119840,
	0.732432407358,0.734030480202,0.735598872663,0.737137561458,0.738647039381,
	0.740127306269,0.741578817528,0.743001592703,0.744396053478,0.745762236126,
	0.747100531879,0.748410991139,0.749693977606,0.750949553545,0.752178057738,
	0.753379562342,0.754554383562,0.755702601738,0.756824512591,0.757920203167,
	0.758989950584,0.760033847318,0.761052153574,0.762044966154,0.763012529877,
	0.763954944928,0.764872442108,0.765765124179,0.766633209162,0.767476801714,
	0.768296108190,0.769091234563,0.769862376539,0.770609640915,0.771333213667,
	0.772033202011,0.772709783028,0.773363064017,0.773993213920,0.774600339845,
	0.775184603291,0.775746110953,0.776285017515,0.776801429084,0.777295494112,
	0.777767317981,0.778217043437,0.778644775039,0.779050650314,0.779434772923,
	0.779797275625,0.780138261136,0.780457857854,0.780732643507,0.780940625418
	}
};

double always_inline tubeclip(double x) {
    double f = fabs(x);
    f = f * tube_table.istep;
    int i = static_cast<int>(f);
    if (i < 0) {
        f = tube_table.data[0];
    } else if (i >= tube_table.size-1) {
        f = tube_table.data[tube_table.size-1];
    } else {
    f -= i;
    f = tube_table.data[i]*(1-f) + tube_table.data[i+1]*f;
    }
    return copysign(f, x);
}

