/*  xrealloc.c - abort on reallocation failure.
    Copyright (C) 1990 by Thorsten Ohl, td12@ddagsi3.bitnet

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 1, or (at your option)
    any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    $Header: e:/gnu/lib/RCS/xrealloc.c 1.0 90/09/11 01:55:28 tho Exp $
 */

/* ANSI C Prototypes */
#include <stdlib.h>

#include <gnulib.h>

void *
xrealloc (void *buffer, size_t bytes)
{
  void *ptr = (void *) realloc (buffer, bytes);

  /* Don't abort if BYTES is zero, since realloc() frees BUFFER
     in this case and returns a NULL pointer.  */

  if (ptr == NULL && bytes != 0)
    error (2, 0, "Out of memory!");

  return ptr;
}

/* 
 * Local Variables:
 * mode:C
 * ChangeLog:ChangeLog
 * compile-command:make
 * End:
 */
