/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.File;
import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.DBeaverCore;
import org.jkiss.dbeaver.core.DBeaverUI;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DBeaverActivator
extends AbstractUIPlugin {
    private static DBeaverActivator instance;
    private static File configDir;
    private ResourceBundle pluginResourceBundle;
    private ResourceBundle coreResourceBundle;
    private PrintStream debugWriter;
    private DBPPreferenceStore preferences;

    public static DBeaverActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Bundle bundle = this.getBundle();
        ModelPreferences.setMainBundle((Bundle)bundle);
        this.preferences = new BundlePreferenceStore(bundle);
        DBRFeatureRegistry.getInstance().registerFeatures(CoreFeatures.class);
        try {
            this.coreResourceBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.core.CoreResources");
            this.pluginResourceBundle = Platform.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException missingResourceException) {
            this.coreResourceBundle = null;
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownUI();
        this.shutdownCore();
        if (this.debugWriter != null) {
            this.debugWriter.close();
            this.debugWriter = null;
        }
        instance = null;
        super.stop(context);
    }

    private void shutdownUI() {
        DBeaverUI.disposeUI();
    }

    public static synchronized File getConfigurationFile(String fileName) {
        if (configDir == null) {
            configDir = DBeaverActivator.getInstance().getStateLocation().toFile();
        }
        return new File(configDir, fileName);
    }

    public static ResourceBundle getCoreResourceBundle() {
        return DBeaverActivator.getInstance().coreResourceBundle;
    }

    public static ResourceBundle getPluginResourceBundle() {
        return DBeaverActivator.getInstance().pluginResourceBundle;
    }

    public DBPPreferenceStore getPreferences() {
        return this.preferences;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    private void shutdownCore() {
        try {
            if (DBeaverCore.instance != null) {
                DBeaverCore.instance.dispose();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Internal error after shutdown process:" + e.getMessage());
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DBeaverActivator.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.core", (String)path);
    }
}

