/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.log;

import java.util.Objects;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.qm.QMEventFilter;
import org.jkiss.dbeaver.model.qm.QMMetaEvent;
import org.jkiss.dbeaver.model.qm.meta.QMMObject;
import org.jkiss.dbeaver.model.qm.meta.QMMSessionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementExecuteInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMStatementInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionInfo;
import org.jkiss.dbeaver.model.qm.meta.QMMTransactionSavepointInfo;
import org.jkiss.dbeaver.ui.editors.sql.SQLEditor;

class SQLLogFilter
implements QMEventFilter {
    private SQLEditor editor;

    public SQLLogFilter(SQLEditor editor) {
        this.editor = editor;
    }

    public boolean accept(QMMetaEvent event) {
        QMMObject object = event.getObject();
        if (object instanceof QMMSessionInfo) {
            return this.editor.getDataSourceContainer() != null && Objects.equals(((QMMSessionInfo)object).getContainerId(), this.editor.getDataSourceContainer().getId());
        }
        if (object instanceof QMMStatementExecuteInfo) {
            return this.belongsToEditor(((QMMStatementExecuteInfo)object).getStatement().getSession());
        }
        if (object instanceof QMMStatementInfo) {
            return this.belongsToEditor(((QMMStatementInfo)object).getSession());
        }
        if (object instanceof QMMTransactionInfo) {
            return this.belongsToEditor(((QMMTransactionInfo)object).getSession());
        }
        if (object instanceof QMMTransactionSavepointInfo) {
            return this.belongsToEditor(((QMMTransactionSavepointInfo)object).getTransaction().getSession());
        }
        return false;
    }

    private boolean belongsToEditor(QMMSessionInfo session) {
        String containerId = session.getContainerId();
        String contextName = session.getContextName();
        DBCExecutionContext executionContext = this.editor.getExecutionContext();
        return executionContext != null && Objects.equals(executionContext.getDataSource().getContainer().getId(), containerId) && Objects.equals(executionContext.getContextName(), contextName);
    }
}

