/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.type;

import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;

public class AmbiguousType
implements DiagnosticResult {
    final Path cipherDir;
    final Set<CiphertextFileType> possibleTypes;

    AmbiguousType(Path cipherDir, Set<CiphertextFileType> possibleTypes) {
        this.cipherDir = cipherDir;
        this.possibleTypes = possibleTypes;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.CRITICAL;
    }

    @Override
    public String toString() {
        return String.format("Node %s of ambiguous type. Possible types are: %s", this.cipherDir, this.possibleTypes);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.cipherDir.toString(), "Possible Types", this.possibleTypes.toString());
    }
}

