/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import com.google.common.io.BaseEncoding;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.cryptomator.cryptofs.CryptoPathMapper;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.common.CiphertextFileType;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileNameCryptor;
import org.cryptomator.cryptolib.api.Masterkey;

public class OrphanDir
implements DiagnosticResult {
    private static final String FILE_PREFIX = "file";
    private static final String DIR_PREFIX = "directory";
    private static final String SYMLINK_PREFIX = "symlink";
    private static final String LONG_NAME_SUFFIX_BASE = "_withVeryLongName";
    final Path dir;

    OrphanDir(Path dir) {
        this.dir = dir;
    }

    @Override
    public DiagnosticResult.Severity getSeverity() {
        return DiagnosticResult.Severity.WARN;
    }

    @Override
    public String toString() {
        return String.format("Orphan directory: %s", this.dir);
    }

    @Override
    public Map<String, String> details() {
        return Map.of("Encrypted Path", this.dir.toString());
    }

    @Override
    public void fix(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor) throws IOException {
        MessageDigest sha1 = OrphanDir.getSha1MessageDigest();
        String runId = Integer.toString((short)UUID.randomUUID().getMostSignificantBits(), 32);
        Path dataDir = pathToVault.resolve("d");
        Path orphanedDir = dataDir.resolve(this.dir);
        String orphanDirIdHash = this.dir.getParent().getFileName().toString() + this.dir.getFileName().toString();
        Path recoveryDir = this.prepareRecoveryDir(pathToVault, cryptor.fileNameCryptor());
        if (recoveryDir.toAbsolutePath().equals(orphanedDir.toAbsolutePath())) {
            return;
        }
        CryptoPathMapper.CiphertextDirectory stepParentDir = this.prepareStepParent(dataDir, recoveryDir, cryptor.fileNameCryptor(), orphanDirIdHash);
        AtomicInteger fileCounter = new AtomicInteger(1);
        AtomicInteger dirCounter = new AtomicInteger(1);
        AtomicInteger symlinkCounter = new AtomicInteger(1);
        String longNameSuffix = OrphanDir.createClearnameToBeShortened(config.getShorteningThreshold());
        try (DirectoryStream<Path> orphanedContentStream = Files.newDirectoryStream(orphanedDir);){
            for (Path orphanedResource : orphanedContentStream) {
                String newClearName = (switch (OrphanDir.determineCiphertextFileType(orphanedResource)) {
                    default -> throw new IncompatibleClassChangeError();
                    case CiphertextFileType.FILE -> FILE_PREFIX + fileCounter.getAndIncrement();
                    case CiphertextFileType.DIRECTORY -> DIR_PREFIX + dirCounter.getAndIncrement();
                    case CiphertextFileType.SYMLINK -> SYMLINK_PREFIX + symlinkCounter.getAndIncrement();
                }) + "_" + runId;
                this.adoptOrphanedResource(orphanedResource, newClearName, stepParentDir, cryptor.fileNameCryptor(), longNameSuffix, sha1);
            }
        }
        Files.delete(orphanedDir);
    }

    Path prepareRecoveryDir(Path pathToVault, FileNameCryptor cryptor) throws IOException {
        Path dataDir = pathToVault.resolve("d");
        String rootDirHash = cryptor.hashDirectoryId("");
        Path vaultCipherRootPath = dataDir.resolve(rootDirHash.substring(0, 2)).resolve(rootDirHash.substring(2)).toAbsolutePath();
        String cipherRecoveryDirName = OrphanDir.convertClearToCiphertext(cryptor, "CRYPTOMATOR_RECOVERY", "");
        Path cipherRecoveryDirFile = vaultCipherRootPath.resolve(cipherRecoveryDirName + "/dir.c9r");
        if (Files.notExists(cipherRecoveryDirFile, LinkOption.NOFOLLOW_LINKS)) {
            Files.createDirectories(cipherRecoveryDirFile.getParent(), new FileAttribute[0]);
            Files.writeString(cipherRecoveryDirFile, (CharSequence)"recovery", StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        } else {
            String uuid = Files.readString(cipherRecoveryDirFile, StandardCharsets.UTF_8);
            if (!"recovery".equals(uuid)) {
                throw new FileAlreadyExistsException("Directory /CRYPTOMATOR_RECOVERY already exists, but with wrong directory id.");
            }
        }
        String recoveryDirHash = cryptor.hashDirectoryId("recovery");
        Path cipherRecoveryDir = dataDir.resolve(recoveryDirHash.substring(0, 2)).resolve(recoveryDirHash.substring(2)).toAbsolutePath();
        Files.createDirectories(cipherRecoveryDir, new FileAttribute[0]);
        return cipherRecoveryDir;
    }

    CryptoPathMapper.CiphertextDirectory prepareStepParent(Path dataDir, Path cipherRecoveryDir, FileNameCryptor cryptor, String clearStepParentDirName) throws IOException {
        String stepParentUUID;
        String cipherStepParentDirName = OrphanDir.convertClearToCiphertext(cryptor, clearStepParentDirName, "recovery");
        Path cipherStepParentDirFile = cipherRecoveryDir.resolve(cipherStepParentDirName + "/dir.c9r");
        if (Files.exists(cipherStepParentDirFile, LinkOption.NOFOLLOW_LINKS)) {
            stepParentUUID = Files.readString(cipherStepParentDirFile, StandardCharsets.UTF_8);
        } else {
            Files.createDirectories(cipherStepParentDirFile.getParent(), new FileAttribute[0]);
            stepParentUUID = UUID.randomUUID().toString();
            Files.writeString(cipherStepParentDirFile, (CharSequence)stepParentUUID, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW, StandardOpenOption.WRITE);
        }
        String stepParentDirHash = cryptor.hashDirectoryId(stepParentUUID);
        Path stepParentDir = dataDir.resolve(stepParentDirHash.substring(0, 2)).resolve(stepParentDirHash.substring(2)).toAbsolutePath();
        Files.createDirectories(stepParentDir, new FileAttribute[0]);
        return new CryptoPathMapper.CiphertextDirectory(stepParentUUID, stepParentDir);
    }

    void adoptOrphanedResource(Path oldCipherPath, String newClearname, CryptoPathMapper.CiphertextDirectory stepParentDir, FileNameCryptor cryptor, String longNameSuffix, MessageDigest sha1) throws IOException {
        if (oldCipherPath.toString().endsWith(".c9s")) {
            String newCipherName = OrphanDir.convertClearToCiphertext(cryptor, newClearname + longNameSuffix, stepParentDir.dirId);
            String deflatedName = BaseEncoding.base64Url().encode(sha1.digest(newCipherName.getBytes(StandardCharsets.UTF_8))) + ".c9s";
            Path targetPath = stepParentDir.path.resolve(deflatedName);
            Files.move(oldCipherPath, targetPath, new CopyOption[0]);
            try (SeekableByteChannel fc = Files.newByteChannel(targetPath.resolve("name.c9s"), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                fc.write(ByteBuffer.wrap(newCipherName.getBytes(StandardCharsets.UTF_8)));
            }
        } else {
            String newCipherName = OrphanDir.convertClearToCiphertext(cryptor, newClearname, stepParentDir.dirId);
            Path targetPath = stepParentDir.path.resolve(newCipherName);
            Files.move(oldCipherPath, targetPath, new CopyOption[0]);
        }
    }

    private static String createClearnameToBeShortened(int threshold) {
        int neededLength = (threshold - 4) / 4 * 3 - 16;
        return LONG_NAME_SUFFIX_BASE.repeat(neededLength % LONG_NAME_SUFFIX_BASE.length() + 1);
    }

    private static String convertClearToCiphertext(FileNameCryptor cryptor, String clearTextName, String dirId) {
        return cryptor.encryptFilename(BaseEncoding.base64Url(), clearTextName, (byte[][])new byte[][]{dirId.getBytes(StandardCharsets.UTF_8)}) + ".c9r";
    }

    private static CiphertextFileType determineCiphertextFileType(Path ciphertextPath) {
        if (Files.exists(ciphertextPath.resolve("dir.c9r"), LinkOption.NOFOLLOW_LINKS)) {
            return CiphertextFileType.DIRECTORY;
        }
        if (Files.exists(ciphertextPath.resolve("symlink.c9r"), LinkOption.NOFOLLOW_LINKS)) {
            return CiphertextFileType.SYMLINK;
        }
        return CiphertextFileType.FILE;
    }

    private static MessageDigest getSha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Every JVM needs to provide a SHA1 implementation.");
        }
    }
}

