/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptofs.health.dirid;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.cryptomator.cryptofs.VaultConfig;
import org.cryptomator.cryptofs.health.api.CheckFailed;
import org.cryptomator.cryptofs.health.api.DiagnosticResult;
import org.cryptomator.cryptofs.health.api.HealthCheck;
import org.cryptomator.cryptofs.health.dirid.DirIdCollision;
import org.cryptomator.cryptofs.health.dirid.EmptyDirFile;
import org.cryptomator.cryptofs.health.dirid.HealthyDir;
import org.cryptomator.cryptofs.health.dirid.MissingDirectory;
import org.cryptomator.cryptofs.health.dirid.ObeseDirFile;
import org.cryptomator.cryptofs.health.dirid.OrphanDir;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.Masterkey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirIdCheck
implements HealthCheck {
    private static final Logger LOG = LoggerFactory.getLogger(DirIdCheck.class);
    private static final int MAX_TRAVERSAL_DEPTH = 4;
    private static final String CHECK_NAME = "Directory Check";

    @Override
    public String name() {
        return CHECK_NAME;
    }

    @Override
    public void check(Path pathToVault, VaultConfig config, Masterkey masterkey, Cryptor cryptor, Consumer<DiagnosticResult> resultCollector) {
        Path dataDirPath = pathToVault.resolve("d");
        DirVisitor dirVisitor = new DirVisitor(dataDirPath, resultCollector);
        try {
            Files.walkFileTree(dataDirPath, Set.of(), 4, dirVisitor);
        }
        catch (IOException e) {
            LOG.error("Traversal of data dir failed.", (Throwable)e);
            resultCollector.accept(new CheckFailed("Traversal of data dir failed. See log for details."));
            return;
        }
        Iterator<Map.Entry<String, Path>> iter = dirVisitor.dirIds.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, Path> entry = iter.next();
            String dirId2 = entry.getKey();
            Path dirIdFile2 = entry.getValue();
            String hashedDirId = cryptor.fileNameCryptor().hashDirectoryId(dirId2);
            Path expectedDir = Path.of(hashedDirId.substring(0, 2), hashedDirId.substring(2));
            boolean foundDir = dirVisitor.secondLevelDirs.remove(expectedDir);
            if (!foundDir) continue;
            iter.remove();
            resultCollector.accept(new HealthyDir(dirId2, dirIdFile2, expectedDir));
        }
        dirVisitor.dirIds.forEach((dirId, dirIdFile) -> resultCollector.accept(new MissingDirectory((String)dirId, (Path)dirIdFile)));
        dirVisitor.secondLevelDirs.forEach(dir -> resultCollector.accept(new OrphanDir((Path)dir)));
    }

    static class DirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path dataDirPath;
        private final Consumer<DiagnosticResult> resultCollector;
        public final Map<String, Path> dirIds = new HashMap<String, Path>();
        public final Set<Path> secondLevelDirs = new HashSet<Path>();

        public DirVisitor(Path dataDirPath, Consumer<DiagnosticResult> resultCollector) {
            this.dataDirPath = dataDirPath;
            this.resultCollector = resultCollector;
            this.dirIds.put("", null);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if ("dir.c9r".equals(file.getFileName().toString())) {
                return this.visitDirFile(file, attrs);
            }
            return FileVisitResult.CONTINUE;
        }

        private FileVisitResult visitDirFile(Path file, BasicFileAttributes attrs) throws IOException {
            assert ("dir.c9r".equals(file.getFileName().toString()));
            if (attrs.size() > 36L) {
                LOG.warn("Encountered dir.c9r file of size {}", (Object)attrs.size());
                this.resultCollector.accept(new ObeseDirFile(file, attrs.size()));
            } else if (attrs.size() == 0L) {
                LOG.warn("Empty dir.c9r file.", (Object)file);
                this.resultCollector.accept(new EmptyDirFile(file));
            } else {
                byte[] bytes = Files.readAllBytes(file);
                String dirId = new String(bytes, StandardCharsets.UTF_8);
                if (this.dirIds.containsKey(dirId)) {
                    Path otherFile = this.dirIds.get(dirId);
                    LOG.warn("Same directory ID used by {} and {}", (Object)file, (Object)otherFile);
                    this.resultCollector.accept(new DirIdCollision(dirId, file, otherFile));
                } else {
                    this.dirIds.put(dirId, file);
                }
            }
            return FileVisitResult.SKIP_SIBLINGS;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            Path relPath = this.dataDirPath.relativize(dir);
            if (relPath.getNameCount() == 2) {
                this.secondLevelDirs.add(relPath);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

