/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.cryptolib.common;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.crypto.Mac;
import org.cryptomator.cryptolib.common.DestroyableSecretKey;
import org.cryptomator.cryptolib.common.MacSupplier;

public class Scrypt {
    private static final int P = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] scrypt(CharSequence passphrase, byte[] salt, int costParam, int blockSize, int keyLengthInBytes) {
        ByteBuffer buf = StandardCharsets.UTF_8.encode(CharBuffer.wrap(passphrase));
        byte[] pw = new byte[buf.remaining()];
        buf.get(pw);
        try {
            byte[] byArray = Scrypt.scrypt(pw, salt, costParam, blockSize, keyLengthInBytes);
            return byArray;
        }
        finally {
            Arrays.fill(pw, (byte)0);
            buf.rewind();
            buf.put(pw);
        }
    }

    public static byte[] scrypt(byte[] passphrase, byte[] salt, int costParam, int blockSize, int keyLengthInBytes) {
        if (costParam < 2 || (costParam & costParam - 1) != 0) {
            throw new IllegalArgumentException("N must be a power of 2 greater than 1");
        }
        if (costParam > 0xFFFFFF / blockSize) {
            throw new IllegalArgumentException("Parameter N is too large");
        }
        if (blockSize > 0xFFFFFF) {
            throw new IllegalArgumentException("Parameter r is too large");
        }
        try (DestroyableSecretKey key = new DestroyableSecretKey(passphrase, "HmacSHA256");){
            Mac mac = MacSupplier.HMAC_SHA256.withKey(key);
            byte[] DK = new byte[keyLengthInBytes];
            byte[] B = new byte[128 * blockSize * 1];
            byte[] XY = new byte[256 * blockSize];
            byte[] V = new byte[128 * blockSize * costParam];
            Scrypt.pbkdf2(mac, salt, 1, B, 128 * blockSize);
            for (int i = 0; i < 1; ++i) {
                Scrypt.smix(B, i * 128 * blockSize, blockSize, costParam, V, XY);
            }
            Scrypt.pbkdf2(mac, B, 1, DK, keyLengthInBytes);
            byte[] byArray = DK;
            return byArray;
        }
    }

    private static void pbkdf2(Mac mac, byte[] S, int c, byte[] DK, int dkLen) {
        int hLen = mac.getMacLength();
        if ((double)dkLen > (Math.pow(2.0, 32.0) - 1.0) * (double)hLen) {
            throw new IllegalArgumentException("Requested key length too long");
        }
        byte[] T = new byte[hLen];
        byte[] block1 = new byte[S.length + 4];
        int l = (int)Math.ceil((double)dkLen / (double)hLen);
        int r = dkLen - (l - 1) * hLen;
        System.arraycopy(S, 0, block1, 0, S.length);
        for (int i = 1; i <= l; ++i) {
            block1[S.length + 0] = (byte)(i >> 24 & 0xFF);
            block1[S.length + 1] = (byte)(i >> 16 & 0xFF);
            block1[S.length + 2] = (byte)(i >> 8 & 0xFF);
            block1[S.length + 3] = (byte)(i >> 0 & 0xFF);
            byte[] U = mac.doFinal(block1);
            System.arraycopy(U, 0, T, 0, hLen);
            for (int j = 1; j < c; ++j) {
                U = mac.doFinal(U);
                for (int k = 0; k < hLen; ++k) {
                    int n = k;
                    T[n] = (byte)(T[n] ^ U[k]);
                }
            }
            System.arraycopy(T, 0, DK, (i - 1) * hLen, i == l ? r : hLen);
        }
    }

    private static void smix(byte[] B, int Bi, int r, int N, byte[] V, byte[] XY) {
        int i;
        int Xi = 0;
        int Yi = 128 * r;
        System.arraycopy(B, Bi, XY, Xi, 128 * r);
        for (i = 0; i < N; ++i) {
            System.arraycopy(XY, Xi, V, i * (128 * r), 128 * r);
            Scrypt.blockmixSalsa8(XY, Xi, Yi, r);
        }
        for (i = 0; i < N; ++i) {
            int j = Scrypt.integerify(XY, Xi, r) & N - 1;
            Scrypt.blockxor(V, j * (128 * r), XY, Xi, 128 * r);
            Scrypt.blockmixSalsa8(XY, Xi, Yi, r);
        }
        System.arraycopy(XY, Xi, B, Bi, 128 * r);
    }

    private static void blockmixSalsa8(byte[] BY, int Bi, int Yi, int r) {
        int i;
        byte[] X = new byte[64];
        System.arraycopy(BY, Bi + (2 * r - 1) * 64, X, 0, 64);
        for (i = 0; i < 2 * r; ++i) {
            Scrypt.blockxor(BY, i * 64, X, 0, 64);
            Scrypt.salsa20_8(X);
            System.arraycopy(X, 0, BY, Yi + i * 64, 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + i * 2 * 64, BY, Bi + i * 64, 64);
        }
        for (i = 0; i < r; ++i) {
            System.arraycopy(BY, Yi + (i * 2 + 1) * 64, BY, Bi + (i + r) * 64, 64);
        }
    }

    private static int r(int a, int b) {
        return a << b | a >>> 32 - b;
    }

    private static void salsa20_8(byte[] B) {
        int i;
        int[] B32 = new int[16];
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            B32[i] = (B[i * 4 + 0] & 0xFF) << 0;
            int n = i;
            B32[n] = B32[n] | (B[i * 4 + 1] & 0xFF) << 8;
            int n2 = i;
            B32[n2] = B32[n2] | (B[i * 4 + 2] & 0xFF) << 16;
            int n3 = i;
            B32[n3] = B32[n3] | (B[i * 4 + 3] & 0xFF) << 24;
        }
        System.arraycopy(B32, 0, x, 0, 16);
        for (i = 8; i > 0; i -= 2) {
            x[4] = x[4] ^ Scrypt.r(x[0] + x[12], 7);
            x[8] = x[8] ^ Scrypt.r(x[4] + x[0], 9);
            x[12] = x[12] ^ Scrypt.r(x[8] + x[4], 13);
            x[0] = x[0] ^ Scrypt.r(x[12] + x[8], 18);
            x[9] = x[9] ^ Scrypt.r(x[5] + x[1], 7);
            x[13] = x[13] ^ Scrypt.r(x[9] + x[5], 9);
            x[1] = x[1] ^ Scrypt.r(x[13] + x[9], 13);
            x[5] = x[5] ^ Scrypt.r(x[1] + x[13], 18);
            x[14] = x[14] ^ Scrypt.r(x[10] + x[6], 7);
            x[2] = x[2] ^ Scrypt.r(x[14] + x[10], 9);
            x[6] = x[6] ^ Scrypt.r(x[2] + x[14], 13);
            x[10] = x[10] ^ Scrypt.r(x[6] + x[2], 18);
            x[3] = x[3] ^ Scrypt.r(x[15] + x[11], 7);
            x[7] = x[7] ^ Scrypt.r(x[3] + x[15], 9);
            x[11] = x[11] ^ Scrypt.r(x[7] + x[3], 13);
            x[15] = x[15] ^ Scrypt.r(x[11] + x[7], 18);
            x[1] = x[1] ^ Scrypt.r(x[0] + x[3], 7);
            x[2] = x[2] ^ Scrypt.r(x[1] + x[0], 9);
            x[3] = x[3] ^ Scrypt.r(x[2] + x[1], 13);
            x[0] = x[0] ^ Scrypt.r(x[3] + x[2], 18);
            x[6] = x[6] ^ Scrypt.r(x[5] + x[4], 7);
            x[7] = x[7] ^ Scrypt.r(x[6] + x[5], 9);
            x[4] = x[4] ^ Scrypt.r(x[7] + x[6], 13);
            x[5] = x[5] ^ Scrypt.r(x[4] + x[7], 18);
            x[11] = x[11] ^ Scrypt.r(x[10] + x[9], 7);
            x[8] = x[8] ^ Scrypt.r(x[11] + x[10], 9);
            x[9] = x[9] ^ Scrypt.r(x[8] + x[11], 13);
            x[10] = x[10] ^ Scrypt.r(x[9] + x[8], 18);
            x[12] = x[12] ^ Scrypt.r(x[15] + x[14], 7);
            x[13] = x[13] ^ Scrypt.r(x[12] + x[15], 9);
            x[14] = x[14] ^ Scrypt.r(x[13] + x[12], 13);
            x[15] = x[15] ^ Scrypt.r(x[14] + x[13], 18);
        }
        for (i = 0; i < 16; ++i) {
            B32[i] = x[i] + B32[i];
        }
        for (i = 0; i < 16; ++i) {
            B[i * 4 + 0] = (byte)(B32[i] >> 0 & 0xFF);
            B[i * 4 + 1] = (byte)(B32[i] >> 8 & 0xFF);
            B[i * 4 + 2] = (byte)(B32[i] >> 16 & 0xFF);
            B[i * 4 + 3] = (byte)(B32[i] >> 24 & 0xFF);
        }
    }

    private static void blockxor(byte[] S, int Si, byte[] D, int Di, int len) {
        for (int i = 0; i < len; ++i) {
            int n = Di + i;
            D[n] = (byte)(D[n] ^ S[Si + i]);
        }
    }

    private static int integerify(byte[] B, int Bi, int r) {
        int n = (B[(Bi += (2 * r - 1) * 64) + 0] & 0xFF) << 0;
        n |= (B[Bi + 1] & 0xFF) << 8;
        n |= (B[Bi + 2] & 0xFF) << 16;
        return n |= (B[Bi + 3] & 0xFF) << 24;
    }
}

