/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.frontend.webdav.mount;

import java.net.URI;
import java.nio.file.Path;
import java.util.Optional;
import org.cryptomator.frontend.webdav.mount.MountParams;

public interface Mounter {
    public Mount mount(URI var1, MountParams var2) throws CommandFailedException;

    @FunctionalInterface
    public static interface Revealer {
        public void reveal(Path var1) throws Exception;
    }

    public static class UnsupportedSystemException
    extends CommandFailedException {
        private static final String MESSAGE = "No applicable mounting strategy found for this system.";
        private final URI uri;

        public UnsupportedSystemException(URI uri) {
            super(MESSAGE);
            this.uri = uri;
        }

        public URI getUri() {
            return this.uri;
        }
    }

    public static class CommandFailedException
    extends Exception {
        public CommandFailedException(String message) {
            super(message);
        }

        public CommandFailedException(Throwable cause) {
            super(cause);
        }
    }

    public static interface UnmountOperation {
        public void unmount() throws CommandFailedException;
    }

    public static interface Mount
    extends UnmountOperation {
        default public Optional<Path> getMountPoint() {
            return Optional.empty();
        }

        public URI getWebDavUri();

        default public Optional<UnmountOperation> forced() {
            return Optional.empty();
        }

        @Deprecated
        public void reveal() throws CommandFailedException;

        public void reveal(Revealer var1) throws Exception;
    }
}

