/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.mainwindow;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.scene.input.DragEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.StackPane;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.apache.commons.lang3.SystemUtils;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.cryptofs.CryptoFileSystemProvider;
import org.cryptomator.cryptofs.DirStructure;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.mainwindow.MainWindow;
import org.cryptomator.ui.mainwindow.MainWindowScoped;
import org.cryptomator.ui.wrongfilealert.WrongFileAlertComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MainWindowScoped
public class MainWindowController
implements FxController {
    private static final Logger LOG = LoggerFactory.getLogger(MainWindowController.class);
    private final Stage window;
    private final VaultListManager vaultListManager;
    private final ReadOnlyObjectProperty<Vault> selectedVault;
    private final WrongFileAlertComponent.Builder wrongFileAlert;
    private final BooleanProperty draggingOver = new SimpleBooleanProperty();
    private final BooleanProperty draggingVaultOver = new SimpleBooleanProperty();
    public StackPane root;

    @Inject
    public MainWindowController(@MainWindow Stage window, VaultListManager vaultListManager, ObjectProperty<Vault> selectedVault, WrongFileAlertComponent.Builder wrongFileAlert) {
        this.window = window;
        this.vaultListManager = vaultListManager;
        this.selectedVault = selectedVault;
        this.wrongFileAlert = wrongFileAlert;
    }

    @FXML
    public void initialize() {
        LOG.trace("init MainWindowController");
        this.root.setOnDragEntered(this::handleDragEvent);
        this.root.setOnDragOver(this::handleDragEvent);
        this.root.setOnDragDropped(this::handleDragEvent);
        this.root.setOnDragExited(this::handleDragEvent);
        if (SystemUtils.IS_OS_WINDOWS) {
            this.root.getStyleClass().add((Object)"os-windows");
        }
        this.window.focusedProperty().addListener(this::mainWindowFocusChanged);
    }

    private void mainWindowFocusChanged(Observable observable) {
        Vault v = (Vault)this.selectedVault.get();
        if (v != null) {
            VaultListManager.redetermineVaultState(v);
        }
    }

    private void handleDragEvent(DragEvent event) {
        if (DragEvent.DRAG_ENTERED.equals(event.getEventType()) && event.getGestureSource() == null) {
            this.draggingOver.set(true);
        } else if (DragEvent.DRAG_OVER.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            event.acceptTransferModes(TransferMode.ANY);
            this.draggingVaultOver.set(event.getDragboard().getFiles().stream().map(File::toPath).anyMatch(this::containsVault));
        } else if (DragEvent.DRAG_DROPPED.equals(event.getEventType()) && event.getGestureSource() == null && event.getDragboard().hasFiles()) {
            Set<Path> vaultPaths = event.getDragboard().getFiles().stream().map(File::toPath).filter(this::containsVault).collect(Collectors.toSet());
            if (vaultPaths.isEmpty()) {
                this.wrongFileAlert.build().showWrongFileAlertWindow();
            } else {
                vaultPaths.forEach(this::addVault);
            }
            event.setDropCompleted(!vaultPaths.isEmpty());
            event.consume();
        } else if (DragEvent.DRAG_EXITED.equals(event.getEventType())) {
            this.draggingOver.set(false);
            this.draggingVaultOver.set(false);
        }
    }

    private boolean containsVault(Path path) {
        try {
            if (path.getFileName().toString().endsWith(".cryptomator")) {
                path = path.getParent();
            }
            return CryptoFileSystemProvider.checkDirStructureForVault((Path)path, (String)"vault.cryptomator", (String)"masterkey.cryptomator") != DirStructure.UNRELATED;
        }
        catch (IOException e) {
            return false;
        }
    }

    private void addVault(Path pathToVault) {
        try {
            if (pathToVault.getFileName().toString().endsWith(".cryptomator")) {
                this.vaultListManager.add(pathToVault.getParent());
            } else {
                this.vaultListManager.add(pathToVault);
            }
        }
        catch (IOException e) {
            LOG.debug("Not a vault: {}", (Object)pathToVault);
        }
    }

    public BooleanProperty draggingOverProperty() {
        return this.draggingOver;
    }

    public boolean isDraggingOver() {
        return this.draggingOver.get();
    }

    public BooleanProperty draggingVaultOverProperty() {
        return this.draggingVaultOver;
    }

    public boolean isDraggingVaultOver() {
        return this.draggingVaultOver.get();
    }
}

