/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.keyloading;

import dagger.Module;
import dagger.Provides;
import java.io.IOException;
import java.util.Map;
import java.util.ResourceBundle;
import javax.inject.Provider;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.DefaultSceneFactory;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlLoaderFactory;
import org.cryptomator.ui.keyloading.KeyLoading;
import org.cryptomator.ui.keyloading.KeyLoadingScoped;
import org.cryptomator.ui.keyloading.KeyLoadingStrategy;
import org.cryptomator.ui.keyloading.masterkeyfile.MasterkeyFileLoadingModule;

@Module(includes={MasterkeyFileLoadingModule.class})
abstract class KeyLoadingModule {
    KeyLoadingModule() {
    }

    @Provides
    @KeyLoading
    @KeyLoadingScoped
    static FxmlLoaderFactory provideFxmlLoaderFactory(Map<Class<? extends FxController>, Provider<FxController>> factories, DefaultSceneFactory sceneFactory, ResourceBundle resourceBundle) {
        return new FxmlLoaderFactory(factories, sceneFactory, resourceBundle);
    }

    @Provides
    @KeyLoading
    @KeyLoadingScoped
    static KeyLoadingStrategy provideKeyLoaderProvider(@KeyLoading Vault vault, Map<String, Provider<KeyLoadingStrategy>> strategies) {
        try {
            String scheme = vault.getVaultConfigCache().get().getKeyId().getScheme();
            KeyLoadingStrategy fallback = KeyLoadingStrategy.failed(new IllegalArgumentException("Unsupported key id " + scheme));
            return (KeyLoadingStrategy)strategies.getOrDefault(scheme, (Provider<KeyLoadingStrategy>)((Provider)() -> fallback)).get();
        }
        catch (IOException e) {
            return KeyLoadingStrategy.failed(e);
        }
    }
}

