/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;

public class UserInteractionLock<E extends Enum> {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final BooleanProperty awaitingInteraction = new SimpleBooleanProperty();
    private volatile E state;

    public UserInteractionLock(E initialValue) {
        this.state = initialValue;
    }

    public void interacted(E result) {
        assert (Platform.isFxApplicationThread());
        this.lock.lock();
        try {
            this.state = result;
            this.awaitingInteraction.set(false);
            this.condition.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public E awaitInteraction() throws InterruptedException {
        assert (!Platform.isFxApplicationThread());
        this.lock.lock();
        try {
            Platform.runLater(() -> this.awaitingInteraction.set(true));
            this.condition.await();
            E e = this.state;
            return e;
        }
        finally {
            this.lock.unlock();
        }
    }

    public ReadOnlyBooleanProperty awaitingInteraction() {
        return this.awaitingInteraction;
    }
}

