/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.common;

import com.nulabinc.zxcvbn.Zxcvbn;
import java.util.List;
import java.util.ResourceBundle;
import javax.inject.Inject;
import org.cryptomator.common.Environment;
import org.cryptomator.ui.fxapp.FxApplicationScoped;

@FxApplicationScoped
public class PasswordStrengthUtil {
    private static final int PW_TRUNC_LEN = 100;
    private static final String RESSOURCE_PREFIX = "passwordStrength.messageLabel.";
    private static final List<String> SANITIZED_INPUTS = List.of("cryptomator");
    private final ResourceBundle resourceBundle;
    private final int minPwLength;
    private final Zxcvbn zxcvbn;

    @Inject
    public PasswordStrengthUtil(ResourceBundle resourceBundle, Environment environment) {
        this.resourceBundle = resourceBundle;
        this.minPwLength = environment.getMinPwLength();
        this.zxcvbn = new Zxcvbn();
    }

    public boolean fulfillsMinimumRequirements(CharSequence password) {
        return password.length() >= this.minPwLength;
    }

    public int computeRate(CharSequence password) {
        if (password == null || password.length() < this.minPwLength) {
            return -1;
        }
        int numCharsToRate = Math.min(100, password.length());
        return this.zxcvbn.measure(password.subSequence(0, numCharsToRate), SANITIZED_INPUTS).getScore();
    }

    public String getStrengthDescription(Number score) {
        if (score.intValue() == -1) {
            return String.format(this.resourceBundle.getString("passwordStrength.messageLabel.tooShort"), this.minPwLength);
        }
        if (this.resourceBundle.containsKey(RESSOURCE_PREFIX + score.intValue())) {
            return this.resourceBundle.getString(RESSOURCE_PREFIX + score.intValue());
        }
        return "";
    }
}

