/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.recoverykey;

import com.google.common.base.CharMatcher;
import com.google.common.base.Strings;
import dagger.Lazy;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Scene;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.stage.Stage;
import javax.inject.Inject;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.ui.common.FxController;
import org.cryptomator.ui.common.FxmlFile;
import org.cryptomator.ui.common.FxmlScene;
import org.cryptomator.ui.recoverykey.AutoCompleter;
import org.cryptomator.ui.recoverykey.RecoveryKeyFactory;
import org.cryptomator.ui.recoverykey.RecoveryKeyScoped;
import org.cryptomator.ui.recoverykey.RecoveryKeyWindow;

@RecoveryKeyScoped
public class RecoveryKeyRecoverController
implements FxController {
    private static final CharMatcher ALLOWED_CHARS = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.is((char)' '));
    private final Stage window;
    private final Vault vault;
    private final StringProperty recoveryKey;
    private final RecoveryKeyFactory recoveryKeyFactory;
    private final BooleanBinding validRecoveryKey;
    private final Lazy<Scene> resetPasswordScene;
    private final AutoCompleter autoCompleter;
    public TextArea textarea;

    @Inject
    public RecoveryKeyRecoverController(@RecoveryKeyWindow Stage window, @RecoveryKeyWindow Vault vault, @RecoveryKeyWindow StringProperty recoveryKey, RecoveryKeyFactory recoveryKeyFactory, @FxmlScene(value=FxmlFile.RECOVERYKEY_RESET_PASSWORD) Lazy<Scene> resetPasswordScene) {
        this.window = window;
        this.vault = vault;
        this.recoveryKey = recoveryKey;
        this.recoveryKeyFactory = recoveryKeyFactory;
        this.validRecoveryKey = Bindings.createBooleanBinding(this::isValidRecoveryKey, (Observable[])new Observable[]{recoveryKey});
        this.resetPasswordScene = resetPasswordScene;
        this.autoCompleter = new AutoCompleter(recoveryKeyFactory.getDictionary());
    }

    @FXML
    public void initialize() {
        this.recoveryKey.bind((ObservableValue)this.textarea.textProperty());
    }

    private TextFormatter.Change filterTextChange(TextFormatter.Change change) {
        int beginOfWord;
        String currentWord;
        Optional<String> suggestion;
        if (Strings.isNullOrEmpty((String)change.getText())) {
            return change;
        }
        if (!ALLOWED_CHARS.matchesAllOf((CharSequence)change.getText())) {
            return null;
        }
        String text = change.getControlNewText();
        int caretPos = change.getCaretPosition();
        if ((caretPos == text.length() || text.charAt(caretPos) == ' ') && (suggestion = this.autoCompleter.autocomplete(currentWord = text.substring(beginOfWord = Math.max(text.substring(0, caretPos).lastIndexOf(32) + 1, 0), caretPos))).isPresent()) {
            String completion = suggestion.get().substring(currentWord.length());
            change.setText(change.getText() + completion);
            change.setAnchor(caretPos + completion.length());
        }
        return change;
    }

    @FXML
    public void onKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getCode() == KeyCode.TAB && this.textarea.getAnchor() > this.textarea.getCaretPosition()) {
            int pos = this.textarea.getAnchor();
            this.textarea.insertText(pos, " ");
            this.textarea.positionCaret(pos + 1);
        }
    }

    @FXML
    public void close() {
        this.window.close();
    }

    @FXML
    public void recover() {
        this.window.setScene((Scene)this.resetPasswordScene.get());
    }

    public Vault getVault() {
        return this.vault;
    }

    public BooleanBinding validRecoveryKeyProperty() {
        return this.validRecoveryKey;
    }

    public boolean isValidRecoveryKey() {
        return this.recoveryKeyFactory.validateRecoveryKey((String)this.recoveryKey.get());
    }

    public TextFormatter getRecoveryKeyTextFormatter() {
        return new TextFormatter(this::filterTextChange);
    }
}

