/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.ui.launcher;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import javafx.application.Platform;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.cryptomator.common.vaults.Vault;
import org.cryptomator.common.vaults.VaultListManager;
import org.cryptomator.ui.fxapp.FxApplication;
import org.cryptomator.ui.launcher.AppLaunchEvent;
import org.cryptomator.ui.launcher.FxApplicationStarter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
class AppLaunchEventHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AppLaunchEventHandler.class);
    private final BlockingQueue<AppLaunchEvent> launchEventQueue;
    private final ExecutorService executorService;
    private final FxApplicationStarter fxApplicationStarter;
    private final VaultListManager vaultListManager;

    @Inject
    public AppLaunchEventHandler(@Named(value="launchEventQueue") BlockingQueue<AppLaunchEvent> launchEventQueue, ExecutorService executorService, FxApplicationStarter fxApplicationStarter, VaultListManager vaultListManager) {
        this.launchEventQueue = launchEventQueue;
        this.executorService = executorService;
        this.fxApplicationStarter = fxApplicationStarter;
        this.vaultListManager = vaultListManager;
    }

    public void startHandlingLaunchEvents() {
        this.executorService.submit(this::handleLaunchEvents);
    }

    private void handleLaunchEvents() {
        try {
            while (!Thread.interrupted()) {
                AppLaunchEvent event = this.launchEventQueue.take();
                this.handleLaunchEvent(event);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted launch event handler.");
            Thread.currentThread().interrupt();
        }
    }

    private void handleLaunchEvent(AppLaunchEvent event) {
        switch (event.getType()) {
            case REVEAL_APP: {
                this.fxApplicationStarter.get().thenAccept(FxApplication::showMainWindow);
                break;
            }
            case OPEN_FILE: {
                this.fxApplicationStarter.get().thenRun(() -> Platform.runLater(() -> event.getPathsToOpen().forEach(this::addOrRevealVault)));
                break;
            }
            default: {
                LOG.warn("Unsupported event type: {}", (Object)event.getType());
            }
        }
    }

    private void addOrRevealVault(Path potentialVaultPath) {
        assert (Platform.isFxApplicationThread());
        try {
            Vault v = potentialVaultPath.getFileName().toString().endsWith(".cryptomator") ? this.vaultListManager.add(potentialVaultPath.getParent()) : this.vaultListManager.add(potentialVaultPath);
            if (v.isUnlocked()) {
                this.fxApplicationStarter.get().thenAccept(app -> app.getVaultService().reveal(v));
            }
            LOG.debug("Added vault {}", (Object)potentialVaultPath);
        }
        catch (IOException e) {
            LOG.error("Failed to add vault " + potentialVaultPath, (Throwable)e);
        }
    }
}

