/*
 * Decompiled with CFR 0.152.
 */
package org.cryptomator.common.settings;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.cryptomator.common.settings.VaultSettings;
import org.cryptomator.common.settings.WhenUnlocked;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class VaultSettingsJsonAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(VaultSettingsJsonAdapter.class);

    VaultSettingsJsonAdapter() {
    }

    public void write(JsonWriter out, VaultSettings value) throws IOException {
        out.beginObject();
        out.name("id").value(value.getId());
        out.name("path").value(((Path)value.path().get()).toString());
        out.name("displayName").value((String)value.displayName().get());
        out.name("winDriveLetter").value((String)value.winDriveLetter().get());
        out.name("unlockAfterStartup").value(value.unlockAfterStartup().get());
        out.name("revealAfterMount").value(value.revealAfterMount().get());
        out.name("useCustomMountPath").value(value.useCustomMountPath().get());
        out.name("customMountPath").value((String)value.customMountPath().get());
        out.name("usesReadOnlyMode").value(value.usesReadOnlyMode().get());
        out.name("mountFlags").value((String)value.mountFlags().get());
        out.name("maxCleartextFilenameLength").value((long)value.maxCleartextFilenameLength().get());
        out.name("actionAfterUnlock").value(((WhenUnlocked)((Object)value.actionAfterUnlock().get())).name());
        out.name("autoLockWhenIdle").value(value.autoLockWhenIdle().get());
        out.name("autoLockIdleSeconds").value((long)value.autoLockIdleSeconds().get());
        out.endObject();
    }

    public VaultSettings read(JsonReader in) throws IOException {
        VaultSettings vaultSettings;
        String id = null;
        String path = null;
        String mountName = null;
        String displayName = null;
        String customMountPath = null;
        String winDriveLetter = null;
        boolean unlockAfterStartup = false;
        boolean revealAfterMount = true;
        boolean useCustomMountPath = false;
        boolean usesReadOnlyMode = false;
        String mountFlags = "";
        int maxCleartextFilenameLength = -1;
        WhenUnlocked actionAfterUnlock = VaultSettings.DEFAULT_ACTION_AFTER_UNLOCK;
        boolean autoLockWhenIdle = false;
        int autoLockIdleSeconds = 1800;
        in.beginObject();
        block36: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "id": {
                    id = in.nextString();
                    continue block36;
                }
                case "path": {
                    path = in.nextString();
                    continue block36;
                }
                case "mountName": {
                    mountName = in.nextString();
                    continue block36;
                }
                case "displayName": {
                    displayName = in.nextString();
                    continue block36;
                }
                case "winDriveLetter": {
                    winDriveLetter = in.nextString();
                    continue block36;
                }
                case "unlockAfterStartup": {
                    unlockAfterStartup = in.nextBoolean();
                    continue block36;
                }
                case "revealAfterMount": {
                    revealAfterMount = in.nextBoolean();
                    continue block36;
                }
                case "usesIndividualMountPath": 
                case "useCustomMountPath": {
                    useCustomMountPath = in.nextBoolean();
                    continue block36;
                }
                case "individualMountPath": 
                case "customMountPath": {
                    customMountPath = in.nextString();
                    continue block36;
                }
                case "usesReadOnlyMode": {
                    usesReadOnlyMode = in.nextBoolean();
                    continue block36;
                }
                case "mountFlags": {
                    mountFlags = in.nextString();
                    continue block36;
                }
                case "maxCleartextFilenameLength": {
                    maxCleartextFilenameLength = in.nextInt();
                    continue block36;
                }
                case "actionAfterUnlock": {
                    actionAfterUnlock = this.parseActionAfterUnlock(in.nextString());
                    continue block36;
                }
                case "autoLockWhenIdle": {
                    autoLockWhenIdle = in.nextBoolean();
                    continue block36;
                }
                case "autoLockIdleSeconds": {
                    autoLockIdleSeconds = in.nextInt();
                    continue block36;
                }
            }
            LOG.warn("Unsupported vault setting found in JSON: " + name);
            in.skipValue();
        }
        in.endObject();
        VaultSettings vaultSettings2 = vaultSettings = id == null ? VaultSettings.withRandomId() : new VaultSettings(id);
        if (displayName != null) {
            vaultSettings.displayName().set(displayName);
        } else {
            vaultSettings.displayName().set(mountName);
        }
        vaultSettings.path().set((Object)Paths.get(path, new String[0]));
        vaultSettings.winDriveLetter().set((Object)winDriveLetter);
        vaultSettings.unlockAfterStartup().set(unlockAfterStartup);
        vaultSettings.revealAfterMount().set(revealAfterMount);
        vaultSettings.useCustomMountPath().set(useCustomMountPath);
        vaultSettings.customMountPath().set((Object)customMountPath);
        vaultSettings.usesReadOnlyMode().set(usesReadOnlyMode);
        vaultSettings.mountFlags().set((Object)mountFlags);
        vaultSettings.maxCleartextFilenameLength().set(maxCleartextFilenameLength);
        vaultSettings.actionAfterUnlock().set((Object)actionAfterUnlock);
        vaultSettings.autoLockWhenIdle().set(autoLockWhenIdle);
        vaultSettings.autoLockIdleSeconds().set(autoLockIdleSeconds);
        return vaultSettings;
    }

    private WhenUnlocked parseActionAfterUnlock(String actionAfterUnlockName) {
        try {
            return WhenUnlocked.valueOf(actionAfterUnlockName.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOG.warn("Invalid action after unlock {}. Defaulting to {}.", (Object)actionAfterUnlockName, (Object)VaultSettings.DEFAULT_ACTION_AFTER_UNLOCK);
            return VaultSettings.DEFAULT_ACTION_AFTER_UNLOCK;
        }
    }
}

