---
layout: page
title:  "Albert 0.9 released"
date: 2017-01-17 14:49 +0100
---
Almost four months have passed since the last alpha release. Dozens of hours of contemplation about a sophisticated design, dozens of hours of implementation and even a broken arm later I am happy to announce the release of Albert v0.9.

This release comes with a new architecture that allows extensions to register extensions themselves. Based on this changes a new extension *"External extensions"* has been implemented, which can be used to let Albert run external programs and scripts as extensions. Here's an example of an external bash extension that lets you run the scan popup of goldendict as external search engine:

```
#!/bin/bash
case $ALBERT_OP in
  "METADATA")
    STDOUT='{
      "iid":"org.albert.extension.external/v2.0",
      "name":"Goldendict",
      "version":"1.0",
      "author":"Manuel Schneider",
      "dependencies":["goldendict"],
      "trigger":"gd "
    }'
    echo -n "${STDOUT}"
    exit 0
    ;;
  "QUERY")
    QUERYSTRING="${ALBERT_QUERY:3}"
    echo -n '{
      "items":[{
        "id":"goldendict",
        "name":"Use goldendict to lookup '"'${QUERYSTRING}'"'",
        "description":"Opens the scan popup and searches for '"'${QUERYSTRING}'"'.",
        "icon":"goldendict",
        "actions":[{
          "name":"goldendict",
          "command":"goldendict",
          "arguments":["'${QUERYSTRING}'"]
        }]
      }]
    }'
    exit 0
    ;;
esac

```
Just a few words on this to get you started. The core application runs the extension with several environment variables set. The vars used in this script are `$ALBERT_OP` and `$ALBERT_QUERY`. `$ALBERT_OP` tells the extension what to do. When the user enters a query the extension is started with `$ALBERT_OP` set to `QUERY` and `$ALBERT_QUERY` set to the string that the user entered.

The bash script in the listing above extracts the query string by cutting the trigger prefix and runs goldendict with this query string, which opens the goldendict scan popup with the query string. Now this was quick! For the details check the relevant section in the documentation.

Further, finally a Firefox bookmark extension made it into the extension inventory. Just as the chrome bookmarks extension the extension basically indexes the bookmarks and makes them accessible via Albert. In the settings you can choose the user profile you want to track and set if the bookmarks should open in the default browser or in Firefox.

The virtual box extension got some major improvements as well. You can now control the state of the virtual machine, i.e. if it is turned off you can run it (as before), if it runs you can pause, stop or save it, if it is paused... I think you got it.

Transparent to the user, things changed a lot under the hood to make albert even better and of course several bug fixes made it into v0.9.0 as well. If you want to see the complete changes check the [git log](https://github.com/albertlauncher/albert/commits/v0.9.0).

Have fun with it!
