#include "jsrunner.h"

JSRunner::JSRunner()
{
    profile = new QWebEngineProfile();
    page = new QWebEnginePage(this->profile);
    page->setAudioMuted(true);
}

JSRunner::~JSRunner() {
   this->timer.disconnect();
   this->loop.disconnect();
   this->page->disconnect();
   this->profile->disconnect();
   this->page->deleteLater();
   this->profile->deleteLater();
}

bool JSRunner::setHtml(QString html) {
    timer.setSingleShot(true);
    connect(page, SIGNAL(loadFinished(bool)), this, SLOT(handleHtmlReady(bool)));
    connect(page, SIGNAL(loadFinished(bool)), &loop, SLOT(quit()));
    connect(&timer, SIGNAL(timeout()), &loop, SLOT(quit()));

    htmlReady = false;
    page->setHtml(html);
    timer.start(10000);
    loop.exec();
    return this->htmlReady;
}

QVariant JSRunner::runJavaScript(QString script) {
    if (!htmlReady)
    {
        return QVariant();
    }
    timer.setSingleShot(true);
    connect(&timer, SIGNAL(timeout()), &loop, SLOT(quit()));
    connect(this, SIGNAL(resultAvailable()), &loop, SLOT(quit()));

    page->runJavaScript(script, [&](const QVariant &v) {handleResultReady(v);});

    timer.start(10000);
    loop.exec();

    if (timer.isActive())
    {
        return result;
    } else {
        return QVariant();
    }
}

void JSRunner::handleResultReady(const QVariant &v)
{
    result = v;
    emit resultAvailable();
    if (v.isValid()) {
        result = v;
        emit resultAvailable();
    }
}


void JSRunner::handleHtmlReady(bool success)
{
    htmlReady = success;
}
