/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.Stamps;
import org.netbeans.Util;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.BaseUtilities;
import org.openide.util.NbBundle;

final class LocaleVariants
implements Stamps.Updater {
    private static final Logger err = Util.err;
    private static final Map<File, List<FileWithSuffix>> map;
    private static Locale mapLocale;
    private static LocaleVariants UPDATER;
    private static String[] suffixes;
    private static Locale lastLocale;
    private static String lastBranding;

    private LocaleVariants() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flushCaches(DataOutputStream os) throws IOException {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            os.writeUTF(mapLocale.toString());
            for (Map.Entry<File, List<FileWithSuffix>> entry : LocaleVariants.map.entrySet()) {
                Stamps.writeRelativePath(entry.getKey().getPath(), os);
                for (FileWithSuffix fws : entry.getValue()) {
                    fws.write(os);
                }
                Stamps.writeRelativePath("", os);
            }
            Stamps.writeRelativePath("", os);
        }
    }

    @Override
    public void cacheReady() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            LocaleVariants.map.clear();
        }
    }

    static List<File> findLocaleVariantsOf(File f, String codeNameBase) {
        List<FileWithSuffix> result = LocaleVariants.findLocaleVariantsWithSuffixesOf(f, codeNameBase);
        ArrayList<File> l = new ArrayList<File>(result.size());
        for (FileWithSuffix fws : result) {
            l.add(fws.file);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<FileWithSuffix> findLocaleVariantsWithSuffixesOf(File f, String codeNameBase) {
        List<FileWithSuffix> res;
        Map<File, List<FileWithSuffix>> map = LocaleVariants.map;
        synchronized (map) {
            if (mapLocale != Locale.getDefault()) {
                LocaleVariants.map.clear();
                mapLocale = Locale.getDefault();
            }
            if ((res = LocaleVariants.map.get(f)) != null) {
                return res;
            }
        }
        if (!f.isFile()) {
            res = Collections.emptyList();
        } else {
            String ext;
            String name;
            Object logicalDir = null;
            String logicalPath = LocaleVariants.findLogicalPath(f, codeNameBase);
            if (logicalPath != null) {
                int slash = logicalPath.lastIndexOf(47);
                logicalDir = slash != -1 ? logicalPath.substring(0, slash + 1) + "locale/" : "locale/";
            }
            ArrayList<FileWithSuffix> l = new ArrayList<FileWithSuffix>(7);
            String nameExt = f.getName();
            int idx = nameExt.lastIndexOf(46);
            if (idx != -1) {
                name = nameExt.substring(0, idx);
                ext = nameExt.substring(idx);
            } else {
                name = nameExt;
                ext = "";
            }
            if (logicalDir != null) {
                for (String suffix : LocaleVariants.getLocalizingSuffixesFast()) {
                    String path = (String)logicalDir + name + suffix + ext;
                    File v = InstalledFileLocator.getDefault().locate(path, codeNameBase, false);
                    if (v == null) continue;
                    l.add(new FileWithSuffix(v, suffix));
                }
            } else {
                File dir = new File(f.getParentFile(), "locale");
                if (dir.exists()) {
                    for (String suffix : LocaleVariants.getLocalizingSuffixesFast()) {
                        File v = new File(dir, name + suffix + ext);
                        if (!v.isFile()) continue;
                        l.add(new FileWithSuffix(v, suffix));
                    }
                }
            }
            res = l;
        }
        res = res.isEmpty() ? Collections.emptyList() : res;
        map = LocaleVariants.map;
        synchronized (map) {
            LocaleVariants.map.put(f, res);
        }
        if (UPDATER == null) {
            UPDATER = new LocaleVariants();
            Stamps.getModulesJARs().scheduleSave(UPDATER, "localeVariants", false);
        }
        return res;
    }

    static synchronized String[] getLocalizingSuffixesFast() {
        if (suffixes == null || Locale.getDefault() != lastLocale || !BaseUtilities.compareObjects((Object)NbBundle.getBranding(), (Object)lastBranding)) {
            ArrayList<String> _suffixes = new ArrayList<String>();
            Iterator it = NbBundle.getLocalizingSuffixes();
            while (it.hasNext()) {
                _suffixes.add((String)it.next());
            }
            suffixes = _suffixes.toArray(new String[0]);
            lastLocale = Locale.getDefault();
            lastBranding = NbBundle.getBranding();
        }
        return suffixes;
    }

    private static String findLogicalPath(File f, String codeNameBase) {
        InstalledFileLocator l = InstalledFileLocator.getDefault();
        Object path = f.getName();
        for (File parent = f.getParentFile(); parent != null; parent = parent.getParentFile()) {
            File probe = l.locate((String)path, codeNameBase, false);
            if (f.equals(probe)) {
                return path;
            }
            path = parent.getName() + "/" + (String)path;
        }
        return null;
    }

    static {
        InputStream stream = Stamps.getModulesJARs().asStream("localeVariants");
        HashMap<File, List<FileWithSuffix>> tmp = new HashMap<File, List<FileWithSuffix>>();
        if (stream != null) {
            try {
                String file;
                DataInputStream is = new DataInputStream(stream);
                String locale = is.readUTF();
                Locale locale2 = mapLocale = Locale.getDefault().toString().equals(locale) ? Locale.getDefault() : null;
                while ((file = Stamps.readRelativePath(is)).length() != 0) {
                    FileWithSuffix fws;
                    List arr = new ArrayList();
                    while ((fws = FileWithSuffix.read(is)) != null) {
                        arr.add(fws);
                    }
                    arr = arr.isEmpty() ? Collections.emptyList() : arr;
                    tmp.put(new File(file), arr);
                }
                is.close();
            }
            catch (IOException ex) {
                err.log(Level.WARNING, "Cannot read localeVariants cache", ex);
                tmp.clear();
            }
        }
        map = tmp;
        suffixes = null;
        lastLocale = null;
        lastBranding = null;
    }

    static final class FileWithSuffix {
        public final File file;
        public final String suffix;

        FileWithSuffix(File file, String suffix) {
            this.file = file;
            this.suffix = suffix;
        }

        static FileWithSuffix read(DataInputStream is) throws IOException {
            String path = Stamps.readRelativePath(is);
            if (path.length() == 0) {
                return null;
            }
            String suffix = is.readUTF();
            return new FileWithSuffix(new File(path), suffix);
        }

        void write(DataOutputStream os) throws IOException {
            Stamps.writeRelativePath(this.file.getPath(), os);
            os.writeUTF(this.suffix);
        }
    }
}

