/*
 * Decompiled with CFR 0.152.
 */
package ancestris.util.swing;

import genj.util.Registry;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang.ArrayUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public abstract class DialogManager {
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int WARNING_MESSAGE = 2;
    public static final int QUESTION_MESSAGE = 3;
    public static final int PLAIN_MESSAGE = -1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int OK_ONLY_OPTION = 10;
    public static final Object OK_OPTION = DialogDescriptor.OK_OPTION;
    public static final Object CANCEL_OPTION = DialogDescriptor.CANCEL_OPTION;
    public static final Object YES_OPTION = DialogDescriptor.YES_OPTION;
    public static final Object NO_OPTION = DialogDescriptor.NO_OPTION;
    public static final Object CLOSED_OPTION = DialogDescriptor.CLOSED_OPTION;
    protected String dialogId = null;
    protected boolean isResizable = true;
    protected JButton defaultButton;
    protected boolean forceButtonFocus = false;
    public static boolean useMacButtonOrder = DialogManager.shouldUseMacButtonOrder();

    public static ADialog create(String title, JComponent content) {
        return new ADialog(title, content);
    }

    public static ADialog create(String title, JComponent[] content) {
        return DialogManager.create(title, content, true);
    }

    public static ADialog create(String title, JComponent[] content, boolean modal) {
        JPanel box = new JPanel();
        box.setLayout(new BoxLayout(box, 1));
        box.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        for (JComponent currentContent : content) {
            if (currentContent == null) continue;
            box.add(currentContent);
            currentContent.setAlignmentX(0.0f);
        }
        return DialogManager.create(title, box, modal);
    }

    public static ADialog create(String title, JComponent content, boolean modal) {
        return new ADialog(title, content, modal);
    }

    public static InputLine create(String title, String text, String value) {
        return new InputLine(title, text, value);
    }

    public static DialogManager createError(String title, String text) {
        return new ADialog(title, text).setMessageType(0);
    }

    public static DialogManager create(String title, String text) {
        return new ADialog(title, text);
    }

    public static DialogManager createYesNo(String title, String text) {
        return new ADialog(title, text).setOptionType(0).setMessageType(3);
    }

    protected abstract NotifyDescriptor getDescriptor();

    public abstract Object show();

    public abstract void cancel();

    private static boolean shouldUseMacButtonOrder() {
        String testLooksAsMacProp = System.getProperty("xtest.looks_as_mac");
        if (testLooksAsMacProp != null) {
            return testLooksAsMacProp.equalsIgnoreCase("true");
        }
        return UIManager.getBoolean("OptionPane.isYesLast");
    }

    public DialogManager setOptions(Object[] newOptions) {
        Object object;
        if (newOptions.length > 1 && (object = newOptions[0]) instanceof JButton) {
            JButton button;
            this.defaultButton = button = (JButton)object;
        }
        if (useMacButtonOrder) {
            DialogManager.reverseButtons(newOptions);
        }
        this.getDescriptor().setOptions(newOptions);
        return this;
    }

    public DialogManager setAdditionalOptions(Object[] newOptions) {
        this.getDescriptor().setAdditionalOptions(newOptions);
        return this;
    }

    public DialogManager setOptionType(int newType) {
        if (newType == 10) {
            return this.setOptions(new Object[]{OK_OPTION});
        }
        this.getDescriptor().setOptions(null);
        this.getDescriptor().setOptionType(newType);
        return this;
    }

    public DialogManager setMessageType(int newType) {
        this.getDescriptor().setMessageType(newType);
        return this;
    }

    public DialogManager setDialogId(Class type) {
        return this.setDialogId(type.getName());
    }

    public DialogManager setDialogId(String id) {
        this.dialogId = id;
        return this;
    }

    public DialogManager setResizable(boolean set) {
        this.isResizable = set;
        return this;
    }

    public final DialogManager setValid(boolean newValid) {
        this.getDescriptor().setValid(newValid);
        return this;
    }

    public DialogManager setForceButtonFocus(boolean set) {
        this.forceButtonFocus = set;
        return this;
    }

    public static Object[] reverseButtons(Object[] newOptions) {
        ArrayUtils.reverse((Object[])newOptions);
        return newOptions;
    }

    public static class ADialog
    extends DialogManager {
        protected DialogDescriptor descriptor;
        private Dialog dialog;

        public ADialog(String title, String message) {
            if (!((String)message).contains("<html>")) {
                message = "<html>" + (String)message + "</html>";
            }
            JLabel content = new JLabel((String)message);
            this.descriptor = new DialogDescriptor((Object)content, title);
            this.forceButtonFocus = true;
        }

        public ADialog(String title, JComponent content) {
            this.descriptor = new DialogDescriptor((Object)content, title);
        }

        public ADialog(String title, JComponent content, boolean modal) {
            ActionListener al = e -> {
                if (this.dialogId != null) {
                    Registry.get(DialogManager.class).put(this.dialogId + ".dialog", this.dialog.getSize());
                }
                this.cancel();
            };
            this.descriptor = new DialogDescriptor((Object)content, title, modal, al);
        }

        @Override
        protected NotifyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public Object show() {
            Component component;
            Dimension bounds;
            if (this.dialog == null) {
                this.dialog = DialogDisplayer.getDefault().createDialog(this.descriptor, null);
            }
            Registry registry = Registry.get(DialogManager.class);
            if (this.dialogId != null && (bounds = registry.get(this.dialogId + ".dialog", (Dimension)null)) != null) {
                Rectangle prev = this.dialog.getBounds();
                bounds.width = Math.max(bounds.width, prev.width);
                bounds.height = Math.max(bounds.height, prev.height);
                prev.grow((bounds.width - prev.width) / 2, (bounds.height - prev.height) / 2);
                this.dialog.setBounds(prev);
            }
            this.dialog.setResizable(this.isResizable);
            Component[] components = this.dialog.getComponents();
            if (components.length > 0 && (component = components[0]) instanceof JRootPane) {
                JRootPane rootPane = (JRootPane)component;
                JButton rootPaneDefaultButton = rootPane.getDefaultButton();
                if (this.defaultButton != null && rootPaneDefaultButton != this.defaultButton) {
                    rootPane.setDefaultButton(this.defaultButton);
                }
                if (this.defaultButton == null && rootPaneDefaultButton != null) {
                    this.defaultButton = rootPaneDefaultButton;
                }
                if (this.forceButtonFocus && this.defaultButton != null) {
                    this.defaultButton.requestFocusInWindow();
                }
            }
            this.dialog.setVisible(true);
            if (this.dialogId != null) {
                registry.put(this.dialogId + ".dialog", this.dialog.getSize());
            }
            return this.descriptor.getValue();
        }

        @Override
        public void cancel() {
            if (this.dialog == null) {
                throw new IllegalStateException("not showing");
            }
            this.dialog.dispose();
        }
    }

    public static class InputLine
    extends DialogManager {
        private MyInputLine descriptor;

        public InputLine(String title, String text, String value) {
            this(title, text, value, 3, false);
        }

        public InputLine(String title, String text, String value, int type, boolean accepEmpty) {
            this.descriptor = new MyInputLine(text, title);
            this.descriptor.setEnabler(!accepEmpty);
            this.descriptor.setInputText(value);
            this.descriptor.setOptionType(2);
            this.setMessageType(type);
            Object message = this.descriptor.getMessage();
            if (message instanceof JPanel) {
                JPanel panel = (JPanel)message;
                int titleLength = 0;
                if (title != null) {
                    titleLength = title.length() * 10;
                }
                panel.setPreferredSize(new Dimension(panel.getPreferredSize().width + titleLength, panel.getPreferredSize().height));
            }
        }

        @Override
        protected NotifyDescriptor getDescriptor() {
            return this.descriptor;
        }

        @Override
        public String show() {
            if (NotifyDescriptor.OK_OPTION == DialogDisplayer.getDefault().notify((NotifyDescriptor)this.descriptor)) {
                return this.descriptor.getInputText();
            }
            return null;
        }

        @Override
        public void cancel() {
        }
    }

    private static class MyInputLine
    extends NotifyDescriptor.InputLine {
        private boolean isAutoEnabler = true;

        public MyInputLine(String text, String title) {
            super(text, title);
            this.doEnablement();
        }

        public void setInputText(String text) {
            super.setInputText(text);
            this.doEnablement();
        }

        public void setEnabler(boolean set) {
            this.isAutoEnabler = set;
            this.doEnablement();
        }

        protected void initialize() {
            super.initialize();
            this.textField.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doEnablement();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doEnablement();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doEnablement();
                }
            });
        }

        private void doEnablement() {
            if (this.isAutoEnabler) {
                if (this.textField.getText().isEmpty()) {
                    this.setValid(false);
                } else {
                    this.setValid(true);
                }
            } else {
                this.setValid(true);
            }
        }
    }
}

