/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.gedcom.gedcomvalidate;

import ancestris.modules.gedcom.gedcomvalidate.GedcomValidate;
import ancestris.modules.gedcom.gedcomvalidate.Test;
import genj.gedcom.Property;
import genj.gedcom.PropertyComparator;
import genj.gedcom.TagPath;
import genj.view.ViewContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openide.util.NbBundle;

public class TestOrder
extends Test {
    private final String tagToSort;
    private final TagPath pathToSort;

    TestOrder(String trigger, String tagToSort, String pathToSortBy) {
        super(trigger, Property.class);
        this.tagToSort = tagToSort;
        this.pathToSort = new TagPath(pathToSortBy);
    }

    @Override
    void test(Property prop, TagPath trigger, List<ViewContext> issues, GedcomValidate report) {
        ArrayList<Property> unsorted = new ArrayList<Property>(prop.getNoOfProperties());
        for (Property sort : prop.getProperties()) {
            Property by;
            if (!sort.getTag().equals(this.tagToSort) || (by = sort.getProperty(this.pathToSort)) == null || !by.isValid()) continue;
            unsorted.add(sort);
        }
        Property[] sorted = Property.toArray(unsorted);
        Arrays.sort(sorted, new PropertyComparator(this.pathToSort));
        if (!Arrays.asList(sorted).equals(unsorted)) {
            issues.add(new ViewContext(prop).setCode(this.getCode()).setText(NbBundle.getMessage(this.getClass(), (String)("warn.order." + this.tagToSort))));
        }
    }

    @Override
    String getCode() {
        return "09";
    }
}

