/*
 * Decompiled with CFR 0.152.
 */
package ancestris.report.svgtree;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.report.svgtree.graphics.GraphicsFileOutput;
import ancestris.report.svgtree.graphics.GraphicsOutput;
import ancestris.report.svgtree.graphics.PdfWriter;
import ancestris.report.svgtree.graphics.PngWriter;
import ancestris.report.svgtree.graphics.SvgWriter;
import genj.report.Report;
import genj.report.Translator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.NbBundle;

public class GraphicsOutputFactory {
    private static final Logger LOG = Logger.getLogger("ancestris.report.svgtree.GraphicsOutputFactory", null);
    public int output_type = 0;
    public String[] output_types = null;
    private final Map<String, GraphicsOutput> outputs = new LinkedHashMap<String, GraphicsOutput>();
    public List<GraphicsOutput> outputList = new ArrayList<GraphicsOutput>();
    protected int preview_type = 3;
    private final Translator translator;

    public GraphicsOutputFactory(Translator translator) {
        this.translator = translator;
        this.add(translator.translate("output_type.svg"), new SvgWriter());
        this.add(translator.translate("output_type.pdf"), new PdfWriter());
        this.add(translator.translate("output_type.png"), new PngWriter());
        this.add(translator.translate("output_type.screen"), new SvgWriter());
    }

    public GraphicsOutput createOutput(Report report) {
        GraphicsOutput output = this.outputList.get(this.output_type);
        if (output == null) {
            return null;
        }
        if (output instanceof GraphicsFileOutput) {
            File file;
            GraphicsFileOutput fileOutput = (GraphicsFileOutput)output;
            String extension = fileOutput.getFileExtension();
            if (this.output_type == this.preview_type) {
                try {
                    file = File.createTempFile("ancestris_svg", ".svg");
                    file.deleteOnExit();
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, NbBundle.getMessage(this.getClass(), (String)"output.error.tmpsvg"), ex);
                    return null;
                }
            } else {
                file = report.getFileFromUser(report.translate("output.file"), AbstractAncestrisAction.TXT_OK, true, extension, "");
                if (file == null) {
                    return null;
                }
                String suffix = "." + extension;
                if (!file.getPath().endsWith(suffix)) {
                    file = new File(file.getPath() + suffix);
                }
            }
            fileOutput.setFile(file);
        }
        return output;
    }

    public final void add(String name, GraphicsOutput output) {
        this.outputs.put(name, output);
        this.outputList.add(output);
        this.output_types = this.outputs.keySet().toArray(new String[0]);
    }
}

