/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.pedigree;

import ancestris.core.TextOptions;
import ancestris.reports.FormatIDOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingMainOptions;
import ancestris.reports.FormattingPedigreeOptions;
import ancestris.reports.PedigreeColorsOptions;
import ancestris.reports.ScopeIndiMiniOptions;
import ancestris.reports.utils.SvgUtils;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.report.Report;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGGraphics2DIOException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class ReportPedigree
extends Report {
    public MyFormattingOptions formattingOptions = new MyFormattingOptions();
    public MyScope scope = new MyScope();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    public PedigreeColorsOptions colors = new PedigreeColorsOptions();
    private static final Charset SVG_CHARSET = Charset.forName("UTF-8");
    private static final int MAX_GENERATIONS = 7;
    private static final int BORDER_TOP = 10;
    private static final int BORDER_LEFT = 10;
    private static final int SVG_HEIGHT = 1240;
    private static final int SVG_WIDTH = 1754;
    private static final int BLANK_LENGTH = 50;
    private static final int BOX_PADDING = 10;
    private static final int TEXT_PADDING = 10;
    private static final int NB_LINES = 5;
    private Document document;
    private SVGGraphics2D svgGenerator;
    private String reportTitle;
    private int pageWidth = 0;
    private int pageHeight = 0;
    private int colWidth = 0;
    private int lineHeight = 0;
    private int fullTitleHeight = 0;
    private int vertColSpace = 0;
    private List<Indibox> indiboxes;
    private int maxBoxHeight = 0;
    private Map<Integer, Integer> maxWidthMap;
    private Map<Integer, Integer> xMap;

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi) {
            return super.getName();
        }
        return null;
    }

    public File start(Gedcom gedcom) {
        Indi indi = this.scope.common.getScope(gedcom, this);
        return indi != null ? this.main(indi) : null;
    }

    public File start(Indi indi) {
        return indi != null ? this.main(indi) : null;
    }

    public File main(Indi indi) {
        File file;
        try {
            file = File.createTempFile("ancestris_svg", ".svg");
            file.deleteOnExit();
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, this.translate("output.error.creation"), ex);
            return null;
        }
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        this.document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        this.svgGenerator = new SVGGraphics2D(this.document);
        this.svgGenerator.getGeneratorContext().setComment("Generated by Ancestris with Batik SVG Generator");
        this.drawPedigree(indi);
        try {
            PrintWriter writer = this.getWriter(new FileOutputStream(file));
            this.svgGenerator.stream((Writer)writer);
            writer.flush();
            writer.close();
        }
        catch (FileNotFoundException | SVGGraphics2DIOException ex) {
            LOG.log(Level.INFO, this.translate("output.error.writing"), ex);
            return null;
        }
        return file;
    }

    private PrintWriter getWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, SVG_CHARSET));
    }

    private void drawPedigree(Indi indi) {
        int gridCols = this.scope.nbGenerations = Math.max(1, Math.min(7, this.scope.nbGenerations));
        int gridRows = (int)Math.pow(2.0, gridCols - 1);
        this.reportTitle = indi.getDisplayTitle(true);
        this.pageWidth = this.formattingOptions.common.isPortraitOrientation() ? 1240 : 1754;
        this.pageHeight = this.formattingOptions.common.isPortraitOrientation() ? 1754 : 1240;
        this.svgGenerator.setSVGCanvasSize(new Dimension(this.pageWidth, this.pageHeight));
        this.svgGenerator.setPaint((Paint)this.colors.canvasColor);
        this.svgGenerator.fill((Shape)new Rectangle(0, 0, this.pageWidth, this.pageHeight));
        BasicStroke line = new BasicStroke(1.0f);
        this.svgGenerator.setColor(this.colors.borderColor);
        this.svgGenerator.setStroke((Stroke)line);
        this.svgGenerator.drawRect(10, 10, this.pageWidth - 20, this.pageHeight - 20);
        this.svgGenerator.setColor(this.colors.titleColor);
        Font titleFont = this.formattingOptions.common.getTitleFont();
        this.svgGenerator.setFont(titleFont);
        String title = this.translate("title", new Object[]{this.reportTitle});
        Rectangle2D rectTitle = SvgUtils.getTextSize(title, titleFont);
        int titleW = (int)rectTitle.getWidth();
        int titleH = (int)rectTitle.getHeight();
        this.svgGenerator.drawString(title, this.pageWidth / 2 - titleW / 2, 20 + titleH);
        this.fullTitleHeight = 30 + titleH;
        int width = this.pageWidth - 20;
        int height = this.pageHeight - this.fullTitleHeight - 10;
        this.colWidth = width / gridCols;
        this.lineHeight = height / gridRows;
        this.maxBoxHeight = height / gridRows * 8 / 10;
        if (this.maxBoxHeight > this.pageWidth / 8) {
            this.maxBoxHeight = this.pageWidth / 8;
        }
        this.indiboxes = new ArrayList<Indibox>();
        this.maxWidthMap = new HashMap<Integer, Integer>();
        this.buildTree(1, indi, 1, null);
        this.xMap = new HashMap<Integer, Integer>();
        this.drawTree();
    }

    private void buildTree(int level, Indi indi, Integer sosa, Indibox previous) {
        Fam famc;
        if (level > this.scope.nbGenerations) {
            return;
        }
        Indibox indibox = new Indibox(level, indi, sosa, this.scope.nbGenerations, previous);
        this.indiboxes.add(indibox);
        Integer width = this.maxWidthMap.get(level);
        Integer maxWidth = (int)indibox.dim.getWidth();
        if (width != null && width > maxWidth) {
            maxWidth = width;
        }
        this.maxWidthMap.put(level, maxWidth);
        Indi father = null;
        Indi mother = null;
        if (indi != null && (famc = indi.getFamilyWhereBiologicalChild()) != null) {
            father = famc.getHusband();
            mother = famc.getWife();
        }
        this.buildTree(level + 1, father, 2 * sosa, indibox);
        this.buildTree(level + 1, mother, 2 * sosa + 1, indibox);
    }

    private void drawTree() {
        for (Indibox indibox : this.indiboxes) {
            indibox.setMaxWidth(this.maxWidthMap);
        }
        int colWidthTotal = 0;
        for (Integer level2 : this.maxWidthMap.keySet()) {
            colWidthTotal += this.maxWidthMap.get(level2).intValue();
        }
        this.vertColSpace = (this.pageWidth - 20 - colWidthTotal) / (this.scope.nbGenerations + 1);
        if (this.vertColSpace < 10) {
            this.vertColSpace = 10;
        }
        int n = Integer.MAX_VALUE;
        Integer level = this.scope.nbGenerations;
        while (level > 0) {
            int n2;
            int w232 = this.maxWidthMap.get(level);
            int x = (level - 1) * this.colWidth + this.colWidth / 2 + 10 - w232 / 2;
            if (level == this.scope.nbGenerations && level > 1) {
                x = this.pageWidth - 10 - this.vertColSpace - w232;
            }
            if (x + w232 > n2 && level == this.scope.nbGenerations - 1) {
                x = n2 - this.vertColSpace - w232;
            }
            if (x + w232 > n2 && level < this.scope.nbGenerations - 1) {
                x = level == 1 ? 20 : n2 - this.vertColSpace - w232 / (this.scope.nbGenerations - level);
            }
            if (x < 20) {
                x = 20;
            }
            this.xMap.put(level, x);
            n2 = x;
            Integer w232 = level;
            level = level - 1;
        }
        if (this.scope.nbGenerations >= 4) {
            int from = this.xMap.get(1);
            int to = this.xMap.get(this.scope.nbGenerations - 1);
            int space = (to - from) / (this.scope.nbGenerations - 2);
            for (int i = 2; i <= this.scope.nbGenerations - 2; ++i) {
                this.xMap.put(i, from + (i - 1) * space);
            }
        }
        for (Indibox indibox : this.indiboxes) {
            this.drawBox(indibox);
        }
        for (int level3 = this.scope.nbGenerations; level3 > 1; --level3) {
            for (Indibox indibox : this.indiboxes) {
                if (indibox.level != level3) continue;
                this.drawConnector(indibox, indibox.previous);
            }
        }
    }

    private Point getPoint(int gen, int sosa) {
        int x = (int)(Math.log(sosa) / Math.log(2.0));
        int y = (2 * sosa - (int)Math.pow(2.0, x + 1) + 1) * (int)Math.pow(2.0, gen - x - 1) - 1;
        return new Point(x, y);
    }

    private void drawBox(Indibox indibox) {
        int x = this.xMap.get(indibox.level);
        int y = indibox.p.y * this.lineHeight / 2 + this.lineHeight / 2 + this.fullTitleHeight;
        int w = (int)indibox.dim.getWidth();
        int h = (int)indibox.dim.getHeight();
        y -= h / 2;
        this.svgGenerator.setPaint((Paint)this.colors.boxBackgroundColor);
        if (this.formattingOptions.pedigree.roundedRect) {
            this.svgGenerator.fillRoundRect(x, y, w, h, 20, 20);
        } else {
            this.svgGenerator.fillRect(x, y, w, h);
        }
        this.svgGenerator.setColor(this.colors.boxBorderColor);
        if (this.formattingOptions.pedigree.roundedRect) {
            this.svgGenerator.drawRoundRect(x, y, w, h, 20, 20);
        } else {
            this.svgGenerator.drawRect(x, y, w, h);
        }
        this.svgGenerator.setColor(this.colors.boxTextColor);
        Rectangle2D rectTitle = SvgUtils.getTextSize(indibox.labelLines[0], this.formattingOptions.common.getFont().deriveFont(1));
        int textH = (int)rectTitle.getHeight();
        int textY = y + 10 + textH - 1;
        if (h < 20 + textH) {
            textY = y + h / 2 + textH / 2 - 1;
        }
        this.svgGenerator.setFont(this.formattingOptions.common.getFont().deriveFont(1));
        this.svgGenerator.drawString(indibox.labelLines[0], x + 10, textY);
        this.svgGenerator.setFont(this.formattingOptions.common.getFont());
        for (int l = 1; l < 5 && y + h > textY + 10 + textH + 10; ++l) {
            textY = textY + 10 + textH;
            this.svgGenerator.drawString(indibox.labelLines[l], x + 10, textY);
        }
        indibox.setCoord(x, y);
    }

    private void drawConnector(Indibox indibox, Indibox previous) {
        if (previous == null) {
            return;
        }
        int attach = (int)previous.dim.getWidth() / 2;
        if (previous.coord.x + attach > indibox.coord.x) {
            attach = (indibox.coord.x - previous.coord.x) / 2;
        }
        int w = (int)indibox.dim.getHeight();
        BasicStroke line = new BasicStroke(1.0f);
        if (this.formattingOptions.pedigree.dashed) {
            line = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{3.0f}, 0.0f);
        }
        this.svgGenerator.setStroke((Stroke)line);
        this.svgGenerator.setColor(this.colors.lineColor);
        if (indibox.coord.y < previous.coord.y) {
            this.svgGenerator.drawLine(previous.coord.x + attach, previous.coord.y, previous.coord.x + attach, indibox.coord.y + w / 2);
            this.svgGenerator.drawLine(previous.coord.x + attach, indibox.coord.y + w / 2, indibox.coord.x, indibox.coord.y + w / 2);
        } else {
            this.svgGenerator.drawLine(previous.coord.x + attach, previous.coord.y + w, previous.coord.x + attach, indibox.coord.y + w - w / 2);
            this.svgGenerator.drawLine(previous.coord.x + attach, indibox.coord.y + w - w / 2, indibox.coord.x, indibox.coord.y + w - w / 2);
        }
    }

    public class MyFormattingOptions {
        public FormattingMainOptions common = new FormattingMainOptions();
        public FormattingPedigreeOptions pedigree = new FormattingPedigreeOptions();
    }

    public class MyScope {
        public ScopeIndiMiniOptions common = new ScopeIndiMiniOptions();
        public int nbGenerations = 5;
    }

    public class MyDataFormatOptions {
        public FormatIDOptions id = new FormatIDOptions();
        public FormatPlaceOptions place = new FormatPlaceOptions();
    }

    private class Indibox {
        private int level;
        private Point p;
        private Indibox previous;
        private Rectangle2D dim;
        private String[] labelLines;
        private Point coord;

        public Indibox(int level, Indi indi, Integer sosa, int nbGen, Indibox previous) {
            this.level = level;
            this.p = ReportPedigree.this.getPoint(nbGen, sosa);
            this.previous = previous;
            this.labelLines = new String[5];
            if (indi != null) {
                String id = ReportPedigree.this.dataFormatOptions.id.getId(indi);
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(sosa));
                sb.append(" - ");
                if (!id.isBlank()) {
                    sb.append(id);
                    sb.append(" - ");
                }
                sb.append(indi.getDisplayTitle(false));
                this.labelLines[0] = sb.toString();
                this.labelLines[1] = TextOptions.getInstance().getBirthSymbol() + " " + ReportPedigree.this.dataFormatOptions.place.getPlace((Property)indi.getBirthPlaceOption());
                this.labelLines[2] = TextOptions.getInstance().getDeathSymbol() + " " + ReportPedigree.this.dataFormatOptions.place.getPlace((Property)indi.getDeathPlaceOption());
                Property[] occus = indi.getProperties("OCCU");
                Property occu = occus.length > 0 ? occus[occus.length - 1] : null;
                this.labelLines[3] = TextOptions.getInstance().getOccuSymbol() + " " + (occu == null ? "" : occu.getDisplayValue());
                Property[] resis = indi.getProperties("RESI");
                Property resi = resis.length > 0 ? resis[resis.length - 1] : null;
                this.labelLines[4] = TextOptions.getInstance().getResiSymbol() + " " + (resi == null ? "" : ReportPedigree.this.dataFormatOptions.place.getPlace(resi.getProperty("PLAC")));
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(String.valueOf(sosa));
                sb.append(" - ");
                sb.append(" ".repeat(50));
                this.labelLines[0] = sb.toString();
                this.labelLines[1] = "";
                this.labelLines[2] = "";
                this.labelLines[3] = "";
                this.labelLines[4] = "";
            }
            Rectangle2D rect = SvgUtils.getTextSize(this.labelLines[0] + "MM", ReportPedigree.this.formattingOptions.common.getFont().deriveFont(1));
            rect.setRect(rect.getX(), rect.getY(), rect.getWidth() + 20.0, ReportPedigree.this.maxBoxHeight);
            for (int l = 1; l < 5; ++l) {
                Rectangle2D rectOther = SvgUtils.getTextSize(this.labelLines[l] + "MM", ReportPedigree.this.formattingOptions.common.getFont());
                if (!(rectOther.getWidth() > rect.getWidth())) continue;
                rect.setRect(rect.getX(), rect.getY(), rectOther.getWidth(), rect.getHeight());
            }
            this.dim = rect;
        }

        public void setMaxWidth(Map<Integer, Integer> map) {
            this.dim.setRect(this.dim.getX(), this.dim.getY(), map.get(this.level).intValue(), this.dim.getHeight());
        }

        public void setCoord(int x, int y) {
            this.coord = new Point(x, y);
        }
    }
}

