/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.view.util;

import java.util.logging.Logger;
import org.graphstream.ui.geom.Point3;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.Value;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.miv.pherd.geom.Vector3;

public class GraphMetrics {
    private static final Logger logger = Logger.getLogger(GraphMetrics.class.getSimpleName());
    public Point3 lo = new Point3();
    public Point3 hi = new Point3();
    public Point3 loVisible = new Point3();
    public Point3 hiVisible = new Point3();
    public Vector3 size = new Vector3();
    public double diagonal = 1.0;
    public double[] viewport = new double[4];
    public double ratioPx2Gu;
    public double px1;

    public GraphMetrics() {
        this.setDefaults();
    }

    protected void setDefaults() {
        this.lo.set(-1.0, -1.0, -1.0);
        this.hi.set(1.0, 1.0, 1.0);
        this.size.set(2.0, 2.0, 2.0);
        this.diagonal = 1.0;
        this.ratioPx2Gu = 1.0;
        this.px1 = 1.0;
    }

    public double getDiagonal() {
        return this.diagonal;
    }

    public Vector3 getSize() {
        return this.size;
    }

    public Point3 getLowPoint() {
        return this.lo;
    }

    public Point3 getHighPoint() {
        return this.hi;
    }

    public double graphWidthGU() {
        return this.hi.x - this.lo.x;
    }

    public double graphHeightGU() {
        return this.hi.y - this.lo.y;
    }

    public double graphDepthGU() {
        return this.hi.z - this.lo.z;
    }

    public double lengthToGu(double value, StyleConstants.Units units) {
        switch (units) {
            case PX: {
                return value / this.ratioPx2Gu;
            }
            case PERCENTS: {
                return this.diagonal * value;
            }
        }
        return value;
    }

    public double lengthToGu(Value value) {
        return this.lengthToGu(value.value, value.units);
    }

    public double lengthToGu(Values values, int index) {
        return this.lengthToGu(values.get(index), values.units);
    }

    public double lengthToPx(double value, StyleConstants.Units units) {
        switch (units) {
            case GU: {
                return value * this.ratioPx2Gu;
            }
            case PERCENTS: {
                return this.diagonal * value * this.ratioPx2Gu;
            }
        }
        return value;
    }

    public double lengthToPx(Value value) {
        return this.lengthToPx(value.value, value.units);
    }

    public double lengthToPx(Values values, int index) {
        return this.lengthToPx(values.get(index), values.units);
    }

    public double positionPixelToGu(int pixels, int index) {
        double l = this.lengthToGu(pixels, StyleConstants.Units.PX);
        switch (index) {
            case 0: {
                l -= this.graphWidthGU() / 2.0;
                l = (this.hi.x + this.lo.x) / 2.0 + l;
                break;
            }
            case 1: {
                l -= this.graphHeightGU() / 2.0;
                l = (this.hi.y + this.lo.y) / 2.0 + l;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        logger.fine(String.format("%spixel[%d] %d --> %fgu", this, index, pixels, l));
        return l;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(String.format("Graph Metrics :%n", new Object[0]));
        builder.append(String.format("        lo         = %s%n", this.lo));
        builder.append(String.format("        hi         = %s%n", this.hi));
        builder.append(String.format("        visible lo = %s%n", this.loVisible));
        builder.append(String.format("        visible hi = %s%n", this.hiVisible));
        builder.append(String.format("        size       = %s%n", this.size));
        builder.append(String.format("        diag       = %f%n", this.diagonal));
        builder.append(String.format("        viewport   = %s%n", new Object[]{this.viewport}));
        builder.append(String.format("        ratio      = %fpx = 1gu%n", this.ratioPx2Gu));
        return builder.toString();
    }

    public void setViewport(double viewportX, double viewportY, double viewportWidth, double viewportHeight) {
        this.viewport[0] = viewportX;
        this.viewport[1] = viewportY;
        this.viewport[2] = viewportWidth;
        this.viewport[3] = viewportHeight;
    }

    public void setRatioPx2Gu(double ratio) {
        if (ratio > 0.0) {
            this.ratioPx2Gu = ratio;
            this.px1 = (double)0.95f / this.ratioPx2Gu;
        } else {
            if (ratio == 0.0) {
                throw new RuntimeException("ratio PX to GU cannot be zero");
            }
            if (ratio < 0.0) {
                throw new RuntimeException(String.format("ratio PX to GU cannot be negative (%f)", ratio));
            }
        }
    }

    public void setBounds(double minx, double miny, double minz, double maxx, double maxy, double maxz) {
        this.lo.x = minx;
        this.lo.y = miny;
        this.lo.z = minz;
        this.hi.x = maxx;
        this.hi.y = maxy;
        this.hi.z = maxz;
        this.size.data[0] = this.hi.x - this.lo.x;
        this.size.data[1] = this.hi.y - this.lo.y;
        this.size.data[2] = this.hi.z - this.lo.z;
        this.diagonal = Math.sqrt(this.size.data[0] * this.size.data[0] + this.size.data[1] * this.size.data[1] + this.size.data[2] * this.size.data[2]);
    }
}

