/*
 * Decompiled with CFR 0.152.
 */
package ancestris.startup.settings;

import ancestris.startup.settings.Util;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Properties;
import org.openide.util.Utilities;

public class PropertiesLike
extends Properties {
    public static final String LF = System.getProperty("line.separator");
    public static final String PROP_ESCAPE = "nb-settings.escape";

    public PropertiesLike() {
    }

    public PropertiesLike(Properties def) {
        super(def);
    }

    public PropertiesLike(String pathToLoad) throws IOException {
        FileInputStream fileIn = new FileInputStream(pathToLoad);
        this.load(fileIn);
        Util.close(fileIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void load(InputStream inStream) throws IOException {
        block6: {
            block5: {
                if (!Utilities.isWindows()) break block5;
                BufferedReader bf = null;
                ByteArrayOutputStream byteOut = null;
                ByteArrayInputStream byteIn = null;
                try {
                    String line;
                    bf = new BufferedReader(new InputStreamReader(inStream));
                    byteOut = new ByteArrayOutputStream();
                    while ((line = bf.readLine()) != null) {
                        if (line.indexOf("jdkhome") > -1 || line.indexOf("default_userdir") > -1 || line.indexOf("default_mac_userdir") > -1) {
                            line = line.replace('\\', '/');
                        }
                        if (line.indexOf("default_options") > -1) {
                            line = line.replace("\\\"", "");
                            line = line.replace("\\", "/");
                            line = line.replace("\\t", "/t");
                        }
                        byteOut.write(line.getBytes());
                        byteOut.write(LF.getBytes());
                    }
                    byteOut.flush();
                    byteIn = new ByteArrayInputStream(byteOut.toByteArray());
                    super.load(byteIn);
                }
                catch (Throwable throwable) {
                    Util.close(byteIn);
                    Util.close(byteOut);
                    Util.close(bf);
                    throw throwable;
                }
                Util.close(byteIn);
                Util.close(byteOut);
                Util.close(bf);
                break block6;
            }
            super.load(inStream);
        }
    }

    @Override
    public void store(OutputStream out, String comments) throws IOException {
        boolean escape = Boolean.getBoolean(PROP_ESCAPE);
        if (escape) {
            super.store(out, comments);
        } else {
            StringBuilder buff = new StringBuilder("###");
            buff.append(comments);
            buff.append(LF);
            for (String key : this.stringPropertyNames()) {
                String value = this.getProperty(key);
                buff.append(key).append("=").append(value).append(LF);
            }
            out.write(buff.toString().getBytes());
        }
    }

    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        PropertiesLike props = new PropertiesLike("/home/claudio/downloads/netbeans.conf");
        ((Properties)props).store(byteOut, "netbeans configuration file generated by nb-settings module");
        System.out.println(byteOut.toString());
        System.out.println(System.getProperty("user.home"));
    }
}

