/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.aries.models;

import genj.gedcom.Gedcom;
import genj.gedcom.Property;
import genj.gedcom.values.EnumOperations;
import genj.gedcom.values.NameTypeEnum;
import genj.util.ReferenceSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.DefaultComboBoxModel;
import org.openide.util.NbBundle;

public class NameTypeComboBoxModel
extends DefaultComboBoxModel<String> {
    static final Map<String, String> NAME_TYPE_COMBO_BOX = new HashMap<String, String>(){
        {
            this.put("aka", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.aka"));
            this.put("birth", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.birth"));
            this.put("immigrant", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.immigrant"));
            this.put("maiden", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.maiden"));
            this.put("married", NbBundle.getMessage(NameTypeComboBoxModel.class, (String)"NameTypeComboBoxModelModel.NamesType.married"));
        }
    };
    private final Set<String> elements = new HashSet<String>(4);

    public void setGedcom(Gedcom gedcom) {
        this.removeAllElements();
        if (!gedcom.isGrammar7()) {
            ReferenceSet gedcomList = gedcom.getReferenceSet("NAME-TYPE");
            for (String key : gedcomList.getKeys()) {
                Set propList = gedcomList.getReferences((Object)key);
                this.elements.addAll(propList.stream().filter(prop -> "NAME".equals(prop.getParent().getTag())).map(Property::getValue).collect(Collectors.toSet()));
            }
        }
        this.addDefault(gedcom);
    }

    private void addDefault(Gedcom gedcom) {
        if (gedcom.isGrammar7()) {
            for (String s2 : EnumOperations.getDisplayChoices((Enum[])NameTypeEnum.values())) {
                this.addElement(s2);
            }
        } else {
            this.elements.addAll(NAME_TYPE_COMBO_BOX.values());
            List<String> elemList = this.elements.stream().sorted().collect(Collectors.toList());
            elemList.forEach(s -> this.addElement(s));
        }
    }
}

