/*
 * Decompiled with CFR 0.152.
 */
package ancestris.reports.families;

import ancestris.reports.FilterOptions;
import ancestris.reports.FormatDateOptions;
import ancestris.reports.FormatPlaceOptions;
import ancestris.reports.FormattingOptions;
import ancestris.reports.ScopeFamOptions;
import ancestris.reports.SimpleColorsOptions;
import ancestris.reports.utils.ColorUtils;
import ancestris.reports.utils.PropUtils;
import ancestris.reports.utils.StringFiller;
import ancestris.util.Utilities;
import genj.fo.Document;
import genj.gedcom.Entity;
import genj.gedcom.Fam;
import genj.gedcom.Gedcom;
import genj.gedcom.Indi;
import genj.gedcom.Property;
import genj.gedcom.PropertyEvent;
import genj.report.Report;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ReportFamilies
extends Report {
    private static final String FONTWEIGHTBOLD = "font-weight=bold";
    public FormattingOptions formattingOptions = new FormattingOptions();
    public ScopeFamOptions scope = new ScopeFamOptions();
    public boolean reportParents = true;
    public boolean reportOtherSpouses = true;
    public boolean reportChildren = true;
    public boolean reportOtherEvents = true;
    public FilterOptions filterOptions = new FilterOptions();
    public MyDataFormatOptions dataFormatOptions = new MyDataFormatOptions();
    private final SimpleColorsOptions defaultColor = new SimpleColorsOptions();
    public Colors colors = new Colors();
    private Document doc;
    private Gedcom gedcom;
    private static final String BG_HUSB = "#6fc2ec";
    private static final String BG_HUSBPARENTS = "#b8e6fe";
    private static final String BG_WIFE = "#fe7d91";
    private static final String BG_WIFEPARENTS = "#fcb9c2";
    private static final String BG_HUSBUNION = "#f5f1e6";
    private static final String BG_WIFEUNION = "#ffe4cf";
    private static final String BG_FAMILY = "#d1f8e6";
    private static final String SPAN_ALL = "number-columns-spanned=4";
    private static final String SPAN_2 = "number-columns-spanned=2";

    public String accepts(Object context) {
        if (context instanceof Gedcom || context instanceof Indi || context instanceof Fam || context instanceof Indi[]) {
            return super.getName();
        }
        return null;
    }

    public Document start(Gedcom gedcom) {
        this.gedcom = gedcom;
        List<Fam> fams = this.scope.getScope(gedcom, this);
        return fams != null ? this.main(fams) : null;
    }

    public Document start(Entity entity) {
        this.gedcom = entity.getGedcom();
        List<Fam> fams = this.scope.getScope(entity, this);
        return fams != null ? this.main(fams) : null;
    }

    public Document start(Indi[] indis) {
        if (indis.length == 0) {
            return null;
        }
        this.gedcom = indis[0].getGedcom();
        ArrayList<Fam> fams = new ArrayList<Fam>();
        for (Indi indi : indis) {
            fams.addAll(Arrays.asList(indi.getFamiliesWhereChild()));
            fams.addAll(Arrays.asList(indi.getFamiliesWhereSpouse()));
        }
        return this.main(fams);
    }

    public Document main(List<Fam> fams) {
        String bgHeaderRow = ColorUtils.color2string(this.colors.bgHeaderRow);
        String bgHusb = ColorUtils.color2string(this.colors.bgHusb);
        String bgWife = ColorUtils.color2string(this.colors.bgWife);
        String bgHusbParents = ColorUtils.color2string(this.colors.bgHusbParents);
        String bgWifeParents = ColorUtils.color2string(this.colors.bgWifeParents);
        String bgHusbUnion = ColorUtils.color2string(this.colors.bgHusbUnion);
        String bgWifeUnion = ColorUtils.color2string(this.colors.bgWifeUnion);
        String bgFamily = ColorUtils.color2string(this.colors.bgFamily);
        String textColor = ColorUtils.color2string(this.colors.fgText);
        String backColor = ColorUtils.color2string(this.colors.bgColor);
        ArrayList<FamRecord> records = new ArrayList<FamRecord>();
        for (Fam fam : fams) {
            Iterator<String[]> record;
            if (!this.filterOptions.matchRecord((Property)fam, ((FamRecord)((Object)(record = new FamRecord(fam)))).getSortTitle(), ((FamRecord)((Object)record)).toString().toLowerCase())) continue;
            records.add((FamRecord)((Object)record));
        }
        Collections.sort(records, (o1, o2) -> ((FamRecord)o1).getSortTitle().compareTo(((FamRecord)o2).getSortTitle()));
        String number = "" + records.size();
        String title = this.translate("title", new Object[]{number, this.gedcom.getDisplayName()});
        this.doc = this.formattingOptions.createDocument(this.translate("name"), textColor, backColor);
        this.doc.startSection(title, "title", 1, false, false, "font-size=" + this.formattingOptions.getTitleSize() + ",text-align=center, space-before=0cm, space-after=1cm");
        if (this.formattingOptions.includeTOC) {
            this.doc.addTOC(2, false, true);
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.scope.isLimited()) {
            this.doc.addText(this.scope.getMainMessage(), FONTWEIGHTBOLD);
            for (String[] scopeLine : this.scope.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + scopeLine[0]);
                if (scopeLine[1].isBlank()) continue;
                this.doc.addText(" : " + scopeLine[1], FONTWEIGHTBOLD);
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        if (this.filterOptions.isFilterOn()) {
            this.doc.addText(this.filterOptions.getMainMessage(), FONTWEIGHTBOLD);
            for (String[] filterLine : this.filterOptions.getMessages()) {
                this.doc.nextParagraph();
                this.doc.addText("\u2219  " + filterLine[0]);
                if (filterLine[1].isBlank()) continue;
                this.doc.addText(" : " + filterLine[1], FONTWEIGHTBOLD);
            }
            this.doc.nextParagraph("space-before=1cm");
        }
        this.doc.startTable("genj:csv=true, width=100%, border-style=none, border=0, space-before=1cm, , border-color=" + textColor);
        String letter = "";
        for (FamRecord fam : records) {
            String newLetter = fam.letter;
            if (!newLetter.equals(letter) && this.formattingOptions.includeTOC) {
                letter = newLetter;
                this.doc.nextTableRow("page-break-before=always");
                this.doc.nextTableCell(SPAN_ALL);
                this.doc.addTOCEntry(letter);
                this.doc.addLink("^^^", "title");
                this.doc.nextParagraph();
                this.doc.addText(letter, "font-size=" + (this.formattingOptions.getTextSize() + 4) + ", font-weight=bold");
            }
            this.doc.nextTableRow("font-size=" + (this.formattingOptions.getTextSize() + 2) + ", text-align=center, font-weight=bold, background-color=" + bgHeaderRow);
            this.doc.nextTableCell(SPAN_ALL);
            this.doc.addText(fam.titleVal + " ");
            this.doc.addLink(fam.titleId, fam.titleLink);
            this.doc.nextTableRow();
            this.doc.nextTableCell("background-color=" + bgHusb);
            IndiRecord husb = fam.husb;
            if (!husb.id.isBlank()) {
                this.doc.addText(husb.val, FONTWEIGHTBOLD);
                this.doc.addText(" ");
                this.doc.addLink(husb.id, husb.link);
            } else {
                this.doc.addText(" ");
            }
            this.doc.nextTableCell("background-color=" + bgHusb);
            this.doc.addText(" ");
            this.doc.nextTableCell("background-color=" + bgWife);
            IndiRecord wife = fam.wife;
            if (!wife.id.isBlank()) {
                this.doc.addText(wife.val, FONTWEIGHTBOLD);
                this.doc.addText(" ");
                this.doc.addLink(wife.id, wife.link);
            } else {
                this.doc.addText(" ");
            }
            this.doc.nextTableCell("background-color=" + bgWife);
            this.doc.addText(" ");
            if (!(husb.birthPlace.isBlank() && husb.birthDate.isBlank() && wife.birthPlace.isBlank() && wife.birthDate.isBlank())) {
                this.doc.nextTableRow();
                this.doc.nextTableCell("background-color=" + bgHusb);
                this.doc.addText((String)(husb.birthPlace.isBlank() ? "" : this.OPTIONS.getBirthSymbol() + " " + husb.birthPlace));
                this.doc.nextTableCell("text-align=center, background-color=" + bgHusb);
                this.doc.addText((String)(husb.birthDate.isBlank() ? "" : this.OPTIONS.getBirthSymbol() + " " + husb.birthDate));
                this.doc.nextTableCell("background-color=" + bgWife);
                this.doc.addText((String)(wife.birthPlace.isBlank() ? "" : this.OPTIONS.getBirthSymbol() + " " + wife.birthPlace));
                this.doc.nextTableCell("text-align=center, background-color=" + bgWife);
                this.doc.addText((String)(wife.birthDate.isBlank() ? "" : this.OPTIONS.getBirthSymbol() + " " + wife.birthDate));
            }
            if (!(husb.deathPlace.isBlank() && husb.deathDate.isBlank() && wife.deathPlace.isBlank() && wife.deathDate.isBlank())) {
                this.doc.nextTableRow();
                this.doc.nextTableCell("background-color=" + bgHusb);
                this.doc.addText((String)(husb.deathPlace.isBlank() ? "" : this.OPTIONS.getDeathSymbol() + " " + husb.deathPlace));
                this.doc.nextTableCell("text-align=center, background-color=" + bgHusb);
                this.doc.addText((String)(husb.deathDate.isBlank() ? "" : this.OPTIONS.getDeathSymbol() + " " + husb.deathDate));
                this.doc.nextTableCell("background-color=" + bgWife);
                this.doc.addText((String)(wife.deathPlace.isBlank() ? "" : this.OPTIONS.getDeathSymbol() + " " + wife.deathPlace));
                this.doc.nextTableCell("text-align=center, background-color=" + bgWife);
                this.doc.addText((String)(wife.deathDate.isBlank() ? "" : this.OPTIONS.getDeathSymbol() + " " + wife.deathDate));
            }
            if (this.reportParents) {
                if (!fam.husbParentsId.isBlank() || !fam.wifeParentsId.isBlank()) {
                    this.doc.nextTableRow();
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgHusbParents);
                    this.doc.nextParagraph();
                    if (!fam.husbParentsId.isBlank()) {
                        this.doc.addText(fam.parentsTag + " ", FONTWEIGHTBOLD);
                        this.doc.addLink(fam.husbParentsId, fam.husbParentsLink);
                    } else {
                        this.doc.addText("");
                    }
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgWifeParents);
                    this.doc.addText("\u00a0");
                    this.doc.nextParagraph();
                    if (!fam.wifeParentsId.isBlank()) {
                        this.doc.addText(fam.parentsTag + " ", FONTWEIGHTBOLD);
                        this.doc.addLink(fam.wifeParentsId, fam.wifeParentsLink);
                    } else {
                        this.doc.addText("");
                    }
                }
                if (fam.husbFather != null && fam.husbFather.indi != null || fam.wifeFather != null && fam.wifeFather.indi != null) {
                    this.doc.nextTableRow();
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgHusbParents);
                    if (fam.husbFather != null && fam.husbFather.indi != null) {
                        this.doc.addText(fam.husbFather.valdates + " ");
                        this.doc.addLink(fam.husbFather.id, fam.husbFather.link);
                    } else {
                        this.doc.addText(" ");
                    }
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgWifeParents);
                    if (fam.wifeFather != null && fam.wifeFather.indi != null) {
                        this.doc.addText(fam.wifeFather.valdates + " ");
                        this.doc.addLink(fam.wifeFather.id, fam.wifeFather.link);
                    } else {
                        this.doc.addText(" ");
                    }
                }
                if (fam.husbMother != null && fam.husbMother.indi != null || fam.wifeMother != null && fam.wifeMother.indi != null) {
                    this.doc.nextTableRow();
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgHusbParents);
                    if (fam.husbMother != null && fam.husbMother.indi != null) {
                        this.doc.addText(fam.husbMother.valdates + " ");
                        this.doc.addLink(fam.husbMother.id, fam.husbMother.link);
                    } else {
                        this.doc.addText(" ");
                    }
                    this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgWifeParents);
                    if (fam.wifeMother != null && fam.wifeMother.indi != null) {
                        this.doc.addText(fam.wifeMother.valdates + " ");
                        this.doc.addLink(fam.wifeMother.id, fam.wifeMother.link);
                    } else {
                        this.doc.addText(" ");
                    }
                }
            }
            if (this.reportOtherSpouses) {
                Iterator<Object> husbSpousesIt = fam.husbSpouses.iterator();
                Iterator<SpouseRecord> wifeSpousesIt = fam.wifeSpouses.iterator();
                while (husbSpousesIt.hasNext() || wifeSpousesIt.hasNext()) {
                    SpouseRecord husbSpouse = null;
                    SpouseRecord wifeSpouse = null;
                    if (husbSpousesIt.hasNext()) {
                        husbSpouse = (SpouseRecord)husbSpousesIt.next();
                    }
                    if (wifeSpousesIt.hasNext()) {
                        wifeSpouse = wifeSpousesIt.next();
                    }
                    if (husbSpouse != null || wifeSpouse != null) {
                        this.doc.nextTableRow();
                        this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgHusbUnion);
                        this.doc.nextParagraph("");
                        if (husbSpouse != null) {
                            this.doc.addText(fam.unionTag + " ", FONTWEIGHTBOLD);
                            this.doc.addLink(husbSpouse.id, husbSpouse.link);
                        } else {
                            this.doc.addText(" ");
                        }
                        this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgWifeUnion);
                        this.doc.addText("\u00a0");
                        this.doc.nextParagraph("");
                        if (wifeSpouse != null) {
                            this.doc.addText(fam.unionTag + " ", FONTWEIGHTBOLD);
                            this.doc.addLink(wifeSpouse.id, wifeSpouse.link);
                        } else {
                            this.doc.addText(" ");
                        }
                    }
                    if (husbSpouse != null && husbSpouse.spouse.indi != null || wifeSpouse != null && wifeSpouse.spouse.indi != null) {
                        this.doc.nextTableRow();
                        this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgHusbUnion);
                        if (husbSpouse != null && husbSpouse.spouse.indi != null) {
                            this.doc.addText(husbSpouse.spouse.valdates + " ");
                            this.doc.addLink(husbSpouse.spouse.id, husbSpouse.spouse.link);
                        } else {
                            this.doc.addText(" ");
                        }
                        this.doc.nextTableCell("number-columns-spanned=2,background-color=" + bgWifeUnion);
                        if (wifeSpouse != null && wifeSpouse.spouse.indi != null) {
                            this.doc.addText(wifeSpouse.spouse.valdates + " ");
                            this.doc.addLink(wifeSpouse.spouse.id, wifeSpouse.spouse.link);
                        } else {
                            this.doc.addText(" ");
                        }
                    }
                    if (!(husbSpouse != null && !husbSpouse.marrPlace.isBlank() || husbSpouse != null && !husbSpouse.marrDate.isBlank() || wifeSpouse != null && !wifeSpouse.marrPlace.isBlank()) && (wifeSpouse == null || wifeSpouse.marrDate.isBlank())) continue;
                    this.doc.nextTableRow();
                    this.doc.nextTableCell("background-color=" + bgHusbUnion);
                    if (husbSpouse != null && !husbSpouse.marrPlace.isBlank()) {
                        this.doc.addText(this.OPTIONS.getMarriageSymbol() + " " + husbSpouse.marrPlace);
                    } else {
                        this.doc.addText(" ");
                    }
                    this.doc.nextTableCell("text-align=center, background-color=" + bgHusbUnion);
                    if (husbSpouse != null && !husbSpouse.marrDate.isBlank()) {
                        this.doc.addText(this.OPTIONS.getMarriageSymbol() + " " + husbSpouse.marrDate);
                    } else {
                        this.doc.addText(" ");
                    }
                    this.doc.nextTableCell("background-color=" + bgWifeUnion);
                    if (wifeSpouse != null && !wifeSpouse.marrPlace.isBlank()) {
                        this.doc.addText(this.OPTIONS.getMarriageSymbol() + " " + wifeSpouse.marrPlace);
                    } else {
                        this.doc.addText(" ");
                    }
                    this.doc.nextTableCell("text-align=center, background-color=" + bgWifeUnion);
                    if (wifeSpouse != null && !wifeSpouse.marrDate.isBlank()) {
                        this.doc.addText(this.OPTIONS.getMarriageSymbol() + " " + wifeSpouse.marrDate);
                        continue;
                    }
                    this.doc.addText(" ");
                }
            }
            if (!fam.marrDate.isBlank() || !fam.marrPlace.isBlank()) {
                this.doc.nextTableRow("background-color=" + bgFamily);
                this.doc.nextTableCell("");
                this.doc.nextParagraph("");
                this.doc.addText(fam.marrEvent, FONTWEIGHTBOLD);
                this.doc.nextTableCell("text-align=center");
                this.doc.addText("\u00a0");
                this.doc.nextParagraph("");
                this.doc.addText((String)(fam.marrDate.isBlank() ? "" : this.OPTIONS.getMarriageSymbol() + " " + fam.marrDate));
                this.doc.nextTableCell("");
                this.doc.addText("\u00a0");
                this.doc.nextParagraph("");
                this.doc.addText((String)(fam.marrPlace.isBlank() ? "" : this.OPTIONS.getMarriageSymbol() + " " + fam.marrPlace));
                this.doc.nextTableCell("");
                this.doc.addText("");
            }
            if (!fam.children.isEmpty()) {
                this.doc.nextTableRow("background-color=" + bgFamily);
                this.doc.nextTableCell(SPAN_ALL);
                this.doc.nextParagraph("");
                this.doc.addText(fam.childrenTag, FONTWEIGHTBOLD);
            }
            for (IndiRecord child : fam.children) {
                this.doc.nextTableRow("background-color=" + bgFamily);
                this.doc.nextTableCell("");
                this.doc.addText(child.val);
                this.doc.addText(" ");
                this.doc.addLink(child.id, child.link);
                this.doc.nextTableCell("text-align=center");
                this.doc.addText((String)(child.birthDate.isBlank() ? "" : this.OPTIONS.getBirthSymbol() + " " + child.birthDate));
                this.doc.nextTableCell("");
                this.doc.addText(child.birthPlace);
                this.doc.nextTableCell("text-align=center");
                this.doc.addText((String)(child.deathDate.isBlank() ? "" : this.OPTIONS.getDeathSymbol() + " " + child.deathDate));
            }
            int i = 0;
            for (EventRecord event : fam.events) {
                this.doc.nextTableRow("background-color=" + bgFamily);
                this.doc.nextTableCell("");
                if (i == 0) {
                    this.doc.nextParagraph("");
                }
                this.doc.addText(event.tag, FONTWEIGHTBOLD);
                this.doc.nextTableCell("text-align=center");
                if (i == 0) {
                    this.doc.addText("\u00a0");
                    this.doc.nextParagraph("");
                }
                this.doc.addText(event.date);
                this.doc.nextTableCell("");
                if (i == 0) {
                    this.doc.addText("\u00a0");
                    this.doc.nextParagraph("");
                }
                this.doc.addText(event.place);
                this.doc.nextTableCell("");
                this.doc.addText("");
                ++i;
            }
            this.doc.nextTableRow();
            this.doc.nextTableCell(SPAN_ALL);
            this.doc.nextParagraph("");
            this.doc.addText("\u00a0");
        }
        this.doc.endTable();
        return this.doc;
    }

    public class MyDataFormatOptions {
        public FormatPlaceOptions place = new FormatPlaceOptions();
        public FormatDateOptions date = new FormatDateOptions();
    }

    public class Colors {
        public Color fgText;
        public Color bgColor;
        public Color bgHeaderRow;
        public Color bgHusb;
        public Color bgWife;
        public Color bgHusbParents;
        public Color bgWifeParents;
        public Color bgHusbUnion;
        public Color bgWifeUnion;
        public Color bgFamily;

        public Colors() {
            this.fgText = ReportFamilies.this.defaultColor.fgText;
            this.bgColor = ReportFamilies.this.defaultColor.bgColor;
            this.bgHeaderRow = ReportFamilies.this.defaultColor.bgHeaderRow;
            this.bgHusb = ColorUtils.string2color(ReportFamilies.BG_HUSB);
            this.bgWife = ColorUtils.string2color(ReportFamilies.BG_WIFE);
            this.bgHusbParents = ColorUtils.string2color(ReportFamilies.BG_HUSBPARENTS);
            this.bgWifeParents = ColorUtils.string2color(ReportFamilies.BG_WIFEPARENTS);
            this.bgHusbUnion = ColorUtils.string2color(ReportFamilies.BG_HUSBUNION);
            this.bgWifeUnion = ColorUtils.string2color(ReportFamilies.BG_WIFEUNION);
            this.bgFamily = ColorUtils.string2color(ReportFamilies.BG_FAMILY);
        }
    }

    private class FamRecord {
        private Fam fam = null;
        private String letter = "";
        private String titleVal = "";
        private String titleId = "";
        private String titleLink = "";
        private IndiRecord husb = null;
        private Fam husbParents = null;
        private String husbParentsId = "";
        private String husbParentsLink = "";
        private IndiRecord husbFather = null;
        private IndiRecord husbMother = null;
        private List<SpouseRecord> husbSpouses = null;
        private IndiRecord wife = null;
        private Fam wifeParents = null;
        private String wifeParentsId = "";
        private String wifeParentsLink = "";
        private IndiRecord wifeFather = null;
        private IndiRecord wifeMother = null;
        private List<SpouseRecord> wifeSpouses = null;
        private String marrEvent = "";
        private String marrDate = "";
        private String marrPlace = "";
        private List<IndiRecord> children = null;
        private List<EventRecord> events = null;
        private String parentsTag = "";
        private String unionTag = "";
        private String childrenTag = "";

        /*
         * WARNING - void declaration
         */
        public FamRecord(Fam fam) {
            this.fam = fam;
            this.titleId = PropUtils.getIdValue((Entity)fam);
            this.titleLink = fam.getLinkAnchor();
            this.husb = new IndiRecord(fam.getHusband());
            this.wife = new IndiRecord(fam.getWife());
            if (ReportFamilies.this.reportParents) {
                if (this.husb.indi != null) {
                    this.husbParents = this.husb.indi.getFamilyWhereBiologicalChild();
                    if (this.husbParents != null) {
                        this.husbParentsId = PropUtils.getIdValue((Entity)this.husbParents);
                        this.husbParentsLink = this.husbParents.getLinkAnchor();
                        this.husbFather = new IndiRecord(this.husbParents.getHusband());
                        this.husbMother = new IndiRecord(this.husbParents.getWife());
                    }
                }
                if (this.wife.indi != null) {
                    this.wifeParents = this.wife.indi.getFamilyWhereBiologicalChild();
                    if (this.wifeParents != null) {
                        this.wifeParentsId = PropUtils.getIdValue((Entity)this.wifeParents);
                        this.wifeParentsLink = this.wifeParents.getLinkAnchor();
                        this.wifeFather = new IndiRecord(this.wifeParents.getHusband());
                        this.wifeMother = new IndiRecord(this.wifeParents.getWife());
                    }
                }
                if (!this.husbParentsId.isBlank() || !this.wifeParentsId.isBlank()) {
                    this.parentsTag = Gedcom.getReportName((String)"FAMC");
                }
            }
            this.husbSpouses = new ArrayList<SpouseRecord>();
            this.wifeSpouses = new ArrayList<SpouseRecord>();
            if (ReportFamilies.this.reportOtherSpouses) {
                Fam fam1;
                int n2;
                Fam[] famArray;
                Fam[] fams;
                if (this.husb.indi != null) {
                    void var6_9;
                    famArray = fams = this.husb.indi.getFamiliesWhereSpouse(true);
                    n2 = famArray.length;
                    boolean n = false;
                    while (var6_9 < n2) {
                        fam1 = famArray[var6_9];
                        if (fam1 != fam) {
                            this.husbSpouses.add(new SpouseRecord(fam1, fam1.getOtherSpouse(this.husb.indi)));
                        }
                        ++var6_9;
                    }
                }
                if (this.wife.indi != null) {
                    void var6_11;
                    famArray = fams = this.wife.indi.getFamiliesWhereSpouse(true);
                    n2 = famArray.length;
                    boolean bl = false;
                    while (var6_11 < n2) {
                        fam1 = famArray[var6_11];
                        if (fam1 != fam) {
                            this.wifeSpouses.add(new SpouseRecord(fam1, fam1.getOtherSpouse(this.wife.indi)));
                        }
                        ++var6_11;
                    }
                }
                if (!this.husbSpouses.isEmpty() || !this.wifeSpouses.isEmpty()) {
                    this.unionTag = Gedcom.getReportName((String)"FAMS");
                }
            }
            this.marrDate = ReportFamilies.this.dataFormatOptions.date.getDate((Property)fam.getMarriageDate());
            this.marrPlace = ReportFamilies.this.dataFormatOptions.place.getPlace((Property)fam.getMarriagePlace());
            this.marrEvent = this.marrDate.isBlank() && this.marrPlace.isBlank() ? "" : Gedcom.getReportName((String)"MARR");
            this.children = new ArrayList<IndiRecord>();
            if (ReportFamilies.this.reportChildren) {
                for (Fam fam2 : fam.getChildren(true)) {
                    this.children.add(new IndiRecord((Indi)fam2));
                }
            }
            if (!this.children.isEmpty()) {
                this.childrenTag = Gedcom.getName((String)"CHIL", (boolean)true);
            }
            this.events = new ArrayList<EventRecord>();
            if (ReportFamilies.this.reportOtherEvents) {
                for (Fam fam3 : fam.getProperties()) {
                    if (fam3.getTag().matches("HUSB|WIFE|CHIL|MARR") || !(fam3 instanceof PropertyEvent)) continue;
                    this.events.add(new EventRecord((Property)fam3));
                }
            }
            String names = fam.getDisplayTitle(false).split("\\(")[0].trim();
            this.titleVal = names + (String)(this.marrDate.isBlank() ? "" : " (" + this.marrDate + ")");
            this.letter = Utilities.removeDiacritics((String)names.substring(0, 1)).toUpperCase();
        }

        public String getSortTitle() {
            return this.fam.getDisplayTitle(false).toLowerCase();
        }

        public String toString() {
            StringFiller sf = new StringFiller(" ");
            sf.append(this.titleVal);
            sf.append(this.titleId);
            sf.append(this.husb);
            sf.append(this.wife);
            if (ReportFamilies.this.reportParents) {
                sf.append(this.parentsTag);
                sf.append(this.husbParentsId);
                sf.append(this.husbFather);
                sf.append(this.husbMother);
                sf.append(this.wifeParentsId);
                sf.append(this.wifeFather);
                sf.append(this.wifeMother);
            }
            for (SpouseRecord spouseRecord : this.husbSpouses) {
                sf.append(spouseRecord);
            }
            for (SpouseRecord spouseRecord : this.wifeSpouses) {
                sf.append(spouseRecord);
            }
            sf.append(this.marrEvent);
            sf.append(this.marrDate);
            sf.append(this.marrPlace);
            sf.append(this.unionTag);
            for (IndiRecord child : this.children) {
                sf.append(child);
            }
            sf.append(this.childrenTag);
            for (EventRecord event : this.events) {
                sf.append(event);
            }
            return sf.toString();
        }
    }

    private class IndiRecord {
        private Indi indi = null;
        private String val = "";
        private String valdates = "";
        private String id = "";
        private String link = "";
        private String birthDate = "";
        private String birthPlace = "";
        private String deathDate = "";
        private String deathPlace = "";

        public IndiRecord(Indi indi) {
            if (indi == null) {
                return;
            }
            this.indi = indi;
            this.val = PropUtils.getIndiValue(indi, false);
            this.id = PropUtils.getIdValue((Entity)indi);
            this.link = indi.getLinkAnchor();
            this.birthDate = ReportFamilies.this.dataFormatOptions.date.getDate((Property)indi.getBirthDate());
            this.birthPlace = ReportFamilies.this.dataFormatOptions.place.getPlace((Property)indi.getBirthPlace());
            this.deathDate = ReportFamilies.this.dataFormatOptions.date.getDate((Property)indi.getDeathDate());
            this.deathPlace = ReportFamilies.this.dataFormatOptions.place.getPlace((Property)indi.getDeathPlace());
            this.valdates = this.val + " (" + ReportFamilies.this.OPTIONS.getBirthSymbol() + this.birthDate + " - " + ReportFamilies.this.OPTIONS.getDeathSymbol() + this.deathDate + ")";
        }

        public String toString() {
            StringFiller sf = new StringFiller(" ");
            sf.append(this.val);
            sf.append(this.id);
            sf.append(this.birthDate);
            sf.append(this.birthPlace);
            sf.append(this.deathDate);
            sf.append(this.deathPlace);
            return sf.toString();
        }
    }

    private class SpouseRecord {
        private String id = "";
        private String link = "";
        private String marrDate = "";
        private String marrPlace = "";
        private IndiRecord spouse = null;

        public SpouseRecord(Fam fams, Indi spouse) {
            this.spouse = new IndiRecord(spouse);
            if (fams == null) {
                return;
            }
            this.id = PropUtils.getIdValue((Entity)fams);
            this.link = fams.getLinkAnchor();
            this.marrDate = ReportFamilies.this.dataFormatOptions.date.getDate((Property)fams.getMarriageDate());
            this.marrPlace = ReportFamilies.this.dataFormatOptions.place.getPlace((Property)fams.getMarriagePlace());
        }

        public String toString() {
            StringFiller sf = new StringFiller(" ");
            sf.append(this.id);
            sf.append(this.spouse.toString());
            sf.append(this.marrDate);
            sf.append(this.marrPlace);
            return sf.toString();
        }
    }

    private class EventRecord {
        private String tag = "";
        private String date = "";
        private String place = "";

        public EventRecord(Property event) {
            this.tag = Gedcom.getReportName((String)event.getTag());
            this.date = ReportFamilies.this.dataFormatOptions.date.getDate(event.getProperty("DATE"));
            this.place = ReportFamilies.this.dataFormatOptions.place.getPlace(event.getProperty("PLAC"));
        }

        public String toString() {
            StringFiller sf = new StringFiller(" ");
            sf.append(this.tag);
            sf.append(this.date);
            sf.append(this.place);
            return sf.toString();
        }
    }
}

