/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.imageBrowser;

import ancestris.modules.releve.editor.MainPanelTranscriber;
import ancestris.modules.releve.editor.TextPanel;
import ancestris.modules.releve.imageAligner.MainPanelCropper;
import ancestris.modules.releve.imageBrowser.BrowserOptionsPanel;
import ancestris.modules.releve.imageBrowser.ImageFinder;
import ancestris.modules.releve.imageBrowser.ImagePanel;
import ancestris.modules.releve.imageBrowser.LLMResponseHandler;
import ancestris.modules.releve.imageBrowser.LLMService;
import ancestris.modules.releve.model.AbstractRecord;
import ancestris.util.Utilities;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.io.InputSource;
import genj.renderer.MediaUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.json.JSONException;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class BrowserPanel
extends JPanel {
    private static final Logger LOG = Logger.getLogger("ancestris.app.releve", null);
    private static final String INPUT_BROWSER_DIRECTORY_KEY = "ImageDirectory";
    private static final String SPLIT_PANE_KEY = "BrowserSplitPane";
    private File currentImageDirectory = null;
    MainPanelTranscriber transcriber = null;
    ImageFinder imageFinder = new ImageFinder();
    private JButton btnFolder;
    private ImagePanel imagePanel;
    private JButton jButtonAdjust;
    private JButton jButtonBottom;
    private JButton jButtonExtract;
    private JButton jButtonLeft;
    private JButton jButtonRight;
    private JButton jButtonTop;
    private JPanel jPanel4;
    private JPanel jPanelButton;
    private JPanel jPanelFiles;
    private JPanel jPanelImage;
    private JPanel jPanelImageInfo;
    private JScrollPane jScrollPaneFiles;
    private JScrollPane jScrollPaneImage;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPaneBrowser;
    private JLabel lbFileName;
    private JList<String> listFiles;

    public BrowserPanel() {
        this.initComponents();
        this.jPanelButton.setVisible(false);
        this.jPanelImageInfo.setVisible(false);
        int size = Integer.parseInt(NbPreferences.forModule(BrowserPanel.class).get(SPLIT_PANE_KEY, "10"));
        if (size > 10) {
            this.jSplitPaneBrowser.setDividerLocation(size);
        }
        ListSelectionListener lsl = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (BrowserPanel.this.listFiles.getSelectedValue() != null) {
                    String fileName = BrowserPanel.this.listFiles.getSelectedValue();
                    BrowserPanel.this.showImage(fileName, false);
                }
            }
        };
        this.listFiles.addListSelectionListener(lsl);
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(37, 512), "previousImage");
        this.jPanelImage.getActionMap().put("previousImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.jButtonLeftActionPerformed(null);
            }
        });
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(39, 512), "nextImage");
        this.jPanelImage.getActionMap().put("nextImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.jButtonRightActionPerformed(null);
            }
        });
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(40, 512), "downLeftCornerImage");
        this.jPanelImage.getActionMap().put("downLeftCornerImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.jButtonBottomActionPerformed(null);
            }
        });
        this.jPanelImage.getInputMap(2).put(KeyStroke.getKeyStroke(38, 512), "upLeftCornerImage");
        this.jPanelImage.getActionMap().put("upLeftCornerImage", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.jButtonTopActionPerformed(null);
            }
        });
        this.settingsUpdated();
        String imageDirectory = NbPreferences.forModule(BrowserPanel.class).get(INPUT_BROWSER_DIRECTORY_KEY, "");
        if (!imageDirectory.isBlank()) {
            File f = new File(imageDirectory);
            this.setCurrentImageDirectory(f);
        }
    }

    public void setParent(MainPanelTranscriber parent) {
        this.transcriber = parent;
    }

    public JComponent[] getMenuComponents() {
        return new JComponent[]{this.btnFolder, this.jButtonLeft, this.jButtonRight, this.jSeparator1, this.jButtonBottom, this.jButtonTop, this.jButtonAdjust, this.jButtonExtract};
    }

    public void componentClosed() {
    }

    public void refreshImageList() {
        if (this.currentImageDirectory != null) {
            this.populateImageList(this.currentImageDirectory);
        }
    }

    private void populateImageList(File folder) {
        if (!folder.exists()) {
            return;
        }
        File[] files = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                name = name.toLowerCase();
                return name.matches(MainPanelCropper.IMAGE_EXTENSION_PATTERN);
            }
        });
        if (files != null) {
            String[] fileNames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                fileNames[i] = files[i].getName();
            }
            Arrays.sort(fileNames, String.CASE_INSENSITIVE_ORDER);
            this.listFiles.setListData((String[])fileNames);
        } else {
            System.err.println("BrowserPanel.populateImageList folder.listFiles=null for  folder=" + folder.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImage(String fileName, boolean forceRefesh) {
        if (this.lbFileName.getText().equals(fileName) && !forceRefesh) {
            return;
        }
        Utilities.setCursorWaiting((JPanel)this);
        this.imagePanel.showImage(null);
        this.lbFileName.setText("");
        try {
            String fullFileName = this.currentImageDirectory.getCanonicalPath() + File.separator + fileName;
            Optional is = InputSource.get((File)new File(fullFileName));
            BufferedImage image = MediaUtils.getImageFromFile((InputSource)((InputSource)is.get()), this.getClass(), (BufferedImage)MediaUtils.IMG_NO_SOURCE_MEDIA);
            this.imagePanel.showImage(image);
            this.lbFileName.setText(fileName);
        }
        catch (IOException iOException) {
        }
        finally {
            Utilities.setCursorNormal((JPanel)this);
        }
    }

    public void showImage(final String filepath, final String title, String city, String notary, String cote, String page) {
        this.imagePanel.showImage(null);
        this.lbFileName.setText("");
        this.listFiles.clearSelection();
        final Cursor browserPanelCursor = this.getCursor();
        final Cursor imagePanelCursor = this.imagePanel.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.imagePanel.setCursor(Cursor.getPredefinedCursor(3));
        File[] directories = BrowserOptionsPanel.ImageDirectoryModel.getModel().getImageBrowserDirectories();
        ImageFinder.ImageFinderListener listener = new ImageFinder.ImageFinderListener(){

            @Override
            public void onFindResult(File imageFile) {
                if (imageFile != null) {
                    try {
                        BufferedImage image = ImageIO.read(imageFile);
                        if (image != null) {
                            BrowserPanel.this.imagePanel.showImage(image);
                            BrowserPanel.this.setCurrentImageDirectory(imageFile.getParentFile());
                            BrowserPanel.this.lbFileName.setText(imageFile.getName());
                            BrowserPanel.this.listFiles.setSelectedValue(imageFile.getName(), true);
                        }
                    }
                    catch (IOException image) {}
                } else if (title != null) {
                    String info = filepath.isBlank() ? title : filepath;
                    String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.showimage.msg.unfound", (Object)info);
                    DialogManager.createError((String)title, (String)msg).show();
                }
                BrowserPanel.this.setCursor(browserPanelCursor);
                BrowserPanel.this.imagePanel.setCursor(imagePanelCursor);
            }
        };
        this.imageFinder.findImage(directories, filepath, city, notary, cote, page, listener);
        this.setCursor(browserPanelCursor);
        this.imagePanel.setCursor(imagePanelCursor);
    }

    public void selectImage(String filepath, String city, String notary, String cote, String page) {
        if (this.listFiles == null || filepath.isBlank() && cote.isBlank() && page.isBlank()) {
            return;
        }
        File[] directories = BrowserOptionsPanel.ImageDirectoryModel.getModel().getImageBrowserDirectories();
        ImageFinder.ImageFinderListener listener = new ImageFinder.ImageFinderListener(){

            @Override
            public void onFindResult(File imageFile) {
                if (imageFile != null) {
                    try {
                        BufferedImage image = ImageIO.read(imageFile);
                        if (image != null) {
                            BrowserPanel.this.imagePanel.showImage(image);
                            BrowserPanel.this.setCurrentImageDirectory(imageFile.getParentFile());
                            BrowserPanel.this.listFiles.setSelectedValue(imageFile.getName(), true);
                            BrowserPanel.this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
                            BrowserPanel.this.imagePanel.moveToLeft();
                            BrowserPanel.this.imagePanel.moveToTop();
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    BrowserPanel.this.imagePanel.showImage(null);
                    BrowserPanel.this.listFiles.clearSelection();
                }
            }
        };
        this.imageFinder.findImage(directories, filepath, city, notary, cote, page, listener);
    }

    public void setCurrentImageDirectory(File directory) {
        if (!directory.exists()) {
            return;
        }
        if (this.currentImageDirectory == null || this.currentImageDirectory != null && this.currentImageDirectory.getAbsolutePath() != directory.getAbsolutePath()) {
            this.currentImageDirectory = directory;
            this.btnFolder.setText(directory.getParentFile().getName() + File.separator + directory.getName());
            this.populateImageList(directory);
            try {
                NbPreferences.forModule(BrowserPanel.class).put(INPUT_BROWSER_DIRECTORY_KEY, this.currentImageDirectory.getCanonicalPath());
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public void settingsUpdated() {
        String mode = BrowserOptionsPanel.getTwoStepProcess() ? "2" : "";
        this.jButtonExtract.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)("BrowserPanel.jButtonExtract.toolTipText" + mode)));
        this.jButtonExtract.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/ExtractInfo" + mode + ".png")));
    }

    private void initComponents() {
        this.jPanelButton = new JPanel();
        this.btnFolder = new JButton();
        this.jButtonLeft = new JButton();
        this.jButtonRight = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jButtonBottom = new JButton();
        this.jButtonTop = new JButton();
        this.jButtonAdjust = new JButton();
        this.jButtonExtract = new JButton();
        this.jPanelImage = new JPanel();
        this.jSplitPaneBrowser = new JSplitPane();
        this.jPanelFiles = new JPanel();
        this.jScrollPaneFiles = new JScrollPane();
        this.listFiles = new JList();
        this.jPanel4 = new JPanel();
        this.jPanelImageInfo = new JPanel();
        this.lbFileName = new JLabel();
        this.jScrollPaneImage = new JScrollPane();
        this.imagePanel = new ImagePanel();
        this.setLayout(new BorderLayout());
        this.jPanelButton.setPreferredSize(new Dimension(0, 40));
        this.jPanelButton.setLayout(new FlowLayout(0));
        Mnemonics.setLocalizedText((AbstractButton)this.btnFolder, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.btnFolder.text"));
        this.btnFolder.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.btnFolder.toolTipText"));
        this.btnFolder.setMargin(new Insets(2, 4, 2, 4));
        this.btnFolder.setPreferredSize(new Dimension(123, 32));
        this.btnFolder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.btnFolderActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.btnFolder);
        this.jButtonLeft.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Back.png")));
        this.jButtonLeft.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonLeft.toolTipText"));
        this.jButtonLeft.setMargin(null);
        this.jButtonLeft.setPreferredSize(new Dimension(36, 32));
        this.jButtonLeft.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonLeftActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonLeft);
        this.jButtonRight.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Forward.png")));
        this.jButtonRight.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonRight.toolTipText"));
        this.jButtonRight.setMargin(null);
        this.jButtonRight.setPreferredSize(new Dimension(36, 32));
        this.jButtonRight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonRightActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonRight);
        this.jPanelButton.add(this.jSeparator1);
        this.jButtonBottom.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Down.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonBottom, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonBottom.text"));
        this.jButtonBottom.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonDown.toolTiptext"));
        this.jButtonBottom.setMargin(null);
        this.jButtonBottom.setPreferredSize(new Dimension(36, 32));
        this.jButtonBottom.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonBottomActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonBottom);
        this.jButtonTop.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Up.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonTop, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonTop.text"));
        this.jButtonTop.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonTop.toolTiptext"));
        this.jButtonTop.setMargin(null);
        this.jButtonTop.setPreferredSize(new Dimension(36, 32));
        this.jButtonTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonTopActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonTop);
        this.jButtonAdjust.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/Optimize.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonAdjust, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonAdjust.text"));
        this.jButtonAdjust.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonAdjust.toolTiptext"));
        this.jButtonAdjust.setMargin(null);
        this.jButtonAdjust.setPreferredSize(new Dimension(36, 32));
        this.jButtonAdjust.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonAdjustActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonAdjust);
        this.jButtonExtract.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/releve/images/ExtractInfo.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.jButtonExtract, (String)NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonExtract.text"));
        this.jButtonExtract.setToolTipText(NbBundle.getMessage(BrowserPanel.class, (String)"BrowserPanel.jButtonExtract.toolTipText"));
        this.jButtonExtract.setMargin(null);
        this.jButtonExtract.setPreferredSize(new Dimension(36, 32));
        this.jButtonExtract.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BrowserPanel.this.jButtonExtractActionPerformed(evt);
            }
        });
        this.jPanelButton.add(this.jButtonExtract);
        this.add((Component)this.jPanelButton, "North");
        this.jPanelImage.setLayout(new BorderLayout());
        this.jSplitPaneBrowser.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                BrowserPanel.this.jSplitPaneBrowserPropertyChange(evt);
            }
        });
        this.jPanelFiles.setMinimumSize(new Dimension(150, 23));
        this.jPanelFiles.setPreferredSize(new Dimension(150, 497));
        this.jPanelFiles.setLayout(new BorderLayout());
        this.listFiles.setSelectionMode(0);
        this.listFiles.setMaximumSize(new Dimension(500, 16));
        this.listFiles.setMinimumSize(new Dimension(150, 16));
        this.listFiles.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                BrowserPanel.this.listFilesKeyPressed(evt);
            }
        });
        this.jScrollPaneFiles.setViewportView(this.listFiles);
        this.jPanelFiles.add((Component)this.jScrollPaneFiles, "Center");
        this.jSplitPaneBrowser.setLeftComponent(this.jPanelFiles);
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanelImageInfo.setPreferredSize(new Dimension(585, 20));
        GroupLayout jPanelImageInfoLayout = new GroupLayout(this.jPanelImageInfo);
        this.jPanelImageInfo.setLayout(jPanelImageInfoLayout);
        jPanelImageInfoLayout.setHorizontalGroup(jPanelImageInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelImageInfoLayout.createSequentialGroup().addComponent(this.lbFileName, -1, 847, Short.MAX_VALUE).addContainerGap()));
        jPanelImageInfoLayout.setVerticalGroup(jPanelImageInfoLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lbFileName, -1, 20, Short.MAX_VALUE));
        this.jPanel4.add((Component)this.jPanelImageInfo, "North");
        this.imagePanel.setMinimumSize(new Dimension(100, 100));
        GroupLayout imagePanelLayout = new GroupLayout(this.imagePanel);
        this.imagePanel.setLayout(imagePanelLayout);
        imagePanelLayout.setHorizontalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 841, Short.MAX_VALUE));
        imagePanelLayout.setVerticalGroup(imagePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 475, Short.MAX_VALUE));
        this.jScrollPaneImage.setViewportView(this.imagePanel);
        this.jPanel4.add((Component)this.jScrollPaneImage, "Center");
        this.jSplitPaneBrowser.setRightComponent(this.jPanel4);
        this.jPanelImage.add((Component)this.jSplitPaneBrowser, "Center");
        this.add((Component)this.jPanelImage, "Center");
    }

    private void btnFolderActionPerformed(ActionEvent evt) {
        File file = new FileChooserBuilder(BrowserPanel.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.btnFolder.text")).setApproveText(NbBundle.getMessage(this.getClass(), (String)"BrowserOptionsPanel.dialogTitle.ok")).setSelectedFile(this.currentImageDirectory).setFileHiding(true).showOpenDialog();
        if (file != null) {
            this.setCurrentImageDirectory(file);
        } else {
            this.populateImageList(this.currentImageDirectory);
        }
    }

    private void jButtonLeftActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isleftSideVisible()) {
            int currentIndex = this.listFiles.getSelectedIndex();
            if (currentIndex > 0) {
                this.listFiles.setSelectedIndex(currentIndex - 1);
            } else {
                this.listFiles.setSelectedIndex(this.listFiles.getModel().getSize() - 1);
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.listFiles == null || this.listFiles.getSelectedValue() == null) {
                return;
            }
            String fileName = this.listFiles.getSelectedValue().toString();
            this.showImage(fileName, false);
            this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
            this.imagePanel.moveToRight();
            this.imagePanel.moveToBottom();
        } else {
            this.imagePanel.moveToLeft();
        }
    }

    private void jButtonRightActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isRightSideVisible()) {
            int currentIndex = this.listFiles.getSelectedIndex();
            if (currentIndex < this.listFiles.getModel().getSize() - 1) {
                this.listFiles.setSelectedIndex(currentIndex + 1);
            } else {
                this.listFiles.setSelectedIndex(0);
                Toolkit.getDefaultToolkit().beep();
            }
            if (this.listFiles == null || this.listFiles.getSelectedValue() == null) {
                return;
            }
            String fileName = this.listFiles.getSelectedValue().toString();
            this.showImage(fileName, false);
            this.jScrollPaneImage.getVerticalScrollBar().setValue(0);
            this.imagePanel.moveToLeft();
            this.imagePanel.moveToTop();
        } else {
            this.imagePanel.moveToRight();
        }
    }

    private void jButtonBottomActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isBottomSideVisible()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.imagePanel.moveToBottom();
        }
    }

    private void jButtonTopActionPerformed(ActionEvent evt) {
        if (this.imagePanel.isTopSideVisible()) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.imagePanel.moveToTop();
        }
    }

    private void jButtonAdjustActionPerformed(ActionEvent evt) {
        this.imagePanel.adjustAreaColor();
    }

    private void listFilesKeyPressed(KeyEvent evt) {
    }

    private void jSplitPaneBrowserPropertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("dividerLocation")) {
            NbPreferences.forModule(BrowserPanel.class).put(SPLIT_PANE_KEY, String.valueOf(this.jSplitPaneBrowser.getDividerLocation()));
        }
    }

    private void jButtonExtractActionPerformed(ActionEvent evt) {
        String fullFileName = this.getSelectedFileAbsolutePath();
        if (fullFileName == null) {
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.selectFile");
            DialogManager.createError((String)title, (String)msg).show();
            return;
        }
        this.extractInfo(fullFileName);
    }

    public String getSelectedFileAbsolutePath() {
        String fileName = this.listFiles.getSelectedValue();
        if (fileName == null) {
            return null;
        }
        try {
            return this.currentImageDirectory.getCanonicalPath() + File.separator + this.listFiles.getSelectedValue();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public void selectAndExtract(String filename) {
        this.listFiles.setSelectedValue(filename, true);
        String fullFileName = this.getSelectedFileAbsolutePath();
        this.extractInfo(fullFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractInfo(final String fullFileName) {
        Utilities.setCursorWaiting((JPanel)this);
        try {
            LLMService llmService = new LLMService();
            boolean isPdf = FileChooserBuilder.getExtension((String)fullFileName).equalsIgnoreCase("pdf");
            String base64Image = llmService.encodeImage(fullFileName);
            LLMResponseHandler handler = new LLMResponseHandler(){

                @Override
                public boolean processText(String text) {
                    return BrowserPanel.this.createMapFromText(text, fullFileName);
                }

                @Override
                public boolean processMap(Map<AbstractRecord.FieldType, String> map) {
                    return BrowserPanel.this.creatreRecordFromMap(map, fullFileName);
                }
            };
            boolean twoStepProcess = BrowserOptionsPanel.getTwoStepProcess();
            if (twoStepProcess) {
                llmService.call_LLM_OCR(base64Image, null, isPdf, handler);
            } else {
                llmService.call_LLM(base64Image, null, isPdf, handler);
            }
        }
        catch (IOException | InterruptedException | JSONException ex) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction"));
            Exceptions.printStackTrace((Throwable)ex);
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction");
            DialogManager.createError((String)title, (String)msg).show();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Utilities.setCursorNormal((JPanel)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createMapFromText(String text, final String fullFileName) {
        TextPanel textPanel = new TextPanel(text);
        String fixText = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title.fixText");
        Object o = DialogManager.create((String)fixText, (JComponent)textPanel).setDialogId("fixText").setMessageType(3).setOptionType(2).show();
        if (o == DialogManager.CANCEL_OPTION) {
            return false;
        }
        final String newText = textPanel.getText();
        Utilities.setCursorWaiting((JPanel)this);
        try {
            LLMService llmService = new LLMService();
            LLMResponseHandler handler = new LLMResponseHandler(){

                @Override
                public boolean processMap(Map<AbstractRecord.FieldType, String> map) {
                    return BrowserPanel.this.creatreRecordFromMap(map, fullFileName);
                }

                @Override
                public boolean processError(Object o) {
                    return BrowserPanel.this.createMapFromText(newText, fullFileName);
                }
            };
            llmService.call_LLM_QnA(newText, null, handler);
        }
        catch (IOException | InterruptedException | JSONException ex) {
            LOG.log(Level.SEVERE, NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction"));
            Exceptions.printStackTrace((Throwable)ex);
            String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
            String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.malfunction");
            DialogManager.createError((String)title, (String)msg).show();
        }
        catch (ExecutionException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            Utilities.setCursorNormal((JPanel)this);
        }
        return true;
    }

    private boolean creatreRecordFromMap(Map<AbstractRecord.FieldType, String> map, String fullFileName) {
        String tag = map.get((Object)AbstractRecord.FieldType.eventTag);
        if (tag == null) {
            tag = "";
        }
        int type = switch (tag) {
            case "BIRT" -> 0;
            case "MARR" -> 1;
            case "DEAT" -> 2;
            default -> 3;
        };
        map.put(AbstractRecord.FieldType.eventMedia, fullFileName);
        this.transcriber.createRecord(type, map);
        this.jSplitPaneBrowser.setDividerLocation(100);
        String title = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.title");
        String msg = NbBundle.getMessage(this.getClass(), (String)"BrowserPanel.extractService.msg.success");
        DialogManager.create((String)title, (String)msg).setOptionType(10).show();
        return true;
    }
}

