/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JWindow;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;

class CustomPopupFactory
extends PopupFactory {
    CustomPopupFactory() {
    }

    @Override
    public Popup getPopup(Component owner, Component contents, int x, int y) throws IllegalArgumentException {
        assert (owner instanceof JComponent);
        Dimension d = contents.getPreferredSize();
        Container c = ((JComponent)owner).getTopLevelAncestor();
        if (c == null) {
            throw new IllegalArgumentException("Not onscreen: " + owner);
        }
        Point p = new Point(x, y);
        SwingUtilities.convertPointFromScreen(p, c);
        Rectangle r = new Rectangle(p.x, p.y, d.width, d.height);
        if (c.getBounds().contains(r)) {
            return new LWPopup(owner, contents, x, y);
        }
        return new HWPopup(owner, contents, x, y);
    }

    private static void disableShadow(JWindow win) {
        CustomPopupFactory.safeSetBackground(win, new Color(255, 255, 255, 0));
        win.getRootPane().putClientProperty("Window.shadow", Boolean.FALSE.toString());
    }

    private static void safeSetBackground(JWindow window, Color background) {
        GraphicsConfiguration gc = window.getGraphicsConfiguration();
        if (!gc.isTranslucencyCapable()) {
            return;
        }
        if (gc.getDevice().getFullScreenWindow() == window) {
            return;
        }
        window.setBackground(background);
    }

    private static class LWPopup
    extends OurPopup {
        private Rectangle bounds = null;

        public LWPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
        }

        @Override
        protected void prepareResources() {
            JComponent jc = (JComponent)this.owner;
            Container w = jc.getTopLevelAncestor();
            JComponent pane = null;
            if (w instanceof JFrame) {
                pane = (JComponent)((JFrame)w).getGlassPane();
            } else if (w instanceof JDialog) {
                pane = (JComponent)((JDialog)w).getGlassPane();
            } else if (w instanceof JWindow) {
                pane = (JComponent)((JWindow)w).getGlassPane();
            }
            if (w == null) {
                throw new IllegalArgumentException("Not a JFrame/JWindow/JDialog: " + this.owner);
            }
            Point p = new Point(this.x, this.y);
            SwingUtilities.convertPointFromScreen(p, pane);
            if (pane.getLayout() != null) {
                pane.setLayout(null);
            }
            pane.setVisible(true);
            this.contents.setVisible(false);
            Dimension d = this.contents.getPreferredSize();
            pane.add(this.contents);
            this.bounds = new Rectangle(p.x, p.y, d.width, d.height);
            this.contents.setBounds(p.x, p.y, d.width, d.height);
        }

        @Override
        protected void doShow() {
            this.contents.setVisible(true);
        }

        @Override
        public boolean isShowing() {
            return this.contents != null && this.contents.isShowing();
        }

        @Override
        protected void doHide() {
            Container parent = this.contents.getParent();
            if (parent != null) {
                this.contents.getParent().remove(this.contents);
                parent.repaint(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
                parent.setVisible(false);
            }
            this.contents.setVisible(true);
        }
    }

    private static class HWPopup
    extends OurPopup {
        private JWindow window = null;

        public HWPopup(Component owner, Component contents, int x, int y) {
            super(owner, contents, x, y);
        }

        @Override
        public boolean isShowing() {
            return this.window != null && this.window.isShowing();
        }

        @Override
        void dispose() {
            this.window.setVisible(false);
            this.window.dispose();
            this.window = null;
            super.dispose();
        }

        @Override
        protected void prepareResources() {
            this.window = new JWindow(SwingUtilities.getWindowAncestor(this.owner));
            this.window.setType(Window.Type.POPUP);
            this.window.getContentPane().add(this.contents);
            this.window.setLocation(new Point(this.x, this.y));
            this.window.pack();
            CustomPopupFactory.disableShadow(this.window);
        }

        @Override
        protected void doShow() {
            this.window.setVisible(true);
        }

        @Override
        protected void doHide() {
            if (this.window != null) {
                this.window.setVisible(false);
                this.window.getContentPane().remove(this.contents);
                this.dispose();
            }
        }
    }

    private static abstract class OurPopup
    extends Popup {
        protected Component owner = null;
        protected Component contents = null;
        protected int x = -1;
        protected int y = -1;
        private boolean canReuse = false;

        public OurPopup(Component owner, Component contents, int x, int y) {
            this.configure(owner, contents, x, y);
        }

        final void configure(Component owner, Component contents, int x, int y) {
            this.owner = owner;
            this.contents = contents;
            this.x = x;
            this.y = y;
        }

        protected abstract void prepareResources();

        protected abstract void doShow();

        public abstract boolean isShowing();

        protected abstract void doHide();

        @Override
        public final void show() {
            this.prepareResources();
            this.doShow();
        }

        @Override
        public final void hide() {
            this.doHide();
        }

        void dispose() {
            this.owner = null;
            this.contents = null;
            this.x = -1;
            this.y = -1;
        }

        public final void clear() {
            this.canReuse = true;
            this.dispose();
        }

        boolean isInUse() {
            return this.canReuse;
        }
    }
}

