/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.releve.model;

import ancestris.modules.releve.model.AbstractRecord;
import ancestris.modules.releve.model.BeanField;
import ancestris.modules.releve.model.BeanGroup;
import ancestris.modules.releve.model.DataManager;
import ancestris.modules.releve.model.Field;
import ancestris.modules.releve.model.FieldDate;
import genj.gedcom.GedcomException;
import genj.gedcom.PropertyDate;
import genj.gedcom.time.Calendar;
import genj.gedcom.time.PointInTime;
import org.openide.util.NbBundle;

public class Synthesis {
    AbstractRecord m_record;

    public Synthesis(AbstractRecord record) {
        this.m_record = record;
    }

    public String getSynthesisTitle() {
        if (this.m_record == null) {
            return "";
        }
        switch (this.m_record.getType()) {
            case BIRTH: {
                String message = this.m_record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiLastName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.eventDate);
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.birth", (Object)message);
            }
            case DEATH: {
                String message = this.m_record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiLastName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.eventDate);
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.death", (Object)message);
            }
            case MARRIAGE: {
                String husband = this.m_record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiLastName);
                String wife = this.m_record.getFieldString(AbstractRecord.FieldType.wifeFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeLastName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.eventDate);
                return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.marriage", (Object)husband, (Object)wife);
            }
        }
        String husband = this.m_record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiLastName);
        String wife = this.m_record.getFieldString(AbstractRecord.FieldType.wifeFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeLastName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.eventDate);
        return NbBundle.getMessage(Synthesis.class, (String)"synthesis.title.misc", (Object)this.m_record.getFieldString(AbstractRecord.FieldType.eventTag), (Object)husband, (Object)wife);
    }

    public String getSynthesis(boolean showFrenchCalendarDate) {
        String synthesis = "";
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.general.ordinal()].getTitle(), Synthesis.appendValue(Synthesis.appendPrefixValue(this.getEventDateDDMMYYYY(((FieldDate)this.m_record.getField(AbstractRecord.FieldType.eventDate)).getPropertyDate(), showFrenchCalendarDate), new String[0]), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.eventTag) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.eventTag)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.eventDate) + ": ", this.getEventDateDDMMYYYY(((FieldDate)this.m_record.getField(AbstractRecord.FieldType.eventDate)).getPropertyDate(), showFrenchCalendarDate)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.parish) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.parish)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.notary) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.notary)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.cote) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.cote)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.freeComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.freeComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.indi.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.indiFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiLastName), this.m_record.getFieldString(AbstractRecord.FieldType.indiAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.indiAge), Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.born"), this.m_record.getField(AbstractRecord.FieldType.indiBirthDate), this.m_record.getFieldString(AbstractRecord.FieldType.indiBirthAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiBirthPlace), showFrenchCalendarDate), this.m_record.getFieldString(AbstractRecord.FieldType.indiOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiResidence)), Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.died"), this.m_record.getField(AbstractRecord.FieldType.indiDeathDate), this.m_record.getFieldString(AbstractRecord.FieldType.indiDeathAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiDeathPlace), showFrenchCalendarDate), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.indiMarried.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedLastName), this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedDead), this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMarriedResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMarriedComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiMarriedComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.indiFather.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherLastName), this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherAge), this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiFatherResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiFatherComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiFatherComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.indiMother.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherLastName), this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherAge), this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherDead), this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMotherResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherAddress), this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.indiMotherComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.indiMotherComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.wife.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.wifeFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeLastName), this.m_record.getFieldString(AbstractRecord.FieldType.wifeAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.wifeAge), Synthesis.makeEventComment(NbBundle.getMessage(Synthesis.class, (String)"synthesis.born"), this.m_record.getField(AbstractRecord.FieldType.wifeBirthDate), this.m_record.getFieldString(AbstractRecord.FieldType.wifeBirthAddress), this.m_record.getFieldString(AbstractRecord.FieldType.wifeBirthPlace), showFrenchCalendarDate), this.m_record.getFieldString(AbstractRecord.FieldType.wifeOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeAddress), this.m_record.getFieldString(AbstractRecord.FieldType.wifeResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.wifeMarried.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedLastName), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedDead), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMarriedResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedAddress), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMarriedComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeMarriedComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.wifeFather.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherLastName), this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherAge), this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeFatherResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherAddress), this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeFatherComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeFatherComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.wifeMother.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherFirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherLastName), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherAge).isEmpty() ? "" : this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherAge), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherDead), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherOccupation), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMotherResidence) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherAddress), this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherResidence)), Synthesis.appendPrefixValue(BeanField.getLabel(AbstractRecord.FieldType.wifeMotherComment) + ": ", this.m_record.getFieldString(AbstractRecord.FieldType.wifeMotherComment))));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.witness1.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.witness1FirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.witness1LastName), this.m_record.getFieldString(AbstractRecord.FieldType.witness1Occupation), this.m_record.getFieldString(AbstractRecord.FieldType.witness1Comment)));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.witness2.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.witness2FirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.witness2LastName), this.m_record.getFieldString(AbstractRecord.FieldType.witness2Occupation), this.m_record.getFieldString(AbstractRecord.FieldType.witness2Comment)));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.witness3.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.witness3FirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.witness3LastName), this.m_record.getFieldString(AbstractRecord.FieldType.witness3Occupation), this.m_record.getFieldString(AbstractRecord.FieldType.witness3Comment)));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.witness4.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.witness4FirstName) + " " + this.m_record.getFieldString(AbstractRecord.FieldType.witness4LastName), this.m_record.getFieldString(AbstractRecord.FieldType.witness4Occupation), this.m_record.getFieldString(AbstractRecord.FieldType.witness4Comment)));
        synthesis = this.appendComment(synthesis, BeanGroup.getGroups(this.m_record.getType())[BeanGroup.GroupId.generalComment.ordinal()].getTitle(), Synthesis.appendValue(this.m_record.getFieldString(AbstractRecord.FieldType.generalComment)));
        if (DataManager.getCopySourceTextToComment()) {
            synthesis = this.appendComment(synthesis, BeanField.getLabel(AbstractRecord.FieldType.deedText), this.m_record.getFieldString(AbstractRecord.FieldType.deedText));
        }
        return synthesis;
    }

    public static String makeEventComment(String message, Field fieldDate, String fieldAddress, String fieldPlace, boolean showFrenchCalendarDate) {
        PropertyDate birthDate;
        Object comment = "";
        if (fieldDate != null && (birthDate = ((FieldDate)fieldDate).getPropertyDate()) != null && birthDate.isValid()) {
            comment = message;
            comment = (String)comment + " " + NbBundle.getMessage(Synthesis.class, (String)"synthesis.on.date", (Object)Synthesis.formatDateDDMMYYYY(birthDate));
            if (showFrenchCalendarDate) {
                try {
                    String frenchCalendarDate = birthDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                    if (!frenchCalendarDate.isEmpty()) {
                        comment = (String)comment + " (" + frenchCalendarDate + ")";
                    }
                }
                catch (GedcomException gedcomException) {
                    // empty catch block
                }
            }
        }
        if (!fieldAddress.isEmpty() || !fieldPlace.isEmpty()) {
            comment = (String)comment + Synthesis.appendPrefixValue(((String)comment).isEmpty() ? message : "", NbBundle.getMessage(Synthesis.class, (String)"synthesis.in.place", (Object)Synthesis.appendValue(fieldAddress, fieldPlace)));
        }
        return comment;
    }

    String getEventDateDDMMYYYY(PropertyDate eventDate, boolean showFrenchCalendarDate) {
        Object result = Synthesis.formatDateDDMMYYYY(eventDate);
        if (showFrenchCalendarDate) {
            try {
                String frenchCalendarDate = eventDate.getStart().getPointInTime((Calendar)PointInTime.FRENCHR).toString();
                if (!frenchCalendarDate.isEmpty()) {
                    result = (String)result + " (" + frenchCalendarDate + ")";
                }
            }
            catch (GedcomException gedcomException) {
                // empty catch block
            }
        }
        return result;
    }

    static String formatDateDDMMYYYY(PropertyDate dateProperty) {
        try {
            PointInTime pit = dateProperty.getStart().getPointInTime((Calendar)PointInTime.GREGORIAN);
            String result = pit.getYear() == Integer.MAX_VALUE || pit.getYear() == Integer.MIN_VALUE ? "" : (pit.getMonth() == Integer.MAX_VALUE || pit.getMonth() == Integer.MIN_VALUE ? String.format("%04d", pit.getYear()) : (pit.getDay() == Integer.MAX_VALUE || pit.getDay() == Integer.MIN_VALUE ? String.format("%02d/%04d", pit.getMonth() + 1, pit.getYear()) : String.format("%02d/%02d/%04d", pit.getDay() + 1, pit.getMonth() + 1, pit.getYear())));
            return result;
        }
        catch (GedcomException ex) {
            return "";
        }
    }

    private String appendComment(String comment, String label, String newComment) {
        if (!newComment.isEmpty()) {
            if (!((String)comment).isEmpty() && ((String)comment).charAt(((String)comment).length() - 1) != '\n') {
                comment = (String)comment + "\n";
            }
            comment = (String)comment + label + ": " + newComment;
        }
        return comment;
    }

    protected static String appendValue(String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
        }
        return sb.toString();
    }

    public static String appendPrefixValue(String prefix, String ... otherValues) {
        StringBuilder sb = new StringBuilder();
        for (String otherValue : otherValues) {
            if (otherValue == null || otherValue.trim().isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(otherValue.trim());
        }
        if (sb.length() > 0) {
            sb.insert(0, prefix + " ");
        }
        return sb.toString();
    }
}

