/*
 * Decompiled with CFR 0.152.
 */
package genj.edit.actions;

import ancestris.core.actions.AbstractAncestrisAction;
import ancestris.core.resources.Images;
import ancestris.util.swing.DialogManager;
import genj.common.SelectEntityWidget;
import genj.edit.actions.GedcomDialog;
import genj.gedcom.AbstractNote;
import genj.gedcom.Entity;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomOptions;
import genj.gedcom.Grammar;
import genj.gedcom.Note;
import genj.gedcom.Property;
import genj.gedcom.PropertyNote;
import genj.gedcom.TagPath;
import genj.util.Resources;
import genj.util.swing.ImageIcon;
import genj.util.swing.NestedBlockLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

public class EditNote
extends AbstractAncestrisAction {
    private static final Resources RESOURCES = Resources.get(EditNote.class);
    public static final ImageIcon EDIT_NOTE = Grammar.V551.getMeta(new TagPath("NOTE")).getImage();
    public static final ImageIcon NEW_NOTE = EDIT_NOTE.getOverLayed(Images.imgNew);
    public static final ImageIcon NO_NOTE = EDIT_NOTE.getTransparent(128);
    private Property property;

    public EditNote(Property property) {
        this(property, false);
    }

    public EditNote(Property property, boolean showNone) {
        this.property = property;
        boolean has = this.hasNote(property);
        this.setImage((Icon)(has ? EDIT_NOTE : (showNone ? NO_NOTE : NEW_NOTE)));
        this.setText(RESOURCES.getString(has ? "edit" : "new", new Object[]{Gedcom.getName((String)"NOTE")}));
        this.setTip(this.getText());
    }

    private boolean hasNote(Property property) {
        for (Property note : property.getProperties("NOTE")) {
            if (note instanceof PropertyNote && note.isValid() && ((Entity)((PropertyNote)note).getTargetEntity().get()).getValue().length() > 0) {
                return true;
            }
            if (note.getValue().length() <= 0) continue;
            return true;
        }
        return false;
    }

    public void actionPerformed(ActionEvent e) {
        Property note = this.property.getProperty("NOTE", true);
        JPanel panel = new JPanel((LayoutManager)new NestedBlockLayout("<col><entity/><text gy=\"1\"/></col>"));
        SelectEntityWidget select = new SelectEntityWidget(this.property.getGedcom(), "NOTE", RESOURCES.getString("new", new Object[]{Gedcom.getName((String)"NOTE")}), true);
        panel.add((Component)select);
        JTextPane text = new JTextPane();
        text.setPreferredSize(new Dimension(128, 128));
        panel.add(new JScrollPane(text));
        select.addActionListener(e1 -> {
            Note selection = (Note)select.getSelection();
            text.setText(selection != null ? selection.getDisplayValue() : "");
        });
        if (note instanceof PropertyNote && note.isValid()) {
            select.setSelection((Entity)((PropertyNote)note).getTargetEntity().get());
        } else if (note != null) {
            text.setText(note.getValue());
        }
        if (new GedcomDialog(this.property.getGedcom(), this.property.toString() + " - " + this.getTip(), panel).setMessageType(3).setOptionType(2).show() != DialogManager.OK_OPTION) {
            return;
        }
        this.property.getGedcom().doMuteUnitOfWork(gedcom -> {
            Note newNote = (Note)select.getSelection();
            if (newNote == null && !(note instanceof PropertyNote) && GedcomOptions.getInstance().isUseInline()) {
                if (note != null) {
                    note.setValue(text.getText());
                } else {
                    this.property.addProperty("NOTE", text.getText());
                }
                return;
            }
            String value = text.getText().trim();
            if (value.length() == 0) {
                if (newNote != null) {
                    gedcom.deleteEntity((Entity)newNote);
                    newNote = null;
                }
            } else {
                if (newNote == null) {
                    newNote = (Note)this.property.getGedcom().createEntity("NOTE");
                }
                newNote.setValue(value);
            }
            if (note != null && note.isValid()) {
                Note oldNote = null;
                if (note instanceof PropertyNote) {
                    oldNote = ((PropertyNote)note).getTargetEntity().orElse(null);
                }
                this.property.delProperty(note);
                if (oldNote != null && oldNote != newNote && !oldNote.isConnected()) {
                    gedcom.deleteEntity((Entity)oldNote);
                }
            }
            if (newNote != null) {
                this.property.addNote((AbstractNote)newNote);
            }
        });
    }
}

