#!/bin/sh -e

. package/info

check_elements(){
    for e in ${2}; do [ "$e" = "$1" ] && return 0; done ; return 1 ;
}

echo '#'
echo '# This file has been generated by tools/gen-deps.sh'
echo '#'
echo

for dir in src/include/${package} src/* ; do
    for file in $(ls -1 $dir | grep -- \\.h$) ; do

    {
        grep -F -- "#include <${package}/" < ${dir}/$file | cut -d'<' -f2 | cut -d'>' -f1 ;
        grep -- '#include ".*\.h"' < ${dir}/$file | cut -d'"' -f2
    } | sort -u | {

        deps=
        while read dep ; do
            if echo $dep | grep -q "^${package}/" ; then
                deps="$deps src/include/$dep"
            elif test -f "${dir}/$dep" ; then
                deps="$deps ${dir}/$dep"
            else
                deps="$deps src/include-local/$dep"
            fi
        done

        if test -n "$deps" ; then
            echo "${dir}/${file}:${deps}"
        fi
    }
    done
done

for dir in src/* ; do
    for file in $(ls -1 $dir | grep -- \\.c$) ; do

    {
        grep -F -- "#include <${package}/" < ${dir}/$file | cut -d'<' -f2 | cut -d'>' -f1 ;
        grep -- '#include ".*\.h"' < ${dir}/$file | cut -d'"' -f2
    } | sort -u | {

        deps=" ${dir}/$file"
        while read dep ; do
            if echo $dep | grep -q "^${package}/" ; then
                deps="$deps src/include/$dep"
            elif test -f "${dir}/$dep" ; then
                deps="$deps ${dir}/$dep"
            else
                deps="$deps src/include-local/$dep"
            fi
        done

        o=$(echo $file | sed s/\\.c$/.o/)
        lo=$(echo $file | sed s/\\.c$/.lo/)
        echo "${dir}/${o} ${dir}/${lo}:${deps}"
    }
    done
done

for dir in src/lib66/* ; do
    for file in $(ls -1 $dir | grep -- \\.c$) ; do

    {
        grep -F -- "#include <${package}/" < ${dir}/$file | cut -d'<' -f2 | cut -d'>' -f1 ;
        grep -- '#include ".*\.h"' < ${dir}/$file | cut -d'"' -f2
    } | sort -u | {

        deps=" ${dir}/$file"
        while read dep ; do
            if echo $dep | grep -q "^${package}/" ; then
                deps="$deps src/include/$dep"
            elif test -f "${dir}/$dep" ; then
                deps="$deps ${dir}/$dep"
            else
                deps="$deps src/include-local/$dep"
            fi
        done

        o=$(echo $file | sed s/\\.c$/.o/)
        lo=$(echo $file | sed s/\\.c$/.lo/)
        echo "${dir}/${o} ${dir}/${lo}:${deps}"
    }
    done
done

deps_lib(){

    local dir=${1} libs deps

    for file in $(ls -1 ${dir}) ; do
        for sfile in $(ls -1 ${dir}/${file}/deps-lib) ; do
            while read dep ; do
                if [ ! -z "$dep" ]; then
                    if echo $dep | grep -q -e ^-l -e '^\${.*_LIB}' ; then
                        if ! check_elements "$dep" "$libs"; then
                            libs="$libs $dep"
                        fi
                    else
                        deps="$deps ${dir}/${file}/$dep"
                    fi
                fi
            done < ${dir}/${file}/deps-lib/${sfile}
        done

    done
    echo 'ifeq ($(strip $(STATIC_LIBS_ARE_PIC)),)'
    echo "lib66.a.xyzzy:$deps"
    echo else
    echo "lib66.a.xyzzy:$(echo "$deps" | sed 's/\.o/.lo/g')"
    echo endif
    echo "lib66.so.xyzzy: EXTRA_LIBS :=$libs"
    echo "lib66.so.xyzzy:$(echo "$deps" | sed 's/\.o/.lo/g')"
    unset dir libs deps
}

for dir in $(ls -1 src | grep -v ^include) ; do

    if [ $dir == "lib66" ]; then
        deps_lib src/$dir
    fi

    if [ -e src/$dir/deps-exe ]; then
        for file in $(ls -1 src/$dir/deps-exe) ; do
            deps=
            libs=
            while read dep ; do
                if echo $dep | grep -q -- \\.o$ ; then
                    dep="src/$dir/$dep"
                fi
                if echo $dep | grep -q -e ^-l -e '^\${.*_LIB}' ; then
                    libs="$libs $dep"
                else
                    deps="$deps $dep"
                fi
            done < src/$dir/deps-exe/$file

            echo "$file: EXTRA_LIBS :=$libs"
            echo "$file: src/$dir/$file.o$deps"
        done
    fi
done
