#!/bin/sh

mountpoint -q /proc/sys/fs/binfmt_misc || \
mount -t binfmt_misc binfmt /proc/sys/fs/binfmt_misc

for path in /usr/lib/binfmt.d /etc/binfmt.d /run/binfmt.d; do
    [ ! -d $path ] && continue
    [ -z "$(ls $path)" ] && continue
    grep -h "^:" $path/* | \
        while read -r line; do
            reg=${line#*:}
            [ -e /proc/sys/fs/binfmt_misc/${reg%%:*} ] && echo -1 > /proc/sys/fs/binfmt_misc/${reg%%:*}
            printf "%s" "$line" > /proc/sys/fs/binfmt_misc/register
        done
done
