'\"
'\" Generated from file 'numtheory\&.man' by tcllib/doctools with format 'nroff'
'\" Copyright (c) 2010 Lars Hellström <Lars dot Hellstrom at residenset dot net>
'\"
.TH "math::numtheory" n 1\&.1\&.3 tcllib "Tcl Math Library"
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.BS
.SH NAME
math::numtheory \- Number Theory
.SH SYNOPSIS
package require \fBTcl  ?8\&.5?\fR
.sp
package require \fBmath::numtheory  ?1\&.1\&.3?\fR
.sp
\fBmath::numtheory::isprime\fR \fIN\fR ?\fIoption\fR \fIvalue\fR \&.\&.\&.?
.sp
\fBmath::numtheory::firstNprimes\fR \fIN\fR
.sp
\fBmath::numtheory::primesLowerThan\fR \fIN\fR
.sp
\fBmath::numtheory::primeFactors\fR \fIN\fR
.sp
\fBmath::numtheory::primesLowerThan\fR \fIN\fR
.sp
\fBmath::numtheory::primeFactors\fR \fIN\fR
.sp
\fBmath::numtheory::uniquePrimeFactors\fR \fIN\fR
.sp
\fBmath::numtheory::factors\fR \fIN\fR
.sp
\fBmath::numtheory::totient\fR \fIN\fR
.sp
\fBmath::numtheory::moebius\fR \fIN\fR
.sp
\fBmath::numtheory::legendre\fR \fIa\fR \fIp\fR
.sp
\fBmath::numtheory::jacobi\fR \fIa\fR \fIb\fR
.sp
\fBmath::numtheory::gcd\fR \fIm\fR \fIn\fR
.sp
\fBmath::numtheory::lcm\fR \fIm\fR \fIn\fR
.sp
\fBmath::numtheory::numberPrimesGauss\fR \fIN\fR
.sp
\fBmath::numtheory::numberPrimesLegendre\fR \fIN\fR
.sp
\fBmath::numtheory::numberPrimesLegendreModified\fR \fIN\fR
.sp
\fBmath::numtheory::differenceNumberPrimesLegendreModified\fR \fIlower\fR \fIupper\fR
.sp
\fBmath::numtheory::listPrimePairs\fR \fIlower\fR \fIupper\fR \fIstep\fR
.sp
\fBmath::numtheory::listPrimeProgressions\fR \fIlower\fR \fIupper\fR \fIstep\fR
.sp
.BE
.SH DESCRIPTION
.PP
This package is for collecting various number-theoretic operations, with
a slight bias to prime numbers\&.
.TP
\fBmath::numtheory::isprime\fR \fIN\fR ?\fIoption\fR \fIvalue\fR \&.\&.\&.?
The \fBisprime\fR command tests whether the integer \fIN\fR is a
prime, returning a boolean true value for prime \fIN\fR and a
boolean false value for non-prime \fIN\fR\&. The formal definition of
\'prime' used is the conventional, that the number being tested is
greater than 1 and only has trivial divisors\&.
.sp
To be precise, the return value is one of \fB0\fR (if \fIN\fR is
definitely not a prime), \fB1\fR (if \fIN\fR is definitely a
prime), and \fBon\fR (if \fIN\fR is probably prime); the latter
two are both boolean true values\&. The case that an integer may be
classified as "probably prime" arises because the Miller-Rabin
algorithm used in the test implementation is basically probabilistic,
and may if we are unlucky fail to detect that a number is in fact
composite\&. Options may be used to select the risk of such
"false positives" in the test\&. \fB1\fR is returned for "small"
\fIN\fR (which currently means \fIN\fR < 118670087467), where it is
known that no false positives are possible\&.
.sp
The only option currently defined is:
.RS
.TP
\fB-randommr\fR \fIrepetitions\fR
which controls how many times the Miller-Rabin test should be
repeated with randomly chosen bases\&. Each repetition reduces the
probability of a false positive by a factor at least 4\&. The
default for \fIrepetitions\fR is 4\&.
.RE
.IP
Unknown options are silently ignored\&.
.TP
\fBmath::numtheory::firstNprimes\fR \fIN\fR
Return the first N primes
.RS
.TP
integer \fIN\fR (in)
Number of primes to return
.RE
.TP
\fBmath::numtheory::primesLowerThan\fR \fIN\fR
Return the prime numbers lower/equal to N
.RS
.TP
integer \fIN\fR (in)
Maximum number to consider
.RE
.TP
\fBmath::numtheory::primeFactors\fR \fIN\fR
Return a list of the prime numbers in the number N
.RS
.TP
integer \fIN\fR (in)
Number to be factorised
.RE
.TP
\fBmath::numtheory::primesLowerThan\fR \fIN\fR
Return the prime numbers lower/equal to N
.RS
.TP
integer \fIN\fR (in)
Maximum number to consider
.RE
.TP
\fBmath::numtheory::primeFactors\fR \fIN\fR
Return a list of the prime numbers in the number N
.RS
.TP
integer \fIN\fR (in)
Number to be factorised
.RE
.TP
\fBmath::numtheory::uniquePrimeFactors\fR \fIN\fR
Return a list of the \fIunique\fR prime numbers in the number N
.RS
.TP
integer \fIN\fR (in)
Number to be factorised
.RE
.TP
\fBmath::numtheory::factors\fR \fIN\fR
Return a list of all \fIunique\fR factors in the number N, including 1 and N itself
.RS
.TP
integer \fIN\fR (in)
Number to be factorised
.RE
.TP
\fBmath::numtheory::totient\fR \fIN\fR
Evaluate the Euler totient function for the number N (number of numbers
relatively prime to N)
.RS
.TP
integer \fIN\fR (in)
Number in question
.RE
.TP
\fBmath::numtheory::moebius\fR \fIN\fR
Evaluate the Moebius function for the number N
.RS
.TP
integer \fIN\fR (in)
Number in question
.RE
.TP
\fBmath::numtheory::legendre\fR \fIa\fR \fIp\fR
Evaluate the Legendre symbol (a/p)
.RS
.TP
integer \fIa\fR (in)
Upper number in the symbol
.TP
integer \fIp\fR (in)
Lower number in the symbol (must be non-zero)
.RE
.TP
\fBmath::numtheory::jacobi\fR \fIa\fR \fIb\fR
Evaluate the Jacobi symbol (a/b)
.RS
.TP
integer \fIa\fR (in)
Upper number in the symbol
.TP
integer \fIb\fR (in)
Lower number in the symbol (must be odd)
.RE
.TP
\fBmath::numtheory::gcd\fR \fIm\fR \fIn\fR
Return the greatest common divisor of \fIm\fR and \fIn\fR
.RS
.TP
integer \fIm\fR (in)
First number
.TP
integer \fIn\fR (in)
Second number
.RE
.TP
\fBmath::numtheory::lcm\fR \fIm\fR \fIn\fR
Return the lowest common multiple of \fIm\fR and \fIn\fR
.RS
.TP
integer \fIm\fR (in)
First number
.TP
integer \fIn\fR (in)
Second number
.RE
.TP
\fBmath::numtheory::numberPrimesGauss\fR \fIN\fR
Estimate the number of primes according the formula by Gauss\&.
.RS
.TP
integer \fIN\fR (in)
Number in question, should be larger than 0
.RE
.TP
\fBmath::numtheory::numberPrimesLegendre\fR \fIN\fR
Estimate the number of primes according the formula by Legendre\&.
.RS
.TP
integer \fIN\fR (in)
Number in question, should be larger than 0
.RE
.TP
\fBmath::numtheory::numberPrimesLegendreModified\fR \fIN\fR
Estimate the number of primes according the modified formula by Legendre\&.
.RS
.TP
integer \fIN\fR (in)
Number in question, should be larger than 0
.RE
.TP
\fBmath::numtheory::differenceNumberPrimesLegendreModified\fR \fIlower\fR \fIupper\fR
Estimate the number of primes between tow limits according the modified formula by Legendre\&.
.RS
.TP
integer \fIlower\fR (in)
Lower limit for the primes, should be larger than 0
.TP
integer \fIupper\fR (in)
Upper limit for the primes, should be larger than 0
.RE
.TP
\fBmath::numtheory::listPrimePairs\fR \fIlower\fR \fIupper\fR \fIstep\fR
Return a list of pairs of primes each differing by the given step\&.
.RS
.TP
integer \fIlower\fR (in)
Lower limit for the primes, should be larger than 0
.TP
integer \fIupper\fR (in)
Upper limit for the primes, should be larger than the lower limit
.TP
integer \fIstep\fR (in)
Step by which the primes should differ, defaults to 2
.RE
.TP
\fBmath::numtheory::listPrimeProgressions\fR \fIlower\fR \fIupper\fR \fIstep\fR
Return a list of lists of primes each differing by the given step from the previous one\&.
.RS
.TP
integer \fIlower\fR (in)
Lower limit for the primes, should be larger than 0
.TP
integer \fIupper\fR (in)
Upper limit for the primes, should be larger than the lower limit
.TP
integer \fIstep\fR (in)
Step by which the primes should differ, defaults to 2
.RE
.PP
.SH "BUGS, IDEAS, FEEDBACK"
This document, and the package it describes, will undoubtedly contain
bugs and other problems\&.
Please report such in the category \fImath :: numtheory\fR of the
\fITcllib Trackers\fR [http://core\&.tcl\&.tk/tcllib/reportlist]\&.
Please also report any ideas for enhancements you may have for either
package and/or documentation\&.
.PP
When proposing code changes, please provide \fIunified diffs\fR,
i\&.e the output of \fBdiff -u\fR\&.
.PP
Note further that \fIattachments\fR are strongly preferred over
inlined patches\&. Attachments can be made by going to the \fBEdit\fR
form of the ticket immediately after its creation, and then using the
left-most button in the secondary navigation bar\&.
.SH KEYWORDS
number theory, prime
.SH CATEGORY
Mathematics
.SH COPYRIGHT
.nf
Copyright (c) 2010 Lars Hellström <Lars dot Hellstrom at residenset dot net>

.fi
