Serial Ports
============

The package `core.io` contains classes to access serial ports, both physical and virtual, on the
local machine.


Serial Ports
------------

The class [stormname:core.io.SerialPort] represents a serial port. There are two ways to create
[stormname:core.io.SerialPort] objects. Either by retrieving a list by calling the
[stormname:core.io.serialPorts] function and picking one, or by passing a system-specific identifier
to the constructor of [stormname:core.io.SerialPort] (i.e. `COMX` on Windows, or `/dev/ttySX` on
Linux).

The [stormname:core.io.SerialPort] class has the following members in addition to `==` and `hash`:

```stormdoc
@core.io.SerialPort
- .open(*)
- .name(*)
```

As mentioned previously, the following function can be used to enumerate all serial ports on the system:

```stormdoc
- core.io.serialPorts
```

Serial Streams
--------------

The `open` method of [stormname:core.io.SerialPort] returns a [stormname:core.io.SerialStream]
object that represents an open serial port. The [stormname:core.io.SerialOptions] class is used to
represent options of the serial connection. It has the following members:

```stormdoc
@core.io.SerialOptions
- .__init(*)
- .baudrate
- .byteSize
- .parity
- .stopBits
```

The [stormname:core.io.SerialStream] has the following members:

```stormdoc
@core.io.SerialStream
- .input(*)
- .output(*)
- .close(*)
- .options(*)
```
