-- -*- coding: utf-8 -*-
--- status: DRAFT
--- author(s): MES
--- notes: 

-- in Classic: (monomialIdeal, String)

document { 
     Key => monomialIdeal,
     Headline => "make a monomial ideal"
     }
document { 
     Key => {
	  (monomialIdeal,Matrix),
	  (monomialIdeal,RingElement),
	  (monomialIdeal,List),
	  (monomialIdeal,Sequence)},
     Headline => "monomial ideal of lead monomials",
     Usage => "monomialIdeal L",
     Inputs => {
	  "L" => Nothing => {ofClass Matrix, ", ",
	       ofClass RingElement, ", ",
	       ofClass List, ", or ",
	       ofClass Sequence}
	  },
     Outputs => {
	  MonomialIdeal => "the monomial ideal of lead monomials of the elements of L",
	  },
     "If L is a matrix, then it must have only one row.  For all of these types,
     the result is generated by only the lead monomials given: no Gröbner bases are computed.
     See ", TO (monomialIdeal,Ideal), " if the lead monomials of a Gröbner basis is desired.",
     EXAMPLE lines ///
	  R = ZZ/101[a,b,c];
	  I = monomialIdeal(a^3,b^3,c^3, a^2-b^2)
      	  M = monomialIdeal vars R
	  J = monomialIdeal 0_R
	  ///,
     "If the coefficient ring is ZZ, lead coefficients of the monomials are ignored.",
     EXAMPLE lines ///
       R = ZZ[x,y]
       monomialIdeal(2*x,3*y)
     ///,
     SeeAlso => {MonomialIdeal}
     }
document { 
     Key => {
	 (monomialIdeal, Ideal),
	 (monomialIdeal, Module),
	 (monomialIdeal, MonomialIdeal)},
     Headline => "monomial ideal of lead monomials of a Gröbner basis",
     Usage => "monomialIdeal J",
     Inputs => {
	  "J"
	  },
     Outputs => {
	  MonomialIdeal => {"the monomial ideal generated by the lead monomials of a Gröbner basis of ", 
	       TT "J" } },
     "J may also be a submodule of R^1, for R the ring of J.",
     EXAMPLE lines ///
	  R = ZZ/101[a,b,c];
	  I = ideal(a^3,b^3,c^3, a^2-b^2)
     	  monomialIdeal I	  
	  monomialSubideal I
	  ///,
     "If the coefficient ring is ZZ, lead coefficients of the monomials are ignored.",
     EXAMPLE lines ///
       R = ZZ[x,y]
       monomialIdeal ideal(2*x,3*y)
     ///,
     SeeAlso => {MonomialIdeal,monomialSubideal}
     }


