(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      6793,        195]
NotebookOptionsPosition[      6557,        182]
NotebookOutlinePosition[      6893,        197]
CellTagsIndexPosition[      6850,        194]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{"\"\<Problema 5\>\"", "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<=== 1. S\[OAcute]lido D ===\>\"", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "\"\<1.1. Gr\[AAcute]fico \
de D en el plano X-Y:\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["y", "2"]}], "\[Equal]", "1"}], ",", 
      RowBox[{
       RowBox[{
        SuperscriptBox["x", "2"], "-", 
        SuperscriptBox["y", "2"]}], "\[Equal]", "5"}], ",", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[Equal]", "4"}], ",", 
      RowBox[{
       RowBox[{"x", " ", "y"}], "\[Equal]", "1"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "10"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "\"\<1.2. Gr\[AAcute]fico \
de D en Z (suponiendo m=1):\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ContourPlot3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"x", "+", "y", "+", 
        RowBox[{"3", " ", "z"}]}], "\[Equal]", "2"}], ",", 
      RowBox[{
       RowBox[{"x", "+", "y", "+", 
        RowBox[{"3", " ", "z"}]}], "\[Equal]", "4"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "15"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "5"}], ",", "10"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", 
      RowBox[{"-", "9"}], ",", "5"}], "}"}], ",", 
    RowBox[{"AxesLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\"\<X\>\"", ",", "\"\<Y\>\"", ",", "\"\<Z\>\""}], "}"}]}], ",", 
    RowBox[{"Mesh", "\[Rule]", "None"}], ",", 
    RowBox[{"FaceGrids", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0", ",", 
         RowBox[{"-", "1"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "1"}], ",", "0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"FaceGridsStyle", "\[Rule]", 
     RowBox[{"Directive", "[", "Dashed", "]"}]}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "\"\<1.3. Momento de \
inercia en Z:\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"J1", "=", 
    FractionBox["1", 
     RowBox[{"6", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}]}]]}], ";"}], " ", 
  RowBox[{"(*", " ", "Jacobiano", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d1", "=", 
    RowBox[{"g", "[", "u", "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", "Densidad", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"Izd", "=", 
   RowBox[{"Integrate", "[", 
    RowBox[{
     RowBox[{"J1", " ", "d1", " ", 
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox["x", "2"], "+", 
        SuperscriptBox["y", "2"]}], ")"}]}], ",", 
     RowBox[{"{", 
      RowBox[{"u", ",", "1", ",", "5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"v", ",", "1", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"w", ",", "2", ",", 
       RowBox[{"4", "m"}]}], "}"}]}], "]"}]}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"\"\<=== 2. S\[OAcute]lido E ===\>\"", 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "\"\<2.1. Gr\[AAcute]fico \
de E en el plano X-Y:\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"ContourPlot", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"y", "\[Equal]", 
       RowBox[{"-", "x"}]}], ",", 
      RowBox[{"y", "\[Equal]", 
       RowBox[{"5", "-", "x"}]}], ",", 
      RowBox[{"x", "==", "1"}], ",", 
      RowBox[{"x", "\[Equal]", "5"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "2"}], ",", "8"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "8"}], ",", "8"}], "}"}]}], "]"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", "\"\<2.2. Momento de \
inercia en Z:\>\"", "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"J2", "=", "1"}], ";"}], " ", 
  RowBox[{"(*", " ", "Jacobiano", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"d2", "=", 
    FractionBox["k", 
     RowBox[{
      SuperscriptBox["x", "2"], "+", 
      SuperscriptBox["y", "2"]}]]}], ";"}], " ", 
  RowBox[{"(*", " ", "Densidad", " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Ize", "=", 
  RowBox[{"Integrate", "[", 
   RowBox[{
    RowBox[{"J2", " ", "d2", " ", 
     RowBox[{"(", 
      RowBox[{
       SuperscriptBox["x", "2"], "+", 
       SuperscriptBox["y", "2"]}], ")"}]}], ",", 
    RowBox[{"{", 
     RowBox[{"u", ",", "1", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"v", ",", "0", ",", "5"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"w", ",", "0", ",", 
      RowBox[{"g", "[", "u", "]"}]}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.6387327992168093`*^9, 3.638732804068037*^9}, {
   3.63873298460928*^9, 3.638733092957738*^9}, {3.638733145216991*^9, 
   3.6387332491198397`*^9}, {3.638761195961063*^9, 3.6387613413249397`*^9}, 
   3.638761556864925*^9, {3.638761593831718*^9, 3.638761676596403*^9}, {
   3.638761709430225*^9, 3.638761851342112*^9}, {3.638761884041648*^9, 
   3.638761976945223*^9}, {3.63876201800246*^9, 3.6387620804237022`*^9}, {
   3.638762117698328*^9, 3.6387621303918667`*^9}, {3.63876217592058*^9, 
   3.6387623303211107`*^9}, {3.6387624793598013`*^9, 3.638762539318665*^9}, {
   3.638762581458088*^9, 3.638762823232787*^9}, {3.6387629631127234`*^9, 
   3.638762997769565*^9}, {3.638763047419931*^9, 3.6387630492115097`*^9}, {
   3.638763089505518*^9, 3.6387632836807756`*^9}, 3.638763336766321*^9, {
   3.638764435293357*^9, 3.638764448553895*^9}}]
},
WindowSize->{1027, 664},
WindowMargins->{{Automatic, 62}, {Automatic, 0}},
FrontEndVersion->"9.0 for Linux x86 (64-bit) (February 7, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 5996, 160, 702, "Input"]
}
]
*)

(* End of internal cache information *)
