# ITK 5.4 Release Candidate 1: C++17

We are happy to announce the [Insight Toolkit (ITK)](https://itk.org) 5.4 Release Candidate 1 is available for testing! :tada: ITK is an open-source, cross-platform toolkit for N-dimensional scientific image processing, segmentation, and registration.

🔦 Highlights
-------------

ITK 5.4 is a feature release that continues our modern C++ evolution by requiring C\+\+17. The toolkit progresses in performance with a simple and elegant style and syntax. Through hundreds of changes in this release, we advance in readability and maintainability for the library and client code, often facilitated by improvements in the C++ standards.

Community contributions through Remote extension Modules are a valuable source of innovation in ITK, and updates to 30 modules in this release are no exception. A few examples of the Remote Modules updated include: *BoneMorphometry, Cleaver, GenericLabelInterpolator, IOScanco, LabelErodeDilate, MinimalPathExtraction, Montage, MorphologicalContourInterpolation, ParabolicMorphology, RANSAC, ReconstructionToolkit (RTK), TextureFeatures, TubeTK, Ultrasound, VkFFTBackend,* and *WebAssemblyInterface*. New modules can quickly be created with [a cookiecutter](https://github.com/InsightSoftwareConsortium/ITKModuleTemplate) and cross-platform testing for high quality development and Python package generation is supported by a [reusable GitHub Action](https://github.com/InsightSoftwareConsortium/ITKRemoteModuleBuildTestPackageAction). For more information, see Chapter 9 of the [ITK Software Guide](https://itk.org/ItkSoftwareGuide.pdf).

![image](https://github.com/InsightSoftwareConsortium/ITK/assets/25432/5c603076-1ab0-41e2-aedf-a2b29522d7d2)

*Highlights from the [ITKElastix Remote Module](https://github.com/InsightSoftwareConsortium/ITKElastix) presentation at SciPy 2023, the Annual Scientific Computing with Python Conference. Konstantinos Ntatsis, Niels Dekker, Viktor van der Valk, Tom Birdsong, Dženan Zukić, Stefan Klein, Marius Staring, & Matthew McCormick. (2023). itk-elastix: Medical image registration in Python [SciPy 2023 Poster]. Zenodo. [https://doi.org/10.5281/zenodo.8136801](https://doi.org/10.5281/zenodo.8136801).*

💾 Download
-------------

**Python Packages**

Install [ITK Python packages](https://itkpythonpackage.readthedocs.io/en/latest/Quick_start_guide.html) with:

```sh
pip install --upgrade --pre itk
```

**Guide and Textbook**

- [InsightSoftwareGuide-Book1-5.4rc01.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightSoftwareGuide-Book1-5.4rc01.pdf)
- [InsightSoftwareGuide-Book2-5.4rc01.pdf](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightSoftwareGuide-Book2-5.4rc01.pdf)

**Library Sources**

- [InsightToolkit-5.4rc01.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightToolkit-5.4rc01.tar.gz)
- [InsightToolkit-5.4rc01.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightToolkit-5.4rc01.zip)

**Testing Data**

Unpack optional testing data in the same directory where the Library Source is unpacked.

- [InsightData-5.4rc01.tar.gz](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightData-5.4rc01.tar.gz)
- [InsightData-5.4rc01.zip](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/InsightData-5.4rc01.zip)

**Checksums**

- [MD5SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/MD5SUMS)
- [SHA512SUMS](https://github.com/InsightSoftwareConsortium/ITK/releases/download/v5.4rc01/SHA512SUMS)


✨ Features
------------

### Python

- `itk.imread` supports a `series_uid` kwarg for DICOM series selection
- TBB version updated to latest stable version, disabled on Intel macOS
- Python binaries for 3.7-3.11 across platforms
- This will be the last release with Python 3.7 suppport
- Remote module GitHub action updated, Python 3.7 is not supported in Remote module builds
- Updated to the latest version of scikit-build

### C++

- C++17 is now required
- Many style improvements for modern C++
- GCC 13 support
- Name mangling prefix for third party libraries is configurable
- Many improvements to code coverage
- Improved SSE2 detection
- Enhanced NRRD and Nifti metadata support

### Documentation

- Doxygen formatting cleanup
- Doxygen spelling fixes
- Doxygen Insight Journal links are consistent
- Software Guide updated for style modernization

### Remote module updates

Updated modules:
- [BSplineGradient](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient.git)
- [BoneMorphometry](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry.git)
- [Cleaver](https://github.com/SCIInstitute/ITKCleaver.git)
- [Cuberille](https://github.com/InsightSoftwareConsortium/ITKCuberille.git),
- [CudaCommon](https://github.com/RTKConsortium/ITKCudaCommon.git)
- [FPFH](https://github.com/InsightSoftwareConsortium/ITKFPFH.git)
- [GenericLabelInterpolator](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator.git)
- [HASI](https://github.com/KitwareMedical/HASI.git)
- [HigherOrderAccurateGradient](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient.git)
- [IOMeshSTL](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL.git)
- [IOMeshSWC](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC.git)
- [IOScanco](https://github.com/KitwareMedical/ITKIOScanco.git)
- [LabelErodeDilate](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate.git)
- [MeshToPolyData](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData.git)
- [MinimalPathExtraction](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction.git)
- [Montage](https://github.com/InsightSoftwareConsortium/ITKMontage.git)
- [MorphologicalContourInterpolation](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation.git)
- [ParabolicMorphology](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology.git)
- [RANSAC](https://github.com/InsightSoftwareConsortium/ITKRANSAC.git)
- [RLEImage](https://github.com/KitwareMedical/ITKRLEImage.git)
- [RTK](https://github.com/RTKConsortium/RTK.git)
- [Shape](https://github.com/SlicerSALT/ITKShape.git)
- [SimpleITKFilters](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters.git)
- [SplitComponents](https://github.com/InsightSoftwareConsortium/ITKSplitComponents.git)
- [Strain](https://github.com/KitwareMedical/ITKStrain.git)
- [TextureFeatures](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures.git)
- [Thickness3D](https://github.com/InsightSoftwareConsortium/ITKThickness3D.git)
- [TubeTK](https://github.com/InsightSoftwareConsortium/ITKTubeTK.git)
- [Ultrasound](https://github.com/KitwareMedical/ITKUltrasound.git)
- [VkFFTBackend](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend.git)
- [WebAssemblyInterface](https://github.com/InsightSoftwareConsortium/itk-wasm.git)


### Third party library updates

- eigen
- gdcm
- googletest
- kwsys
- nifti
- vxl
- zlib-ng


🙏 Congratulations
------------------------

Congratulations and **thank you** to everyone who contributed to this release.

Of the *42 authors* who contributed since v5.3.0, we would like to specially recognize the new contributors:

*huangjxbq, Sankhesh Jhaveri, adrinkwater, FabioLolix, Vaibhaw, Ningfei Li, Max Aehle, Noah Egnatis, Federico Zivolo, Patrick Linnane, LAURENDEAU Matthieu, Shreeraj Jadhav, Shengpeng YU, Fernando Bordignon, and Andras Lasso.*

🗣️ What's Next
---------------

Our next release candidate will include improvements based on experiences with 5.4 RC 1. Please try out the current release candidate, and discuss your experiences at [discourse.itk.org](https://discourse.itk.org). Contribute with pull requests, code reviews, and issue discussions in our [GitHub Organization](https://github.com/InsightSoftwareConsortium).

**Enjoy ITK!**

ITK Changes Since v5.3.0
---------------------------------------------

### Andras Lasso (1):

#### Bug Fixes

- Fix read/write of displacement field in NIFTI file format ([d007ee8e78](https://github.com/InsightSoftwareConsortium/ITK/commit/d007ee8e78))


### Bradley Lowekamp (20):

#### Enhancements

- Add VectorImage support to MaskNegateImageFilter ([e3a1a598c8](https://github.com/InsightSoftwareConsortium/ITK/commit/e3a1a598c8))
- Set ITK_TEST_OUTPUT_DIR with module path ([7d50786353](https://github.com/InsightSoftwareConsortium/ITK/commit/7d50786353))
- Use generator/lambda ITK filter for pixel computation ([0624dad082](https://github.com/InsightSoftwareConsortium/ITK/commit/0624dad082))
- Restore integer support for laplacian sharpening ([6a5060be54](https://github.com/InsightSoftwareConsortium/ITK/commit/6a5060be54))

#### Platform Fixes

- Supress warning in MSVC for non-float complex ([3a9c76273e](https://github.com/InsightSoftwareConsortium/ITK/commit/3a9c76273e))
- fix linkage for MINCTransformIO ([97f003cb91](https://github.com/InsightSoftwareConsortium/ITK/commit/97f003cb91))
- Supress warning in MSVC for non-float complex ([a7a3e5dfe0](https://github.com/InsightSoftwareConsortium/ITK/commit/a7a3e5dfe0))
- Address HasNumericTraits failure for Vector pixel type. ([c9fc138886](https://github.com/InsightSoftwareConsortium/ITK/commit/c9fc138886))
- address missing enum error ([dbc9c9112f](https://github.com/InsightSoftwareConsortium/ITK/commit/dbc9c9112f))
- QualifiedIterator follow rule of zero ([df6aa66e40](https://github.com/InsightSoftwareConsortium/ITK/commit/df6aa66e40))

#### Bug Fixes

- Set GTest discovery timeout to 120 ([050bab52f2](https://github.com/InsightSoftwareConsortium/ITK/commit/050bab52f2))
- Restore setting TargetPoints after ReachMode ([bb0f6e84fe](https://github.com/InsightSoftwareConsortium/ITK/commit/bb0f6e84fe))
- Remove dead code in MRC Header ([d96191b40e](https://github.com/InsightSoftwareConsortium/ITK/commit/d96191b40e))
- Fix MRC zero spacing for tilt series ([c380670dd1](https://github.com/InsightSoftwareConsortium/ITK/commit/c380670dd1))
- MRC write full machine stamp ([cac4e26b69](https://github.com/InsightSoftwareConsortium/ITK/commit/cac4e26b69))
- Remove dead code in MRC Header ([3b643f53f9](https://github.com/InsightSoftwareConsortium/ITK/commit/3b643f53f9))
- Fix MRC zero spacing for tilt series ([e7ffba648f](https://github.com/InsightSoftwareConsortium/ITK/commit/e7ffba648f))
- MRC write full machine stamp ([8ca5d1f676](https://github.com/InsightSoftwareConsortium/ITK/commit/8ca5d1f676))
- Add missing string value for NoTargets enum ([ac32a50e6e](https://github.com/InsightSoftwareConsortium/ITK/commit/ac32a50e6e))

#### Style Changes

- Use inline initializers for MaskImageFilter ([c0374a334c](https://github.com/InsightSoftwareConsortium/ITK/commit/c0374a334c))


### Darren Thompson (2):

#### Platform Fixes

- Reworked ITKFFT_SRCS for FFTW and cuFFTW use ([5703c74375](https://github.com/InsightSoftwareConsortium/ITK/commit/5703c74375))

#### Bug Fixes

- itkFFTWFFTImageFilterInitFactory.cxx is required for ITK_USE_CUFFTW ([5b9861d743](https://github.com/InsightSoftwareConsortium/ITK/commit/5b9861d743))


### Dave Chen (10):

#### Documentation Updates

- fixed spelling errors in Modules/IO subdir ([64f2428bd0](https://github.com/InsightSoftwareConsortium/ITK/commit/64f2428bd0))
- Fixed spelling bugs in Modules/Filtering headers ([2513f8f62e](https://github.com/InsightSoftwareConsortium/ITK/commit/2513f8f62e))
- Spell checking Registration headers ([b44e0b13f8](https://github.com/InsightSoftwareConsortium/ITK/commit/b44e0b13f8))
- Spell checking Modules/Segmentation ([9cf6ee9081](https://github.com/InsightSoftwareConsortium/ITK/commit/9cf6ee9081))
- spell checking Modules/Numerics ([f51ac27b98](https://github.com/InsightSoftwareConsortium/ITK/commit/f51ac27b98))
- Spellcheck Filtering HXX and Video headers ([ed7ad92dd6](https://github.com/InsightSoftwareConsortium/ITK/commit/ed7ad92dd6))
- Spell check remaining headers ([61b0a16d22](https://github.com/InsightSoftwareConsortium/ITK/commit/61b0a16d22))
- spell out OOP ([379eb109e9](https://github.com/InsightSoftwareConsortium/ITK/commit/379eb109e9))
- Spell check the code in Examples ([e6b03bbd4b](https://github.com/InsightSoftwareConsortium/ITK/commit/e6b03bbd4b))

#### Style Changes

- Fixed spelling errors in Modules/Core headers ([2ec7cd1cf7](https://github.com/InsightSoftwareConsortium/ITK/commit/2ec7cd1cf7))


### Dženan Zukić (24):

#### Enhancements

- Disable itkNiftiLargeImageRegionReadTest on 32-bit architectures ([f77c8dbd0a](https://github.com/InsightSoftwareConsortium/ITK/commit/f77c8dbd0a))
- Improve itk.imread error message when the input file doesn't exist ([3c802f650d](https://github.com/InsightSoftwareConsortium/ITK/commit/3c802f650d))
- Use latest stable GTest v1.13.0 ([56875007ab](https://github.com/InsightSoftwareConsortium/ITK/commit/56875007ab))
- Add ITK_NODISCARD(message) macro to Image "Transform" members ([bc75d43a41](https://github.com/InsightSoftwareConsortium/ITK/commit/bc75d43a41))
- Update remote modules using the script ([455b06be6c](https://github.com/InsightSoftwareConsortium/ITK/commit/455b06be6c))
- Update remote modules using the script ([a0c67bb21e](https://github.com/InsightSoftwareConsortium/ITK/commit/a0c67bb21e))
- Drop support for MSVC toolset v141 aka Visual Studio 2017 ([140f3c249f](https://github.com/InsightSoftwareConsortium/ITK/commit/140f3c249f))
- Update ContinuousIntegration Batch test to use VS2022 ([92c17bc4da](https://github.com/InsightSoftwareConsortium/ITK/commit/92c17bc4da))
- Exclude Utilities/ITKv5Preparation/* from triggering CI builds ([f5cfdd4018](https://github.com/InsightSoftwareConsortium/ITK/commit/f5cfdd4018))
- Update remote modules using the script ([56c7434002](https://github.com/InsightSoftwareConsortium/ITK/commit/56c7434002))

#### Documentation Updates

- Add a reminder to update API docs link to older version ([da36517a51](https://github.com/InsightSoftwareConsortium/ITK/commit/da36517a51))

#### Platform Fixes

- Use proper floating point-pixel type in Frequency FFT Layout Test ([9a7846e6a1](https://github.com/InsightSoftwareConsortium/ITK/commit/9a7846e6a1))
- Fix new warning STL4037 raised by VS2022 ([37e4c71805](https://github.com/InsightSoftwareConsortium/ITK/commit/37e4c71805))
- Use proper floating point-pixel type in Frequency FFT Layout Test ([19e02a4e9d](https://github.com/InsightSoftwareConsortium/ITK/commit/19e02a4e9d))
- Fix new warning STL4037 raised by VS2022 ([0892cd1e3f](https://github.com/InsightSoftwareConsortium/ITK/commit/0892cd1e3f))
- Fix deprecation warning for PyEval_CallObject ([138f9d9e8d](https://github.com/InsightSoftwareConsortium/ITK/commit/138f9d9e8d))
- Fix boolean member print statement in `itk::GPUDataManager` ([9b55bcec62](https://github.com/InsightSoftwareConsortium/ITK/commit/9b55bcec62))
- Add Superclass alias to GPUGradientAnisotropicDiffusionImageFilter ([296db6ac2b](https://github.com/InsightSoftwareConsortium/ITK/commit/296db6ac2b))
- Update maintenance script to compile with C++17 ([04ef14a37a](https://github.com/InsightSoftwareConsortium/ITK/commit/04ef14a37a))

#### Bug Fixes

- Fix a crash in itkDirectoryTest caused by updating to newest KWSys ([b92705851b](https://github.com/InsightSoftwareConsortium/ITK/commit/b92705851b))

#### Style Changes

- Convert a tab indent into spaces in BuildHeaderTest.py ([0ca7901450](https://github.com/InsightSoftwareConsortium/ITK/commit/0ca7901450))
- Change some declarations to use trailing return type ([b37ac53206](https://github.com/InsightSoftwareConsortium/ITK/commit/b37ac53206))
- Use trailing return type instead of typename + dependent type ([5f83fb2537](https://github.com/InsightSoftwareConsortium/ITK/commit/5f83fb2537))
- Use trailing return type for declarations containing "inline" ([f048a5b8a9](https://github.com/InsightSoftwareConsortium/ITK/commit/f048a5b8a9))


### FabioLolix (1):

#### Platform Fixes

- add missing header with GCC 13.1.1 ([d3b5e8baa6](https://github.com/InsightSoftwareConsortium/ITK/commit/d3b5e8baa6))


### Fernando Bordignon (1):

#### Platform Fixes

- Mangle HDF5 symbols: H5_debug_t, H5E_t and H5I_type_info_t ([17b0fded41](https://github.com/InsightSoftwareConsortium/ITK/commit/17b0fded41))


### GDCM Upstream (2):

#### Miscellaneous Changes

- GDCM 2023-05-05 (401a81d7) ([8713d6f217](https://github.com/InsightSoftwareConsortium/ITK/commit/8713d6f217))
- GDCM 2023-06-02 (2ea6fd87) ([6f3a0a8855](https://github.com/InsightSoftwareConsortium/ITK/commit/6f3a0a8855))


### GoogleTest Upstream (1):

#### Miscellaneous Changes

- GoogleTest 2023-01-17 (b796f7d4) ([1a5c2de017](https://github.com/InsightSoftwareConsortium/ITK/commit/1a5c2de017))


### Hans J. Johnson (17):

#### Enhancements

- Need large source for lbfg*.c files ([a5d61cb4d0](https://github.com/InsightSoftwareConsortium/ITK/commit/a5d61cb4d0))
- Add more specific diagnostics for lbfgs stopping ([0de99b2d48](https://github.com/InsightSoftwareConsortium/ITK/commit/0de99b2d48))
- Enforce computational requirements for SobelOperator ([03c8176dca](https://github.com/InsightSoftwareConsortium/ITK/commit/03c8176dca))

#### Performance Improvements

- Should not check bounds by default with vnl ([67a791262f](https://github.com/InsightSoftwareConsortium/ITK/commit/67a791262f))

#### Platform Fixes

- Threads package is required by TBB ([5d1aa4aced](https://github.com/InsightSoftwareConsortium/ITK/commit/5d1aa4aced))
- Manually merged formatting changes for jpeg9f ([b37e416490](https://github.com/InsightSoftwareConsortium/ITK/commit/b37e416490))
- Updated to jpeg9f to address ubsan failures ([e80db20c05](https://github.com/InsightSoftwareConsortium/ITK/commit/e80db20c05))
- Manual review of itkjpeg and jpeg-8b differences ([cd6d907d5c](https://github.com/InsightSoftwareConsortium/ITK/commit/cd6d907d5c))
- Suppress ubsan in H5detect.c code ([bdc523419f](https://github.com/InsightSoftwareConsortium/ITK/commit/bdc523419f))
- Remove unused variables ([cd97879e6b](https://github.com/InsightSoftwareConsortium/ITK/commit/cd97879e6b))
- Remove clang unsupported compiler flag from default ([4fc92814dc](https://github.com/InsightSoftwareConsortium/ITK/commit/4fc92814dc))

#### Bug Fixes

- Testing of sobel operators was being done with unsigned data values ([a8eed95093](https://github.com/InsightSoftwareConsortium/ITK/commit/a8eed95093))
- Casting negative numbers to unsigned char error ([1d6b3e92bc](https://github.com/InsightSoftwareConsortium/ITK/commit/1d6b3e92bc))
- implicit conversion undefined behavior ([264114331f](https://github.com/InsightSoftwareConsortium/ITK/commit/264114331f))

#### Style Changes

- Use typedef for type to ensure consistency ([1eb4fed9a3](https://github.com/InsightSoftwareConsortium/ITK/commit/1eb4fed9a3))
- Prefer initialization to assignment ([1a6f2ce261](https://github.com/InsightSoftwareConsortium/ITK/commit/1a6f2ce261))
- Prefer C++11 zero initializer to ZeroValue ([ef5cc8c495](https://github.com/InsightSoftwareConsortium/ITK/commit/ef5cc8c495))


### Jon Haitz Legarreta Gorroño (83):

#### Enhancements

- Use windows-2019 image v141 toolchain in `Batch` Azure CI matrix ([2cf08be965](https://github.com/InsightSoftwareConsortium/ITK/commit/2cf08be965))
- Apply the `type:Infrastructure` label to CI config files ([a83d4ded92](https://github.com/InsightSoftwareConsortium/ITK/commit/a83d4ded92))
- Increase coverage for miscellaneous classes ([41339276ee](https://github.com/InsightSoftwareConsortium/ITK/commit/41339276ee))
- Add boolean macro to use cluster labels ([4351f3651a](https://github.com/InsightSoftwareConsortium/ITK/commit/4351f3651a))
- Use `itkPrintSelfObjectMacro` to print objects that can be null ([c6d374a457](https://github.com/InsightSoftwareConsortium/ITK/commit/c6d374a457))
- Increase coverage for `itk::AttributeSelectionLabelMapFilter` ([e9bc06e6f5](https://github.com/InsightSoftwareConsortium/ITK/commit/e9bc06e6f5))
- Increase coverage for `itk::OnePlusOneEvolutionaryOptimizer` ([5286bdb2f3](https://github.com/InsightSoftwareConsortium/ITK/commit/5286bdb2f3))
- Increase coverage for `itk::ImageRegistrationMethodv4` ([ac019e3744](https://github.com/InsightSoftwareConsortium/ITK/commit/ac019e3744))
- Add boolean macro to across-scale normalization ivar ([e7aca74334](https://github.com/InsightSoftwareConsortium/ITK/commit/e7aca74334))
- Increase coverage for `itk::RecursiveGaussianImageFilter` ([7c13d36ba0](https://github.com/InsightSoftwareConsortium/ITK/commit/7c13d36ba0))
- Add test for the `itk::BoundedReciprocalImageFilter` class ([9d2c892600](https://github.com/InsightSoftwareConsortium/ITK/commit/9d2c892600))
- Fix `clang-format` workflow actions warnings linked to `Node.js` ([791686038e](https://github.com/InsightSoftwareConsortium/ITK/commit/791686038e))
- Use strongly typed enums for FMUG filter target reached condition ([6919764fab](https://github.com/InsightSoftwareConsortium/ITK/commit/6919764fab))
- Remove ivar memberless/static-only class `PrinSelf` ([d2ff3110f1](https://github.com/InsightSoftwareConsortium/ITK/commit/d2ff3110f1))
- Increase coverage for miscellaneous classes ([f76d26a0e2](https://github.com/InsightSoftwareConsortium/ITK/commit/f76d26a0e2))
- Add getter methods for `itk::KdTreeGenerator` publicly set ivars ([2c5dec142e](https://github.com/InsightSoftwareConsortium/ITK/commit/2c5dec142e))
- Use ITK macros to print runtime type information ([74f557094b](https://github.com/InsightSoftwareConsortium/ITK/commit/74f557094b))
- Remove ivar memberless `PrintSelf` ([1f81ef69d1](https://github.com/InsightSoftwareConsortium/ITK/commit/1f81ef69d1))
- Remove `itkMath.h` duplicate include ([48025bd985](https://github.com/InsightSoftwareConsortium/ITK/commit/48025bd985))
- Remove duplicate `itkMath.h` include in itkFEMRegistrationFilter ([4d440dc3ae](https://github.com/InsightSoftwareConsortium/ITK/commit/4d440dc3ae))
- Provide with printing ability to time resource classes ([cd303c33ae](https://github.com/InsightSoftwareConsortium/ITK/commit/cd303c33ae))
- Increase coverage for `itk::ConstantVelocityFieldTransform` ([33697686c7](https://github.com/InsightSoftwareConsortium/ITK/commit/33697686c7))
- Increase coverage for miscellaneous classes ([bf183be9c4](https://github.com/InsightSoftwareConsortium/ITK/commit/bf183be9c4))
- Increase coverage for `itk::Rigid3DTransform` ([9bc884e619](https://github.com/InsightSoftwareConsortium/ITK/commit/9bc884e619))
- Test `itk::RegistrationParameterScales*` classes ([bc1025b1c0](https://github.com/InsightSoftwareConsortium/ITK/commit/bc1025b1c0))
- Add macros to `itk::kRegistrationParameterScalesEstimator` ivars ([37a2151768](https://github.com/InsightSoftwareConsortium/ITK/commit/37a2151768))
- Increase `RegistrationParameterScalesFromPhysicalShift` coverage ([165fb5b6fe](https://github.com/InsightSoftwareConsortium/ITK/commit/165fb5b6fe))

#### Performance Improvements

- Remove immediately modified ivar assignment ([d1c46d63be](https://github.com/InsightSoftwareConsortium/ITK/commit/d1c46d63be))

#### Documentation Updates

- Fix class names in documentation and comments ([482102d507](https://github.com/InsightSoftwareConsortium/ITK/commit/482102d507))
- Fix typos in documentation ([d589e6b034](https://github.com/InsightSoftwareConsortium/ITK/commit/d589e6b034))
- Remove unnecessary or empty implementation file method doc blocks ([aff7703dc8](https://github.com/InsightSoftwareConsortium/ITK/commit/aff7703dc8))
- Document methods in header file ([c7d3cda80f](https://github.com/InsightSoftwareConsortium/ITK/commit/c7d3cda80f))
- Make class description be a complete sentence ([4241506fa8](https://github.com/InsightSoftwareConsortium/ITK/commit/4241506fa8))
- Fix grammar in documentation ([18609c6296](https://github.com/InsightSoftwareConsortium/ITK/commit/18609c6296))
- Restrict the class authorship to the Doxygen documentation ([eae47ff0d1](https://github.com/InsightSoftwareConsortium/ITK/commit/eae47ff0d1))
- Remove duplicate `FourierTransform` Doxygen grouping command ([138d135656](https://github.com/InsightSoftwareConsortium/ITK/commit/138d135656))
- Clean up method Doxygen documentation ([d58bf56fe2](https://github.com/InsightSoftwareConsortium/ITK/commit/d58bf56fe2))
- Clean up method Doxygen documentation ([c44f9c1b39](https://github.com/InsightSoftwareConsortium/ITK/commit/c44f9c1b39))
- Change the Insight Journal handle links to insight-journal links ([e936cabc7a](https://github.com/InsightSoftwareConsortium/ITK/commit/e936cabc7a))
- Make insight-journal links consistent: add www to URL ([7e000aec50](https://github.com/InsightSoftwareConsortium/ITK/commit/7e000aec50))
- Consolidate `LaplacianSharpeningImageFilter` `UseImageSpacing` doc ([75bf848e27](https://github.com/InsightSoftwareConsortium/ITK/commit/75bf848e27))
- Clean up method Doxygen documentation ([9d1a93dfb8](https://github.com/InsightSoftwareConsortium/ITK/commit/9d1a93dfb8))

#### Platform Fixes

- Install the `lxml` Python package for the `Batch` Azure CI build ([1adbb26384](https://github.com/InsightSoftwareConsortium/ITK/commit/1adbb26384))
- Fix missing initialization braces warnings ([5834520cc9](https://github.com/InsightSoftwareConsortium/ITK/commit/5834520cc9))
- Fix missing initialization braces warning in Convolution test ([5094cfb7f5](https://github.com/InsightSoftwareConsortium/ITK/commit/5094cfb7f5))
- Remove unused local variables in image iterator tests ([fd38fe7290](https://github.com/InsightSoftwareConsortium/ITK/commit/fd38fe7290))
- Fix declaration and syntax errors in Review class `PrintSelf` ([94538d42c2](https://github.com/InsightSoftwareConsortium/ITK/commit/94538d42c2))
- Fix `Regitration::FEM` module `PrintSelf` compiler errors ([dde9dc39c0](https://github.com/InsightSoftwareConsortium/ITK/commit/dde9dc39c0))
- Restore `PrintSelf` in itkGPUPDEDeformableRegistrationFilter.h ([fc1cce56a9](https://github.com/InsightSoftwareConsortium/ITK/commit/fc1cce56a9))
- Provide prefix-less member name to `itkPrintSelfObjectMacro` ([748ef3002a](https://github.com/InsightSoftwareConsortium/ITK/commit/748ef3002a))
- Fix itkParallelSparseFieldLevelSetImageFilter uninitialized memory ([f11797b7a9](https://github.com/InsightSoftwareConsortium/ITK/commit/f11797b7a9))
- Fix `itk::Histogram` uninitialized memory ([b32182fdec](https://github.com/InsightSoftwareConsortium/ITK/commit/b32182fdec))

#### Bug Fixes

- Fix Superclass name in RTTI macro ([d60ed81f76](https://github.com/InsightSoftwareConsortium/ITK/commit/d60ed81f76))
- Fix input argument indices in test ([dcc8ea3851](https://github.com/InsightSoftwareConsortium/ITK/commit/dcc8ea3851))
- Fix Superclass name in RTTI macro ([84d402a619](https://github.com/InsightSoftwareConsortium/ITK/commit/84d402a619))
- Set ivar to appropriate value when condition is met ([cd3e200ada](https://github.com/InsightSoftwareConsortium/ITK/commit/cd3e200ada))
- Fix uninitialized value ImageRegistrationMethodv4::m_NumberOfLevels ([a31e8bf32a](https://github.com/InsightSoftwareConsortium/ITK/commit/a31e8bf32a))
- Fix symbol exportation macro module name in `itk::DCMTKImageIO` ([736410b7e1](https://github.com/InsightSoftwareConsortium/ITK/commit/736410b7e1))
- Add semicolon after `ITK_EXERCISE_BASIC_OBJECT_METHODS` call ([9a2379f0f7](https://github.com/InsightSoftwareConsortium/ITK/commit/9a2379f0f7))

#### Style Changes

- Prefer using test macros for setter/getter method testing ([f0e6c56e6f](https://github.com/InsightSoftwareConsortium/ITK/commit/f0e6c56e6f))
- Rename a type alias to honor the class purpose ([f20e3140c4](https://github.com/InsightSoftwareConsortium/ITK/commit/f20e3140c4))
- Conform to ITK style in miscellaneous tests ([1de6b4fc4a](https://github.com/InsightSoftwareConsortium/ITK/commit/1de6b4fc4a))
- Prefer using exception macros in tests ([f0ce6a871f](https://github.com/InsightSoftwareConsortium/ITK/commit/f0ce6a871f))
- Prefer using local counters in loops ([b28578da4f](https://github.com/InsightSoftwareConsortium/ITK/commit/b28578da4f))
- Improve style in miscellaneous `LabelMap` module tests ([3d6a2e147e](https://github.com/InsightSoftwareConsortium/ITK/commit/3d6a2e147e))
- Prefer using exception macros in tests ([b3dadeee1d](https://github.com/InsightSoftwareConsortium/ITK/commit/b3dadeee1d))
- Remove unnecessary test starting message ([acd4b67359](https://github.com/InsightSoftwareConsortium/ITK/commit/acd4b67359))
- Use canonical naming for itkRecursiveGaussianImageFilter tests ([4156d3d563](https://github.com/InsightSoftwareConsortium/ITK/commit/4156d3d563))
- Prefer double forward slashes for within-method body comments ([be6b447afc](https://github.com/InsightSoftwareConsortium/ITK/commit/be6b447afc))
- Remove commented output stream messages ([f42c10a20f](https://github.com/InsightSoftwareConsortium/ITK/commit/f42c10a20f))
- Remove unnecessary within-method body comments ([7a34977bd4](https://github.com/InsightSoftwareConsortium/ITK/commit/7a34977bd4))
- Break line before calling `PrintSelf` in test ([626c1b4d99](https://github.com/InsightSoftwareConsortium/ITK/commit/626c1b4d99))
- Remove commented code in `itk::LevelSetMotionRegistrationFunction` ([484ada7ff8](https://github.com/InsightSoftwareConsortium/ITK/commit/484ada7ff8))
- Prefer double forward slashes for within-method body comments ([1a296b5dd3](https://github.com/InsightSoftwareConsortium/ITK/commit/1a296b5dd3))
- Make `PrintSelf` implementation style consistent ([c47ed1c1b3](https://github.com/InsightSoftwareConsortium/ITK/commit/c47ed1c1b3))
- Use the ellipsis properly in printed messages ([a925c70af8](https://github.com/InsightSoftwareConsortium/ITK/commit/a925c70af8))
- Remove an unnecessary static_cast from Histogram::PrintSelf ([4aa66a29e2](https://github.com/InsightSoftwareConsortium/ITK/commit/4aa66a29e2))
- Prefer in-class `{}` member initializers ([998b25b25a](https://github.com/InsightSoftwareConsortium/ITK/commit/998b25b25a))
- Make `PrintSelf` implementation style consistent ([e750782e41](https://github.com/InsightSoftwareConsortium/ITK/commit/e750782e41))
- Remove duplicate statement in `itk::Histogram::Initialize` ([bbc691ab30](https://github.com/InsightSoftwareConsortium/ITK/commit/bbc691ab30))
- Prefer double forward slashes for within-method body comments ([647ef1fe6a](https://github.com/InsightSoftwareConsortium/ITK/commit/647ef1fe6a))
- Remove unnecessary within-method body comments ([1d316c5454](https://github.com/InsightSoftwareConsortium/ITK/commit/1d316c5454))
- Make PrintSelf implementation style consistent ([34a598a3a8](https://github.com/InsightSoftwareConsortium/ITK/commit/34a598a3a8))


### KWSys Upstream (1):

#### Miscellaneous Changes

- KWSys 2023-01-19 (be3c441e) ([e8b74bbf06](https://github.com/InsightSoftwareConsortium/ITK/commit/e8b74bbf06))


### Lee Newberg (1):

#### Platform Fixes

- Replace numpy.bool8 (deprecated in numpy>=1.24) with numpy.bool_ ([a508af5100](https://github.com/InsightSoftwareConsortium/ITK/commit/a508af5100))


### Matt McCormick (23):

#### Enhancements

- Bump ITK_VERSION_MINOR to 4 ([928774748a](https://github.com/InsightSoftwareConsortium/ITK/commit/928774748a))
- Update remote modules for 2022-11-24 ([dd3b4a2f9e](https://github.com/InsightSoftwareConsortium/ITK/commit/dd3b4a2f9e))
- Bump Azure Testing ExternalDataVersion to 5.3.0 ([07c91df71e](https://github.com/InsightSoftwareConsortium/ITK/commit/07c91df71e))

#### Documentation Updates

- Include links to updated remote modules in release notes ([81143d0775](https://github.com/InsightSoftwareConsortium/ITK/commit/81143d0775))
- Add links to previous versions in the Doxygen footer ([205ce51d2a](https://github.com/InsightSoftwareConsortium/ITK/commit/205ce51d2a))
- Improve doxygen footer formatting ([cf19aba2fa](https://github.com/InsightSoftwareConsortium/ITK/commit/cf19aba2fa))
- Add archives of 5.3 release notes ([5a7dcb1a02](https://github.com/InsightSoftwareConsortium/ITK/commit/5a7dcb1a02))
- Add link to 5.3 documentation in Doxygen footer ([542ae7b3d5](https://github.com/InsightSoftwareConsortium/ITK/commit/542ae7b3d5))
- Release process updates for 5.3.0 ([d76a1833a7](https://github.com/InsightSoftwareConsortium/ITK/commit/d76a1833a7))
- Add emojis to the first-interaction message ([ba054649ac](https://github.com/InsightSoftwareConsortium/ITK/commit/ba054649ac))
- Consolidate release notes inte Documentation/Releases ([5093d831ba](https://github.com/InsightSoftwareConsortium/ITK/commit/5093d831ba))
- Add contributing graph to CONTRIBUTING.md ([366ed3edc9](https://github.com/InsightSoftwareConsortium/ITK/commit/366ed3edc9))

#### Platform Fixes

- Add CastXML binary for Windows 11 ([e30096df7d](https://github.com/InsightSoftwareConsortium/ITK/commit/e30096df7d))
- zlib crc32_braid.c cast to smaller integer type ([0cd5391417](https://github.com/InsightSoftwareConsortium/ITK/commit/0cd5391417))
- Use newer CastXML binary for latest versions of Windows 10 ([364c27a393](https://github.com/InsightSoftwareConsortium/ITK/commit/364c27a393))
- Use pre-built swig for Linux/x86_64 ([bfc7f7b800](https://github.com/InsightSoftwareConsortium/ITK/commit/bfc7f7b800))
- Replace numpy.bool8 with np.bool_ ([63fd7e7a89](https://github.com/InsightSoftwareConsortium/ITK/commit/63fd7e7a89))

#### Bug Fixes

- pointset_type_from_wasm_type return a PointSet ([2f2e888612](https://github.com/InsightSoftwareConsortium/ITK/commit/2f2e888612))
- transform_to_displacement_field_filter type inference ([f13070288b](https://github.com/InsightSoftwareConsortium/ITK/commit/f13070288b))
- SetRegions in image_from_dict ([504f06f9e3](https://github.com/InsightSoftwareConsortium/ITK/commit/504f06f9e3))
- Support heterogeneous inputs/outputs for PyImageFilter ([eee6f8ac9b](https://github.com/InsightSoftwareConsortium/ITK/commit/eee6f8ac9b))
- Add other SWIG sources download URLs ([0e3a056e89](https://github.com/InsightSoftwareConsortium/ITK/commit/0e3a056e89))
- wasm_type_from_image_type for VariableLengthVector ([99f16a0dfe](https://github.com/InsightSoftwareConsortium/ITK/commit/99f16a0dfe))


### Max Aehle (3):

#### Platform Fixes

- Declare ZLIB_SYMBOL_PREFIX as cache variable ([f935f4c666](https://github.com/InsightSoftwareConsortium/ITK/commit/f935f4c666))
- Perform TEST_LFS_WORKS in every CMake run ([1d056d2f19](https://github.com/InsightSoftwareConsortium/ITK/commit/1d056d2f19))
- Decide early whether to use -msse2 ([52732a065e](https://github.com/InsightSoftwareConsortium/ITK/commit/52732a065e))


### Mihail Isakov (4):

#### Bug Fixes

- ITK_COMPILER_SUPPORTS_SSE2_64 incorrectly set for 32-bit x86 ([6c800e4640](https://github.com/InsightSoftwareConsortium/ITK/commit/6c800e4640))
- ITK_COMPILER_SUPPORTS_SSE2_64 incorrectly set for 32-bit x86 ([37c107436f](https://github.com/InsightSoftwareConsortium/ITK/commit/37c107436f))
- fixed valgrind defect in FreeSurfer mesh test ([336cf57efc](https://github.com/InsightSoftwareConsortium/ITK/commit/336cf57efc))
- Added missing semicolon in FastMarchingUpwindGradientTest ([4ca68daba0](https://github.com/InsightSoftwareConsortium/ITK/commit/4ca68daba0))


### NIFTI Upstream (2):

#### Miscellaneous Changes

- nifti 2023-03-29 (2acc4449) ([5e40191542](https://github.com/InsightSoftwareConsortium/ITK/commit/5e40191542))
- nifti 2023-05-22 (c135c3d4) ([8a04aa2070](https://github.com/InsightSoftwareConsortium/ITK/commit/8a04aa2070))


### Nick Tustison (3):

#### Enhancements

- refactor LaplacianSharpeningImageFilter (#4052) ([c93f06865e](https://github.com/InsightSoftwareConsortium/ITK/commit/c93f06865e))

#### Bug Fixes

- Need to initialize both seeds. ([8e1b8259f0](https://github.com/InsightSoftwareConsortium/ITK/commit/8e1b8259f0))
- Need to initialize both seeds. ([490b5c6069](https://github.com/InsightSoftwareConsortium/ITK/commit/490b5c6069))


### Niels Dekker (143):

#### Enhancements

- Mention the floating point type on a NumberToString expect failure ([43d3e848a6](https://github.com/InsightSoftwareConsortium/ITK/commit/43d3e848a6))
- Add GTest `FixedArray.ValueInitialized` ([6bb951c394](https://github.com/InsightSoftwareConsortium/ITK/commit/6bb951c394))
- Add C++ script to add in-class `{}` member initializers to ITK ([ef40e98381](https://github.com/InsightSoftwareConsortium/ITK/commit/ef40e98381))
- Upgrade ITK from C++14 to C++17 ([513507e4c7](https://github.com/InsightSoftwareConsortium/ITK/commit/513507e4c7))
- Test `bool` return value of TransformPhysicalPoint member functions ([1d03697690](https://github.com/InsightSoftwareConsortium/ITK/commit/1d03697690))
- Add C++17 `[[nodiscard]]` to Image "Transform" member functions ([63d43546a3](https://github.com/InsightSoftwareConsortium/ITK/commit/63d43546a3))
- Add C++17 CTAD deduction guides to `ImageScanlineIterator` ([7f934595eb](https://github.com/InsightSoftwareConsortium/ITK/commit/7f934595eb))
- CTAD guide `ImageScanlineConstIterator` support non-const image ([a6c37421f6](https://github.com/InsightSoftwareConsortium/ITK/commit/a6c37421f6))

#### Performance Improvements

- Declare TriangleCell::m_PointIds std::array instead of std::vector ([8aa679af1b](https://github.com/InsightSoftwareConsortium/ITK/commit/8aa679af1b))
- SLICImageFilter use faster TransformPhysicalPointToContinuousIndex ([d0109630dc](https://github.com/InsightSoftwareConsortium/ITK/commit/d0109630dc))
- Use faster TransformPhysicalPointToIndex/ContinuousIndex in Python ([87b48e49be](https://github.com/InsightSoftwareConsortium/ITK/commit/87b48e49be))
- Use `std::move` inside `itkSetMacro`, declare parameter non-const ([e5011aeb76](https://github.com/InsightSoftwareConsortium/ITK/commit/e5011aeb76))

#### Documentation Updates

- Mention that Utilities/Maintenance is excluded from CI triggers ([4728e7c436](https://github.com/InsightSoftwareConsortium/ITK/commit/4728e7c436))
- Add note to Image "Transform" member functions that return `bool` ([dc43b54be6](https://github.com/InsightSoftwareConsortium/ITK/commit/dc43b54be6))
- Add note constructors on class template argument deduction (CTAD) ([e421dac080](https://github.com/InsightSoftwareConsortium/ITK/commit/e421dac080))
- ShapedImageNeighborhoodRange iterator types follow Rule of Zero ([a024dfa34d](https://github.com/InsightSoftwareConsortium/ITK/commit/a024dfa34d))

#### Platform Fixes

- Fix MSVC warning C26495: `m_MetaDataObjectValue` uninitialized ([0dc5b66bd3](https://github.com/InsightSoftwareConsortium/ITK/commit/0dc5b66bd3))
- Fix MSVC warning C26495: `ZwQuerySystemInformation` uninitialized ([a1f40a77ca](https://github.com/InsightSoftwareConsortium/ITK/commit/a1f40a77ca))
- Fix MSVC `/permissive-` error C2516: ... is not a legal base class ([687f51e642](https://github.com/InsightSoftwareConsortium/ITK/commit/687f51e642))
- Do #include "itkConfigure.h" before using `ITK_USE_WIN32_THREADS` ([15ce483e5b](https://github.com/InsightSoftwareConsortium/ITK/commit/15ce483e5b))
- Fix MSVC warning C26495: `m_PositionIndex` uninitialized ([de142a0dbd](https://github.com/InsightSoftwareConsortium/ITK/commit/de142a0dbd))
- Make ITK implementation `make_unique_for_overwrite` unconditional ([a0aecfe0a7](https://github.com/InsightSoftwareConsortium/ITK/commit/a0aecfe0a7))
- Make ITK implementation `bit_cast` unconditional ([f187319530](https://github.com/InsightSoftwareConsortium/ITK/commit/f187319530))
- MSVC Code Analysis warning, "redundant code" in ImageIORegionGTest ([3d14c44629](https://github.com/InsightSoftwareConsortium/ITK/commit/3d14c44629))
- Exclude Utilities/Maintenance and documentation files from AZP CI ([eb5ca2585a](https://github.com/InsightSoftwareConsortium/ITK/commit/eb5ca2585a))
- Fix warning: unused variable 'compensatedSum' [-Wunused-variable] ([a51d204c49](https://github.com/InsightSoftwareConsortium/ITK/commit/a51d204c49))
- Move RayCastHelper from unnamed namespace to private class section ([208902e16a](https://github.com/InsightSoftwareConsortium/ITK/commit/208902e16a))
- Place `#define _SILENCE_..._DEPRECATION_WARNING` before `#include` ([cd0ff94e4f](https://github.com/InsightSoftwareConsortium/ITK/commit/cd0ff94e4f))
- Declare `operator-(const Self &)` member functions const ([8bd60993a7](https://github.com/InsightSoftwareConsortium/ITK/commit/8bd60993a7))
- Declare `operator<(const SliceIterator &)` member function const ([f60dc98cef](https://github.com/InsightSoftwareConsortium/ITK/commit/f60dc98cef))
- Declare `operator*` and `operator/` of VariableSizeMatrix const ([212c0e1cc4](https://github.com/InsightSoftwareConsortium/ITK/commit/212c0e1cc4))
- Replace result_of_t with C++17 invoke_result_t in ThreadPool ([75350f1f81](https://github.com/InsightSoftwareConsortium/ITK/commit/75350f1f81))
- Work around GCC < 10 bug, "no user-provided default constructor" ([79faea587c](https://github.com/InsightSoftwareConsortium/ITK/commit/79faea587c))
- Require compiler versions that support C++17 ([45407f3560](https://github.com/InsightSoftwareConsortium/ITK/commit/45407f3560))
- Fix `[[nodiscard]]` warnings in PolyLineParametricPath1 example ([6b2d4701bb](https://github.com/InsightSoftwareConsortium/ITK/commit/6b2d4701bb))
- Remove CTAD because of clang "error: member reference base" bug ([2f30e35b4f](https://github.com/InsightSoftwareConsortium/ITK/commit/2f30e35b4f))
- Remove use of C++17 CTAD from `lock_guard` variable declarations ([6958f05338](https://github.com/InsightSoftwareConsortium/ITK/commit/6958f05338))
- Add CTAD deduction guides to ImageBufferRange and ImageRegionRange ([639e8ff31a](https://github.com/InsightSoftwareConsortium/ITK/commit/639e8ff31a))
- Fix TransformPhysicalPointToIndex `nodiscard` warnings ([49ece7f608](https://github.com/InsightSoftwareConsortium/ITK/commit/49ece7f608))
- Fix TransformPhysicalPointToContinuousIndex `nodiscard` warnings ([7cda5badd0](https://github.com/InsightSoftwareConsortium/ITK/commit/7cda5badd0))
- Fix Nonunit/Review/test error: ContinuousIndexType is not a member ([fd2b6d6d72](https://github.com/InsightSoftwareConsortium/ITK/commit/fd2b6d6d72))
- Fix Nonunit/Review/test error: 'cindex': undeclared identifier ([1a1281ce03](https://github.com/InsightSoftwareConsortium/ITK/commit/1a1281ce03))
- Fix BinomialBlurImageFilter error, num_reps undeclared identifier ([1e3e606e83](https://github.com/InsightSoftwareConsortium/ITK/commit/1e3e606e83))
- Add `template` to TransformPhysicalPointToContinuousIndex in tests ([1f8c0f8128](https://github.com/InsightSoftwareConsortium/ITK/commit/1f8c0f8128))
- Enable warning on C++17 class template argument deduction (CTAD) ([d26c07ea57](https://github.com/InsightSoftwareConsortium/ITK/commit/d26c07ea57))
- Disable KWStyle check "error: namespace is wrong" on *.cxx files ([cce48b3cfa](https://github.com/InsightSoftwareConsortium/ITK/commit/cce48b3cfa))
- Rule of Zero, SFINAE ImageBufferRange, ImageRegionRange iterators ([19079c8bc7](https://github.com/InsightSoftwareConsortium/ITK/commit/19079c8bc7))

#### Style Changes

- Remove `diff` variables from ConvertPixelBuffer (warning C26451) ([288d87b89f](https://github.com/InsightSoftwareConsortium/ITK/commit/288d87b89f))
- Replace C-style cast (size_t) ConvertPixelBuffer with static_cast ([622fb69f84](https://github.com/InsightSoftwareConsortium/ITK/commit/622fb69f84))
- NumberToStringGTest: add #include, avoid narrowing conversion pow ([d5beb7a657](https://github.com/InsightSoftwareConsortium/ITK/commit/d5beb7a657))
- Add `const` to `inputData` parameters of `ConvertPixelBuffer` ([c28be8ba00](https://github.com/InsightSoftwareConsortium/ITK/commit/c28be8ba00))
- Use range-based `for` loops to iterate over `faceList` variables ([2de7e24b0b](https://github.com/InsightSoftwareConsortium/ITK/commit/2de7e24b0b))
- Do not suppress clang "-Wfloat-equal" inside `itkSetObjectMacro` ([10f6e6bc5e](https://github.com/InsightSoftwareConsortium/ITK/commit/10f6e6bc5e))
- Declare m_PointIds of Cell types std::array instead of C-array ([09e5548a07](https://github.com/InsightSoftwareConsortium/ITK/commit/09e5548a07))
- Add `const` to `inputData` of `DoConvertBuffer` member functions ([f8dc373884](https://github.com/InsightSoftwareConsortium/ITK/commit/f8dc373884))
- Initialize `faceList` directly by ImageBoundaryFacesCalculator ([18a672368d](https://github.com/InsightSoftwareConsortium/ITK/commit/18a672368d))
- Replace `for` loops SetPointIds(PointIdConstIterator) by copy_n ([e019779ba5](https://github.com/InsightSoftwareConsortium/ITK/commit/e019779ba5))
- Add missing `<< indent` insertions to `PrintSelf` implementations ([48c6ed7697](https://github.com/InsightSoftwareConsortium/ITK/commit/48c6ed7697))
- Replace `*x.begin()` with `x.front()` ([c8103b4e55](https://github.com/InsightSoftwareConsortium/ITK/commit/c8103b4e55))
- Replace `*x.begin()` with `x.front()` in DecisionRule test ([eb26094080](https://github.com/InsightSoftwareConsortium/ITK/commit/eb26094080))
- Chain consecutive insertions (`<<`) to the same output stream ([67ca856a8c](https://github.com/InsightSoftwareConsortium/ITK/commit/67ca856a8c))
- Make data of PixelReferenceWrapper (in ImageBufferRange) private ([ca965f3300](https://github.com/InsightSoftwareConsortium/ITK/commit/ca965f3300))
- In-class default-member-initialization in Command derived classes ([76dad9f321](https://github.com/InsightSoftwareConsortium/ITK/commit/76dad9f321))
- In-class default-member-initialization in VTKImageImport ([a0488b99f3](https://github.com/InsightSoftwareConsortium/ITK/commit/a0488b99f3))
- Move ObjectFactorBase `OverrideInformation` to unnamed namespace ([cdd5408631](https://github.com/InsightSoftwareConsortium/ITK/commit/cdd5408631))
- Add in-class `{}` member initializers to objects created by New() ([5e2c49f9eb](https://github.com/InsightSoftwareConsortium/ITK/commit/5e2c49f9eb))
- Add missing braces to the substatements of `if` statements ([8d12282fd7](https://github.com/InsightSoftwareConsortium/ITK/commit/8d12282fd7))
- Add missing braces to the substatements of `for` loops ([57624fda9a](https://github.com/InsightSoftwareConsortium/ITK/commit/57624fda9a))
- Default default-constructors of class templates in Core/Common ([c2c67ac48c](https://github.com/InsightSoftwareConsortium/ITK/commit/c2c67ac48c))
- Replace double quotes around a space character with single quotes ([e8773472dd](https://github.com/InsightSoftwareConsortium/ITK/commit/e8773472dd))
- Default default-constructor ImageConstIteratorWithIndex/OnlyIndex ([ca0021b93c](https://github.com/InsightSoftwareConsortium/ITK/commit/ca0021b93c))
- Replace double quotes around single characters with single quotes ([ea231d6002](https://github.com/InsightSoftwareConsortium/ITK/commit/ea231d6002))
- Replace double quotes around double quote with single quotes ([ffa592d124](https://github.com/InsightSoftwareConsortium/ITK/commit/ffa592d124))
- Replace double quotes around escaped chars with single quotes ([3ec88007fc](https://github.com/InsightSoftwareConsortium/ITK/commit/3ec88007fc))
- Add in-class `{}` initializers to classes with itkSimpleNewMacro ([21f500a807](https://github.com/InsightSoftwareConsortium/ITK/commit/21f500a807))
- Use `lock_guard<mutex>` in Logger classes and GPUImageDataManager ([a744aef227](https://github.com/InsightSoftwareConsortium/ITK/commit/a744aef227))
- Use range-based `for` in MultipleLogOutput and LoggerManager ([4bd1e7a10a](https://github.com/InsightSoftwareConsortium/ITK/commit/4bd1e7a10a))
- Remove unnecessary private type aliases from Log classes ([b91931b381](https://github.com/InsightSoftwareConsortium/ITK/commit/b91931b381))
- Add in-class `{}` initializers to classes with virtual functions ([5c97b7605e](https://github.com/InsightSoftwareConsortium/ITK/commit/5c97b7605e))
- Add in-class `{}` initializers to classes with override = default ([5635b75d8f](https://github.com/InsightSoftwareConsortium/ITK/commit/5635b75d8f))
- Default default-constructor of ConstantBoundaryCondition ([67ec6584a3](https://github.com/InsightSoftwareConsortium/ITK/commit/67ec6584a3))
- Default default-constructor of CompensatedSummation ([015e93635b](https://github.com/InsightSoftwareConsortium/ITK/commit/015e93635b))
- Default default-constructor of SpatialFunction classes ([554c442430](https://github.com/InsightSoftwareConsortium/ITK/commit/554c442430))
- Default default-constructor of Image classes ([e596c0110f](https://github.com/InsightSoftwareConsortium/ITK/commit/e596c0110f))
- Default default-constructor of ImageRandom ConstIterator classes ([4e46cb6ef5](https://github.com/InsightSoftwareConsortium/ITK/commit/4e46cb6ef5))
- Default default-constructor of ConstNeighborhoodIterator ([6a1ccdccb6](https://github.com/InsightSoftwareConsortium/ITK/commit/6a1ccdccb6))
- Default default-constructor ImageVectorOptimizerParametersHelper ([6df203ab20](https://github.com/InsightSoftwareConsortium/ITK/commit/6df203ab20))
- Default default-constructor of ImportImageContainer and Filter ([b9e08130d0](https://github.com/InsightSoftwareConsortium/ITK/commit/b9e08130d0))
- Default default-constructor of MinimumMaximumImageCalculator ([791e2d462b](https://github.com/InsightSoftwareConsortium/ITK/commit/791e2d462b))
- Default default-constructor of ObjectStore and MemoryBlock ([a77ace2e26](https://github.com/InsightSoftwareConsortium/ITK/commit/a77ace2e26))
- Default default-constructor of PointSet ([e996dac415](https://github.com/InsightSoftwareConsortium/ITK/commit/e996dac415))
- Default default-constructor of PriorityQueueContainer ([ea237faaac](https://github.com/InsightSoftwareConsortium/ITK/commit/ea237faaac))
- Default default-constructor of RegularizedHeavisideStepFunction ([8aa993b758](https://github.com/InsightSoftwareConsortium/ITK/commit/8aa993b758))
- Default default-constructor of ThreadedImageRegionPartitioner ([992537a393](https://github.com/InsightSoftwareConsortium/ITK/commit/992537a393))
- Default default-constructor of VariableLengthVector ([74a55f9f8b](https://github.com/InsightSoftwareConsortium/ITK/commit/74a55f9f8b))
- Default default-constructor of Versor ([1b5da45dc7](https://github.com/InsightSoftwareConsortium/ITK/commit/1b5da45dc7))
- Add in-class `{}` member initializers to 3-letter data members ([ffe5eb6118](https://github.com/InsightSoftwareConsortium/ITK/commit/ffe5eb6118))
- Construct local variables by passing their arguments directly ([9e5dda5425](https://github.com/InsightSoftwareConsortium/ITK/commit/9e5dda5425))
- Add in-class `{}` member initializers having trailing comments ([8f233d177a](https://github.com/InsightSoftwareConsortium/ITK/commit/8f233d177a))
- Remove unnecessary iterator `GoToBegin()` calls from Filtering ([5a60ed00ad](https://github.com/InsightSoftwareConsortium/ITK/commit/5a60ed00ad))
- Remove duplicate `InLineIt.GoToBegin()` calls from Filtering ([dfbc85fd77](https://github.com/InsightSoftwareConsortium/ITK/commit/dfbc85fd77))
- Move ITK iterator declarations into init-statement of `for` loops ([d91d2b15b2](https://github.com/InsightSoftwareConsortium/ITK/commit/d91d2b15b2))
- Replace `T var = NumericTraits<T>::ZeroValue()` with `T var{}` ([42b0bfc077](https://github.com/InsightSoftwareConsortium/ITK/commit/42b0bfc077))
- Replace `while (!outIt.IsAtEnd())` with `for` loops, in Filtering ([31c713eb10](https://github.com/InsightSoftwareConsortium/ITK/commit/31c713eb10))
- Replace `T var = T()` with modern `T var{}` value-initialization ([6e3d4b3dc7](https://github.com/InsightSoftwareConsortium/ITK/commit/6e3d4b3dc7))
- Construct local variables by passing arguments directly (part 2) ([ef24b65d02](https://github.com/InsightSoftwareConsortium/ITK/commit/ef24b65d02))
- Reduce scope ResampleImageFilter::NonlinearThreadedGenerateData ([6b0d4b8337](https://github.com/InsightSoftwareConsortium/ITK/commit/6b0d4b8337))
- Default default-constructors MultiTransform, CompositeTransform ([8fbbcd5a6e](https://github.com/InsightSoftwareConsortium/ITK/commit/8fbbcd5a6e))
- Remove std::allocator from TestImportImageContainer (Common/test) ([55fb520252](https://github.com/InsightSoftwareConsortium/ITK/commit/55fb520252))
- Default default-constructor BSplineBaseTransform ([94f5a43e71](https://github.com/InsightSoftwareConsortium/ITK/commit/94f5a43e71))
- Simplify `BSplineBaseTransform::SetIdentity()` ([12df6f4d1c](https://github.com/InsightSoftwareConsortium/ITK/commit/12df6f4d1c))
- Declare local supportSize variables in BSplineTransform constexpr ([85dccb237f](https://github.com/InsightSoftwareConsortium/ITK/commit/85dccb237f))
- Use C++17 `_v` variable templates from `std` library type traits ([1a914b71bd](https://github.com/InsightSoftwareConsortium/ITK/commit/1a914b71bd))
- Remove pre-C++17 definition constexpr data member `SupportSize` ([014ea433aa](https://github.com/InsightSoftwareConsortium/ITK/commit/014ea433aa))
- Remove GCC 5.2 specific code from IntensityLinearTransform ([9e81d6d88d](https://github.com/InsightSoftwareConsortium/ITK/commit/9e81d6d88d))
- Use C++17 CTAD for `ImageBufferRange` ([acab22f238](https://github.com/InsightSoftwareConsortium/ITK/commit/acab22f238))
- Use C++17 CTAD for `ImageRegionRange` ([8ee4d9a410](https://github.com/InsightSoftwareConsortium/ITK/commit/8ee4d9a410))
- Replace `std::min` and `std::max` calls with C++17 `std::clamp` ([fa667ebe40](https://github.com/InsightSoftwareConsortium/ITK/commit/fa667ebe40))
- Use C++17 class template argument deduction (CTAD) for lock_guard ([3bfdc28908](https://github.com/InsightSoftwareConsortium/ITK/commit/3bfdc28908))
- Declare all lock_guard variables `const` ([357503ea5b](https://github.com/InsightSoftwareConsortium/ITK/commit/357503ea5b))
- Replace `sizeof(array) / sizeof(array[0])` with C++17 `std::size` ([feb86b8a81](https://github.com/InsightSoftwareConsortium/ITK/commit/feb86b8a81))
- Remove private ImageBufferRange ImageType alias, just use TImage ([136064885e](https://github.com/InsightSoftwareConsortium/ITK/commit/136064885e))
- Add `const` to TransformPhysicalPointToIndex results in "Review" ([7c4b827b44](https://github.com/InsightSoftwareConsortium/ITK/commit/7c4b827b44))
- Replace `T var = NumericTraits<T>::ZeroValue()` having whitespace ([b7bfef30a8](https://github.com/InsightSoftwareConsortium/ITK/commit/b7bfef30a8))
- Use TImage for CTAD supporting constructors ImageScanlineIterator ([1b14a34459](https://github.com/InsightSoftwareConsortium/ITK/commit/1b14a34459))
- Use C++17 CTAD for `ImageScanlineIterator` variable declarations ([e287d819f5](https://github.com/InsightSoftwareConsortium/ITK/commit/e287d819f5))
- Use C++17 "constexpr if" in `ImageRegionRange` ([2e1b8fffe0](https://github.com/InsightSoftwareConsortium/ITK/commit/2e1b8fffe0))
- Use C++17 "constexpr if" in `ImageHelper` ComputeIndex, Offset ([a980ae9faf](https://github.com/InsightSoftwareConsortium/ITK/commit/a980ae9faf))
- Replace `T var{ NumericTraits<T>::ZeroValue() }` with `T var{}` ([5ac803e290](https://github.com/InsightSoftwareConsortium/ITK/commit/5ac803e290))
- Remove local ImageScanlineIterator type aliases, using C++17 CTAD ([788e55897c](https://github.com/InsightSoftwareConsortium/ITK/commit/788e55897c))
- Default default-constructor SimpleDataObjectDecorator ([7a89717c1a](https://github.com/InsightSoftwareConsortium/ITK/commit/7a89717c1a))
- Replace ImageScanlineIterator `while` loops with `for` loops ([dbd3db552f](https://github.com/InsightSoftwareConsortium/ITK/commit/dbd3db552f))
- Move ImageScanlineIterator variable declarations into `for` loops ([869b22217d](https://github.com/InsightSoftwareConsortium/ITK/commit/869b22217d))
- Remove empty ResourceProbe legacy function GetSystemInformation() ([1ee4cd8e63](https://github.com/InsightSoftwareConsortium/ITK/commit/1ee4cd8e63))
- Use trailing return type instead of `typename` in "*.h" files ([c1628d5ff9](https://github.com/InsightSoftwareConsortium/ITK/commit/c1628d5ff9))
- More trailing return types for declarations containing "inline" ([b3f74ffbda](https://github.com/InsightSoftwareConsortium/ITK/commit/b3f74ffbda))
- Use trailing return types in multi-line function declarations ([f7fa2693f6](https://github.com/InsightSoftwareConsortium/ITK/commit/f7fa2693f6))
- Remove initial `<<` insertion from `itkExceptionMacro(<< "` calls ([89beb0447f](https://github.com/InsightSoftwareConsortium/ITK/commit/89beb0447f))
- Remove initial `<<` from `itkGenericExceptionMacro(<< "` calls ([1d0d43cc6d](https://github.com/InsightSoftwareConsortium/ITK/commit/1d0d43cc6d))
- Remove initial `<<` insertion from `itkDebugMacro(<< "` calls ([b52f423117](https://github.com/InsightSoftwareConsortium/ITK/commit/b52f423117))
- Remove initial `<<` insertion from `itkWarningMacro(<< "` calls ([c6fedbdb9a](https://github.com/InsightSoftwareConsortium/ITK/commit/c6fedbdb9a))
- Remove initial `<<` from `itkGenericOutputMacro(<< "` calls ([30ef8733c1](https://github.com/InsightSoftwareConsortium/ITK/commit/30ef8733c1))
- MultiTransform iterate over m_TransformQueue by range-based `for` ([da9ecbb513](https://github.com/InsightSoftwareConsortium/ITK/commit/da9ecbb513))


### Ningfei Li (1):

#### Platform Fixes

- Update itkExternal_Eigen3.cmake ([b8c2c94be4](https://github.com/InsightSoftwareConsortium/ITK/commit/b8c2c94be4))


### Noah Egnatis (1):

#### Platform Fixes

- gcc-13 compatability ([9a719a0d2f](https://github.com/InsightSoftwareConsortium/ITK/commit/9a719a0d2f))


### Pablo Hernandez-Cerdan (1):

#### Bug Fixes

- CMake, Eigen, pass CMAKE_SYSTEM_VERSION to Eigen ([c3bfb987b8](https://github.com/InsightSoftwareConsortium/ITK/commit/c3bfb987b8))


### Patrick Linnane (1):

#### Documentation Updates

- add Homebrew instructions ([dbce33bc68](https://github.com/InsightSoftwareConsortium/ITK/commit/dbce33bc68))


### Philip Cook (1):

#### Documentation Updates

- Remove outdated comment about sparse sampling ([8d6e787f2d](https://github.com/InsightSoftwareConsortium/ITK/commit/8d6e787f2d))


### Sean McBride (1):

#### Platform Fixes

- Get the Utilities/gdcmext folder from GDCM, it's needed to build now ([6adfd15ab9](https://github.com/InsightSoftwareConsortium/ITK/commit/6adfd15ab9))


### Simon Rit (3):

#### Platform Fixes

- Remove in-class {} member initializers of unique_ptr ([eac289d252](https://github.com/InsightSoftwareConsortium/ITK/commit/eac289d252))
- Remove in class init of SmartPointer of forward declaration ([f5f8367875](https://github.com/InsightSoftwareConsortium/ITK/commit/f5f8367875))

#### Bug Fixes

- Add missing Python string prefix in wrapping warning ([e7a9e9a48e](https://github.com/InsightSoftwareConsortium/ITK/commit/e7a9e9a48e))


### Stephen R. Aylward (3):

#### Enhancements

- Bump to TubeTKv1.3.4 and MinimalPathExtractionv1.2.4 ([065c5d8539](https://github.com/InsightSoftwareConsortium/ITK/commit/065c5d8539))
- Bump TubeTK to v1.3.5 and MinimalPathExtraction to v1.2.6 ([fe46f35f00](https://github.com/InsightSoftwareConsortium/ITK/commit/fe46f35f00))
- Add series_uid arg to imread() for dicom series selection ([9759b63e56](https://github.com/InsightSoftwareConsortium/ITK/commit/9759b63e56))


### Tom Birdsong (2):

#### Documentation Updates

- Update remote module docs for git hash instead of tag ([bdbbf82c9a](https://github.com/InsightSoftwareConsortium/ITK/commit/bdbbf82c9a))

#### Bug Fixes

- Use hashes instead of tags for remote modules ([fd386e4c29](https://github.com/InsightSoftwareConsortium/ITK/commit/fd386e4c29))


### VXL Maintainers (3):

#### Miscellaneous Changes

- VXL 2022-11-22 (4fd87cd5) ([24cb223828](https://github.com/InsightSoftwareConsortium/ITK/commit/24cb223828))
- VXL 2022-12-23 (8169cc76) ([5e4d60e58c](https://github.com/InsightSoftwareConsortium/ITK/commit/5e4d60e58c))
- VXL 2023-04-06 (4cfb87fc) ([37351308a3](https://github.com/InsightSoftwareConsortium/ITK/commit/37351308a3))


### Vaibhaw (1):

#### Bug Fixes

- Update UpdateRequiredITKVersionInRemoteModules.sh ([05d3490db4](https://github.com/InsightSoftwareConsortium/ITK/commit/05d3490db4))


### Vladimir S. FONOV (5):

#### Enhancements

- Added saving metadata in NRRD file in more data types ([94368f8ce3](https://github.com/InsightSoftwareConsortium/ITK/commit/94368f8ce3))
- Added permissive mode to NIFTI reader ([5cdf6ee6c9](https://github.com/InsightSoftwareConsortium/ITK/commit/5cdf6ee6c9))
- Made ITK_NIFTI_IO_SFORM_PERMISSIVE_DEFAULT OFF by default ([629f39c69c](https://github.com/InsightSoftwareConsortium/ITK/commit/629f39c69c))

#### Bug Fixes

- fixed the itkNiftiReadWriteDirectionSmallVoxelTest test ([9c6e5fd4a6](https://github.com/InsightSoftwareConsortium/ITK/commit/9c6e5fd4a6))
- orthogonalization should be done only on 3x3 submatrix ([815d0f0531](https://github.com/InsightSoftwareConsortium/ITK/commit/815d0f0531))


### Zlib-ng Upstream (2):

#### Miscellaneous Changes

- zlib-ng 2023-01-09 (43fd1418) ([e49bab8469](https://github.com/InsightSoftwareConsortium/ITK/commit/e49bab8469))
- zlib-ng 2023-02-08 (3e75a5c9) ([15cd2ffe33](https://github.com/InsightSoftwareConsortium/ITK/commit/15cd2ffe33))


### huangjxbq (1):

#### Bug Fixes

- Error converting from rotation axis and rotation angle to quaternion ([e2f0d9aa6a](https://github.com/InsightSoftwareConsortium/ITK/commit/e2f0d9aa6a))




ITK Sphinx Examples Changes Since v5.3.0
---------------------------------------------

### Dženan Zukić (1):

#### Enhancements

- Rename CreateAnother into CreateAnotherInstanceOfAFilter ([724543b2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/724543b2))


### Jon Haitz Legarreta Gorroño (4):

#### Enhancements

- Transition to `nbmake` to test notebooks ([f898fc5d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/f898fc5d))
- Fix workflow actions warnings linked to `Node.js` ([67c46c79](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/67c46c79))
- Bump `actions/upload-artifact` action to v3 ([0d24e60d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0d24e60d))

#### Style Changes

- Capitalize first letter for `Histogram` class name in index ([ccde3363](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ccde3363))


### Matt McCormick (17):

#### Enhancements

- Bump ITK version to 5.3.0 ([4078f3fb](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4078f3fb))
- Add "Edit this page" links ([875c43bd](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/875c43bd))
- Add DeformAVolumeWithAThinPlateSpline ([407addb2](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/407addb2))
- Add Python version of ExtractIsoSurface ([a312fd34](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a312fd34))
- Update to ITK 5.4 RC 01 ([0b4ca644](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/0b4ca644))

#### Documentation Updates

- Update README required CMake version ([c46ff9b9](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c46ff9b9))
- Add GitHub repository icon link ([c7fda565](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c7fda565))
- Browser-based editing is now available via GitHub ([4b25d62e](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/4b25d62e))

#### Platform Fixes

- Remove Superbuild zlib ([56fcffdf](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/56fcffdf))
- Enable IPython.sphinxext.ipython_console_highlighting ([a428ef2c](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/a428ef2c))
- Bump CI images to latest versions ([c0c0fc3d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/c0c0fc3d))
- Address ITK Windows warnings ([d68014af](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/d68014af))
- Fix traitlets version to 5.6.0 ([33888c1d](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/33888c1d))
- Bump minimum CMake version to 3.16.3 ([cc99d7aa](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/cc99d7aa))
- pandoc version for docs build ([3370d2ae](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/3370d2ae))

#### Bug Fixes

- Bump srvaroa/labeler to v0.9 ([57a8dea5](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/57a8dea5))
- Download HTML tarballs from GitHub Releases ([ec4ead33](https://github.com/InsightSoftwareConsortium/ITKSphinxExamples/commit/ec4ead33))




ITK Software Guide Changes Since v5.3.0
---------------------------------------------

### Dženan Zukić (1):

#### Documentation Updates

- Update supported compiler versions to C++17 ([cb8ba6e](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/cb8ba6e))


### Jon Haitz Legarreta Gorroño (9):

#### Enhancements

- Update Python version in GitHub Actions to 3.9 ([10275b3](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/10275b3))
- Fix workflow actions warnings linked to Node.js ([1999983](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1999983))
- Bump `actions/upload-artifact` action to v3 ([1cadef0](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/1cadef0))
- Update GitHub Actions Ubuntu environment version ([013c3b5](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/013c3b5))

#### Documentation Updates

- Avoid documenting ivar default values ([6a2861a](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6a2861a))
- Avoid using initialization lists in coding style snippets ([35a15c2](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/35a15c2))
- Use non-boolean, built-in type ivars to illustrate `PrintSelf` ([8f61111](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/8f61111))
- Do not encourage using empty comment lines ([278366c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/278366c))

#### Style Changes

- Finish coding style guideline item sentence with period ([14aee41](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/14aee41))


### Matt McCormick (2):

#### Enhancements

- Bump ITK to 5.3.0 ([83a3e23](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/83a3e23))
- Bump ITK Superbuild version to 5.4 RC 1 ([381c84c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/381c84c))


### Niels Dekker (4):

#### Documentation Updates

- Remove mistaken exception to data member initialization guideline ([6525a5c](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6525a5c))
- Adjust initialization rule for padding data, smart pointers, etc. ([6d5f5b5](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/6d5f5b5))
- Do not require using NumericTraits, replace ZeroValue() with `{}` ([b5410c5](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/b5410c5))
- Add "Integer Type Specifiers" section ([612adf5](https://github.com/InsightSoftwareConsortium/ITKSoftwareGuide/commit/612adf5))




Remote Module Changes Since v5.3.0
---------------------------------------------

## BSplineGradient:
### Tom Birdsong (6):

#### Enhancements

- Bump to ITK v5.3rc04.post3 ([16c1cc7](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/16c1cc7))
- Bump ITK workflow for v5.3rc04.post4 ([1bff249](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/1bff249))
- Bump ITK to v5.3 ([9281af8](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/9281af8))
- Use ITK reusable CI workflow ([5bd41c5](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/5bd41c5))

#### Bug Fixes

- Do not fail CI if archive is already removed ([bbf518e](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/bbf518e))

#### Miscellaneous Changes

- Bump ITKBSplineGradient to 0.2.10 ([3577ec7](https://github.com/InsightSoftwareConsortium/ITKBSplineGradient/commit/3577ec7))



## BoneMorphometry:
### Matt McCormick (1):

#### Enhancements

- Bump CI, package for ITK 5.3.0 ([cb826f5](https://github.com/InsightSoftwareConsortium/ITKBoneMorphometry/commit/cb826f5))



## Cleaver:
### Jean-Christophe Fillion-Robin (8):

#### Enhancements

- Update references to Cleaver repository to account for project rename ([ac2827b](https://github.com/SCIInstitute/ITKCleaver/commit/ac2827b))
- Download Cleaver source from upstream repository instead of a fork ([767985f](https://github.com/SCIInstitute/ITKCleaver/commit/767985f))
- Avoid triggering GitHub Actions workflow on both upstream and fork ([dd988f6](https://github.com/SCIInstitute/ITKCleaver/commit/dd988f6))
- Bump Cleaver version to integrate build-system updates ([c5ed2c4](https://github.com/SCIInstitute/ITKCleaver/commit/c5ed2c4))

#### Documentation Updates

- Fix license referenced in setup.py ([9cc174d](https://github.com/SCIInstitute/ITKCleaver/commit/9cc174d))
- Tweak list of classifiers associated with the package ([56f8592](https://github.com/SCIInstitute/ITKCleaver/commit/56f8592))

#### Platform Fixes

- Pin GitHub actions to full length commit SHA ([44ba697](https://github.com/SCIInstitute/ITKCleaver/commit/44ba697))
- Add Dependabot workflow to update GitHub Actions ([5e844c2](https://github.com/SCIInstitute/ITKCleaver/commit/5e844c2))


### Matt McCormick (26):

#### Enhancements

- Update for ITK 5.3.0 ([c1f76a0](https://github.com/SCIInstitute/ITKCleaver/commit/c1f76a0))
- Generate Linux ARM wheels ([fc650e6](https://github.com/SCIInstitute/ITKCleaver/commit/fc650e6))
- Add Emscripten Wasm build configuration ([f0d18e3](https://github.com/SCIInstitute/ITKCleaver/commit/f0d18e3))
- Add WebAssembly CI build ([336b154](https://github.com/SCIInstitute/ITKCleaver/commit/336b154))
- Add wasi build target ([9abbd0e](https://github.com/SCIInstitute/ITKCleaver/commit/9abbd0e))
- Bump itk-wasm version to 1.0.0-b.84 ([a915fac](https://github.com/SCIInstitute/ITKCleaver/commit/a915fac))
- Update JS package name to @itk-wasm/cleaver ([56c1be5](https://github.com/SCIInstitute/ITKCleaver/commit/56c1be5))
- Bump itk-wasm to 1.0.0-b.85 ([5b251c8](https://github.com/SCIInstitute/ITKCleaver/commit/5b251c8))
- Add TypeScript build to CI ([5b494ed](https://github.com/SCIInstitute/ITKCleaver/commit/5b494ed))
- Add TypeScript sources ([e08e0a2](https://github.com/SCIInstitute/ITKCleaver/commit/e08e0a2))
- Add wasi debug build script target ([ff2a6ac](https://github.com/SCIInstitute/ITKCleaver/commit/ff2a6ac))
- Add WASI CTest configuration ([f9b1049](https://github.com/SCIInstitute/ITKCleaver/commit/f9b1049))
- Test Emscripten Node.js function ([a2c6773](https://github.com/SCIInstitute/ITKCleaver/commit/a2c6773))
- Add initial wasm browser testing ([d67b0d6](https://github.com/SCIInstitute/ITKCleaver/commit/d67b0d6))
- Test TypeScript bindings generation ([cb2c6c2](https://github.com/SCIInstitute/ITKCleaver/commit/cb2c6c2))

#### Documentation Updates

- Add wasm CI badge ([3af57cf](https://github.com/SCIInstitute/ITKCleaver/commit/3af57cf))
- Add NPM badge ([1d050de](https://github.com/SCIInstitute/ITKCleaver/commit/1d050de))

#### Platform Fixes

- Fix wasm CLI testing enablement ([895a8c3](https://github.com/SCIInstitute/ITKCleaver/commit/895a8c3))
- Export and link to cleaver's jsoncpp ([1584960](https://github.com/SCIInstitute/ITKCleaver/commit/1584960))
- Do not force enable BUILD_TESTING with WASI ([55a27bf](https://github.com/SCIInstitute/ITKCleaver/commit/55a27bf))

#### Bug Fixes

- Fix wasm CI yaml name ([713c9d7](https://github.com/SCIInstitute/ITKCleaver/commit/713c9d7))
- Fix input option identifier ([ff7099d](https://github.com/SCIInstitute/ITKCleaver/commit/ff7099d))
- Add image and mesh type names to wasm pipeline ([f9ba30b](https://github.com/SCIInstitute/ITKCleaver/commit/f9ba30b))
- Output triangle mesh should be a positional output ([46d152c](https://github.com/SCIInstitute/ITKCleaver/commit/46d152c))
- Set BUILD_TESTING on CMake CACHE ([ae88148](https://github.com/SCIInstitute/ITKCleaver/commit/ae88148))

#### Miscellaneous Changes

- build(WASI): Fix WASI build / execution ([0b9cbfc](https://github.com/SCIInstitute/ITKCleaver/commit/0b9cbfc))


### dependabot[bot] (5):

#### Platform Fixes

- Bump actions/checkout from 1.2.0 to 3.4.0 ([739160b](https://github.com/SCIInstitute/ITKCleaver/commit/739160b))
- Bump InsightSoftwareConsortium/ITKRemoteModuleBuildTestPackageAction ([0f0e2f9](https://github.com/SCIInstitute/ITKCleaver/commit/0f0e2f9))
- Bump actions/checkout from 3.4.0 to 3.5.0 ([ae3a644](https://github.com/SCIInstitute/ITKCleaver/commit/ae3a644))
- Bump actions/upload-artifact from 2 to 3 ([a45f652](https://github.com/SCIInstitute/ITKCleaver/commit/a45f652))
- Bump actions/checkout from 3.5.0 to 3.5.2 ([c0d7137](https://github.com/SCIInstitute/ITKCleaver/commit/c0d7137))



## Cuberille:
### Pranjal Sahu (2):

#### Enhancements

- Bump ITK to make Python packages compatible ([3b4cd1e](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/3b4cd1e))

#### Miscellaneous Changes

- Update package version to 2.6.0 ([859d3c4](https://github.com/InsightSoftwareConsortium/ITKCuberille/commit/859d3c4))



## CudaCommon:
### Simon Rit (10):

#### Enhancements

- Upgrade GitHub actions following ITKRemoteModuleBuildTestPackageAction ([f08c035](https://github.com/RTKConsortium/ITKCudaCommon/commit/f08c035))
- Use cmake-options variable in GitHub action for Python packaging ([7763f2c](https://github.com/RTKConsortium/ITKCudaCommon/commit/7763f2c))

#### Documentation Updates

- Changed radART to medPhoton in RTK consortium ([87c2643](https://github.com/RTKConsortium/ITKCudaCommon/commit/87c2643))
- Change mailing list links to CREATIS website ([e5dba4a](https://github.com/RTKConsortium/ITKCudaCommon/commit/e5dba4a))

#### Platform Fixes

- Set CMP0135 to remove DOWNLOAD_EXTRACT_TIMESTAMP config warning ([82ce410](https://github.com/RTKConsortium/ITKCudaCommon/commit/82ce410))
- Fix unsigned int warning on image dimension ([319222c](https://github.com/RTKConsortium/ITKCudaCommon/commit/319222c))
- Add missing ITK config include for external compilation ([36ea588](https://github.com/RTKConsortium/ITKCudaCommon/commit/36ea588))
- Fix unused parameters argc / argv warnings ([cc77281](https://github.com/RTKConsortium/ITKCudaCommon/commit/cc77281))

#### Bug Fixes

- Fix typo in wheel name ([5cb1187](https://github.com/RTKConsortium/ITKCudaCommon/commit/5cb1187))
- Remove CUDA libraries from the CI generated Python packages ([cefcfbb](https://github.com/RTKConsortium/ITKCudaCommon/commit/cefcfbb))



## FPFH:
### Pranjal Sahu (6):

#### Miscellaneous Changes

- Update description in setup.py ([4c58393](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/4c58393))
- Update github link in setup.py ([6c14c8d](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/6c14c8d))
- Update the actions URL in setup.py ([7889e74](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/7889e74))
- WIP: Removing not required dependencies ([f7bebe4](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/f7bebe4))
- Update ITK tag to 5.3 ([b0d5a70](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/b0d5a70))
- Bump tag to 0.1.1 ([b89bd09](https://github.com/InsightSoftwareConsortium/ITKFPFH/commit/b89bd09))



## GenericLabelInterpolator:
### Matt McCormick (3):

#### Enhancements

- Update CI configuration ([28398f8](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/28398f8))
- Bump Python package version, dependency ([411d3b1](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/411d3b1))
- Bump CI itk-git-tag to be closer to itk-wheel-tag ([f4de9ec](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/f4de9ec))


### Tom Birdsong (1):

#### Enhancements

- Bump CI workflow to ITK v5.3.0 ([a4383b2](https://github.com/InsightSoftwareConsortium/ITKGenericLabelInterpolator/commit/a4383b2))



## HASI:
### Matt McCormick (1):

#### Enhancements

- Update CI for reusable workflow, ITK 5.3.0 ([65ec726](https://github.com/KitwareMedical/HASI/commit/65ec726))


### Paul Elliott (36):

#### Enhancements

- add Vite and Lit frontend ([621287b](https://github.com/KitwareMedical/HASI/commit/621287b))
- add some nav buttons and router ([bd824b6](https://github.com/KitwareMedical/HASI/commit/bd824b6))
- router points to stub page components ([4eea911](https://github.com/KitwareMedical/HASI/commit/4eea911))
- toggle nav sidebar with button ([0b79596](https://github.com/KitwareMedical/HASI/commit/0b79596))
- add biomarker-picker ([04ac055](https://github.com/KitwareMedical/HASI/commit/04ac055))
- add table ([a9dd01f](https://github.com/KitwareMedical/HASI/commit/a9dd01f))
- add xstate machine ([e12f8c9](https://github.com/KitwareMedical/HASI/commit/e12f8c9))
- set PlotParameters on machine context with types ([7a4453c](https://github.com/KitwareMedical/HASI/commit/7a4453c))
- click grid row to select scan ([fc728f2](https://github.com/KitwareMedical/HASI/commit/fc728f2))
- row cell color changes on selecting scan ([e94335b](https://github.com/KitwareMedical/HASI/commit/e94335b))
- checkbox for row header, smaller width ([2600501](https://github.com/KitwareMedical/HASI/commit/2600501))
- add scan-views, connect to selectedScans ([33b9896](https://github.com/KitwareMedical/HASI/commit/33b9896))
- add SelectController for xstate ([d996faf](https://github.com/KitwareMedical/HASI/commit/d996faf))
- refactor SelectController to SelectState ([c7e4b27](https://github.com/KitwareMedical/HASI/commit/c7e4b27))
- can add and remove feature views ([322fcb5](https://github.com/KitwareMedical/HASI/commit/322fcb5))
- add scan selection model ([a426584](https://github.com/KitwareMedical/HASI/commit/a426584))
- color whole selected row ([308b6ef](https://github.com/KitwareMedical/HASI/commit/308b6ef))
- rename ScanSelections, use color in feature view ([18efa93](https://github.com/KitwareMedical/HASI/commit/18efa93))
- add focus row button to scan views ([3a6d25b](https://github.com/KitwareMedical/HASI/commit/3a6d25b))
- add 3 sections of shoelace details on population ([e993d5c](https://github.com/KitwareMedical/HASI/commit/e993d5c))
- style accordion headers, min height to sections ([8d8fac8](https://github.com/KitwareMedical/HASI/commit/8d8fac8))
- styled navbar ([31b9cb3](https://github.com/KitwareMedical/HASI/commit/31b9cb3))
- add chart placeholder images ([55a4781](https://github.com/KitwareMedical/HASI/commit/55a4781))
- add feature view image placeholder ([3d5a112](https://github.com/KitwareMedical/HASI/commit/3d5a112))
- add accordion layout component ([c90755e](https://github.com/KitwareMedical/HASI/commit/c90755e))
- add upload scans component ([86e3180](https://github.com/KitwareMedical/HASI/commit/86e3180))
- add upload process flow via button ([3b0001a](https://github.com/KitwareMedical/HASI/commit/3b0001a))
- add upload progress component: ([8169f38](https://github.com/KitwareMedical/HASI/commit/8169f38))

#### Platform Fixes

- build as website ([62edf44](https://github.com/KitwareMedical/HASI/commit/62edf44))

#### Bug Fixes

- use keys for feature views for dom stability ([9172eee](https://github.com/KitwareMedical/HASI/commit/9172eee))
- fix repeated clicks of focus scan ID button ([904f7af](https://github.com/KitwareMedical/HASI/commit/904f7af))

#### Style Changes

- use single quotes ([def2ee6](https://github.com/KitwareMedical/HASI/commit/def2ee6))

#### Miscellaneous Changes

- fix: router works in Firefox and full page row clickable ([72009be](https://github.com/KitwareMedical/HASI/commit/72009be))
- FIX: remove top level await ([c6771dc](https://github.com/KitwareMedical/HASI/commit/c6771dc))
- FIX: update DataGrid on menu close ([cd6841e](https://github.com/KitwareMedical/HASI/commit/cd6841e))
- WIP ENH: stash machine state on url ([329f860](https://github.com/KitwareMedical/HASI/commit/329f860))


### Tom Birdsong (1):

#### Platform Fixes

- Build ITK module dependencies in CI reusable workflow ([5ee74fd](https://github.com/KitwareMedical/HASI/commit/5ee74fd))



## HigherOrderAccurateGradient:
### Jon Haitz Legarreta Gorroño (1):

#### Documentation Updates

- Fix module description ([31e65e4](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/31e65e4))


### Tom Birdsong (3):

#### Enhancements

- Bump ITK to v5.3rc04.post3 and reference ITK CI workflow ([449f2b1](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/449f2b1))
- Bump ITK workflow to v5.3rc04.post4 ([6298ae1](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/6298ae1))
- Bump for ITK v5.3 ([b524294](https://github.com/InsightSoftwareConsortium/ITKHigherOrderAccurateGradient/commit/b524294))



## IOMeshSTL:
### Jon Haitz Legarreta Gorroño (2):

#### Enhancements

- Update linter checkout action to v3 ([7779c09](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL/commit/7779c09))

#### Platform Fixes

- Match CMake minimum required version to  ITK's ([0fdd038](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL/commit/0fdd038))


### Matt McCormick (1):

#### Enhancements

- Bump CI for ITK 5.3.0 ([cbe9793](https://github.com/InsightSoftwareConsortium/ITKIOMeshSTL/commit/cbe9793))



## IOMeshSWC:
### Matt McCormick (1):

#### Enhancements

- Update CI configuration for ITK 5.3.0 ([103e3c4](https://github.com/InsightSoftwareConsortium/ITKIOMeshSWC/commit/103e3c4))



## IOScanco:
### Matt McCormick (7):

#### Enhancements

- Update CI / packaging for ITK 5.3.0 ([18e17a2](https://github.com/KitwareMedical/ITKIOScanco/commit/18e17a2))
- Bump Notebook Actions runner to ubuntu-22.04 ([e67f066](https://github.com/KitwareMedical/ITKIOScanco/commit/e67f066))
- Update Notebook CI configuration ([fe56af4](https://github.com/KitwareMedical/ITKIOScanco/commit/fe56af4))

#### Documentation Updates

- Add notebook tests CI badge ([32700b2](https://github.com/KitwareMedical/ITKIOScanco/commit/32700b2))
- Update notebooks for new api, itkwidgets 1.0, pooch ([8a67a3b](https://github.com/KitwareMedical/ITKIOScanco/commit/8a67a3b))

#### Platform Fixes

- Use Python version for notebook tests ([92c567a](https://github.com/KitwareMedical/ITKIOScanco/commit/92c567a))
- Bump itk-ioscanco Notebook CI required version to 0.10.0 ([fdd18cc](https://github.com/KitwareMedical/ITKIOScanco/commit/fdd18cc))


### Michael Kuczynski (4):

#### Enhancements

- Adding get/set functions for missing header parameters ([2d22baa](https://github.com/KitwareMedical/ITKIOScanco/commit/2d22baa))

#### Miscellaneous Changes

- Updated tests for new get/set functions ([ce0727a](https://github.com/KitwareMedical/ITKIOScanco/commit/ce0727a))
- Updated formatting ([c468eba](https://github.com/KitwareMedical/ITKIOScanco/commit/c468eba))
- Updating format as line length was less than limit ([bc0d40a](https://github.com/KitwareMedical/ITKIOScanco/commit/bc0d40a))



## LabelErodeDilate:
### Bryn Lloyd (1):

#### Enhancements

- update to ITK 5.3.0 (#38) ([7e23b12](https://github.com/InsightSoftwareConsortium/ITKLabelErodeDilate/commit/7e23b12))



## MeshToPolyData:
### Matt McCormick (11):

#### Enhancements

- Bump CI itk-git-tag to v5.3rc04 ([12d3c3d](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/12d3c3d))
- Bump Python package version to 0.9.0 ([f26b80c](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/f26b80c))
- Bump itk-wasm to 1.0.0-b.71 ([a77ed2e](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/a77ed2e))
- Move wasm/ to top level ([4c3df79](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/4c3df79))
- Add .gitignore for wasm artifacts ([3b53d80](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/3b53d80))
- Bump itk-wasm to 1.0.0-b.73 ([0b98db4](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/0b98db4))
- Add wasi build step ([6af3e34](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/6af3e34))
- Build wasi in build script ([6972bd9](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/6972bd9))
- Add Wasm GitHub Action ([3b6d67e](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/3b6d67e))

#### Bug Fixes

- Build-test-package: resolve merge conflicts ([2558bd4](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/2558bd4))

#### Style Changes

- Rename mesh-to-polydata to mesh-to-poly-data ([58730f9](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/58730f9))


### Paul Elliott (1):

#### Enhancements

- Add package with itk-wasm build ([c183978](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/c183978))


### Pranjal Sahu (3):

#### Enhancements

- Adding changes for itk::PolyLineCell ([5586157](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/5586157))
- Adding test for itk::PolyLineCell ([d56e249](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/d56e249))
- Adding Python test for itk::PolyLineCell conversion ([374bea6](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/374bea6))


### Tom Birdsong (6):

#### Enhancements

- Bump for ITK v5.3rc04.post3 ([a5f1897](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/a5f1897))
- Bump ITK workflow to v5.3rc04.post4 ([d46d656](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/d46d656))
- Bump for ITK v5.3 ([3ad8f08](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/3ad8f08))
- Bump CI workflow for ARM builds and wheel validation ([496096f](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/496096f))
- Enable notebook CI check ([e597c84](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/e597c84))

#### Bug Fixes

- Example notebook fixups ([f963101](https://github.com/InsightSoftwareConsortium/ITKMeshToPolyData/commit/f963101))



## MinimalPathExtraction:
### Dženan Zukić (1):

#### Platform Fixes

- Fix discarding return value warning introduced by ITK 5.4 ([35dd8e8](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/35dd8e8))


### Matt McCormick (1):

#### Enhancements

- Bump Python package version to 1.2.6 ([592d965](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/592d965))


### Stephen R. Aylward (3):

#### Enhancements

- Bump CI and setup to ITKv5.3.0 (#96) ([458796e](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/458796e))
- Release 1.2.4 with ITK v5.3.0 support ([71813fa](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/71813fa))
- Update python builds to 1.2.5 ([426576c](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/426576c))


### Tom Birdsong (1):

#### Enhancements

- Use ITK reusable CI workflow ([bd45bf0](https://github.com/InsightSoftwareConsortium/ITKMinimalPathExtraction/commit/bd45bf0))



## Montage:
### Dženan Zukić (8):

#### Enhancements

- Require less components to be built for examples ([76b2286](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/76b2286))

#### Platform Fixes

- Fix compile error of MontageImageCompareCommand ([da7649e](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/da7649e))
- Fix discarding return value warning introduced by ITK 5.4 ([d8c9a3f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d8c9a3f))
- Update minimum CMake version from 3.10.2 to 3.16.3 ([2789c34](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/2789c34))

#### Bug Fixes

- erase confidence together with the translation candidate ([4f501a8](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/4f501a8))
- Avoid appearance of NaN values ([b7ab26a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b7ab26a))

#### Style Changes

- Replace SFINAE selection by constexpr if ([33b6b74](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/33b6b74))
- Use trailing return type instead of typename + dependent type ([b91741f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/b91741f))


### Matt McCormick (2):

#### Enhancements

- Bump Python package version to 0.8.1 ([d7f849f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/d7f849f))

#### Bug Fixes

- Do not wrap duplicate complex double dependencies ([ce1c9f0](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/ce1c9f0))


### Tom Birdsong (4):

#### Enhancements

- Bump for ITK v5.3 ([fc64c6f](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/fc64c6f))
- Port montage notebook example ([7015e4a](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/7015e4a))
- Add CI notebook testing ([777a669](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/777a669))

#### Bug Fixes

- Update `TileMergeImageFilter` signature in example script ([bfe0cac](https://github.com/InsightSoftwareConsortium/ITKMontage/commit/bfe0cac))



## MorphologicalContourInterpolation:
### Dženan Zukić (2):

#### Enhancements

- Remove test parallelism to prevent non-deterministic test failures ([a31fbf7](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/a31fbf7))

#### Style Changes

- Use trailing return type instead of typename + dependent type ([0a057d7](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/0a057d7))


### Tom Birdsong (1):

#### Enhancements

- Bump to ITK v5.3.0 ([ac69d71](https://github.com/KitwareMedical/ITKMorphologicalContourInterpolation/commit/ac69d71))



## ParabolicMorphology:
### Matt McCormick (8):

#### Enhancements

- Update to ITK 5.3.0 ([45eff88](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/45eff88))
- Add notebook testing CI configuration ([2c3b2ea](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/2c3b2ea))
- Update to consolidated notebook testing configuration ([847e1ec](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/847e1ec))

#### Documentation Updates

- Update notebook to use itkwidgets 1.X, pooch ([bae9eb6](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/bae9eb6))
- Add distance map example ([34da76a](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/34da76a))
- Update notebook screenshots ([cd2b6c4](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/cd2b6c4))

#### Platform Fixes

- Update build-test-package GitHub Action ([32c7ca7](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/32c7ca7))

#### Bug Fixes

- Distance filters should only be wrapped for real outputs ([c9516f8](https://github.com/InsightSoftwareConsortium/ITKParabolicMorphology/commit/c9516f8))



## RANSAC:
### Matt McCormick (1):

#### Documentation Updates

- Add Python installation, IJ link ([e3ce1ff](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/e3ce1ff))


### Pranjal Sahu (13):

#### Miscellaneous Changes

- Update URL and description in setup.py ([b1c5e66](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/b1c5e66))
- Update Badge URLs in README ([2886c2b](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/2886c2b))
- Update ITK tag to 5.3 ([198f5e9](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/198f5e9))
- Bump tag to 0.1.1 ([6b0417d](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/6b0417d))
- Remove itkPoint dimension 6 wrapping ([23cf7a3](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/23cf7a3))
- Add support for VersorRigid3D Transform ([acccf2c](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/acccf2c))
- Update Tag to 0.1.2 ([20b38a6](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/20b38a6))
- Add early prune check for transformed feature points ([58aebfd](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/58aebfd))
- Check for RMSE when inlier count is same ([07d57c5](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/07d57c5))
- Add Set/Get for additional corresspondence checks ([f6b16a2](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/f6b16a2))
- Upgrade Version to 0.1.3 with additional checks ([4259b25](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/4259b25))
- Change delta to Euclidean distance ([04db366](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/04db366))
- Upgrade ITKRANSAC to 0.1.4 ([5d6bdf7](https://github.com/InsightSoftwareConsortium/ITKRANSAC/commit/5d6bdf7))



## RLEImage:
### Dženan Zukić (1):

#### Style Changes

- Use trailing return type instead of typename + dependent type ([901e40f](https://github.com/KitwareMedical/ITKRLEImage/commit/901e40f))


### Tom Birdsong (3):

#### Enhancements

- Bump to ITK v5.3.0 ([fe2bb30](https://github.com/KitwareMedical/ITKRLEImage/commit/fe2bb30))

#### Platform Fixes

- Remove Python CI workflow ([070fef6](https://github.com/KitwareMedical/ITKRLEImage/commit/070fef6))

#### Bug Fixes

- Remove Linux notebook check from CI ([310b579](https://github.com/KitwareMedical/ITKRLEImage/commit/310b579))



## RTK:
### Antoine Robert (2):

#### Enhancements

- Change default value of OSEM regularization to O ([5f01b347](https://github.com/RTKConsortium/RTK/commit/5f01b347))

#### Bug Fixes

- Fix OSEM image quality test ([c92dde36](https://github.com/RTKConsortium/RTK/commit/c92dde36))


### LAURENDEAU Matthieu (2):

#### Enhancements

- Add MaskCollimationImageFilter Python wrapping ([c6fa8732](https://github.com/RTKConsortium/RTK/commit/c6fa8732))
- Add option to set the rotation axis in MaskCollimationImageFilter ([688e9ab8](https://github.com/RTKConsortium/RTK/commit/688e9ab8))


### Shengpeng YU (1):

#### Bug Fixes

- Fix CUDA/CPU inconsistency in DisplacedDetectorImageFilter ([e8299590](https://github.com/RTKConsortium/RTK/commit/e8299590))


### Simon Rit (30):

#### Enhancements

- Bump for ITK v5.3 release ([c87911c4](https://github.com/RTKConsortium/RTK/commit/c87911c4))
- Reduce downloads in self-hosted Github runners ([038ad5d4](https://github.com/RTKConsortium/RTK/commit/038ad5d4))
- Upgrade GitHub actions to checkout@v3 ([a924bb73](https://github.com/RTKConsortium/RTK/commit/a924bb73))
- Update for ITKPythonPackage script updates ([b3145e37](https://github.com/RTKConsortium/RTK/commit/b3145e37))
- Account for yaw rotation in ImagingRing geometry ([c7206715](https://github.com/RTKConsortium/RTK/commit/c7206715))
- Add OptiTrack option to Ora geometry ([ab572956](https://github.com/RTKConsortium/RTK/commit/ab572956))
- Add warning when Ora projection is not valid ([36982471](https://github.com/RTKConsortium/RTK/commit/36982471))
- Add tests for yaw and optitrack information in ImagingRing files ([40a2fc61](https://github.com/RTKConsortium/RTK/commit/40a2fc61))
- Make tolerances on angle verification parametrizable ([fac3f646](https://github.com/RTKConsortium/RTK/commit/fac3f646))
- Allow more than one projection in Weidinger's spectrum ([4707a3ce](https://github.com/RTKConsortium/RTK/commit/4707a3ce))
- Allow one step reconstruction with fast switching ([a1d91c41](https://github.com/RTKConsortium/RTK/commit/a1d91c41))
- Use ITKRemoteModuleBuildTestPackageAction and separate CUDA actions ([bcce053e](https://github.com/RTKConsortium/RTK/commit/bcce053e))
- Split MacOS Python package jobs in GitHub actions ([15e1aa85](https://github.com/RTKConsortium/RTK/commit/15e1aa85))
- Do not build C++ applications when generating Python packages ([d9724b45](https://github.com/RTKConsortium/RTK/commit/d9724b45))
- Remove ITKCudaCommon from the source tree ([138474a8](https://github.com/RTKConsortium/RTK/commit/138474a8))
- Add CudaCommon dependency to Cuda wheels ([9bc33997](https://github.com/RTKConsortium/RTK/commit/9bc33997))
- Import Cuda bin directory in the Windows environment for Cuda DLLs ([abe956fb](https://github.com/RTKConsortium/RTK/commit/abe956fb))

#### Documentation Updates

- Fix digraph for projection weights ([2c35fdf4](https://github.com/RTKConsortium/RTK/commit/2c35fdf4))
- Change mailing list links to CREATIS website ([23cb5598](https://github.com/RTKConsortium/RTK/commit/23cb5598))

#### Platform Fixes

- Fix unused variables and sign warnings in Ora geometry ([f26e5cf8](https://github.com/RTKConsortium/RTK/commit/f26e5cf8))
- Set CMake Policy 135 to NEW to suppress warnings in CMake 3.24 ([93bcf263](https://github.com/RTKConsortium/RTK/commit/93bcf263))
- Upgrade GitHub remote action to avoid MacOS warnings ([dd49c2f4](https://github.com/RTKConsortium/RTK/commit/dd49c2f4))
- Remove warnings due to re-use of Python wrapping names ([b357c903](https://github.com/RTKConsortium/RTK/commit/b357c903))
- Remove wrapping warning due to unwrapped geometry class ([e7de14d6](https://github.com/RTKConsortium/RTK/commit/e7de14d6))
- Fix [[nodiscard]] warnings of Image "Transform" member functions ([37b2cee7](https://github.com/RTKConsortium/RTK/commit/37b2cee7))
- Fix Cuda [[nodiscard]] warnings of Image "Transform" functions ([ab08d7a6](https://github.com/RTKConsortium/RTK/commit/ab08d7a6))

#### Bug Fixes

- Fix ITKPythonPackage git tag in Python CUDA action ([02005d75](https://github.com/RTKConsortium/RTK/commit/02005d75))

#### Style Changes

- Rename non-templated types from T* to *Type ([c4882b88](https://github.com/RTKConsortium/RTK/commit/c4882b88))
- Rename template parameter values ([e1484a09](https://github.com/RTKConsortium/RTK/commit/e1484a09))
- Remove traces of CG cost function calculation ([a7e0f2df](https://github.com/RTKConsortium/RTK/commit/a7e0f2df))



## Shape:
### Matt McCormick (1):

#### Enhancements

- Bump CI and Python package for ITK 5.3.0 ([0c8b94e](https://github.com/SlicerSALT/ITKShape/commit/0c8b94e))


### Tom Birdsong (1):

#### Enhancements

- Bump ITK to v5.3rc04.post3 with reusable workflow ([a9ba859](https://github.com/SlicerSALT/ITKShape/commit/a9ba859))



## SimpleITKFilters:
### Bradley Lowekamp (3):

#### Miscellaneous Changes

- Update GHA from template for ITK 5.3.0 ([04c3f48](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/04c3f48))
- Wrap DICOMOrientation ([0557b25](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/0557b25))
- Update to version 1.0 ([9926e46](https://github.com/InsightSoftwareConsortium/ITKSimpleITKFilters/commit/9926e46))



## SplitComponents:
### Tom Birdsong (16):

#### Enhancements

- Update Linux CI OS version ([6173045](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/6173045))
- Replace cxx CI steps with composite action ([a715438](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/a715438))
- Update macos version in CI ([430301b](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/430301b))
- Bump to ITK v5.3rc04.post3 ([f37cc13](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/f37cc13))
- Update tarball list for Python CI ([4ab0a64](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/4ab0a64))
- Use reusable ITK CI workflow ([869eceb](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/869eceb))
- Bump ITK workflows to v5.3rc04.post4 ([58428c5](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/58428c5))
- Bump for v5.3 release ([ac1b3da](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/ac1b3da))
- Apply ITK CI workflow updates ([ef7a950](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/ef7a950))
- Bump ITKPythonPackage tag ([e126069](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/e126069))
- Build only required ITK modules for testing ([0e6214b](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/0e6214b))
- Add CI Linux ARM build and notebook checks ([9d1565d](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/9d1565d))
- Bump reusable workflow for wheel validation ([343a9ef](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/343a9ef))

#### Bug Fixes

- Update example notebook from python2 to python3 kernel ([67237cd](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/67237cd))
- Address Python notebook test failures ([04710af](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/04710af))
- Resolve CMP135 Warning ([981b099](https://github.com/InsightSoftwareConsortium/ITKSplitComponents/commit/981b099))



## Strain:
### Tom Birdsong (3):

#### Enhancements

- Bump ITK to v5.3rc04.post3 ([59cb2b4](https://github.com/KitwareMedical/ITKStrain/commit/59cb2b4))
- Bump for ITK v5.3rc04.post4 ([d6af2c5](https://github.com/KitwareMedical/ITKStrain/commit/d6af2c5))
- Bump for ITK v5.3 ([8666068](https://github.com/KitwareMedical/ITKStrain/commit/8666068))



## TextureFeatures:
### Jon Haitz Legarreta Gorroño (1):

#### Platform Fixes

- Match CMake minimum required version to ITK's ([867bbc6](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/867bbc6))


### Matt McCormick (2):

#### Enhancements

- Update CI configuration to 5.3.0 latest ([e20b8f0](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/e20b8f0))
- Bump Python package version to 3.6.0 ([d3e5d1c](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/d3e5d1c))


### Pranjal Sahu (1):

#### Enhancements

- Remove unused FixedArray wrapping ([0823b10](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/0823b10))


### Tom Birdsong (1):

#### Enhancements

- Bump to ITK v5.3rc04.post3 with reusable workflow ([015ff58](https://github.com/InsightSoftwareConsortium/ITKTextureFeatures/commit/015ff58))



## Thickness3D:
### Matt McCormick (1):

#### Enhancements

- Update CI for ITK 5.3.0 ([944886a](https://github.com/InsightSoftwareConsortium/ITKThickness3D/commit/944886a))



## Ultrasound:
### Dženan Zukić (10):

#### Enhancements

- Add BackscatterImageFilter with Python wrapping ([d8e02b2](https://github.com/KitwareMedical/ITKUltrasound/commit/d8e02b2))
- Use tighter tolerances for C++ attenuation tests ([b8c81da](https://github.com/KitwareMedical/ITKUltrasound/commit/b8c81da))
- Make the output mask of AttenuationImageFilter a normal output ([39fd2d5](https://github.com/KitwareMedical/ITKUltrasound/commit/39fd2d5))
- Add a Python test for AttenuationImageFilter ([b5ecbc5](https://github.com/KitwareMedical/ITKUltrasound/commit/b5ecbc5))
- Wrap ResampleFilter for 3D CurvilinearArraySpecialCoordinatesImage ([cff669e](https://github.com/KitwareMedical/ITKUltrasound/commit/cff669e))
- Add quantitative regression test for Python curvilinear resampling ([86aff35](https://github.com/KitwareMedical/ITKUltrasound/commit/86aff35))

#### Platform Fixes

- Use more performant variants of transform physical point methods ([aeb838b](https://github.com/KitwareMedical/ITKUltrasound/commit/aeb838b))

#### Style Changes

- make the Python test documentation more consistent ([07f3e41](https://github.com/KitwareMedical/ITKUltrasound/commit/07f3e41))
- Baseline image is the first parameter in regression comparison ([43b5123](https://github.com/KitwareMedical/ITKUltrasound/commit/43b5123))
- Use ITK_DISALLOW_COPY_AND_MOVE instead deleted private members ([9acfc48](https://github.com/KitwareMedical/ITKUltrasound/commit/9acfc48))


### Tom Birdsong (9):

#### Enhancements

- Bump ITK to v5.3rc04.post3 ([269d8cc](https://github.com/KitwareMedical/ITKUltrasound/commit/269d8cc))
- Bump version to 0.5.9 ([13d57e2](https://github.com/KitwareMedical/ITKUltrasound/commit/13d57e2))
- Bump for ITK v5.3.0 ([0ff2216](https://github.com/KitwareMedical/ITKUltrasound/commit/0ff2216))
- Bump notebook workflow ([88f79b5](https://github.com/KitwareMedical/ITKUltrasound/commit/88f79b5))
- Use ITK reusable workflow ([38280fc](https://github.com/KitwareMedical/ITKUltrasound/commit/38280fc))
- Update ITK CI reusable workflow ([ca760c8](https://github.com/KitwareMedical/ITKUltrasound/commit/ca760c8))

#### Platform Fixes

- Ignore `SliceSeriesSpecialCoordinatesImage` warning ([568fc49](https://github.com/KitwareMedical/ITKUltrasound/commit/568fc49))

#### Bug Fixes

- Fix `install_requires` list in `setup.py` ([1e8a1f1](https://github.com/KitwareMedical/ITKUltrasound/commit/1e8a1f1))
- Update SpectralDistributions example for itkwidgets 0.21a ([128e4f0](https://github.com/KitwareMedical/ITKUltrasound/commit/128e4f0))



## VkFFTBackend:
### Lee Newberg (1):

#### Enhancements

- Versions as strings, not numbers, so that 3.1 != 3.10, etc. ([a4d0860](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/a4d0860))


### Tom Birdsong (8):

#### Enhancements

- Update AWS EC2 GPU AMI tag ([900f0db](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/900f0db))
- Bump ITK version to v5.3rc04.post2 ([1d4b375](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/1d4b375))
- Bump to v5.3rc04.post3 ([4c968f1](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/4c968f1))
- Support ITK tarball specializations in linux build ([eae3ddd](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/eae3ddd))
- Bump VkFFT to v1.2.31 ([933862b](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/933862b))
- Bump for ITK v5.3.0 ([31a1921](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/31a1921))

#### Platform Fixes

- Ignore VkFFT benchmark compiler warning ([ed3c449](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/ed3c449))
- Use VkFFT as a header-only library ([9a1f6c3](https://github.com/InsightSoftwareConsortium/ITKVkFFTBackend/commit/9a1f6c3))



## WebAssemblyInterface:
### Dženan Zukić (5):

#### Miscellaneous Changes

- docs(examples): remove manual line breaks from examples/index.md ([3697feaf](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/3697feaf))
- docs: remove manual line breaks in itk_js_to_itk_wasm_migration_guide.md ([7523fdff](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7523fdff))
- docs: typo fixes in itk_js_to_itk_wasm_migration_guide.md ([95d8324a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/95d8324a))
- docs(HelloWorldExample): More direct link to Git repository ([0741bf34](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0741bf34))
- docs(HelloWorldExample): HTML file should be named index.html ([10e91189](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/10e91189))


### Federico Zivolo (2):

#### Miscellaneous Changes

- feat: expose version ([c51dcf53](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c51dcf53))
- fix: import ([3e6d0a79](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/3e6d0a79))


### Matt McCormick (380):

#### Miscellaneous Changes

- style(ViteExample): Add textarea styling for readability ([ef41550e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/ef41550e))
- build(DynamicImports): Add @vite-ignore ([f32fccf3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f32fccf3))
- chore(ViteExample): Bump to Vite 3 ([320fe99e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/320fe99e))
- feat(Pipeline): Add interface_json() ([24bbeb77](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/24bbeb77))
- style(Pipelines): Use dash delimited names for name and positional args ([df5aa7f2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/df5aa7f2))
- fix(runPipelineEmscripten): Copy args before passing to callMain ([6f0a85f2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6f0a85f2))
- feat(itk-wasm-cli): Update default Docker image for kebab modules ([c6182e52](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c6182e52))
- docs(hello-pipeline,inputs-outputs): Update for pipeline name, type_name ([7c64db46](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7c64db46))
- feat(structured-report-to-text): Initial pipeline addition ([b961063d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b961063d))
- feat(itk-wasm-cli): Update default Docker image for Pipeline updates ([145308d3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/145308d3))
- build(publish): Update test pipeline path for prepublish cleanup ([19cf4434](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/19cf4434))
- ci(repository-url): Remove git+ protocol prefix ([07ce28a2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/07ce28a2))
- fix(package.json): Remove git+ protocol from repository url's ([e617cf21](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e617cf21))
- feat(itk-dicom): Browser package configuration ([6cc2574c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6cc2574c))
- style(camelCase): Provide return type ([559c398f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/559c398f))
- build(ExportMap): Add "default" entry ([bf806c5f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/bf806c5f))
- feat(itk-wasm-cli): Update default Docker image for 1.0.0-b.7 ([84fb14be](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/84fb14be))
- feat(version): Bump version to 1.0.0-b.7 ([91e1f6eb](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/91e1f6eb))
- feat(itk-dicom): Node.js bundling and interface ([3e5feb18](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/3e5feb18))
- test(XState): Vendor for testing offline ([da81c204](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/da81c204))
- build(prepublishOnly): Do not remove dist/pipelines/*Test* ([85815250](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/85815250))
- style(python): Move itkwasm package into its own directory ([00a8fe0b](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/00a8fe0b))
- ci(Python): Update Hosted Runner versions ([f9bf19a2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f9bf19a2))
- build(Python): Migrate packager from flit to hatch ([e5fec054](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e5fec054))
- feat(python): Execute with stdout / stderr ([29318f6c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/29318f6c))
- build(itk-dicom): Bump itk-dicom to required version ([1f60b18a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1f60b18a))
- docs(dicom): Add options to demo app ([f5650ff3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f5650ff3))
- style(dicom-demo): Use spectrum-web-components ([e3857b12](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e3857b12))
- fix(bindings): Pass pipeline path for generation ([e8cf50cf](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e8cf50cf))
- fix(runPipelineEmscript): Lower mesh cellData ([50185ca5](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/50185ca5))
- docs(Hacking): Document creating a debug build ([5b1fdf65](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/5b1fdf65))
- docs(Hacking): Add welcome message, semantic-release link ([ff26ca1d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/ff26ca1d))
- docs(debugging): Fix links ([81c621f2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/81c621f2))
- docs(hacking_itk_wasm): Fix debugging example link ([b4f70c2c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b4f70c2c))
- refactor(itk-wasm-cli): Rename bindings subcommand to bindgen ([501e4166](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/501e4166))
- chore(itk-dicom): Bump version to 0.1.0 ([b77a743c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b77a743c))
- fix(itkConfig.ts): Import from './browser/index.js' ([f6a125de](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f6a125de))
- feat(WASI): Support itk_wasm_delayed_start ([a4609a6e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/a4609a6e))
- ci(Firefox): Disable until issues with FF 105 addressed: ([1afd9886](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1afd9886))
- ci(update-versions): Run during verifyReleaseCmd ([d0defca5](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d0defca5))
- docs(ViteExample): Bump to 1.0.0-b.37 ([2f25c583](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/2f25c583))
- feat(itk-wasm-cli): Update default Docker image for 1.0.0-b.38 ([a6af973a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/a6af973a))
- chore: Bump itk-dicom version to 0.2.0 ([4f2056ec](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4f2056ec))
- fix: Run update-versions during prepublishOnly npm step ([8717d055](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/8717d055))
- feat(Python): Support pipeline stream inputs/outputs ([837876ac](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/837876ac))
- chore(Dependencies): Bump Cypress to 10.10.0 ([4ce2d9f3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4ce2d9f3))
- test(runPipeline): Migrate from Karma to Cypress ([a408e7c8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/a408e7c8))
- feat(itkConfig): Support dynamic runtime specification for browser ([a461426c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/a461426c))
- style(runPipelineNode): loadEmscriptenModuleNode consistent with export ([e36ba4f2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e36ba4f2))
- feat: Python File interface types support ([b9509ba9](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b9509ba9))
- fix(io-packages): Update with main package semantic-release version ([6e62ba79](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6e62ba79))
- feat(SupportInputImageTypes): Support VectorImage as template specialization ([0ec818e2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0ec818e2))
- feat(castImage): Function to cast to pixelType, componentType ([52500fef](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/52500fef))
- feat(itk-wasm-cli): Update default Docker image for 20221101-a2f1bdfa ([2a0cd0f7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/2a0cd0f7))
- docs(RELEASE): Remove components automated by semantic-release ([74b75db8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/74b75db8))
- feat(itk-wasm-cli): Update default Docker image for 20221101-1b7430cf ([b877b784](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/b877b784))
- build: Remove SupportInputImageTypesNoVectorImage ([1ada4361](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1ada4361))
- feat(itk-wasm-cli): Update default Docker image for 20221101-8f65383f ([bf965dd7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/bf965dd7))
- docs(Docker): Move release documentation into src/docker ([be9ffc83](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/be9ffc83))
- build: Export cpp-base64 from WebAssemblyInterface ([7cc7cfa2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7cc7cfa2))
- ci(testing-data): Remove Pinata pinning ([1e3e0835](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1e3e0835))
- refactor: Updates for master to main branch rename ([770d853a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/770d853a))
- ci: Remove unused Azure Pipelines config ([075eb0bf](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/075eb0bf))
- test: Update released data resources ([6e0d4c17](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6e0d4c17))
- test: Retrieve released data from Kitware's Apache server ([09c335b3](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/09c335b3))
- feat(readImageLocalFile): Support casting options ([149721db](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/149721db))
- feat(readImageArrayBuffer): Support componentType, pixelType options ([6d1c20ac](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6d1c20ac))
- feat(readImageBlob): Add pixelType, componentType options ([9b8c32a2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9b8c32a2))
- feat(readImageDICOMArrayBufferSeries): Add componentType, pixelType options ([54deca39](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/54deca39))
- style: ts-standard updates ([94460b73](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/94460b73))
- feat(readImageFileSeries): Support componentType, pixelType ([d42fbc12](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d42fbc12))
- feat(readImageDICOMFileSeries): Support componentType, pixelType options ([5e5d1423](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/5e5d1423))
- feat(readImageFile): Support componentType, pixelType ([9ac40b94](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9ac40b94))
- feat(readImageLocalDICOMFileSeries): Support componentType, pixelType ([0a61e48c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0a61e48c))
- feat(writeImageArrayBuffer): Support componentType, pixelType ([2b50d9c8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/2b50d9c8))
- feat(writeImageLocalFile): Support componentType, pixelType ([23eca873](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/23eca873))
- build: Update ExternalData.cmake for w3s.link gateway output ([08ead980](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/08ead980))
- docs: Document how to add new testing data ([6970f542](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/6970f542))
- feat(Image): use Map for metadata member ([f9ac56ec](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f9ac56ec))
- feat(Image): support metadata serialization ([282db1b8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/282db1b8))
- feat(itk-wasm-cli): Update default Docker image for 20221114-8659b8cc ([7af2985c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/7af2985c))
- docs(docker-release): Note checking out a new branch ([1e4a827d](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1e4a827d))
- docs: Add BREAKING_CHANGES.md to track beta breaking changes ([c9ffa2b1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c9ffa2b1))
- feat(Python): Add IO wrapping ([a0e6705f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/a0e6705f))
- build(Python): Add setup.py ([0183eb00](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0183eb00))
- ci(GitHubActions): Add C++, Python package builds ([75e8337a](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/75e8337a))
- ci(GitHubActions): Migrate to remote module reusable action ([1b6926c1](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1b6926c1))
- build(Windows): Use C++20 standard ([f367476c](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f367476c))
- build(libcbor): Bump to latest master ([f023f0f8](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/f023f0f8))
- build(Windows): Replace std::atol with std::strtoull ([93b8a7b2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/93b8a7b2))
- build(GCC): Address operator | warning ([9234e1a5](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/9234e1a5))
- build(macos): Use C++17 ([76168258](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/76168258))
- build(SharedLibs): Add missing export specification, linkage ([ddc60684](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/ddc60684))
- build(Windows): Simplify cbor pair initialization ([0c62f22f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/0c62f22f))
- docs(NativePythonPackage): Improve long description ([06916b20](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/06916b20))
- test(C++): Disable itkPipelineTest in CI ([8e8d08ca](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/8e8d08ca))
- feat(ITK): Bump to 2022-12-21 master ([d37dad3f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/d37dad3f))
- feat(itk-wasm-cli): Update default Docker image for 20221222-d37dad3f ([79b57308](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/79b57308))
- ci(NativePython): Fix wheel uploads ([1fa7dbd7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1fa7dbd7))
- build(PythonPackages): Enable CMAKE_POSITION_INDEPENDENT_CODE ([c4fe6221](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c4fe6221))
- docs(Badges): Fix C++ / Native Python link ([c02db3db](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/c02db3db))
- chore(HelloWorldExample): Bump dependencies to latest ([859ad9cb](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/859ad9cb))
- refactor(HelloWorldExample): Run example on port 8083 ([e3bc54ac](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/e3bc54ac))
- docs(HelloWorldExample): WASM -> Wasm ([4759d243](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4759d243))
- docs(HelloWorld): Updates and improvements for 1.0.0-b.53 ([49d8cf99](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/49d8cf99))
- docs(HelloWorld): Update screenshot ([3e646d8f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/3e646d8f))
- ci(HelloWorld): Bump actions to latest ([4afb68f7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/4afb68f7))
- ci(HelloWorldExample): Update emscripten-build artifact directory ([ed0754b7](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/ed0754b7))
- ci(Python): Add native ARM wheel support ([1444f69e](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1444f69e))
- feat(runPipeline): Support passing pipelineBaseUrl directly ([2a65e196](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/2a65e196))
- fix(runPipeline): Support URL pipelineBaseUrl ([af20cd98](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/af20cd98))
- fix(createWebWorkerPromise): Move up one directory ([1ed0b88f](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/1ed0b88f))
- build(toolchains): Bump to wasi-sdk-19, emscripten latest release ([fcc852e2](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/fcc852e2))
- feat(itk-wasm-cli): Update default Docker image for 20230116-fcc852e2 ([358f42bc](https://github.com/InsightSoftwareConsortium/itk-wasm/commit/358f42bc))
- [...]
