package u64

// LeBytes returns a byte slice corresponding to the 8 bytes in the uint64 in little-endian byte order.
func LeBytes(v uint64) []byte {
	return []byte{
		byte(v),
		byte(v >> 8),
		byte(v >> 16),
		byte(v >> 24),
		byte(v >> 32),
		byte(v >> 40),
		byte(v >> 48),
		byte(v >> 56),
	}
}
