+++
title = "htmx 2.0.0-alpha2 has been released!"
date = 2024-02-09
[taxonomies]
tag = ["posts", "announcements"]
+++

## htmx 2.0.0-alpha2 Release

I'm happy to announce the second alpha release of htmx 2.0

This is an _alpha_ release and should NOT be considered ready for production.  We are releasing it to begin testing
the code against real world scenarios to figure out what is broken and what needs improvement.

If you are able to do so, please switch to the release and do a quick run through any htmx-powered functionality you
have and let us know if there are issues.

Of particular concern to us are the following changes:

* We removed the deprecated `hx-sse` and `hx-ws` attributes in favor of the extensions (which are available in 1.x)
* `DELETE` requests now use parameters, rather than form encoded bodies, for their payload (This is in accordance w/ the spec.)

A complete upgrade guide can be found here:

[htmx 1.x -> 2.x Migration Guide](@/migration-guide-htmx-1.md)

Note that htmx 2.x will no longer be IE compatible, but 1.x will continue to be supported for IE users.

### Installing

The alpha can be installed via a package manager referencing version `2.0.0-alpha2`, or can be linked via a CDN:

```html
<script src="https://unpkg.com/htmx.org@2.0.0-alpha2/dist/htmx.min.js"></script>
```

or <a href="https://unpkg.com/htmx.org@2.0.0-alpha1/dist/htmx.min.js" download>Downloaded</a>

### Extensions

Extensions have been removed from the main codebase and are now in this github repo:

<https://github.com/bigskysoftware/htmx-extensions/tree/main/ext>

They will eventually be available at <https://extensions.htmx.org> and in NPM but for now must be linked from the
github repo.

There was one breaking change in the extensions, SSE, so you must use the newer version of that extension:

https://github.com/bigskysoftware/htmx-extensions/blob/main/ext/sse.js

### New Features

* No new features, in fact we took one out: we reverted `head` tag processing, we have decided that that is better handled as an extension
  because it's a little too magic for the core
