#define XERR "memoryaccess"
#include "memoryaccess.ih"

    // by cptsizes.cc

    // each segment is .5 GB large, 10 segments can be
    // used before extend is called.

// static
void MemoryAccess::gigaBytes(size_t *nBlocks, size_t *blockSize, 
                             size_t factor) 
{
                                                    // #pages per .5 GB
    size_t pphgb = divPlus(1024 * 1024 * 1024 / 2, s_pageSize);  

    *blockSize = pphgb * s_pageSize;        // segm. size .5 GB

    *nBlocks = max(s_minimum,               // #potentially avail. segments
                   divPlus(factor * 1024 * 1024 * 1024, *blockSize));
}
