/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.image.readers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import org.sunflow.image.Bitmap;
import org.sunflow.image.BitmapReader;
import org.sunflow.image.formats.BitmapXYZ;

public class IGIBitmapReader
implements BitmapReader {
    public Bitmap load(String string, boolean bl) throws IOException, BitmapReader.BitmapFormatException {
        int n;
        InputStream inputStream;
        try {
            JarURLConnection jarURLConnection;
            URL uRL;
            URLConnection uRLConnection = new URL(string).openConnection();
            if (uRLConnection instanceof JarURLConnection && (uRL = (jarURLConnection = (JarURLConnection)uRLConnection).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
                try {
                    if (new File(uRL.toURI()).canWrite()) {
                        uRLConnection.setUseCaches(false);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IOException(uRISyntaxException);
                }
            }
            inputStream = uRLConnection.getInputStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        inputStream = new BufferedInputStream(inputStream);
        int n2 = IGIBitmapReader.read32i(inputStream);
        int n3 = IGIBitmapReader.read32i(inputStream);
        inputStream.skip(8L);
        int n4 = IGIBitmapReader.read32i(inputStream);
        int n5 = IGIBitmapReader.read32i(inputStream);
        int n6 = IGIBitmapReader.read32i(inputStream);
        int n7 = IGIBitmapReader.read32i(inputStream);
        int n8 = IGIBitmapReader.read32i(inputStream);
        int n9 = IGIBitmapReader.read32i(inputStream);
        inputStream.skip(5000L);
        if (n2 != 66613373) {
            throw new BitmapReader.BitmapFormatException("wrong magic: " + n2);
        }
        if (n3 != 1) {
            throw new BitmapReader.BitmapFormatException("unsupported version: " + n3);
        }
        if (n7 != 0) {
            throw new BitmapReader.BitmapFormatException("unsupported compression: " + n7);
        }
        if (n9 != 0) {
            throw new BitmapReader.BitmapFormatException("unsupported color space: " + n9);
        }
        if (n8 != n4 * n5 * 12) {
            throw new BitmapReader.BitmapFormatException("invalid data block size: " + n8);
        }
        if (n4 <= 0 || n5 <= 0) {
            throw new BitmapReader.BitmapFormatException("invalid image size: " + n4 + "x" + n5);
        }
        if (n6 <= 0) {
            throw new BitmapReader.BitmapFormatException("invalid super sample factor: " + n6);
        }
        if (n4 % n6 != 0 || n5 % n6 != 0) {
            throw new BitmapReader.BitmapFormatException("invalid image size: " + n4 + "x" + n5);
        }
        float[] fArray = new float[n4 * n5 * 3];
        int n10 = 0;
        int n11 = 3 * (n5 - 1) * n4;
        while (n10 < n5) {
            n = 0;
            while (n < n4) {
                fArray[n11 + 0] = IGIBitmapReader.read32f(inputStream);
                fArray[n11 + 1] = IGIBitmapReader.read32f(inputStream);
                fArray[n11 + 2] = IGIBitmapReader.read32f(inputStream);
                ++n;
                n11 += 3;
            }
            ++n10;
            n11 -= 6 * n4;
        }
        inputStream.close();
        if (n6 > 1) {
            float[] fArray2 = new float[fArray.length / (n6 * n6)];
            float f = 1.0f / (float)(n6 * n6);
            int n12 = 0;
            for (n = 0; n < n5; n += n6) {
                int n13 = 0;
                while (n13 < n4) {
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    float f4 = 0.0f;
                    for (int i = 0; i < n6; ++i) {
                        for (int j = 0; j < n6; ++j) {
                            int n14 = 3 * (n13 + j + (n + i) * n4);
                            f2 += fArray[n14 + 0];
                            f3 += fArray[n14 + 1];
                            f4 += fArray[n14 + 2];
                        }
                    }
                    fArray2[n12 + 0] = f2 * f;
                    fArray2[n12 + 1] = f3 * f;
                    fArray2[n12 + 2] = f4 * f;
                    n13 += n6;
                    n12 += 3;
                }
            }
            return new BitmapXYZ(n4 / n6, n5 / n6, fArray2);
        }
        return new BitmapXYZ(n4, n5, fArray);
    }

    private static final int read32i(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        n |= inputStream.read() << 8;
        n |= inputStream.read() << 16;
        return n |= inputStream.read() << 24;
    }

    private static final float read32f(InputStream inputStream) throws IOException {
        return Float.intBitsToFloat(IGIBitmapReader.read32i(inputStream));
    }
}

