/*
 * Decompiled with CFR 0.152.
 */
package org.sunflow.core;

import org.sunflow.PluginRegistry;
import org.sunflow.core.CausticPhotonMapInterface;
import org.sunflow.core.GIEngine;
import org.sunflow.core.IntersectionState;
import org.sunflow.core.LightSource;
import org.sunflow.core.Options;
import org.sunflow.core.PhotonStore;
import org.sunflow.core.Ray;
import org.sunflow.core.Scene;
import org.sunflow.core.Shader;
import org.sunflow.core.ShadingCache;
import org.sunflow.core.ShadingState;
import org.sunflow.image.Color;
import org.sunflow.math.Point3;
import org.sunflow.math.QMC;
import org.sunflow.math.Vector3;
import org.sunflow.system.Timer;
import org.sunflow.system.UI;

class LightServer {
    private Scene scene;
    LightSource[] lights;
    private Shader shaderOverride;
    private boolean shaderOverridePhotons;
    private int maxDiffuseDepth;
    private int maxReflectionDepth;
    private int maxRefractionDepth;
    private int maxTransparencyDepth;
    private CausticPhotonMapInterface causticPhotonMap;
    private GIEngine giEngine;
    private int photonCounter;

    LightServer(Scene scene) {
        this.scene = scene;
        this.lights = new LightSource[0];
        this.causticPhotonMap = null;
        this.shaderOverride = null;
        this.shaderOverridePhotons = false;
        this.maxDiffuseDepth = 1;
        this.maxReflectionDepth = 4;
        this.maxRefractionDepth = 4;
        this.maxTransparencyDepth = 4;
        this.causticPhotonMap = null;
        this.giEngine = null;
    }

    void setLights(LightSource[] lightSourceArray) {
        this.lights = lightSourceArray;
    }

    Scene getScene() {
        return this.scene;
    }

    void setShaderOverride(Shader shader, boolean bl) {
        this.shaderOverride = shader;
        this.shaderOverridePhotons = bl;
    }

    boolean build(Options options) {
        this.maxDiffuseDepth = options.getInt("depths.diffuse", this.maxDiffuseDepth);
        this.maxReflectionDepth = options.getInt("depths.reflection", this.maxReflectionDepth);
        this.maxRefractionDepth = options.getInt("depths.refraction", this.maxRefractionDepth);
        this.maxTransparencyDepth = options.getInt("depths.transparency", this.maxTransparencyDepth);
        String string = options.getString("gi.engine", null);
        this.giEngine = PluginRegistry.giEnginePlugins.createObject(string);
        String string2 = options.getString("caustics", null);
        this.causticPhotonMap = PluginRegistry.causticPhotonMapPlugins.createObject(string2);
        this.maxDiffuseDepth = Math.max(0, this.maxDiffuseDepth);
        this.maxReflectionDepth = Math.max(0, this.maxReflectionDepth);
        this.maxRefractionDepth = Math.max(0, this.maxRefractionDepth);
        Timer timer = new Timer();
        timer.start();
        int n = 0;
        for (int i = 0; i < this.lights.length; ++i) {
            n += this.lights[i].getNumSamples();
        }
        if (this.giEngine != null && !this.giEngine.init(options, this.scene)) {
            return false;
        }
        if (!this.calculatePhotons(this.causticPhotonMap, "caustic", 0, options)) {
            return false;
        }
        timer.end();
        UI.printInfo(UI.Module.LIGHT, "Light Server stats:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "  * Light sources found: %d", this.lights.length);
        UI.printInfo(UI.Module.LIGHT, "  * Light samples:       %d", n);
        UI.printInfo(UI.Module.LIGHT, "  * Max raytrace depth:", new Object[0]);
        UI.printInfo(UI.Module.LIGHT, "      - Diffuse          %d", this.maxDiffuseDepth);
        UI.printInfo(UI.Module.LIGHT, "      - Reflection       %d", this.maxReflectionDepth);
        UI.printInfo(UI.Module.LIGHT, "      - Refraction       %d", this.maxRefractionDepth);
        UI.printInfo(UI.Module.LIGHT, "  * GI engine            %s", string == null ? "none" : string);
        UI.printInfo(UI.Module.LIGHT, "  * Caustics:            %s", string2 == null ? "none" : string2);
        UI.printInfo(UI.Module.LIGHT, "  * Shader override:     %b", this.shaderOverride);
        UI.printInfo(UI.Module.LIGHT, "  * Photon override:     %b", this.shaderOverridePhotons);
        UI.printInfo(UI.Module.LIGHT, "  * Build time:          %s", timer.toString());
        return true;
    }

    void showStats() {
    }

    boolean calculatePhotons(final PhotonStore photonStore, String string, final int n, Options options) {
        int n2;
        int n3;
        int n4;
        if (photonStore == null) {
            return true;
        }
        if (this.lights.length == 0) {
            UI.printError(UI.Module.LIGHT, "Unable to trace %s photons, no lights in scene", string);
            return false;
        }
        final float[] fArray = new float[this.lights.length];
        fArray[0] = this.lights[0].getPower();
        for (n4 = 1; n4 < this.lights.length; ++n4) {
            fArray[n4] = fArray[n4 - 1] + this.lights[n4].getPower();
        }
        UI.printInfo(UI.Module.LIGHT, "Tracing %s photons ...", string);
        photonStore.prepare(options, this.scene.getBounds());
        n4 = photonStore.numEmit();
        if (n4 <= 0 || fArray[fArray.length - 1] <= 0.0f) {
            UI.printError(UI.Module.LIGHT, "Photon mapping enabled, but no %s photons to emit", string);
            return false;
        }
        UI.taskStart("Tracing " + string + " photons", 0, n4);
        Thread[] threadArray = new Thread[this.scene.getThreads()];
        final float f = 1.0f / (float)n4;
        int n5 = n4 / threadArray.length;
        this.photonCounter = 0;
        Timer timer = new Timer();
        timer.start();
        for (n3 = 0; n3 < threadArray.length; ++n3) {
            n2 = n3;
            final int n6 = n2 * n5;
            final int n7 = n2 == threadArray.length - 1 ? n4 : (n2 + 1) * n5;
            threadArray[n3] = new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    IntersectionState intersectionState = new IntersectionState();
                    for (int i = n6; i < n7; ++i) {
                        int n3;
                        LightServer lightServer = LightServer.this;
                        synchronized (lightServer) {
                            UI.taskUpdate(LightServer.this.photonCounter);
                            LightServer.this.photonCounter++;
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                        }
                        int n2 = i + n;
                        double d = QMC.halton(0, n2) * (double)fArray[fArray.length - 1];
                        for (n3 = 0; d >= (double)fArray[n3] && n3 < fArray.length; ++n3) {
                        }
                        if (n3 == fArray.length) continue;
                        double d2 = n3 == 0 ? d / (double)fArray[0] : (d - (double)fArray[n3]) / (double)(fArray[n3] - fArray[n3 - 1]);
                        double d3 = QMC.halton(1, n2);
                        double d4 = QMC.halton(2, n2);
                        double d5 = QMC.halton(3, n2);
                        Point3 point3 = new Point3();
                        Vector3 vector3 = new Vector3();
                        Color color = new Color();
                        LightServer.this.lights[n3].getPhoton(d2, d3, d4, d5, point3, vector3, color);
                        color.mul(f);
                        Ray ray = new Ray(point3, vector3);
                        LightServer.this.scene.trace(ray, intersectionState);
                        if (!intersectionState.hit()) continue;
                        LightServer.this.shadePhoton(ShadingState.createPhotonState(ray, intersectionState, n2, photonStore, LightServer.this), color);
                    }
                }
            });
            threadArray[n3].setPriority(this.scene.getThreadPriority());
            threadArray[n3].start();
        }
        try {
            for (n3 = 0; n3 < threadArray.length; ++n3) {
                threadArray[n3].join();
            }
        }
        catch (InterruptedException interruptedException) {
            for (n2 = 0; n2 < threadArray.length; ++n2) {
                threadArray[n2].interrupt();
            }
            UI.printError(UI.Module.BCKT, "Photon thread was interrupted", new Object[0]);
            return false;
        }
        timer.end();
        UI.taskStop();
        UI.printInfo(UI.Module.LIGHT, "Tracing time for %s photons: %s", string, timer.toString());
        photonStore.init();
        return true;
    }

    void shadePhoton(ShadingState shadingState, Color color) {
        shadingState.getInstance().prepareShadingState(shadingState);
        Shader shader = this.getPhotonShader(shadingState);
        if (shader != null) {
            shader.scatterPhoton(shadingState, color);
        }
    }

    void traceDiffusePhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createDiffuseBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    void traceReflectionPhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createReflectionBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    void traceRefractionPhoton(ShadingState shadingState, Ray ray, Color color) {
        if (shadingState.getRefractionDepth() >= this.maxRefractionDepth) {
            return;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        if (shadingState.getIntersectionState().hit()) {
            ShadingState shadingState2 = ShadingState.createRefractionBounceState(shadingState, ray, 0);
            this.shadePhoton(shadingState2, color);
        }
    }

    private Shader getShader(ShadingState shadingState) {
        return this.shaderOverride != null ? this.shaderOverride : shadingState.getShader();
    }

    private Shader getPhotonShader(ShadingState shadingState) {
        return this.shaderOverride != null && this.shaderOverridePhotons ? this.shaderOverride : shadingState.getShader();
    }

    ShadingState getRadiance(float f, float f2, float f3, int n, int n2, Ray ray, IntersectionState intersectionState, ShadingCache shadingCache) {
        intersectionState.time = f3;
        this.scene.trace(ray, intersectionState);
        if (intersectionState.hit()) {
            Color color;
            ShadingState shadingState = ShadingState.createState(intersectionState, f, f2, f3, ray, n, n2, this);
            shadingState.getInstance().prepareShadingState(shadingState);
            Shader shader = this.getShader(shadingState);
            if (shader == null) {
                shadingState.setResult(Color.BLACK);
                return shadingState;
            }
            if (shadingCache != null && (color = shadingCache.lookup(shadingState, shader)) != null) {
                shadingState.setResult(color);
                return shadingState;
            }
            shadingState.setResult(shader.getRadiance(shadingState));
            if (shadingCache != null) {
                shadingCache.add(shadingState, shader, shadingState.getResult());
            }
            LightServer.checkNanInf(shadingState.getResult());
            return shadingState;
        }
        return null;
    }

    private static final void checkNanInf(Color color) {
        if (color.isNan()) {
            UI.printWarning(UI.Module.LIGHT, "NaN shading sample!", new Object[0]);
        } else if (color.isInf()) {
            UI.printWarning(UI.Module.LIGHT, "Inf shading sample!", new Object[0]);
        }
    }

    void shadeBakeResult(ShadingState shadingState) {
        Shader shader = this.getShader(shadingState);
        if (shader != null) {
            shadingState.setResult(shader.getRadiance(shadingState));
        } else {
            shadingState.setResult(Color.BLACK);
        }
    }

    Color shadeHit(ShadingState shadingState) {
        shadingState.getInstance().prepareShadingState(shadingState);
        Shader shader = this.getShader(shadingState);
        return shader != null ? shader.getRadiance(shadingState) : Color.BLACK;
    }

    Color traceGlossy(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        ++intersectionState.numGlossyRays;
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createGlossyBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    Color traceReflection(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getReflectionDepth() >= this.maxReflectionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        ++intersectionState.numReflectionRays;
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createReflectionBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    Color traceRefraction(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getRefractionDepth() >= this.maxRefractionDepth || shadingState.getDiffuseDepth() > 0) {
            return Color.BLACK;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        ++intersectionState.numRefractionRays;
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? this.shadeHit(ShadingState.createRefractionBounceState(shadingState, ray, n)) : Color.BLACK;
    }

    ShadingState traceFinalGather(ShadingState shadingState, Ray ray, int n) {
        if (shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return null;
        }
        IntersectionState intersectionState = shadingState.getIntersectionState();
        this.scene.trace(ray, intersectionState);
        return intersectionState.hit() ? ShadingState.createFinalGatherState(shadingState, ray, n) : null;
    }

    Color getGlobalRadiance(ShadingState shadingState) {
        if (this.giEngine == null) {
            return Color.BLACK;
        }
        return this.giEngine.getGlobalRadiance(shadingState);
    }

    Color getIrradiance(ShadingState shadingState, Color color) {
        if (this.giEngine == null || shadingState.getDiffuseDepth() >= this.maxDiffuseDepth) {
            return Color.BLACK;
        }
        return this.giEngine.getIrradiance(shadingState, color);
    }

    void initLightSamples(ShadingState shadingState) {
        for (LightSource lightSource : this.lights) {
            lightSource.getSamples(shadingState);
        }
    }

    void initCausticSamples(ShadingState shadingState) {
        if (this.causticPhotonMap != null) {
            this.causticPhotonMap.getSamples(shadingState);
        }
    }

    Color traceShadow(Ray ray, ShadingState shadingState) {
        float f = ray.getMax();
        this.scene.traceShadow(ray, shadingState.getIntersectionState());
        if (shadingState.getIntersectionState().hit()) {
            Shader shader = shadingState.getIntersectionState().instance.getShader(0);
            if (shader == null || shader.isOpaque() || shadingState.getShadowDepth() >= this.maxTransparencyDepth) {
                return Color.WHITE;
            }
            ShadingState shadingState2 = ShadingState.createShadowState(shadingState, ray);
            shadingState2.getInstance().prepareShadingState(shadingState2);
            Shader shader2 = this.getShader(shadingState2);
            if (shader2 == null || shader2.isOpaque()) {
                return Color.WHITE;
            }
            Color color = shader2.getOpacity(shadingState2);
            if (color.isWhite()) {
                return color;
            }
            return color.copy().madd(Color.sub(Color.WHITE, color), shadingState2.traceTransparentShadow(f));
        }
        return Color.BLACK;
    }
}

